/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.IInitDataInputAP;
import com.kingdee.eas.fi.ap.IInitDataInputAPentry;
import com.kingdee.eas.fi.ap.InitDataInputAPCollection;
import com.kingdee.eas.fi.ap.InitDataInputAPFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPInfo;
import com.kingdee.eas.fi.ap.InitDataInputAPentryFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPentryInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IInitDataInputAR;
import com.kingdee.eas.fi.ar.IInitDataInputARentry;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.ImpInitDataGLException;
import com.kingdee.eas.fi.ar.InitDataInputARCollection;
import com.kingdee.eas.fi.ar.InitDataInputARFactory;
import com.kingdee.eas.fi.ar.InitDataInputARInfo;
import com.kingdee.eas.fi.ar.InitDataInputARentryFactory;
import com.kingdee.eas.fi.ar.InitDataInputARentryInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractImpInitDataGLFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.IBillEntryBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ImpInitDataGLFacadeControllerBean
extends AbstractImpInitDataGLFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)ImpInitDataGLFacadeControllerBean.class.getName());
    protected static final String rt = " \r\n ";
    protected static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    public static final String REC_BILL_TYPE_101 = "101";
    public static final String REC_BILL_TYPE_103 = "103";
    public static final String PAY_BILL_TYPE_202 = "202";
    public static final String PAY_BILL_TYPE_204 = "204";
    private Locale L1 = ArApConstants.L1;
    private Locale L2 = ArApConstants.L2;
    private Locale L3 = ArApConstants.L3;

    private RowSet getAccountBalance(Context ctx, String companyID, int period, String accountID) throws BOSException {
        StringBuilder sb = new StringBuilder(300).append("select FOrgUnitID as FCompanyID, FAccountID, FCurrencyID,").append(rt);
        sb.append(" FBeginBalanceFor, FBeginBalanceLocal, FYearDebitFor, FYearDebitLocal, FYearCreditFor, FYearCreditLocal ").append(rt);
        sb.append(" from T_GL_AccountBalance_5F ").append(rt);
        sb.append("where  FOrgUnitID = '").append(companyID).append("'").append(rt);
        sb.append(" and FPeriod = ").append(period).append(rt);
        sb.append(" and FAccountID = '").append(accountID).append("'").append(rt);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private RowSet getAssistBalance(Context ctx, String companyID, int period, String accountID) throws BOSException {
        StringBuilder sb = new StringBuilder(300);
        sb.append("select t1.FOrgUnitID as FCompanyID, t1.FAccountID as FAccountID,").append(rt);
        sb.append("t1.FCurrencyID as FCurrencyID, t1.FAssistGrpID as FAssistGrpID,").append(rt);
        sb.append(" t1.FBeginBalanceFor as FBeginBalanceFor, t1.FBeginBalanceLocal as FBeginBalanceLocal, ").append(rt);
        sb.append(" t1.FYearDebitFor-t1.FDEBITFOR as FYearDebitFor,t1.FYearDebitLocal-t1.FDEBITLOCAL as FYearDebitLocal, ").append(rt);
        sb.append(" t1.FYearCreditFor-t1.FCREDITFOR as FYearCreditFor,t1.FYearCreditLocal-t1.FCREDITLOCAL as FYearCreditLocal ").append(rt);
        sb.append(" from T_GL_AssistBalance_5f t1 ");
        sb.append(" where t1.ForgUnitID = '").append(companyID).append("'").append(rt);
        sb.append(" and t1.FPeriod = ").append(period).append(rt);
        sb.append(" and t1.FAccountID = '").append(accountID).append("'").append(rt);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _ImportInitData(Context ctx, Map filter) throws BOSException, EASBizException {
        this._importInitBill(ctx, filter);
        String system = filter.get("system").toString();
        if ("AR".equalsIgnoreCase(system)) {
            this.importARInitData(ctx, filter);
        } else {
            this.importAPInitData(ctx, filter);
        }
    }

    private BigDecimal caluateExchageRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currency, Date billDate, BigDecimal beginBalanceFor, BigDecimal beginBalanceLocal, HashMap<BOSUuid, ExchangeRateInfo> currToRateMap) throws EASBizException, BOSException {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0) {
            int precision = 4;
            boolean isDirectExchange = true;
            if (currency != null) {
                ExchangeRateInfo rateInfo = null;
                if (null != currToRateMap) {
                    if (currToRateMap.containsKey(currency.getId())) {
                        rateInfo = currToRateMap.get(currency.getId());
                    } else {
                        rateInfo = BaseDataUtil.getExchangeRate(ctx, company, currency, billDate);
                        currToRateMap.put(currency.getId(), rateInfo);
                    }
                }
                if (rateInfo != null) {
                    precision = rateInfo.getPrecision();
                    if (rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
                        isDirectExchange = false;
                    }
                } else {
                    precision = currency.getPrecision();
                }
            }
            if (beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0 && beginBalanceFor.compareTo(BigDecimal.ZERO) != 0) {
                exchangeRate = isDirectExchange ? beginBalanceLocal.divide(beginBalanceFor, precision, 4).setScale(precision) : beginBalanceFor.divide(beginBalanceLocal, precision, 4).setScale(precision);
            }
        }
        return exchangeRate;
    }

    protected void checkImportFilter(Map filter) throws BOSException, EASBizException {
        boolean isCAA;
        if (filter.get("account") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_ACCOUNT);
        }
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        boolean bl = isCAA = accountViewInfo.getCAA() != null;
        if (isCAA) {
            if (filter.get("asstActType") == null) {
                throw new ImpInitDataGLException(ImpInitDataGLException.AP_NULLASSTACTTYPE);
            }
        } else if (filter.get("asstAct") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_ASSTACT);
        }
        if (filter.get("direction") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_DIRECTION);
        }
        if (filter.get("bizType") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_BIZ_TYPE);
        }
        if (filter.get("company") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_COMPANY);
        }
        if (filter.get("startPeriod") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_START_PERIOD);
        }
        if (filter.get("glCurrentPeriod") == null) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_GL_PERIOD);
        }
    }

    private void importAROtherBill(Context ctx, Map filter) throws BOSException, EASBizException {
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        boolean isCAA = accountViewInfo.getCAA() != null;
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        MaterialInfo material = (MaterialInfo)filter.get("material");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        ExpenseTypeInfo expenseitem = (ExpenseTypeInfo)filter.get("expenseitem");
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        this.removeLastImpBill(ctx, iOtherBill, company, bizType, accountViewInfo);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        this.removeLastImpBill(ctx, (IBillBase)iReceivingBill, company, null, accountViewInfo);
        try {
            RowSet rs = null;
            rs = isCAA ? this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString()) : this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
            AsstActTypeCollection assActTypeCol = null;
            if (rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
            CoreBaseCollection arOtherBillCol = new CoreBaseCollection();
            while (rs.next()) {
                OtherBillInfo otherBillInfo = new OtherBillInfo();
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"));
                if (beginBalanceLocal == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if (BalanceDirectionEnum.CREDIT.getValue() == accountViewInfo.getDC().getValue() || direction.getValue() != accountViewInfo.getDC().getValue()) {
                    beginBalanceFor = beginBalanceFor.negate();
                    beginBalanceLocal = beginBalanceLocal.negate();
                }
                otherBillInfo.setCompany(company);
                otherBillInfo.setReqCalculate4Srv(false);
                String number = BaseDataUtil.getNumberFromCodeRule(ctx, otherBillInfo);
                if (number == null) {
                    throw new ImpInitDataGLException(ImpInitDataGLException.AR_OTHERBILL_NO_NUMBER_RULE);
                }
                otherBillInfo.setNumber(number);
                otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
                otherBillInfo.setIsInTax(true);
                if (11 == bizType.getValue()) {
                    otherBillInfo.setIsPriceWithoutTax(false);
                } else {
                    otherBillInfo.setIsPriceWithoutTax(true);
                }
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                otherBillInfo.setBillDate(billDate);
                otherBillInfo.setIsInitializeBill(true);
                otherBillInfo.setBillType(this.getARBillType(bizType));
                otherBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
                otherBillInfo.setIsImpFromGL(true);
                otherBillInfo.setIsBizBill((Boolean)filter.get("isBizBill"));
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setAsstAct(ctx, asstActType, assistGrpID, otherBillInfo);
                    if (!"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        otherBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (!"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        otherBillInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    otherBillInfo.setAsstActType(asstActType);
                    if (asstAct != null) {
                        otherBillInfo.setAsstActID(asstAct.getId().toString());
                        otherBillInfo.setAsstActName(asstAct.getName(this.L1), this.L1);
                        otherBillInfo.setAsstActName(asstAct.getName(this.L2), this.L2);
                        otherBillInfo.setAsstActName(asstAct.getName(this.L3), this.L3);
                        otherBillInfo.setAsstActNumber(asstAct.getNumber());
                    }
                }
                String currencyID = rs.getString("FCurrencyID");
                CurrencyInfo currency = null;
                if (!StringUtils.isEmpty((String)currencyID)) {
                    if (!currencyMap.containsKey(currencyID)) {
                        currencyMap.put(currencyID, this.getCurrency(ctx, currencyID));
                    }
                    currency = (CurrencyInfo)currencyMap.get(currencyID);
                    otherBillInfo.setCurrency(currency);
                }
                BigDecimal exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                otherBillInfo.setExchangeRate(exchangeRate);
                otherBillInfo.setLastExhangeRate(exchangeRate);
                otherBillInfo.setBizDate(billDate);
                String paymentTypeID = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
                PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
                paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeID));
                otherBillInfo.setPaymentType(paymentTypeInfo);
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) < 0) {
                    otherBillInfo.setRedBlueType(true);
                } else {
                    otherBillInfo.setRedBlueType(false);
                }
                otherBillInfo.setAmount(beginBalanceFor);
                otherBillInfo.setAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillInfo.setTotalAmount(beginBalanceFor);
                otherBillInfo.setTotalTaxAmount(beginBalanceFor);
                otherBillInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillInfo.setUnVerifyAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                OtherBillentryInfo otherBillEntryInfo = new OtherBillentryInfo();
                otherBillEntryInfo.setSeq(1);
                if (bizType.getValue() == 2) {
                    if (material == null && isCAA) {
                        String assistGrpID = rs.getString("FAssistGrpID");
                        if (!materialMap.containsKey(assistGrpID)) {
                            material = this.getMaterial(ctx, assistGrpID);
                            materialMap.put(assistGrpID, material);
                        } else {
                            material = (MaterialInfo)materialMap.get(assistGrpID);
                        }
                    }
                    if (material != null) {
                        otherBillEntryInfo.setMaterial(material);
                        otherBillEntryInfo.setMaterialName(material.getName());
                        otherBillEntryInfo.setMeasureUnit(material.getBaseUnit());
                        otherBillEntryInfo.setBaseUnit(material.getBaseUnit());
                    }
                } else {
                    otherBillEntryInfo.setExpenseItem(expenseitem);
                }
                otherBillEntryInfo.setAccount(accountViewInfo);
                BigDecimal qty = new BigDecimal("0");
                if (beginBalanceFor.compareTo(new BigDecimal("0")) > 0) {
                    qty = BigDecimal.ONE;
                } else if (beginBalanceFor.compareTo(new BigDecimal("0")) < 0) {
                    qty = NEGATIVE_ONE;
                }
                otherBillEntryInfo.setQuantity(qty);
                otherBillEntryInfo.setBaseQty(qty);
                otherBillEntryInfo.setPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setRealPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setTaxPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setActualPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setAmount(beginBalanceFor);
                otherBillEntryInfo.setAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setTaxAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setTaxAmountLocal(BigDecimal.ZERO);
                otherBillEntryInfo.setDiscountAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setDiscountAmountLocal(BigDecimal.ZERO);
                otherBillEntryInfo.setRecievePayAmount(beginBalanceFor);
                otherBillEntryInfo.setRecievePayAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setWittenOffBaseQty(qty);
                otherBillEntryInfo.setLocalWrittenOffAmount(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setUnwriteOffBaseQty(BigDecimal.ZERO);
                otherBillEntryInfo.setLocalUnwriteOffAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setLockUnVerifyAmt(beginBalanceFor);
                otherBillEntryInfo.setLockUnVerifyAmtLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillEntryInfo.setUnVerifyAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                OtherBillPlanInfo otherBillPlanInfo = new OtherBillPlanInfo();
                otherBillPlanInfo.setRecievePayDate(billDate);
                otherBillPlanInfo.setRecievePayAmount(beginBalanceFor);
                otherBillPlanInfo.setRecievePayAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillPlanInfo.setVerifyAmount(BigDecimal.ZERO);
                otherBillPlanInfo.setVerifyAmountLocal(BigDecimal.ZERO);
                otherBillPlanInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillPlanInfo.setUnVerifyAmountLocal(otherBillPlanInfo.getRecievePayAmountLocal());
                otherBillPlanInfo.setLockAmount(BigDecimal.ZERO);
                otherBillPlanInfo.setLockAmountLoc(BigDecimal.ZERO);
                otherBillPlanInfo.setUnLockAmount(beginBalanceFor);
                otherBillPlanInfo.setUnLockAmountLoc(otherBillPlanInfo.getRecievePayAmountLocal());
                otherBillInfo.getEntry().add(otherBillEntryInfo);
                otherBillInfo.getRecievePlan().add(otherBillPlanInfo);
                iOtherBill.submit((CoreBaseInfo)otherBillInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void importAPOtherBill(Context ctx, Map filter) throws BOSException, EASBizException {
        com.kingdee.eas.fi.ap.IOtherBill iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        boolean isCAA = false;
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        if (accountViewInfo.getCAA() != null) {
            isCAA = true;
        }
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        MaterialInfo material = (MaterialInfo)filter.get("material");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        ExpenseTypeInfo expenseitem = (ExpenseTypeInfo)filter.get("expenseitem");
        this.removeLastImpBill(ctx, iOtherBill, company, bizType, accountViewInfo);
        this.removeLastImpBill(ctx, (IBillBase)iPaymentBill, company, null, accountViewInfo);
        RowSet rs = null;
        rs = isCAA ? this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString()) : this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        try {
            AsstActTypeCollection assActTypeCol = null;
            if (rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
            CoreBaseCollection apOtherBillCol = new CoreBaseCollection();
            while (rs.next()) {
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"));
                if (beginBalanceLocal == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if (BalanceDirectionEnum.CREDIT.getValue() == accountViewInfo.getDC().getValue() || direction.getValue() != accountViewInfo.getDC().getValue()) {
                    beginBalanceFor = beginBalanceFor.negate();
                    beginBalanceLocal = beginBalanceLocal.negate();
                }
                com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo = new com.kingdee.eas.fi.ap.OtherBillInfo();
                otherBillInfo.setCompany(company);
                otherBillInfo.setReqCalculate4Srv(false);
                String number = BaseDataUtil.getNumberFromCodeRule(ctx, otherBillInfo);
                if (number == null) {
                    throw new ImpInitDataGLException(ImpInitDataGLException.AP_OTHERBILL_NO_NUMBER_RULE);
                }
                otherBillInfo.setNumber(number);
                otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
                otherBillInfo.setIsInitializeBill(true);
                otherBillInfo.setIsImpFromGL(true);
                otherBillInfo.setIsBizBill((Boolean)filter.get("isBizBill"));
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                otherBillInfo.setBillDate(billDate);
                otherBillInfo.setIsInTax(true);
                if (10 == bizType.getValue()) {
                    otherBillInfo.setIsPriceWithoutTax(false);
                } else {
                    otherBillInfo.setIsPriceWithoutTax(true);
                }
                otherBillInfo.setBillType(this.getAPBillType(bizType));
                otherBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setAPAsstAct(ctx, asstActType, assistGrpID, otherBillInfo);
                    if (!"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        otherBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (!"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        otherBillInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    otherBillInfo.setAsstActType(asstActType);
                    otherBillInfo.setAsstActID(asstAct.getId().toString());
                    otherBillInfo.setAsstActName(asstAct.getName(this.L1), this.L1);
                    otherBillInfo.setAsstActName(asstAct.getName(this.L2), this.L2);
                    otherBillInfo.setAsstActName(asstAct.getName(this.L3), this.L3);
                    otherBillInfo.setAsstActNumber(asstAct.getNumber());
                }
                String currencyID = rs.getString("FCurrencyID");
                CurrencyInfo currency = null;
                if (!StringUtils.isEmpty((String)currencyID)) {
                    if (!currencyMap.containsKey(currencyID)) {
                        currencyMap.put(currencyID, this.getCurrency(ctx, currencyID));
                    }
                    currency = (CurrencyInfo)currencyMap.get(currencyID);
                    otherBillInfo.setCurrency(currency);
                }
                BigDecimal exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                otherBillInfo.setExchangeRate(exchangeRate);
                otherBillInfo.setLastExhangeRate(exchangeRate);
                otherBillInfo.setBizDate(billDate);
                String paymentTypeID = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
                PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
                paymentTypeInfo.setId(BOSUuid.read((String)paymentTypeID));
                otherBillInfo.setPaymentType(paymentTypeInfo);
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) < 0) {
                    otherBillInfo.setRedBlueType(true);
                } else {
                    otherBillInfo.setRedBlueType(false);
                }
                otherBillInfo.setAmount(beginBalanceFor);
                otherBillInfo.setAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillInfo.setTotalAmount(beginBalanceFor);
                otherBillInfo.setTotalTaxAmount(beginBalanceFor);
                otherBillInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillInfo.setUnVerifyAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                com.kingdee.eas.fi.ap.OtherBillentryInfo otherBillEntryInfo = new com.kingdee.eas.fi.ap.OtherBillentryInfo();
                otherBillEntryInfo.setSeq(1);
                if (bizType.getValue() == 0) {
                    if (material == null && isCAA) {
                        String assistGrpID = rs.getString("FAssistGrpID");
                        if (!materialMap.containsKey(assistGrpID)) {
                            material = this.getMaterial(ctx, assistGrpID);
                            materialMap.put(assistGrpID, material);
                        } else {
                            material = (MaterialInfo)materialMap.get(assistGrpID);
                        }
                    }
                    if (material != null) {
                        otherBillEntryInfo.setMaterial(material);
                        otherBillEntryInfo.setMaterialName(material.getName());
                        otherBillEntryInfo.setMeasureUnit(material.getBaseUnit());
                        otherBillEntryInfo.setBaseUnit(material.getBaseUnit());
                    }
                } else {
                    otherBillEntryInfo.setExpenseItem(expenseitem);
                }
                otherBillEntryInfo.setAccount(accountViewInfo);
                BigDecimal qty = BigDecimal.ZERO;
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) > 0) {
                    qty = BigDecimal.ONE;
                } else if (beginBalanceFor.compareTo(BigDecimal.ZERO) < 0) {
                    qty = NEGATIVE_ONE;
                }
                otherBillEntryInfo.setQuantity(qty);
                otherBillEntryInfo.setBaseQty(qty);
                otherBillEntryInfo.setPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setRealPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setTaxPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setActualPrice(beginBalanceFor.abs());
                otherBillEntryInfo.setAmount(beginBalanceFor);
                otherBillEntryInfo.setAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setTaxAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setTaxAmountLocal(BigDecimal.ZERO);
                otherBillEntryInfo.setDiscountAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setDiscountAmountLocal(BigDecimal.ZERO);
                otherBillEntryInfo.setRecievePayAmount(beginBalanceFor);
                otherBillEntryInfo.setRecievePayAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setWittenOffBaseQty(qty);
                otherBillEntryInfo.setLocalWrittenOffAmount(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setUnwriteOffBaseQty(BigDecimal.ZERO);
                otherBillEntryInfo.setLocalUnwriteOffAmount(BigDecimal.ZERO);
                otherBillEntryInfo.setLockUnVerifyAmt(beginBalanceFor);
                otherBillEntryInfo.setLockUnVerifyAmtLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillEntryInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillEntryInfo.setUnVerifyAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                com.kingdee.eas.fi.ap.OtherBillPlanInfo otherBillPlanInfo = new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
                otherBillPlanInfo.setRecievePayDate(billDate);
                otherBillPlanInfo.setRecievePayAmount(beginBalanceFor);
                otherBillPlanInfo.setRecievePayAmountLocal(this.convertLocalAmount(company, beginBalanceLocal));
                otherBillPlanInfo.setVerifyAmount(BigDecimal.ZERO);
                otherBillPlanInfo.setVerifyAmountLocal(BigDecimal.ZERO);
                otherBillPlanInfo.setUnVerifyAmount(beginBalanceFor);
                otherBillPlanInfo.setUnVerifyAmountLocal(otherBillPlanInfo.getRecievePayAmountLocal());
                otherBillPlanInfo.setLockAmount(BigDecimal.ZERO);
                otherBillPlanInfo.setLockAmountLoc(BigDecimal.ZERO);
                otherBillPlanInfo.setUnLockAmount(beginBalanceFor);
                otherBillPlanInfo.setUnLockAmountLoc(otherBillPlanInfo.getRecievePayAmountLocal());
                otherBillInfo.getEntry().add(otherBillEntryInfo);
                otherBillInfo.getPayPlan().add(otherBillPlanInfo);
                iOtherBill.submit((CoreBaseInfo)otherBillInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ReceivingBillTypeInfo getReceivingBillType(Context ctx, String billType) throws BOSException, EASBizException {
        IReceivingBillType iReceivingBillType = ReceivingBillTypeFactory.getLocalInstance((Context)ctx);
        ReceivingBillTypeCollection coll = iReceivingBillType.getReceivingBillTypeCollection("where number='" + billType + "'");
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private PaymentBillTypeInfo getPaymentBillType(Context ctx, String billType) throws BOSException, EASBizException {
        IPaymentBillType iPaymentBillType = PaymentBillTypeFactory.getLocalInstance((Context)ctx);
        PaymentBillTypeCollection coll = iPaymentBillType.getPaymentBillTypeCollection("where number='" + billType + "'");
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private void removeLastImpBill(Context ctx, IBillBase iBillBase, CompanyOrgUnitInfo company, VerificateBillTypeEnum billType, AccountViewInfo account) throws EASBizException, BOSException {
        if (company == null || account == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isImpFromGL", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId()));
        String tableName = "";
        boolean isOtherBill = false;
        if (iBillBase instanceof IOtherBill) {
            tableName = "T_AR_OtherBillEntry";
            isOtherBill = true;
        } else if (iBillBase instanceof com.kingdee.eas.fi.ap.IOtherBill) {
            tableName = "T_AP_OtherBillEntry";
            isOtherBill = true;
        }
        if (isOtherBill) {
            String sql = "select FParentID from " + tableName + " where FAccountID = '" + account.getId() + "'";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("oppAccount.id", (Object)account.getId()));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        CoreBillBaseCollection billCollection = iBillBase.getCoreBillBaseCollection(view);
        this.verifyBillCannotDelete(ctx, iBillBase, billCollection);
        for (int i = 0; i < billCollection.size(); ++i) {
            iBillBase.delete((IObjectPK)new ObjectUuidPK(billCollection.get(i).getId()));
        }
    }

    private boolean canDeleteOtherbill(ArApBillEntryBaseInfo entryInfo) {
        boolean canDelete = true;
        BigDecimal hisUnVerifyAmt = entryInfo.getHisUnVerifyAmount();
        BigDecimal unLockAmt = entryInfo.getLockUnVerifyAmt();
        BigDecimal recPayAmt = entryInfo.getRecievePayAmount();
        hisUnVerifyAmt = hisUnVerifyAmt == null ? BigDecimal.ZERO : hisUnVerifyAmt;
        unLockAmt = unLockAmt == null ? BigDecimal.ZERO : unLockAmt;
        BigDecimal bigDecimal = recPayAmt = recPayAmt == null ? BigDecimal.ZERO : recPayAmt;
        if (hisUnVerifyAmt.compareTo(BigDecimal.ZERO) != 0 && hisUnVerifyAmt.compareTo(unLockAmt) != 0 || hisUnVerifyAmt.compareTo(BigDecimal.ZERO) == 0 && recPayAmt.compareTo(unLockAmt) != 0) {
            canDelete = false;
        }
        return canDelete;
    }

    private void verifyBillCannotDelete(Context ctx, IBillBase iBillBase, CoreBillBaseCollection billCollection) throws EASBizException, BOSException {
        ArApBillEntryBaseInfo entryInfo;
        ArApBillBaseInfo otherBillInfo;
        if ((iBillBase instanceof IReceivingBill || iBillBase instanceof IPaymentBill) && billCollection != null && billCollection.size() > 0) {
            StringBuilder ids = new StringBuilder(150);
            for (int i = 0; i < billCollection.size(); ++i) {
                if (i > 0) {
                    ids.append(",");
                }
                ids.append("'");
                ids.append(billCollection.get(i).getId());
                ids.append("'");
            }
            StringBuilder buf = new StringBuilder(300);
            buf.append("SELECT a.FNumber, b.FUnLockAmt,b.FHisUnVcAmount FROM ");
            if (iBillBase instanceof IReceivingBill) {
                buf.append(" T_CAS_ReceivingBill a ").append(rt).append(" LEFT JOIN T_CAS_ReceivingBillEntry b ON a.fid = b.FReceivingBillID ").append(rt);
            } else {
                buf.append(" T_CAS_PaymentBill a ").append(rt).append(" LEFT JOIN T_CAS_PaymentBillEntry b ON a.fid = b.FPaymentBillID ").append(rt);
            }
            buf.append(" WHERE a.FID in (").append(ids.toString()).append(") AND a.FIsinitializeBill = 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            BigDecimal unLockAmt = null;
            BigDecimal hisUnVcAmt = null;
            String number = null;
            try {
                while (rs.next()) {
                    unLockAmt = rs.getBigDecimal("FUnLockAmt");
                    if (unLockAmt.compareTo(hisUnVcAmt = rs.getBigDecimal("FHisUnVcAmount")) == 0) continue;
                    number = rs.getString("FNumber");
                    throw new RecPayException(RecPayException.CANNOT_DELETE_INIT, (Object[])new String[]{number});
                }
            }
            catch (SQLException e) {
                logger.error((Object)("sql is :" + buf.toString()));
                throw new BOSException("sql is :" + buf.toString(), (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        if (iBillBase instanceof IOtherBill) {
            for (int i = 0; i < billCollection.size(); ++i) {
                otherBillInfo = (OtherBillInfo)billCollection.get(i);
                if (!otherBillInfo.isIsInitializeBill()) continue;
                for (int j = 0; j < ((AbstractOtherBillInfo)otherBillInfo).getEntry().size(); ++j) {
                    entryInfo = ((AbstractOtherBillInfo)otherBillInfo).getEntry().get(j);
                    if (this.canDeleteOtherbill(entryInfo)) continue;
                    throw new OtherBillBizException(OtherBillBizException.HASNEXTBIZACTION);
                }
            }
        }
        if (iBillBase instanceof com.kingdee.eas.fi.ap.IOtherBill) {
            for (int i = 0; i < billCollection.size(); ++i) {
                otherBillInfo = (com.kingdee.eas.fi.ap.OtherBillInfo)billCollection.get(i);
                if (!otherBillInfo.isIsInitializeBill()) continue;
                for (int j = 0; j < ((com.kingdee.eas.fi.ap.AbstractOtherBillInfo)otherBillInfo).getEntry().size(); ++j) {
                    entryInfo = ((com.kingdee.eas.fi.ap.AbstractOtherBillInfo)otherBillInfo).getEntry().get(j);
                    if (this.canDeleteOtherbill(entryInfo)) continue;
                    throw new OtherBillBizException(OtherBillBizException.HASNEXTBIZACTION);
                }
            }
        }
    }

    private void removeLastImpData(IBillEntryBase iBillEntryBase, CompanyOrgUnitInfo company, VerificateBillTypeEnum bizType, AccountViewInfo accountViewInfo) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isImpFromGL", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.company.id", (Object)company.getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountViewInfo.getId()));
        iBillEntryBase.delete(filterInfo);
    }

    private void importReceivingBill(Context ctx, Map filter) throws BOSException, EASBizException {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        boolean isCAA = false;
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        if (accountViewInfo != null && accountViewInfo.getCAA() != null) {
            isCAA = true;
        }
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        AccountViewInfo recAccount = (AccountViewInfo)filter.get("recAccount");
        this.removeLastImpBill(ctx, (IBillBase)iReceivingBill, company, null, accountViewInfo);
        this.removeLastImpBill(ctx, iOtherBill, company, bizType, accountViewInfo);
        ResultSet rs = null;
        if (company != null && glCurrentPeriod != null) {
            rs = isCAA ? this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString()) : this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        }
        try {
            AsstActTypeCollection assActTypeCol = null;
            if (rs != null && rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            HashMap<String, ReceivingBillTypeInfo> recBillTypeMap = new HashMap<String, ReceivingBillTypeInfo>();
            CoreBaseCollection receiveBillCol = new CoreBaseCollection();
            String receBillType = "";
            PaymentTypeInfo paymentType = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
            while (rs != null && rs.next()) {
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"));
                if (beginBalanceLocal == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if (BalanceDirectionEnum.CREDIT.getValue() == accountViewInfo.getDC().getValue() || direction.getValue() != accountViewInfo.getDC().getValue()) {
                    beginBalanceFor = beginBalanceFor.negate();
                    beginBalanceLocal = beginBalanceLocal.negate();
                }
                ReceivingBillInfo receivingBillInfo = new ReceivingBillInfo();
                receivingBillInfo.setCompany(company);
                receivingBillInfo.setCU(company.getCU());
                String number = BaseDataUtil.getNumberFromCodeRule(ctx, (BillBaseInfo)receivingBillInfo);
                if (number == null) {
                    throw new ImpInitDataGLException(ImpInitDataGLException.RECEIVINGBILL_NO_NUMBER_RULE);
                }
                receivingBillInfo.setNumber(number);
                receivingBillInfo.setSourceType(SourceTypeEnum.AR);
                receivingBillInfo.setIsInitializeBill(true);
                receivingBillInfo.setIsImpFromGL(true);
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                receivingBillInfo.setBizDate(billDate);
                receivingBillInfo.setSourceSysType(SourceTypeEnum.AR);
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) < 0) {
                    receBillType = REC_BILL_TYPE_103;
                    receivingBillInfo.setIsRedBill(true);
                } else {
                    receBillType = REC_BILL_TYPE_101;
                    receivingBillInfo.setIsRedBill(false);
                }
                if (!recBillTypeMap.containsKey(receBillType)) {
                    recBillTypeMap.put(receBillType, this.getReceivingBillType(ctx, receBillType));
                }
                receivingBillInfo.setRecBillType((ReceivingBillTypeInfo)recBillTypeMap.get(receBillType));
                receivingBillInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SUBMIT);
                String currencyID = rs.getString("FCurrencyID");
                CurrencyInfo currency = null;
                if (!StringUtils.isEmpty((String)currencyID)) {
                    if (!currencyMap.containsKey(currencyID)) {
                        currencyMap.put(currencyID, this.getCurrency(ctx, currencyID));
                    }
                    currency = (CurrencyInfo)currencyMap.get(currencyID);
                    receivingBillInfo.setCurrency(currency);
                }
                BigDecimal exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                receivingBillInfo.setExchangeRate(exchangeRate);
                receivingBillInfo.setLastExhangeRate(exchangeRate);
                receivingBillInfo.setActRecAmt(beginBalanceFor);
                receivingBillInfo.setActRecLocAmt(this.convertLocalAmount(company, beginBalanceLocal));
                receivingBillInfo.setAmount(beginBalanceFor);
                receivingBillInfo.setLocalAmt(this.convertLocalAmount(company, beginBalanceLocal));
                receivingBillInfo.setIsCommitSettle(false);
                receivingBillInfo.setFundType(BizTypeEnum.OTHER);
                receivingBillInfo.setPayeeAccount(recAccount);
                receivingBillInfo.setOppAccount(accountViewInfo);
                String language = ctx.getLocale().getLanguage();
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setRBAsstAct(ctx, asstActType, assistGrpID, receivingBillInfo, language);
                    if (!"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        receivingBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (!"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        receivingBillInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    receivingBillInfo.setPayerType(asstActType);
                    receivingBillInfo.setPayerID(asstAct.getId().toString());
                    if (LocaleUtils.getLocaleString((Locale)this.L1).equalsIgnoreCase(language)) {
                        receivingBillInfo.setPayerName(asstAct.getName(this.L1));
                    } else if (LocaleUtils.getLocaleString((Locale)this.L2).equalsIgnoreCase(language)) {
                        receivingBillInfo.setPayerName(asstAct.getName(this.L2));
                    } else if (LocaleUtils.getLocaleString((Locale)this.L3).equalsIgnoreCase(language)) {
                        receivingBillInfo.setPayerName(asstAct.getName(this.L3));
                    }
                    receivingBillInfo.setPayerNumber(asstAct.getNumber());
                }
                ReceivingBillEntryInfo receivingBillEntryInfo = new ReceivingBillEntryInfo();
                receivingBillEntryInfo.setSeq(1);
                receivingBillEntryInfo.setAmount(beginBalanceFor);
                receivingBillEntryInfo.setLocalAmt(this.convertLocalAmount(company, beginBalanceLocal));
                receivingBillEntryInfo.setActualAmt(beginBalanceFor);
                receivingBillEntryInfo.setActualLocAmt(this.convertLocalAmount(company, beginBalanceLocal));
                receivingBillEntryInfo.setUnVcAmount(beginBalanceFor);
                receivingBillEntryInfo.setUnVcLocAmount(beginBalanceLocal);
                receivingBillEntryInfo.setHisUnVcAmount(beginBalanceFor);
                receivingBillEntryInfo.setHisUnVcLocAmount(beginBalanceLocal);
                receivingBillEntryInfo.setAmountVc(SysConstant.BIGZERO);
                receivingBillEntryInfo.setLocalAmtVc(SysConstant.BIGZERO);
                receivingBillInfo.getEntries().add(receivingBillEntryInfo);
                iReceivingBill.submit((CoreBaseInfo)receivingBillInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void importPaymentBill(Context ctx, Map filter) throws BOSException, EASBizException {
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        com.kingdee.eas.fi.ap.IOtherBill iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        boolean isCAA = false;
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        if (accountViewInfo != null && accountViewInfo.getCAA() != null) {
            isCAA = true;
        }
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        AccountViewInfo payAccount = (AccountViewInfo)filter.get("payAccount");
        this.removeLastImpBill(ctx, (IBillBase)iPaymentBill, company, null, accountViewInfo);
        this.removeLastImpBill(ctx, iOtherBill, company, bizType, accountViewInfo);
        ResultSet rs = null;
        if (isCAA && glCurrentPeriod != null) {
            rs = this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        } else if (glCurrentPeriod != null) {
            rs = this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        }
        try {
            AsstActTypeCollection assActTypeCol = null;
            if (rs != null && rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            HashMap<String, PaymentBillTypeInfo> paymentBillTypeMap = new HashMap<String, PaymentBillTypeInfo>();
            CoreBaseCollection paymentBillCol = new CoreBaseCollection();
            String paymentBillType = "";
            PaymentTypeInfo paymentType = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
            while (rs != null && rs.next()) {
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"));
                if (beginBalanceLocal == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if (BalanceDirectionEnum.CREDIT.getValue() == accountViewInfo.getDC().getValue() || direction.getValue() != accountViewInfo.getDC().getValue()) {
                    beginBalanceFor = beginBalanceFor.negate();
                    beginBalanceLocal = beginBalanceLocal.negate();
                }
                PaymentBillInfo paymentBillInfo = new PaymentBillInfo();
                paymentBillInfo.setCompany(company);
                paymentBillInfo.setCU(company.getCU());
                String number = BaseDataUtil.getNumberFromCodeRule(ctx, (BillBaseInfo)paymentBillInfo);
                if (number == null) {
                    throw new ImpInitDataGLException(ImpInitDataGLException.PAYMENTBILL_NO_NUMBER_RULE);
                }
                paymentBillInfo.setNumber(number);
                paymentBillInfo.setIsInitializeBill(true);
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                paymentBillInfo.setBizDate(billDate);
                paymentBillInfo.setIsImpFromGL(true);
                paymentBillInfo.setSourceType(SourceTypeEnum.AP);
                paymentBillInfo.setSourceSysType(SourceTypeEnum.AP);
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) < 0) {
                    paymentBillType = PAY_BILL_TYPE_204;
                    paymentBillInfo.setIsRedBill(true);
                } else {
                    paymentBillType = PAY_BILL_TYPE_202;
                    paymentBillInfo.setIsRedBill(false);
                }
                if (!paymentBillTypeMap.containsKey(paymentBillType)) {
                    paymentBillTypeMap.put(paymentBillType, this.getPaymentBillType(ctx, paymentBillType));
                }
                paymentBillInfo.setPayBillType((PaymentBillTypeInfo)paymentBillTypeMap.get(paymentBillType));
                paymentBillInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SUBMIT);
                String currencyID = rs.getString("FCurrencyID");
                CurrencyInfo currency = null;
                if (!StringUtils.isEmpty((String)currencyID)) {
                    if (!currencyMap.containsKey(currencyID)) {
                        currencyMap.put(currencyID, this.getCurrency(ctx, currencyID));
                    }
                    currency = (CurrencyInfo)currencyMap.get(currencyID);
                    paymentBillInfo.setCurrency(currency);
                }
                BigDecimal exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                paymentBillInfo.setExchangeRate(exchangeRate);
                paymentBillInfo.setLastExhangeRate(exchangeRate);
                paymentBillInfo.setActPayAmt(beginBalanceFor);
                paymentBillInfo.setActPayLocAmt(this.convertLocalAmount(company, beginBalanceLocal));
                paymentBillInfo.setAmount(beginBalanceFor);
                paymentBillInfo.setLocalAmt(this.convertLocalAmount(company, beginBalanceLocal));
                paymentBillInfo.setIsCommitSettle(false);
                paymentBillInfo.setFundType(BizTypeEnum.OTHER);
                paymentBillInfo.setPayerAccount(payAccount);
                paymentBillInfo.setOppAccount(accountViewInfo);
                String language = ctx.getLocale().getLanguage();
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setPBAsstAct(ctx, asstActType, assistGrpID, paymentBillInfo, language);
                    if (!"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        paymentBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (!"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        paymentBillInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    paymentBillInfo.setPayeeType(asstActType);
                    if (asstAct != null) {
                        paymentBillInfo.setPayeeID(asstAct.getId().toString());
                        if (LocaleUtils.getLocaleString((Locale)this.L1).equalsIgnoreCase(language)) {
                            paymentBillInfo.setPayeeName(asstAct.getName(this.L1));
                        } else if (LocaleUtils.getLocaleString((Locale)this.L2).equalsIgnoreCase(language)) {
                            paymentBillInfo.setPayeeName(asstAct.getName(this.L2));
                        } else if (LocaleUtils.getLocaleString((Locale)this.L3).equalsIgnoreCase(language)) {
                            paymentBillInfo.setPayeeName(asstAct.getName(this.L3));
                        }
                        paymentBillInfo.setPayeeNumber(asstAct.getNumber());
                    }
                }
                PaymentBillEntryInfo paymentBillEntryInfo = new PaymentBillEntryInfo();
                paymentBillEntryInfo.setSeq(1);
                paymentBillEntryInfo.setAmount(beginBalanceFor);
                paymentBillEntryInfo.setLocalAmt(this.convertLocalAmount(company, beginBalanceLocal));
                paymentBillEntryInfo.setActualAmt(beginBalanceFor);
                paymentBillEntryInfo.setActualLocAmt(this.convertLocalAmount(company, beginBalanceLocal));
                paymentBillEntryInfo.setUnVcAmount(beginBalanceFor);
                paymentBillEntryInfo.setUnVcLocAmount(beginBalanceLocal);
                paymentBillEntryInfo.setHisUnVcAmount(beginBalanceFor);
                paymentBillEntryInfo.setHisUnVcLocAmount(beginBalanceLocal);
                paymentBillEntryInfo.setAmountVc(SysConstant.BIGZERO);
                paymentBillEntryInfo.setLocalAmtVc(SysConstant.BIGZERO);
                paymentBillInfo.getEntries().add(paymentBillEntryInfo);
                iPaymentBill.submit((CoreBaseInfo)paymentBillInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void importARInitData(Context ctx, Map filter) throws BOSException, EASBizException {
        IInitDataInputAR iInitDataInputAR = InitDataInputARFactory.getLocalInstance(ctx);
        boolean isCAA = false;
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        if (accountViewInfo.getCAA() != null) {
            isCAA = true;
        }
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        if (bizType.getValue() == 7) {
            bizType = VerificateBillTypeEnum.REC_AR_PRE_REC;
        } else if (bizType.getValue() == 5) {
            bizType = VerificateBillTypeEnum.PAY_AP_PRE_PAYMENT;
        }
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        IInitDataInputARentry iInitDataEntry = InitDataInputARentryFactory.getLocalInstance(ctx);
        this.removeLastImpData(iInitDataEntry, company, bizType, accountViewInfo);
        RowSet rs = null;
        rs = isCAA ? this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString()) : this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        try {
            AsstActTypeCollection assActTypeCol = null;
            if (rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, InitDataInputARCollection> InitDataInputARMap = new HashMap<String, InitDataInputARCollection>();
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            CoreBaseCollection InitDataInputARCol = new CoreBaseCollection();
            while (rs.next()) {
                BigDecimal yearCreditLocal;
                BigDecimal yearCreditFor;
                BigDecimal yearDebitLocal;
                BigDecimal yearDebitFor;
                BigDecimal beginBalanceLocal;
                InitDataInputARInfo initDataInputARInfo = null;
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if ((beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"))) == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if ((yearDebitFor = rs.getBigDecimal("FYearDebitFor")) == null) {
                    yearDebitFor = BigDecimal.ZERO;
                }
                if ((yearDebitLocal = this.convertLocalAmount(company, rs.getBigDecimal("FYearDebitLocal"))) == null) {
                    yearDebitLocal = BigDecimal.ZERO;
                }
                if ((yearCreditFor = rs.getBigDecimal("FYearCreditFor")) == null) {
                    yearCreditFor = BigDecimal.ZERO;
                }
                if ((yearCreditLocal = this.convertLocalAmount(company, rs.getBigDecimal("FYearCreditLocal"))) == null) {
                    yearCreditLocal = BigDecimal.ZERO;
                }
                if ((beginBalanceFor.compareTo(BaseDataUtil.ZERO) == 0 && beginBalanceLocal.compareTo(BaseDataUtil.ZERO) == 0 || beginBalanceFor.compareTo(BaseDataUtil.ZERO) != 0 && beginBalanceLocal.compareTo(BaseDataUtil.ZERO) != 0) && yearDebitFor.compareTo(BaseDataUtil.ZERO) == 0 && yearDebitLocal.compareTo(BaseDataUtil.ZERO) == 0 && yearCreditLocal.compareTo(BaseDataUtil.ZERO) == 0 && yearCreditFor.compareTo(BaseDataUtil.ZERO) == 0) continue;
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                String currencyID = rs.getString("FCurrencyID") == null ? "null" : rs.getString("FCurrencyID");
                InitDataInputARCollection coll = null;
                if (InitDataInputARMap.containsKey(currencyID)) {
                    coll = (InitDataInputARCollection)((Object)InitDataInputARMap.get(currencyID));
                } else {
                    FilterInfo initDataFilter = new FilterInfo();
                    initDataFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                    initDataFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
                    initDataFilter.getFilterItems().add(new FilterItemInfo("startPeriod.id", (Object)startPeriod.getId().toString()));
                    initDataFilter.setMaskString(" #0 and #1 and #2");
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(initDataFilter);
                    coll = iInitDataInputAR.getInitDataInputARCollection(view);
                    InitDataInputARMap.put(currencyID, coll);
                }
                if (coll.size() > 0) {
                    initDataInputARInfo = coll.get(0);
                } else {
                    initDataInputARInfo = new InitDataInputARInfo();
                    initDataInputARInfo.setCompany(company);
                    initDataInputARInfo.setBizDate(billDate);
                    initDataInputARInfo.setStartPeriod(startPeriod);
                    CurrencyInfo currency = null;
                    if (!StringUtils.isEmpty((String)currencyID)) {
                        if (currencyMap.containsKey(currencyID)) {
                            currency = (CurrencyInfo)currencyMap.get(currencyID);
                        } else {
                            currency = this.getCurrency(ctx, currencyID);
                            currencyMap.put(currencyID, currency);
                        }
                        initDataInputARInfo.setCurrency(currency);
                    }
                    BigDecimal exchangeRate = BigDecimal.ONE;
                    if (beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0 && beginBalanceFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                    } else if (yearDebitLocal.compareTo(BigDecimal.ZERO) != 0 && yearDebitFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, yearDebitFor, yearDebitLocal, currToRateMap);
                    } else if (yearCreditLocal.compareTo(BigDecimal.ZERO) != 0 && yearCreditFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, yearCreditFor, yearCreditLocal, currToRateMap);
                    }
                    initDataInputARInfo.setExchangeRate(exchangeRate);
                }
                InitDataInputARentryInfo initDataInputARentryInfo = new InitDataInputARentryInfo();
                initDataInputARentryInfo.setSeq(1);
                initDataInputARentryInfo.setAccount(accountViewInfo);
                initDataInputARentryInfo.setBizDate(billDate);
                initDataInputARentryInfo.setBizType(bizType);
                initDataInputARentryInfo.setIsBillCollected(false);
                initDataInputARentryInfo.setIsBizBill((Boolean)filter.get("isBizBill"));
                BigDecimal initYearAmt = BigDecimal.ZERO;
                BigDecimal initYearAmtLocal = BigDecimal.ZERO;
                if (accountViewInfo.getDC().getValue() == 1) {
                    initYearAmt = beginBalanceFor.add(yearCreditFor).subtract(yearDebitFor);
                    initYearAmtLocal = beginBalanceLocal.add(yearCreditLocal).subtract(yearDebitLocal);
                } else {
                    initYearAmt = beginBalanceFor.add(yearDebitFor).subtract(yearCreditFor);
                    initYearAmtLocal = beginBalanceLocal.add(yearDebitLocal).subtract(yearCreditLocal);
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0 && beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0) {
                    initDataInputARentryInfo.setInitPeriodAmt(beginBalanceFor);
                    initDataInputARentryInfo.setInitPeriodAmtLocal(this.convertLocalAmount(company, beginBalanceLocal));
                } else {
                    initDataInputARentryInfo.setInitPeriodAmt(BigDecimal.ZERO);
                    initDataInputARentryInfo.setInitPeriodAmtLocal(BigDecimal.ZERO);
                }
                initDataInputARentryInfo.setInitYearAmt(initYearAmt);
                initDataInputARentryInfo.setInitYearAmtLocal(this.convertLocalAmount(company, initYearAmtLocal));
                initDataInputARentryInfo.setYearTotalDebitAmt(yearDebitFor);
                initDataInputARentryInfo.setYearTotalDebitAmtLocal(this.convertLocalAmount(company, yearDebitLocal));
                initDataInputARentryInfo.setYearTotalCreditAmt(yearCreditFor);
                initDataInputARentryInfo.setYearTotalCreditAmtLocal(this.convertLocalAmount(company, yearCreditLocal));
                initDataInputARentryInfo.setInitPeriodDirection(direction);
                initDataInputARentryInfo.setInitYearDirection(direction);
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setARInitDataAsstAct(ctx, asstActType, assistGrpID, initDataInputARentryInfo);
                    if (!"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        initDataInputARentryInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (!"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        initDataInputARentryInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    initDataInputARentryInfo.setAcctCussType(asstActType);
                    initDataInputARentryInfo.setAcctCussID(asstAct.getId().toString());
                }
                initDataInputARentryInfo.setIsImpFromGL(true);
                initDataInputARInfo.getEntrys().add(initDataInputARentryInfo);
                iInitDataInputAR.impSubmit(initDataInputARInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void importAPInitData(Context ctx, Map filter) throws BOSException, EASBizException {
        IInitDataInputAP iInitDataInputAP = InitDataInputAPFactory.getLocalInstance(ctx);
        boolean isCAA = false;
        this.checkImportFilter(filter);
        AccountViewInfo accountViewInfo = (AccountViewInfo)filter.get("account");
        if (accountViewInfo.getCAA() != null) {
            isCAA = true;
        }
        BalanceDirectionEnum direction = (BalanceDirectionEnum)filter.get("direction");
        VerificateBillTypeEnum bizType = (VerificateBillTypeEnum)filter.get("bizType");
        if (bizType.getValue() == 7) {
            bizType = VerificateBillTypeEnum.REC_AR_PRE_REC;
        } else if (bizType.getValue() == 5) {
            bizType = VerificateBillTypeEnum.PAY_AP_PRE_PAYMENT;
        }
        AsstActTypeInfo asstActType = this.getAsstActType(ctx, ((AsstActTypeInfo)filter.get("asstActType")).getId().toString());
        DataBaseInfo asstAct = (DataBaseInfo)filter.get("asstAct");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.get("company");
        PeriodInfo startPeriod = (PeriodInfo)filter.get("startPeriod");
        PeriodInfo glCurrentPeriod = (PeriodInfo)filter.get("glCurrentPeriod");
        IInitDataInputAPentry iInitDataEntry = InitDataInputAPentryFactory.getLocalInstance(ctx);
        this.removeLastImpData(iInitDataEntry, company, bizType, accountViewInfo);
        RowSet rs = null;
        rs = isCAA ? this.getAssistBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString()) : this.getAccountBalance(ctx, company.getId().toString(), glCurrentPeriod.getNumber(), accountViewInfo.getId().toString());
        try {
            AsstActTypeCollection assActTypeCol = null;
            if (rs.next()) {
                assActTypeCol = this.getAssistantAsstActType(ctx, accountViewInfo);
                rs.beforeFirst();
            }
            HashMap<String, InitDataInputAPCollection> InitDataInputAPMap = new HashMap<String, InitDataInputAPCollection>();
            HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
            HashMap<BOSUuid, ExchangeRateInfo> currToRateMap = new HashMap<BOSUuid, ExchangeRateInfo>();
            CoreBaseCollection InitDataInputAPCol = new CoreBaseCollection();
            while (rs.next()) {
                BigDecimal yearCreditLocal;
                BigDecimal yearCreditFor;
                BigDecimal yearDebitLocal;
                BigDecimal yearDebitFor;
                BigDecimal beginBalanceLocal;
                InitDataInputAPInfo initDataInputAPInfo = null;
                BigDecimal beginBalanceFor = rs.getBigDecimal("FBeginBalanceFor");
                if (beginBalanceFor == null) {
                    beginBalanceFor = BigDecimal.ZERO;
                }
                if ((beginBalanceLocal = this.convertLocalAmount(company, rs.getBigDecimal("FBeginBalanceLocal"))) == null) {
                    beginBalanceLocal = BigDecimal.ZERO;
                }
                if ((yearDebitFor = rs.getBigDecimal("FYearDebitFor")) == null) {
                    yearDebitFor = BigDecimal.ZERO;
                }
                if ((yearDebitLocal = this.convertLocalAmount(company, rs.getBigDecimal("FYearDebitLocal"))) == null) {
                    yearDebitLocal = BigDecimal.ZERO;
                }
                if ((yearCreditFor = rs.getBigDecimal("FYearCreditFor")) == null) {
                    yearCreditFor = BigDecimal.ZERO;
                }
                if ((yearCreditLocal = this.convertLocalAmount(company, rs.getBigDecimal("FYearCreditLocal"))) == null) {
                    yearCreditLocal = BigDecimal.ZERO;
                }
                if ((beginBalanceFor.compareTo(BaseDataUtil.ZERO) == 0 && beginBalanceLocal.compareTo(BaseDataUtil.ZERO) == 0 || beginBalanceFor.compareTo(BaseDataUtil.ZERO) != 0 && beginBalanceLocal.compareTo(BaseDataUtil.ZERO) != 0) && yearDebitFor.compareTo(BaseDataUtil.ZERO) == 0 && yearDebitLocal.compareTo(BaseDataUtil.ZERO) == 0 && yearCreditLocal.compareTo(BaseDataUtil.ZERO) == 0 && yearCreditFor.compareTo(BaseDataUtil.ZERO) == 0) continue;
                Date billDate = ImpInitDataGLFacadeControllerBean.changeDate(startPeriod.getBeginDate(), -1);
                String currencyID = rs.getString("FCurrencyID") != null ? rs.getString("FCurrencyID") : "null";
                InitDataInputAPCollection coll = null;
                if (InitDataInputAPMap.containsKey(currencyID)) {
                    coll = (InitDataInputAPCollection)((Object)InitDataInputAPMap.get(currencyID));
                } else {
                    FilterInfo initDataFilter = new FilterInfo();
                    initDataFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                    initDataFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
                    initDataFilter.getFilterItems().add(new FilterItemInfo("startPeriod.id", (Object)startPeriod.getId().toString()));
                    initDataFilter.setMaskString(" #0 and #1 and #2");
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(initDataFilter);
                    coll = iInitDataInputAP.getInitDataInputAPCollection(view);
                    InitDataInputAPMap.put(currencyID, coll);
                }
                if (coll.size() > 0) {
                    initDataInputAPInfo = coll.get(0);
                } else {
                    initDataInputAPInfo = new InitDataInputAPInfo();
                    initDataInputAPInfo.setCompany(company);
                    initDataInputAPInfo.setBizDate(billDate);
                    initDataInputAPInfo.setStartPeriod(startPeriod);
                    CurrencyInfo currency = null;
                    if (!StringUtils.isEmpty((String)currencyID)) {
                        if (currencyMap.containsKey(currencyID)) {
                            currency = (CurrencyInfo)currencyMap.get(currencyID);
                        } else {
                            currency = this.getCurrency(ctx, currencyID);
                            currencyMap.put(currencyID, currency);
                        }
                        initDataInputAPInfo.setCurrency(currency);
                    }
                    BigDecimal exchangeRate = BigDecimal.ONE;
                    if (beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0 && beginBalanceFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, beginBalanceFor, beginBalanceLocal, currToRateMap);
                    } else if (yearDebitLocal.compareTo(BigDecimal.ZERO) != 0 && yearDebitFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, yearDebitFor, yearDebitLocal, currToRateMap);
                    } else if (yearCreditLocal.compareTo(BigDecimal.ZERO) != 0 && yearCreditFor.compareTo(BigDecimal.ZERO) != 0) {
                        exchangeRate = this.caluateExchageRate(ctx, company, currency, billDate, yearCreditFor, yearCreditLocal, currToRateMap);
                    }
                    initDataInputAPInfo.setExchangeRate(exchangeRate);
                }
                InitDataInputAPentryInfo initDataInputAPentryInfo = new InitDataInputAPentryInfo();
                initDataInputAPentryInfo.setSeq(1);
                initDataInputAPentryInfo.setAccount(accountViewInfo);
                initDataInputAPentryInfo.setBizDate(billDate);
                initDataInputAPentryInfo.setBizType(bizType);
                initDataInputAPentryInfo.setIsBillCollected(false);
                initDataInputAPentryInfo.setIsBizBill((Boolean)filter.get("isBizBill"));
                BigDecimal initYearAmt = BigDecimal.ZERO;
                BigDecimal initYearAmtLocal = BigDecimal.ZERO;
                if (accountViewInfo.getDC().getValue() == 1) {
                    initYearAmt = beginBalanceFor.add(yearCreditFor).subtract(yearDebitFor);
                    initYearAmtLocal = beginBalanceLocal.add(yearCreditLocal).subtract(yearDebitLocal);
                } else {
                    initYearAmt = beginBalanceFor.add(yearDebitFor).subtract(yearCreditFor);
                    initYearAmtLocal = beginBalanceLocal.add(yearDebitLocal).subtract(yearCreditLocal);
                }
                if (beginBalanceFor.compareTo(BigDecimal.ZERO) == 0 && beginBalanceLocal.compareTo(BigDecimal.ZERO) != 0) {
                    initDataInputAPentryInfo.setInitPeriodAmt(beginBalanceFor);
                    initDataInputAPentryInfo.setInitPeriodAmtLocal(this.convertLocalAmount(company, beginBalanceLocal));
                } else {
                    initDataInputAPentryInfo.setInitPeriodAmt(BigDecimal.ZERO);
                    initDataInputAPentryInfo.setInitPeriodAmtLocal(BigDecimal.ZERO);
                }
                initDataInputAPentryInfo.setInitYearAmt(initYearAmt);
                initDataInputAPentryInfo.setInitYearAmtLocal(this.convertLocalAmount(company, initYearAmtLocal));
                initDataInputAPentryInfo.setYearTotalDebitAmt(yearDebitFor);
                initDataInputAPentryInfo.setYearTotalDebitAmtLocal(this.convertLocalAmount(company, yearDebitLocal));
                initDataInputAPentryInfo.setYearTotalCreditAmt(yearCreditFor);
                initDataInputAPentryInfo.setYearTotalCreditAmtLocal(this.convertLocalAmount(company, yearCreditLocal));
                initDataInputAPentryInfo.setInitPeriodDirection(direction);
                initDataInputAPentryInfo.setInitYearDirection(direction);
                if (isCAA) {
                    String assistGrpID = rs.getString("FAssistGrpID");
                    this.setAPInitDataAsstAct(ctx, asstActType, assistGrpID, initDataInputAPentryInfo);
                    if (asstActType != null && !"FAdminOrgID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasAdminOrg(ctx, assActTypeCol)) {
                        initDataInputAPentryInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, assistGrpID));
                    }
                    if (asstActType != null && !"FPersonID".equalsIgnoreCase(asstActType.getMappingFieldName()) && this.hasPerson(ctx, assActTypeCol)) {
                        initDataInputAPentryInfo.setPerson(this.getPerson(ctx, assistGrpID));
                    }
                } else {
                    initDataInputAPentryInfo.setAcctCussType(asstActType);
                    initDataInputAPentryInfo.setAcctCussID(asstAct.getId().toString());
                }
                initDataInputAPentryInfo.setIsImpFromGL(true);
                initDataInputAPInfo.getEntrys().add(initDataInputAPentryInfo);
                iInitDataInputAP.impSubmit(initDataInputAPInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, OtherBillInfo otherBillInfo) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        otherBillInfo.setAsstActType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            otherBillInfo.setAsstActID(asstActRS.getString("FAsstActID"));
            otherBillInfo.setAsstActNumber(asstActRS.getString("FNumber"));
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L1"), this.L1);
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L2"), this.L2);
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L3"), this.L3);
        }
    }

    private void setAPAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        otherBillInfo.setAsstActType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            otherBillInfo.setAsstActID(asstActRS.getString("FAsstActID"));
            otherBillInfo.setAsstActNumber(asstActRS.getString("FNumber"));
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L1"), this.L1);
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L2"), this.L2);
            otherBillInfo.setAsstActName(asstActRS.getString("FName_L3"), this.L3);
        }
    }

    private void setARInitDataAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, InitDataInputARentryInfo initDataInputARentryInfo) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        initDataInputARentryInfo.setAcctCussType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            initDataInputARentryInfo.setAcctCussID(asstActRS.getString("FAsstActID"));
        }
    }

    private void setAPInitDataAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, InitDataInputAPentryInfo initDataInputAPentryInfo) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        initDataInputAPentryInfo.setAcctCussType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            initDataInputAPentryInfo.setAcctCussID(asstActRS.getString("FAsstActID"));
        }
    }

    private void setRBAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, ReceivingBillInfo receivingBillInfo, String language) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        receivingBillInfo.setPayerType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            receivingBillInfo.setPayerID(asstActRS.getString("FAsstActID"));
            receivingBillInfo.setPayerNumber(asstActRS.getString("FNumber"));
            if (LocaleUtils.getLocaleString((Locale)this.L1).equalsIgnoreCase(language)) {
                receivingBillInfo.setPayerName(asstActRS.getString("FName_l1"));
            } else if (LocaleUtils.getLocaleString((Locale)this.L2).equalsIgnoreCase(language)) {
                receivingBillInfo.setPayerName(asstActRS.getString("FName_l2"));
            } else if (LocaleUtils.getLocaleString((Locale)this.L3).equalsIgnoreCase(language)) {
                receivingBillInfo.setPayerName(asstActRS.getString("FName_l3"));
            }
        }
    }

    private void setPBAsstAct(Context ctx, AsstActTypeInfo asstActTypeInfo, String assistGrpID, PaymentBillInfo paymentBillInfo, String language) throws BOSException, SQLException, EASBizException {
        String mappingField = asstActTypeInfo.getMappingFieldName();
        String mappingTable = asstActTypeInfo.getRealtionDataObject();
        paymentBillInfo.setPayeeType(asstActTypeInfo);
        RowSet asstActRS = this.getAsstAct(ctx, assistGrpID, mappingField, mappingTable);
        if (asstActRS.next()) {
            paymentBillInfo.setPayeeID(asstActRS.getString("FAsstActID"));
            paymentBillInfo.setPayeeNumber(asstActRS.getString("FNumber"));
            if (LocaleUtils.getLocaleString((Locale)this.L1).equalsIgnoreCase(language)) {
                paymentBillInfo.setPayeeName(asstActRS.getString("FName_l1"));
            } else if (LocaleUtils.getLocaleString((Locale)this.L2).equalsIgnoreCase(language)) {
                paymentBillInfo.setPayeeName(asstActRS.getString("FName_l2"));
            } else if (LocaleUtils.getLocaleString((Locale)this.L3).equalsIgnoreCase(language)) {
                paymentBillInfo.setPayeeName(asstActRS.getString("FName_l3"));
            }
        }
    }

    private RowSet getAsstAct(Context ctx, String assistGrpID, String mappingField, String mappingTable) throws BOSException, SQLException {
        StringBuilder sb = new StringBuilder(150);
        sb.append("select t1.").append(mappingField).append(" as FAsstActID,").append(rt);
        sb.append(" t2.FNumber as FNumber,t2.FName_L1 as FName_L1, t2.FName_L2 as FName_L2,t2.FName_L3 as FName_L3 ").append(rt);
        sb.append(" from T_BD_AssistantHG t1 inner join ").append(rt);
        sb.append(mappingTable).append(" as t2 on t1.").append(mappingField).append("=t2.FID").append(rt);
        sb.append(" where t1.fid = '").append(assistGrpID).append("'").append(rt);
        sb.append(" and ").append(mappingField).append(" is not null").append(rt);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private MaterialInfo getMaterial(Context ctx, String assistGrpID) throws BOSException, EASBizException, SQLException {
        RowSet rs = this.getAsstAct(ctx, assistGrpID, "FMaterialID", "T_BD_Material");
        String materialID = rs.getString("FAsstActID");
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(materialID);
        return iMaterial.getMaterialInfo((IObjectPK)pk);
    }

    private AdminOrgUnitInfo getAdminOrgUnit(Context ctx, String assistGrpID) throws BOSException, SQLException, EASBizException {
        RowSet rs = this.getAsstAct(ctx, assistGrpID, "FAdminOrgID", "T_ORG_Admin");
        String asstActID = null;
        if (rs.next()) {
            asstActID = rs.getString("FAsstActID");
        }
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(asstActID);
        return iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)pk);
    }

    private PersonInfo getPerson(Context ctx, String assistGrpID) throws BOSException, SQLException, EASBizException {
        RowSet rs = this.getAsstAct(ctx, assistGrpID, "FPersonID", "T_BD_Person");
        String asstActID = null;
        if (rs.next()) {
            asstActID = rs.getString("FAsstActID");
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(asstActID);
        return iPerson.getPersonInfo((IObjectPK)pk);
    }

    private boolean hasCompareValue(Context ctx, AsstActTypeCollection assActTypeCol, String compareValue) throws BOSException, EASBizException {
        int size = assActTypeCol.size();
        for (int i = 0; i < size; ++i) {
            AsstActTypeInfo asstActTypeInfo = assActTypeCol.get(i);
            if (!compareValue.equalsIgnoreCase(asstActTypeInfo.getMappingFieldName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasCompareValue(Context ctx, AsstActTypeInfo asstActTypeInfo, String compareValue) throws BOSException, EASBizException {
        return compareValue.equalsIgnoreCase(asstActTypeInfo.getMappingFieldName());
    }

    private boolean hasCustomer(Context ctx, AsstActTypeCollection assActTypeCol) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, assActTypeCol, "FCustomerID");
    }

    private boolean hasCustomer(Context ctx, AsstActTypeInfo info) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, info, "FCustomerID");
    }

    private boolean hasSupplier(Context ctx, AsstActTypeCollection assActTypeCol) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, assActTypeCol, "FProviderID");
    }

    private boolean hasSupplier(Context ctx, AsstActTypeInfo info) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, info, "FProviderID");
    }

    private boolean hasAdminOrg(Context ctx, AsstActTypeCollection assActTypeCol) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, assActTypeCol, "FAdminOrgID");
    }

    private boolean hasAdminOrg(Context ctx, AsstActTypeInfo info) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, info, "FAdminOrgID");
    }

    private boolean hasPerson(Context ctx, AsstActTypeCollection assActTypeCol) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, assActTypeCol, "FPersonID");
    }

    private boolean hasPerson(Context ctx, AsstActTypeInfo info) throws BOSException, EASBizException {
        return this.hasCompareValue(ctx, info, "FPersonID");
    }

    private OtherBillTypeEnum getARBillType(VerificateBillTypeEnum bizType) {
        if (bizType == null) {
            return null;
        }
        OtherBillTypeEnum billType = null;
        if (bizType.getValue() == 2) {
            billType = OtherBillTypeEnum.getEnum((int)102);
        } else if (bizType.getValue() == 11) {
            billType = OtherBillTypeEnum.getEnum((int)103);
        } else if (bizType.getValue() == 8) {
            billType = OtherBillTypeEnum.getEnum((int)101);
        }
        return billType;
    }

    private OtherBillType getAPBillType(VerificateBillTypeEnum bizType) {
        if (bizType == null) {
            return null;
        }
        OtherBillType billType = null;
        if (bizType.getValue() == 0) {
            billType = OtherBillType.getEnum((int)202);
        } else if (bizType.getValue() == 10) {
            billType = OtherBillType.getEnum((int)203);
        } else if (bizType.getValue() == 9) {
            billType = OtherBillType.getEnum((int)201);
        }
        return billType;
    }

    private AsstActTypeCollection getAssistantAsstActType(Context ctx, AccountViewInfo accountViewInfo) throws BOSException {
        if (accountViewInfo == null || accountViewInfo.getCAA() == null) {
            return null;
        }
        AsstActTypeCollection assActTypeCol = null;
        String asstAccountID = accountViewInfo.getCAA().getId().toString();
        String sql = "SELECT FASSTACTTYPEID FROM T_BD_ASSTACTGROUPDETAIL WHERE FASSTACCOUNTID ='" + asstAccountID + "'";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        FilterItemCollection fic = filterinfo.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        view.setFilter(filterinfo);
        assActTypeCol = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        return assActTypeCol;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyID) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        return iCurrency.getCurrencyInfo((IObjectPK)pk);
    }

    private boolean isHasMaterial(Context ctx, AccountViewInfo accout) throws BOSException, EASBizException {
        AsstActGroupDetailCollection asstActGDColl = accout.getCAA().getAsstActGpDt();
        int size = asstActGDColl.size();
        for (int i = 0; i < size; ++i) {
            AsstActGroupDetailInfo info = asstActGDColl.get(i);
            AsstActTypeInfo asstActTypeInfo = this.getAsstActType(ctx, info.getAsstActType().getId().toString());
            if (!"FMaterialID".equalsIgnoreCase(asstActTypeInfo.getMappingFieldName())) continue;
            return true;
        }
        return false;
    }

    private AsstActTypeInfo getAsstActType(Context ctx, String asstActTypeID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(asstActTypeID);
        IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        return iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
    }

    public static Date changeDate(Date oldDate, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, day);
        Date dateDown = new Date(calendar.getTime().getTime());
        return dateDown;
    }

    private int getExchangratePrecisioin(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currencyInfo, Date billDate) throws EASBizException, BOSException {
        int precision = 0;
        ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, company, currencyInfo, billDate);
        precision = rateInfo != null ? rateInfo.getPrecision() : currencyInfo.getPrecision();
        return precision;
    }

    private BigDecimal convertLocalAmount(CompanyOrgUnitInfo company, BigDecimal amount) {
        CurrencyInfo currency;
        int precision = 0;
        if (company != null && (currency = company.getBaseCurrency()) != null) {
            precision = currency.getPrecision();
        }
        if (precision == 0) {
            precision = 2;
        }
        if (DataUtils.IsZeroBigDecimal(amount)) {
            return BigDecimal.ZERO;
        }
        return amount.setScale(precision, 4);
    }

    @Override
    protected void _importInitBill(Context ctx, Map filter) throws BOSException, EASBizException {
        VerificateBillTypeEnum bizType = null;
        if (filter.get("bizType") != null) {
            bizType = (VerificateBillTypeEnum)filter.get("bizType");
        }
        String system = filter.get("system").toString();
        if (null == bizType) {
            throw new ImpInitDataGLException(ImpInitDataGLException.NULL_BIZ_TYPE);
        }
        if ("AR".equalsIgnoreCase(system)) {
            if (bizType.getValue() == 2 || bizType.getValue() == 11 || bizType.getValue() == 8) {
                this.importAROtherBill(ctx, filter);
            } else if (bizType.getValue() == 7) {
                this.importReceivingBill(ctx, filter);
            }
        } else if (bizType.getValue() == 0 || bizType.getValue() == 10 || bizType.getValue() == 9) {
            this.importAPOtherBill(ctx, filter);
        } else if (bizType != null && bizType.getValue() == 5) {
            this.importPaymentBill(ctx, filter);
        }
    }

    @Override
    protected void _importBalanceFromGL(Context ctx, Map params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.get("company");
        PeriodInfo period = (PeriodInfo)params.get("period");
        String errorMsg = null == company ? " company is null." : "";
        if (!StringUtils.isEmpty((String)(errorMsg = errorMsg + (null == period ? " period is null." : "")))) {
            throw new BOSException("_importBalanceFromGL:" + errorMsg);
        }
        boolean isAr = params.get("isAR") != null && (Boolean)params.get("isAR") != false;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)(isAr ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE), (CompanyOrgUnitInfo)company);
        String companyId = company.getId().toString();
        int peridNum = startPeriod == null ? 0 : startPeriod.getNumber();
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, companyId, peridNum, isAr);
        String tableType = isContrastByBillAccount ? "BILL_ACCOUNT" : "ACCOUNT_NORMAL";
        String system = isAr ? "SYSTEM_AR" : "SYSTEM_AP";
        String tableName = CommonUtils.getARAPBalanceTable(system, tableType);
        String bosType = CommonUtils.getARAPBalanceID(system, tableType);
        PeriodInfo glStartPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        AccountTableInfo accountTable = company.getAccountTable();
        String accountTableID = null;
        if (null != accountTable) {
            accountTableID = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)accountTable.getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        }
        PeriodInfo fromPeriod = null;
        fromPeriod = PeriodUtils.PeriodCompare((PeriodInfo)startPeriod, (PeriodInfo)glStartPeriod) ? startPeriod : glStartPeriod;
        IRowSet rs = null;
        try {
            StringBuilder periodIDs = new StringBuilder(200);
            StringBuilder periodNumbers = new StringBuilder(60);
            int count = 0;
            while (fromPeriod.getNumber() < period.getNumber()) {
                if (count > 0) {
                    periodIDs.append(",");
                    periodNumbers.append(",");
                }
                periodIDs.append("'").append(fromPeriod.getId().toString()).append("'");
                periodNumbers.append(fromPeriod.getNumber());
                fromPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)fromPeriod);
                ++count;
            }
            StringBuilder buf = new StringBuilder(300);
            buf.append("DELETE FROM ").append(tableName).append(" WHERE FCompanyID = '").append(companyId).append("'").append(rt);
            buf.append(" AND FPeriodID IN ('").append(period.getId().toString()).append("'");
            if (periodIDs.length() != 0) {
                buf.append(",").append(periodIDs.toString());
            }
            buf.append(")");
            DBUtil.execute((Context)ctx, (String)buf.toString());
            buf.setLength(0);
            buf.append("SELECT ContrastAccount.FAccountID, AsstActType.FID AS FAsstActTypeID, AsstActType.FMappingFieldName ").append(rt).append(" FROM T_AR_CONTRASTACCOUNTVIEW ContrastAccount").append(rt).append(" LEFT JOIN T_BD_ASSTACTTYPE AsstActType ON ContrastAccount.FAsstActTypeID = AsstActType.FID").append(rt).append(" WHERE ContrastAccount.FCompanyID = ? AND ContrastAccount.FSystem = ?").append(rt).append(" AND ContrastAccount.FAccountTableID = ? AND ContrastAccount.FControlUnitID = ?").append(rt).append(" AND ContrastAccount.FPeriodYear = ? AND ContrastAccount.FPeriodNumber = ?");
            Object[] paramValue = new Object[]{companyId, isAr ? 1 : 2, accountTableID, company.getCU().getId().toString(), period.getPeriodYear(), period.getPeriodNumber()};
            rs = DBUtil.executeQuery((Context)ctx, (String)buf.toString(), (Object[])paramValue);
            StringBuilder selectSql = new StringBuilder(1200);
            StringBuilder preSelectSql = new StringBuilder(1200);
            String balType = isContrastByBillAccount ? "20" : String.valueOf(3);
            String sel_assistbalance_1f = "SELECT %s AS FBALTYPE, ASSISTBALANCE.FORGUNITID, PD.FID AS FPERIODID,  \r\n  ASSISTBALANCE.FCURRENCYID AS FCURRENCYID, ASSISTBALANCE.FACCOUNTID AS FACCOUNTID,  \r\n  '%s' AS FASSTACTTYPEID, HG.%s AS FASSTACTID, \r\n  'z' AS FADMINORGUNITID, 'z' AS FPERSONID, FBEGINBALANCEFOR, \r\n  FDEBITFOR, FCREDITFOR, FYEARDEBITFOR, FYEARCREDITFOR, FENDBALANCEFOR, \r\n  FBEGINBALANCELOCAL, FDEBITLOCAL, FCREDITLOCAL, FYEARDEBITLOCAL, FYEARCREDITLOCAL, FENDBALANCELOCAL \r\n  FROM T_GL_ASSISTBALANCE_1F ASSISTBALANCE \r\n  INNER JOIN T_BD_ASSISTANTHG HG ON ASSISTBALANCE.FASSISTGRPID = HG.FID \r\n ";
            String sel_accountbalance_1f = "SELECT %s AS FBALTYPE, FORGUNITID, PD.FID AS FPERIODID,  \r\n  FCURRENCYID, FACCOUNTID, 'z' AS FASSTACTTYPEID, 'z' AS FASSTACTID,  \r\n  'z' AS FADMINORGUNITID, 'z' AS FPERSONID, FBEGINBALANCEFOR,  \r\n  FDEBITFOR, FCREDITFOR, FYEARDEBITFOR, FYEARCREDITFOR, FENDBALANCEFOR,  \r\n  FBEGINBALANCELOCAL, FDEBITLOCAL, FCREDITLOCAL, FYEARDEBITLOCAL, FYEARCREDITLOCAL, FENDBALANCELOCAL  \r\n  FROM T_GL_ACCOUNTBALANCE_1F ASSISTBALANCE  \r\n ";
            String condition = " INNER JOIN T_ORG_COMPANY ORG ON ORG.FID = ASSISTBALANCE.FORGUNITID \r\n  INNER JOIN T_BD_PERIOD PD ON PD.FNUMBER = ASSISTBALANCE.FPERIOD AND PD.FTYPEID = ORG.FACCOUNTPERIODID \r\n  WHERE ASSISTBALANCE.FORGUNITID = '%s' \r\n  AND ASSISTBALANCE.FPERIOD = %s \r\n  %s  AND (ASSISTBALANCE.FBEGINBALANCEFOR <> 0 OR ASSISTBALANCE.FYEARDEBITFOR <> 0 OR ASSISTBALANCE.FYEARCREDITFOR <> 0) \r\n  AND ASSISTBALANCE.FACCOUNTID = '%s'";
            String pre_condition = " INNER JOIN T_BD_PERIOD PD ON PD.FNUMBER = ASSISTBALANCE.FPERIOD  \r\n  WHERE ASSISTBALANCE.FORGUNITID = '%s' \r\n  AND ASSISTBALANCE.FPERIOD IN ( %s ) \r\n  %s  AND ASSISTBALANCE.FACCOUNTID = '%s'";
            while (rs.next()) {
                if (selectSql.length() != 0) {
                    selectSql.append(rt).append(" UNION ALL ").append(rt);
                }
                if (rs.getString("FAsstActTypeID") != null) {
                    selectSql.append(String.format(sel_assistbalance_1f, balType, rs.getString("FAsstActTypeID"), rs.getString("FMappingFieldName"))).append(String.format(condition, companyId, period.getNumber(), " AND HG." + rs.getString("FMappingFieldName") + " IS NOT NULL" + rt, rs.getString("FAccountID")));
                } else {
                    selectSql.append(String.format(sel_accountbalance_1f, balType)).append(String.format(condition, companyId, period.getNumber(), "", rs.getString("FAccountID")));
                }
                if (preSelectSql.length() != 0) {
                    preSelectSql.append(rt).append(" UNION ALL ").append(rt);
                }
                if (periodIDs.length() == 0) continue;
                if (rs.getString("FAsstActTypeID") != null) {
                    preSelectSql.append(String.format(sel_assistbalance_1f, balType, rs.getString("FAsstActTypeID"), rs.getString("FMappingFieldName"))).append(String.format(pre_condition, companyId, periodNumbers.toString(), " AND HG." + rs.getString("FMappingFieldName") + " IS NOT NULL" + rt, rs.getString("FAccountID")));
                    continue;
                }
                preSelectSql.append(String.format(sel_accountbalance_1f, balType)).append(String.format(pre_condition, companyId, periodNumbers.toString(), "", rs.getString("FAccountID")));
            }
            StringBuilder basic_Insert_Buf = new StringBuilder(300).append("INSERT INTO ").append(tableName).append(" (FID, FBalType, FCompanyID, FPeriodID,").append(rt).append(" FCurrencyID, FAccount").append(", FAsstActTypeID, FAsstActID, FAdminOrgUnitID, FPersonID,").append(rt).append(" FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FEndBalanceFor,").append(rt).append(" FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FEndBalanceLocal)").append(rt).append(" SELECT ").append(bosType).append(" AS FID, FBalType, FOrgUnitID, FPeriodID,").append(rt).append(" FCurrencyID, FAccountID, FAsstActTypeID, FAsstActID, FAdminOrgUnitID, FPersonID,").append(rt).append(" FBeginBalanceFor, FDebitFor, FCreditFor, FYearDebitFor, FYearCreditFor, FEndBalanceFor,").append(rt).append(" FBeginBalanceLocal, FDebitLocal, FCreditLocal, FYearDebitLocal, FYearCreditLocal, FEndBalanceLocal").append(rt).append(" FROM ( SELECT FBalType, FOrgUnitID, FPeriodID, FCurrencyID, FAccountID, FAsstActTypeID,").append(rt).append(" FAsstActID, FAdminOrgUnitID, FPersonID, SUM(FBeginBalanceFor) AS FBeginBalanceFor,").append(rt);
            if (selectSql.length() != 0) {
                StringBuffer insertSql = new StringBuffer(2000);
                insertSql.append((CharSequence)basic_Insert_Buf);
                insertSql.append(" 0 FDebitFor, 0 FCreditFor, SUM(FYearDebitFor) - SUM(FDebitFor) FYearDebitFor, SUM(FYearCreditFor) - SUM(FCreditFor) FYearCreditFor,").append(rt);
                insertSql.append(" 0 FEndBalanceFor, SUM(FBeginBalanceLocal) FBeginBalanceLocal, 0 FDebitLocal, 0 FCreditLocal,").append(rt);
                insertSql.append(" SUM(FYearDebitLocal) - SUM(FDebitLocal) FYearDebitLocal, SUM(FYearCreditLocal) - SUM(FCreditLocal) FYearCreditLocal, 0 FEndBalanceLocal").append(rt);
                insertSql.append(" FROM (").append(selectSql.toString()).append(") bill").append(rt);
                insertSql.append(" GROUP BY FBalType, FOrgUnitID, FPeriodID, FCurrencyID, FAccountID, FAsstActTypeID, FAsstActID, FAdminOrgUnitID, FPersonID) as T1");
                DBUtil.execute((Context)ctx, (String)insertSql.toString());
            }
            if (preSelectSql.length() != 0) {
                StringBuffer preInsertSql = new StringBuffer(2000);
                preInsertSql.append((CharSequence)basic_Insert_Buf);
                preInsertSql.append(" SUM(FDebitFor) FDebitFor, SUM(FCreditFor) FCreditFor, SUM(FYearDebitFor) FYearDebitFor, SUM(FYearCreditFor) FYearCreditFor,").append(rt);
                preInsertSql.append(" SUM(FEndBalanceFor) FEndBalanceFor, SUM(FBeginBalanceLocal) FBeginBalanceLocal, SUM(FDebitLocal) FDebitLocal, SUM(FCreditLocal) FCreditLocal,").append(rt);
                preInsertSql.append(" SUM(FYearDebitLocal) FYearDebitLocal, SUM(FYearCreditLocal) FYearCreditLocal, SUM(FEndBalanceLocal) FEndBalanceLocal").append(rt);
                preInsertSql.append(" FROM (").append(preSelectSql.toString()).append(") bill").append(rt);
                preInsertSql.append(" GROUP BY FBalType, FOrgUnitID, FPeriodID, FCurrencyID, FAccountID, FAsstActTypeID, FAsstActID, FAdminOrgUnitID, FPersonID) as T1");
                DBUtil.execute((Context)ctx, (String)preInsertSql.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

