/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArShutAccountFactory;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IncomeConfimBillCollection;
import com.kingdee.eas.fi.ar.IncomeConfimBillFactory;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.IncomeConfimEntryCollection;
import com.kingdee.eas.fi.ar.IncomeConfimEntryFactory;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.IncomeConfirmBillException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.AbstractIncomeConfimBillControllerBean;
import com.kingdee.eas.fi.ar.app.service.IncomeConfirmBillReverseService;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.util.IncomeConfimUtil;
import com.kingdee.eas.fi.arap.app.reverse.ReverseFacatory;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeConfimBillControllerBean
extends AbstractIncomeConfimBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.IncomeConfimBillControllerBean");
    private String LOG_ITEM_APPOINTMENT_SUBJECT = "ar_income_confirm_bill_appoint_subject";
    private String SALE_ISSUE_BILL_BOS_TYPE = "CC3E933B";

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompany(), info.getBillDate());
        this.isExistedBill = info.getId() == null ? false : this.exists(ctx, "where id='" + info.getId().toString() + "'");
        if (this.isExistedBill) {
            this.addSQLLock(ctx, new ObjectUuidPK(info.getId()));
        }
        this.clearEmptyEntry(info);
        boolean isBillInShareFlow = false;
        if (null != info && null != info.getId() && null != info.getBillStatus()) {
            String billID = info.getId().toString();
            isBillInShareFlow = ArApBillUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, info.getBillStatus().getValue(), 2);
        }
        if (isBillInShareFlow) {
            return this._submit(ctx, model);
        }
        this.checkSourceCurrency(ctx, info.getEntries(), info.getCurrency().getId().toString(), IncomeConfimUtil.getResString("INMCOME_CONFIM_EDIT"));
        this.check4save(ctx, info, !this.isExistedBill);
        ArApBillHelper.calculate(ctx, info, null);
        this.setDefaultValue(ctx, info);
        super.checkNumber(ctx, info);
        this.doBeforeSaveSubmit(ctx, info);
        IObjectPK pk = null;
        pk = super._save(ctx, model);
        try {
            this.doAfterSaveSubmit(ctx, info);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return pk;
    }

    @Override
    protected void doAfterSaveSubmit(Context ctx, ArApBillBaseInfo info) throws BOSException, UuidException, SQLException, EASBizException {
        super.doAfterSaveSubmit(ctx, info);
        if (!this.isExistedBill) {
            DbUtil.execute((Context)ctx, (String)"update T_ar_IncomeConfimBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ?", (Object[])new String[]{info.getId().toString()});
        }
    }

    @Override
    protected void setDefaultValue(Context ctx, ArApBillBaseInfo billInfo) throws EASBizException, BOSException {
        super.setDefaultValue(ctx, billInfo);
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)billInfo;
        if (info.getTotalConfimAmount() == null) {
            info.setTotalConfimAmount(this.ZERO);
        }
        if (info.getTotalConfimAmountLoc() == null) {
            info.setTotalConfimAmountLoc(this.ZERO);
        }
        if (info.getCU() == null) {
            if (info.getCompany() != null) {
                info.setCU(info.getCompany().getCU());
            } else {
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
        }
        this.setYearAndPeriod(ctx, info);
        IncomeConfimEntryCollection collection = info.getEntry();
        if (info.isIsImportBill() && !BillStatusEnum.AUDITED.equals((Object)billInfo.getBillStatus())) {
            for (int i = 0; i < collection.size(); ++i) {
                IncomeConfimEntryInfo entry = collection.get(i);
                entry.setLockUnVerifyAmt(entry.getIncomeConfimAmount());
                entry.setLockUnVerifyAmtLocal(entry.getIncomeConfimAmountLoc());
                entry.setLockVerifyAmt(BigDecimal.ZERO);
                entry.setLockVerifyAmtLocal(BigDecimal.ZERO);
                entry.setLockQty(BigDecimal.ZERO);
                entry.setUnLockQty(entry.getQuantity());
                entry.setTotalArQty(BigDecimal.ZERO);
                entry.setTotalArAmount(BigDecimal.ZERO);
            }
        }
    }

    protected void check4save(Context ctx, ArApBillBaseInfo info, Boolean isAddNew) throws EASBizException, BOSException {
        super.check4save(ctx, info);
        SystemStatusCtrolInfo sysStatus = null;
        SystemEnum sysEnum = null;
        sysEnum = SystemEnum.ACCOUNTSRECEIVABLE;
        sysStatus = CommonServerUtils.getSysStatusCtrolInfo(ctx, info.getCompany(), sysEnum);
        if (sysStatus == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{sysEnum.getAlias()});
        }
        if (sysStatus.getStartPeriod() == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{sysEnum.getAlias()});
        }
        if (!isAddNew.booleanValue()) {
            AbstractArApBillBaseInfo oldBillInfo;
            try {
                oldBillInfo = (IncomeConfimBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), ArApSelectorFactory.getIncomeConfimBillSelector(true));
            }
            catch (Exception e) {
                oldBillInfo = null;
            }
            if (oldBillInfo.getBillStatus().getValue() == 2) {
                throw new OtherBillBizException(OtherBillBizException.SUBMMITED_CANNNOTSAVE);
            }
            if (oldBillInfo.getBillStatus().getValue() == 3) {
                throw new OtherBillBizException(OtherBillBizException.AUDIT_BILL_CANNOT_SAVE);
            }
            if (oldBillInfo.getBillStatus().getValue() == -1) {
                throw new ArApCommonException(ArApCommonException.IGNORE_CANNOT_UPDATE);
            }
        }
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.INCOMECONFIRM_ENTRIESCANNOTEMPTY);
        }
    }

    private boolean clearEmptyEntry(IncomeConfimBillInfo info) {
        boolean isChanged = false;
        int size = info.getEntry().size();
        for (int j = size - 1; j >= 0; --j) {
            IncomeConfimEntryInfo entry = info.getEntry().get(j);
            if (entry.getMaterial() != null || entry.getExpenseItem() != null) continue;
            info.getEntry().removeObject(j);
            isChanged = true;
        }
        info.sumEntry();
        return isChanged;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.submitBill(ctx, model, null);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.submitBill(ctx, model, pk);
    }

    protected IObjectPK submitBill(Context ctx, IObjectValue model, IObjectPK infoPk) throws BOSException, EASBizException {
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)model;
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_income_confirm_bill_batchSubmit");
        this.addSQLLock(ctx, info.getId());
        this.isExistedBill = info.getId() == null ? false : this.exists(ctx, "where id='" + info.getId().toString() + "'");
        if (info.getCompany() != null) {
            SystemStatusCtrolInfo arapStatus = CommonServerUtils.getSysStatusCtrolInfo(ctx, info.getCompany().getId().toString(), SystemEnum.ACCOUNTSRECEIVABLE);
            if (!info.isIsInitializeBill()) {
                if (arapStatus != null && arapStatus.getCurrentPeriod() != null && info.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                    throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
                }
            } else if (arapStatus != null && arapStatus.getStartPeriod() != null && !info.getBillDate().before(arapStatus.getStartPeriod().getBeginDate())) {
                throw new OtherBillBizException(OtherBillBizException.BILL_DATE_NEED_BEFORE_START_PERIOD);
            }
        }
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompany(), info.getBillDate());
        this.checkSourceCurrency(ctx, info.getEntries(), info.getCurrency().getId().toString(), IncomeConfimUtil.getResString("INMCOME_CONFIM_EDIT"));
        this.clearEmptyEntry(info);
        this.checkValid(ctx, info);
        if (BillStatusEnum.AUDITED == info.getBillStatus()) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        IObjectPK pk = null;
        info.setBillStatus(BillStatusEnum.SUBMITED);
        ArApBillHelper.calculate(ctx, info, null);
        this.setDefaultValue(ctx, info);
        super.checkNumber(ctx, info);
        IncomeConfimBillInfo oldModel = null;
        if (this.isExistedBill) {
            String id = info.get("id").toString();
            try {
                oldModel = (IncomeConfimBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(id), ArApSelectorFactory.getIncomeConfimBillSelector(true));
            }
            catch (Exception e) {
                oldModel = null;
            }
        }
        this.doBeforeSaveSubmit(ctx, info);
        if (null == infoPk) {
            pk = super._submit(ctx, (IObjectValue)info);
        } else {
            pk = infoPk;
            super._submit(ctx, infoPk, (IObjectValue)info);
        }
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
        String tableName = "T_AR_IncomeConfimEntry";
        boolean isHasBizFlow = false;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            isHasBizFlow = true;
        }
        if (isHasBizFlow) {
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.handleBillSubmit((Context)ctx, (IObjectValue)oldModel, (IObjectValue)info);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            ArApServerUtils.doWriteBack(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.resetBillChange((Context)ctx, (IObjectValue)model);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        try {
            this.doAfterSaveSubmit(ctx, info);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return pk;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (botpSelectors != null) {
            entityViewInfo.setSelector(botpSelectors);
        }
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("billStatus"));
        FilterInfo filterInfo = new FilterInfo();
        String strIdLists = StringUtils.arrayToString((Object[])sourceBillPkList, (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseCollection billColl = this.getCoreBillBaseCollection(ctx, entityViewInfo);
        ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
        block0: for (int i = 0; i < sourceBillPkList.length; ++i) {
            for (int j = 0; j < billColl.size(); ++j) {
                if (!sourceBillPkList[i].toString().equals(billColl.get(j).getId().toString())) continue;
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)BOSObjectType.create((String)IncomeConfimBillInfo.getBosType()), null, (String)billColl.get(i).getNumber(), (String)"ar_income_confirm_bill_makevoucher");
                logPks.add(logPk);
                allSourceBillCollection.addObject((IObjectValue)billColl.get(j));
                continue block0;
            }
        }
        DAPTransformResult result = super.generateVoucher(ctx, allSourceBillCollection, botMappingPK);
        for (IObjectPK logPk : logPks) {
            if (logPk == null) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        return result;
    }

    protected void checkValid(Context ctx, IncomeConfimBillInfo billInfo) throws EASBizException, BOSException {
        if (billInfo == null) {
            return;
        }
        if (billInfo.isIsReverseBill()) {
            return;
        }
        if (billInfo.getCompany() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
        }
        if (billInfo.getBillDate() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATE_NOTSET);
        }
        if (billInfo.getBizDate() == null) {
            throw new OtherBillBizException(OtherBillBizException.BIZDATE_NOTSET);
        }
        if (billInfo.getAsstActType() == null) {
            throw new OtherBillBizException(OtherBillBizException.ASSTACTTYPE_NOTSET);
        }
        if (billInfo.getAsstActID() == null) {
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTSET);
        }
        if (!this.isExistAsstActByCompany(ctx, billInfo.getCompany(), billInfo.getAsstActType(), billInfo.getAsstActID())) {
            SupplierInfo supp;
            CustomerInfo cust;
            AsstActTypeInfo assactTypeInfo = billInfo.getAsstActType();
            String relationDataObject = assactTypeInfo.getRealtionDataObject();
            if (relationDataObject == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("realtionDataObject"));
                assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()), selector);
                relationDataObject = assactTypeInfo.getRealtionDataObject();
            }
            boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
            boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
            String asstActId = billInfo.getAsstActID();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            String str = "";
            if (fCust && (cust = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(asstActId), sic)) != null) {
                str = cust.getName();
            }
            if (fSupp && (supp = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActId), sic)) != null) {
                str = supp.getName();
            }
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTBELONGCOMORG1, new Object[]{billInfo.getNumber(), str, billInfo.getCompany().getName()});
        }
        if (billInfo.getSourceBillType() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLTYPE_NOTSET);
        }
        if (billInfo.getBillType() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLTYPE_NOTSET);
        }
        if (billInfo.getCurrency() == null) {
            throw new OtherBillBizException(OtherBillBizException.CURRENCY_NOTSET);
        }
        if (billInfo.getExchangeRate() == null) {
            throw new OtherBillBizException(OtherBillBizException.EXCHANGERATE_NOTSET);
        }
        if (billInfo.getEntry() == null || billInfo.getEntry().size() == 0) {
            throw new OtherBillBizException(OtherBillBizException.ARBILL_ENTRIESCANNOTEMPTY);
        }
        for (int j = 0; j < billInfo.getEntry().size(); ++j) {
            IncomeConfimEntryInfo entry = billInfo.getEntry().get(j);
            if (entry.getMaterial() != null && entry.getMaterial().getAssistAttr() != null && entry.getAssistProperty() == null) {
                throw new OtherBillBizException(OtherBillBizException.ENTRY_ASSISTATTR_NOTSET, new Object[]{String.valueOf(j + 1)});
            }
            if (entry.getAccount() == null && billInfo.isIsInitializeBill()) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"ArSubject", (Locale)ctx.getOriginLocale())});
            }
            if (!entry.isIsPresent()) {
                entry.setTaxAmount(DataUtils.nullToZero(entry.getTaxAmount()));
                entry.setIncomeConfimAmount(DataUtils.nullToZero(entry.getIncomeConfimAmount()));
                if (entry.getAmount() != null && entry.getIncomeConfimAmount().compareTo(entry.getAmount().add(entry.getTaxAmount())) != 0) {
                    throw new IncomeConfirmBillException(IncomeConfirmBillException.ENTRYAMOUNTNOTEQUALTAX);
                }
                if (entry.getLockVerifyAmt() != null && entry.getLockUnVerifyAmt() != null && entry.getIncomeConfimAmount().compareTo(entry.getLockVerifyAmt().add(entry.getLockUnVerifyAmt())) != 0 && !billInfo.isIsAllowanceBill()) {
                    throw new IncomeConfirmBillException(IncomeConfirmBillException.ENTRYAMOUNTNOTEQUALLOCKVERIFY);
                }
            }
            if (entry.getQuantity() != null && this.ZERO.compareTo(entry.getQuantity()) != 0) continue;
            throw new OtherBillBizException(OtherBillBizException.QTY_NOTSET);
        }
        if (BillStatusEnum.SUBMITED.equals((Object)billInfo.getBillStatus()) && billInfo.getId() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("billStatus"));
            IncomeConfimBillInfo oldInfo = IncomeConfimBillFactory.getLocalInstance(ctx).getIncomeConfimBillInfo((IObjectPK)new ObjectStringPK(billInfo.getId().toString()), selector);
            if (oldInfo != null && !oldInfo.getBillStatus().equals((Object)BillStatusEnum.SAVE) && !oldInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMITED)) {
                throw new OtherBillBizException(OtherBillBizException.BILLSTATUS_NOTSAVEDANDSUBMITED);
            }
        }
        if (!billInfo.isIsReverseBill() && !this.isExistedBill) {
            this.check4save(ctx, billInfo);
        }
        this.check4submit(ctx, billInfo);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        this.addSQLLock(ctx, pk);
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        IncomeConfimBillInfo info = this.getIncomeConfimBillInfo(ctx, pk, ArApSelectorFactory.getIncomeConfimBillSelector(true));
        this.checkStatus4Audit(ctx, info);
        this.cacheParamForAudit(ctx, info);
        String tableName = "T_AR_IncomeConfimEntry";
        if (!SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) || !SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            this.check4QtyNotGreater(ctx, info);
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        info.setAuditor(currentUser);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        if (this.getBooleanParamValue(ctx, "ARBILL_IS_SAME_PERSON") && ArApBillHelper.idEquals((CoreBaseInfo)info.getCreator(), (CoreBaseInfo)info.getAuditor()) && !info.isIsReverseBill()) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAME_PERSON);
        }
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.AUDIT);
        info.setBillStatus(BillStatusEnum.AUDITED);
        this.updatePartial(ctx, (CoreBaseInfo)info, this.getSelectorForAudit());
        this.writeBackSCMBill(ctx, info, BizActionEnum.AUDIT);
        if (this.isReqSCMCalculate(ctx, info)) {
            ICalculateFacade icf = CalculateFacadeFactory.getLocalInstance((Context)ctx);
            icf.calculate((CoreBillBaseInfo)info);
        }
        boolean isCoreReverse = this.getBooleanParamValue(ctx, "AR_BIZ_reverse_01");
        ReverseFacatory.getInstance(ctx, info, this, isCoreReverse).doReverse();
    }

    protected boolean isReqSCMCalculate(Context ctx, IncomeConfimBillInfo info) throws EASBizException, BOSException {
        if (info.isIsReverseBill()) {
            return false;
        }
        if (info.getSourceBillType() == null || VerificateBillTypeEnum.OTHER.equals((Object)info.getSourceBillType())) {
            return false;
        }
        if (null == this.isRelationSCM) {
            boolean isStartparam = ArApParamHelper.isRelationSCM(ctx, info.getCompany().getId().toString(), this._getOwnedSys(ctx));
            this.isRelationSCM = isStartparam;
        }
        return info.isIsSCMBill() || this.isRelationSCM != false;
    }

    private void check4QtyNotGreater(Context ctx, IncomeConfimBillInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.isIsReverseBill()) {
            return;
        }
        if (info.isBotpBill()) {
            boolean arQtyGtSiQty = this.getBooleanParamValue(ctx, "AR_QTY_CANT_GT_SI");
            BillTypeInfo coreBillType = null;
            boolean exeistsReturnsBill = false;
            boolean exeistsTansferBill = false;
            String coreBillTypeID = null;
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                coreBillType = info.getEntry().get(i).getCoreBillType();
                String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
                if (VerificateBillTypeEnum.SaleIssueBill.equals((Object)info.getSourceBillType()) && ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID))) {
                    exeistsReturnsBill = true;
                    break;
                }
                if (!VerificateBillTypeEnum.SaleIssueBill.equals((Object)info.getSourceBillType()) || !"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeID)) continue;
                exeistsTansferBill = true;
                break;
            }
            if (arQtyGtSiQty && exeistsReturnsBill) {
                StringBuffer selectQuerySQL = new StringBuffer("");
                selectQuerySQL.append("SELECT INCOMEBILLENTRY.FSEQ AS FSEQ,INCOMEBILL.FNUMBER AS FNUMBER, SALEISSUEBILL.FNUMBER AS FWBNUMBER,SALEISSUEBILLE.FSEQ AS FWBSEQ");
                selectQuerySQL.append(" FROM T_AR_IncomeConfimBill INCOMEBILL INNER JOIN T_AR_IncomeConfimEntry INCOMEBILLENTRY ON INCOMEBILL.FID = INCOMEBILLENTRY.FPARENTID");
                selectQuerySQL.append(" INNER JOIN T_IM_SALEISSUEENTRY SALEISSUEBILLE ON SALEISSUEBILLE.FID = INCOMEBILLENTRY.FSOURCEBILLENTRYID ");
                selectQuerySQL.append(" INNER JOIN T_IM_SALEISSUEBILL SALEISSUEBILL ON SALEISSUEBILL.FID=SALEISSUEBILLE.FParentID");
                selectQuerySQL.append(" WHERE INCOMEBILL.FID = ?");
                selectQuerySQL.append(" AND ABS(INCOMEBILLENTRY.FBaseQty) > ABS(SALEISSUEBILLE.FUnWriteOffBaseQty)");
                selectQuerySQL.append(" AND (INCOMEBILLENTRY.FcoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552");
                selectQuerySQL.append("' OR INCOMEBILLENTRY.FcoreBillTypeID='").append("50957179-0105-1000-e000-015bc0a812fd463ED552").append("')");
                selectQuerySQL.append(" order by SALEISSUEBILLE.FSEQ ASC");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString(), (Object[])new String[]{info.getId().toString()});
                StringBuffer sql = new StringBuffer("");
                boolean isError = false;
                try {
                    while (rowSet.next()) {
                        isError = true;
                        sql.append(this.getResStr(ctx, "AR_ISSUEQTYGTARQTY")).append("\n");
                        sql.append(this.getResStr(ctx, "ARNO")).append(":");
                        sql.append(rowSet.getString("FNumber")).append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SEQNO", (Locale)ctx.getOriginLocale())).append(":");
                        sql.append(rowSet.getInt("FSeq")).append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"WBNO", (Locale)ctx.getOriginLocale())).append("-->");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SALEISSUE", (Locale)ctx.getOriginLocale()));
                        sql.append(":").append(rowSet.getString("FWBNumber")).append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SEQNO", (Locale)ctx.getOriginLocale())).append(":");
                        sql.append(rowSet.getInt("FWBSeq")).append("\n");
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)("sql is :" + selectQuerySQL.toString()), (Throwable)e);
                    throw new BOSException("sql is :" + selectQuerySQL.toString(), (Throwable)e);
                }
                if (isError) {
                    throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
                }
            } else if (arQtyGtSiQty && exeistsTansferBill) {
                StringBuffer bf = new StringBuffer();
                bf.append(" select  ");
                bf.append(" T_IM_SALEISSUEBILL.fnumber as number, ");
                bf.append(" T_IM_SALEISSUEENTRY.fseq as imseq, ");
                bf.append(" T_IM_SALEISSUEENTRY.funWriteOffBaseQty as unWriteOffBaseQty, ");
                bf.append(" T_AR_IncomeConfimEntry.fseq as arseq, ");
                bf.append(" T_AR_IncomeConfimEntry.funwriteOffBaseQty as arunwriteOffBaseQty ");
                bf.append(" from T_AR_IncomeConfimBill ");
                bf.append(" inner join T_AR_IncomeConfimEntry on T_AR_IncomeConfimBill.fid = T_AR_IncomeConfimEntry.fparentid ");
                bf.append(" inner join T_IM_SALEISSUEENTRY on T_IM_SALEISSUEENTRY.fid = T_AR_IncomeConfimEntry.FSourceBillEntryId ");
                bf.append(" inner join T_IM_SALEISSUEBILL on T_IM_SALEISSUEBILL.fid = T_IM_SALEISSUEENTRY.fparentid ");
                bf.append(" where T_AR_IncomeConfimBill.fid= ?");
                String number = null;
                BigDecimal unWriteOffBaseQty = this.ZERO;
                BigDecimal arunWriteOffBaseQty = this.ZERO;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)bf.toString(), (Object[])new String[]{info.getId().toString()});
                try {
                    while (rs.next()) {
                        number = rs.getString("number");
                        unWriteOffBaseQty = rs.getBigDecimal("unWriteOffBaseQty") != null ? rs.getBigDecimal("unWriteOffBaseQty") : this.ZERO;
                        arunWriteOffBaseQty = rs.getBigDecimal("arunWriteOffBaseQty") != null ? rs.getBigDecimal("arunWriteOffBaseQty") : this.ZERO;
                        if (arunWriteOffBaseQty.abs().compareTo(unWriteOffBaseQty.abs()) <= 0) continue;
                        throw new IncomeConfirmBillException(IncomeConfirmBillException.WRITEPURINWAREHSBILLERROR, new Object[]{info.getNumber(), new Integer(rs.getInt("arseq")), number, new Integer(rs.getInt("imseq"))});
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)("sql is :" + bf.toString()), (Throwable)e);
                    throw new BOSException("sql is :" + bf.toString(), (Throwable)e);
                }
            }
        }
    }

    protected void cacheParamForAudit(Context ctx, IncomeConfimBillInfo info) {
        if (info.getCompany() == null) {
            return;
        }
        String currentCompanyId = info.getCompany().getId().toString();
        HashMap paramMap = new HashMap();
        paramMap.put("ARBILL_IS_SAME_PERSON", currentCompanyId);
        paramMap.put("CURRENCYSALE_AUTO_GEN_RECBILL", currentCompanyId);
        paramMap.put("AR_SCM_001", currentCompanyId);
        paramMap.put("AR_QTY_GT_SO", currentCompanyId);
        paramMap.put("AR_QTY_CANT_GT_SI", currentCompanyId);
        paramMap.put("CONSIGNSALES", currentCompanyId);
        paramMap.put("IS_ARAP_CORP_BILL", currentCompanyId);
        paramMap.put("AR_037", currentCompanyId);
        paramMap.put("AR_COOP_BILL_IS_EDIT", currentCompanyId);
        paramMap.put("AR_BIZ_reverse_01", currentCompanyId);
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        this.paramKeyMap.putAll(paramMap);
    }

    protected void cacheParamForUnAudit(Context ctx, IncomeConfimBillInfo info) {
        String currentCompanyId = info.getCompany().getId().toString();
        HashMap paramMap = new HashMap();
        paramMap.put("AR_SCM_001", currentCompanyId);
        paramMap.put("AR_COOP_BILL_IS_EDIT", currentCompanyId);
        paramMap.put("AR_034", currentCompanyId);
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        this.paramKeyMap.putAll(paramMap);
    }

    @Override
    protected HashMap _appointmentAccount(Context ctx, IObjectPK[] pk, AccountViewInfo accountViewInfo, AccountViewInfo oppAccountInfo) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
        if (pk == null || pk.length == 0) {
            return hashMap;
        }
        ObjectUuidPK opk = new ObjectUuidPK(pk[0].toString());
        BOSObjectType bosType = opk.getObjectType();
        String bostypeStr = bosType.toString();
        StringBuffer strBuf = new StringBuffer();
        int j = pk.length - 1;
        for (int i = 0; i <= j; ++i) {
            strBuf.append("'").append(pk[i].toString()).append("'");
            if (i == j) continue;
            strBuf.append(",");
        }
        if ("A8378ABC".equals(bostypeStr)) {
            IncomeConfimBillCollection collection = this.getIncomeConfimBillCollection(ctx, "where id in (" + strBuf + ")");
            PeriodInfo currentPeriod = null;
            for (int i = 0; i < pk.length; ++i) {
                IncomeConfimBillInfo billInfo = collection.get(i);
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)billInfo.getBOSType(), null, (String)billInfo.getNumber(), (String)this.LOG_ITEM_APPOINTMENT_SUBJECT);
                if (!billInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_UNAUDIT_NOT);
                }
                if (currentPeriod == null) {
                    currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, billInfo.getCompany());
                }
                if (billInfo.getBillDate().before(currentPeriod.getBeginDate())) {
                    throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT);
                }
                AbstractObjectCollection entryCollection = billInfo.getEntries();
                for (ArApBillEntryBaseInfo arApEntry : entryCollection) {
                    if (accountViewInfo != null && accountViewInfo.getId() != null) {
                        arApEntry.setAccount(accountViewInfo);
                    }
                    if (oppAccountInfo == null || oppAccountInfo.getId() == null) continue;
                    arApEntry.setOppAccount(oppAccountInfo);
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        } else {
            int i;
            String ids = ArrayUtil.getStringFromArr((Object[])pk);
            HashSet<String> set = new HashSet<String>();
            int size = pk.length;
            for (int i2 = 0; i2 < size; ++i2) {
                set.add(pk[i2].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("seq");
            sic.add("head.id");
            sic.add("head.number");
            sic.add("head.billDate");
            sic.add("head.billStatus");
            sic.add("head.company.id");
            sic.add("head.sourceBillType");
            sic.add("account");
            sic.add("oppAccount");
            view.setSelector(sic);
            IncomeConfimEntryCollection collection = IncomeConfimEntryFactory.getLocalInstance(ctx).getIncomeConfimEntryCollection(view);
            HashSet<String> numberSet = new HashSet<String>(collection.size());
            ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>(collection.size());
            if (collection != null && collection.size() > 0) {
                PeriodInfo currentPeriod = null;
                int size2 = collection.size();
                for (i = 0; i < size2; ++i) {
                    IncomeConfimEntryInfo entry = collection.get(0);
                    IncomeConfimBillInfo info = entry.getHead();
                    if (!numberSet.contains(info.getNumber())) {
                        numberSet.add(info.getNumber());
                        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)this.LOG_ITEM_APPOINTMENT_SUBJECT);
                        logPks.add(logPK);
                    }
                    if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                        throw new OtherBillBizException(OtherBillBizException.ENTRY_POINT_SUBJECT_UNAUDIT_NOT, new Object[]{info.getNumber(), entry.getSeq()});
                    }
                    if (currentPeriod == null) {
                        currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
                    }
                    if (info.getBillDate().before(currentPeriod.getBeginDate())) {
                        throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT_1, new Object[]{info.getNumber(), entry.getSeq()});
                    }
                    if (accountViewInfo != null && accountViewInfo.getId() != null) {
                        entry.setAccount(accountViewInfo);
                    }
                    if (oppAccountInfo == null || oppAccountInfo.getId() == null) continue;
                    entry.setOppAccount(oppAccountInfo);
                }
            }
            StringBuilder sql = new StringBuilder(300);
            sql.append("update T_AR_IncomeConfimEntry ");
            if (accountViewInfo != null && oppAccountInfo != null && accountViewInfo.getId() != null && oppAccountInfo.getId() != null) {
                sql.append("set FAccountID='" + accountViewInfo.getId().toString() + "',FOppAccountID='" + oppAccountInfo.getId().toString());
            } else if (accountViewInfo != null && accountViewInfo.getId() != null) {
                sql.append("set FAccountID='" + accountViewInfo.getId().toString());
            } else if (oppAccountInfo != null && oppAccountInfo.getId() != null) {
                sql.append("set FOppAccountID='" + oppAccountInfo.getId().toString());
            }
            sql.append("' where fid in (" + ids + ")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            for (i = 0; i < logPks.size(); ++i) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)((IObjectPK)logPks.get(i)));
            }
        }
        hashMap.put("Msg", sb);
        return hashMap;
    }

    @Override
    protected void _cancelAppointmentAccount(Context ctx, IObjectPK pk, Boolean bizAccountFlag, Boolean oppAccountFlag) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        IncomeConfimBillInfo info = this.getIncomeConfimBillInfo(ctx, pk);
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELSUBJECT_UNAUDIT_NOT);
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
        if (info.getBillDate().before(currentPeriod.getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELSUBJECT_INITBILL_NOT);
        }
        AbstractObjectCollection collection = info.getEntries();
        for (ArApBillEntryBaseInfo entry : collection) {
            if (bizAccountFlag.booleanValue()) {
                entry.setAccount(null);
            }
            if (!oppAccountFlag.booleanValue()) continue;
            entry.setOppAccount(null);
        }
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks, CoreBillBaseCollection coreBillCollection) throws BOSException, EASBizException {
        for (int i = 0; i < pks.length; ++i) {
            IObjectPK pk = pks[i];
            this.unpassAudit(ctx, pk, null);
        }
    }

    public void unpassAudit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        IncomeConfimBillInfo info = model != null ? (IncomeConfimBillInfo)model : this.getIncomeConfimBillInfo(ctx, pk, ArApSelectorFactory.getIncomeConfimBillSelector(true));
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_income_confirm_bill_antiAudit");
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        this.addSQLLock(ctx, pk);
        this.checkUnAudit(ctx, info);
        info.setAuditDate(null);
        info.setAuditor(null);
        info.setBillStatus(BillStatusEnum.SAVE);
        this.updatePartial(ctx, (CoreBaseInfo)info, this.getSelectorForAudit());
        EnactmentServiceFactory.createEnactService((Context)ctx).abortProcessByHoldedObjectId(pk.toString());
        IManualWriteOffFacade m = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
        m.inverseWriteOff(new String[]{pk.toString()});
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.UNAUDIT);
        this.writeBackSCMBill(ctx, info, BizActionEnum.UNAUDIT);
        this.dealReverseBill(ctx, info);
        this.dealReverseBizBill(ctx, info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void dealReverseBizBill(Context ctx, IncomeConfimBillInfo info) throws BOSException, EASBizException {
        try {
            HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
            ids.add(info.getId());
            IRowSet rowSet = this.getReversedBizBillByFiBill(ctx, ids, true);
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    if (rowSet.getInt("FFiVouchered") != 1) continue;
                    throw new OtherBillBizException(OtherBillBizException.BIZBILLCANNOTREVERSED, new String[]{""});
                }
                rowSet.beforeFirst();
                this.unReversedBizARAP(ctx, rowSet, info.getCompany(), true);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void dealReverseBill(Context ctx, IncomeConfimBillInfo info) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || !info.isIsReverseBill()) {
            return;
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        IncomeConfimBillInfo recycleInfo = (IncomeConfimBillInfo)info.clone();
        String billid = info.getId().toString();
        String sourceBillid = info.getSourceBillId();
        StringBuilder sql = new StringBuilder(100);
        sql.append("UPDATE T_AR_IncomeConfimBill SET FUnVerifyAmount = FAmount, FUnVerifyAmountLocal = FAmountLocal , ");
        sql.append("FVerifyAmount = 0, FVerifyAmountLocal = 0 ,FIsReversed=0 ");
        sql.append(" WHERE fid = '" + sourceBillid + "'");
        sqlList.add(sql.toString());
        sql.setLength(0);
        sql.append("update T_AR_IncomeConfimEntry set FLockVerifyAmt=0,FLockVerifyAmtLocal=0 ");
        sql.append(" ,FLocalWrittenOffAmount = 0,FWrittenOffBaseQty = 0 ");
        sql.append(" ,FLockQty = 0, FLockBaseQty = 0 ");
        sql.append(" ,FUnwriteOffBaseQty = FBaseQty, FLocalUnwriteOffAmount = FIncomeConfimAmountLoc ");
        sql.append(" ,FLockUnVerifyAmt= FIncomeConfimAmount,FLockUnVerifyAmtLocal = FIncomeConfimAmountLoc ");
        sql.append(" ,FUnLockQty = FQuantity, FUnLockBaseQty = FBaseQty ");
        sql.append(" where fparentid = '" + sourceBillid + "'");
        sqlList.add(sql.toString());
        sql.setLength(0);
        sql.append("delete from T_AR_IncomeConfimEntry where fparentid = '" + billid + "'");
        sqlList.add(sql.toString());
        sql.setLength(0);
        sql.append("delete from T_AR_IncomeConfimBill where fid = '" + billid + "'");
        sqlList.add(sql.toString());
        sql.setLength(0);
        sql.append("delete from t_bot_relation where fsrcobjectid='").append(sourceBillid).append("' and foperatorid='unknown' ");
        sql.append("and fdestobjectid = '" + billid + "'");
        sqlList.add(sql.toString());
        sql.setLength(0);
        DBUtil.execBatchSql((Context)ctx, sqlList, (boolean)true);
        if (recycleInfo != null) {
            this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(recycleInfo.getId().toString()), recycleInfo, true);
        }
    }

    protected void writeBackSCMBill(Context ctx, IncomeConfimBillInfo info, BizActionEnum bizActionEnum) throws EASBizException, BOSException {
        BizActionEnum reverse;
        BizActionEnum positive;
        if (info == null) {
            return;
        }
        if (info.getSourceBillType() == null || VerificateBillTypeEnum.OTHER.equals((Object)info.getSourceBillType())) {
            return;
        }
        if (BizActionEnum.AUDIT.equals((Object)bizActionEnum)) {
            positive = BizActionEnum.AUDIT;
            reverse = BizActionEnum.UNAUDIT;
        } else if (BizActionEnum.UNAUDIT.equals((Object)bizActionEnum)) {
            reverse = BizActionEnum.AUDIT;
            positive = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        String id = info.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select fSourceBillId,fCoreBillId from T_AR_IncomeConfimEntry where fparentid = ? group by fSourceBillId,fCoreBillId");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        int rsSize = rowSet.size();
        String[] srcIdArr = new String[rsSize];
        String[][] idList = new String[rsSize][2];
        int i = 0;
        try {
            while (rowSet.next()) {
                idList[i][0] = rowSet.getString(1);
                idList[i][1] = rowSet.getString(2);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)this.getBOSType(), (String[])srcIdArr);
        if (info.isIsReverseBill()) {
            for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, reverse, new String[]{info.getSourceBillId()}, idList);
            }
        } else {
            for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, positive, new String[]{id}, idList);
            }
        }
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected String getTableNameForReverseSave() {
        return "T_AR_IncomeConfimBill";
    }

    @Override
    protected void _delVoucher(Context ctx, String billId) throws BOSException, EASBizException {
    }

    @Override
    protected int _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        int success = 0;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.setSelector(ArApSelectorFactory.getIncomeConfimBillSelector(true));
        IncomeConfimBillCollection collection = this.getIncomeConfimBillCollection(ctx, entityView);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (collection.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < collection.size(); ++i) {
            IncomeConfimBillInfo bill = collection.get(i);
            BOTRelationCollection btpRelationCollection = iBTPManager.getRelationCollection(bill.get("id").toString());
            iBTPManager.submitRelations((CoreBillBaseInfo)bill, btpRelationCollection);
            ++success;
        }
        return success;
    }

    @Override
    protected void _ignore(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        this.addSQLLock(ctx, id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billStatus");
        sic.add("company.id");
        IncomeConfimBillInfo billInfo = this.getIncomeConfimBillInfo(ctx, id, sic);
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)billInfo.getBOSType(), null, (String)billInfo.getNumber(), (String)"ar_income_confirm_bill_ignore", (String)billInfo.getCompany().getId().toString());
        this.checkIgnore(ctx, billInfo);
        billInfo.setBillStatus(BillStatusEnum.DELETED);
        this.updatePartial(ctx, (CoreBaseInfo)billInfo, sic);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        this.addSQLLock(ctx, pk);
        super.isCanDelete(ctx, pk, coreBillInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billStatus");
        IncomeConfimBillInfo billInfo = this.getIncomeConfimBillInfo(ctx, pk, sic);
        this.checkDelete(ctx, billInfo);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.recycleNumber(ctx, pk, null, true);
        super._delete(ctx, pk);
    }

    private void checkUnAudit(Context ctx, IncomeConfimBillInfo info) throws EASBizException, BOSException {
        UserInfo currentUser;
        this.cacheParamForUnAudit(ctx, info);
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (info.isIsInitializeBill()) {
            throw new OtherBillBizException(OtherBillBizException.DISALLOWANCE_INITIALIZEBILL_UNAUDIT);
        }
        if (info.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
        }
        if (info.isIsReversed()) {
            throw new OtherBillBizException(OtherBillBizException.REVERSED);
        }
        boolean ar034 = this.getBooleanParamValue(ctx, "AR_034");
        if (ar034 && !ArApBillHelper.idEquals((CoreBaseInfo)(currentUser = CommonServerUtils.getCurrentUser(ctx)), (CoreBaseInfo)info.getAuditor())) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAMEAUDITOR_PERSON);
        }
        Iterator iterator = info.getEntries().iterator();
        HashSet<String> coreBillEntryIdSet = new HashSet<String>();
        BOSObjectType saleOrderEntryBosType = new SaleOrderEntryInfo().getBOSType();
        while (iterator.hasNext()) {
            BOSObjectType coreBillEntryBosType;
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)iterator.next();
            String coreBillEntryId = entryInfo.getCoreBillEntryId();
            if (coreBillEntryId == null || !saleOrderEntryBosType.equals((Object)(coreBillEntryBosType = BOSUuid.read((String)coreBillEntryId).getType()))) continue;
            coreBillEntryIdSet.add(coreBillEntryId);
        }
        if (coreBillEntryIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("id", coreBillEntryIdSet, CompareType.INCLUDE);
            FilterItemInfo filterItem2 = new FilterItemInfo("baseStatus", (Object)6, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            IDynamicObject iDyna = DynamicObjectFactory.getLocalInstance((Context)ctx);
            if (iDyna.exists(saleOrderEntryBosType, filter)) {
                throw new OtherBillBizException(OtherBillBizException.COREBILLSTATUSERROR, new Object[]{EntryBaseStatusEnum.BLOCKED.getAlias()});
            }
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("destEntityID"));
        ev.getSelector().add(new SelectorItemInfo("destObjectID"));
        ev.getSelector().add(new SelectorItemInfo("type"));
        FilterItemInfo filterItem1 = new FilterItemInfo("srcEntityID", (Object)this.getBOSType().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("srcObjectID", (Object)info.getId());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.setFilter(filter);
        BOTRelationCollection botRelationCol = iBOTRelation.getCollection(ev);
        if (botRelationCol.size() > 0) {
            throw new OtherBillBizException(OtherBillBizException.HASDESTBILL);
        }
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeBizProcess(info.getCompany(), info.getBillDate());
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompany(), info.getBillDate());
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void checkDelete(Context ctx, IncomeConfimBillInfo info) throws EASBizException, BOSException {
        this.commonCheck(ctx, info);
    }

    protected void checkIgnore(Context ctx, IncomeConfimBillInfo info) throws EASBizException, BOSException {
        this.commonCheck(ctx, info);
        if (BTPManagerFactory.getLocalInstance((Context)ctx).ifHaveDestBills(info.getId().toString())) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.IGNORE_FAIL_REASON);
        }
    }

    protected void commonCheck(Context ctx, IncomeConfimBillInfo info) throws EASBizException, BOSException {
        if (info == null) {
            throw new ObjectNotFoundException(ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale()));
        }
        if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.IGNORE_FAIL_REASON);
        }
        if (!BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) && !BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus())) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.IGNORE_FAIL_REASON);
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected void _splitBill(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        IncomeConfimBillInfo info = null;
        IncomeConfimBillInfo motherBillInfo = null;
        IncomeConfimBillInfo childBillInfo = null;
        info = this.getIncomeConfimBillInfo(ctx, billId, ArApSelectorFactory.getIncomeConfimBillSelector(true));
        this.canSplit(ctx, info);
        motherBillInfo = (IncomeConfimBillInfo)info.clone();
        childBillInfo = (IncomeConfimBillInfo)info.clone();
        String childNumber = this.getChildNumber(ctx, motherBillInfo.getNumber(), motherBillInfo.getCompany().getId().toString(), 1);
        childBillInfo.setId(null);
        childBillInfo.setNumber(childNumber);
        IncomeConfimEntryCollection motherEntryCollection = motherBillInfo.getEntry();
        IncomeConfimEntryCollection childEntryCollection = childBillInfo.getEntry();
        IncomeConfimEntryInfo motherEntryInfo = null;
        IncomeConfimEntryInfo childEntryInfo = null;
        HashMap<String, Integer> assistUnitQtyPrecision = new HashMap<String, Integer>();
        this.cacheAssistQtyPrecision(ctx, motherBillInfo, assistUnitQtyPrecision);
        int k = motherEntryCollection.size();
        for (int j = 0; j < k; ++j) {
            motherEntryInfo = motherEntryCollection.get(j);
            childEntryInfo = childEntryCollection.get(j);
            childEntryInfo.setId(null);
            childEntryInfo.setHead(null);
            this.splitBillEntry(ctx, motherEntryInfo, childEntryInfo, info);
        }
        motherBillInfo.setIsSplitBill(true);
        motherBillInfo.setAmountLocal(this.ZERO);
        ArApBillHelper.calculate(ctx, motherBillInfo, null);
        this.splitChildInfo(ctx, info, motherBillInfo, childBillInfo, assistUnitQtyPrecision);
        IncomeConfimEntryInfo entryInfo = null;
        Iterator childIterator = childEntryCollection.iterator();
        while (childIterator.hasNext()) {
            entryInfo = (IncomeConfimEntryInfo)childIterator.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            entryInfo.setBaseQty(this.ONE);
        }
        LogControllManager.getInstance().enableLog();
        IObjectPK childBillPK = super._submit(ctx, (IObjectValue)childBillInfo);
        ObjectUuidPK motherBillPK = new ObjectUuidPK(motherBillInfo.getId());
        this.updateBotpRelation(ctx, childBillPK, (IObjectPK)motherBillPK);
        Iterator motherIterator = motherEntryCollection.iterator();
        while (motherIterator.hasNext()) {
            entryInfo = (IncomeConfimEntryInfo)motherIterator.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            motherIterator.remove();
        }
        Iterator childIterator2 = childEntryCollection.iterator();
        while (childIterator2.hasNext()) {
            entryInfo = (IncomeConfimEntryInfo)childIterator2.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            childIterator2.remove();
        }
        super._update(ctx, (IObjectPK)motherBillPK, (IObjectValue)motherBillInfo);
        childBillInfo.setBillStatus(BillStatusEnum.AUDITED);
        super._update(ctx, childBillPK, (IObjectValue)childBillInfo);
    }

    private void updateBotpRelation(Context ctx, IObjectPK childBillPK, IObjectPK motherBillPK) throws BOSException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("destEntityID", (Object)this.getBOSType().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("destObjectID", (Object)motherBillPK.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.setFilter(filter);
        BOTRelationCollection botRelationCol = iBOTRelation.getCollection(ev);
        String bosType = IncomeConfimBillInfo.getBosType();
        int k = botRelationCol.size();
        for (int j = 0; j < k; ++j) {
            BOTRelationInfo botRelationInfo = botRelationCol.get(j);
            BOTRelationInfo childRelationInfo = new BOTRelationInfo();
            childRelationInfo.setSrcObjectID(botRelationInfo.getSrcObjectID());
            childRelationInfo.setDestEntityID(bosType);
            childRelationInfo.setSrcEntityID(botRelationInfo.getSrcEntityID());
            childRelationInfo.setDestObjectID(childBillPK.toString());
            childRelationInfo.setOperatorID("unknown");
            childRelationInfo.setType(0);
            iBOTRelation.addnew(childRelationInfo);
        }
    }

    private void splitChildInfo(Context ctx, IncomeConfimBillInfo info, IncomeConfimBillInfo motherBillInfo, IncomeConfimBillInfo childBillInfo, Map<String, Integer> assistUnitQtyPrecision) {
        IncomeConfimEntryCollection motherEntryCollection = motherBillInfo.getEntry();
        IncomeConfimEntryCollection childEntryCollection = childBillInfo.getEntry();
        IncomeConfimEntryCollection entryCollection = info.getEntry();
        IncomeConfimEntryInfo motherEntryInfo = null;
        IncomeConfimEntryInfo childEntryInfo = null;
        IncomeConfimEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        MeasureUnitInfo assistUnitInfo = null;
        int k = motherEntryCollection.size();
        for (int j = 0; j < k; ++j) {
            motherEntryInfo = motherEntryCollection.get(j);
            childEntryInfo = childEntryCollection.get(j);
            entryInfo = entryCollection.get(j);
            materialInfo = entryInfo.getMaterial();
            assistUnitInfo = entryInfo.getAssistUnit();
            childEntryInfo.setQuantity(entryInfo.getQuantity().subtract(motherEntryInfo.getQuantity()));
            childEntryInfo.setBaseQty(entryInfo.getBaseQty().subtract(motherEntryInfo.getBaseQty()));
            if (materialInfo != null && assistUnitInfo != null) {
                if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) {
                    String key = materialInfo.getId().toString() + assistUnitInfo.getId().toString();
                    motherEntryInfo.setAssistQty(motherEntryInfo.getQuantity().multiply(entryInfo.getAssistQty()).divide(entryInfo.getQuantity(), assistUnitQtyPrecision.get(key) == null ? 10 : Integer.parseInt(assistUnitQtyPrecision.get(key).toString()), 4));
                    childEntryInfo.setAssistQty(entryInfo.getAssistQty().subtract(motherEntryInfo.getAssistQty()));
                } else {
                    childEntryInfo.setAssistQty(this.ZERO);
                }
            }
            childEntryInfo.setAmount(entryInfo.getAmount().subtract(motherEntryInfo.getAmount()));
            childEntryInfo.setAmountLocal(entryInfo.getAmountLocal().subtract(motherEntryInfo.getAmountLocal()));
            childEntryInfo.setIncomeConfimAmount(entryInfo.getIncomeConfimAmount().subtract(motherEntryInfo.getIncomeConfimAmount()));
            childEntryInfo.setIncomeConfimAmountLoc(entryInfo.getIncomeConfimAmountLoc().subtract(motherEntryInfo.getIncomeConfimAmountLoc()));
            childEntryInfo.setDiscountAmount(entryInfo.getDiscountAmount().subtract(motherEntryInfo.getDiscountAmount()));
            childEntryInfo.setDiscountAmountLocal(entryInfo.getDiscountAmountLocal().subtract(motherEntryInfo.getDiscountAmountLocal()));
            childEntryInfo.setTaxAmount(entryInfo.getTaxAmount().subtract(motherEntryInfo.getTaxAmount()));
            childEntryInfo.setTaxAmountLocal(entryInfo.getTaxAmountLocal().subtract(motherEntryInfo.getTaxAmountLocal()));
            childEntryInfo.setHisUnVerifyAmount(entryInfo.getHisUnVerifyAmount().subtract(motherEntryInfo.getHisUnVerifyAmount()));
            childEntryInfo.setHisUnVerifyAmountLocal(entryInfo.getHisUnVerifyAmountLocal().subtract(motherEntryInfo.getHisUnVerifyAmountLocal()));
            childEntryInfo.setLockUnVerifyAmt(entryInfo.getLockUnVerifyAmt().subtract(motherEntryInfo.getLockUnVerifyAmt()));
            childEntryInfo.setLockUnVerifyAmtLocal(entryInfo.getLockUnVerifyAmtLocal().subtract(motherEntryInfo.getLockUnVerifyAmtLocal()));
            childEntryInfo.setLockQty(this.ZERO);
            childEntryInfo.setUnLockQty(childEntryInfo.getQuantity());
            childEntryInfo.setLockBaseQty(this.ZERO);
            childEntryInfo.setUnLockBaseQty(childEntryInfo.getBaseQty());
            childEntryInfo.setTotalArAmount(this.ZERO);
            childEntryInfo.setTotalArQty(this.ZERO);
            childEntryInfo.setTotalArBaseQty(this.ZERO);
            if (childEntryInfo.isIsPresent() || childEntryInfo.getQuantity().compareTo(this.ZERO) == 0) continue;
            childEntryInfo.setRealPrice(childEntryInfo.getAmount().divide(childEntryInfo.getQuantity(), materialInfo == null ? 6 : materialInfo.getPricePrecision(), 4));
            childEntryInfo.setActualPrice(childEntryInfo.getIncomeConfimAmount().divide(childEntryInfo.getQuantity(), materialInfo == null ? 6 : materialInfo.getPricePrecision(), 4));
        }
        childBillInfo.sumEntry();
        childBillInfo.setIsSplitBill(true);
        childBillInfo.setReqCalculate4Srv(false);
    }

    private void splitBillEntry(Context ctx, IncomeConfimEntryInfo motherEntryInfo, IncomeConfimEntryInfo childEntryInfo, IncomeConfimBillInfo otherBillInfo) throws EASBizException, BOSException {
        IncomeConfimEntryInfo cloneMotherEntryInfo = (IncomeConfimEntryInfo)motherEntryInfo.clone();
        motherEntryInfo.setBaseQty(cloneMotherEntryInfo.getWittenOffBaseQty());
        childEntryInfo.setBaseQty(cloneMotherEntryInfo.getUnwriteOffBaseQty());
        motherEntryInfo.setWittenOffBaseQty(cloneMotherEntryInfo.getWittenOffBaseQty());
        motherEntryInfo.setUnwriteOffBaseQty(this.ZERO);
        childEntryInfo.setWittenOffBaseQty(this.ZERO);
        childEntryInfo.setUnwriteOffBaseQty(cloneMotherEntryInfo.getUnwriteOffBaseQty());
        motherEntryInfo.setLocalWrittenOffAmount(cloneMotherEntryInfo.getLocalWrittenOffAmount());
        motherEntryInfo.setLocalUnwriteOffAmount(this.ZERO);
        childEntryInfo.setLocalWrittenOffAmount(this.ZERO);
        childEntryInfo.setLocalUnwriteOffAmount(cloneMotherEntryInfo.getLocalUnwriteOffAmount());
        motherEntryInfo.setAmountLocal(cloneMotherEntryInfo.getLocalWrittenOffAmount());
    }

    private void cacheAssistQtyPrecision(Context ctx, IncomeConfimBillInfo motherBillInfo, Map<String, Integer> assistUnitQtyPrecision) throws BOSException {
        IncomeConfimEntryCollection motherEntryCollection = motherBillInfo.getEntry();
        HashSet<String> assistUnitIDSet = new HashSet<String>();
        HashSet<String> materialIDSet = new HashSet<String>();
        int k = motherEntryCollection.size();
        for (int j = 0; j < k; ++j) {
            IncomeConfimEntryInfo motherEntryInfo = motherEntryCollection.get(j);
            if (motherEntryInfo.getAssistUnit() != null) {
                assistUnitIDSet.add(motherEntryInfo.getAssistUnit().getId().toString());
            }
            if (motherEntryInfo.getMaterial() == null) continue;
            materialIDSet.add(motherEntryInfo.getMaterial().getId().toString());
        }
        String key = null;
        if (assistUnitIDSet.size() > 0 && materialIDSet.size() > 0) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("material.id"));
            view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
            view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", assistUnitIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MultiMeasureUnitCollection multiUnitColl = multiUnit.getMultiMeasureUnitCollection(view);
            int size = multiUnitColl.size();
            for (int i = 0; i < size; ++i) {
                key = multiUnitColl.get(i).getMaterial().getId().toString() + multiUnitColl.get(i).getMeasureUnit().getId().toString();
                if (assistUnitQtyPrecision.containsKey(key)) continue;
                assistUnitQtyPrecision.put(key, multiUnitColl.get(i).getQtyPrecision());
            }
        }
    }

    private String getChildNumber(Context ctx, String number, String companyId, int n) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("00");
        sb.append(String.valueOf(n));
        if (sb.length() > 3) {
            sb.delete(0, sb.length() - 3);
        }
        String childNumber = number + sb.toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)childNumber));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        if (this.exists(ctx, filter)) {
            return this.getChildNumber(ctx, number, companyId, n + 1);
        }
        return childNumber;
    }

    private void canSplit(Context ctx, IncomeConfimBillInfo info) throws BOSException, EASBizException {
        if (!IncomeConfimBillTypeEnum.SALE_INCOME.equals((Object)info.getBillType())) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.BILLTYPE_NOT_SALEINCOME);
        }
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (info.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
        }
        if (info.getLockAmt().compareTo(this.ZERO) != 0) {
            throw new OtherBillBizException(OtherBillBizException.LOCKAMT_NOTZERO);
        }
        CompanyOrgUnitInfo currentCompany = info.getCompany();
        SystemStatusCtrolInfo arapStatus = CommonServerUtils.getSysStatusCtrolInfo(ctx, currentCompany.getId().toString(), this._getOwnedSys(ctx));
        if (info.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
        }
        if (BTPManagerFactory.getLocalInstance((Context)ctx).ifHaveDestBills(info.getId().toString())) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.HAVE_NEXT_BILL);
        }
        BigDecimal sumLocalWrittenOffAmount = new BigDecimal("0.00");
        BigDecimal sumLocalUnwriteOffAmount = new BigDecimal("0.00");
        IncomeConfimEntryCollection entryCol = info.getEntry();
        for (int j = 0; j < entryCol.size(); ++j) {
            IncomeConfimEntryInfo entryInfo = entryCol.get(j);
            sumLocalWrittenOffAmount = sumLocalWrittenOffAmount.add(entryInfo.getLocalWrittenOffAmount());
            sumLocalUnwriteOffAmount = sumLocalUnwriteOffAmount.add(entryInfo.getLocalUnwriteOffAmount());
        }
        if (sumLocalWrittenOffAmount.compareTo(this.ZERO) == 0 || sumLocalUnwriteOffAmount.compareTo(this.ZERO) == 0) {
            throw new OtherBillBizException(OtherBillBizException.ENTRY_NOTPARTWRITTENOFF);
        }
    }

    @Override
    protected IObjectPK[] _createReverseBill(Context ctx, IObjectPK[] sourceBillpk, Date bizDate, Date billDate) throws BOSException, EASBizException {
        ArrayList<IObjectPK> result = new ArrayList<IObjectPK>(sourceBillpk.length);
        for (IObjectPK pk : sourceBillpk) {
            IncomeConfimBillInfo billInfo = this.getIncomeConfimBillInfo(ctx, pk);
            this.canReverse(ctx, billInfo);
            IncomeConfirmBillReverseService service = new IncomeConfirmBillReverseService(ctx, billInfo, bizDate, billDate);
            IObjectPK destBillPk = service.doReverse();
            if (null == destBillPk) continue;
            result.add(destBillPk);
        }
        return result.toArray(new IObjectPK[0]);
    }

    @Override
    protected IObjectPK _reverseBillAudit(Context ctx, IncomeConfimBillInfo billInfo) throws BOSException, EASBizException {
        billInfo.setBillStatus(BillStatusEnum.SUBMITED);
        this.setDefaultValue(ctx, billInfo);
        this.checkNumber(ctx, billInfo);
        this.check4submit(ctx, billInfo);
        LogControllManager.getInstance().enableLog();
        IObjectPK destPk = super._submit(ctx, (IObjectValue)billInfo);
        this.auditReverseBill(ctx, destPk);
        IncomeConfimBillInfo sourceBillInfo = this.getIncomeConfimBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getSourceBillId()));
        this.writeBackSCMBill(ctx, sourceBillInfo, BizActionEnum.UNAUDIT);
        return destPk;
    }

    @Override
    protected void canEntryReverse(IObjectValue entryInfo) throws EASBizException, BOSException {
        IncomeConfimEntryInfo incomeEntry = (IncomeConfimEntryInfo)entryInfo;
        BigDecimal lockQty = incomeEntry.getLockQty();
        BigDecimal bigDecimal = lockQty = lockQty == null ? BigDecimal.ZERO : lockQty;
        if (BigDecimal.ZERO.compareTo(lockQty) != 0) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.ENTRY_QTY_LOCK_NOT_ZERO);
        }
    }

    private void auditReverseBill(Context ctx, IObjectPK pk) throws BOSException {
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        String sql = "update t_ar_incomeconfimbill set fbillstatus=?,fauditdate=?,fauditorid=?,fLastUpdateTime = null,fLastUpdateUserId = null where fid=? ";
        Object[] params = new Object[]{3, new Timestamp(System.currentTimeMillis()), currentUser.getId().toString(), pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _cancelAppointmentVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        IncomeConfimBillInfo info = this.getIncomeConfimBillInfo(ctx, pk);
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_UNAUDIT_NOT);
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
        if (currentPeriod == null) {
            throw new OtherBillBizException(OtherBillBizException.CURRENTPERIODISNULL);
        }
        if (info.getBillDate().before(currentPeriod.getBeginDate()) || info.isIsInitializeBill()) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_INITBILL_NOT);
        }
        if (!info.isIsAppointVoucher()) {
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)IncomeConfimBillInfo.getBosType(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.getId(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            BOTRelationCollection botRelationCollection = iBotRelation.getCollection(view);
            if (botRelationCollection.size() == 1) {
                throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_CREATED_NOT);
            }
        }
        if (!info.isIsAppointVoucher() || info.getVoucher() == null) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_EXIST_NOT);
        }
        String destObjectId = info.getVoucher().getId().toString();
        String srcObjectId = info.getId().toString();
        FilterInfo filterInfo2 = new FilterInfo();
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view2 = new EntityViewInfo();
        view2.getSelector().add(new SelectorItemInfo("id"));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)IncomeConfimBillInfo.getBosType(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view2.setFilter(filterInfo2);
        BOTRelationCollection deleteCollection = iBOTRelation.getCollection(view2);
        if (deleteCollection.size() > 0) {
            BOTRelationInfo rotpmap = deleteCollection.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation.delete((IObjectPK)pkbot);
        }
        info.setVoucher(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setIsAppointVoucher(false);
        info.setFiVouchered(false);
        info.setAccountant(null);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        ObjectBaseCollection collection = new ObjectBaseCollection();
        collection.addObject(objectValue);
        this._handleAfterTransform(ctx, action, (IObjectCollection)collection);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        ArApServerUtils.checkBillStatusForBotp(ctx, collection, new String[]{"C48A423A", this.SALE_ISSUE_BILL_BOS_TYPE});
        for (int i = 0; i < collection.size(); ++i) {
            CurrencyInfo baseCurrency;
            IncomeConfimBillInfo info = (IncomeConfimBillInfo)collection.getObject(i);
            CurrencyInfo currency = info.getCurrency();
            if (!ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)(baseCurrency = info.getCompany().getBaseCurrency()))) continue;
            info.setExchangeRate(BigDecimal.ONE);
        }
        super._handleAfterTransform(ctx, action, collection);
    }

    @Override
    protected void _pureUpdate(Context ctx, IncomeConfimBillInfo billInfo) throws BOSException, EASBizException {
        if (null == billInfo.getId()) {
            return;
        }
        this.innerUpdate(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws EASBizException, BOSException {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String getResStr(Context ctx, String key) {
        String res = "com.kingdee.eas.fi.ar.IncomeConfimResource";
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale());
    }

    protected String getResStr(Context ctx, String key, Object[] params) {
        String res = "com.kingdee.eas.fi.ar.IncomeConfimResource";
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }
}

