/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.RptAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.RptApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.RptApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.RptApBillSql;
import com.kingdee.eas.fi.ar.app.RptApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptApTransSql;
import com.kingdee.eas.fi.ar.app.RptApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.RptArBillSql;
import com.kingdee.eas.fi.ar.app.RptArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.RptArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.RptArTransSql;
import com.kingdee.eas.fi.ar.app.RptArVRecBadVRec_RecSql;
import com.kingdee.eas.fi.ar.app.RptArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.RptAr_ApVArSql;
import com.kingdee.eas.fi.ar.app.RptBadAcctSql;
import com.kingdee.eas.fi.ar.app.RptBadRecASql;
import com.kingdee.eas.fi.ar.app.RptBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.RptPayBillSql;
import com.kingdee.eas.fi.ar.app.RptPayTransSql;
import com.kingdee.eas.fi.ar.app.RptRecBillSql;
import com.kingdee.eas.fi.ar.app.RptRecTransSql;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ItemRptSqlBuilder {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ItemRptSqlBuilder");
    protected static final int DATA_START = 0;
    protected static final int DATA_PERIODSTART = 1;
    protected static final int DATA_BILLS = 2;
    protected static final int SUM_ADMIN_PRSN = 3;
    protected static final int SUM_CUSSACCT = 4;
    protected static final int DATA_PERIODSUM = 5;
    protected static final int DATA_YEARSUM = 6;
    protected static final int SUM_CURRENCY = 7;

    private ItemRptSqlBuilder() {
    }

    protected static String getItemStartSql(Context ctx, ItemRptQueryParam param, PeriodInfo currPeriod) throws BOSException, EASBizException, SQLException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        Date qryBeginDate = param.getBeginDate();
        Date qryEndDate = param.getEndDate();
        boolean fStartClosed = qryBeginDate.before(currPeriod.getBeginDate());
        String qryStPeriodId = fStartClosed ? param.getPeriodId() : currPeriod.getId().toString();
        boolean fNeedCalc = false;
        if (fStartClosed) {
            PeriodInfo startPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(qryStPeriodId));
            fNeedCalc = DateTimeUtils.dayAfter((java.util.Date)param.getBeginDate(), (java.util.Date)startPeriod.getBeginDate());
            if (fNeedCalc) {
                param.setBeginDate(startPeriod.getBeginDate());
                param.setEndDate(qryBeginDate);
            }
        } else {
            fNeedCalc = DateTimeUtils.dayAfter((java.util.Date)param.getBeginDate(), (java.util.Date)currPeriod.getBeginDate());
            if (fNeedCalc) {
                param.setBeginDate(currPeriod.getBeginDate());
                param.setEndDate(qryBeginDate);
            }
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append("  select t4.FBaseCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("  select t4.FCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("  select t4.FCurrency");
            sql.append(", t4.FBaseCurrency");
        }
        if (fSumByCussAcct) {
            sql.append(", t4.FCussAcctId");
        } else if (param.isSumByDept()) {
            sql.append(", t4.FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append(", t4.FPersonId");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(", SUM(t4.FBalanceLocal) as FBalanceLocal FROM (");
            sql.append("  select t6.").append(nameFld).append(" as FBaseCurrency");
            if (fSumByCussAcct) {
                sql.append(", tB.FAsstActId as FCussAcctId");
            } else if (param.isSumByDept()) {
                sql.append(", tB.FAdminOrgUnitID as FAdminOrgId");
            } else if (param.isSumByPerson()) {
                sql.append(", tB.FPersonId");
            }
            sql.append(", tB.FBeginBalanceLocal as FBalanceLocal ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(", SUM(t4.FBalance) as FBalance FROM (");
            sql.append("  select t3.").append(nameFld).append(" as FCurrency");
            if (fSumByCussAcct) {
                sql.append(", tB.FAsstActId as FCussAcctId");
            } else if (param.isSumByDept()) {
                sql.append(", tB.FAdminOrgUnitID as FAdminOrgId");
            } else if (param.isSumByPerson()) {
                sql.append(", tB.FPersonId");
            }
            sql.append(", tB.FBeginBalanceFor as FBalance ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(", SUM(t4.FBalance) as FBalance, SUM(t4.FBalanceLocal) as FBalanceLocal FROM (");
            sql.append("  select t3.").append(nameFld).append(" as FCurrency");
            sql.append(",  t6.").append(nameFld).append(" as FBaseCurrency");
            if (fSumByCussAcct) {
                sql.append(", tB.FAsstActId as FCussAcctId");
            } else if (param.isSumByDept()) {
                sql.append(", tB.FAdminOrgUnitID as FAdminOrgId");
            } else if (param.isSumByPerson()) {
                sql.append(", tB.FPersonId");
            }
            sql.append(", tB.FBeginBalanceFor as FBalance ");
            sql.append(", tB.FBeginBalanceLocal as FBalanceLocal ");
        }
        sql.append(" from ");
        sql.append(param.isArRpt() ? "t_ar_Arbalance tB " : "t_ap_ApBalance tB ");
        sql.append(" inner join ").append(param.getCussAcctTempTable());
        sql.append(" tt on tB.FAsstActId = tt.FId ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" left join T_ORG_Company t5 on tB.FCompanyID = t5.FId ");
            sql.append(" inner join t_bd_currency t6 on t5.FBaseCurrencyId = t6.FId ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" left join t_bd_currency t3 on tB.FCurrencyId = t3.FId ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" left join t_bd_currency t3 on tB.FCurrencyId = t3.FId ");
            sql.append(" left join T_ORG_Company t5 on tB.FCompanyID = t5.FId ");
            sql.append(" inner join t_bd_currency t6 on t5.FBaseCurrencyId = t6.FId ");
        }
        if (param.isSumByDept()) {
            sql.append("\r\n inner join ");
            sql.append(param.getAdminOrgTempTable()).append(" t2 on ");
            sql.append(" tB.FAdminOrgUnitID = t2.FId ");
        }
        if (param.isSumByPerson()) {
            sql.append("\r\n inner join ");
            sql.append(param.getPersonTempTable()).append(" t2 on ");
            sql.append(" tB.FPersonID = t2.FId ");
        }
        sql.append(" where tB.FCompanyId = '").append(param.getCompanyId()).append("'");
        sql.append(" and tB.FAsstActTypeId = '");
        sql.append(param.getCussTypeId()).append("' ");
        if (!param.isAllCurrency()) {
            sql.append(" and t3.fid = '").append(param.getCurrencyId()).append("'");
        }
        sql.append("\r\n and tB.FPeriodId = '").append(qryStPeriodId);
        sql.append("' and tB.FbalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 102);
        }
        sql.append(") and tB.FBalType IN (");
        if (param.isIncludeBizBill()) {
            if (param.getIncludeBizIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(102);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 103);
        }
        sql.append(")");
        if (fNeedCalc) {
            sql.append("  \r\n union all \r\n");
            if ("base".equals(param.getCurrencyId())) {
                sql.append("  select t3.").append(nameFld).append(" as FBaseCurrency");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("  select t3.").append(nameFld).append(" as FCurrency");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("  select t3.").append(nameFld).append(" as FCurrency");
                sql.append(",  t4.").append(nameFld).append(" as FBaseCurrency");
            }
            if (fSumByCussAcct) {
                sql.append(", tBiz.FAsstActId as FCussAcctId");
            } else if (param.isSumByDept()) {
                sql.append(", tBiz.FAdminOrgID as FAdminOrgId");
            } else if (param.isSumByPerson()) {
                sql.append(", tBiz.FPersonId");
            }
            if ("base".equals(param.getCurrencyId())) {
                sql.append(", (tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FBalanceLocal ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(", (tBiz.FDebitAmt - tBiz.FCreditAmt) FBalance ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(", (tBiz.FDebitAmt - tBiz.FCreditAmt) FBalance ");
                sql.append(", (tBiz.FDebitAmtLocal - tBiz.FCreditAmtLocal) FBalanceLocal ");
            }
            sql.append("   from   ");
            sql.append(ItemRptSqlBuilder.viewDataSql(ctx, param));
            sql.append(" tBiz ");
            if ("base".equals(param.getCurrencyId())) {
                sql.append(" left join t_bd_currency t3 on tBiz.FBaseCurrencyId = t3.FId ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append(" left join t_bd_currency t3 on tBiz.FCurrencyId = t3.FId ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append(" left join t_bd_currency t3 on tBiz.FCurrencyId = t3.FId ");
                sql.append(" left join t_bd_currency t4 on tBiz.FCurrencyId = t4.FId ");
            }
            sql.append(" where tBiz.FCompanyId = '").append(param.getCompanyId()).append("'");
            sql.append(" and tBiz.FAsstActTypeId = '");
            sql.append(param.getCussTypeId()).append("' ");
            if (!param.isAllCurrency()) {
                sql.append(" and t3.fid = '").append(param.getCurrencyId()).append("'");
            }
        }
        if (fNeedCalc) {
            param.setBeginDate(qryBeginDate);
            param.setEndDate(qryEndDate);
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(") t4 group by t4.FBaseCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(") t4 group by t4.FCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(") t4 group by t4.FCurrency, t4.FBaseCurrency");
        }
        if (fSumByCussAcct) {
            sql.append(", t4.FCussAcctId");
        } else if (param.isSumByDept()) {
            sql.append(", t4.FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append(", t4.FPersonId");
        }
        logger.debug((Object)("itemRptStart: \r\n" + sql));
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String viewDataSql(Context ctx, ItemRptQueryParam param) throws SQLException, BOSException {
        String tempTbl = "";
        Locale locale = ctx.getLocale();
        Connection con = null;
        Statement stmt = null;
        try {
            StringBuffer tblStruct = new StringBuffer();
            tblStruct.append("(FCompanyId varchar(44), ");
            tblStruct.append(" FCurrencyId varchar(44), FAsstActId varchar(44),");
            tblStruct.append(" FAsstActTypeID varchar(44),");
            tblStruct.append(" FAdminOrg varchar(1000), FAdminOrgId varchar(44),");
            tblStruct.append(" FPerson varchar(1000), FPersonId varchar(44),");
            if ("base".equals(param.getCurrencyId())) {
                tblStruct.append(" FBaseCurrencyId varchar(44),");
                tblStruct.append(" FDebitAmtLocal NUMERIC(19,4) NOT NULL DEFAULT 0,");
                tblStruct.append(" FCreditAmtLocal NUMERIC(19,4) NOT NULL DEFAULT 0)");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                tblStruct.append(" FDebitAmt NUMERIC(19,4) NOT NULL DEFAULT 0,");
                tblStruct.append(" FCreditAmt NUMERIC(19,4) NOT NULL DEFAULT 0)");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                tblStruct.append(" FBaseCurrencyId varchar(44),");
                tblStruct.append(" FDebitAmt NUMERIC(19,4) NOT NULL DEFAULT 0,");
                tblStruct.append(" FCreditAmt NUMERIC(19,4) NOT NULL DEFAULT 0,");
                tblStruct.append(" FDebitAmtLocal NUMERIC(19,4) NOT NULL DEFAULT 0,");
                tblStruct.append(" FCreditAmtLocal NUMERIC(19,4) NOT NULL DEFAULT 0)");
            }
            tempTbl = TempTableUtil.createTempTable(ctx, tblStruct.toString());
            TempTablePool t = TempTablePool.getInstance((Context)ctx);
            try {
                if ("base".equals(param.getCurrencyId())) {
                    t.createIndex(tempTbl, "FCompanyId,FBaseCurrencyId,FAsstActId,FAsstActTypeID", false, false);
                } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                    t.createIndex(tempTbl, "FCompanyId,FCurrencyId,FAsstActId,FAsstActTypeID", false, false);
                } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                    t.createIndex(tempTbl, "FCompanyId,FCurrencyId,FBaseCurrencyId,FAsstActId,FAsstActTypeID", false, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            ArrayList<String> sqlList = new ArrayList<String>();
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTbl);
            if ("base".equals(param.getCurrencyId())) {
                sql.append("(FCompanyId, FBaseCurrencyId, FAsstActTypeID, FAsstActId, FAdminOrg, FAdminOrgId, FPerson, FPersonId, FDebitAmtLocal, FCreditAmtLocal) ");
            } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
                sql.append("(FCompanyId, FCurrencyId, FAsstActTypeID,FAsstActId, FAdminOrg, FAdminOrgId, FPerson, FPersonId, FDebitAmt, FCreditAmt) ");
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("(FCompanyId, FCurrencyId, FBaseCurrencyId, FAsstActTypeID,FAsstActId, FAdminOrg, FAdminOrgId, FPerson, FPersonId, FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal) ");
            }
            sqlList.add("delete from " + tempTbl);
            if (param.isArRpt()) {
                sqlList.add(sql + new RptArBillSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptRecBillSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptBadAcctSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptBadRecASql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptBadRec_BadSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptArVRec_ArVApSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptArVRecBadVRec_RecSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptArPreRecVPrePay_RecVPaySql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptAr_ApVArSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptArPrePayVPreRec_PayVRecSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptArTransSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptRecTransSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptAr2PrepayTransSql().getSummQuerySql(param, locale));
            } else {
                sqlList.add(sql + new RptApBillSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptPayBillSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApVPay_ApVArSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApApVPay_PaySql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApPrePayVPreRec_PayVRecSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApArVAp_ApSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApPreRecVPrePay_RecVPaySql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptApTransSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptPayTransSql().getSummQuerySql(param, locale));
                sqlList.add(sql + new RptAp2PrerecTransSql().getSummQuerySql(param, locale));
            }
            DBUtil.execBatchSql((Connection)con, sqlList, (boolean)true);
            try {
                t.analyzeTable(con, tempTbl);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tempTbl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getItemDataSql(Context ctx, ItemRptQueryParam param) throws BOSException, EASBizException, SQLException {
        String tempTbl = "";
        Connection con = null;
        Statement stmt = null;
        try {
            Locale locale = ctx.getLocale();
            tempTbl = param.getTempTable();
            boolean existTempTable = TempTablePool.getInstance((Context)ctx).exists(tempTbl);
            if (!existTempTable) {
                throw new IllegalArgumentException();
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tempTbl);
            sql.append("\r\n (FBillId, FCurrNum, FCurrency, FCussType, FCussNum,");
            sql.append(" FCussName, FCussAcctId,\r\n");
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId,");
            sql.append(" FPerson, FPersonNum, FPersonId,\r\n");
            sql.append(" FBillDate, FBillType, FRecPayType, FBillNum,");
            sql.append(" FVoucherType, FVoucherNum, FDescription , FContractNumber,\r\n");
            if (param.isShowMaterialItem()) {
                sql.append(" FEntrySeq, FEntryId, FMaterialId, FExpenseItemId, FQuantity,\r\n");
            }
            sql.append(" FDebitAmt, FCreditAmt, FBalance, FPeriodId,\r\n");
            sql.append(" FPeriodYear, FPeriodNumber, ");
            sql.append("FMainBillType, FDataType) \r\n");
            ArrayList<String> sqlList = new ArrayList<String>();
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            sqlList.add("delete from " + tempTbl);
            if (param.isArRpt()) {
                sqlList.add(sql + new RptRecBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadAcctSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadRecASql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptBadRec_BadSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArVRec_ArVApSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArVRecBadVRec_RecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAr_ApVArSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptArTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptRecTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAr2PrepayTransSql().getItemQuerySql(param, locale));
            } else {
                sqlList.add(sql + new RptApBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptPayBillSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApVPay_ApVArSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApApVPay_PaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApArVAp_ApSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptApTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptPayTransSql().getItemQuerySql(param, locale));
                sqlList.add(sql + new RptAp2PrerecTransSql().getItemQuerySql(param, locale));
            }
            DBUtil.execBatchSql((Connection)con, sqlList, (boolean)true);
            TempTablePool t = TempTablePool.getInstance((Context)ctx);
            try {
                t.analyzeTable(con, tempTbl);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tempTbl.toString();
    }

    protected static String getItemPeriodSumSql(Context ctx, ItemRptQueryParam param) {
        String lbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName2", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" FPerson, FPersonNum, FPersonId, ");
        }
        sql.append(" FDescription, FPeriodId, ");
        sql.append(param.isByPeriod() ? "FPeriodYear, FPeriodNumber, " : "");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        sql.append(" N'' || ");
        if (param.isByPeriod()) {
            sql.append("to_char(t2.FPeriodYear) || '-' || case when ");
            sql.append("t2.FPeriodNumber >= 10 then to_char(t2.FPeriodNumber)");
            sql.append(" else '0' || to_char(t2.FPeriodNumber)");
            sql.append(" end || ");
        }
        sql.append("'").append(lbl).append("' FDescription, FPeriodId, \r\n");
        sql.append(param.isByPeriod() ? "t2.FPeriodYear, t2.FPeriodNumber, " : "");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(5);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(5);
        }
        sql.append(" FDataType, newbosid('ARAPItem') from ").append(param.getTempTable());
        sql.append(" t1 \r\n left join t_bd_period t2 on t1.FPeriodId = t2.FId ");
        sql.append(" \r\n where t1.FDataType = ").append(2);
        sql.append(" or t1.FDataType = ").append(0);
        sql.append(" or t1.FDataType = ").append(1);
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        if (fSumByCussAcct) {
            sql.append(" t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        sql.append(" t1.FPeriodId, t2.FPeriodYear, t2.FPeriodNumber");
        logger.debug((Object)("itemRpt periodSum Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getItemYearSumSql(Context ctx, PeriodInfo periodInfo, ItemRptQueryParam param) {
        String lbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName3", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" FPerson, FPersonNum, FPersonId, ");
        }
        sql.append(" FDescription, FPeriodId, ");
        sql.append("FPeriodYear, FPeriodNumber, ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        sql.append(" N'' || ");
        sql.append("to_char(").append(periodInfo.getPeriodYear()).append(") || '-' || case when ");
        sql.append(periodInfo.getPeriodNumber()).append(" >= 10 then to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" else '0' || to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" end || ");
        sql.append("'").append(lbl).append("' FDescription,");
        sql.append("'").append(periodInfo.getId().toString()).append("', \r\n");
        sql.append(periodInfo.getPeriodYear()).append(",").append(periodInfo.getPeriodNumber()).append(",");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType, newbosid('ARAPItem') from ").append(param.getTempTable());
        sql.append(" t1 \r\n where t1.FDataType = ").append(5);
        sql.append(" and t1.FPeriodNumber <= ").append(periodInfo.getPeriodNumber());
        sql.append(" and t1.FPeriodYear = ").append(periodInfo.getPeriodYear());
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        }
        if (param.isSumByDept()) {
            sql.append(" ,t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append(" ,t1.FPerson, t1.FPersonNum, t1.FPersonId");
        }
        if (fSumByCussAcct) {
            sql.append(" ,t1.FCussNum, t1.FCussName, t1.FCussAcctId");
        }
        logger.debug((Object)("itemRpt periodSum Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getItemYearSumSql(Context ctx, PeriodInfo lastPeriod, PeriodInfo periodInfo, ItemRptQueryParam param) {
        String lbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName3", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" FPerson, FPersonNum, FPersonId, ");
        }
        sql.append(" FDescription, FPeriodId, ");
        sql.append("FPeriodYear, FPeriodNumber, ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        sql.append(" N'' || ");
        sql.append("to_char(").append(periodInfo.getPeriodYear()).append(") || '-' || case when ");
        sql.append(periodInfo.getPeriodNumber()).append(" >= 10 then to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" else '0' || to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" end || ");
        sql.append("'").append(lbl).append("' FDescription,");
        sql.append("'").append(periodInfo.getId().toString()).append("', \r\n");
        sql.append(periodInfo.getPeriodYear()).append(",").append(periodInfo.getPeriodNumber()).append(",");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType, newbosid('ARAPItem') from (");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ");
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType from ").append(param.getTempTable());
        sql.append(" t1 \r\n where t1.FDataType = ").append(6);
        sql.append(" and t1.FPeriodNumber = ").append(lastPeriod.getPeriodNumber());
        sql.append(" and t1.FPeriodYear = ").append(lastPeriod.getPeriodYear());
        sql.append(" \r\n union all \r\n");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ");
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType from ").append(param.getTempTable());
        sql.append(" t1 \r\n where t1.FDataType = ").append(5);
        sql.append(" and t1.FPeriodNumber = ").append(periodInfo.getPeriodNumber());
        sql.append(" and t1.FPeriodYear = ").append(periodInfo.getPeriodYear());
        sql.append(")  t1 ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        }
        if (param.isSumByDept()) {
            sql.append(" ,t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append(" ,t1.FPerson, t1.FPersonNum, t1.FPersonId");
        }
        if (fSumByCussAcct) {
            sql.append(" ,t1.FCussNum, t1.FCussName, t1.FCussAcctId");
        }
        logger.debug((Object)("itemRpt periodSum Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getItemYearSumSqlForFirstPeriod(Context ctx, PeriodInfo periodInfo, ItemRptQueryParam param) {
        String lbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName3", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" FAdminOrg, FAdminOrgNum, FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" FPerson, FPersonNum, FPersonId, ");
        }
        sql.append(" FDescription, FPeriodId, ");
        sql.append("FPeriodYear, FPeriodNumber, ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        sql.append(" N'' || ");
        sql.append("to_char(").append(periodInfo.getPeriodYear()).append(") || '-' || case when ");
        sql.append(periodInfo.getPeriodNumber()).append(" >= 10 then to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" else '0' || to_char(").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" end || ");
        sql.append("'").append(lbl).append("' FDescription,");
        sql.append("'").append(periodInfo.getId().toString()).append("', \r\n");
        sql.append(periodInfo.getPeriodYear()).append(",").append(periodInfo.getPeriodNumber()).append(",");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" sum(t1.FDebitAmt) FDebitAmt, ");
            sql.append(" sum(t1.FCreditAmt) FCreditAmt, ");
            sql.append(" sum(t1.FDebitAmtLocal) FDebitAmtLocal, ");
            sql.append(" sum(t1.FCreditAmtLocal) FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType, newbosid('ARAPItem') from (");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussName, t1.FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" t1.FPerson, t1.FPersonNum, t1.FPersonId, ");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ").append(6);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" t1.FDebitAmt FDebitAmt, ");
            sql.append(" t1.FCreditAmt FCreditAmt, ");
            sql.append(" t1.FDebitAmtLocal FDebitAmtLocal, ");
            sql.append(" t1.FCreditAmtLocal FCreditAmtLocal, ").append(6);
        }
        sql.append(" FDataType from ").append(param.getTempTable());
        sql.append(" t1 \r\n where t1.FDataType = ").append(5);
        sql.append(" and t1.FPeriodNumber = ").append(periodInfo.getPeriodNumber());
        sql.append(" and t1.FPeriodYear = ").append(periodInfo.getPeriodYear());
        sql.append(")  t1 ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n group by t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FBaseCurrNum, t1.FBaseCurrency, t1.FCussType");
        }
        if (param.isSumByDept()) {
            sql.append(" ,t1.FAdminOrg, t1.FAdminOrgNum, t1.FAdminOrgId");
        } else if (param.isSumByPerson()) {
            sql.append(" ,t1.FPerson, t1.FPersonNum, t1.FPersonId");
        }
        if (fSumByCussAcct) {
            sql.append(" ,t1.FCussNum, t1.FCussName, t1.FCussAcctId");
        }
        logger.debug((Object)("itemRpt periodSum Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getItemOneYearSumSql(Context ctx, PeriodInfo periodInfo, ItemRptQueryParam param, boolean isFinal) {
        String lbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName3", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        String nameFld = "FName_" + ctx.getLocale().getLanguage();
        sql.append(" insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" FAdminOrg, FAdminOrgNum,FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append(" FPerson, FPersonNum,FPersonId, ");
        }
        sql.append(" FDescription, FPeriodId, ");
        sql.append("FPeriodYear, FPeriodNumber, ");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select baseCurrency.fnumber,baseCurrency.").append(nameFld).append(",t3.").append(nameFld).append(", ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDataType, Fid) \r\n ");
            sql.append(" select t2.fnumber,t2.").append(nameFld).append(",t3.").append(nameFld).append(", ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" FDebitAmt, FCreditAmt, FDebitAmtLocal, FCreditAmtLocal, FDataType, Fid) \r\n ");
            sql.append(" select t2.fnumber,t2.").append(nameFld).append(",baseCurrency.fnumber,baseCurrency.").append(nameFld).append(",t3.").append(nameFld).append(", ");
        }
        if (fSumByCussAcct) {
            sql.append(" t4.FNumber,t4.").append(nameFld).append(",t1.FAsstActId, ");
        }
        if (param.isSumByDept()) {
            sql.append(" t5.").append(nameFld).append(",t5.FNumber,");
            sql.append("case when t1.FAdminorgunitID = 'z' then null else t1.FAdminorgunitID end FAdminorgunitID,");
        } else if (param.isSumByPerson()) {
            sql.append(" t6.").append(nameFld).append(",t6.FNumber,");
            sql.append("case when t1.FPersonId = 'z' then null else t1.FPersonId end FPersonId,");
        }
        if (isFinal) {
            sql.append(" N'' || ");
            sql.append("to_char(").append(periodInfo.getPeriodYear()).append(") || '-' || case when ");
            sql.append(periodInfo.getPeriodNumber()).append(" >= 10 then to_char(").append(periodInfo.getPeriodNumber()).append(")");
            sql.append(" else '0' || to_char(").append(periodInfo.getPeriodNumber()).append(")");
            sql.append(" end || ");
            sql.append("'").append(lbl).append("' FDescription,");
            sql.append("'").append(periodInfo.getId().toString()).append("', \r\n");
            sql.append(periodInfo.getPeriodYear()).append(",").append(periodInfo.getPeriodNumber()).append(",");
        } else {
            sql.append("'tempSum' FDescription,");
            sql.append("'").append(param.getPeriodId().toString()).append("', \r\n");
            sql.append(param.getStartPeriodYear()).append(",").append(param.getEndPeriodNum()).append(",");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" sum(FYearDebitLocal) FYearDebitLocal, ");
            sql.append(" sum(FYearCreditLocal) FYearCreditLocal, ").append(isFinal ? 6 : 5);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" sum(FYearDebitFor) FYearDebit, ");
            sql.append(" sum(FYearCreditFor) FYearCredit, ").append(isFinal ? 6 : 5);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" sum(FYearDebitFor) FYearDebit, ");
            sql.append(" sum(FYearCreditFor) FYearCredit, ");
            sql.append(" sum(FYearDebitLocal) FYearDebitLocal, ");
            sql.append(" sum(FYearCreditLocal) FYearCreditLocal, ").append(isFinal ? 6 : 5);
        }
        sql.append(" FDataType, newbosid('ARAPItem') from ");
        sql.append(param.isArRpt() ? "t_ar_ArBalance" : "t_ap_ApBalance").append(" t1");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyID").append("\r\n");
            sql.append(" inner join T_BD_Currency  baseCurrency ON company.FBaseCurrencyID = baseCurrency.FID ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" inner join T_BD_Currency  t2 ON t1.FCurrencyID = t2.FID ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" inner join T_BD_Currency  t2 ON t1.FCurrencyID = t2.FID ");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyID").append("\r\n");
            sql.append(" inner join T_BD_Currency  baseCurrency ON company.FBaseCurrencyID = baseCurrency.FID ");
        }
        sql.append(" inner join t_bd_asstActType t3 on t1.FAsstActTypeId = t3.FID");
        sql.append(" inner join ").append(param.getCussAcctTempTable());
        sql.append(" t4 on t1.FAsstActId = t4.FID ");
        if (param.isSumByDept()) {
            sql.append(" inner join ").append(param.getAdminOrgTempTable()).append(" t5  ON t1.FAdminorgunitID = t5.FID ");
        } else if (param.isSumByPerson()) {
            sql.append(" inner join ").append(param.getPersonTempTable()).append(" t6  ON t1.FPersonId = t6.FID ");
        }
        sql.append("\r\n where 1=1 ");
        if (!param.isAllCurrency()) {
            sql.append("\r\n and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getCussTypeId())) {
            sql.append("\r\n and t1.FAsstActTypeId = '");
            sql.append(param.getCussTypeId()).append("' ");
        }
        sql.append("\r\n and t1.FAsstActId in (select fid from ");
        sql.append(param.getCussAcctTempTable()).append(") ");
        sql.append("\r\n and t1.FCompanyId = '");
        sql.append(param.getCompanyId().toString());
        sql.append("' and t1.FPeriodId = '");
        sql.append(periodInfo.getId().toString()).append("' \r\n");
        sql.append(" and t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 102);
        }
        sql.append(") and t1.FBalType IN (");
        if (param.isIncludeBizBill()) {
            if (param.getIncludeBizIndex() == 0) {
                sql.append(101 + (param.isArRpt() ? ",104" : "") + ", 102" + "," + 103);
            } else {
                sql.append(102);
            }
        } else {
            sql.append(101 + (param.isArRpt() ? ",104" : "") + ", " + 103);
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(") \r\n group by baseCurrency.fnumber,baseCurrency.").append(nameFld).append(",t3.").append(nameFld);
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(") \r\n group by t2.fnumber,t2.").append(nameFld).append(",t3.").append(nameFld);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(") \r\n group by t2.fnumber,t2.").append(nameFld).append(", baseCurrency.fnumber,baseCurrency.").append(nameFld).append(",t3.").append(nameFld);
        }
        if (fSumByCussAcct) {
            sql.append(" ,t4.FNumber,t4.").append(nameFld).append(",t1.FAsstActId ");
        }
        if (param.isSumByDept()) {
            sql.append(" ,t5.").append(nameFld).append(",t5.FNumber,FAdminorgunitID ");
        } else if (param.isSumByPerson()) {
            sql.append(" ,t6.").append(nameFld).append(",t6.FNumber, FPersonId ");
        }
        logger.debug((Object)("itemRpt periodSum Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getItemAllCurrencySumSql(ItemRptQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(param.getTempTable());
        sql.append(" (FCurrNum, FCurrency, FCussType,");
        sql.append(param.isSumByCussAcct() ? " FCussAcctId," : "");
        sql.append(" FPeriodId, FPeriodYear, FPeriodNumber, FCurrSumOrder, ");
        sql.append(" FDescription, FDebitAmt, FCreditAmt, FDataType, fid)\r\n ");
        sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        sql.append(param.isSumByCussAcct() ? " null FCussAcctId, " : "");
        sql.append(" t1.FPeriodId, t1.FPeriodYear, t1.FPeriodNumber, ");
        sql.append(" 2 FCurrSumOrder, t1.FDescription ");
        sql.append(" FDescription, sum(t1.FDebitAmt) FDebitAmt");
        sql.append(", sum(t1.FCreditAmt) FCreditAmt, ");
        sql.append(7).append(" FDataType, newbosid('ARAPItem')");
        sql.append(" from ").append(param.getTempTable());
        sql.append(" t1\r\n ");
        sql.append(" where 1=1 ");
        sql.append(" and t1.FDataType = ").append(5);
        sql.append(" and t1.FDescription != 'tempSum' ");
        sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
        sql.append(" t1.FPeriodId, t1.FPeriodYear, ");
        sql.append(" t1.FPeriodNumber, t1.FDescription");
        if (param.isSumByCussAcct()) {
            sql.append("\r\n union all \r\n ");
            sql.append(" select t1.FCurrNum, t1.FCurrency, t1.FCussType, ");
            sql.append(" t1.FCussAcctId FCussAcctId, ");
            sql.append(" t1.FPeriodId, t1.FPeriodYear, t1.FPeriodNumber, ");
            sql.append(" 1 FCurrSumOrder, t1.FDescription ");
            sql.append(" FDescription, sum(t1.FDebitAmt) FDebitAmt");
            sql.append(", sum(t1.FCreditAmt) FCreditAmt, ");
            sql.append(7).append(" FDataType ,newbosid('ARAPItem')");
            sql.append(" from ").append(param.getTempTable());
            sql.append(" t1\r\n ");
            sql.append(" where 1=1 ");
            sql.append(" and t1.FDataType = ").append(5);
            sql.append(" and t1.FDescription != 'tempSum' ");
            sql.append("\r\n group by t1.FCurrNum, t1.FCurrency, ");
            sql.append(" t1.FCussType, t1.FCussAcctId, t1.FPeriodId, ");
            sql.append(" t1.FPeriodYear, t1.FPeriodNumber, t1.FDescription");
        }
        logger.debug((Object)("itemAllCurrencySum sql: \r\n " + sql));
        return sql.toString();
    }

    protected static String updatePeriodStartBalSql(ItemRptQueryParam param, String prePeriodId) {
        String tempTable = param.getTempTable();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" as t0 set ");
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" (FPeriodId, FBaseCurrency, FCussAcctId, FBalanceLocal)\r\n");
            sql.append(" = (select t3.FPeriodId, t3.FBaseCurrency, t3.FCussAcctId, ");
            sql.append(" tb.FBalanceLocal + t3.FBalanceLocal FBalanceLocal\r\n from ");
            sql.append(tempTable).append(" as t3, (select t1.FBaseCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId, ");
            } else if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPersonId, ");
            }
            sql.append(" sum(t1.FBalanceLocal + t1.FDebitAmtLocal - t1.FCreditAmtLocal)");
            sql.append(" as FBalanceLocal \r\n    from ").append(tempTable);
            sql.append(" t1 where (t1.FDataType = 0 or t1.FDataType = 2 )");
            sql.append(" and t1.FPeriodId = '").append(prePeriodId).append("' ");
            sql.append("\r\n group by t1.FBaseCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId");
            }
            sql.append(param.isSumByDept() ? "t1.FAdminOrgId" : "");
            sql.append(param.isSumByPerson() ? "t1.FPersonId" : "");
            sql.append(", t1.FPeriodId) as tb ");
            sql.append("\r\n where t3.FPeriodId = '");
            sql.append(param.getPeriodId()).append("'\r\n and ");
            sql.append(" t3.FBaseCurrency = tb.FBaseCurrency ");
            sql.append(" and t0.FBaseCurrency = t3.FBaseCurrency\r\n");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" (FPeriodId, FCurrency, FCussAcctId, FBalance)\r\n");
            sql.append(" = (select t3.FPeriodId, t3.FCurrency, t3.FCussAcctId, ");
            sql.append(" tb.FBalance + t3.FBalance FBalance\r\n from ");
            sql.append(tempTable).append(" as t3, (select t1.FCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId, ");
            } else if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPersonId, ");
            }
            sql.append(" sum(t1.FBalance + t1.FDebitAmt - t1.FCreditAmt)");
            sql.append(" as FBalance \r\n    from ").append(tempTable);
            sql.append(" t1 where (t1.FDataType = 0 or t1.FDataType = 2 )");
            sql.append(" and t1.FPeriodId = '").append(prePeriodId).append("' ");
            sql.append("\r\n group by t1.FCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId");
            }
            sql.append(param.isSumByDept() ? "t1.FAdminOrgId" : "");
            sql.append(param.isSumByPerson() ? "t1.FPersonId" : "");
            sql.append(", t1.FPeriodId) as tb ");
            sql.append("\r\n where t3.FPeriodId = '");
            sql.append(param.getPeriodId()).append("'\r\n and ");
            sql.append(" t3.FCurrency = tb.FCurrency ");
            sql.append(" and t0.FCurrency = t3.FCurrency\r\n");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" (FPeriodId, FCurrency, FBaseCurrency, FCussAcctId, FBalance, FBalanceLocal)\r\n");
            sql.append(" = (select t3.FPeriodId, t3.FCurrency, t3.FBaseCurrency, t3.FCussAcctId, ");
            sql.append(" tb.FBalance + t3.FBalance FBalance, tb.FBalanceLocal + t3.FBalanceLocal FBalanceLocal \r\n from ");
            sql.append(tempTable).append(" as t3, (select t1.FCurrency, t1.FBaseCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId, ");
            } else if (param.isSumByDept()) {
                sql.append(" t1.FAdminOrgId, ");
            } else if (param.isSumByPerson()) {
                sql.append(" t1.FPersonId, ");
            }
            sql.append(" sum(t1.FBalance + t1.FDebitAmt - t1.FCreditAmt)");
            sql.append(" as FBalance, sum(t1.FBalanceLocal + t1.FDebitAmtLocal - t1.FCreditAmtLocal) as FBalanceLocal \r\n    from ").append(tempTable);
            sql.append(" t1 where (t1.FDataType = 0 or t1.FDataType = 2 )");
            sql.append(" and t1.FPeriodId = '").append(prePeriodId).append("' ");
            sql.append("\r\n group by t1.FCurrency, t1.FBaseCurrency, ");
            if (fSumByCussAcct) {
                sql.append(" t1.FCussAcctId");
            }
            sql.append(param.isSumByDept() ? "t1.FAdminOrgId" : "");
            sql.append(param.isSumByPerson() ? "t1.FPersonId" : "");
            sql.append(", t1.FPeriodId) as tb ");
            sql.append("\r\n where t3.FPeriodId = '");
            sql.append(param.getPeriodId()).append("'\r\n and ");
            sql.append(" t3.FCurrency = tb.FCurrency and t3.FBaseCurrency = tb.FBaseCurrency ");
            sql.append(" and t0.FCurrency = t3.FCurrency and t0.FBaseCurrency = t3.FBaseCurrency\r\n");
        }
        if (fSumByCussAcct) {
            sql.append(" and t3.FCussAcctId = tb.FCussAcctId ");
            sql.append(" and t0.FCussAcctId = t3.FCussAcctId ");
        } else if (param.isSumByDept()) {
            sql.append(" and t3.FAdminOrgId = tb.FAdminOrgId ");
            sql.append(" and t0.FAdminOrgId = t3.FAdminOrgId ");
        } else if (param.isSumByPerson()) {
            sql.append(" and t3.FPersonId = tb.FPersonId ");
            sql.append(" and t0.FPersonId = t3.FPersonId ");
        }
        sql.append("\r\n and t0.FPeriodId = t3.FPeriodId ) ");
        logger.debug((Object)("updatePeriodStart :\r\n" + sql));
        return sql.toString();
    }

    protected static String delBalZeroSql(String tempTable, String field) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(tempTable);
        sql.append(" where ").append(field).append(" in \r\n(select ");
        sql.append(" t1.").append(field).append(" from (select t0.");
        sql.append(field).append(",");
        sql.append(" t0.FPeriodId, t0.FBalance from ");
        sql.append(tempTable);
        sql.append(" t0 where t0.FDataType = ").append(0);
        sql.append(") t1 \r\n left join (select t01.").append(field);
        sql.append(", t01.FPeriodId, ");
        sql.append(" t01.FDebitAmt, t01.FCreditAmt from ");
        sql.append(tempTable);
        sql.append(" t01 where FDataType = ").append(5);
        sql.append(" ) t2 \r\n on t1.").append(field).append(" = t2.");
        sql.append(field).append(" and ");
        sql.append(" t1.FPeriodId = t2.FPeriodId \r\n ");
        sql.append("where (t1.FBalance + ");
        sql.append(" t2.FDebitAmt -  t2.FCreditAmt ) = 0 )");
        logger.debug((Object)("itemRpt delBalZero Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String delAllCurrencyBizZeroSql(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(tempTable);
        sql.append(" where FDebitAmt = 0  and FCreditAmt = 0 ");
        sql.append(" and FDataType = ").append(7);
        logger.debug((Object)("itemRpt AllCurrency delBizZero Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String delAllCurrencyBizZeroSql(String tempTable, ItemRptQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(tempTable);
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" where FDebitAmtLocal = 0  and FCreditAmtLocal = 0 ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" where FDebitAmt = 0  and FCreditAmt = 0 ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" where FDebitAmt = 0  and FCreditAmt = 0");
        }
        sql.append(" and FDataType = ").append(7);
        logger.debug((Object)("itemRpt AllCurrency delBizZero Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String blankStartSql(Context ctx, ItemRptQueryParam param, PeriodInfo qryPeriod, boolean fStart, DateFormat format) {
        Locale locale = ctx.getLocale();
        String nameFld = ArApReportHelper.getNameFld(ctx);
        String sDate = "";
        String fmtDate = "";
        String lbl = "";
        int periodNum = qryPeriod.getPeriodNumber();
        String periodDesc = qryPeriod.getPeriodYear() + "-";
        periodDesc = periodNum >= 10 ? periodDesc + periodNum : periodDesc + "0" + periodNum;
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sDate = dtFormat.format(param.getBeginDate());
        if (fStart) {
            if (format != null) {
                fmtDate = format.format(param.getBeginDate());
            }
            lbl = param.isByPeriod() ? periodDesc + ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName1", (Locale)locale) : fmtDate + ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"dayBalance", (Locale)locale);
        } else {
            lbl = periodDesc + ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"abstractName1", (Locale)locale);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(param.getTempTable());
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n (FBaseCurrNum, FBaseCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n (FCurrNum, FCurrency, FCussType, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n (FCurrNum, FCurrency, FBaseCurrNum, FBaseCurrency, FCussType, ");
        }
        boolean fSumByCussAcct = param.isSumByCussAcct();
        if (fSumByCussAcct) {
            sql.append("FCussNum, FCussName, FCussAcctId,");
        }
        sql.append(param.isSumByDept() ? "FAdminOrg, FAdminOrgNum, FAdminOrgId, " : "");
        sql.append(param.isSumByPerson() ? "FPerson, FPersonNum, FPersonId, " : "");
        sql.append(" FDataType, FDescription, FBillDate, FPeriodId");
        sql.append(", FPeriodYear, FPeriodNumber,Fid");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(") \r\n select t2.FNumber FBaseCurrNum, t2.").append(nameFld);
            sql.append(" FBaseCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(") \r\n select t2.FNumber FCurrNum, t2.").append(nameFld);
            sql.append(" FCurrency");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(") \r\n select t2.FNumber FCurrNum, t2.").append(nameFld);
            sql.append(" FCurrency,");
            sql.append(" t2.baseCurrencyNo FBaseCurrNum, t2.baseCurrencyName FBaseCurrency");
        }
        sql.append(", N'").append(param.getCussAcctTypeInfo().getName());
        sql.append("' FCussType, ");
        if (fSumByCussAcct) {
            sql.append("t1.FNumber FCussNum");
            sql.append(", t1.").append(nameFld).append(" FCussName");
            sql.append(", t1.FId FCussAcctId, ");
        } else if (param.isSumByDept()) {
            sql.append("t1.").append(nameFld).append(" FAdminOrg, ");
            sql.append("t1.FNumber FAdminOrgNumber, ");
            sql.append("t1.FId FAdminOrgId, ");
        } else if (param.isSumByPerson()) {
            sql.append("t1.").append(nameFld).append(" FPerson, ");
            sql.append("t1.FNumber FPersonNumber, ");
            sql.append("t1.FId FPersonId, ");
        }
        sql.append(fStart ? 0 : 1);
        sql.append(" FDataType,\r\n N'").append(lbl);
        sql.append("' FDescription, {").append(sDate);
        sql.append("} FBillDate, '").append(qryPeriod.getString("id"));
        sql.append("' FPeriodId, ").append(qryPeriod.getPeriodYear());
        sql.append(" FPeriodYear, ").append(qryPeriod.getPeriodNumber());
        sql.append(" FPeriodNumber, newbosid('ARAPItem') ");
        if (fSumByCussAcct) {
            sql.append("\r\n from ").append(param.getCussAcctTempTable());
        } else if (param.isSumByDept()) {
            sql.append("\r\n from ").append(param.getAdminOrgTempTable());
            sql.append(" \r\n ");
        } else if (param.isSumByPerson()) {
            sql.append("\r\n from ").append(param.getPersonTempTable());
            sql.append(" \r\n ");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" t1 cross join ");
            sql.append(" (select baseCurrency.FNumber, baseCurrency.").append(nameFld);
            sql.append(" from t_bd_currency baseCurrency");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FBaseCurrencyID=baseCurrency.FId and company.FID='" + param.getCompanyId() + "'").append("\r\n");
            sql.append(" ) t2 \r\n ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append(" t1 cross join ");
            sql.append(" (select FNumber, ").append(nameFld);
            sql.append(" from t_bd_currency ");
            if (param.isAllCurrency()) {
                sql.append(" where fid != '");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and FId != '");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("' ");
            } else {
                sql.append(" where Fid = '").append(param.getCurrencyId()).append("' ");
            }
            sql.append(" ) t2 \r\n ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" t1 cross join ");
            sql.append(" (select currency.FNumber, currency.").append(nameFld);
            sql.append(", select FNumber from t_bd_currency where fid =(select FBaseCurrencyID from T_ORG_Company where FID='" + param.getCompanyId() + "') baseCurrencyNo,");
            sql.append(" select FName_l2 from t_bd_currency where fid =(select FBaseCurrencyID from T_ORG_Company where FID='" + param.getCompanyId() + "') baseCurrencyName");
            sql.append(" from t_bd_currency currency");
            if (param.isAllCurrency()) {
                sql.append(" where currency.fid != '");
                sql.append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
                sql.append("' and currency.FId != '");
                sql.append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
                sql.append("' ");
            } else {
                sql.append(" where currency.Fid = '").append(param.getCurrencyId()).append("' ");
            }
            sql.append(" ) t2 \r\n ");
        }
        if (!fSumByCussAcct) {
            sql.append(" where t1.FId != '").append("z");
            sql.append("' or t1.FId is null");
        }
        logger.debug((Object)("ItemRpt BlankStart Sql: \r\n" + sql));
        return sql.toString();
    }

    protected static String getRptDataSql(Context ctx, ItemRptQueryParam param, boolean limit, String selector) {
        String tempTable = param.getTempTable();
        if (StringUtils.isEmpty((String)tempTable)) {
            return null;
        }
        boolean fCussRange = StringUtils.isEmpty((String)param.getCussAcctId());
        boolean fSumByCussAcct = param.isSumByCussAcct();
        String field = "FCussAcctId";
        field = fSumByCussAcct ? "FCussAcctId" : (param.isSumByDept() ? "FAdminOrgId" : "FPersonId");
        boolean isJoin = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        if (limit) {
            sql.append(" top ").append(param.getEndIndex());
        }
        if (!StringUtils.isEmpty((String)selector)) {
            String[] selectorArr = selector.split(",");
            int len = selectorArr.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append("t1.").append(selectorArr[i].trim());
            }
        } else {
            sql.append(" t1.* ");
        }
        String expenseSimpleNameField = "t3.FTypeSimpleName_" + ctx.getLocale().getLanguage();
        if (param.isCkBxMShortName()) {
            sql.append(", case when t2.FSHORTNAME IS NULL THEN " + expenseSimpleNameField + " ELSE  t2.FSHORTNAME END AS FSHORTNAME ");
            isJoin = true;
        }
        sql.append("from ").append(tempTable).append(" t1 ");
        if (isJoin) {
            sql.append("left join t_bd_material t2 on (t1.fmaterialid = t2.fid )");
            sql.append("left join T_BC_ExpenseType t3 on (t1.fexpenseItemId = t3.fid )");
        }
        sql.append(" WHERE 1=1");
        if (isJoin) {
            String str = " T2.FSHORTNAME >= '" + param.getTxtMShortNameFrom().trim() + "' ";
            String str1 = " T2.FSHORTNAME <= '" + param.getTxtMShortNameTo().trim() + "' ";
            if (param.getTxtMShortNameFrom().trim().length() > 0 && param.getTxtMShortNameTo().trim().length() > 0) {
                sql.append(" AND " + str + " AND " + str1);
            } else if (param.getTxtMShortNameFrom().trim().length() > 0 && param.getTxtMShortNameTo().trim().length() <= 0) {
                sql.append(" AND " + str);
            } else if (param.getTxtMShortNameFrom().trim().length() <= 0 && param.getTxtMShortNameTo().trim().length() > 0) {
                sql.append(" ( " + str1 + " OR T2.FSHORTNAME IS NULL )");
            }
        }
        if (fSumByCussAcct) {
            if (fCussRange) {
                sql.append(" And t1.FDataType != ");
                sql.append(7);
                sql.append(" or (t1.FDataType = ");
                sql.append(7);
                sql.append(" and t1.FCussAcctId is null)");
            } else {
                sql.append(" And t1.").append(field).append(" = '");
                sql.append(param.getCussAcctId());
                sql.append("' ");
            }
        } else if (!StringUtils.isEmpty((String)param.getCussAcctId())) {
            sql.append(" And t1.").append(field);
            sql.append(" = '").append(param.getCussAcctId()).append("' ");
        } else if (param.isQryAdminPersonNull()) {
            sql.append(" And t1.").append(field);
            sql.append(" is null ");
        }
        if ("base".equals(param.getCurrencyId())) {
            sql.append("\r\n order by t1.FBaseCurrNum, ");
        } else if (!"base".equals(param.getCurrencyId()) && !param.isBaseCurrency()) {
            sql.append("\r\n order by t1.FCurrNum, ");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("\r\n order by t1.FCurrNum,  t1.FBaseCurrNum, ");
        }
        if (fSumByCussAcct) {
            sql.append("t1.FCussNum, t1.FCussAcctId, ");
        } else if (param.isSumByDept()) {
            sql.append("t1.FAdminOrgNum, t1.FAdminOrgId, ");
        } else {
            sql.append("t1.FPersonNum, t1.FPersonId, ");
        }
        sql.append(param.isByPeriod() ? " t1.FPeriodYear, t1.FPeriodNumber, " : "");
        sql.append("t1.FCurrSumOrder, ");
        if (fSumByCussAcct) {
            sql.append(" t1.FDatatype, t1.FBillDate, ");
            sql.append("t1.FAdminOrgNum, t1.FPersonNum, ");
        } else if (param.isSumByDept()) {
            sql.append(" t1.FDatatype, t1.FBillDate, ");
            sql.append(" t1.FCussNum, t1.FPersonNum, ");
        } else {
            sql.append(" t1.FDatatype, t1.FBillDate, ");
            sql.append(" t1.FCussNum, t1.FAdminOrgNum, ");
        }
        sql.append("t1.FBillNum");
        sql.append(",t1.FContractNumber ");
        if (param.isShowMaterialItem()) {
            sql.append(", t1.FEntrySeq");
        }
        sql.append(",t1.FID ");
        logger.debug((Object)("get itemRptData \r\n" + sql));
        return sql.toString();
    }

    protected static String updateVerifBillEntryMaterialSql(Context ctx, String tbl, String matTbl, boolean fAr) throws BOSException {
        String nameFld = "FName_" + ctx.getLocale().getLanguage();
        StringBuffer iSql = new StringBuffer("");
        iSql.append("INSERT INTO ").append(matTbl);
        iSql.append(" (FEntryId, FMaterialName, FSpecName, FMeasureUnitName, FQtyPrecision)");
        iSql.append(" select distinct entry.FId, mat.").append(nameFld);
        iSql.append(", mat.FModel, tM.").append(nameFld);
        iSql.append(", tmmu.FQtyPrecision\r\n from ");
        iSql.append(tbl).append(" as t1\r\n inner join ");
        iSql.append(fAr ? "t_ar_otherbillEntry" : "t_ap_otherbillEntry");
        iSql.append(" as entry on t1.FEntryId = entry.FId \r\n ");
        iSql.append(" inner join t_bd_material as mat on mat.FId = entry.");
        iSql.append("FMaterialId \r\n left join T_BD_MeasureUnit as ");
        iSql.append("tM on tM.FId = entry.FMeasureUnitId \r\n left join ");
        iSql.append("T_BD_MultiMeasureUnit as tmmu on tmmu.FMaterialId = ");
        iSql.append("entry.FMaterialId\r\n and tmmu.FMeasureUnitId = ");
        iSql.append("entry.FMeasureUnitId\r\n where t1.FMaterialId is not null");
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            DBUtil.execute((Connection)con, (String)iSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        StringBuffer uSql = new StringBuffer();
        uSql.append("update ").append(tbl);
        uSql.append(" as t0 set (FMaterialName, FSpecName, FMeasureUnitName");
        uSql.append(", FQtyPrecision) =\r\n ");
        uSql.append("(SELECT FMaterialName, FSpecName, FMeasureUnitName, FQtyPrecision");
        uSql.append(" FROM ").append(matTbl).append(" t1 WHERE t0.FEntryId = t1.FEntryId");
        uSql.append(") where t0.FMaterialId is not null ");
        return uSql.toString();
    }

    protected static String updateVerifBillEntryExpenseSql(Context ctx, String tbl, boolean fAr) {
        String nameFld = "FName_" + ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tbl);
        sql.append(" as t0 set (FMaterialName, FQtyPrecision) ");
        sql.append(" =\r\n (select distinct exp.").append(nameFld);
        sql.append(", 2 FQtyPrecision\r\n from ");
        sql.append(tbl).append(" as t1\r\n left join ");
        sql.append(fAr ? "t_ar_otherbillEntry" : "t_ap_otherbillEntry");
        sql.append(" as entry on t1.FEntryId = entry.FId \r\n ");
        sql.append(" inner join T_BC_ExpenseType as exp on exp.FId = ");
        sql.append("entry.FExpenseItemID \r\n");
        sql.append(" where t1.FExpenseItemId is not null ");
        sql.append(" and t0.FEntryId = t1.FEntryId ");
        sql.append(") where t0.FExpenseItemId is not null ");
        logger.debug((Object)("updateVerifBillEntryExpenseFlds: \r\n " + sql));
        return sql.toString();
    }

    protected static String updateItemRptBillRowTypeSql(Context ctx, String tbl, boolean fAr) {
        String nameFld = "FName_" + ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tbl);
        sql.append(" as t0 set (FMaterialName, FMeasureUnitName, FQtyPrecision) ");
        sql.append(" =\r\n (select distinct entry.FMaterialName,");
        sql.append(" tM.").append(nameFld).append(", tM.FQtyPrecision\r\n from ");
        sql.append(tbl).append(" as t1\r\n left join ");
        sql.append(fAr ? "t_ar_otherbillEntry" : "t_ap_otherbillEntry");
        sql.append(" as entry on t1.FEntryId = entry.FId \r\n ");
        sql.append(" inner join T_SCM_RowType as tRow on tRow.FId =");
        sql.append(" entry.FRowTypeId \r\n  left join T_BD_MeasureUnit ");
        sql.append(" as tM on tM.FId = entry.FMeasureUnitId ");
        sql.append("\r\n  where t1.FExpenseItemId is null ");
        sql.append(" and t1.FMaterialId is null");
        sql.append(" and t0.FEntryId = t1.FEntryId\r\n");
        sql.append(" ) where t0.FExpenseItemId is null ");
        sql.append(" and t0.FMaterialId is null");
        logger.debug((Object)("updateItemRpt EntryRowTypeFlds: \r\n " + sql));
        return sql.toString();
    }
}

