/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.BalanceResult;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ManageAccount;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.ARAPAccountCheckBalance;
import com.kingdee.eas.fi.ar.app.AbstractManageAccountControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArApSQLHelper;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.app.util.KDQResultSet;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.arap.ArApShutAccountBizException;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApParams;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.ContrastGLRptParamConvertor;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.IBalanceCalculator;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ManageAccountControllerBean
extends AbstractManageAccountControllerBean {
    private static final long serialVersionUID = 1L;
    public static final String RT = "\r\n";
    private static final int ACCOUNT_VIEW_CONVERT_PERIOD = 13;
    private static final String AR_CLOSE_LOG_ITEM = "fi_ar_PeriodClose";
    private static final String AP_CLOSE_LOG_ITEM = "fi_ap_PeriodClose";
    private static final String AR_REVERSE_LOG_ITEM = "fi_ar_PeriodReverse";
    private static final String AP_REVERSE_LOG_ITEM = "fi_ap_PeriodReverse";

    @Override
    protected VoucherInfo _voucherLazyLoad(Context ctx, VoucherInfo voucher) throws BOSException, EASBizException {
        VoucherInfo result = this.voucherLazyLoad0(ctx, voucher);
        return result;
    }

    @Override
    protected void _closeArAccount(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        this.innerCloseARAccount(ctx, currentCompany);
    }

    @Override
    protected void _reverseCloseArAccount(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        this.processContext(ctx);
        String manipulateObject = this.getDisplayManipulateObject(company);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)AR_REVERSE_LOG_ITEM);
        this.innerCloseARAPAccount(ctx, company, true, OperationTypeEnum.Reverse);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _closeApAccount(Context ctx) throws BOSException, EASBizException {
        this.processContext(ctx);
        String manipulateObject = this.getDisplayManipulateObject(CommonServerUtils.getCurrentCompany(ctx));
        ObjectUuidPK pk = new ObjectUuidPK(CommonServerUtils.getCurrentCompany(ctx).getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), (IObjectPK)pk, (String)manipulateObject, (String)AP_REVERSE_LOG_ITEM);
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        this.innerCloseAPAccount(ctx, currentCompany);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _reverseCloseApAccount(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        this.processContext(ctx);
        String manipulateObject = this.getDisplayManipulateObject(company);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)AP_REVERSE_LOG_ITEM);
        this.innerCloseARAPAccount(ctx, company, false, OperationTypeEnum.Reverse);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void innerCloseARAccount(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, currentCompany);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        if (nextPeriod == null) {
            return;
        }
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, currentCompany.getId().toString(), currentPeriod.getNumber(), true);
        this.arSettleAccount(ctx, currentCompany, currentPeriod, nextPeriod, isContrastByBillAccount);
        if (nextPeriod.isIsAdjustPeriod()) {
            PeriodInfo next2Period = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
            this.arSettleAccount(ctx, currentCompany, nextPeriod, next2Period, isContrastByBillAccount);
            if (nextPeriod.getPeriodNumber() == 13) {
                this.updateAccountBalance(ctx, currentCompany, currentPeriod, nextPeriod, true);
            }
        }
        ArServerUtils.changeArCurrentPeriodToNext(ctx, currentCompany, nextPeriod);
        FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(currentCompany.getId().toString(), "rM52TBYcQFeaZMTzrzcMfM4XzhY=", currentPeriod.getId().toString(), false);
    }

    private void innerCloseAPAccount(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = ApServerUtils.getApCurrentPeriod(ctx, currentCompany);
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        if (nextPeriod == null) {
            return;
        }
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, currentCompany.getId().toString(), currentPeriod.getNumber(), false);
        this.apSettleAccount(ctx, currentCompany, currentPeriod, nextPeriod, isContrastByBillAccount);
        if (nextPeriod.isIsAdjustPeriod()) {
            PeriodInfo next2Period = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriod);
            this.apSettleAccount(ctx, currentCompany, nextPeriod, next2Period, isContrastByBillAccount);
            if (nextPeriod.getPeriodNumber() == 13) {
                this.updateAccountBalance(ctx, currentCompany, currentPeriod, nextPeriod, false);
            }
        }
        ApServerUtils.changeApCurrentPeriodToNext(ctx, currentCompany, nextPeriod);
        FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(currentCompany.getId().toString(), "ovBdLuutTl2CO/mJXrhncc4XzhY=", currentPeriod.getId().toString(), false);
    }

    private void innerreverseCloseApAccount(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        ArApServerUtils.changeCurrentPeriodToPrevious(ctx, currentCompany, false);
    }

    private void innerreverseCloseARAccount(Context ctx, CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        ArApServerUtils.changeCurrentPeriodToPrevious(ctx, currentCompany, true);
    }

    private void arSettleAccount(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, PeriodInfo nextPeriod, boolean isContrastByBillAccount) throws BOSException, EASBizException {
        this.calculateARBalance(ctx, currentPeriod, nextPeriod, currentCompany);
        if (isContrastByBillAccount) {
            this.calculateBillAccountBalance(ctx, currentPeriod, nextPeriod, currentCompany, true);
        } else {
            this.calculateARAccountBalance(ctx, currentPeriod, nextPeriod, currentCompany);
        }
    }

    private void calculateARAccountBalance(Context ctx, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String tableName = CommonUtils.getARAPBalanceTable("SYSTEM_AR", "ACCOUNT_NORMAL");
        if (!currentPeriod.isIsAdjustPeriod()) {
            ArApParams params = this.createT(ctx);
            CommonServerUtils.computeAcctBalance(ctx, true, currentPeriod, company, params, tableName);
        }
        CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tableName);
        CommonServerUtils.transferArBalance(ctx, "ACCOUNT_NORMAL", currentPeriod, nextPeriod, company);
        CommonServerUtils.transferContrastAccountView(ctx, 1, company, currentPeriod, nextPeriod);
    }

    private void calculateARBalance(Context ctx, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (currentPeriod.isIsAdjustPeriod()) {
            CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, "SYSTEM_AR", "DAILY_NORMAL", currentPeriod);
            CommonServerUtils.transferArBalance(ctx, "DAILY_NORMAL", currentPeriod, nextPeriod, company);
        } else {
            IBalanceCalculator arCalculator = BalanceCalculatorFactory.getCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("rZr83XuPQXGYgUePQ5LecSPUYjI="));
            arCalculator.calculate(company.getId().toString(), currentPeriod, OperationTypeEnum.Positive, false);
        }
    }

    private void calculateBillAccountBalance(Context ctx, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company, boolean isAr) throws BOSException, EASBizException {
        String type = "BILL_ACCOUNT";
        String system = isAr ? "SYSTEM_AR" : "SYSTEM_AP";
        int systemValue = isAr ? 1 : 2;
        String tableName = CommonUtils.getARAPBalanceTable(system, type);
        if (currentPeriod.isIsAdjustPeriod()) {
            CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tableName);
        } else {
            String companyID = company.getId().toString();
            ContrastGLQueryParam param = this.getDefaultParam(ctx, companyID, isAr, currentPeriod, true, true);
            String tempBalanceTable = CommonServerUtils.computeBillAccountBalance(ctx, currentPeriod, company, param, isAr);
            CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, currentPeriod, tempBalanceTable);
            CommonServerUtils.deleteBalanceData(ctx, tableName, companyID, currentPeriod);
            CommonServerUtils.copyBillAccountBalanceData(ctx, tempBalanceTable, tableName, companyID, currentPeriod.getId().toString());
        }
        CommonServerUtils.transferBalance(ctx, system, type, currentPeriod, nextPeriod, company);
        CommonServerUtils.transferContrastAccountView(ctx, systemValue, company, currentPeriod, nextPeriod);
    }

    private void apSettleAccount(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, PeriodInfo nextPeriod, boolean isContrastByBillAccount) throws BOSException, EASBizException {
        this.calculateAPBalance(ctx, currentPeriod, nextPeriod, currentCompany);
        if (isContrastByBillAccount) {
            this.calculateBillAccountBalance(ctx, currentPeriod, nextPeriod, currentCompany, false);
        } else {
            this.calculateAPAccountBalance(ctx, currentPeriod, nextPeriod, currentCompany);
        }
    }

    private void calculateAPAccountBalance(Context ctx, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String tableName = CommonUtils.getARAPBalanceTable("SYSTEM_AP", "ACCOUNT_NORMAL");
        if (!currentPeriod.isIsAdjustPeriod()) {
            ArApParams params = this.createT(ctx);
            CommonServerUtils.computeAcctBalance(ctx, false, currentPeriod, company, params, tableName);
        }
        CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, "SYSTEM_AP", "ACCOUNT_NORMAL", currentPeriod);
        CommonServerUtils.transferApBalance(ctx, "ACCOUNT_NORMAL", currentPeriod, nextPeriod, company);
        CommonServerUtils.transferContrastAccountView(ctx, 2, company, currentPeriod, nextPeriod);
    }

    private void calculateAPBalance(Context ctx, PeriodInfo currentPeriod, PeriodInfo nextPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (currentPeriod.isIsAdjustPeriod()) {
            CommonServerUtils.caculateCurrentPeriodBalance(ctx, company, "SYSTEM_AP", "DAILY_NORMAL", currentPeriod);
            CommonServerUtils.transferApBalance(ctx, "DAILY_NORMAL", currentPeriod, nextPeriod, company);
        } else {
            IBalanceCalculator apCalculator = BalanceCalculatorFactory.getCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK("ffjhq9qjQDajSUiiCFG1NCPUYjI="));
            apCalculator.calculate(company.getId().toString(), currentPeriod, OperationTypeEnum.Positive, false);
        }
    }

    private void updateAccountBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, PeriodInfo nextPeriod, boolean isAr) throws EASBizException, BOSException {
        String currAccounID = BaseDataUtil.getCurrentAccountTableID(ctx, currentPeriod, currentCompany);
        String nextAccounID = BaseDataUtil.getCurrentAccountTableID(ctx, nextPeriod, currentCompany);
        String companyId = currentCompany.getId().toString();
        if (!currAccounID.equalsIgnoreCase(nextAccounID)) {
            String refID = CommonServerUtils.getRefID(ctx, companyId, nextAccounID, currAccounID);
            ARAPAccountCheckBalance.updateAccountBalance(ctx, companyId, refID, currentPeriod.getNumber(), isAr);
        }
    }

    private ArApParams createT(Context ctx) throws BOSException {
        ArApParams params = new ArApParams();
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        String tempTableDefine = CommonServerUtils.arapTempTableDefine("ACCOUNT_NORMAL");
        String tempTable = TempTableUtil.createTempTable(ctx, tempTableDefine);
        String tempTable1 = TempTableUtil.createTempTable(ctx, tempTableDefine);
        String tempTable2 = TempTableUtil.createTempTable(ctx, tempTableDefine);
        String tempTable3 = TempTableUtil.createTempTable(ctx, tempTableDefine);
        String tempTable4 = TempTableUtil.createTempTable(ctx, tempTableDefine);
        params.setString("CommonServerUtils.computeAcctBalance.tempTable", tempTable);
        params.setString("CommonServerUtils.computeAcctBalance.tempTable1", tempTable1);
        params.setString("CommonServerUtils.computeAcctBalance.tempTable2", tempTable2);
        params.setString("CommonServerUtils.computeAcctBalance.tempTable3", tempTable3);
        params.setString("CommonServerUtils.computeAcctBalance.resultTempTable", tempTable4);
        try {
            t.createIndex(tempTable, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            t.createIndex(tempTable1, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            t.createIndex(tempTable2, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            t.createIndex(tempTable3, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            t.createIndex(tempTable4, "FCompanyID,FCurrencyID,FAsstActTypeID,FAsstActID,FAccountID,FAdminOrgUnitID,FPersonID", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        tempTableDefine = ArApSQLHelper.getTempTableDefine();
        params.setString("CommonServerUtils.computeAcctBalance.computeRecBill.tempTable", TempTableUtil.createTempTable(ctx, tempTableDefine));
        params.setString("CommonServerUtils.computeAcctBalance.computePayBill.tempTable", TempTableUtil.createTempTable(ctx, tempTableDefine));
        tempTableDefine = ArApSQLHelper.getRecBillTempTableDefine();
        params.setString("CommonServerUtils.computeAcctBalance.computeReceivingBillEntry.tempTable", TempTableUtil.createTempTable(ctx, tempTableDefine));
        return params;
    }

    @Override
    protected Vector _balanceARToGL(Context ctx, String type) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
        Vector result = this.balanceARAPToGL(ctx, "SYSTEM_AR", type, company, currentPeriod);
        return result;
    }

    @Override
    protected Vector _balanceAPToGL(Context ctx, String type) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo currentPeriod = ApServerUtils.getApCurrentPeriod(ctx, company);
        Vector result = this.balanceARAPToGL(ctx, "SYSTEM_AP", type, company, currentPeriod);
        return result;
    }

    protected IObjectValue _voucherLazyLoad(Context ctx, IObjectValue voucherInfo) throws BOSException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void _reComputeArAccountBalance(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo startPeriod = ArServerUtils.getArStartPeriod(ctx, currentCompany);
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, currentCompany);
        boolean currentPeriodIsStarePeriod = false;
        int compareResult = CommonServerUtils.periodCompare(ctx, startPeriod.getId().toString(), currentPeriod.getId().toString());
        currentPeriodIsStarePeriod = compareResult == 0;
        PeriodInfo previousPeriod = null;
        if (!currentPeriodIsStarePeriod) {
            previousPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        }
        if (currentPeriodIsStarePeriod) {
            CommonServerUtils.transferArBalance(ctx, "ACCOUNT_INITIAL", previousPeriod, currentPeriod, currentCompany);
        } else {
            CommonServerUtils.transferArBalance(ctx, "ACCOUNT_NORMAL", previousPeriod, currentPeriod, currentCompany);
        }
    }

    @Override
    protected void _reComputeApAccountBalance(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        PeriodInfo startPeriod = ApServerUtils.getApStartPeriod(ctx, currentCompany);
        PeriodInfo currentPeriod = ApServerUtils.getApCurrentPeriod(ctx, currentCompany);
        boolean currentPeriodIsStarePeriod = false;
        int compareResult = CommonServerUtils.periodCompare(ctx, startPeriod.getId().toString(), currentPeriod.getId().toString());
        currentPeriodIsStarePeriod = compareResult == 0;
        PeriodInfo previousPeriod = null;
        if (!currentPeriodIsStarePeriod) {
            previousPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        }
        if (currentPeriodIsStarePeriod) {
            CommonServerUtils.transferApBalance(ctx, "ACCOUNT_INITIAL", previousPeriod, currentPeriod, currentCompany);
        } else {
            CommonServerUtils.transferApBalance(ctx, "ACCOUNT_NORMAL", previousPeriod, currentPeriod, currentCompany);
        }
    }

    private Vector balanceARAPToGL(Context ctx, String system, String type, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        if (!"SYSTEM_AP".equals(system) && !"SYSTEM_AR".equals(system)) {
            throw new IllegalArgumentException();
        }
        if (company == null) {
            throw new IllegalArgumentException();
        }
        if (period == null) {
            throw new IllegalArgumentException();
        }
        if (!type.equals("COMMON") && !type.equals("RELATEGL")) {
            throw new IllegalArgumentException();
        }
        Connection connection = CommonServerUtils.getConnection(ctx);
        Vector<BalanceResult> result = new Vector<BalanceResult>();
        KDQResultSet ARAPAccountBalance = null;
        try {
            ARAPAccountBalance = this.getARAPAccountBalance(ctx, connection, system, company, period);
            ResultSet ARAPAccountBalanceRS = ARAPAccountBalance.getResultSet();
            while (ARAPAccountBalanceRS.next()) {
                KDQResultSet GLAccountBalance;
                ResultSet GLAccountBalanceRS;
                String accountID = ARAPAccountBalanceRS.getString("FAccount");
                String accountName = ARAPAccountBalanceRS.getString("FAccountName");
                int accountDirection = ARAPAccountBalanceRS.getInt("FDirection");
                String currencyID = ARAPAccountBalanceRS.getString("FCurrencyID");
                String currencyName = ARAPAccountBalanceRS.getString("FCurrencyName");
                BigDecimal beginBalanceFor = ARAPAccountBalanceRS.getBigDecimal("FBeginBalanceFor");
                BigDecimal yearDebitFor = ARAPAccountBalanceRS.getBigDecimal("FYearDebitFor");
                BigDecimal yearCreditFor = ARAPAccountBalanceRS.getBigDecimal("FYearCreditFor");
                if (type.equals("RELATEGL")) {
                    BigDecimal debitFor = ARAPAccountBalanceRS.getBigDecimal("FDebitFor");
                    yearDebitFor = yearDebitFor.subtract(debitFor);
                    BigDecimal creditFor = ARAPAccountBalanceRS.getBigDecimal("FCreditFor");
                    yearCreditFor = yearCreditFor.subtract(creditFor);
                }
                if ((GLAccountBalanceRS = (GLAccountBalance = this.getGLAccountBalance(connection, period, company, accountID, currencyID)).getResultSet()).next()) {
                    BigDecimal glBeginBalanceFor = GLAccountBalanceRS.getBigDecimal("FBeginBalanceFor");
                    BigDecimal glYearDebitFor = GLAccountBalanceRS.getBigDecimal("FYearDebitFor");
                    BigDecimal glYearCreditFor = GLAccountBalanceRS.getBigDecimal("FYearCreditFor");
                    if (type.equals("RELATEGL")) {
                        BigDecimal glDebitFor = GLAccountBalanceRS.getBigDecimal("FDebitFor");
                        glYearDebitFor = glYearDebitFor.subtract(glDebitFor);
                        BigDecimal glCreditFor = GLAccountBalanceRS.getBigDecimal("FCreditFor");
                        glYearCreditFor = glYearCreditFor.subtract(glCreditFor);
                    }
                    if (!(beginBalanceFor.equals(glBeginBalanceFor) && yearDebitFor.equals(glYearDebitFor) && yearCreditFor.equals(glYearCreditFor))) {
                        BalanceResult balanceResult = new BalanceResult();
                        balanceResult.account = accountName;
                        balanceResult.currency = currencyName;
                        balanceResult.asstActType = "";
                        balanceResult.asstAct = "";
                        balanceResult.beginBalanceFor = beginBalanceFor;
                        balanceResult.yearDebitFor = yearDebitFor;
                        balanceResult.yearCreditFor = yearCreditFor;
                        balanceResult.glBeginBalanceFor = glBeginBalanceFor;
                        balanceResult.glYearDebitFor = glYearDebitFor;
                        balanceResult.glYearCreditFor = glYearCreditFor;
                        balanceResult.direction = accountDirection;
                        balanceResult.adjustData();
                        result.add(balanceResult);
                    }
                    if (GLAccountBalanceRS.next()) {
                        throw new UnsupportedOperationException("Data is error!");
                    }
                } else {
                    BigDecimal zero = new BigDecimal(0);
                    if (!(beginBalanceFor.equals(zero.setScale(beginBalanceFor.scale())) && yearDebitFor.equals(zero.setScale(yearDebitFor.scale())) && yearCreditFor.equals(zero.setScale(yearCreditFor.scale())))) {
                        BalanceResult balanceResult = new BalanceResult();
                        balanceResult.account = accountName;
                        balanceResult.currency = currencyName;
                        balanceResult.asstActType = "";
                        balanceResult.asstAct = "";
                        balanceResult.beginBalanceFor = beginBalanceFor;
                        balanceResult.yearDebitFor = yearDebitFor;
                        balanceResult.yearCreditFor = yearCreditFor;
                        balanceResult.glBeginBalanceFor = null;
                        balanceResult.glYearDebitFor = null;
                        balanceResult.glYearCreditFor = null;
                        balanceResult.direction = accountDirection;
                        balanceResult.adjustData();
                        result.add(balanceResult);
                    }
                }
                GLAccountBalance.close();
                Map accountAsstActType = this.getAccountAsstActType(ctx, connection, accountID);
                KDQResultSet ARAPAssistBalance = this.getARAPAssistBalance(ctx, connection, system, company, period, accountID);
                ResultSet ARAPAssistBalanceRS = ARAPAssistBalance.getResultSet();
                while (ARAPAssistBalanceRS.next()) {
                    String asstActType = ARAPAssistBalanceRS.getString("FAsstActTypeID");
                    String asstAct = ARAPAssistBalanceRS.getString("FAsstActID");
                    BigDecimal beginBalanceFor2 = ARAPAssistBalanceRS.getBigDecimal("FBeginBalanceFor");
                    BigDecimal yearDebitFor2 = ARAPAssistBalanceRS.getBigDecimal("FYearDebitFor");
                    BigDecimal yearCreditFor2 = ARAPAssistBalanceRS.getBigDecimal("FYearCreditFor");
                    if (type.equals("RELATEGL")) {
                        BigDecimal debitFor = ARAPAssistBalanceRS.getBigDecimal("FDebitFor");
                        yearDebitFor2 = yearDebitFor2.subtract(debitFor);
                        BigDecimal creditFor = ARAPAssistBalanceRS.getBigDecimal("FCreditFor");
                        yearCreditFor2 = yearCreditFor2.subtract(creditFor);
                    }
                    if (asstActType == null || !accountAsstActType.containsKey(asstActType)) continue;
                    AsstActType asstActTypeObject = (AsstActType)accountAsstActType.get(asstActType);
                    KDQResultSet GLAssistBalance = this.getGLAssistBalance(ctx, connection, period, company, accountID, currencyID, asstActTypeObject, asstAct);
                    ResultSet GLAssistBalanceRS = GLAssistBalance.getResultSet();
                    if (GLAssistBalanceRS.next()) {
                        BigDecimal glBeginBalanceFor = GLAssistBalanceRS.getBigDecimal("FBeginBalanceFor");
                        BigDecimal glYearDebitFor = GLAssistBalanceRS.getBigDecimal("FYearDebitFor");
                        BigDecimal glYearCreditFor = GLAssistBalanceRS.getBigDecimal("FYearCreditFor");
                        if (type.equals("RELATEGL")) {
                            BigDecimal glDebitFor = GLAssistBalanceRS.getBigDecimal("FDebitFor");
                            glYearDebitFor = glYearDebitFor.subtract(glDebitFor);
                            BigDecimal glCreditFor = GLAssistBalanceRS.getBigDecimal("FCreditFor");
                            glYearCreditFor = glYearCreditFor.subtract(glCreditFor);
                        }
                        if (!(beginBalanceFor2.equals(glBeginBalanceFor) && yearDebitFor2.equals(glYearDebitFor) && yearCreditFor2.equals(glYearCreditFor))) {
                            BalanceResult balanceResult = new BalanceResult();
                            balanceResult.account = accountName;
                            balanceResult.currency = currencyName;
                            balanceResult.asstActType = asstActTypeObject.name;
                            balanceResult.asstAct = this.getAsstActName(ctx, asstActTypeObject, asstAct);
                            balanceResult.beginBalanceFor = beginBalanceFor2;
                            balanceResult.yearDebitFor = yearDebitFor2;
                            balanceResult.yearCreditFor = yearCreditFor2;
                            balanceResult.glBeginBalanceFor = glBeginBalanceFor;
                            balanceResult.glYearDebitFor = glYearDebitFor;
                            balanceResult.glYearCreditFor = glYearCreditFor;
                            balanceResult.direction = accountDirection;
                            balanceResult.adjustData();
                            result.add(balanceResult);
                        }
                        if (!GLAssistBalanceRS.next()) continue;
                        throw new UnsupportedOperationException("Data is error!");
                    }
                    BigDecimal zero = new BigDecimal(0);
                    if (beginBalanceFor2.equals(zero.setScale(beginBalanceFor2.scale())) && yearDebitFor2.equals(zero.setScale(yearDebitFor2.scale())) && yearCreditFor2.equals(zero.setScale(yearCreditFor2.scale()))) continue;
                    BalanceResult balanceResult = new BalanceResult();
                    balanceResult.account = accountName;
                    balanceResult.currency = currencyName;
                    balanceResult.asstActType = asstActTypeObject.name;
                    balanceResult.asstAct = this.getAsstActName(ctx, asstActTypeObject, asstAct);
                    balanceResult.beginBalanceFor = beginBalanceFor2;
                    balanceResult.yearDebitFor = yearDebitFor2;
                    balanceResult.yearCreditFor = yearCreditFor2;
                    balanceResult.glBeginBalanceFor = null;
                    balanceResult.glYearDebitFor = null;
                    balanceResult.glYearCreditFor = null;
                    balanceResult.direction = accountDirection;
                    balanceResult.adjustData();
                    result.add(balanceResult);
                }
                ARAPAssistBalance.close();
            }
            ARAPAccountBalance.close();
            Vector<BalanceResult> vector = result;
            return vector;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ARAPAccountBalance != null) {
                ARAPAccountBalance.close();
            }
            SQLUtils.cleanup((Connection)connection);
        }
    }

    private Map getAccountAsstActType(Context ctx, Connection connection, String account) throws BOSException {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (account == null || account.length() == 0) {
            throw new IllegalArgumentException();
        }
        String fieldName_FName = CommonServerUtils.getLocaleField(ctx, "FName");
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" C.FAsstActTypeID FAsstActTypeID");
            buffer.append(" ,D." + fieldName_FName + " FAsstActTypeName");
            buffer.append(" ,D.FMappingFieldName FMappingFieldName");
            buffer.append(" ,D.FRealtionDataObject FRealtionDataObject");
            buffer.append(" from");
            buffer.append(" T_BD_AccountView A");
            buffer.append(",T_BD_AsstAccount B");
            buffer.append(",T_BD_AsstActGroupDetail C");
            buffer.append(",T_BD_AsstActType D");
            buffer.append(" where");
            buffer.append(" (A.FCAA=B.FID)");
            buffer.append(" and (B.FID=C.FAsstAccountID)");
            buffer.append(" and (C.FAsstActTypeID=D.FID)");
            buffer.append(" and (A.FID=?)");
            String sql = buffer.toString();
            statement = connection.prepareStatement(sql);
            statement.setString(1, account);
            resultSet = statement.executeQuery();
            HashMap<String, AsstActType> result = new HashMap<String, AsstActType>();
            while (resultSet.next()) {
                AsstActType asstActType = new AsstActType();
                asstActType.ID = resultSet.getString("FAsstActTypeID");
                asstActType.name = resultSet.getString("FAsstActTypeName");
                asstActType.mappingField = resultSet.getString("FMappingFieldName");
                asstActType.mappingTable = resultSet.getString("FRealtionDataObject");
                result.put(asstActType.ID, asstActType);
            }
            HashMap<String, AsstActType> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private KDQResultSet getARAPAccountBalance(Context ctx, Connection connection, String system, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        String fieldName_FName = CommonServerUtils.getLocaleField(ctx, "FName");
        StringBuffer buffer = new StringBuffer();
        buffer.append("select");
        buffer.append(" A.FAccount");
        buffer.append(" ,max(B.FDC) FDirection");
        buffer.append(" ,max(B." + fieldName_FName + ") FAccountName");
        buffer.append(" ,A.FCurrencyID");
        buffer.append(" ,max(C." + fieldName_FName + ") FCurrencyName");
        buffer.append(" ,sum(A.FBeginBalanceFor) FBeginBalanceFor");
        buffer.append(" ,sum(A.FYearDebitFor) FYearDebitFor");
        buffer.append(" ,sum(A.FYearCreditFor) FYearCreditFor");
        buffer.append(" ,sum(A.FDebitFor) FDebitFor");
        buffer.append(" ,sum(A.FCreditFor) FCreditFor");
        buffer.append(" from");
        buffer.append(" " + this.getARAPBalanceTable(system) + " A");
        buffer.append(" ,T_BD_AccountView B");
        buffer.append(" ,T_BD_Currency C");
        buffer.append(" where");
        buffer.append(" (A.FAccount=B.FID)");
        buffer.append(" and (A.FCurrencyID=C.FID)");
        buffer.append(" and (A.FCompanyID=?)");
        buffer.append(" and (A.FPeriodID=?)");
        buffer.append(" group by A.FAccount,A.FCurrencyID");
        String sql = buffer.toString();
        try {
            PreparedStatement prprdStmnt = connection.prepareStatement(sql);
            prprdStmnt.setString(1, company.getId().toString());
            prprdStmnt.setString(2, period.getId().toString());
            ResultSet resultSet = prprdStmnt.executeQuery();
            KDQResultSet result = new KDQResultSet(prprdStmnt, resultSet);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private KDQResultSet getARAPAssistBalance(Context ctx, Connection connection, String system, CompanyOrgUnitInfo company, PeriodInfo period, String account) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select");
        buffer.append(" A.FAsstActTypeID");
        buffer.append(" ,A.FAsstActID");
        buffer.append(" ,A.FBeginBalanceFor");
        buffer.append(" ,A.FYearDebitFor");
        buffer.append(" ,A.FYearCreditFor");
        buffer.append(" ,A.FDebitFor");
        buffer.append(" ,A.FCreditFor");
        buffer.append(" from");
        buffer.append(" " + this.getARAPBalanceTable(system) + " A");
        buffer.append(" where");
        buffer.append(" (A.FCompanyID=?)");
        buffer.append(" and (A.FPeriodID=?)");
        buffer.append(" and (A.FAccount=?)");
        String sql = buffer.toString();
        try {
            PreparedStatement prprdStmnt = connection.prepareStatement(sql);
            prprdStmnt.setString(1, company.getId().toString());
            prprdStmnt.setString(2, period.getId().toString());
            prprdStmnt.setString(3, account);
            ResultSet resultSet = prprdStmnt.executeQuery();
            KDQResultSet result = new KDQResultSet(prprdStmnt, resultSet);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getARAPBalanceTable(String system) {
        if ("SYSTEM_AR".equals(system)) {
            return "T_AR_ArBalanceCollate";
        }
        if ("SYSTEM_AP".equals(system)) {
            return "T_AP_ApBalanceCollate";
        }
        throw new IllegalArgumentException();
    }

    private KDQResultSet getGLAccountBalance(Connection connection, PeriodInfo period, CompanyOrgUnitInfo company, String account, String currency) throws BOSException {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (period == null) {
            throw new IllegalArgumentException();
        }
        if (company == null) {
            throw new IllegalArgumentException();
        }
        if (account == null || account.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (currency == null || currency.length() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("select");
        buffer.append(" FBeginBalanceFor");
        buffer.append(" ,FYearDebitFor");
        buffer.append(" ,FYearCreditFor");
        buffer.append(" ,FDebitFor");
        buffer.append(" ,FCreditFor");
        buffer.append(" from T_GL_AccountBalance_5f");
        buffer.append(" where");
        buffer.append(" and (FOrgUnitID=?)");
        buffer.append(" and (FPeriod=?)");
        buffer.append(" and (FAccountID=?)");
        buffer.append(" and (FCurrencyID=?)");
        String sql = buffer.toString();
        try {
            PreparedStatement prprdSttmnt = connection.prepareStatement(sql);
            prprdSttmnt.setString(1, company.getId().toString());
            prprdSttmnt.setInt(2, period.getNumber());
            prprdSttmnt.setString(3, account);
            prprdSttmnt.setString(4, currency);
            ResultSet resultSet = prprdSttmnt.executeQuery();
            KDQResultSet result = new KDQResultSet(prprdSttmnt, resultSet);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getAsstActName(Context ctx, AsstActType asstActTypeObject, String asstActID) throws BOSException {
        ResultSet resultSet;
        PreparedStatement prprdSttmnt;
        Connection connection;
        block6: {
            String fieldName_FName = CommonServerUtils.getLocaleField(ctx, "FName");
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" A." + fieldName_FName + " FAsstActName");
            buffer.append(" from");
            buffer.append(" " + asstActTypeObject.mappingTable + " A");
            buffer.append(" where");
            buffer.append(" (FID=?)");
            String sql = buffer.toString();
            connection = CommonServerUtils.getConnection(ctx);
            prprdSttmnt = null;
            resultSet = null;
            prprdSttmnt = connection.prepareStatement(sql);
            prprdSttmnt.setString(1, asstActID);
            resultSet = prprdSttmnt.executeQuery();
            if (!resultSet.next()) break block6;
            String asstActName = resultSet.getString("FAsstActName");
            if (resultSet.next()) {
                throw new IllegalArgumentException("Data is error!");
            }
            String string = asstActName;
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)prprdSttmnt, (Connection)connection);
            return string;
        }
        try {
            try {
                throw new IllegalArgumentException("Data is error!");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(resultSet, (Statement)prprdSttmnt, (Connection)connection);
            throw throwable;
        }
    }

    private KDQResultSet getGLAssistBalance(Context ctx, Connection connection, PeriodInfo period, CompanyOrgUnitInfo commpany, String account, String currency, AsstActType asstActTypeObject, String asstAct) throws BOSException {
        String fieldName_FName = CommonServerUtils.getLocaleField(ctx, "FName");
        String mappingField = asstActTypeObject.mappingField;
        String mappingTable = asstActTypeObject.mappingTable;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select");
        buffer.append(" sum(A.FBeginBalanceFor) FBeginBalanceFor");
        buffer.append(" ,sum(A.FYearDebitFor) FYearDebitFor");
        buffer.append(" ,sum(A.FYearCreditFor) FYearCreditFor");
        buffer.append(" ,sum(A.FDebitFor) FDebitFor");
        buffer.append(" ,sum(A.FCreditFor) FCreditFor");
        buffer.append(" ,max(C." + fieldName_FName + ") FAsstActName");
        buffer.append(" from");
        buffer.append("  T_GL_AssistBalance_5f A");
        buffer.append("  ,T_BD_AssistantHG B");
        buffer.append("  ," + mappingTable + " C");
        buffer.append(" where");
        buffer.append(" (A.FAssistGrpID=B.FID)");
        buffer.append(" and (B." + mappingField + "=C.FID)");
        buffer.append(" and (A.FOrgUnitID=?)");
        buffer.append(" and (A.FPeriod=?)");
        buffer.append(" and (A.FAccountID=?)");
        buffer.append(" and (A.FCurrencyID=?)");
        buffer.append(" and (B." + mappingField + "=?)");
        buffer.append(" group by B." + mappingField);
        String sql = buffer.toString();
        try {
            PreparedStatement prprdSttmnt = connection.prepareStatement(sql);
            prprdSttmnt.setString(1, commpany.getId().toString());
            prprdSttmnt.setInt(2, period.getNumber());
            prprdSttmnt.setString(3, account);
            prprdSttmnt.setString(4, currency);
            prprdSttmnt.setString(5, asstAct);
            ResultSet resultSet = prprdSttmnt.executeQuery();
            KDQResultSet result = new KDQResultSet(prprdSttmnt, resultSet);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private VoucherInfo voucherLazyLoad0(Context ctx, VoucherInfo vchinfo) throws BOSException, VoucherException, EASBizException {
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = VoucherInfo.getDefaultSelector();
        VoucherInfo vch = vchCtrl.exteriorLazyLoad((BaseVoucherInfo)vchinfo, selector);
        VoucherEntryInfo ve = null;
        AccountViewInfo acct = null;
        VoucherEntryCollection veColl = vch.getEntries();
        for (int i = 0; i < veColl.size(); ++i) {
            ve = veColl.get(i);
            acct = ve.getAccount();
            if (acct.getCAA() == null) continue;
            this.fillEntryHasAssist(ctx, ve, acct);
        }
        return vch;
    }

    private void fillEntryHasAssist(Context ctx, VoucherEntryInfo ve, AccountViewInfo acct) throws BOSException, VoucherException, EASBizException {
        AsstAccountInfo asstAct = null;
        String typeGroupId = null;
        if (acct.getCAA() == null) {
            return;
        }
        asstAct = acct.getCAA();
        typeGroupId = asstAct.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("asstActType.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)typeGroupId));
        IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
        AsstActGroupDetailCollection asstDeColl = relCtrl.getAsstActGroupDetailCollection(view);
        SelectorItemCollection sicHG = new SelectorItemCollection();
        for (AsstActGroupDetailInfo asstDe : asstDeColl) {
            AsstActTypeInfo asstType = asstDe.getAsstActType();
            sicHG.add(new SelectorItemInfo(asstType.getAsstHGAttribute() + ".id"));
            sicHG.add(new SelectorItemInfo(asstType.getAsstHGAttribute() + ".number"));
            sicHG.add(new SelectorItemInfo(asstType.getAsstHGAttribute() + ".name"));
        }
    }

    public Date upDate(Date oldDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldDate);
        calendar.add(5, 1);
        Date dateUp = new Date(calendar.getTime().getTime());
        return dateUp;
    }

    private String convertDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    @Override
    protected boolean _isUnAuditedOrVouchered(Context ctx, String checkType, String arap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        return this.innerIsUnAuditedOrVouchered(ctx, checkType, arap, currentCompany);
    }

    private boolean innerIsUnAuditedOrVouchered(Context ctx, String checkType, String arap, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        String currentCompanyID = currentCompany.getId().toString();
        boolean fAR = arap.equalsIgnoreCase("AR");
        PeriodInfo currentPeriod = null;
        currentPeriod = arap.equalsIgnoreCase("AR") ? ArServerUtils.getArCurrentPeriod(ctx, currentCompany) : ApServerUtils.getApCurrentPeriod(ctx, currentCompany);
        if (currentPeriod == null) {
            return false;
        }
        Date beginDate = currentPeriod.getBeginDate();
        String beginDateString = this.convertDateToString(beginDate);
        Date endDate = this.upDate(currentPeriod.getEndDate());
        String endDateString = this.convertDateToString(endDate);
        HashMap paramKeyMap = new HashMap();
        if (fAR) {
            paramKeyMap.put("AR_RECVOUCHER_BILLTYPE", currentCompanyID);
            paramKeyMap.put("AR_IS_PRE_REC_ACCT", currentCompanyID);
            paramKeyMap.put("AR_IS_BIZ_VOUCHER", currentCompanyID);
        } else {
            paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE", currentCompanyID);
            paramKeyMap.put("AP_IS_PRE_PAY_ACCT", currentCompanyID);
            paramKeyMap.put("AP_CONTRAST_ESTIMATE_GL", currentCompanyID);
        }
        paramKeyMap = ArApParamHelper.getParamHashMap(ctx, paramKeyMap);
        boolean fRecPay2Vou = paramKeyMap.containsKey(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE") && "1".equals(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE"));
        boolean fPreAcctVou = "true".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT"));
        boolean isBizBillVoucher = "true".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL"));
        StringBuffer sql = new StringBuffer("");
        sql.append("select top 1 FID from ");
        if ("AR".equalsIgnoreCase(arap)) {
            sql.append(" V_AR_CheckAuditedOrVouchered ");
        } else {
            sql.append(" V_AP_CheckAuditedOrVouchered ");
        }
        sql.append(" where (FCompanyID='" + currentCompanyID + "')");
        sql.append(" and (FBillDate>={" + beginDateString + "})");
        sql.append(" and (FBillDate<{" + endDateString + "})");
        if (checkType.equalsIgnoreCase("audited")) {
            sql.append(" and (FIsAudited = 0) ");
        } else {
            sql.append(" and (FIsAudited = 1) ");
            sql.append(" and (FFiVouchered = 0) ");
            if (!isBizBillVoucher) {
                sql.append(" AND FIsBizBill = 0 ");
            }
            if (fAR) {
                if (fRecPay2Vou && !fPreAcctVou) {
                    sql.append(" and FVeriType <> -100").append(RT);
                    sql.append(" and FVeriType <> -200").append(RT);
                } else if (fRecPay2Vou && fPreAcctVou) {
                    sql.append(" and ((FBillType = -1").append(RT);
                    sql.append(" and FVeriType = -1)").append(RT);
                    sql.append(" OR FVeriType = 1 ").append(RT);
                    sql.append(" OR FVeriType = -200)").append(RT);
                } else if (!fRecPay2Vou && !fPreAcctVou) {
                    sql.append(" and ((FBillType = -1").append(RT);
                    sql.append(" and FVeriType = -1)").append(RT);
                    sql.append(" OR (FVeriType = 1").append(RT);
                    sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append(RT);
                    sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
                    sql.append(" OR FVeriType = -100)").append(RT);
                } else if (!fRecPay2Vou && fPreAcctVou) {
                    sql.append(" and ((FBillType = -1").append(RT);
                    sql.append(" and FVeriType = -1)").append(RT);
                    sql.append(" OR (FVeriType = 1").append(RT);
                    sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append(RT);
                    sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
                    sql.append(" OR (FVeriType = -100").append(RT);
                    sql.append(" OR FVeriType = -200))").append(RT);
                }
            } else if (fRecPay2Vou && !fPreAcctVou) {
                sql.append(" and FVeriType <> -100").append(RT);
                sql.append(" and FVeriType <> -200").append(RT);
            } else if (fRecPay2Vou && fPreAcctVou) {
                sql.append(" and ((FBillType = -1").append(RT);
                sql.append(" and FVeriType = -1)").append(RT);
                sql.append(" OR FVeriType = 1 ").append(RT);
                sql.append(" OR FVeriType = -200)").append(RT);
            } else if (!fRecPay2Vou && !fPreAcctVou) {
                sql.append(" and ((FBillType = -1").append(RT);
                sql.append(" and FVeriType = -1)").append(RT);
                sql.append(" OR (FVeriType = 1").append(RT);
                sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append(RT);
                sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
                sql.append(" OR FVeriType = -100)").append(RT);
            } else if (!fRecPay2Vou && fPreAcctVou) {
                sql.append(" and ((FBillType = -1").append(RT);
                sql.append(" and FVeriType = -1)").append(RT);
                sql.append(" OR (FVeriType = 1").append(RT);
                sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append(RT);
                sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
                sql.append(" OR (FVeriType = -100").append(RT);
                sql.append(" OR FVeriType = -200))").append(RT);
            }
        }
        Connection conn = null;
        Statement pstmt = null;
        IRowSet rs = null;
        int rowCount = 0;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                rowCount = 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
        return rowCount > 0;
    }

    private static boolean isRecBillCreateVoucher(Context ctx, String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AR_RECVOUCHER_BILLTYPE"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    private static boolean isPayBillCreateVoucher(Context ctx, String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    public static boolean isPrePayAcct(Context ctx, String sCompanyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AP_IS_PRE_PAY_ACCT");
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean isPreRecAcct(Context ctx, String sCompanyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AR_IS_PRE_REC_ACCT");
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    @Override
    protected void _reComputeArInitAccountBalance(Context ctx) throws BOSException, EASBizException {
        CommonServerUtils.reComputeInitAccountBalance(ctx, "SYSTEM_AR");
    }

    @Override
    protected void _reComputeApInitAccountBalance(Context ctx) throws BOSException, EASBizException {
        CommonServerUtils.reComputeInitAccountBalance(ctx, "SYSTEM_AP");
    }

    @Override
    protected Map _unAuditedOrVouchered(Context ctx, String checkType, String arap, String checkBillType, Set idSet) throws BOSException, EASBizException {
        return this.innerUnAuditedOrVouchered(ctx, checkType, arap, checkBillType, idSet);
    }

    private Map innerUnAuditedOrVouchered(Context ctx, String checkType, String arap, String checkBillType, Set idSet) throws BOSException, EASBizException {
        HashMap<String, Boolean> checkMap = new HashMap<String, Boolean>();
        HashMap<String, CoreBaseCollection> veriBillMap = new HashMap<String, CoreBaseCollection>();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            CompanyOrgUnitInfo currentCompany = new CompanyOrgUnitInfo();
            currentCompany.setId(BOSUuid.read((String)it.next().toString()));
            String currentCompanyID = currentCompany.getId().toString();
            boolean fAR = arap.equalsIgnoreCase("AR");
            PeriodInfo currentPeriod = null;
            currentPeriod = fAR ? ArServerUtils.getArCurrentPeriod(ctx, currentCompany) : ApServerUtils.getApCurrentPeriod(ctx, currentCompany);
            if (currentPeriod == null) {
                checkMap.put(currentCompany.getId().toString(), Boolean.FALSE);
                continue;
            }
            Date beginDate = currentPeriod.getBeginDate();
            String beginDateString = this.convertDateToString(beginDate);
            Date endDate = this.upDate(currentPeriod.getEndDate());
            String endDateString = this.convertDateToString(endDate);
            HashMap paramKeyMap = new HashMap();
            if (fAR) {
                paramKeyMap.put("AR_RECVOUCHER_BILLTYPE", currentCompanyID);
                paramKeyMap.put("AR_IS_PRE_REC_ACCT", currentCompanyID);
                paramKeyMap.put("AR_IS_BIZ_VOUCHER", currentCompanyID);
                paramKeyMap.put("AR_RECVOUCHER_BILLTYPE_CASH", currentCompanyID);
                paramKeyMap.put("AR_038", currentCompanyID);
            } else {
                paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE_CASH", currentCompanyID);
                paramKeyMap.put("AP_PAYVOUCHER_BILLTYPE", currentCompanyID);
                paramKeyMap.put("AP_IS_PRE_PAY_ACCT", currentCompanyID);
                paramKeyMap.put("AP_CONTRAST_ESTIMATE_GL", currentCompanyID);
                paramKeyMap.put("AP_029", currentCompanyID);
            }
            paramKeyMap = ArApParamHelper.getParamHashMap(ctx, paramKeyMap);
            boolean fRecPay2Vou = paramKeyMap.containsKey(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE") && "1".equals(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE" : "AP_PAYVOUCHER_BILLTYPE"));
            boolean fPreAcctVou = "true".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_PRE_REC_ACCT" : "AP_IS_PRE_PAY_ACCT"));
            boolean isBizBillVoucher = "true".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL")) || "1".equals(paramKeyMap.get(fAR ? "AR_IS_BIZ_VOUCHER" : "AP_CONTRAST_ESTIMATE_GL"));
            boolean isCashVoucher = paramKeyMap.containsKey(fAR ? "AR_RECVOUCHER_BILLTYPE_CASH" : "AP_PAYVOUCHER_BILLTYPE_CASH") && "1".equals(paramKeyMap.get(fAR ? "AR_RECVOUCHER_BILLTYPE_CASH" : "AP_PAYVOUCHER_BILLTYPE_CASH"));
            boolean isCheckCashVerify = paramKeyMap.containsKey(fAR ? "AR_038" : "AP_029") && "true".equals(paramKeyMap.get(fAR ? "AR_038" : "AP_029"));
            StringBuffer sql = new StringBuffer("");
            sql.append("select distinct FID from ");
            if (fAR) {
                sql.append(" V_AR_CheckAuditedOrVouchered ");
            } else {
                sql.append(" V_AP_CheckAuditedOrVouchered ");
            }
            sql.append(" where (FCompanyID='" + currentCompanyID + "')");
            sql.append(" and FISCASH=0");
            sql.append(" and (FBillDate>={" + beginDateString + "})");
            sql.append(" and (FBillDate<{" + endDateString + "})");
            if (checkType.equalsIgnoreCase("audited")) {
                sql.append(" and (FIsAudited = 0) ");
            } else {
                sql.append(" and (FIsAudited = 1) ");
                sql.append(" and (FFiVouchered = 0) ");
                if (!isBizBillVoucher) {
                    sql.append(" AND FIsBizBill = 0 ");
                }
                if (checkBillType != null && !"".equals(checkBillType) && !checkBillType.equalsIgnoreCase("all")) {
                    sql.append(" and fbilltypedes = '").append(checkBillType).append("'");
                }
                if (fAR) {
                    if (fRecPay2Vou && !fPreAcctVou) {
                        sql.append(" and FVeriType <> -100").append(RT);
                        sql.append(" and FVeriType <> -200").append(RT);
                    } else if (fRecPay2Vou && fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR FVeriType = 1 ").append(RT);
                        sql.append(" OR FVeriType = -200)").append(RT);
                    } else if (!fRecPay2Vou && !fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR (FVeriType = 1").append(RT);
                        sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append(RT);
                        sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
                        sql.append(" OR FVeriType = -100)").append(RT);
                    } else if (!fRecPay2Vou && fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR (FVeriType = 1").append(RT);
                        sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(100))).append(RT);
                        sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(102))).append("))\r\n");
                        sql.append(" OR (FVeriType = -100").append(RT);
                        sql.append(" OR FVeriType = -200))").append(RT);
                    }
                } else {
                    if (fRecPay2Vou && !fPreAcctVou) {
                        sql.append(" and FVeriType <> -100").append(RT);
                        sql.append(" and FVeriType <> -200").append(RT);
                    } else if (fRecPay2Vou && fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR FVeriType = 1 ").append(RT);
                        sql.append(" OR FVeriType = -200)").append(RT);
                    } else if (!fRecPay2Vou && !fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR (FVeriType = 1").append(RT);
                        sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append(RT);
                        sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
                        sql.append(" OR FVeriType = -100)").append(RT);
                    } else if (!fRecPay2Vou && fPreAcctVou) {
                        sql.append(" and ((FBillType = -1").append(RT);
                        sql.append(" and FVeriType = -1)").append(RT);
                        sql.append(" OR (FVeriType = 1").append(RT);
                        sql.append(" and (FBillType != ").append(Integer.valueOf(String.valueOf(201))).append(RT);
                        sql.append(" AND FBillType != ").append(Integer.valueOf(String.valueOf(203))).append("))\r\n");
                        sql.append(" OR (FVeriType = -100").append(RT);
                        sql.append(" OR FVeriType = -200))").append(RT);
                    }
                    if (CalculateUtil.getDischargeType((Context)ctx, (String)currentCompanyID) != 0) {
                        sql.append(" AND FID not in (");
                        sql.append(CommonServerUtils.getSpecialNotVoucherApBillSql(currentCompanyID, beginDateString, endDateString));
                        sql.append(")");
                    }
                }
            }
            if (isCheckCashVerify) {
                StringBuffer cashSql = this.checkCashBillSql(fAR, currentCompanyID, beginDateString, endDateString);
                sql.append("\r\n union all \r\n").append(cashSql);
            }
            StringBuffer cashVouSql = this.checkCashVou(fAR, currentCompanyID, beginDateString, endDateString, isCashVoucher, checkType, checkBillType);
            sql.append("\r\n union all \r\n").append(cashVouSql);
            Connection conn = null;
            Statement pstmt = null;
            IRowSet rs = null;
            boolean isCheckGainAndLoss = ARAPCommonServerFacadeFactory.getLocalInstance((Context)ctx).isCheckGainAndLoss();
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (checkType.equalsIgnoreCase("audited") || isCheckGainAndLoss) {
                    if (!rs.next()) continue;
                    checkMap.put(currentCompany.getId().toString(), Boolean.TRUE);
                    continue;
                }
                HashSet<String> veriBillSet = new HashSet<String>();
                String bosType = fAR ? "3C41FD86" : "2F368848";
                int rowCount = 0;
                while (rs.next()) {
                    if (bosType.equals(BOSUuid.read((String)rs.getString(1)).getType().toString())) {
                        veriBillSet.add(rs.getString(1));
                    }
                    ++rowCount;
                }
                CoreBaseCollection coll = null;
                int veriBillNotVouchered = 0;
                if (veriBillSet.size() > 0) {
                    coll = CommonServerUtils.getGainAndLossVeriBill(ctx, fAR, fRecPay2Vou, fPreAcctVou, currentCompanyID, veriBillSet);
                    veriBillNotVouchered = coll.size();
                }
                if (rowCount > 0 && rowCount > veriBillNotVouchered) {
                    checkMap.put(currentCompany.getId().toString(), Boolean.TRUE);
                }
                if (coll == null || coll.size() <= 0) continue;
                veriBillMap.put(currentCompany.getId().toString(), coll);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
            }
        }
        HashMap<String, HashMap<String, Boolean>> result = new HashMap<String, HashMap<String, Boolean>>();
        result.put("checkMap", checkMap);
        result.put("veriBillMap", veriBillMap);
        return result;
    }

    private StringBuffer checkCashVou(boolean far, String currentCompanyID, String beginDateString, String endDateString, boolean isCashVoucher, String checkType, String checkBillType) {
        StringBuffer cashvouSql = new StringBuffer();
        cashvouSql.append(" select distinct FId  from ");
        cashvouSql.append(far ? " V_AR_CheckAuditedOrVouchered " : " V_AP_CheckAuditedOrVouchered ");
        cashvouSql.append("\r\n where FCompanyID='").append(currentCompanyID);
        cashvouSql.append("'\r\n and FISCASH=1");
        cashvouSql.append("\r\n and (FBillDate >= {").append(beginDateString);
        cashvouSql.append("} and FBillDate < {").append(endDateString).append("})");
        if (checkType.equalsIgnoreCase("audited")) {
            cashvouSql.append(" AND FIsAudited = 0");
        } else {
            cashvouSql.append(" AND FIsAudited = 1");
            StringBuffer billType = new StringBuffer("");
            if (isCashVoucher) {
                billType.append("\r\n and (FBILLTYPEDES='otherbill'");
                billType.append(far ? "or FBILLTYPEDES='receivingbill')" : "or FBILLTYPEDES='paymentBill')");
            } else {
                billType.append("\r\n and FBILLTYPEDES='verifyBill'");
            }
            cashvouSql.append("\r\n and FFiVouchered= 0 ").append(billType);
            if (checkBillType != null && !"".equals(checkBillType) && !checkBillType.equalsIgnoreCase("all")) {
                cashvouSql.append(" and fbilltypedes = '").append(checkBillType).append("'");
            }
        }
        return cashvouSql;
    }

    private StringBuffer checkCashBillSql(boolean far, String currentCompanyID, String beginDateString, String endDateString) {
        StringBuffer cashSql = new StringBuffer();
        cashSql.append("select distinct FID from ");
        if (far) {
            cashSql.append(" V_AR_CheckAuditedOrVouchered ");
        } else {
            cashSql.append(" V_AP_CheckAuditedOrVouchered ");
        }
        cashSql.append(" where (FCompanyID='" + currentCompanyID + "')");
        cashSql.append(" and FISCASH=1");
        cashSql.append(" and (FBillDate>={" + beginDateString + "})");
        cashSql.append(" and (FBillDate<{" + endDateString + "})");
        cashSql.append(" and fisUnver  = 1");
        return cashSql;
    }

    @Override
    protected boolean _isVoucherTransBill(Context ctx, String arap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = CommonServerUtils.getCurrentCompany(ctx);
        return this.innerIsVoucherTransBill(ctx, arap, currentCompany);
    }

    private boolean innerIsVoucherTransBill(Context ctx, String arap, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        String currentCompanyID = currentCompany.getId().toString();
        PeriodInfo currentPeriod = null;
        currentPeriod = arap.equalsIgnoreCase("AR") ? ArServerUtils.getArCurrentPeriod(ctx, currentCompany) : ApServerUtils.getApCurrentPeriod(ctx, currentCompany);
        if (currentPeriod == null) {
            return false;
        }
        Date beginDate = currentPeriod.getBeginDate();
        String beginDateString = this.convertDateToString(beginDate);
        Date endDate = this.upDate(currentPeriod.getEndDate());
        String endDateString = this.convertDateToString(endDate);
        StringBuffer sql = new StringBuffer("");
        sql.append("select top 1 fcompanyid from (");
        if ("AR".equalsIgnoreCase(arap)) {
            sql.append(" select fcompanyid,fbilldate from t_ar_otherbill where FIsTransBill = 1 and ffivouchered = 0 ").append(RT);
            if (ManageAccountControllerBean.isRecBillCreateVoucher(ctx, currentCompanyID)) {
                sql.append(" union all ").append(RT);
                sql.append(" select fcompanyid,fbizdate as fbilldate  from t_cas_receivingbill where (FIsTransBill = 1 or FIsTransOtherBill = 1) and ffivouchered = 0  ").append(RT);
            }
        } else {
            sql.append(" select fcompanyid,fbilldate from t_ap_otherbill where FIsTransBill = 1 and ffivouchered = 0 ").append(RT);
            if (ManageAccountControllerBean.isPayBillCreateVoucher(ctx, currentCompanyID)) {
                sql.append(" union all ").append(RT);
                sql.append(" select fcompanyid,fbizdate as fbilldate  from t_cas_paymentbill where (FIsTransBill = 1 or FIsTransOtherBill = 1) and ffivouchered = 0  ").append(RT);
            }
        }
        sql.append(") bill where (fcompanyid='" + currentCompanyID + "')");
        sql.append(" and (fbilldate>={" + beginDateString + "})");
        sql.append(" and (fbilldate<{" + endDateString + "})");
        Connection conn = null;
        Statement pstmt = null;
        IRowSet rs = null;
        int rowCount = 0;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                rowCount = 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
        }
        return rowCount > 0;
    }

    @Override
    protected void _closerArAccountForJobHandler(Context ctx, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        this.processContext(ctx);
        String manipulateObject = this.getDisplayManipulateObject(currentCompany);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)AR_CLOSE_LOG_ITEM);
        this.innerCloseARAPAccount(ctx, currentCompany, true, OperationTypeEnum.Positive);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _closerApAccountForJobHandler(Context ctx, CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        this.processContext(ctx);
        String manipulateObject = this.getDisplayManipulateObject(currentCompany);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)AP_CLOSE_LOG_ITEM);
        this.innerCloseARAPAccount(ctx, currentCompany, false, OperationTypeEnum.Positive);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _closeApAccount4web(Context ctx, String companyid, boolean isAR) throws BOSException, EASBizException {
        this.processContext(ctx);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        String manipulateObject = this.getDisplayManipulateObject(companyInfo);
        String logItem = isAR ? AR_CLOSE_LOG_ITEM : AP_CLOSE_LOG_ITEM;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)logItem);
        this.innerCloseARAPAccount(ctx, companyInfo, isAR, OperationTypeEnum.Positive);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _reverseCloseApAccount4web(Context ctx, String companyid, boolean isAR) throws BOSException, EASBizException {
        this.processContext(ctx);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        String manipulateObject = this.getDisplayManipulateObject(companyInfo);
        String logItem = isAR ? AR_REVERSE_LOG_ITEM : AP_REVERSE_LOG_ITEM;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ManageAccount().getType(), null, (String)manipulateObject, (String)logItem);
        this.innerCloseARAPAccount(ctx, companyInfo, isAR, OperationTypeEnum.Reverse);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected Map _unAuditedOrVouchered4web(Context ctx, String checkType, String arap, String checkBillType, String companyid) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        Collections.addAll(idSet, companyid);
        Map result = this.innerUnAuditedOrVouchered(ctx, checkType, arap, checkBillType, idSet);
        Map checkMap = (Map)result.get("checkMap");
        Map veriBillMap = (Map)result.get("veriBillMap");
        HashMap<String, Boolean> thisResult = new HashMap<String, Boolean>();
        thisResult.put("checkResult", checkMap.get(companyid) == null ? Boolean.valueOf(false) : checkMap.get(companyid));
        thisResult.put("veriBillColl", (Boolean)(veriBillMap.get(companyid) == null ? null : (Object)veriBillMap.get(companyid)));
        return thisResult;
    }

    @Override
    protected boolean _isVoucherTransBill4web(Context ctx, String arap, String companyid) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        return this.innerIsVoucherTransBill(ctx, arap, companyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _reComputeArApBalance(Context ctx, CompanyOrgUnitInfo company, int yearStart, int periodStart, boolean isRecomputeBillBalance, boolean isRecomputeAccountBalance, boolean isAR) throws BOSException, EASBizException {
        this.checkIsInQueue(ctx, isAR, company.getNumber());
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)(isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE), (CompanyOrgUnitInfo)company);
        PeriodInfo calPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(yearStart, periodStart, company.getAccountPeriodType());
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)company);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Uuid mutexID = Uuid.create();
        String mutexName = (isAR ? "AR" : "AP") + "_Balance";
        MutexParameter mp = ArApMutextUtils.getMutexParameter(ctx, mutexID, mutexName, mutexName, MutexLockType.EXCLUSIVE_LOCK, company.getId(), userInfo.getId(), ctx.getAIS());
        boolean isLocked = iMutex.requestMutex(mp);
        if (!isLocked) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.MUTEX_EXIST);
        }
        if (isRecomputeAccountBalance) {
            boolean calPeriodIsStarePeriod = false;
            int compareResult = CommonServerUtils.periodCompare(ctx, startPeriod.getId().toString(), calPeriod.getId().toString());
            calPeriodIsStarePeriod = compareResult == 0;
            PeriodInfo previousPeriod = null;
            if (!calPeriodIsStarePeriod) {
                previousPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)calPeriod);
                if (isAR) {
                    CommonServerUtils.transferArBalance(ctx, "ACCOUNT_NORMAL", previousPeriod, calPeriod, company);
                } else {
                    CommonServerUtils.transferApBalance(ctx, "ACCOUNT_NORMAL", previousPeriod, calPeriod, company);
                }
            }
        }
        try {
            if (isLocked) {
                while (!PeriodUtils.PeriodCompare((PeriodInfo)calPeriod, (PeriodInfo)currentPeriod)) {
                    this.reComputeArApBalance(ctx, company, calPeriod, startPeriod, isRecomputeBillBalance, isRecomputeAccountBalance, isAR);
                    calPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)calPeriod);
                }
            }
        }
        finally {
            iMutex.releaseMutex(mutexID);
        }
    }

    protected void reComputeArApBalance(Context ctx, CompanyOrgUnitInfo company, PeriodInfo calPeriod, PeriodInfo startPeriod, boolean isRecomputeBillBalance, boolean isRecomputeAccountBalance, boolean isAR) throws BOSException, EASBizException {
        String balanceModelID;
        String string = balanceModelID = isAR ? "rZr83XuPQXGYgUePQ5LecSPUYjI=" : "ffjhq9qjQDajSUiiCFG1NCPUYjI=";
        if (isRecomputeBillBalance) {
            if (calPeriod.getNumber() == startPeriod.getNumber()) {
                this.deletePeriodBalance(ctx, isAR, company, calPeriod);
                IBalanceCalculator apCalulator = BalanceCalculatorFactory.getInitCalculator((Context)ctx, (IObjectPK)new ObjectUuidPK(balanceModelID));
                OperationTypeEnum OPType = OperationTypeEnum.Positive;
                apCalulator.calculate(company.getId().toString(), startPeriod, OPType, false);
            } else {
                this.reverseCalYearAmout(ctx, calPeriod, company, isAR);
            }
            this.calculateARAPBalance(ctx, calPeriod, company, isAR);
        }
        if (isRecomputeAccountBalance) {
            if (calPeriod.getNumber() == startPeriod.getNumber()) {
                if (isRecomputeAccountBalance) {
                    if (isAR) {
                        CommonServerUtils.reComputeInitAccountBalance(ctx, "SYSTEM_AR", company);
                    } else {
                        CommonServerUtils.reComputeInitAccountBalance(ctx, "SYSTEM_AP", company);
                    }
                }
            } else {
                this.deleteAccountAmount(ctx, calPeriod, company, isAR);
            }
            this.calculateARAPAccountBalance(ctx, calPeriod, company, isAR);
        }
    }

    private void reverseCalYearAmout(Context ctx, PeriodInfo calPeriod, CompanyOrgUnitInfo company, boolean isAR) throws BOSException, EASBizException {
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)calPeriod);
        if (prePeriod.getPeriodYear() == calPeriod.getPeriodYear()) {
            String tableName = isAR ? "T_AR_ArBalance" : "T_AP_ApBalance";
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("update ").append(tableName).append(" bal set ").append(RT);
            sqlBuilder.append("(FYearDebitFor,").append(RT);
            sqlBuilder.append("FYearCreditFor,").append(RT);
            sqlBuilder.append("FYearDebitLocal,").append(RT);
            sqlBuilder.append("FYearCreditLocal) = (select FYearDebitFor, FYearCreditFor, FYearDebitLocal,FYearCreditLocal").append(RT);
            sqlBuilder.append(" from ").append(tableName).append(" temp \r\n");
            sqlBuilder.append(" Where  temp.FBALTYPE  = bal.FBALTYPE  and  temp.FCURRENCYID  = bal.FCURRENCYID  and temp.FASSTACTID  = bal.FASSTACTID ");
            sqlBuilder.append(" and isnull(temp.FADMINORGUNITID, 0) = isnull(bal.FADMINORGUNITID, 0) and isnull(temp.FPERSONID, 0)  = isnull(bal.FPERSONID, 0) ");
            sqlBuilder.append("and isnull(temp.FBIZANALYSISCODEID, 0) = isnull(bal.FBIZANALYSISCODEID, 0) and temp.FCompanyID= ? ").append(RT);
            sqlBuilder.append(" AND temp.FPeriodID= ?)").append(RT);
            sqlBuilder.append(" where bal.FCompanyID= ?  and bal.FPeriodID= ?");
            DBUtil.execute((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{company.getId().toString(), prePeriod.getId().toString(), company.getId().toString(), calPeriod.getId().toString()});
        }
    }

    private void deleteAccountAmount(Context ctx, PeriodInfo calPeriod, CompanyOrgUnitInfo company, boolean isAR) throws BOSException, EASBizException {
        String tableName = isAR ? "T_AR_ARBALANCECOLLATE" : "T_AP_APBALANCECOLLATE";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("delete from ").append(tableName);
        sqlBuilder.append(" where FBEGINBALANCEFOR = 0 and FCOMPANYID = ? and fperiodID = ?");
        DBUtil.execute((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{company.getId().toString(), calPeriod.getId().toString()});
    }

    private void calculateARAPBalance(Context ctx, PeriodInfo currentPeriod, CompanyOrgUnitInfo company, boolean isAR) throws BOSException, EASBizException {
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        if (isAR) {
            this.calculateARBalance(ctx, currentPeriod, nextPeriod, company);
        } else {
            this.calculateAPBalance(ctx, currentPeriod, nextPeriod, company);
        }
    }

    private void calculateARAPAccountBalance(Context ctx, PeriodInfo currentPeriod, CompanyOrgUnitInfo company, boolean isAR) throws BOSException, EASBizException {
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        if (isAR) {
            this.calculateARAccountBalance(ctx, currentPeriod, nextPeriod, company);
        } else {
            this.calculateAPAccountBalance(ctx, currentPeriod, nextPeriod, company);
        }
    }

    private void deletePeriodBalance(Context ctx, boolean isAR, CompanyOrgUnitInfo company, PeriodInfo calPeriod) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        String table = isAR ? "t_ar_arbalance" : "t_ap_apbalance";
        sb.append("delete from " + table + "  where FCompanyID='");
        sb.append(company.getId().toString()).append("'  AND FPeriodID = '").append(calPeriod.getId().toString() + "'  ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private IObjectPK logUIOperation(Context ctx, String operName) throws Exception {
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)operName, (BOSObjectType)new ManageAccount().getType(), null, (String)operName, (String)"fi_arap");
        return pk;
    }

    private void checkIsInQueue(Context ctx, boolean isAR, String companyNumber) throws BOSException, EASBizException {
        String ar = isAR ? "AR" : "AP";
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        if (createJobFacade.checkDuplicateTask("SCM_FI_" + ar + "_001" + companyNumber)) {
            throw new OtherBillBizException(OtherBillBizException.ARAPCLOSRACCOUNTISINQUEUE_RECOMPUTE);
        }
    }

    @Override
    protected void _reComputeApBalance(Context ctx, CompanyOrgUnitInfo company, int yearStart, int periodStart, boolean isRecomputeBillBalance, boolean isRecomputeAccountBalance) throws BOSException, EASBizException {
        this._reComputeArApBalance(ctx, company, yearStart, periodStart, isRecomputeBillBalance, isRecomputeAccountBalance, false);
    }

    @Override
    protected void _reComputeArBalance(Context ctx, CompanyOrgUnitInfo company, int yearStart, int periodStart, boolean isRecomputeBillBalance, boolean isRecomputeAccountBalance) throws BOSException, EASBizException {
        this._reComputeArApBalance(ctx, company, yearStart, periodStart, isRecomputeBillBalance, isRecomputeAccountBalance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCloseARAPAccount(Context ctx, CompanyOrgUnitInfo currentCompany, boolean isAR, OperationTypeEnum operationType) throws EASBizException, BOSException {
        String mutexName;
        Uuid mutexID;
        MutexParameter mp;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLocked = iMutex.requestMutex(mp = ArApMutextUtils.getMutexParameter(ctx, mutexID = Uuid.create(), mutexName = (isAR ? "AR" : "AP") + "_Balance", mutexName, MutexLockType.EXCLUSIVE_LOCK, currentCompany.getId(), userInfo.getId(), ctx.getAIS()));
        if (!isLocked) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.MUTEX_EXIST);
        }
        try {
            if (isLocked) {
                if (isAR) {
                    if (OperationTypeEnum.Positive.equals((Object)operationType)) {
                        this.innerCloseARAccount(ctx, currentCompany);
                    } else {
                        this.innerreverseCloseARAccount(ctx, currentCompany);
                    }
                } else if (OperationTypeEnum.Positive.equals((Object)operationType)) {
                    this.innerCloseAPAccount(ctx, currentCompany);
                } else {
                    this.innerreverseCloseApAccount(ctx, currentCompany);
                }
            }
        }
        finally {
            iMutex.releaseMutex(mutexID);
        }
    }

    @Override
    protected Map _contrastAccountCheck(Context ctx, Set idSet, String arap) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashMap<String, Boolean> checkMap = new HashMap<String, Boolean>();
        boolean fAR = arap.equalsIgnoreCase("AR");
        PeriodInfo periodInfo = null;
        String companyId = null;
        Iterator it = idSet.iterator();
        Map contrastResult = null;
        HashMap contrastedDiff = new HashMap();
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        HashMap<String, SystemStatusCtrolInfo> sysStatusCtrlMap = new HashMap<String, SystemStatusCtrolInfo>();
        this.initSysStatusCtrl(ctx, idSet, sysStatusCtrlMap);
        ContrastGLQueryParam param = null;
        String key = null;
        while (it.hasNext()) {
            companyId = (String)it.next();
            param = this.getDefaultParam(ctx, companyId, fAR, periodInfo = ((SystemStatusCtrolInfo)sysStatusCtrlMap.get(key = companyId + (fAR ? 12 : 13))).getCurrentPeriod());
            if (param != null) {
                param.setPeriodId(periodInfo.getId().toString());
                param.setPeriodYear(periodInfo.getPeriodYear());
                param.setPeriodNum(periodInfo.getPeriodNumber());
                if (!companyId.equals(param.getCompanyId())) {
                    param.setCompanyId(companyId);
                }
                param.setOnlyUnBalance(true);
                try {
                    contrastResult = ContrastGLFacadeFactory.getLocalInstance(ctx).contrastGL4closeAccount(param, fAR);
                    if (!"0".equals(contrastResult.get("contrastResult"))) continue;
                    contrastedDiff.put(companyId, contrastResult.get("param"));
                }
                catch (EASBizException e) {
                    errorMsg.put(companyId, e.getMessage());
                }
                continue;
            }
            checkMap.put(companyId, true);
        }
        result.put("checkMap", checkMap);
        result.put("contrastedResult", contrastedDiff);
        result.put("errorMsgMap", errorMsg);
        return result;
    }

    private void initSysStatusCtrl(Context ctx, Set idSet, Map<String, SystemStatusCtrolInfo> sysStatusCtrlMap) throws BOSException {
        HashSet<Integer> system = new HashSet<Integer>();
        system.add(12);
        system.add(13);
        system.add(2);
        system.add(6);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isStart"));
        view.getSelector().add(new SelectorItemInfo("isRelatedAccount"));
        view.getSelector().add(new SelectorItemInfo("isClosedAccount"));
        view.getSelector().add(new SelectorItemInfo("systemStatus.name"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.id"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodYear"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodNumber"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.beginDate"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.endDate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", system, CompareType.INCLUDE));
        view.setFilter(filter);
        SystemStatusCtrolCollection sysStatusColl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(view);
        int size = sysStatusColl.size();
        for (int i = 0; i < size; ++i) {
            sysStatusCtrlMap.put(String.valueOf(sysStatusColl.get(i).getCompany().getId()) + sysStatusColl.get(i).getSystemStatus().getName().getValue(), sysStatusColl.get(i));
        }
    }

    private ContrastGLQueryParam getDefaultParam(Context ctx, String companyId, boolean fAR, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        boolean isContrast = ArApParamHelper.isContrastByBillAccount(ctx, companyId, currentPeriod.getNumber(), fAR);
        return this.getDefaultParam(ctx, companyId, fAR, currentPeriod, false, isContrast);
    }

    private ContrastGLQueryParam getDefaultParam(Context ctx, String companyId, boolean fAR, PeriodInfo currentPeriod, boolean isCloseAccount, boolean isContrastByBillAccount) throws BOSException, EASBizException {
        ContrastGLQueryParam param = null;
        if (isContrastByBillAccount) {
            param = CommonServerUtils.getContrastParam(ctx, companyId, fAR, currentPeriod, isCloseAccount);
        } else {
            ContrastGLRptParamConvertor convertor = new ContrastGLRptParamConvertor();
            IQuerySolutionFacade iQuerySolutionFacade = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
            QuerySolutionInfo info = null;
            String parentUIName = "";
            String queryName = "";
            if (fAR) {
                queryName = "com.kingdee.eas.fi.ar.app.ReportQuery";
                parentUIName = "com.kingdee.eas.fi.ar.client.ContrastGLRptUI";
            } else {
                queryName = "com.kingdee.eas.fi.ar.app.ReportQuery";
                parentUIName = "com.kingdee.eas.fi.ap.client.ApContrastGLRptUI";
            }
            String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            QuerySolutionCollection solutionCol = iQuerySolutionFacade.getQuerySolutions(parentUIName, queryName, companyId, userID);
            CustomerParams defaultSolution = null;
            for (int i = 0; i < solutionCol.size(); ++i) {
                info = solutionCol.get(i);
                defaultSolution = this.getDefaultSoltion(ctx, info);
                if (defaultSolution == null) continue;
                param = new ContrastGLQueryParam();
                convertor.setRptParam((IReportQueryParam)param);
                try {
                    convertor.read(ctx, defaultSolution);
                    break;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        this.dealParamExt(param);
        return param;
    }

    protected void dealParamExt(ContrastGLQueryParam param) {
    }

    private CustomerParams getDefaultSoltion(Context ctx, QuerySolutionInfo info) throws BOSException {
        if (info.getId() != null && SolutionTypeEnum.SYSTEM_SOLUTION != info.getSolutionType()) {
            try {
                info = QuerySolutionUtils.getFullQuerySolution((Context)ctx, (String)info.getId().toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        QueryPanelCollection queryPanelColl = info.getQueryPanelInfo();
        QueryPanelInfo queryPanelInfo = null;
        String customerParams = null;
        CustomerParams cp = null;
        for (int i = 0; i < queryPanelColl.size(); ++i) {
            queryPanelInfo = queryPanelColl.get(i);
            if (queryPanelInfo == null || queryPanelInfo.getCustomerParams() == null || !QueryPanelTypeEnum.CUSTOMER_PANEL.equals((Object)queryPanelInfo.getQueryPanelType())) continue;
            customerParams = queryPanelInfo.getCustomerParams();
            try {
                cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            boolean isDefaultSolution = cp.getBoolean("isDefaultSolution");
            if (isDefaultSolution) break;
            cp = null;
        }
        return cp;
    }

    private String getDisplayManipulateObject(CompanyOrgUnitInfo companyInfo) {
        String displayManipulateObjectName = "";
        if (null != companyInfo) {
            displayManipulateObjectName = companyInfo.getNumber() + " " + companyInfo.getName();
        }
        return displayManipulateObjectName;
    }

    private void processContext(Context ctx) {
        if (null == ctx.getClientHostName()) {
            ctx.put((Object)"ClientName", (Object)ctx.getClientHostIP());
        }
    }

    static class AsstActType {
        public String ID = "";
        public String name = "";
        public String mappingField = "";
        public String mappingTable = "";
    }
}

