/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.GeneralBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ARDisposeUtil;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArShutAccountFactory;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfirmBillException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryFactory;
import com.kingdee.eas.fi.ar.app.AbstractOtherBillControllerBean;
import com.kingdee.eas.fi.ar.app.OtherBillSwapHelper;
import com.kingdee.eas.fi.ar.app.util.ARInvoiceParam;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.app.util.CoopUtils;
import com.kingdee.eas.fi.ar.verifyStatusEnum;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.WriteBackFactory;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.fi.arap.util.invoice.InvoiceUtils;
import com.kingdee.eas.fi.arap.util.invoice.MakeInvoiceUtils;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.AR2SOWriteBackHandler;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.IVirtualBillFacade;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.VirtualBillFacadeFactory;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OtherBillControllerBean
extends AbstractOtherBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.OtherBillControllerBean");
    private static final String AR_RESOURCE = "com.kingdee.eas.fi.ar.ARResources";
    private static final String SALE_ISSUE_BILL_BOS_TYPE = "CC3E933B";
    private String LOG_ITEM_APPOINTMENT_SUBJECT = "ar_otherbill_AppointmentSubject";

    private boolean beforeSubmitAndSave(OtherBillInfo info) {
        boolean isChanged = false;
        int size = info.getEntry().size();
        for (int j = size - 1; j >= 0; --j) {
            OtherBillentryInfo entry = info.getEntry().get(j);
            if (entry.getMaterial() != null || entry.getExpenseItem() != null) continue;
            info.getEntry().removeObject(j);
            isChanged = true;
        }
        return isChanged;
    }

    protected void checkIgnore(Context ctx, OtherBillInfo info) throws EASBizException, BOSException {
        if (!BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) && !BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus())) {
            if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
                throw new ArApCommonException(ArApCommonException.IGNORE_CANNOT_UPDATE);
            }
            throw new ArApCommonException(ArApCommonException.AUDIT_CANNOT_IGNORE);
        }
        if (info.isIsCoopBuild()) {
            throw new ArApCommonException(ArApCommonException.COOP_BILL_CANNOT_IGNORE);
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("destEntityID"));
        ev.getSelector().add(new SelectorItemInfo("destObjectID"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)this.getBOSType().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)100, CompareType.NOTEQUALS));
        ev.setFilter(filter);
        BOTRelationCollection botRelationCol = iBOTRelation.getCollection(ev);
        if (botRelationCol.size() > 0) {
            throw new ArApCommonException(ArApCommonException.HAS_TRANS_BILL_CANNOT_IGNORE);
        }
    }

    protected void deleteAndIgnore(Context ctx, IObjectPK pk, boolean isIgnore) throws BOSException, EASBizException {
        this.addSQLLock(ctx, pk);
        OtherBillInfo info = null;
        boolean isHasFlow = false;
        String tableName = "T_AR_OtherBillEntry";
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            isHasFlow = true;
        }
        if ((info = this.getOtherBillInfo(ctx, pk, this.getSelectors())) == null) {
            throw new ObjectNotFoundException(ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale()));
        }
        if (isIgnore) {
            this.checkIgnore(ctx, info);
        } else {
            this.canDelete(ctx, info);
            this.recycleNumber(ctx, pk, null, true);
        }
        if (info.isIsBizBill() && info.isIsInitializeBill() && info.isIsSCMBill()) {
            StringBuffer sb = new StringBuffer("");
            HashSet<String> sourceIdSet = new HashSet<String>();
            OtherBillentryCollection entries = info.getEntry();
            for (int i = 0; i < entries.size(); ++i) {
                OtherBillentryInfo entryInfo = entries.get(i);
                if (StringUtils.isEmpty((String)entryInfo.getSourceBillId())) continue;
                sourceIdSet.add(entryInfo.getSourceBillId());
            }
            sb.append("UPDATE T_IM_SaleIssueBill  SET FIsGenBizAR = 0");
            sb.append(" WHERE FID in (").append(ArApBillHelper.ids2SqlString(sourceIdSet)).append(")");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        if (isHasFlow) {
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.DELETE);
        } else if (BillStatusEnum.SUBMITED == info.getBillStatus()) {
            this.writeBackWhenInitBill(ctx, info, true);
        }
        if (BillStatusEnum.SUBMITED == info.getBillStatus() && info.getPaymentType() != null && !"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(info.getPaymentType().getId().toString())) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.DELETE);
        }
        if (!StringUtil.isEmpty((String)info.getPreRecBillNumber())) {
            RecPayServiceUtil.reverseOtherBillAndPreBill(ctx, info, OperationTypeEnum.Reverse);
        }
        this.returnBudget(ctx, info, 2);
        if (info.isIsTransBill() || info.isIsAllowanceBill()) {
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, info);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, info);
        }
    }

    @Override
    protected void _ignore(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        OtherBillInfo oldInfo = this.getOtherBillInfo(ctx, id, ArApSelectorFactory.getArOtherbillSelector(true));
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)oldInfo.getBOSType(), null, (String)oldInfo.getNumber(), (String)"ar_otherbill_Ignore", (String)oldInfo.getCompany().getId().toString());
        this.deleteAndIgnore(ctx, id, true);
        OtherBillInfo info = this.getOtherBillInfo(ctx, id, ArApSelectorFactory.getArOtherbillSelector(true));
        SelectorItemCollection ignoreSelector = new SelectorItemCollection();
        info.setBillStatus(BillStatusEnum.DELETED);
        if (info.getPreRecBillNumber() != null) {
            info.setPreRecAmount(BigDecimal.ZERO);
            info.setPreRecAmountString(null);
            info.setPreRecBillEntryIDs(null);
            info.setPreRecBillNumber(null);
            info.setThisArAmount(BigDecimal.ZERO);
            ignoreSelector.add(new SelectorItemInfo("preRecBillNumber"));
            ignoreSelector.add(new SelectorItemInfo("preRecAmount"));
            ignoreSelector.add(new SelectorItemInfo("thisArAmount"));
            ignoreSelector.add(new SelectorItemInfo("preRecAmountString"));
            ignoreSelector.add(new SelectorItemInfo("preRecBillEntryIDs"));
        }
        this.clearLockAmt(info);
        ignoreSelector.add(new SelectorItemInfo("entry.lockVerifyAmt"));
        ignoreSelector.add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
        ignoreSelector.add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
        ignoreSelector.add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
        ignoreSelector.add(new SelectorItemInfo("payPlan.lockAmount"));
        ignoreSelector.add(new SelectorItemInfo("payPlan.lockAmountLoc"));
        ignoreSelector.add(new SelectorItemInfo("payPlan.unLockAmount"));
        ignoreSelector.add(new SelectorItemInfo("payPlan.unLockAmountLoc"));
        ignoreSelector.add(new SelectorItemInfo("billStatus"));
        this.updatePartial(ctx, (CoreBaseInfo)info, ignoreSelector);
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteAndIgnore(ctx, pk, false);
        OtherBillInfo info = this.getOtherBillInfo(ctx, pk, this.getSelectors());
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)info);
        super._delete(ctx, pk);
    }

    protected void checkValid(Context ctx, OtherBillInfo otherBillInfo) throws EASBizException, BOSException {
        if (otherBillInfo == null) {
            return;
        }
        if (otherBillInfo.isIsReverseBill()) {
            return;
        }
        if (otherBillInfo.getCompany() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
        }
        if (otherBillInfo.getBillDate() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATE_NOTSET);
        }
        if (otherBillInfo.getBizDate() == null) {
            throw new OtherBillBizException(OtherBillBizException.BIZDATE_NOTSET);
        }
        if (otherBillInfo.getAsstActType() == null) {
            throw new OtherBillBizException(OtherBillBizException.ASSTACTTYPE_NOTSET);
        }
        if (otherBillInfo.getAsstActID() == null) {
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTSET);
        }
        this.checkAmtDirectionForPlan(otherBillInfo.getRecievePlan());
        if (!this.isExistAsstActByCompany(ctx, otherBillInfo.getCompany(), otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID())) {
            SupplierInfo supp;
            CustomerInfo cust;
            AsstActTypeInfo assactTypeInfo = otherBillInfo.getAsstActType();
            String relationDataObject = assactTypeInfo.getRealtionDataObject();
            if (relationDataObject == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("realtionDataObject"));
                assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()), selector);
                relationDataObject = assactTypeInfo.getRealtionDataObject();
            }
            boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
            boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
            String asstActId = otherBillInfo.getAsstActID();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            String str = "";
            if (fCust && (cust = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(asstActId), sic)) != null) {
                str = cust.getName();
            }
            if (fSupp && (supp = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActId), sic)) != null) {
                str = supp.getName();
            }
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTBELONGCOMORG1, new Object[]{otherBillInfo.getNumber(), str, otherBillInfo.getCompany().getName()});
        }
        if (otherBillInfo.getSourceBillType() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLTYPE_NOTSET);
        }
        if (otherBillInfo.getBillType() == null) {
            throw new OtherBillBizException(OtherBillBizException.BILLTYPE_NOTSET);
        }
        if (otherBillInfo.getCurrency() == null) {
            throw new OtherBillBizException(OtherBillBizException.CURRENCY_NOTSET);
        }
        if (otherBillInfo.getExchangeRate() == null) {
            throw new OtherBillBizException(OtherBillBizException.EXCHANGERATE_NOTSET);
        }
        if (otherBillInfo.getEntry() == null || otherBillInfo.getEntry().size() == 0) {
            throw new OtherBillBizException(OtherBillBizException.ARBILL_ENTRIESCANNOTEMPTY);
        }
        boolean isDAPCheckAccount = ArApParamHelper.isDAPCheckAccount(ctx);
        for (int j = 0; j < otherBillInfo.getEntry().size(); ++j) {
            OtherBillentryInfo entry = otherBillInfo.getEntry().get(j);
            if (otherBillInfo.isIsInitializeBill()) {
                if (!entry.isIsPresent() && entry.getRecievePayAmount() != null && entry.getVerifyAmount() != null && entry.getRecievePayAmount().abs().compareTo(entry.getVerifyAmount().abs()) <= 0) {
                    throw new OtherBillBizException(OtherBillBizException.VERIFYAMT_NO_MORETHAN_RECPAYAMOUNT);
                }
            } else if (entry.getMaterial() != null && entry.getMaterial().getAssistAttr() != null && entry.getAssistProperty() == null) {
                throw new OtherBillBizException(OtherBillBizException.ENTRY_ASSISTATTR_NOTSET, new Object[]{String.valueOf(j + 1)});
            }
            if (entry.getAccount() == null && !isDAPCheckAccount || entry.getAccount() == null && otherBillInfo.isIsInitializeBill()) {
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"ArSubject", (Locale)ctx.getOriginLocale())});
            }
            if (!entry.isIsPresent()) {
                entry.setTaxAmount(DataUtils.nullToZero(entry.getTaxAmount()));
                if (entry.getAmount() != null && entry.getRecievePayAmount().compareTo(entry.getAmount().add(entry.getTaxAmount())) != 0) {
                    throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALTAX);
                }
                if (entry.getVerifyAmount() != null && entry.getUnVerifyAmount() != null && entry.getRecievePayAmount().compareTo(entry.getVerifyAmount().add(entry.getUnVerifyAmount())) != 0) {
                    throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALVERIFY);
                }
                if (entry.getLockVerifyAmt() != null && entry.getLockUnVerifyAmt() != null && entry.getRecievePayAmount().compareTo(entry.getLockVerifyAmt().add(entry.getLockUnVerifyAmt())) != 0 && !otherBillInfo.isIsAllowanceBill()) {
                    throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALLOCKVERIFY);
                }
            }
            if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType()) || otherBillInfo.isIsAllowanceBill() || entry.isIsQtyZero() || entry.getQuantity() != null && (entry.getQuantity() == null || this.ZERO.compareTo(entry.getQuantity()) != 0)) continue;
            throw new OtherBillBizException(OtherBillBizException.QTY_NOTSET);
        }
        if (otherBillInfo.getRecievePlan() != null && otherBillInfo.getRecievePlan().size() > 1) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            HashSet<String> dateSet = new HashSet<String>();
            for (int j = 0; j < otherBillInfo.getRecievePlan().size(); ++j) {
                if (otherBillInfo.getRecievePlan().get(j).getRecievePayDate() == null) continue;
                dateSet.add(sdf.format(otherBillInfo.getRecievePlan().get(j).getRecievePayDate()));
            }
            int dateSize = dateSet.size();
            if (dateSize == 1 || dateSize > 1 && otherBillInfo.getRecievePlan().size() > dateSize) {
                throw new OtherBillBizException(OtherBillBizException.BILLDATECHECKERROR);
            }
        }
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
            boolean isMaterial = false;
            boolean isExpenseItem = false;
            int rowCount = otherBillInfo.getEntry().size();
            for (int i = 0; i < rowCount; ++i) {
                if (otherBillInfo.getEntry().get(i).getMaterial() != null) {
                    isMaterial = true;
                    continue;
                }
                isExpenseItem = true;
            }
            if (isMaterial && isExpenseItem) {
                throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTNOTBOTHMTREPI);
            }
        }
        if (!(otherBillInfo.isIsCoopBuild() || otherBillInfo.isIsSplitBill() || otherBillInfo.isIsBizBill() || otherBillInfo.getRecievePlan() != null && otherBillInfo.getRecievePlan().size() != 0)) {
            throw new OtherBillBizException(OtherBillBizException.ENTRY_NOTEXIST);
        }
        if (otherBillInfo.isIsTransBill()) {
            StringBuffer sb = new StringBuffer("");
            AbstractArApBillBaseInfo sourceBillInfo = null;
            if (otherBillInfo.getSourceBillId() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcBillIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            } else {
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("adminOrgUnit.id"));
                sourceBillInfo = this.getOtherBillInfo(ctx, (IObjectPK)new ObjectUuidPK(otherBillInfo.getSourceBillId()), selectors);
            }
            if (sourceBillInfo != null && sourceBillInfo.getAdminOrgUnit() != null && otherBillInfo.getAdminOrgUnitId_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcOUIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (sourceBillInfo != null && sourceBillInfo.getPerson() != null && otherBillInfo.getPersonID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcPersonIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (otherBillInfo.getAsstActTypeID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcAsstActTypeIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (otherBillInfo.getAsstActID_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcAcctCussentIDIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (otherBillInfo.getBillDate_SourceBill() == null) {
                sb.append(ResourceBase.getString((String)AR_RESOURCE, (String)"srcBillDateIsNull", (Locale)ctx.getLocale())).append(";\n");
            }
            if (sb.length() > 0) {
                throw new OtherBillBizException(OtherBillBizException.TRANSFAILED, new Object[]{sb.toString()});
            }
            CompanyOrgUnitInfo company = otherBillInfo.getCompany();
            Date arCurrentDate = null;
            if (company != null && company.getId() != null) {
                Date billDate;
                PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
                if (currentPeriod != null) {
                    arCurrentDate = currentPeriod.getBeginDate();
                }
                if ((billDate = otherBillInfo.getBillDate()).before(arCurrentDate) && !BillStatusEnum.AUDITED.equals((Object)otherBillInfo.getBillStatus())) {
                    throw new OtherBillBizException(OtherBillBizException.TRANSBILL_DATEBEFORECURPERIOD);
                }
            }
        }
        if (BillStatusEnum.SUBMITED.equals((Object)otherBillInfo.getBillStatus()) && otherBillInfo.getId() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("billStatus"));
            OtherBillInfo oldInfo = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)new ObjectStringPK(otherBillInfo.getId().toString()), selector);
            if (oldInfo != null && oldInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new OtherBillBizException(OtherBillBizException.BILLSTATUS_NOTSAVEDANDSUBMITED);
            }
        }
    }

    @Override
    protected void check4submit(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        super.check4submit(ctx, info);
        this.checkCanSaveOrSubmitForIncomeConfirm(ctx, (OtherBillInfo)info);
    }

    @Override
    protected void check4save(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        super.check4save(ctx, info);
    }

    private void checkPlanValid(OtherBillInfo billInfo) throws OtherBillBizException {
        BigDecimal billAmountLocal;
        OtherBillPlanCollection planCol = billInfo.getRecievePlan();
        OtherBillPlanInfo planInfo = null;
        int num = planCol.size();
        if (num == 0) {
            throw new OtherBillBizException(OtherBillBizException.ENTRY_NOTEXIST);
        }
        BigDecimal totalAmount = this.ZERO;
        BigDecimal totalAmountLocal = this.ZERO;
        BigDecimal amount = this.ZERO;
        BigDecimal amountLocal = this.ZERO;
        for (int i = 0; i < num; ++i) {
            planInfo = planCol.get(i);
            amount = planInfo.getRecievePayAmount();
            amountLocal = planInfo.getRecievePayAmountLocal();
            if (amount == null) {
                throw new OtherBillBizException(OtherBillBizException.ENTRY_PAYAMT_NOTSET);
            }
            totalAmount = totalAmount.add(amount);
            if (amountLocal == null) {
                throw new OtherBillBizException(OtherBillBizException.ENTRY_PAYAMTLOC_NOTSET);
            }
            totalAmountLocal = totalAmountLocal.add(amountLocal);
        }
        BigDecimal billAmount = billInfo.getAmount() == null ? this.ZERO : billInfo.getAmount();
        BigDecimal bigDecimal = billAmountLocal = billInfo.getAmountLocal() == null ? this.ZERO : billInfo.getAmountLocal();
        if (billAmount.compareTo(totalAmount) != 0) {
            throw new OtherBillBizException(OtherBillBizException.RECPLANAMOUNTNOTEQUALSTOTALAMOUNT);
        }
        if (billAmountLocal.compareTo(totalAmountLocal) != 0) {
            throw new OtherBillBizException(OtherBillBizException.RECPLANAMOUNTNOTEQUALSTOTALAMOUNT);
        }
    }

    @Override
    protected void setDefaultValue(Context ctx, ArApBillBaseInfo billInfo) throws EASBizException, BOSException {
        super.setDefaultValue(ctx, billInfo);
        OtherBillInfo otherBillInfo = (OtherBillInfo)billInfo;
        if (otherBillInfo.getTotalBadAmount() == null) {
            otherBillInfo.setTotalBadAmount(this.ZERO);
        }
        if (otherBillInfo.getTotalBadAmountLocal() == null) {
            otherBillInfo.setTotalBadAmountLocal(this.ZERO);
        }
        OtherBillentryInfo entryInfo = null;
        int size = otherBillInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = otherBillInfo.getEntry().get(i);
            if (entryInfo.getBadAmount() == null) {
                entryInfo.setBadAmount(this.ZERO);
            }
            if (entryInfo.getBadAmountLocal() == null) {
                entryInfo.setBadAmountLocal(this.ZERO);
            }
            if (entryInfo.getPreparedBadAmount() == null) {
                entryInfo.setPreparedBadAmount(this.ZERO);
            }
            if (entryInfo.getPreparedBadAmountLocal() != null) continue;
            entryInfo.setPreparedBadAmountLocal(this.ZERO);
        }
        if (otherBillInfo.isIsAllowanceBill()) {
            int i;
            otherBillInfo.setUnVerifyAmount(otherBillInfo.getAmount());
            otherBillInfo.setUnVerifyAmountLocal(otherBillInfo.getAmountLocal());
            otherBillInfo.setVerifyAmount(this.ZERO);
            otherBillInfo.setVerifyAmountLocal(this.ZERO);
            OtherBillPlanInfo planInfo = null;
            int size2 = otherBillInfo.getEntry().size();
            for (i = 0; i < size2; ++i) {
                entryInfo = otherBillInfo.getEntry().get(i);
                entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount());
                entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal());
                entryInfo.setVerifyAmount(this.ZERO);
                entryInfo.setVerifyAmountLocal(this.ZERO);
                entryInfo.setLockUnVerifyAmt(this.ZERO);
                entryInfo.setLockUnVerifyAmtLocal(this.ZERO);
                entryInfo.setLockVerifyAmt(entryInfo.getRecievePayAmount());
                entryInfo.setLockVerifyAmtLocal(entryInfo.getRecievePayAmountLocal());
            }
            for (i = 0; i < otherBillInfo.getRecievePlan().size(); ++i) {
                planInfo = otherBillInfo.getRecievePlan().get(i);
                planInfo.setLockAmount(planInfo.getRecievePayAmount());
                planInfo.setLockAmountLoc(planInfo.getRecievePayAmountLocal());
                planInfo.setUnLockAmount(this.ZERO);
                planInfo.setUnLockAmountLoc(this.ZERO);
                planInfo.setVerifyAmount(this.ZERO);
                planInfo.setVerifyAmountLocal(this.ZERO);
                planInfo.setUnVerifyAmount(planInfo.getRecievePayAmount());
                planInfo.setUnVerifyAmountLocal(planInfo.getRecievePayAmountLocal());
            }
        }
    }

    protected void checkCanSaveOrSubmitForIncomeConfirm(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        String id;
        if (info.isIsBizBill()) {
            return;
        }
        HashSet<String> sourceEntryIdSet = new HashSet<String>();
        HashSet<String> coreEntryIdSet = new HashSet<String>();
        OtherBillentryCollection entryColl = info.getEntry();
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            OtherBillentryInfo entry = entryColl.get(i);
            if (!StringUtils.isEmpty((String)entry.getSourceBillEntryId())) {
                sourceEntryIdSet.add(entry.getSourceBillEntryId());
            }
            if (StringUtils.isEmpty((String)entry.getCoreBillEntryId())) continue;
            coreEntryIdSet.add(entry.getCoreBillEntryId());
        }
        String entryTableName = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        String sourceEntryBosType = null;
        String coreEntryBosType = null;
        if (!sourceEntryIdSet.isEmpty()) {
            id = (String)sourceEntryIdSet.iterator().next();
            sourceEntryBosType = new ObjectUuidPK(id).getObjectType().toString();
        }
        if (!coreEntryIdSet.isEmpty()) {
            id = (String)coreEntryIdSet.iterator().next();
            coreEntryBosType = new ObjectUuidPK(id).getObjectType().toString();
        }
        if ("88882A58".equals(sourceEntryBosType)) {
            entryTableName = "T_SD_SaleOrderEntry";
            entryIdSet.addAll(sourceEntryIdSet);
        } else if ("BBC07FBE".equals(sourceEntryBosType)) {
            entryTableName = "T_IM_SaleIssueEntry";
            entryIdSet.addAll(sourceEntryIdSet);
        } else if ("D54A8D57".equals(sourceEntryBosType) || "AF9B19E7".equals(sourceEntryBosType)) {
            if ("88882A58".equals(coreEntryBosType)) {
                entryTableName = "T_SD_SaleOrderEntry";
                entryIdSet.addAll(coreEntryIdSet);
            } else if ("BBC07FBE".equals(coreEntryBosType)) {
                entryTableName = "T_IM_SaleIssueEntry";
                entryIdSet.addAll(coreEntryIdSet);
            }
        }
        if (entryIdSet.isEmpty() || StringUtils.isEmpty((String)entryTableName)) {
            return;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select fid from ").append(entryTableName);
        sql.append(" where fid in (").append(ArApBillHelper.ids2SqlString(entryIdSet)).append(")");
        sql.append(" and FIsIncomeConfirm = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            throw new IncomeConfirmBillException(IncomeConfirmBillException.SRCBILLORCOREBILL_CANNOTCREATE_FIBILL);
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean positWriteBackPreBill;
        OtherBillInfo otherBillInfo = (OtherBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(otherBillInfo.getCompany(), otherBillInfo.getBillDate());
        boolean isChanged = this.beforeSubmitAndSave(otherBillInfo);
        boolean isBillInShareFlow = false;
        if (null != otherBillInfo && null != otherBillInfo.getId() && null != otherBillInfo.getBillStatus()) {
            String billID = otherBillInfo.getId().toString();
            isBillInShareFlow = ArApBillUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, otherBillInfo.getBillStatus().getValue(), 2);
        }
        if (isBillInShareFlow) {
            return this._submit(ctx, model);
        }
        this.checkSourceCurrency(ctx, otherBillInfo.getEntries(), otherBillInfo.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AROtherBill", (Locale)ctx.getLocale()));
        this.checkAmtDirectionForPlan(otherBillInfo.getRecievePlan());
        this.checkIsInQueue(ctx, otherBillInfo);
        this.check4save(ctx, otherBillInfo);
        boolean isAddNew = true;
        this.isExistedBill = false;
        if (otherBillInfo.getId() != null) {
            this.isExistedBill = this.isExistBillInfo(ctx, "where fid='" + otherBillInfo.getId().toString() + "'");
        }
        if (otherBillInfo.getId() != null && this.isExistedBill) {
            isAddNew = false;
        }
        AbstractArApBillBaseInfo oldBillInfo = null;
        if (!isAddNew) {
            try {
                ObjectUuidPK pk = new ObjectUuidPK(otherBillInfo.getId().toString());
                this.addSQLLock(ctx, true, new IObjectPK[]{pk});
                oldBillInfo = (OtherBillInfo)this.getValue(ctx, (IObjectPK)pk, ArApSelectorFactory.getArOtherbillSelector(true));
            }
            catch (Exception e) {
                oldBillInfo = null;
            }
            if (oldBillInfo.getBillStatus().getValue() == 2) {
                throw new OtherBillBizException(OtherBillBizException.SUBMMITED_CANNNOTSAVE);
            }
            if (oldBillInfo.getBillStatus().getValue() == 3) {
                throw new OtherBillBizException(OtherBillBizException.AUDIT_BILL_CANNOT_SAVE);
            }
            if (oldBillInfo.getBillStatus().getValue() == -1) {
                throw new ArApCommonException(ArApCommonException.IGNORE_CANNOT_UPDATE);
            }
        }
        if (otherBillInfo.getEntries() == null || otherBillInfo.getEntries().size() == 0) {
            throw new OtherBillBizException(OtherBillBizException.ARBILL_ENTRIESCANNOTEMPTY);
        }
        if (isChanged) {
            otherBillInfo.setAmountLocal(this.ZERO);
            otherBillInfo.setReqCalculate4Srv(isChanged);
        }
        ArApBillHelper.calculate(ctx, otherBillInfo, null);
        this.setDefaultValue(ctx, otherBillInfo);
        this.setYearAndPeriod(ctx, otherBillInfo);
        super.checkNumber(ctx, otherBillInfo);
        if (oldBillInfo != null && !StringUtils.isEmpty((String)((AbstractOtherBillInfo)oldBillInfo).getPreRecBillNumber())) {
            RecPayServiceUtil.reverseOtherBillAndPreBill(ctx, (ArApBillBaseInfo)oldBillInfo, OperationTypeEnum.Reverse);
        }
        boolean bl = positWriteBackPreBill = !StringUtil.isEmpty((String)otherBillInfo.getPreRecBillNumber());
        if (positWriteBackPreBill) {
            this.assignLockAmount(ctx, otherBillInfo);
            this.clearLockAmt(otherBillInfo);
            RecPayServiceUtil.reversePreOtherBill(ctx, otherBillInfo);
        } else if (StringUtil.isEmpty((String)otherBillInfo.getPreRecBillNumber()) && oldBillInfo != null && !StringUtil.isEmpty((String)((AbstractOtherBillInfo)oldBillInfo).getPreRecBillNumber())) {
            this.clearLockAmt(otherBillInfo);
            otherBillInfo.setPreRecAmountString(null);
            otherBillInfo.setPreRecBillEntryIDs(null);
        }
        if (!isAddNew) {
            WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)oldBillInfo);
        }
        this.doBeforeSaveSubmit(ctx, otherBillInfo);
        IObjectPK pk = super._save(ctx, (IObjectValue)otherBillInfo);
        try {
            this.doAfterSaveSubmit(ctx, otherBillInfo);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.SAVE, null, (IObjectValue)otherBillInfo);
        if (!StringUtil.isEmpty((String)otherBillInfo.getPreRecBillNumber()) && positWriteBackPreBill) {
            RecPayServiceUtil.reverseOtherBillAndPreBill(ctx, otherBillInfo, OperationTypeEnum.Positive);
            ArApBillReverseHelper.reversePlanAmount(ctx, otherBillInfo, otherBillInfo.getEntry());
        }
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)"update T_AR_OtherBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ?", (Object[])new String[]{pk.toString()});
        }
        if (otherBillInfo.isIsTransBill() || otherBillInfo.isIsAllowanceBill()) {
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, (ArApBillBaseInfo)oldBillInfo);
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.SAVE, otherBillInfo);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, (ArApBillBaseInfo)oldBillInfo);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.SAVE, otherBillInfo);
        }
        RecPayServiceUtil.writePreBillLog(ctx, (ArApBillBaseInfo)oldBillInfo, otherBillInfo, "save");
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)otherBillInfo, BatchActionEnum.SAVE);
        return pk;
    }

    private void checkIsInQueue(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        String companyNumber = otherBillInfo.getCompany().getNumber();
        if (companyNumber == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(otherBillInfo.getCompany().getId()), sic);
            companyNumber = currentCompany.getNumber();
        }
        if (createJobFacade.checkDuplicateTask("SCM_FI_AR_001" + companyNumber)) {
            throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.submitBill(ctx, model, null);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.submitBill(ctx, model, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK submitBill(Context ctx, IObjectValue model, IObjectPK infoPk) throws BOSException, EASBizException {
        Set<String> entrySrcIdSet;
        boolean positWriteBackPreBill;
        OtherBillInfo info = (OtherBillInfo)model;
        this.addSQLLock(ctx, new ObjectUuidPK(info.getId()));
        this.SQLLockPreBill(ctx, true, info);
        SystemStatusCtrolCollection sysStatusCollection = CommonServerUtils.getSysStatusCollection(ctx, info.getCompany(), String.valueOf(12));
        SystemStatusCtrolInfo arapStatus = null;
        if (!sysStatusCollection.isEmpty()) {
            arapStatus = sysStatusCollection.get(0);
        }
        if (!info.isIsInitializeBill()) {
            if (arapStatus != null && arapStatus.getCurrentPeriod() != null && info.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
            }
        } else if (arapStatus != null && arapStatus.getStartPeriod() != null && !info.getBillDate().before(arapStatus.getStartPeriod().getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.BILL_DATE_NEED_BEFORE_START_PERIOD);
        }
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompany(), info.getBillDate());
        this.checkSourceCurrency(ctx, info.getEntries(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AROtherBill", (Locale)ctx.getLocale()));
        if (info.isIsInitializeBill()) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        this.beforeSubmitAndSave(info);
        this.checkValid(ctx, info);
        this.checkIsInQueue(ctx, info);
        if (BillStatusEnum.AUDITED == info.getBillStatus()) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        if (info != null && info.isIsCoopBuild() && (info.getRecievePlan() == null || info.getRecievePlan().size() == 0)) {
            OtherBillPlanInfo planInfo = new OtherBillPlanInfo();
            planInfo.setParent(info);
            planInfo.setRecievePayDate(info.getBillDate());
            BigDecimal recievePayAmount = this.ZERO;
            BigDecimal recievePayAmountLocal = this.ZERO;
            BigDecimal verifyAmount = this.ZERO;
            BigDecimal verifyAmountLocal = this.ZERO;
            for (int i = 0; i < info.getEntry().size(); ++i) {
                OtherBillentryInfo entryInfo = info.getEntry().get(i);
                recievePayAmount = recievePayAmount.add(entryInfo.getRecievePayAmount() == null ? this.ZERO : entryInfo.getRecievePayAmount());
                recievePayAmountLocal = recievePayAmountLocal.add(entryInfo.getRecievePayAmountLocal() == null ? this.ZERO : entryInfo.getRecievePayAmountLocal());
                verifyAmount = verifyAmount.add(entryInfo.getVerifyAmount() == null ? this.ZERO : entryInfo.getVerifyAmount());
                verifyAmountLocal = verifyAmountLocal.add(entryInfo.getVerifyAmountLocal() == null ? this.ZERO : entryInfo.getVerifyAmountLocal());
            }
            planInfo.setRecievePayAmount(recievePayAmount);
            planInfo.setRecievePayAmountLocal(recievePayAmountLocal);
            planInfo.setVerifyAmount(verifyAmount);
            planInfo.setVerifyAmountLocal(verifyAmountLocal);
            info.getRecievePlan().add(planInfo);
        }
        this.isExistedBill = false;
        boolean isAddNew = true;
        if (info.getId() == null) {
            this.isExistedBill = false;
            isAddNew = true;
        } else {
            this.isExistedBill = this.isExistBillInfo(ctx, "where fid='" + info.getId().toString() + "'");
            isAddNew = !this.isExistedBill;
        }
        boolean isManualReversed = false;
        if (info != null && info.isIsBizBill() && info.getSourceBillId() != null && this.isExistBillInfo(ctx, "WHERE FID = '" + info.getSourceBillId() + "' AND FIsBizBill = 1")) {
            isManualReversed = true;
        }
        if (!(info.isIsReverseBill() || isManualReversed || info.isIsAllowanceBill() || info.isIsTransBill())) {
            this.check4save(ctx, info);
        }
        if (info.getEntry() != null && info.getEntry().get(0) != null && info.getEntry().get(0).getContractNum() != null) {
            info.setContractNum(info.getEntry().get(0).getContractNum());
        }
        HashMap paramMap = new HashMap();
        paramMap.put("ARBILL_AUDIT_NOW", info.getCompany().getId().toString());
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        this.paramKeyMap.putAll(paramMap);
        if ("true".equals(ctx.get((Object)"isCoopBuild")) && info.isReqCalculate4Srv()) {
            info.setAmountLocal(this.ZERO);
            ArApBillHelper.calculate(ctx, info, null);
        }
        ArApBillHelper.calculate(ctx, info, null);
        this.setDefaultValue(ctx, info);
        ArApBillUtil.checkAmtAndAmtLocalPrecision(ctx, info, info.getCurrency());
        this.checkPlanValid(info);
        if (BillStatusEnum.SUBMITED == info.getBillStatus()) {
            this.writeBackWhenInitBill(ctx, info, true);
        }
        boolean isEditPayPlan = info.getBoolean("isEditPayPlan");
        AbstractArApBillBaseInfo oldModel = null;
        if (this.isExistedBill) {
            try {
                oldModel = (OtherBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), ArApSelectorFactory.getArOtherbillSelector(true));
            }
            catch (Exception e) {
                oldModel = null;
            }
        }
        if (oldModel != null) {
            BigDecimal newVerifyAmount;
            BigDecimal oldVerifyAmount = oldModel.getVerifyAmount() == null ? BigDecimal.ZERO : oldModel.getVerifyAmount();
            BigDecimal bigDecimal = newVerifyAmount = info.getVerifyAmount() == null ? BigDecimal.ZERO : info.getVerifyAmount();
            if (oldVerifyAmount.compareTo(newVerifyAmount) != 0) {
                throw new OtherBillBizException(OtherBillBizException.VERIFY_INFO_CHANGED);
            }
        }
        if ("true".equals(ctx.get((Object)"isCoopBuild")) || BillStatusEnum.AUDITED != info.getBillStatus()) {
            info.setBillStatus(BillStatusEnum.SUBMITED);
        } else if (this.isExistedBill && (info.isIsTransBill() || isEditPayPlan) && BillStatusEnum.AUDITED == info.getBillStatus()) {
            if (!info.isIsInitializeBill()) {
                info.setLastExhangeRate(info.getExchangeRate());
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
            return new ObjectUuidPK(info.getId());
        }
        this.setYearAndPeriod(ctx, info);
        this.check4submit(ctx, info);
        if (info.isIsTransBill() || info.isIsAllowanceBill()) {
            info.setLastExhangeRate(info.getExchangeRate());
        }
        if (info.isIsBizBill() && isManualReversed) {
            this.checkManualReversed(ctx, info, true);
        }
        if (VerificateBillTypeEnum.ArAgentBizBill.equals((Object)info.getSourceBillType())) {
            info.setLastExhangeRate(info.getExchangeRate());
        }
        super.checkNumber(ctx, info);
        if (oldModel != null && !StringUtils.isEmpty((String)((AbstractOtherBillInfo)oldModel).getPreRecBillNumber())) {
            RecPayServiceUtil.reverseOtherBillAndPreBill(ctx, (ArApBillBaseInfo)oldModel, OperationTypeEnum.Reverse);
        }
        boolean bl = positWriteBackPreBill = !StringUtil.isEmpty((String)info.getPreRecBillNumber());
        if (positWriteBackPreBill) {
            this.assignLockAmount(ctx, info);
            this.clearLockAmt(info);
            RecPayServiceUtil.reversePreOtherBill(ctx, info);
        } else if (StringUtil.isEmpty((String)info.getPreRecBillNumber()) && oldModel != null && !StringUtil.isEmpty((String)((AbstractOtherBillInfo)oldModel).getPreRecBillNumber())) {
            this.clearLockAmt(info);
            info.setPreRecAmountString(null);
            info.setPreRecBillEntryIDs(null);
        }
        if (!isAddNew && !isAddNew) {
            WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)oldModel);
        }
        this.doBeforeSaveSubmit(ctx, info);
        IObjectPK pk = null;
        if (null == infoPk) {
            pk = super._submit(ctx, (IObjectValue)info);
        } else {
            pk = infoPk;
            super._submit(ctx, infoPk, (IObjectValue)info);
        }
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.SAVE, null, (IObjectValue)info);
        if (!StringUtil.isEmpty((String)info.getPreRecBillNumber()) && positWriteBackPreBill) {
            RecPayServiceUtil.reverseOtherBillAndPreBill(ctx, info, OperationTypeEnum.Positive);
            ArApBillReverseHelper.reversePlanAmount(ctx, info, info.getEntry());
        }
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
        String tableName = "T_AR_OtherBillEntry";
        boolean isHasBizFlow = false;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            isHasBizFlow = true;
        }
        if (isHasBizFlow) {
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.handleBillSubmit((Context)ctx, (IObjectValue)oldModel, (IObjectValue)info);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ArApServerUtils.doWriteBack(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.resetBillChange((Context)ctx, (IObjectValue)model);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (info.isIsTransBill() || info.isIsAllowanceBill()) {
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, (ArApBillBaseInfo)oldModel);
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.SAVE, info);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.DELETE, (ArApBillBaseInfo)oldModel);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.SAVE, info);
        }
        if ((entrySrcIdSet = this.getEntrySrcIdSet(info)).size() > 0) {
            if (info.isIsBizBill() && info.isIsInitializeBill() && info.isIsSCMBill()) {
                StringBuffer sb = new StringBuffer("");
                sb.append("UPDATE T_IM_SaleIssueBill SET FIsGenBizAR = 1");
                sb.append(" WHERE FID in (").append(ArApBillHelper.ids2SqlString(entrySrcIdSet)).append(")");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            } else if (info.isIsInitializeBill() && info.isIsSCMBill()) {
                super.updateSrcBillIsGenBizBill(ctx, entrySrcIdSet, false, true);
            }
            if (info.isIsSCMBill() && info.isIsBizBill() && info.isIsInitializeBill()) {
                if (info.getSourceBillType() != null && !VerificateBillTypeEnum.SaleIssueBill.equals((Object)info.getSourceBillType())) {
                    throw new OtherBillBizException(OtherBillBizException.SRCBILLNOTISSUEBILL);
                }
                super.checkSrcBill2DupBizOtherBill(ctx, pk.toString(), entrySrcIdSet, 2, true);
            }
        }
        if (isManualReversed) {
            this.manualReversedBizBill(ctx, pk, true);
            this.requestBudget(ctx, info, 3);
        }
        try {
            this.doAfterSaveSubmit(ctx, info);
            if (info != null && info.getId() != null && info.getSourceBillId() != null && OtherBillTypeEnum.DebitAdjust.equals((Object)info.getBillType())) {
                HashSet<String> srcIdSet = new HashSet<String>();
                srcIdSet.add(info.getSourceBillId().toString());
                ArApServerUtils.createBotpRelation(ctx, srcIdSet, info.getId().toString());
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        boolean isproxybill = false;
        if (info.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
            isproxybill = true;
        }
        if (!(info.isIsInitializeBill() || info.isIsReverseBill() || isManualReversed || !this.getBooleanParamValue(ctx, "ARBILL_AUDIT_NOW") || isproxybill)) {
            try {
                WfEventListenerStateManager.getInstance().disableEventListener();
                this.audit(ctx, pk);
            }
            finally {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)"update T_AR_OtherBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ?", (Object[])new String[]{pk.toString()});
        }
        this.writeBackWhenInitBill(ctx, info, false);
        this.requestBudget(ctx, info, 1);
        RecPayServiceUtil.writePreBillLog(ctx, (ArApBillBaseInfo)oldModel, info, "submit");
        return pk;
    }

    private void setVerifyStatus(OtherBillInfo info) {
        if (info != null && null == info.getVerifyStatus()) {
            BigDecimal verifyAmountLocal;
            BigDecimal unVerifyAmountLocal = info.getUnVerifyAmountLocal();
            if (null == unVerifyAmountLocal) {
                unVerifyAmountLocal = BigDecimal.ZERO;
            }
            if (null == (verifyAmountLocal = info.getVerifyAmountLocal())) {
                verifyAmountLocal = BigDecimal.ZERO;
            }
            verifyStatusEnum verifyStatus = BigDecimal.ZERO.compareTo(unVerifyAmountLocal) == 0 ? verifyStatusEnum.VERIFIED : (BigDecimal.ZERO.compareTo(verifyAmountLocal) == 0 ? verifyStatusEnum.UNVERIFY : verifyStatusEnum.SOME_VERIFIED);
            info.setVerifyStatus(verifyStatus);
        }
    }

    @Override
    protected String getContractTypeNumber() {
        return "300";
    }

    @Override
    protected int _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        int success = 0;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.setSelector(ArApSelectorFactory.getArOtherbillSelector(true));
        OtherBillCollection otherCol = this.getOtherBillCollection(ctx, entityView);
        if (otherCol.size() > 0 && otherCol.size() <= 100) {
            IMetaDataLoader imdl = null;
            EntityObjectInfo eoi = null;
            EntityObjectInfo eoientry = null;
            ICreditControlFacade iCreditControl = null;
            CreditCtrlResult result = null;
            int n = otherCol.size();
            for (int i = 0; i < n; ++i) {
                OtherBillInfo info = otherCol.get(i);
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_otherbill_batchSubmit");
                this.checkAmtDirectionForPlan(info.getRecievePlan());
                this.checkRequiredField(info);
                if (i == 0) {
                    imdl = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                    eoi = imdl.getEntity(this.getBOSType());
                    eoientry = imdl.getEntity(new OtherBillentryInfo().getBOSType());
                    iCreditControl = CreditControlFacadeFactory.getLocalInstance((Context)ctx);
                    if (null == this.isRelationSCM) {
                        boolean isStartparam = ArApParamHelper.isRelationSCM(ctx, info.getCompany().getId().toString(), this._getOwnedSys(ctx));
                        this.isRelationSCM = isStartparam;
                    }
                }
                if (info == null || !this.checkOtherBillInfoForSubmit(ctx, info, this.isRelationSCM, imdl, eoi, eoientry)) continue;
                info.setReqCalculate4Srv(false);
                if (!info.isIsBizBill() && (result = iCreditControl.verifyCreditAtSubmit((Object)info)) != null && (result.isOverspend() || result.isTimeout())) {
                    int ctrlMode = result.getCreditCtrlMode().getValue();
                    if (0 == ctrlMode || 3 == ctrlMode) {
                        throw new OtherBillBizException(OtherBillBizException.CREDITCTRLOVERSPENDORTIMEOUTANDCONTINUE);
                    }
                    throw new OtherBillBizException(OtherBillBizException.CREDITCTRLOVERSPENDORTIMEOUT);
                }
                BOTRelationCollection btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
                iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
                ++success;
            }
        }
        return success;
    }

    private boolean checkOtherBillInfoForSubmit(Context ctx, OtherBillInfo info, boolean isSCMRelation, IMetaDataLoader imdl, EntityObjectInfo eoi, EntityObjectInfo eoientry) throws EASBizException, BOSException {
        if (info.getCompany() != null && (info.getBillStatus().getValue() == 1 || info.getBillStatus().getValue() == 2)) {
            int i;
            int n;
            if (info.isIsInitializeBill() && ArServerUtils.arIsStart(ctx, info.getCompany())) {
                throw new OtherBillBizException(OtherBillBizException.SYS_ISINITIALIZED, new Object[]{SystemEnum.ACCOUNTSRECEIVABLE});
            }
            if (!info.isIsInitializeBill() && (info.isIsSCMBill() || isSCMRelation)) {
                if (info.getPaymentType() == null) {
                    String alias = eoi.getPropertyByName("paymentType").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (!(info.isBotpBill() || info.getBillType() != OtherBillTypeEnum.ExpenseInvoice && info.getBillType() != OtherBillTypeEnum.InvoiceBill || info.getSaleOrg() != null)) {
                    String alias = eoi.getPropertyByName("saleOrg").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
            }
            if (!info.isIsInitializeBill() && info.isIsSCMBill() && isSCMRelation && info.getBillType() == OtherBillTypeEnum.InvoiceBill && info.getBizType() == null) {
                String alias = eoi.getPropertyByName("bizType").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getBillType() == OtherBillTypeEnum.ExpenseInvoice || info.getBillType() == OtherBillTypeEnum.OtherReceivable) {
                n = info.getEntry().size();
                for (i = 0; i < n; ++i) {
                    if (info.getEntry().get(i).getExpenseItem() != null) continue;
                    String alias = eoientry.getPropertyByName("expenseItem").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
            } else if (info.getBillType() == OtherBillTypeEnum.DebitAdjust && info.getSourceBillId() == null) {
                n = info.getEntry().size();
                for (i = 0; i < n; ++i) {
                    if (info.getEntry().get(i).getExpenseItem() != null) continue;
                    String alias = eoientry.getPropertyByName("expenseItem").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
            } else if (info.getBillType() == OtherBillTypeEnum.DebitAdjust && info.getSourceBillId() != null) {
                boolean isMaterial = false;
                boolean isExpenseItem = false;
                int n2 = info.getEntry().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (info.getEntry().get(i2).getExpenseItem() != null) {
                        isExpenseItem = true;
                        continue;
                    }
                    isMaterial = true;
                }
                if (isMaterial && isExpenseItem) {
                    throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTNOTBOTHMTREPI);
                }
            } else if (info.getBillType() == OtherBillTypeEnum.InvoiceBill) {
                n = info.getEntry().size();
                for (i = 0; i < n; ++i) {
                    boolean assitPro;
                    OtherBillentryInfo entry = info.getEntry().get(i);
                    if (entry.getMaterial() == null) {
                        String alias = eoientry.getPropertyByName("material").getAlias();
                        throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                    }
                    if (entry.getAccount() == null && !ArApParamHelper.isDAPCheckAccount(ctx) || entry.getAccount() == null && info.isIsInitializeBill()) {
                        String alias = eoientry.getPropertyByName("account").getAlias();
                        throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                    }
                    if (entry.getMaterial() == null) continue;
                    boolean assitAttr = entry.getMaterial().getAssistAttr() == null;
                    boolean bl = assitPro = entry.getAssistProperty() == null;
                    if (assitAttr && !assitPro || !assitAttr && assitPro) {
                        String alias = eoientry.getPropertyByName("assistProperty").getAlias();
                        throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                    }
                    if (entry.getMeasureUnit() == null) {
                        String alias = eoientry.getPropertyByName("measureUnit").getAlias();
                        throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                    }
                    if (entry.getBaseQty() == null) {
                        String alias = eoientry.getPropertyByName("baseQty").getAlias();
                        throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                    }
                    if (entry.getBaseUnit() != null) continue;
                    String alias = eoientry.getPropertyByName("baseUnit").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
            }
            if (info.getAmount() == null) {
                info.setAmount(this.ZERO);
            }
            if (info.getVerifyAmount() == null) {
                info.setVerifyAmount(this.ZERO);
            }
            if (info.getVerifyAmountLocal() == null) {
                info.setVerifyAmountLocal(this.ZERO);
            }
            if (info.getUnVerifyAmount() == null) {
                info.setUnVerifyAmount(this.ZERO);
            }
            if (info.getUnVerifyAmountLocal() == null) {
                info.setUnVerifyAmountLocal(this.ZERO);
            }
            if (info.getAmount().compareTo(info.getVerifyAmount().add(info.getUnVerifyAmount())) != 0) {
                throw new OtherBillBizException(OtherBillBizException.AMOUNTNOTEQUALVERIFY);
            }
            n = info.getEntry().size();
            for (i = 0; i < n; ++i) {
                OtherBillentryInfo entry = info.getEntry().get(i);
                if (entry.isIsPresent()) continue;
                if (entry.getRecievePayAmount().compareTo(entry.getAmount().add(entry.getTaxAmount())) != 0) {
                    throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALTAX);
                }
                if (entry.getRecievePayAmount().compareTo(entry.getVerifyAmount().add(entry.getUnVerifyAmount())) != 0) {
                    throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALVERIFY);
                }
                if (entry.getRecievePayAmount().compareTo(entry.getLockVerifyAmt().add(entry.getLockUnVerifyAmt())) == 0) continue;
                throw new OtherBillBizException(OtherBillBizException.ENTRYAMOUNTNOTEQUALLOCKVERIFY);
            }
            return true;
        }
        if (info != null && info.getBillStatus().getValue() != 1 && info.getBillStatus().getValue() != 2) {
            throw new OtherBillBizException(OtherBillBizException.BILLSTATUS_NOTSAVEDANDSUBMITED);
        }
        return false;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        OtherBillInfo info = (OtherBillInfo)model;
        if (info.getAsstActID() != null) {
            this.setAsstActNameMultiLang(ctx, info);
        }
        super._update(ctx, pk, model);
    }

    protected void _createVoucher(Context ctx, String billId) throws BOSException, EASBizException {
        IOtherBill otherBill = OtherBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        OtherBillInfo otherBillInfo = this.getOtherBillInfo(ctx, (IObjectPK)pk);
        Date arStartDate = ArServerUtils.getArStartPeriod(ctx, otherBillInfo.getCompany()).getBeginDate();
        if (otherBillInfo != null) {
            Date billDate = otherBillInfo.getBillDate();
            if (billDate != null && billDate.before(arStartDate)) {
                throw new OtherBillBizException(OtherBillBizException.INITBILL);
            }
            if (otherBillInfo.isFiVouchered()) {
                throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
            }
            if (BillStatusEnum.AUDITED.equals((Object)otherBillInfo.getBillStatus())) {
                otherBillInfo.setFiVouchered(true);
                otherBill.update((IObjectPK)pk, (CoreBaseInfo)otherBillInfo);
            }
        }
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        IReceivingBill iRec;
        ReceivingBillInfo recBillInfo;
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (new ReceivingBillInfo().getBOSType().toString().equals(botRelation.getDestEntityID()) && com.kingdee.eas.fi.cas.BillStatusEnum.SAVE.equals((Object)(recBillInfo = (iRec = ReceivingBillFactory.getLocalInstance((Context)ctx)).getReceivingBillInfo("select billStatus where id = '" + botRelation.getDestObjectID() + "'")).getBillStatus())) {
            return;
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _delVoucher(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        OtherBillInfo otherBillInfo = this.getOtherBillInfo(ctx, (IObjectPK)pk);
        if (otherBillInfo != null) {
            otherBillInfo.setAccountant(null);
            otherBillInfo.setFiVouchered(false);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)otherBillInfo);
        }
    }

    @Override
    protected boolean _isInitBill(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        OtherBillInfo otherBillInfo = this.getOtherBillInfo(ctx, (IObjectPK)pk);
        return this.isInitBill(ctx, otherBillInfo);
    }

    private boolean isInitBill(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        Date billDate;
        PeriodInfo startPeriod;
        if (otherBillInfo.isIsSCMBill()) {
            return false;
        }
        CompanyOrgUnitInfo company = otherBillInfo.getCompany();
        Date arStartDate = null;
        if (company != null && company.getId() != null && (startPeriod = ArServerUtils.getArStartPeriod(ctx, company)) != null) {
            arStartDate = startPeriod.getBeginDate();
        }
        return (billDate = otherBillInfo.getBillDate()) != null && arStartDate != null && billDate.before(arStartDate);
    }

    @Override
    protected boolean _hasVerifiedInitBill(Context ctx) throws EASBizException, BOSException {
        PeriodInfo startPeriod;
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        Date arStartDate = null;
        if (company != null && company.getId() != null && (startPeriod = ArServerUtils.getArStartPeriod(ctx, company)) != null) {
            arStartDate = startPeriod.getBeginDate();
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo verifyAmountFilter = new FilterItemInfo("verifyAmount", (Object)new BigDecimal("0"), CompareType.NOTEQUALS);
        filter.getFilterItems().add(verifyAmountFilter);
        FilterItemInfo billDateFilter = new FilterItemInfo("billDate", (Object)arStartDate, CompareType.LESS);
        filter.getFilterItems().add(billDateFilter);
        if (company != null) {
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS);
            filter.getFilterItems().add(companyFilter);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        OtherBillCollection col = this.getOtherBillCollection(ctx, viewInfo);
        return col.size() > 0;
    }

    private void deleteRecBill(Context ctx, String sourceBillpk) throws BOSException, EASBizException {
        String sql = "select FReceivingBillID from T_CAS_ReceivingBillEntry where fsourceBillId=?";
        Object[] param = new Object[]{sourceBillpk};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        HashSet<ObjectUuidPK> idSet = new HashSet<ObjectUuidPK>();
        try {
            while (rowSet.next()) {
                idSet.add(new ObjectUuidPK(rowSet.getString(1)));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (idSet.size() > 0) {
            IReceivingBill iRec = ReceivingBillFactory.getLocalInstance((Context)ctx);
            iRec.delete((IObjectPK[])idSet.toArray(new ObjectUuidPK[0]));
        }
    }

    @Override
    protected IObjectPK[] _createReverseBill(Context ctx, IObjectPK[] sourceBillpk) throws EASBizException, BOSException {
        IObjectPK[] newPKs = this._createReverseBill(ctx, sourceBillpk, null, null);
        return newPKs;
    }

    @Override
    protected IObjectPK[] _createReverseBill(Context ctx, IObjectPK[] sourceBillpk, Date txtBizDate, Date txtBillDate) throws EASBizException, BOSException {
        OtherBillInfo srcBillInfo = null;
        OtherBillInfo destBillInfo = null;
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        IObjectPK[] newPKs = new IObjectPK[sourceBillpk.length];
        for (int i = 0; i < sourceBillpk.length; ++i) {
            srcBillInfo = this.getOtherBillInfo(ctx, sourceBillpk[i], this.getSelectors());
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)srcBillInfo.getBOSType(), null, (String)srcBillInfo.getNumber(), (String)"ar_otherbill_reverse");
            this.canReverse(ctx, srcBillInfo);
            destBillInfo = (OtherBillInfo)srcBillInfo.clone();
            ARInvoiceParam.clearARInvoiceParam(destBillInfo);
            String oldnumber = srcBillInfo.getNumber();
            destBillInfo.setId(null);
            if (!this.isAutoNumber(ctx, srcBillInfo, srcBillInfo.getCompany().getId().toString())) {
                destBillInfo.setNumber(oldnumber + "-Rever");
            } else {
                destBillInfo.setNumber(null);
            }
            destBillInfo.setAbstractName(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"ReverseBill", (Locale)ctx.getLocale()) + " - " + oldnumber);
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Date billDate = srcBillInfo.getBillDate();
            Date bizDate = srcBillInfo.getBizDate();
            PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, srcBillInfo.getCompany());
            Date currentPeriod_beginDate = now;
            if (currentPeriod != null) {
                currentPeriod_beginDate = currentPeriod.getBeginDate();
            }
            if (txtBizDate != null) {
                bizDate = txtBizDate;
            }
            if (txtBillDate != null) {
                billDate = txtBillDate;
            }
            if (billDate.before(currentPeriod_beginDate)) {
                billDate = currentPeriod_beginDate;
            }
            destBillInfo.setBillDate(billDate);
            destBillInfo.setBizDate(bizDate);
            this.setYearAndPeriod(ctx, destBillInfo);
            destBillInfo.setBillStatus(BillStatusEnum.SAVE);
            destBillInfo.setIsReverseBill(true);
            destBillInfo.setIsTransBill(false);
            destBillInfo.setIsReversed(false);
            destBillInfo.setIsImportBill(false);
            destBillInfo.setIsInitializeBill(false);
            destBillInfo.setIsNeedVoucher(true);
            destBillInfo.setIsCoopBuild(false);
            srcBillInfo.setIsReversed(true);
            destBillInfo.setRedBlueType(!srcBillInfo.isRedBlueType());
            destBillInfo.setFiVouchered(false);
            destBillInfo.setIsAppointVoucher(false);
            destBillInfo.setSourceBillId(srcBillInfo.getId().toString());
            destBillInfo.setSourceBillType(srcBillInfo.getSourceBillType());
            destBillInfo.setCreator(currentUser);
            destBillInfo.setCreateTime(new Timestamp(now.getTime()));
            destBillInfo.setAccountant(null);
            BigDecimal srcBillAmount = srcBillInfo.getAmount();
            BigDecimal srcBillAmountLocal = srcBillInfo.getAmountLocal();
            BigDecimal destBillAmount = OtherBillControllerBean.getNagtiveValue(srcBillAmount);
            BigDecimal destBillAmountLocal = OtherBillControllerBean.getNagtiveValue(srcBillAmountLocal);
            destBillInfo.setAmount(destBillAmount);
            destBillInfo.setAmountLocal(destBillAmountLocal);
            BigDecimal srcTotalAmount = srcBillInfo.getTotalAmount();
            BigDecimal destTotalAmount = OtherBillControllerBean.getNagtiveValue(srcTotalAmount);
            BigDecimal srcTotalTaxAmount = srcBillInfo.getTotalTaxAmount();
            BigDecimal destTotalTaxAmount = OtherBillControllerBean.getNagtiveValue(srcTotalTaxAmount);
            BigDecimal srcTotalTax = srcBillInfo.getTotalTax();
            BigDecimal destTotalTax = OtherBillControllerBean.getNagtiveValue(srcTotalTax);
            BigDecimal srcTotalAmountLoc = srcBillInfo.getTotalAmountLocal();
            BigDecimal destTotalAmountLoc = OtherBillControllerBean.getNagtiveValue(srcTotalAmountLoc);
            BigDecimal srcTotalTaxLoc = srcBillInfo.getTotalTaxLocal();
            BigDecimal destTotalTaxLoc = OtherBillControllerBean.getNagtiveValue(srcTotalTaxLoc);
            destBillInfo.setTotalAmountLocal(destTotalAmountLoc);
            destBillInfo.setTotalTaxLocal(destTotalTaxLoc);
            destBillInfo.setTotalAmount(destTotalAmount);
            destBillInfo.setTotalTaxAmount(destTotalTaxAmount);
            destBillInfo.setTotalTax(destTotalTax);
            destBillInfo.setUnVerifyAmount(this.ZERO);
            destBillInfo.setUnVerifyAmountLocal(this.ZERO);
            destBillInfo.setVerifyAmount(destBillAmount);
            destBillInfo.setVerifyAmountLocal(destBillAmountLocal);
            destBillInfo.setInvoicedAmt(BigDecimal.ZERO);
            destBillInfo.setVerifyStatus(verifyStatusEnum.VERIFIED);
            srcBillInfo.setUnVerifyAmount(this.ZERO);
            srcBillInfo.setUnVerifyAmountLocal(this.ZERO);
            srcBillInfo.setVerifyAmount(srcBillAmount);
            srcBillInfo.setVerifyAmountLocal(srcBillAmountLocal);
            srcBillInfo.setVerifyStatus(verifyStatusEnum.VERIFIED);
            destBillInfo.setVoucher(null);
            destBillInfo.setVoucherNumber(null);
            destBillInfo.setVoucherType(null);
            destBillInfo.setPreRecAmount(this.ZERO);
            destBillInfo.setPreRecBillNumber(null);
            destBillInfo.setThisArAmount(destBillInfo.getAmount());
            OtherBillentryCollection destEntryCollection = destBillInfo.getEntry();
            OtherBillentryCollection srcEntryollection = srcBillInfo.getEntry();
            OtherBillentryInfo destEntryInfo = null;
            OtherBillentryInfo srcEntryInfo = null;
            int num = destEntryCollection.size();
            for (int j = 0; j < num; ++j) {
                destEntryInfo = destEntryCollection.get(j);
                srcEntryInfo = srcEntryollection.get(j);
                destEntryInfo.setId(null);
                destEntryInfo.setHead(null);
                if (StringUtils.isEmpty((String)destEntryInfo.getSourceBillEntryId())) {
                    destEntryInfo.setSourceBillEntryId(srcEntryInfo.getId().toString());
                }
                if (StringUtils.isEmpty((String)destEntryInfo.getSourceBillId())) {
                    destEntryInfo.setSourceBillId(srcBillInfo.getId().toString());
                }
                BigDecimal srcEntryQty = srcEntryInfo.getQuantity();
                BigDecimal srcEntryBaseQty = srcEntryInfo.getBaseQty();
                BigDecimal srcEntryRecieveAmount = srcEntryInfo.getRecievePayAmount();
                BigDecimal srcEntryRecieveAmountLocal = srcEntryInfo.getRecievePayAmountLocal();
                BigDecimal destEntryQty = OtherBillControllerBean.getNagtiveValue(srcEntryQty);
                BigDecimal destEntryBaseQty = OtherBillControllerBean.getNagtiveValue(srcEntryBaseQty);
                BigDecimal destEntryRecieveAmount = OtherBillControllerBean.getNagtiveValue(srcEntryRecieveAmount);
                BigDecimal destEntryRecieveAmountLocal = OtherBillControllerBean.getNagtiveValue(srcEntryRecieveAmountLocal);
                destEntryInfo.setQuantity(destEntryQty);
                destEntryInfo.setBaseQty(destEntryBaseQty);
                destEntryInfo.setRecievePayAmount(destEntryRecieveAmount);
                destEntryInfo.setRecievePayAmountLocal(destEntryRecieveAmountLocal);
                destEntryInfo.setLockVerifyAmt(destEntryRecieveAmount);
                destEntryInfo.setLockVerifyAmtLocal(destEntryRecieveAmountLocal);
                destEntryInfo.setLockUnVerifyAmt(this.ZERO);
                destEntryInfo.setLockUnVerifyAmtLocal(this.ZERO);
                destEntryInfo.setVerifyAmount(destEntryRecieveAmount);
                destEntryInfo.setVerifyAmountLocal(destEntryRecieveAmountLocal);
                destEntryInfo.setUnVerifyAmount(this.ZERO);
                destEntryInfo.setUnVerifyAmountLocal(this.ZERO);
                destEntryInfo.setLocalUnwriteOffAmount(this.ZERO);
                destEntryInfo.setLocalWrittenOffAmount(OtherBillControllerBean.getNagtiveValue(srcEntryInfo.getLocalUnwriteOffAmount()));
                destEntryInfo.setWittenOffBaseQty(OtherBillControllerBean.getNagtiveValue(srcEntryInfo.getUnwriteOffBaseQty()));
                destEntryInfo.setUnwriteOffBaseQty(this.ZERO);
                destEntryInfo.setInvoiceNumber(null);
                destEntryInfo.setInvoicedAmt(this.ZERO);
                destEntryInfo.setIsInvoiced(false);
                BigDecimal srcAmount = srcEntryInfo.getAmount();
                BigDecimal destAmount = OtherBillControllerBean.getNagtiveValue(srcAmount);
                BigDecimal srcAmountLocal = srcEntryInfo.getAmountLocal();
                BigDecimal destAmountLocal = OtherBillControllerBean.getNagtiveValue(srcAmountLocal);
                BigDecimal srcTaxAmount = srcEntryInfo.getTaxAmount();
                BigDecimal destTaxAmount = OtherBillControllerBean.getNagtiveValue(srcTaxAmount);
                BigDecimal srcTaxAmountLocal = srcEntryInfo.getTaxAmountLocal();
                BigDecimal destTaxAmountLocal = OtherBillControllerBean.getNagtiveValue(srcTaxAmountLocal);
                destEntryInfo.setDiscountAmount(OtherBillControllerBean.getNagtiveValue(srcEntryInfo.getDiscountAmount()));
                destEntryInfo.setDiscountAmountLocal(OtherBillControllerBean.getNagtiveValue(srcEntryInfo.getDiscountAmountLocal()));
                destEntryInfo.setAmount(destAmount);
                destEntryInfo.setAmountLocal(destAmountLocal);
                destEntryInfo.setTaxAmount(destTaxAmount);
                destEntryInfo.setTaxAmountLocal(destTaxAmountLocal);
                srcEntryInfo.setLockUnVerifyAmt(this.ZERO);
                srcEntryInfo.setLockUnVerifyAmtLocal(this.ZERO);
                srcEntryInfo.setLockVerifyAmt(srcEntryRecieveAmount);
                srcEntryInfo.setLockVerifyAmtLocal(srcEntryRecieveAmountLocal);
                srcEntryInfo.setVerifyAmount(srcEntryRecieveAmount);
                srcEntryInfo.setVerifyAmountLocal(srcEntryRecieveAmountLocal);
                srcEntryInfo.setUnVerifyAmount(this.ZERO);
                srcEntryInfo.setUnVerifyAmountLocal(this.ZERO);
                srcEntryInfo.setLocalWrittenOffAmount(srcEntryInfo.getLocalUnwriteOffAmount());
                srcEntryInfo.setLocalUnwriteOffAmount(this.ZERO);
                srcEntryInfo.setWittenOffBaseQty(srcEntryInfo.getUnwriteOffBaseQty());
                srcEntryInfo.setUnwriteOffBaseQty(this.ZERO);
                destEntryInfo.setInvoiceReqQty(this.ZERO);
                destEntryInfo.setInvoiceReqBaseQty(this.ZERO);
                destEntryInfo.setUnInvoiceReqQty(destEntryInfo.getQuantity());
                destEntryInfo.setUnInvoiceReqBaseQty(destEntryInfo.getBaseQty());
                destEntryInfo.setInvoiceReqAmount(this.ZERO);
                destEntryInfo.setInvoiceReqAmountLocal(this.ZERO);
                destEntryInfo.setUnInvoiceReqAmount(destEntryInfo.getRecievePayAmount());
                destEntryInfo.setUnInvoiceReqAmountLocal(destEntryInfo.getRecievePayAmountLocal());
            }
            OtherBillPlanCollection destPlanCollection = destBillInfo.getRecievePlan();
            OtherBillPlanCollection srcPlanCollection = srcBillInfo.getRecievePlan();
            OtherBillPlanInfo srcPlanInfo = null;
            OtherBillPlanInfo destPlanInfo = null;
            int num2 = destPlanCollection.size();
            for (int j = 0; j < num2; ++j) {
                destPlanInfo = destPlanCollection.get(j);
                srcPlanInfo = srcPlanCollection.get(j);
                destPlanInfo.setId(null);
                destPlanInfo.setParent(null);
                BigDecimal srcPlanRecieveAmount = srcPlanInfo.getRecievePayAmount();
                BigDecimal srcPlanRecieveAmountLocal = srcPlanInfo.getRecievePayAmountLocal();
                BigDecimal destPlanRecieveAmount = OtherBillControllerBean.getNagtiveValue(srcPlanRecieveAmount);
                BigDecimal destPlanRecieveAmountLocal = OtherBillControllerBean.getNagtiveValue(srcPlanRecieveAmountLocal);
                destPlanInfo.setRecievePayAmount(destPlanRecieveAmount);
                destPlanInfo.setRecievePayAmountLocal(destPlanRecieveAmountLocal);
                destPlanInfo.setVerifyAmount(destPlanRecieveAmount);
                destPlanInfo.setVerifyAmountLocal(destPlanRecieveAmountLocal);
                destPlanInfo.setUnVerifyAmount(this.ZERO);
                destPlanInfo.setUnVerifyAmountLocal(this.ZERO);
                srcPlanInfo.setVerifyAmount(srcPlanRecieveAmount);
                srcPlanInfo.setVerifyAmountLocal(srcPlanRecieveAmountLocal);
                srcPlanInfo.setUnVerifyAmount(this.ZERO);
                srcPlanInfo.setUnVerifyAmountLocal(this.ZERO);
                destPlanInfo.setLockAmount(destPlanRecieveAmount);
                destPlanInfo.setLockAmountLoc(destPlanRecieveAmountLocal);
                destPlanInfo.setUnLockAmount(this.ZERO);
                destPlanInfo.setUnLockAmountLoc(this.ZERO);
                srcPlanInfo.setLockAmount(srcPlanRecieveAmount);
                srcPlanInfo.setLockAmountLoc(srcPlanRecieveAmountLocal);
                srcPlanInfo.setUnLockAmount(this.ZERO);
                srcPlanInfo.setUnLockAmountLoc(this.ZERO);
                destPlanInfo.setRecievePayDate(billDate);
            }
            this.innerUpdate(ctx, sourceBillpk[i], (IObjectValue)srcBillInfo);
            destBillInfo.setReqCalculate4Srv(false);
            this.changeDestInfoBeforeSubmit(ctx, srcBillInfo, destBillInfo);
            this.handleInfoBeforeReverSubmit(ctx, srcBillInfo, destBillInfo);
            this.submit(ctx, (CoreBaseInfo)destBillInfo);
            newPKs[i] = this.reverseBillAudit(ctx, destBillInfo);
            String strid = newPKs[i].toString();
            String bosType = destBillInfo.getBOSType().toString();
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(sourceBillpk[i].toString());
            info.setDestEntityID(bosType);
            info.setSrcEntityID(bosType);
            info.setDestObjectID(strid);
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        return newPKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK reverseBillAudit(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        int j;
        boolean condition2;
        this.checkIsInQueue(ctx, otherBillInfo);
        this.setDefaultValue(ctx, otherBillInfo);
        otherBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
        this.check4submit(ctx, otherBillInfo);
        this.setYearAndPeriod(ctx, otherBillInfo);
        super.checkNumber(ctx, otherBillInfo);
        IObjectPK pk = super._submit(ctx, (IObjectValue)otherBillInfo);
        DbUtil.execute((Context)ctx, (String)"update t_ar_otherbill set flastupdatetime = null, flastupdateuserid = null where fid = ?", (Object[])new Object[]{pk.toString()});
        this.requestBudget(ctx, otherBillInfo, 3);
        IObjectPK[] pkstemp = new IObjectPK[]{};
        WriteBackNetOrderHandleFactory.headHandle((Context)ctx, (String)this.getBOSType().toString(), (com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.AUDIT, (IObjectPK[])pkstemp);
        if (otherBillInfo.isIsInitializeBill() && !VerificateBillTypeEnum.ArAgentBizBill.equals((Object)otherBillInfo.getSourceBillType())) {
            throw new OtherBillBizException(OtherBillBizException.DISALLOWANCE_INITIALIZEBILL_AUDIT);
        }
        CompanyOrgUnitInfo currentCompany = otherBillInfo.getCompany();
        String sysName = "2,12";
        SystemStatusCtrolCollection col = CommonServerUtils.getSysStatusCollection(ctx, currentCompany, sysName);
        SystemStatusCtrolInfo scmStatus = null;
        SystemStatusCtrolInfo arapStatus = null;
        boolean condition1 = col != null && col.get(0) != null && col.get(0).getSystemStatus() != null;
        boolean bl = condition2 = col != null && col.get(1) != null && col.get(1).getSystemStatus() != null;
        if (condition1 && SystemEnum.INVENTORYMANAGEMENT.equals((Object)col.get(0).getSystemStatus().getName())) {
            scmStatus = col.get(0);
        } else if (condition1 && this._getOwnedSys(ctx).equals((Object)col.get(0).getSystemStatus().getName())) {
            arapStatus = col.get(0);
        }
        if (condition2 && SystemEnum.INVENTORYMANAGEMENT.equals((Object)col.get(1).getSystemStatus().getName())) {
            scmStatus = col.get(1);
        } else if (condition2 && this._getOwnedSys(ctx).equals((Object)col.get(1).getSystemStatus().getName())) {
            arapStatus = col.get(1);
        }
        if (!otherBillInfo.isIsInitializeBill()) {
            if (otherBillInfo.isIsSCMBill() && scmStatus != null && scmStatus.getCurrentPeriod() != null && otherBillInfo.getBizDate().before(scmStatus.getCurrentPeriod().getBeginDate()) && otherBillInfo.getBillType().getValue() == 102 && this.getBooleanParamValue(ctx, "CONSIGNSALES")) {
                throw new OtherBillBizException(OtherBillBizException.BIZDATEBEFORCURRENTPERIOD);
            }
            if (arapStatus != null && arapStatus.getCurrentPeriod() != null && otherBillInfo.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
            }
        } else if (arapStatus != null && arapStatus.getStartPeriod() != null && !otherBillInfo.getBillDate().before(arapStatus.getStartPeriod().getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        otherBillInfo.setAuditor(currentUser);
        otherBillInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
        otherBillInfo.setBillStatus(BillStatusEnum.AUDITED);
        String sql = "update t_ar_otherBill set fbillstatus=?,fauditdate=?,fauditorid=? where fid=? ";
        Object[] params = new Object[]{new Integer(3), new Timestamp(System.currentTimeMillis()), currentUser.getId().toString(), pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "SELECT BILL.FBIZTYPEID,BILL.FPAYMENTTYPEID,BILL.FISREVERSEBILL,ENTRY.FSOURCEBILLID,ENTRY.FCOREBILLID FROM T_AR_OTHERBILL BILL LEFT JOIN T_AR_OTHERBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID WHERE BILL.FID = ? GROUP BY BILL.FBIZTYPEID,BILL.FPAYMENTTYPEID,BILL.FISREVERSEBILL,ENTRY.FSOURCEBILLID,ENTRY.FCOREBILLID";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        String bizTypeId = null;
        int rsSize = rowSet.size();
        String[] srcIdArr = new String[rsSize];
        String[][] idList = new String[rsSize][2];
        int i = 0;
        try {
            while (rowSet.next()) {
                bizTypeId = rowSet.getString(1);
                idList[i][0] = rowSet.getString(4);
                idList[i][1] = rowSet.getString(5);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (this.getBooleanParamValue(ctx, "CONSIGNSALES")) {
            this.updateInventroy(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, otherBillInfo.getSourceBillId().toString(), bizTypeId);
        }
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.AUDIT, null, (IObjectValue)otherBillInfo);
        if (!OtherBillTypeEnum.OtherReceivable.equals((Object)otherBillInfo.getBillType()) || VerificateBillTypeEnum.SaleBackProfitBill.equals((Object)otherBillInfo.getSourceBillType())) {
            IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)ArApConstants.AR_OBILL_TYPE, (String[])srcIdArr);
            for (j = 0; j < handlers.length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, new String[]{otherBillInfo.getSourceBillId().toString()}, idList);
            }
        }
        boolean isBatchWriteback = false;
        for (j = 0; j < otherBillInfo.getEntry().size(); ++j) {
            if (otherBillInfo.getEntry().get(j).getCoreBillType() == null || !"528d806a-0106-1000-e111-0194c0a812e6463ED552".equals(otherBillInfo.getEntry().get(j).getCoreBillType().getId().toString())) continue;
            isBatchWriteback = true;
            break;
        }
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType()) && this.getBooleanParamValue(ctx, "IS_ARAP_CORP_BILL") || isBatchWriteback) {
            this.batchWriteback(ctx, pk, BatchActionEnum.AUDIT);
        }
        if (otherBillInfo.getPaymentType() != null && !"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(otherBillInfo.getPaymentType().getId().toString())) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.AUDIT);
        }
        if (!otherBillInfo.isIsCoopBuild()) {
            String tablename = null;
            try {
                tablename = "AR2SOWB_KSQL_0";
                tablename = KsqlUtil.createTempTable((Context)ctx, (String)WriteBackSQLHelper.getAR2SOTempTableSQL((String)tablename));
                String idStringList = WriteBackSQLHelper.getKeyIdList((String[])new String[]{pk.toString()});
                String WB_TEMP = WriteBackSQLHelper.getAR2SOInsertTempSQL((String)idStringList, (String)tablename);
                DbUtil.execute((Context)ctx, (String)WB_TEMP, (Object[])new Object[0]);
                String WB_TEMP2 = WriteBackSQLHelper.createAR2SOArClosedStatusWriteSQL((com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.AUDIT, (String)idStringList, (String)tablename);
                DbUtil.execute((Context)ctx, (String)WB_TEMP2, (Object[])new Object[0]);
            }
            finally {
                if (tablename != null) {
                    KsqlUtil.releaseTempTable((Context)ctx, (String)tablename);
                }
            }
        }
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType()) && otherBillInfo.getSourceBillId() != null && otherBillInfo.getEntry() != null && otherBillInfo.getSourceBillType() != null && !VerificateBillTypeEnum.OTHER.equals((Object)otherBillInfo.getSourceBillType())) {
            StringBuffer sqljdtz = new StringBuffer();
            OtherBillentryCollection entryColl = otherBillInfo.getEntry();
            ArrayList<String> sqlList = new ArrayList<String>();
            for (int j2 = 0; j2 < entryColl.size(); ++j2) {
                OtherBillentryInfo entryInfo = entryColl.get(j2);
                BillTypeInfo billtypeInfo = entryInfo.getCoreBillType();
                if (billtypeInfo == null || billtypeInfo.getId() == null) continue;
                IBillType billype = BillTypeFactory.getLocalInstance((Context)ctx);
                BillTypeInfo typeInfo = billype.getBillTypeInfo("select headTable,entryTable where id = '" + billtypeInfo.getId() + "'");
                String headTable = typeInfo.getHeadTable();
                String entryTable = typeInfo.getEntryTable();
                sqljdtz.setLength(0);
                if ("T_SD_SaleOrder".equals(headTable) && "T_SD_SaleOrderEntry".equals(entryTable)) {
                    sqljdtz.append(" update T_SD_SaleOrderEntry AS soe set ftotalArAmount = ftotalArAmount +" + entryInfo.getRecievePayAmount() + " where fid= '" + entryInfo.getCoreBillEntryId() + "'");
                    sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleOrder so, T_AR_OTHERBILL ar");
                    sqljdtz.append(" WHERE ((so.FIsCentralBalance = 1 AND so.FCompanyOrgUnitID = ar.FCompanyID)");
                    sqljdtz.append(" OR (so.FIsCentralBalance = 0 AND soe.FCompanyOrgUnitID = ar.FCompanyID))");
                    sqljdtz.append(" AND so.FID = soe.FParentID");
                    sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                    sqlList.add(sqljdtz.toString());
                    continue;
                }
                if (!"T_SD_SaleReturns".equals(headTable) || !"T_SD_SaleReturnsEntry".equals(entryTable)) continue;
                sqljdtz.append(" update T_SD_SaleReturnsEntry AS sre set finvoicePrice = finvoicePrice - " + entryInfo.getRecievePayAmount() + " where fid= '" + entryInfo.getCoreBillEntryId() + "'");
                sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleReturns sr, T_AR_OTHERBILL ar");
                sqljdtz.append(" WHERE ((sr.FIsCentralBalance = 1 AND sr.FCompanyOrgUnitID = ar.FCompanyID)");
                sqljdtz.append(" OR (sr.FIsCentralBalance = 0 AND sre.FCompanyOrgUnitID = ar.FCompanyID))");
                sqljdtz.append(" AND sr.FID = sre.FParentID");
                sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                sqlList.add(sqljdtz.toString());
            }
            DBUtil.execBatchSql((Context)ctx, sqlList, (boolean)true);
        }
        return pk;
    }

    protected boolean canReverse(Context ctx, OtherBillInfo otherbillInfo) throws EASBizException, BOSException {
        super.canReverse(ctx, otherbillInfo);
        if (otherbillInfo != null && VerificateBillTypeEnum.ArAgentBizBill.equals((Object)otherbillInfo.getSourceBillType())) {
            throw new OtherBillBizException(OtherBillBizException.PROXYBILLFORBIDREVERSE);
        }
        if (otherbillInfo != null && OtherBillTypeEnum.DebitAdjust.equals((Object)otherbillInfo.getBillType())) {
            throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTNOTREVERSE);
        }
        return true;
    }

    public static BigDecimal getNagtiveValue(BigDecimal value) {
        BigDecimal nagtiveValue = new BigDecimal("0.00");
        if (value != null) {
            nagtiveValue = nagtiveValue.subtract(value);
        }
        return nagtiveValue;
    }

    @Override
    protected boolean _isAudited(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        boolean exist = this.exists(ctx, "where billstatus=3 and id='" + pk.toString() + "'");
        return exist;
    }

    @Override
    protected boolean _isVouchered(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        boolean exist = this.exists(ctx, "where fiVouchered=1 and id='" + pk.toString() + "'");
        return exist;
    }

    @Override
    protected int _getBillType(Context ctx, String billId) throws BOSException, EASBizException {
        Date billDate;
        PeriodInfo startPeriod;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        OtherBillInfo otherBillInfo = this.getOtherBillInfo(ctx, (IObjectPK)pk);
        CompanyOrgUnitInfo company = otherBillInfo.getCompany();
        Date arStartDate = null;
        if (company != null && company.getId() != null && (startPeriod = ArServerUtils.getArStartPeriod(ctx, company)) != null) {
            arStartDate = startPeriod.getBeginDate();
        }
        if ((billDate = otherBillInfo.getBillDate()) != null && arStartDate != null && billDate.before(arStartDate)) {
            return 2;
        }
        if (otherBillInfo.isIsReverseBill()) {
            return 3;
        }
        if (otherBillInfo.isIsTransBill()) {
            return 4;
        }
        return 1;
    }

    @Override
    protected boolean _arIsRelatedAccount(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = new CompanyOrgUnitInfo();
        currentCompany.setId(BOSUuid.read((String)companyId));
        return ArServerUtils.arIsRelatedAccount(ctx, currentCompany);
    }

    @Override
    protected void _canReverse(Context ctx, IObjectPK billpk) throws BOSException, EASBizException {
        OtherBillInfo otherbillInfo = this.getOtherBillInfo(ctx, billpk);
        this.canReverse(ctx, otherbillInfo);
    }

    @Override
    protected IObjectValue _creditTransfer(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected BOTMappingCollection getRulesByDestBill(Context ctx, String destBosType, CoreBillBaseCollection srcBillCollection) throws BOSException, EASBizException {
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(srcBillCollection, destBosType, DefineSysEnum.BTP);
        return botMappingCollection;
    }

    private CoreBillBaseCollection getBillList(Context ctx, String[] billIDList) throws EASBizException, BOSException {
        if (billIDList.length == 1) {
            String id = billIDList[0];
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            CoreBillBaseInfo sourceBillInfo = this.getBOTPSelectors() == null ? this.getCoreBillBaseInfo(ctx, (IObjectPK)pk) : this.getCoreBillBaseInfo(ctx, (IObjectPK)pk, this.getBOTPSelectors());
            CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
            sourceBillCollection.add(sourceBillInfo);
            return sourceBillCollection;
        }
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        for (int i = 0; i < billIDList.length; ++i) {
            String id = billIDList[i];
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)id);
            if (i != 0) {
                sbMaskString.append(" or ");
            }
            sbMaskString.append("#");
            sbMaskString.append(String.valueOf(i));
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (this.getBOTPSelectors() != null) {
            entityViewInfo.put("selector", (Object)this.getBOTPSelectors());
        }
        CoreBillBaseCollection sourceBillCollection = this.getCoreBillBaseCollection(ctx, entityViewInfo);
        return sourceBillCollection;
    }

    protected SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.expenseItem.name"));
        sic.add(new SelectorItemInfo("entry.expenseItem.number"));
        sic.add(new SelectorItemInfo("entry.measureUnit.name"));
        sic.add(new SelectorItemInfo("entry.measureUnit.number"));
        sic.add(new SelectorItemInfo("recievePlan.*"));
        return sic;
    }

    protected SelectorItemCollection getSelectors() {
        return ArApSelectorFactory.getArOtherbillSelector(true);
    }

    private void addSameCoreBillEntrySeqLock(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (InvoiceUtils.isSupportPreInvoice(ctx, pk.toString(), true)) {
            StringBuffer lockSQL = new StringBuffer();
            lockSQL.append(" update T_AR_OtherBillEntry set FID = FID where FCoreBillEntryId  in ");
            lockSQL.append(" (SELECT FCoreBillEntryId FROM T_AR_OtherBillEntry");
            lockSQL.append("  WHERE FParentID = ?)");
            DBUtil.execute((Context)ctx, (String)lockSQL.toString(), (Object[])new Object[]{pk.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int j;
        boolean condition2;
        logger.info((Object)"-------begin audit interface------");
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        this.addSameCoreBillEntrySeqLock(ctx, pk);
        this.addSQLLock(ctx, pk);
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        IObjectPK[] pkstemp = new IObjectPK[]{};
        WriteBackNetOrderHandleFactory.headHandle((Context)ctx, (String)this.getBOSType().toString(), (com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.AUDIT, (IObjectPK[])pkstemp);
        OtherBillInfo otherBillInfo = this.getOtherBillInfo(ctx, pk, this.getSelectors());
        this.checkStatus4Audit(ctx, otherBillInfo);
        this.checkIsInQueue(ctx, otherBillInfo);
        String currentCompanyId = otherBillInfo.getCompany().getId().toString();
        HashMap paramMap = new HashMap();
        paramMap.put("ARBILL_IS_SAME_PERSON", currentCompanyId);
        paramMap.put("CURRENCYSALE_AUTO_GEN_RECBILL", currentCompanyId);
        paramMap.put("AR_SCM_001", currentCompanyId);
        paramMap.put("AR_QTY_GT_SO", currentCompanyId);
        paramMap.put("AR_QTY_CANT_GT_SI", currentCompanyId);
        paramMap.put("CONSIGNSALES", currentCompanyId);
        paramMap.put("IS_ARAP_CORP_BILL", currentCompanyId);
        paramMap.put("AR_037", currentCompanyId);
        paramMap.put("AR_COOP_BILL_IS_EDIT", currentCompanyId);
        paramMap.put("AR_BIZ_reverse_01", currentCompanyId);
        paramMap.put("AR_VERIFY", currentCompanyId);
        paramMap = ArApParamHelper.getParamHashMap(ctx, paramMap);
        this.paramKeyMap.putAll(paramMap);
        String tableName = "T_AR_OtherBillEntry";
        if (!SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) || !SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            this.check4QtyNotGreater(ctx, otherBillInfo);
        }
        if (otherBillInfo.isIsInitializeBill() && !VerificateBillTypeEnum.ArAgentBizBill.equals((Object)otherBillInfo.getSourceBillType())) {
            throw new OtherBillBizException(OtherBillBizException.DISALLOWANCE_INITIALIZEBILL_AUDIT);
        }
        CompanyOrgUnitInfo currentCompany = otherBillInfo.getCompany();
        if (null == this.isRelationSCM) {
            this.isRelationSCM = new Boolean(this.getBooleanParamValue(ctx, "AR_SCM_001"));
        }
        String sysName = "2,12";
        SystemStatusCtrolCollection col = CommonServerUtils.getSysStatusCollection(ctx, currentCompany, sysName);
        SystemStatusCtrolInfo scmStatus = null;
        SystemStatusCtrolInfo arapStatus = null;
        boolean condition1 = col != null && col.get(0) != null && col.get(0).getSystemStatus() != null;
        boolean bl = condition2 = col != null && col.get(1) != null && col.get(1).getSystemStatus() != null;
        if (condition1 && SystemEnum.INVENTORYMANAGEMENT.equals((Object)col.get(0).getSystemStatus().getName())) {
            scmStatus = col.get(0);
        } else if (condition1 && this._getOwnedSys(ctx).equals((Object)col.get(0).getSystemStatus().getName())) {
            arapStatus = col.get(0);
        }
        if (condition2 && SystemEnum.INVENTORYMANAGEMENT.equals((Object)col.get(1).getSystemStatus().getName())) {
            scmStatus = col.get(1);
        } else if (condition2 && this._getOwnedSys(ctx).equals((Object)col.get(1).getSystemStatus().getName())) {
            arapStatus = col.get(1);
        }
        if (!otherBillInfo.isIsInitializeBill()) {
            if (otherBillInfo.isIsSCMBill() && scmStatus != null && scmStatus.getCurrentPeriod() != null && otherBillInfo.getBizDate().before(scmStatus.getCurrentPeriod().getBeginDate()) && otherBillInfo.getBizType() != null && ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(otherBillInfo.getBizType().getId().toString()) || "d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(otherBillInfo.getBizType().getId().toString())) && this.getBooleanParamValue(ctx, "CONSIGNSALES")) {
                throw new OtherBillBizException(OtherBillBizException.BIZDATEBEFORCURRENTPERIOD);
            }
            if (arapStatus != null && arapStatus.getCurrentPeriod() != null && otherBillInfo.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
                if (!otherBillInfo.isIsCoopBuild()) throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
                otherBillInfo.setBillDate(arapStatus.getCurrentPeriod().getBeginDate());
                DbUtil.execute((Context)ctx, (String)("update T_AR_OtherBill set FBILLDATE = {" + arapStatus.getCurrentPeriod().getBeginDate() + "} where fid = '" + otherBillInfo.getId().toString() + "'"));
            }
        } else if (arapStatus != null && arapStatus.getStartPeriod() != null && !otherBillInfo.getBillDate().before(arapStatus.getStartPeriod().getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        otherBillInfo.setAuditor(currentUser);
        otherBillInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
        if (this.getBooleanParamValue(ctx, "ARBILL_IS_SAME_PERSON") && ArApBillHelper.idEquals((CoreBaseInfo)otherBillInfo.getCreator(), (CoreBaseInfo)otherBillInfo.getAuditor()) && !otherBillInfo.isIsReverseBill()) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAME_PERSON);
        }
        if (!otherBillInfo.isIsBizBill()) {
            ArApServerUtils.injectBizFlow(ctx, (IObjectValue)otherBillInfo, BatchActionEnum.AUDIT);
        }
        if (otherBillInfo.isIsCoopBuild() && !otherBillInfo.isIsGenCoopBill() && BillStatusEnum.SUBMITED == otherBillInfo.getBillStatus() && this.checkWriteCoreOrderBill(ctx, (IObjectPK)new ObjectUuidPK(otherBillInfo.getId().toString()), null)) {
            this.writeBackCoreOrderBill(ctx, (IObjectPK)new ObjectUuidPK(otherBillInfo.getId().toString()), null, com.kingdee.eas.scm.common.BizActionEnum.AUDIT);
        }
        otherBillInfo.setBillStatus(BillStatusEnum.AUDITED);
        Timestamp planInvoiceDate = this.getPlanInvoiceDate(otherBillInfo);
        if (planInvoiceDate != null) {
            otherBillInfo.setPlanInvoiceDate(planInvoiceDate);
        }
        if (otherBillInfo.isIsBizBill()) {
            Set<String> entrySrcIdSet = this.getEntrySrcIdSet(otherBillInfo);
            super.updateSrcBillIsGenBizBill(ctx, entrySrcIdSet, true, true);
            this.requestBudget(ctx, otherBillInfo, 3);
            this.updatePartial(ctx, (CoreBaseInfo)otherBillInfo, this.getSelectorForAudit());
            if (otherBillInfo.isIsSCMBill()) {
                if (otherBillInfo.getSourceBillType() != null && !VerificateBillTypeEnum.SaleIssueBill.equals((Object)otherBillInfo.getSourceBillType())) {
                    throw new OtherBillBizException(OtherBillBizException.SRCBILLNOTISSUEBILL);
                }
                if (entrySrcIdSet.size() > 0) {
                    super.checkSrcBill2DupBizOtherBill(ctx, pk.toString(), entrySrcIdSet, 3, true);
                }
            }
            InvoiceUtils.dispose(ctx, "audit", pk.toString());
            return;
        }
        if (otherBillInfo.isIsTransBill() || otherBillInfo.isIsAllowanceBill()) {
            this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, otherBillInfo);
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, otherBillInfo);
            if (otherBillInfo.isIsAllowanceBill()) {
                int j2;
                otherBillInfo.setVerifyAmount(otherBillInfo.getAmount());
                otherBillInfo.setVerifyAmountLocal(otherBillInfo.getAmountLocal());
                otherBillInfo.setUnVerifyAmount(this.ZERO);
                otherBillInfo.setUnVerifyAmountLocal(this.ZERO);
                OtherBillentryInfo entry = null;
                OtherBillPlanInfo plan = null;
                for (j2 = 0; j2 < otherBillInfo.getEntry().size(); ++j2) {
                    entry = otherBillInfo.getEntry().get(j2);
                    entry.setVerifyAmount(entry.getUnVerifyAmount());
                    entry.setVerifyAmountLocal(entry.getUnVerifyAmountLocal());
                    entry.setUnVerifyAmount(this.ZERO);
                    entry.setUnVerifyAmountLocal(this.ZERO);
                }
                for (j2 = 0; j2 < otherBillInfo.getRecievePlan().size(); ++j2) {
                    plan = otherBillInfo.getRecievePlan().get(j2);
                    plan.setVerifyAmount(plan.getUnVerifyAmount());
                    plan.setVerifyAmountLocal(plan.getUnVerifyAmountLocal());
                    plan.setUnVerifyAmount(this.ZERO);
                    plan.setUnVerifyAmountLocal(this.ZERO);
                }
                this.reverseCoreBill4allowance(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, otherBillInfo);
            }
        }
        ArApBillHelper.updateArApVerifyStatus(otherBillInfo);
        SelectorItemCollection sic = otherBillInfo.isIsAllowanceBill() ? this.getSelectorForAllowanceAudit() : this.getSelectorForAudit();
        this.updatePartial(ctx, (CoreBaseInfo)otherBillInfo, sic);
        InvoiceUtils.dispose(ctx, "audit", pk.toString());
        String sql = "SELECT BILL.FBIZTYPEID,BILL.FPAYMENTTYPEID,BILL.FISREVERSEBILL,ENTRY.FSOURCEBILLID,ENTRY.FCOREBILLID FROM T_AR_OTHERBILL BILL LEFT JOIN T_AR_OTHERBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID WHERE BILL.FID = ? GROUP BY BILL.FBIZTYPEID,BILL.FPAYMENTTYPEID,BILL.FISREVERSEBILL,ENTRY.FSOURCEBILLID,ENTRY.FCOREBILLID";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        String bizTypeId = null;
        String paymentTypeId = null;
        boolean isReverseBill = false;
        int rsSize = rowSet.size();
        String[] srcIdArr = new String[rsSize];
        String[][] idList = new String[rsSize][2];
        int i = 0;
        try {
            while (rowSet.next()) {
                bizTypeId = rowSet.getString(1);
                paymentTypeId = rowSet.getString(2);
                isReverseBill = rowSet.getBoolean(3);
                idList[i][0] = rowSet.getString(4);
                idList[i][1] = rowSet.getString(5);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (this.getBooleanParamValue(ctx, "CONSIGNSALES")) {
            if (otherBillInfo.isIsReverseBill()) {
                this.updateInventroy(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, otherBillInfo.getSourceBillId().toString(), bizTypeId);
            } else {
                this.updateInventroy(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, pk.toString(), bizTypeId);
            }
        }
        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)new OtherBillInfo().getBOSType(), (String[])srcIdArr);
        if (otherBillInfo.isIsReverseBill()) {
            for (j = 0; j < handlers.length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, new String[]{otherBillInfo.getSourceBillId().toString()}, idList);
            }
        } else {
            for (j = 0; j < handlers.length && handlers[j] != null; ++j) {
                if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType())) continue;
                handlers[j].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, new String[]{pk.toString()}, idList);
            }
        }
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.AUDIT, null, (IObjectValue)otherBillInfo);
        if (!otherBillInfo.isIsTransOtherBill() && otherBillInfo.isIsCoopBuild() && !otherBillInfo.isIsGenCoopBill() && !otherBillInfo.isIsTransBill()) {
            this.writeBackSubstituteBill(ctx, (IObjectPK)new ObjectUuidPK(otherBillInfo.getId().toString()), null, com.kingdee.eas.scm.common.BizActionEnum.AUDIT);
        }
        boolean flag = false;
        boolean createVirtualBillFlag = this.isCreateVirtualBill(ctx, otherBillInfo);
        if (!otherBillInfo.isIsImportBill() && !otherBillInfo.isIsReverseBill() && !OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType()) && createVirtualBillFlag) {
            IVirtualBillFacade iv = VirtualBillFacadeFactory.getLocalInstance((Context)ctx);
            flag = iv.createVirtualBill((IObjectValue)otherBillInfo);
        }
        boolean isBatchWriteback = false;
        for (int j3 = 0; j3 < otherBillInfo.getEntry().size(); ++j3) {
            if (otherBillInfo.getEntry().get(j3).getCoreBillType() == null || !"528d806a-0106-1000-e111-0194c0a812e6463ED552".equals(otherBillInfo.getEntry().get(j3).getCoreBillType().getId().toString())) continue;
            isBatchWriteback = true;
            break;
        }
        if (!flag || this.getBooleanParamValue(ctx, "AR_037") || this.getBooleanParamValue(ctx, "IS_ARAP_CORP_BILL") || isBatchWriteback) {
            if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
                ICodingRuleManager iCodingRuleManager;
                CodingRuleInfo codeRuleInfo;
                this.batchWriteback(ctx, pk, BatchActionEnum.AUDIT);
                if (otherBillInfo.isIsCoopBuild() && (StringUtils.isEmpty((String)otherBillInfo.getNumber()) || otherBillInfo.getNumber().equals("AutoNumberFromBTP_" + otherBillInfo.getId().toString())) && (codeRuleInfo = (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getCodingRule((IObjectValue)otherBillInfo, otherBillInfo.getCompany().getId().toString())) != null) {
                    this.getNewNumber(ctx, otherBillInfo, otherBillInfo.getCompany().getId().toString(), null);
                    if (!StringUtils.isEmpty((String)otherBillInfo.getNumber())) {
                        DbUtil.execute((Context)ctx, (String)("update T_AR_OtherBill set FNumber = '" + otherBillInfo.getNumber() + "' where fid = '" + otherBillInfo.getId().toString() + "'"));
                    }
                }
            }
            if (this.isGenArAp(ctx, otherBillInfo)) {
                this.autoCreateBillByInnerBiz(ctx, otherBillInfo);
            }
            if (this.isGenArAp4RecPay(ctx, otherBillInfo)) {
                this.generateArApBill(ctx, otherBillInfo);
            }
        }
        if (!isReverseBill && "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(paymentTypeId) && this.getBooleanParamValue(ctx, "CURRENCYSALE_AUTO_GEN_RECBILL")) {
            this._createReceivingBill(ctx, pk);
        }
        if (!otherBillInfo.isIsCoopBuild()) {
            String tablename = null;
            try {
                tablename = "AR2SOWB_KSQL_0";
                tablename = KsqlUtil.createTempTable((Context)ctx, (String)WriteBackSQLHelper.getAR2SOTempTableSQL((String)tablename));
                String idStringList = WriteBackSQLHelper.getKeyIdList((String[])new String[]{pk.toString()});
                String WB_TEMP = WriteBackSQLHelper.getAR2SOInsertTempSQL((String)idStringList, (String)tablename);
                DbUtil.execute((Context)ctx, (String)WB_TEMP, (Object[])new Object[0]);
                String WB_TEMP2 = WriteBackSQLHelper.createAR2SOArClosedStatusWriteSQL((com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.AUDIT, (String)idStringList, (String)tablename);
                DbUtil.execute((Context)ctx, (String)WB_TEMP2, (Object[])new Object[0]);
            }
            finally {
                if (tablename != null) {
                    KsqlUtil.releaseTempTable((Context)ctx, (String)tablename);
                }
            }
        }
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType()) && otherBillInfo.getSourceBillId() != null && otherBillInfo.getEntry() != null && otherBillInfo.getSourceBillType() != null && !VerificateBillTypeEnum.OTHER.equals((Object)otherBillInfo.getSourceBillType())) {
            StringBuffer sqljdtz = new StringBuffer();
            OtherBillentryCollection entryColl = otherBillInfo.getEntry();
            ArrayList<String> sqlList = new ArrayList<String>();
            IBillType billype = BillTypeFactory.getLocalInstance((Context)ctx);
            HashMap<String, BillTypeInfo> typeMap = new HashMap<String, BillTypeInfo>();
            String billtypeId = null;
            BillTypeInfo typeInfo = null;
            for (int j4 = 0; j4 < entryColl.size(); ++j4) {
                OtherBillentryInfo entryInfo = entryColl.get(j4);
                BillTypeInfo billtypeInfo = entryInfo.getCoreBillType();
                if (billtypeInfo == null || billtypeInfo.getId() == null) continue;
                billtypeId = billtypeInfo.getId().toString();
                if (!typeMap.containsKey(billtypeId)) {
                    typeInfo = billype.getBillTypeInfo("select headTable,entryTable where id = '" + billtypeId + "'");
                    typeMap.put(billtypeId, typeInfo);
                } else {
                    typeInfo = (BillTypeInfo)typeMap.get(billtypeId);
                }
                String headTable = typeInfo.getHeadTable();
                String entryTable = typeInfo.getEntryTable();
                sqljdtz.setLength(0);
                if ("T_SD_SaleOrder".equals(headTable) && "T_SD_SaleOrderEntry".equals(entryTable)) {
                    sqljdtz.append(" update T_SD_SaleOrderEntry AS soe set ftotalArAmount = ftotalArAmount +" + entryInfo.getRecievePayAmount() + " where fid= '" + entryInfo.getCoreBillEntryId() + "'");
                    sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleOrder so, T_AR_OTHERBILL ar");
                    sqljdtz.append(" WHERE ((so.FIsCentralBalance = 1 AND so.FCompanyOrgUnitID = ar.FCompanyID)");
                    sqljdtz.append(" OR (so.FIsCentralBalance = 0 AND soe.FCompanyOrgUnitID = ar.FCompanyID))");
                    sqljdtz.append(" AND so.FID = soe.FParentID");
                    sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                    sqlList.add(sqljdtz.toString());
                    continue;
                }
                if ("T_SD_SaleReturns".equals(headTable) && "T_SD_SaleReturnsEntry".equals(entryTable)) {
                    sqljdtz.append(" update T_SD_SaleReturnsEntry AS sre set finvoicePrice = finvoicePrice - " + entryInfo.getRecievePayAmount() + " where fid= '" + entryInfo.getCoreBillEntryId() + "'");
                    sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleReturns sr, T_AR_OTHERBILL ar");
                    sqljdtz.append(" WHERE ((sr.FIsCentralBalance = 1 AND sr.FCompanyOrgUnitID = ar.FCompanyID)");
                    sqljdtz.append(" OR (sr.FIsCentralBalance = 0 AND sre.FCompanyOrgUnitID = ar.FCompanyID))");
                    sqljdtz.append(" AND sr.FID = sre.FParentID");
                    sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                    sqlList.add(sqljdtz.toString());
                    continue;
                }
                if (!"T_IM_TransferOrderBill".equals(headTable) || !"T_IM_TransferOrderBillEntry".equals(entryTable)) continue;
                this.writeBackTransOrderSql(sqljdtz, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, entryInfo.getCoreBillEntryId(), true, entryInfo.getRecievePayAmount());
                sqlList.add(sqljdtz.toString());
            }
            DBUtil.execBatchSql((Context)ctx, sqlList, (boolean)true);
        }
        if (otherBillInfo.isIsSCMBill() && !otherBillInfo.isIsIncomeConfirm() && OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
            String value = null == paramMap.get("AR_BIZ_reverse_01") ? "" : paramMap.get("AR_BIZ_reverse_01").toString();
            StringBuffer sb = new StringBuffer("");
            sb.append("SELECT ");
            sb.append(" bizentry.FParentID,bizentry.FCoreBillEntryID,bizentry.FID,bizentry.FAmount,bizentry.FAmountLocal,bizentry.FRecievePayAmount,bizentry.FRecievePayAmountLocal,bizentry.FMaterialID,bizentry.FMATERIALNAME");
            sb.append(",bizentry.FMeasureUnitID,bizentry.FBaseUnitID,bizentry.FAssistUnitID,bizentry.FAssistPropertyID,bizentry.FRemark,bizentry.FPrice,bizentry.FTaxPrice,bizentry.FActualPrice,bizentry.FRealPrice");
            sb.append(",bizentry.FDiscountRate,bizentry.FTaxRate,bizentry.FIsPresent,bizentry.FDiscountType,bizentry.FCoreBillID,bizentry.FCoreBillNumber,bizentry.FCoreBillEntrySeq");
            sb.append(",bizentry.FContractBillID,bizentry.FContractEntryID,bizentry.FContractEntrySeq,bizentry.FContractNumber,bizentry.FCoreBillTypeID,bizentry.FAccountID,bizentry.FOppAccountID");
            sb.append(",bizentry.FOrderCustomerID,bizentry.FOrdCustName,bizentry.FOrdCustNumber,bizentry.FServiceCustomerID,bizentry.FSerCustName,bizentry.FSerCustNumber,bizentry.FRecAsstActTypeID");
            sb.append(",bizentry.FRecAsstActID,bizentry.FRecAsstActNumber,bizentry.FRecSendOrgUnitID,bizentry.FSourceBillEntryID,bizentry.FReversedBaseQty,bizentry.FCostCenterID");
            sb.append(",bizentry.FRecAsstActName_" + ctx.getLocale());
            sb.append(", bizentry.FBaseQty - bizentry.FReversedBaseQty AS UnReversedBaseQty");
            sb.append(" FROM T_AR_OtherBillEntry bizentry");
            sb.append(" INNER JOIN T_AR_OtherBill bizbill ON bizentry.FParentID = bizbill.FID WHERE ");
            if ("1".equals(value) && otherBillInfo.getEntry().get(0).getCoreBillEntryId() != null && !"".equals(otherBillInfo.getEntry().get(0).getCoreBillEntryId())) {
                sb.append(" FCOREBILLENTRYID in (SELECT FCOREBILLENTRYID  FROM t_ar_otherbillentry where FPARENTID = ?) ");
            } else {
                sb.append(" FSourceBillEntryID in (SELECT FSourceBillEntryID  FROM t_ar_otherbillentry where FPARENTID = ?) ");
            }
            sb.append(" AND bizBill.FCompanyID = ? AND bizBill.FBillType = ?");
            sb.append(" AND bizBill.FIsBizBill = 1 AND bizBill.FBillStatus = ?");
            sb.append(" ORDER BY bizentry.FCoreBillNumber, bizentry.FCoreBillEntrySeq, bizBill.FBillDate");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{otherBillInfo.getId().toString(), otherBillInfo.getCompany().getId().toString(), otherBillInfo.getBillType().getValue(), 3});
            if (rowSet.size() > 0) {
                this.autoReversedBizInvoiceAR(ctx, rowSet, otherBillInfo, value);
            }
        }
        if (this.isReqSCMCalculate(ctx, otherBillInfo)) {
            ICalculateFacade icf = CalculateFacadeFactory.getLocalInstance((Context)ctx);
            icf.calculate((CoreBillBaseInfo)otherBillInfo);
        }
        ARDisposeUtil.dispose(ctx, otherBillInfo, DisposerActionEnum.AUDIT);
        this.autoVerify(ctx, otherBillInfo, true);
        if (otherBillInfo.getPaymentType() != null && !"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(otherBillInfo.getPaymentType().getId().toString())) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.AUDIT);
        }
        logger.info((Object)"-------end audit interface----------");
        if (!StringUtil.isEmpty((String)otherBillInfo.getPreRecBillNumber())) {
            this.autoPreVerify(ctx, otherBillInfo);
        }
        if (paramMap.get("AR_VERIFY") != null && Boolean.parseBoolean((String)paramMap.get("AR_VERIFY"))) {
            this.autoVerify4SameSide(ctx, otherBillInfo, true);
        }
        this.requestBudget(ctx, otherBillInfo, 3);
    }

    @Override
    protected SelectorItemCollection getSelectorForAudit() {
        SelectorItemCollection selector = super.getSelectorForAudit();
        selector.add("planInvoiceDate");
        selector.add("verifyAmount");
        selector.add("verifyAmountLocal");
        selector.add("unVerifyAmount");
        selector.add("unVerifyAmountLocal");
        selector.add("entry.unVerifyAmount");
        selector.add("entry.unVerifyAmountLocal");
        selector.add("entry.verifyAmount");
        selector.add("entry.verifyAmountLocal");
        selector.add("recievePlan.verifyAmount");
        selector.add("recievePlan.verifyAmountLocal");
        selector.add("recievePlan.unVerifyAmount");
        selector.add("recievePlan.unVerifyAmountLocal");
        return selector;
    }

    protected SelectorItemCollection getSelectorForAllowanceAudit() {
        SelectorItemCollection sic = this.getSelectorForAudit();
        sic.add("verifyStatus");
        return sic;
    }

    protected boolean isCreateVirtualBill(Context ctx, OtherBillInfo info) {
        return true;
    }

    protected boolean isGenArAp(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        return true;
    }

    protected boolean isGenArAp4RecPay(Context ctx, OtherBillInfo info) {
        return true;
    }

    protected void autoReversedBizInvoiceAR(Context ctx, IRowSet rowSet, OtherBillInfo info, String reverseType) throws BOSException, EASBizException {
        try {
            int i;
            HashMap<String, OtherBillInfo> srcBillMap = new HashMap<String, OtherBillInfo>();
            HashMap<String, OtherBillentryInfo> srcBillEntryMap = new HashMap<String, OtherBillentryInfo>();
            HashMap<String, OtherBillentryCollection> coreBillEntryMap = new HashMap<String, OtherBillentryCollection>();
            HashMap<String, OtherBillentryInfo> bizBillEntryMap = new HashMap<String, OtherBillentryInfo>();
            OtherBillInfo reversedInfo = null;
            OtherBillentryInfo reversedSrcEntryInfo = null;
            OtherBillentryCollection reversedSrcEntrys = null;
            Map<String, Boolean> isEntryFullWriteoffMap = this.getEntryFullWriteOff(ctx, info);
            HashSet<String> idSet = new HashSet<String>();
            HashMap<String, OtherBillentryInfo> reversedInfoOldEntryMap = new HashMap<String, OtherBillentryInfo>();
            OtherBillentryInfo reversedOldEntryInfo = null;
            while (rowSet.next()) {
                if (rowSet.getBigDecimal("UnReversedBaseQty").signum() == 0) continue;
                if (!srcBillMap.containsKey(rowSet.getString("FParentID"))) {
                    reversedInfo = (OtherBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(rowSet.getString("FParentID")), ArApSelectorFactory.getArOtherbillSelector(true));
                    for (int i2 = 0; i2 < reversedInfo.getEntry().size(); ++i2) {
                        reversedOldEntryInfo = reversedInfo.getEntry().get(i2);
                        reversedInfoOldEntryMap.put(reversedOldEntryInfo.getId().toString(), reversedOldEntryInfo);
                    }
                    reversedInfo.getEntry().clear();
                    OtherBillInfo clone = (OtherBillInfo)reversedInfo.clone();
                    clone.setCreator(null);
                    clone.setCreateTime(null);
                    clone.setAccountant(null);
                    srcBillMap.put(rowSet.getString("FParentID"), clone);
                }
                reversedSrcEntrys = coreBillEntryMap.containsKey(rowSet.getString("FCoreBillEntryID")) ? (OtherBillentryCollection)((Object)coreBillEntryMap.get(rowSet.getString("FCoreBillEntryID"))) : new OtherBillentryCollection();
                reversedSrcEntryInfo = (OtherBillentryInfo)reversedInfoOldEntryMap.get(rowSet.getString("FID"));
                reversedSrcEntryInfo.setBaseQty(this.ZERO);
                reversedSrcEntryInfo.setReversedBaseQty(rowSet.getBigDecimal("UnReversedBaseQty"));
                reversedSrcEntryInfo.setAmount(rowSet.getBigDecimal("FAmount"));
                reversedSrcEntryInfo.setAmountLocal(rowSet.getBigDecimal("FAmountLocal"));
                reversedSrcEntryInfo.setRecievePayAmount(rowSet.getBigDecimal("FRecievePayAmount"));
                reversedSrcEntryInfo.setRecievePayAmountLocal(rowSet.getBigDecimal("FRecievePayAmountLocal"));
                reversedSrcEntryInfo.setVerifyAmount(this.ZERO);
                reversedSrcEntryInfo.setVerifyAmountLocal(this.ZERO);
                reversedSrcEntryInfo.setUnVerifyAmount(reversedSrcEntryInfo.getRecievePayAmount());
                reversedSrcEntryInfo.setUnVerifyAmountLocal(reversedSrcEntryInfo.getRecievePayAmountLocal());
                reversedSrcEntryInfo.setLockVerifyAmt(this.ZERO);
                reversedSrcEntryInfo.setLockVerifyAmtLocal(this.ZERO);
                reversedSrcEntryInfo.setLockUnVerifyAmt(reversedSrcEntryInfo.getRecievePayAmount());
                reversedSrcEntryInfo.setLockUnVerifyAmtLocal(reversedSrcEntryInfo.getRecievePayAmountLocal());
                reversedSrcEntryInfo.setSourceBillId(rowSet.getString("FParentID"));
                reversedSrcEntryInfo.setSourceBillEntryId(rowSet.getString("FID"));
                reversedSrcEntrys.add(reversedSrcEntryInfo);
                srcBillEntryMap.put(rowSet.getString("FSourceBillEntryID"), reversedSrcEntryInfo);
                coreBillEntryMap.put(rowSet.getString("FCoreBillEntryID"), reversedSrcEntrys);
                if (rowSet.getBigDecimal("FReversedBaseQty").signum() == 0) continue;
                idSet.add(rowSet.getString("FID"));
                bizBillEntryMap.put(rowSet.getString("FID"), reversedSrcEntryInfo);
            }
            if (idSet.size() > 0) {
                StringBuffer sb = new StringBuffer("");
                sb.append("SELECT entry.FSourceBillEntryID, -1 * SUM(entry.FAmount) AS FAmount, -1 * SUM(entry.FAmountLocal) AS FAmountLocal,");
                sb.append(" -1 * SUM(entry.FRecievePayAmount) AS FRecievePayAmount, -1 * SUM(entry.FRecievePayAmountLocal) AS FRecievePayAmountLocal,");
                sb.append(" -1 * SUM(entry.FTAXAMOUNT) AS FTAXAMOUNT ,");
                sb.append(" -1 * SUM(entry.FTAXAMOUNTLOCAL) AS FTAXAMOUNTLOCAL ,");
                sb.append(" -1 * SUM(entry.FDISCOUNTAMOUNT) AS FDISCOUNTAMOUNT ,");
                sb.append(" -1 * SUM(entry.FDISCOUNTAMOUNTLOCAL) AS FDISCOUNTAMOUNTLOCAL ");
                sb.append(" FROM T_AR_OtherBill bill INNER JOIN T_AR_OtherBillEntry entry ON bill.FID = entry.FParentID");
                sb.append(" WHERE bill.FIsBizBill = 1 AND entry.FVerifyAmountLocal = entry.FRecievePayAmountLocal");
                sb.append(" AND bill.FCompanyID = '").append(info.getCompany().getId().toString()).append("'");
                sb.append(" AND entry.FSourceBillEntryID IN (").append(ArApBillHelper.ids2SqlString(idSet));
                sb.append(") GROUP BY entry.FSourceBillEntryID");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    if (!bizBillEntryMap.containsKey(rs.getString("FSourceBillEntryID"))) continue;
                    reversedSrcEntryInfo = (OtherBillentryInfo)bizBillEntryMap.get(rs.getString("FSourceBillEntryID"));
                    reversedSrcEntryInfo.setAmount(reversedSrcEntryInfo.getAmount().subtract(rs.getBigDecimal("FAmount")));
                    reversedSrcEntryInfo.setAmountLocal(reversedSrcEntryInfo.getAmountLocal().subtract(rs.getBigDecimal("FAmountLocal")));
                    reversedSrcEntryInfo.setRecievePayAmount(reversedSrcEntryInfo.getRecievePayAmount().subtract(rs.getBigDecimal("FRecievePayAmount")));
                    reversedSrcEntryInfo.setRecievePayAmountLocal(reversedSrcEntryInfo.getRecievePayAmountLocal().subtract(rs.getBigDecimal("FRecievePayAmountLocal")));
                    reversedSrcEntryInfo.setTaxAmount(reversedSrcEntryInfo.getTaxAmount().subtract(rs.getBigDecimal("FTAXAMOUNT")));
                    reversedSrcEntryInfo.setTaxAmountLocal(reversedSrcEntryInfo.getTaxAmountLocal().subtract(rs.getBigDecimal("FTAXAMOUNTLOCAL")));
                    reversedSrcEntryInfo.setDiscountAmount(reversedSrcEntryInfo.getDiscountAmount().subtract(rs.getBigDecimal("FDISCOUNTAMOUNT")).negate());
                    reversedSrcEntryInfo.setDiscountAmountLocal(reversedSrcEntryInfo.getDiscountAmountLocal().subtract(rs.getBigDecimal("FDISCOUNTAMOUNTLOCAL")).negate());
                }
            }
            OtherBillentryCollection entrys = info.getEntry();
            OtherBillentryInfo entryInfo = null;
            OtherBillentryCollection reversedEntrys = new OtherBillentryCollection();
            HashMap<String, Boolean> coreEntryFullWf = new HashMap<String, Boolean>();
            OtherBillentryInfo reversedEntryInfo = null;
            HashMap<String, BigDecimal> coreEntryReversedBaseQty = new HashMap<String, BigDecimal>();
            BigDecimal reversedBaseQty = this.ZERO;
            for (i = 0; i < entrys.size(); ++i) {
                entryInfo = entrys.get(i);
                reversedBaseQty = entryInfo.getBaseQty();
                boolean isEntryFullWf = isEntryFullWriteoffMap.get(entryInfo.getId().toString());
                if (srcBillEntryMap.containsKey(entryInfo.getSourceBillEntryId())) {
                    reversedEntryInfo = (OtherBillentryInfo)srcBillEntryMap.get(entryInfo.getSourceBillEntryId());
                    if (entryInfo.getBaseQty().signum() * reversedEntryInfo.getReversedBaseQty().signum() > 0) {
                        if (entryInfo.getBaseQty().abs().compareTo(reversedEntryInfo.getReversedBaseQty().abs()) >= 0) {
                            reversedBaseQty = entryInfo.getBaseQty().subtract(reversedEntryInfo.getReversedBaseQty());
                            reversedEntryInfo.setBaseQty(reversedEntryInfo.getReversedBaseQty());
                            reversedEntryInfo.setReversedBaseQty(this.ZERO);
                        } else {
                            if (isEntryFullWf) {
                                reversedEntryInfo.setBaseQty(reversedEntryInfo.getReversedBaseQty());
                                reversedEntryInfo.setReversedBaseQty(this.ZERO);
                            } else {
                                reversedEntryInfo.setReversedBaseQty(reversedEntryInfo.getReversedBaseQty().subtract(entryInfo.getBaseQty()));
                                reversedEntryInfo.setBaseQty(entryInfo.getBaseQty());
                            }
                            reversedEntryInfo.setAmount(this.ZERO);
                            reversedEntryInfo.setAmountLocal(this.ZERO);
                            reversedEntryInfo.setRecievePayAmount(this.ZERO);
                            reversedEntryInfo.setRecievePayAmountLocal(this.ZERO);
                            reversedBaseQty = this.ZERO;
                        }
                        reversedEntrys.add(reversedEntryInfo);
                    } else {
                        throw new OtherBillBizException(OtherBillBizException.SIGNUMNOTEQUALS);
                    }
                }
                if (reversedBaseQty.signum() == 0) continue;
                if (coreEntryReversedBaseQty.containsKey(entryInfo.getCoreBillEntryId())) {
                    coreEntryReversedBaseQty.put(entryInfo.getCoreBillEntryId(), ((BigDecimal)coreEntryReversedBaseQty.get(entryInfo.getCoreBillEntryId())).add(reversedBaseQty));
                } else {
                    coreEntryReversedBaseQty.put(entryInfo.getCoreBillEntryId(), reversedBaseQty);
                }
                if (!isEntryFullWf) continue;
                coreEntryFullWf.put(entryInfo.getCoreBillEntryId(), isEntryFullWf);
            }
            if ("1".equals(reverseType)) {
                Iterator it = coreEntryReversedBaseQty.entrySet().iterator();
                Map.Entry me = null;
                boolean isEntryFullWf = false;
                block6: while (it.hasNext()) {
                    me = it.next();
                    reversedBaseQty = (BigDecimal)me.getValue();
                    boolean bl = isEntryFullWf = null != coreEntryFullWf.get(me.getKey());
                    if (!coreBillEntryMap.containsKey(me.getKey())) continue;
                    reversedSrcEntrys = (OtherBillentryCollection)((Object)coreBillEntryMap.get(me.getKey()));
                    for (int i3 = 0; i3 < reversedSrcEntrys.size(); ++i3) {
                        reversedEntryInfo = reversedSrcEntrys.get(i3);
                        if (reversedBaseQty.signum() * reversedEntryInfo.getReversedBaseQty().signum() <= 0) continue;
                        if (reversedBaseQty.abs().compareTo(reversedEntryInfo.getReversedBaseQty().abs()) >= 0 || isEntryFullWf) {
                            reversedBaseQty = reversedBaseQty.subtract(reversedEntryInfo.getReversedBaseQty());
                            reversedEntryInfo.setBaseQty(reversedEntryInfo.getBaseQty().add(reversedEntryInfo.getReversedBaseQty()));
                            reversedEntryInfo.setReversedBaseQty(this.ZERO);
                        } else {
                            reversedEntryInfo.setBaseQty(reversedEntryInfo.getBaseQty().add(reversedBaseQty));
                            reversedEntryInfo.setReversedBaseQty(reversedEntryInfo.getReversedBaseQty().subtract(reversedBaseQty));
                            reversedEntryInfo.setAmount(this.ZERO);
                            reversedEntryInfo.setAmountLocal(this.ZERO);
                            reversedEntryInfo.setRecievePayAmount(this.ZERO);
                            reversedEntryInfo.setRecievePayAmountLocal(this.ZERO);
                            reversedBaseQty = this.ZERO;
                        }
                        if (!reversedEntrys.contains(reversedEntryInfo.getId())) {
                            reversedEntrys.add(reversedEntryInfo);
                        }
                        if (reversedBaseQty.signum() == 0) continue block6;
                    }
                }
            }
            if (reversedEntrys.size() > 0) {
                for (i = 0; i < reversedEntrys.size(); ++i) {
                    reversedEntryInfo = reversedEntrys.get(i);
                    reversedEntryInfo.setId(null);
                    reversedEntryInfo.setBaseQty(reversedEntryInfo.getBaseQty().negate());
                    reversedEntryInfo.setReversedBaseQty(this.ZERO);
                    reversedEntryInfo.setQuantity(this.ZERO);
                    if (!srcBillMap.containsKey(reversedEntryInfo.getSourceBillId())) continue;
                    ((OtherBillInfo)srcBillMap.get(reversedEntryInfo.getSourceBillId())).getEntry().add(reversedEntryInfo);
                }
                boolean isAutoNumber = this.isAutoNumber(ctx, info, info.getCompany().getId().toString());
                Iterator billIt = srcBillMap.entrySet().iterator();
                while (billIt.hasNext()) {
                    reversedInfo = (OtherBillInfo)billIt.next().getValue();
                    if (reversedInfo.getEntry().size() == 0) continue;
                    String sourceBillID = reversedInfo.getId().toString();
                    reversedInfo.setAmountLocal(this.ZERO);
                    reversedInfo.setSourceBillId(info.getId().toString());
                    reversedInfo.getPlans().clear();
                    reversedInfo.setId(BOSUuid.create((BOSObjectType)reversedInfo.getId().getType()));
                    reversedInfo.setBillDate(info.getBillDate());
                    reversedInfo.setBizDate(info.getBizDate());
                    this.setYearAndPeriod(ctx, reversedInfo);
                    reversedInfo.setFiVouchered(false);
                    reversedInfo.setIsAppointVoucher(false);
                    reversedInfo.setVoucher(null);
                    reversedInfo.setVoucherNumber(null);
                    reversedInfo.setVoucherType(null);
                    reversedInfo.setPcaVouchered(false);
                    reversedInfo.setIsInitializeBill(false);
                    reversedInfo.setIsImportBill(false);
                    reversedInfo.setIsImpFromGL(false);
                    reversedInfo.setAbstractName(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"ReversedBizBill", (Locale)ctx.getLocale()) + " - " + reversedInfo.getNumber());
                    reversedInfo.setAccountant(null);
                    if (isAutoNumber) {
                        reversedInfo.setNumber(null);
                        reversedInfo = (OtherBillInfo)this.getNewNumber(ctx, reversedInfo, reversedInfo.getCompany().getId().toString(), null);
                    } else {
                        reversedInfo.setNumber(reversedInfo.getNumber() + "-Rever");
                    }
                    this.checkNumber(ctx, reversedInfo);
                    OtherBillentryInfo reversedEntryInfo1 = null;
                    String companyID = reversedInfo.getCompany() == null ? null : reversedInfo.getCompany().getId().toString();
                    Date billDate = reversedInfo.getBillDate();
                    int size = reversedInfo.getEntry().size();
                    for (int i4 = 0; i4 < size; ++i4) {
                        reversedEntryInfo1 = reversedInfo.getEntry().get(i4);
                        reversedEntryInfo1.setCompany(companyID);
                        reversedEntryInfo1.setBillDate(billDate);
                    }
                    ArApBillHelper.calculate(ctx, reversedInfo, null);
                    this.handleInfoBeforeReversedBizSubmit(ctx, reversedInfo, true);
                    IObjectPK newPK = super._submit(ctx, (IObjectValue)reversedInfo);
                    this.requestBudget(ctx, reversedInfo, 1);
                    this.requestBudget(ctx, reversedInfo, 3);
                    String sql = "update t_ar_otherBill set fbillstatus=?,fauditdate=?,fauditorid=? ,flastupdateuserid = null,flastupdatetime = null where fid=? ";
                    Object[] params = new Object[]{new Integer(3), new Timestamp(System.currentTimeMillis()), CommonServerUtils.getCurrentUser(ctx).getId().toString(), newPK.toString()};
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
                    IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)info.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new SaleIssueBillInfo().getBOSType().toString()));
                    ev.setFilter(filter);
                    BOTRelationCollection botColl = iBOTRelation.getCollection(ev);
                    ArrayList<String> currOtherbillSrcbillIds = null;
                    if (botColl != null && botColl.size() > 0) {
                        currOtherbillSrcbillIds = new ArrayList<String>();
                        for (int i5 = 0; i5 < botColl.size(); ++i5) {
                            currOtherbillSrcbillIds.add(botColl.get(i5).getSrcObjectID());
                        }
                        this.paramContext.put("currOtherbillSrcbillIds", currOtherbillSrcbillIds);
                    }
                    this.realizePreOrNextRelation(ctx, newPK, sourceBillID);
                    this.verifiedBizARAP(ctx, info, (OtherBillInfo)this._getValue(ctx, newPK, this.getBOTPSelectors()), true);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    @Deprecated
    protected void _batchReversedBizBill(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this._batchReversedBizBill(ctx, pks, null, null);
    }

    @Override
    protected String _batchReversedBizBill(Context ctx, IObjectPK[] pks, Date txtBillDate, Date txtBizDate) throws BOSException, EASBizException {
        if (null == pks) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(this.getSelectors());
        ev.setFilter(this.convert2FilterInfo(pks));
        OtherBillCollection srcBillInfos = this.getOtherBillCollection(ctx, ev);
        if (null == srcBillInfos || srcBillInfos.size() == 0) {
            return null;
        }
        for (int k = 0; k < srcBillInfos.size(); ++k) {
            OtherBillInfo srcBillInfo = srcBillInfos.get(k);
            String companyName = srcBillInfo.getCompany().getName();
            String billNumer = srcBillInfo.getNumber();
            try {
                if (!BillStatusEnum.AUDITED.equals((Object)srcBillInfo.getBillStatus())) {
                    throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
                }
                if (!srcBillInfo.isIsBizBill()) {
                    throw new OtherBillBizException(OtherBillBizException.NOTBIZARAPBILL, new String[]{""});
                }
                OtherBillInfo destBillInfo = (OtherBillInfo)srcBillInfo.clone();
                destBillInfo.setId(null);
                destBillInfo.setBillStatus(BillStatusEnum.SAVE);
                destBillInfo.setFiVouchered(false);
                destBillInfo.setIsAppointVoucher(false);
                destBillInfo.setVoucher(null);
                destBillInfo.setVoucherNumber(null);
                destBillInfo.setVoucherType(null);
                destBillInfo.setPcaVouchered(false);
                destBillInfo.setIsInitializeBill(false);
                destBillInfo.setIsImportBill(false);
                destBillInfo.setIsImpFromGL(false);
                destBillInfo.setCreateTime(null);
                destBillInfo.setCreator(null);
                destBillInfo.setAccountant(null);
                if (!this.isAutoNumber(ctx, srcBillInfo, srcBillInfo.getCompany().getId().toString())) {
                    destBillInfo.setNumber(srcBillInfo.getNumber() + "-Rever");
                } else {
                    destBillInfo.setNumber(null);
                }
                destBillInfo.setAbstractName(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"ReversedBizBill", (Locale)ctx.getLocale()) + " - " + srcBillInfo.getNumber());
                PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, srcBillInfo.getCompany());
                super.setDate4ReversedBizBill(ctx, srcBillInfo, destBillInfo, currentPeriod, txtBillDate, txtBizDate);
                this.setYearAndPeriod(ctx, destBillInfo);
                destBillInfo.setSourceBillId(srcBillInfo.getId().toString());
                OtherBillentryCollection srcBillEntrys = srcBillInfo.getEntry();
                OtherBillentryCollection destBillEntrys = destBillInfo.getEntry();
                OtherBillentryInfo srcBillEntryInfo = null;
                OtherBillentryInfo destBillEntryInfo = null;
                HashSet<String> srcBillEntryIdSet = new HashSet<String>();
                HashMap<String, MultiMeasureUnitInfo> multiMeasureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
                IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                boolean isInvoiceBill = OtherBillTypeEnum.InvoiceBill.equals((Object)destBillInfo.getBillTypeEnum());
                for (int i = srcBillEntrys.size() - 1; i >= 0; --i) {
                    srcBillEntryInfo = srcBillEntrys.get(i);
                    destBillEntryInfo = destBillEntrys.get(i);
                    if (isInvoiceBill && destBillEntryInfo.getBaseQty().compareTo(destBillEntryInfo.getReversedBaseQty()) == 0 || !isInvoiceBill && destBillEntryInfo.getUnVerifyAmountLocal().signum() == 0) {
                        destBillEntrys.remove(destBillEntryInfo);
                        continue;
                    }
                    destBillEntryInfo.setHead(null);
                    destBillEntryInfo.setSourceBillId(srcBillInfo.getId().toString());
                    destBillEntryInfo.setSourceBillEntryId(srcBillEntryInfo.getId().toString());
                    if (isInvoiceBill) {
                        destBillEntryInfo.setBaseQty(destBillEntryInfo.getBaseQty().subtract(destBillEntryInfo.getReversedBaseQty()).negate());
                        if (destBillEntryInfo.getMaterial() != null && destBillEntryInfo.getMeasureUnit() != null) {
                            String strMaterialID = destBillEntryInfo.getMaterial().getId().toString();
                            String strMeasureUnitID = destBillEntryInfo.getMeasureUnit().getId().toString();
                            MultiMeasureUnitInfo multiMeasureUnit = (MultiMeasureUnitInfo)multiMeasureUnitMap.get(strMaterialID + "_" + strMeasureUnitID);
                            if (multiMeasureUnit == null) {
                                multiMeasureUnit = iMultiMeasureUnit.getMultiUnit(strMaterialID, strMeasureUnitID);
                                multiMeasureUnitMap.put(strMaterialID + "_" + strMeasureUnitID, multiMeasureUnit);
                            }
                            if (multiMeasureUnit != null) {
                                destBillEntryInfo.setQuantity(destBillEntryInfo.getBaseQty().divide(multiMeasureUnit.getBaseConvsRate(), multiMeasureUnit.getQtyPrecision(), 4));
                            }
                        } else {
                            destBillEntryInfo.setQuantity(this.ZERO);
                        }
                    } else {
                        destBillEntryInfo.setBaseQty(destBillEntryInfo.getUnwriteOffBaseQty().negate());
                        destBillEntryInfo.setQuantity(destBillEntryInfo.getQuantity().negate());
                    }
                    if (destBillEntryInfo.getVerifyAmountLocal().signum() != 0) {
                        srcBillEntryIdSet.add(destBillEntryInfo.getId().toString());
                    }
                    destBillEntryInfo.setReversedBaseQty(this.ZERO);
                    destBillEntryInfo.setVerifyAmount(this.ZERO);
                    destBillEntryInfo.setVerifyAmountLocal(this.ZERO);
                }
                if (destBillEntrys.size() == 0) {
                    throw new OtherBillBizException(OtherBillBizException.UNREVERSEDBASEQTYISZERO);
                }
                this.handleInfo4ReverseBizBill(ctx, destBillInfo, true, srcBillEntryIdSet);
                IObjectPK iObjectPK = this.submit(ctx, (CoreBaseInfo)destBillInfo);
                continue;
            }
            catch (Exception ex) {
                this.addExceptionMsg(companyName, billNumer, ex.getMessage());
            }
        }
        return super.getExceptionMsg();
    }

    @Override
    protected CoreBillBaseCollection getSrcCollForGenBizBill(Context ctx, Collection ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.customer.id"));
        sic.add(new SelectorItemInfo("parent.customer.number"));
        sic.add(new SelectorItemInfo("parent.customer.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.bizType"));
        sic.add(new SelectorItemInfo("parent.isInTax"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("balanceCustomer.id"));
        sic.add(new SelectorItemInfo("balanceCustomer.number"));
        sic.add(new SelectorItemInfo("balanceCustomer.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("paymentCustomer.id"));
        sic.add(new SelectorItemInfo("paymentCustomer.number"));
        sic.add(new SelectorItemInfo("paymentCustomer.name"));
        sic.add(new SelectorItemInfo("orderCustomer.id"));
        sic.add(new SelectorItemInfo("orderCustomer.number"));
        sic.add(new SelectorItemInfo("orderCustomer.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("saleorder"));
        sic.add(new SelectorItemInfo("saleorderEntry"));
        sic.add(new SelectorItemInfo("saleOrderEntrySeq"));
        sic.add(new SelectorItemInfo("saleOrderNumber"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("unWriteOffBaseQty"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("baseUnit"));
        sic.add(new SelectorItemInfo("assistUnit"));
        sic.add(new SelectorItemInfo("assistProperty"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("isPresent"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("coreBillType"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("parent.exchangeRate"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SaleIssueEntryCollection siEntryCol = SaleIssueEntryFactory.getLocalInstance((Context)ctx).getSaleIssueEntryCollection(view);
        SaleIssueBillInfo siBillInfo = null;
        String id = null;
        HashMap<String, SaleIssueBillInfo> siMap = new HashMap<String, SaleIssueBillInfo>();
        CoreBillBaseCollection siCol = new CoreBillBaseCollection();
        for (int i = 0; i < siEntryCol.size(); ++i) {
            siBillInfo = siEntryCol.get(i).getParent();
            id = siBillInfo.getId().toString();
            if (siMap.get(id) == null) {
                siMap.put(id, siBillInfo);
            }
            ((SaleIssueBillInfo)siMap.get(id)).getEntry().add(siEntryCol.get(i));
        }
        Iterator iterator = siMap.entrySet().iterator();
        while (iterator.hasNext()) {
            siCol.addObject((IObjectValue)iterator.next().getValue());
        }
        return siCol;
    }

    protected String _batchGenBizBill(Context ctx, Collection ids) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (CreateJobFacadeFactory.getLocalInstance((Context)ctx).checkDuplicateTask("SCM_FI_AR_001" + company.getNumber())) {
            throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("parent.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.customer.id"));
        sic.add(new SelectorItemInfo("parent.customer.number"));
        sic.add(new SelectorItemInfo("parent.customer.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.bizType"));
        sic.add(new SelectorItemInfo("parent.isInTax"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("balanceCustomer.id"));
        sic.add(new SelectorItemInfo("balanceCustomer.number"));
        sic.add(new SelectorItemInfo("balanceCustomer.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("paymentCustomer.id"));
        sic.add(new SelectorItemInfo("paymentCustomer.number"));
        sic.add(new SelectorItemInfo("paymentCustomer.name"));
        sic.add(new SelectorItemInfo("orderCustomer.id"));
        sic.add(new SelectorItemInfo("orderCustomer.number"));
        sic.add(new SelectorItemInfo("orderCustomer.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("saleorder"));
        sic.add(new SelectorItemInfo("saleorderEntry"));
        sic.add(new SelectorItemInfo("saleOrderEntrySeq"));
        sic.add(new SelectorItemInfo("saleOrderNumber"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("unWriteOffBaseQty"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("baseUnit"));
        sic.add(new SelectorItemInfo("assistUnit"));
        sic.add(new SelectorItemInfo("assistProperty"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("isPresent"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("coreBillType"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("parent.exchangeRate"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SaleIssueEntryCollection siEntryCol = SaleIssueEntryFactory.getLocalInstance((Context)ctx).getSaleIssueEntryCollection(view);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < siEntryCol.size(); ++i) {
            idSet.add(siEntryCol.get(i).getSaleOrder());
        }
        view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("saleOrgUnit"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("saleGroup"));
        sic.add(new SelectorItemInfo("settlementType"));
        sic.add(new SelectorItemInfo("cashDiscount"));
        sic.add(new SelectorItemInfo("receiveCondition"));
        sic.add(new SelectorItemInfo("paymentType"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.discountType"));
        sic.add(new SelectorItemInfo("entries.discount"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillNumber"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntrySeq"));
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SaleOrderCollection soCol = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderCollection(view);
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo user = CommonServerUtils.getCurrentUser(ctx);
        PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
        paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, company);
        HashMap<String, Object> otherBillMap = new HashMap<String, Object>();
        HashMap<String, BOTRelationInfo> relationMap = new HashMap<String, BOTRelationInfo>();
        HashMap<BOSUuid, AccountViewInfo> billAccount = new HashMap<BOSUuid, AccountViewInfo>();
        StringBuffer message = new StringBuffer("");
        SaleOrderInfo saleOrderInfo = null;
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        SaleIssueBillInfo invBillBaseInfo = null;
        SaleIssueEntryInfo siEntryInfo = null;
        OtherBillInfo info = null;
        OtherBillentryInfo entryInfo = null;
        BOTRelationInfo relationInfo = null;
        String key = null;
        String currencyId = company.getBaseCurrency().getId().toString();
        idSet.clear();
        AccountViewInfo accountInfo = new AccountViewInfo();
        AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActType(AsstActTypeSysEnum.CUSTOMER);
        for (int i = 0; i < siEntryCol.size(); ++i) {
            siEntryInfo = siEntryCol.get(i);
            invBillBaseInfo = siEntryInfo.getParent();
            if (siEntryInfo.getPrice() == null || siEntryInfo.getPrice().signum() == 0) {
                message.append(new MessageFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"genARBizBillFailed", (Locale)ctx.getLocale())).format(new String[]{invBillBaseInfo.getNumber(), String.valueOf(siEntryInfo.getSeq())}));
                message.append("\n");
                continue;
            }
            if (siEntryInfo.getSaleOrder() != null && soCol.contains((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder()))) {
                currencyId = soCol.get((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder())).getCurrency().getId().toString();
            }
            if (otherBillMap.containsKey(key = (siEntryInfo.getBalanceCustomer() == null ? "null" : siEntryInfo.getBalanceCustomer().getId().toString()) + (invBillBaseInfo.getAdminOrgUnit() == null ? "null" : invBillBaseInfo.getAdminOrgUnit().getId().toString()) + (siEntryInfo.getSalePerson() == null ? "null" : siEntryInfo.getSalePerson().getId().toString()) + currencyId + invBillBaseInfo.isIsInTax())) {
                info = (OtherBillInfo)otherBillMap.get(key);
            } else {
                info = new OtherBillInfo();
                info.setId(BOSUuid.create((BOSObjectType)new OtherBillInfo().getBOSType()));
                info.setIsBizBill(true);
                info.setIsInTax(invBillBaseInfo.isIsInTax());
                info.setBillType(OtherBillTypeEnum.InvoiceBill);
                info.setBillStatus(BillStatusEnum.AUDITED);
                info.setBizType(invBillBaseInfo.getBizType());
                info.setAdminOrgUnit(invBillBaseInfo.getAdminOrgUnit());
                info.setAsstActID(siEntryInfo.getBalanceCustomer().getId().toString());
                info.setAsstActNumber(siEntryInfo.getBalanceCustomer().getNumber());
                info.setAsstActName(siEntryInfo.getBalanceCustomer().getName());
                info.setPerson(siEntryInfo.getSalePerson());
                info.setLastExhangeRate(invBillBaseInfo.getExchangeRate());
                info.setAsstActType(asstActTypeInfo);
                info.setSourceBillType(VerificateBillTypeEnum.SaleIssueBill);
                Date date = new Date();
                info.setCreator(user);
                info.setCreateTime(new Timestamp(date.getTime()));
                info.setLastUpdateUser(user);
                info.setLastUpdateTime(new Timestamp(date.getTime()));
                info.setAuditor(user);
                info.setAuditDate(new Timestamp(System.currentTimeMillis()));
                info.setCompany(company);
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                info.setPaymentType(paymentTypeInfo);
                info.setBillDate(currentPeriod.getEndDate());
                info.setBizDate(currentPeriod.getEndDate());
                info.setPeriod(currentPeriod.getPeriodNumber());
                info.setYear(currentPeriod.getPeriodYear());
                if (siEntryInfo.getSaleOrder() != null && soCol.contains((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder()))) {
                    saleOrderInfo = soCol.get((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder()));
                    info.setCurrency(saleOrderInfo.getCurrency());
                    info.setSaleOrg(saleOrderInfo.getSaleOrgUnit());
                    info.setSaleGroup(saleOrderInfo.getSaleGroup());
                    info.setExchangeRate(saleOrderInfo.getExchangeRate());
                    info.setSettleType(saleOrderInfo.getSettlementType());
                    info.setCashDiscount(saleOrderInfo.getCashDiscount());
                    info.setPayCondition(saleOrderInfo.getReceiveCondition());
                    info.setPaymentType(saleOrderInfo.getPaymentType());
                }
            }
            if (billAccount.containsKey(info.getId())) {
                accountInfo = (AccountViewInfo)billAccount.get(info.getId());
            } else {
                boolean isContrast;
                accountInfo = new AccountViewInfo();
                IRowSet accountResult = this._getKAClassAccount(ctx, company.getId().toString(), info.getAsstActID(), false, true, 0);
                if (accountResult != null) {
                    try {
                        if (accountResult.next()) {
                            accountInfo.setId(BOSUuid.read((String)accountResult.getString("account_id")));
                            accountInfo.setNumber(accountResult.getString("account_number"));
                            accountInfo.setName(accountResult.getString("account_name"));
                        }
                        accountInfo = null;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                } else {
                    accountInfo = null;
                }
                IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
                if (accountInfo != null && !(isContrast = iContrastAcct.isContrastAccount(cuInfo.getId().toString(), company.getId().toString(), accountInfo.getId().toString(), AccountControlAttribute.AR))) {
                    accountInfo = null;
                }
                billAccount.put(info.getId(), accountInfo);
            }
            entryInfo = new OtherBillentryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)new OtherBillentryInfo().getBOSType()));
            entryInfo.setBaseQty(siEntryInfo.getUnWriteOffBaseQty());
            entryInfo.setRecievePayAmountLocal(this.ZERO);
            entryInfo.setMaterial(siEntryInfo.getMaterial());
            if (siEntryInfo.getMaterial() != null) {
                entryInfo.setMaterialName(siEntryInfo.getMaterial().getName());
            }
            entryInfo.setMeasureUnit(siEntryInfo.getUnit());
            entryInfo.setBaseUnit(siEntryInfo.getBaseUnit());
            entryInfo.setAssistUnit(siEntryInfo.getAssistUnit());
            entryInfo.setAssistProperty(siEntryInfo.getAssistProperty());
            entryInfo.setPrice(siEntryInfo.getPrice());
            entryInfo.setTaxPrice(siEntryInfo.getTaxPrice());
            entryInfo.setRealPrice(siEntryInfo.getActualPrice());
            entryInfo.setTaxRate(siEntryInfo.getTaxRate());
            entryInfo.setDiscountType(siEntryInfo.getDiscountType());
            if (entryInfo.getDiscountRate() == null || entryInfo.getDiscountRate().compareTo(BigDecimal.ZERO) == 0) {
                entryInfo.setDiscountRate(siEntryInfo.getDiscount() == null ? BigDecimal.ZERO : siEntryInfo.getDiscount());
            }
            if (siEntryInfo.getSaleOrder() != null && soCol.contains((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder())) && (saleOrderInfo = soCol.get((Object)BOSUuid.read((String)siEntryInfo.getSaleOrder()))).getEntries().contains((Object)BOSUuid.read((String)siEntryInfo.getSaleOrderEntry()))) {
                saleOrderEntryInfo = saleOrderInfo.getEntries().get((Object)BOSUuid.read((String)siEntryInfo.getSaleOrderEntry()));
                entryInfo.setDiscountType(saleOrderEntryInfo.getDiscountType());
                entryInfo.setDiscountRate(saleOrderEntryInfo.getDiscount());
                entryInfo.setContractBillID(saleOrderEntryInfo.getSourceBillId());
                entryInfo.setContractNum(saleOrderEntryInfo.getSourceBillNumber());
                entryInfo.setContractEntryID(saleOrderEntryInfo.getSourceBillEntryId());
                entryInfo.setContractEntrySeq(String.valueOf(saleOrderEntryInfo.getSourceBillEntrySeq()));
            }
            entryInfo.setProject(siEntryInfo.getProject());
            entryInfo.setTrackNumberzc(siEntryInfo.getTrackNumber());
            entryInfo.setIsPresent(siEntryInfo.isIsPresent());
            entryInfo.setCoreBillId(siEntryInfo.getSaleOrder());
            entryInfo.setCoreBillEntryId(siEntryInfo.getSaleOrderEntry());
            entryInfo.setCoreBillNumber(siEntryInfo.getSaleOrderNumber());
            entryInfo.setCoreBillEntrySeq(siEntryInfo.getSaleOrderEntrySeq());
            entryInfo.setSourceBillId(invBillBaseInfo.getId().toString());
            entryInfo.setSourceBillEntryId(siEntryInfo.getId().toString());
            entryInfo.setCoreBillType(siEntryInfo.getCoreBillType());
            entryInfo.setOrderCustomer(siEntryInfo.getOrderCustomer());
            entryInfo.setOrdCustName(siEntryInfo.getOrderCustomer().getName());
            entryInfo.setOrdCustNumber(siEntryInfo.getOrderCustomer().getNumber());
            entryInfo.setServiceCustomer(invBillBaseInfo.getCustomer());
            entryInfo.setSerCustName(invBillBaseInfo.getCustomer().getName());
            entryInfo.setSerCustNumber(invBillBaseInfo.getCustomer().getNumber());
            entryInfo.setRecAsstActType(asstActTypeInfo);
            entryInfo.setRecAsstActID(siEntryInfo.getPaymentCustomer().getId().toString());
            entryInfo.setRecAsstActName(siEntryInfo.getPaymentCustomer().getName());
            entryInfo.setRecAsstActNumber(siEntryInfo.getPaymentCustomer().getNumber());
            entryInfo.setAccount(accountInfo);
            entryInfo.setCompany(info.getCompany().getId().toString());
            entryInfo.setBillDate(info.getBillDate());
            info.getEntry().add(entryInfo);
            otherBillMap.put(key, info);
            key = invBillBaseInfo.getId().toString() + info.getId().toString();
            if (relationMap.containsKey(key)) {
                relationInfo = (BOTRelationInfo)relationMap.get(key);
            } else {
                relationInfo = new BOTRelationInfo();
                relationInfo.setSrcObjectID(invBillBaseInfo.getId().toString());
                relationInfo.setDestEntityID(OtherBillInfo.getBosType());
                relationInfo.setSrcEntityID(SALE_ISSUE_BILL_BOS_TYPE);
                relationInfo.setDestObjectID(info.getId().toString());
                relationInfo.setOperatorID(user.getId().toString());
                relationInfo.setType(0);
            }
            relationMap.put(key, relationInfo);
            idSet.add(invBillBaseInfo.getId().toString());
        }
        if (otherBillMap.size() > 0) {
            String[] billNumber = null;
            boolean isAutoNumber = this.isAutoNumber(ctx, new OtherBillInfo(), company.getId().toString());
            if (isAutoNumber) {
                OtherBillCollection col = new OtherBillCollection();
                CollectionUtil.mapToCollection((IObjectCollection)col, otherBillMap);
                billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getBatchNumber((IObjectCollection)col, company.getId().toString(), "", "");
            }
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new OtherBillInfo().getBOSType(), (Context)ctx, (Connection)conn);
                Iterator it = otherBillMap.entrySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    info = (OtherBillInfo)it.next().getValue();
                    if (isAutoNumber) {
                        info.setNumber(billNumber[i]);
                    } else {
                        info.setNumber("AutoNumberFromBTP_" + info.getId());
                    }
                    ArApBillHelper.calculate(ctx, info, null);
                    dao.addNewBatch((IObjectValue)info);
                    ++i;
                }
                dao.executeBatch();
                dao = ORMappingDAO.getInstance((BOSObjectType)new BOTRelationInfo().getBOSType(), (Context)ctx, (Connection)conn);
                it = relationMap.entrySet().iterator();
                while (it.hasNext()) {
                    dao.addNewBatch((IObjectValue)((BOTRelationInfo)it.next().getValue()));
                }
                dao.executeBatch();
                StringBuffer sb = new StringBuffer("");
                sb.append("UPDATE T_IM_SALEISSUEBILL SET FIsGenBizAR = 1 WHERE FID IN (");
                i = 0;
                it = idSet.iterator();
                while (it.hasNext()) {
                    if (i > 1000) {
                        sb.deleteCharAt(sb.length() - 1).append(")");
                        DbUtil.execute((Context)ctx, (String)sb.toString());
                        sb.setLength(0);
                        sb.append("UPDATE T_IM_SALEISSUEBILL SET FIsGenBizAR = 1 WHERE FID IN (");
                        i = 0;
                    }
                    sb.append("'").append(it.next().toString()).append("',");
                    ++i;
                }
                sb.deleteCharAt(sb.length() - 1).append(")");
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return message.toString();
    }

    public static String createAR2SOArClosedStatusWriteSQL(com.kingdee.eas.scm.common.BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SD_SaleOrderEntry as upd set (FArClosedStatus) =");
        sql.append("(select TOP 1 case when soe.FTotalInvoicedQty >= soe.FQty then 1 else 0 end as FArClosedStatus ");
        sql.append("from T_SD_SaleOrderEntry soe inner join ").append(temptable);
        sql.append(" as are on are.FCoreBillEntryId = soe.FID) where upd.fid in( ");
        sql.append(" select FCoreBillEntryId from ").append(temptable).append(")");
        return sql.toString();
    }

    private void batchWriteback(Context ctx, IObjectPK pk, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        IBusinessProcessor processor = null;
        BatchActionResults batchResults = null;
        boolean coopAssign = "true".equals(ctx.get((Object)"isCoopBuild"));
        GeneralBusinessProcessorBuilder builder = new GeneralBusinessProcessorBuilder(batchActionEnum, this.getBOSType(), "510b6503-0105-1000-e000-0117c0a812fd463ED552");
        processor = builder.buildProcessor(ctx);
        if (processor != null) {
            batchResults = BatchActionResults.populateActionResults((Object[])new Object[]{pk});
            try {
                if (!coopAssign) {
                    ctx.put((Object)"isCoopBuild", (Object)"true");
                }
                batchResults = processor.execute(batchResults);
            }
            catch (ObjectNotFoundException e) {
                throw new OtherBillBizException(OtherBillBizException.LACK_COOP_ARPBOTP);
            }
            finally {
                if (!coopAssign) {
                    ctx.remove((Object)"isCoopBuild");
                    if (ctx.get((Object)"isCoopBuild") != null) {
                        ctx.put((Object)"isCoopBuild", (Object)"false");
                    }
                }
            }
            batchResults.throwExceptions();
        }
    }

    private void check4QtyNotGreater(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        if (otherBillInfo == null) {
            return;
        }
        if (otherBillInfo.isIsReverseBill() || otherBillInfo.isIsBizBill() || otherBillInfo.isIsAllowanceBill() || otherBillInfo.isIsTransBill()) {
            return;
        }
        if (otherBillInfo.isBotpBill()) {
            boolean arQtyGtSiQty = this.getBooleanParamValue(ctx, "AR_QTY_CANT_GT_SI");
            BillTypeInfo coreBillType = null;
            boolean exeistsReturnsBill = false;
            boolean exeistsTansferBill = false;
            String coreBillTypeID = null;
            int size = otherBillInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                coreBillType = otherBillInfo.getEntry().get(i).getCoreBillType();
                String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
                if (VerificateBillTypeEnum.SaleIssueBill.equals((Object)otherBillInfo.getSourceBillType()) && ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(coreBillTypeID) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeID))) {
                    exeistsReturnsBill = true;
                    break;
                }
                if (!VerificateBillTypeEnum.SaleIssueBill.equals((Object)otherBillInfo.getSourceBillType()) || !"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeID)) continue;
                exeistsTansferBill = true;
                break;
            }
            if (arQtyGtSiQty && exeistsReturnsBill) {
                StringBuffer selectQuerySQL = new StringBuffer("");
                selectQuerySQL.append("SELECT OTHERBILLE.FSEQ AS FSEQ,OTHERBILL.FNUMBER AS FNUMBER, SALEISSUEBILL.FNUMBER AS FWBNUMBER,SALEISSUEBILLE.FSEQ AS FWBSEQ");
                selectQuerySQL.append(" FROM T_AR_OTHERBILL OTHERBILL INNER JOIN T_AR_OTHERBILLENTRY OTHERBILLE ON OTHERBILL.FID = OTHERBILLE.FPARENTID");
                selectQuerySQL.append(" INNER JOIN T_IM_SALEISSUEENTRY SALEISSUEBILLE ON SALEISSUEBILLE.FID = OTHERBILLE.FSOURCEBILLENTRYID ");
                selectQuerySQL.append(" INNER JOIN T_IM_SALEISSUEBILL SALEISSUEBILL ON SALEISSUEBILL.FID=SALEISSUEBILLE.FParentID");
                selectQuerySQL.append(" WHERE OTHERBILL.FID = '").append(otherBillInfo.getId().toString()).append("'");
                selectQuerySQL.append(" AND ABS(OTHERBILLE.FBaseQty) > ABS(SALEISSUEBILLE.FUnWriteOffBaseQty)");
                selectQuerySQL.append(" AND (OTHERBILLE.FcoreBillTypeID='").append("50957179-0105-1000-e008-8152c0a812fd463ED552");
                selectQuerySQL.append("' OR OTHERBILLE.FcoreBillTypeID='").append("50957179-0105-1000-e000-015bc0a812fd463ED552").append("')");
                selectQuerySQL.append(" order by SALEISSUEBILLE.FSEQ ASC");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectQuerySQL.toString());
                StringBuffer sql = new StringBuffer("");
                boolean isError = false;
                try {
                    while (rowSet.next()) {
                        isError = true;
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"AR_ISSUEQTYGTARQTY", (Locale)ctx.getOriginLocale())).append("\n");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"ARNO", (Locale)ctx.getOriginLocale())).append(":");
                        sql.append(rowSet.getString("FNumber"));
                        sql.append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SEQNO", (Locale)ctx.getOriginLocale())).append(":");
                        sql.append(rowSet.getInt("FSeq")).append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"WBNO", (Locale)ctx.getOriginLocale())).append("-->");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SALEISSUE", (Locale)ctx.getOriginLocale()));
                        sql.append(":").append(rowSet.getString("FWBNumber")).append(";");
                        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource", (String)"SEQNO", (Locale)ctx.getOriginLocale())).append(":");
                        sql.append(rowSet.getInt("FWBSeq")).append("\n");
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)("sql is :" + selectQuerySQL.toString()), (Throwable)e);
                    throw new BOSException("sql is :" + selectQuerySQL.toString(), (Throwable)e);
                }
                if (isError) {
                    throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
                }
            } else if (arQtyGtSiQty && exeistsTansferBill) {
                StringBuffer bf = new StringBuffer();
                bf.append(" select  ");
                bf.append(" T_IM_SALEISSUEBILL.fnumber as number, ");
                bf.append(" T_IM_SALEISSUEENTRY.fseq as imseq, ");
                bf.append(" T_IM_SALEISSUEENTRY.funWriteOffBaseQty as unWriteOffBaseQty, ");
                bf.append(" t_ar_otherbillentry.fseq as arseq, ");
                bf.append(" t_ar_otherbillentry.funwriteOffBaseQty as arunwriteOffBaseQty ");
                bf.append(" from t_ar_otherBill ");
                bf.append(" inner join t_ar_otherbillentry on t_ar_otherBill.fid = t_ar_otherBillentry.fparentid ");
                bf.append(" inner join T_IM_SALEISSUEENTRY on T_IM_SALEISSUEENTRY.fid = t_ar_otherbillentry.FSourceBillEntryId ");
                bf.append(" inner join T_IM_SALEISSUEBILL on T_IM_SALEISSUEBILL.fid = T_IM_SALEISSUEENTRY.fparentid ");
                bf.append(" where t_ar_otherBill.fid= '").append(otherBillInfo.getId().toString()).append("'");
                String number = null;
                BigDecimal unWriteOffBaseQty = this.ZERO;
                BigDecimal arunWriteOffBaseQty = this.ZERO;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)bf.toString());
                try {
                    while (rs.next()) {
                        number = rs.getString("number");
                        unWriteOffBaseQty = rs.getBigDecimal("unWriteOffBaseQty") != null ? rs.getBigDecimal("unWriteOffBaseQty") : this.ZERO;
                        arunWriteOffBaseQty = rs.getBigDecimal("arunWriteOffBaseQty") != null ? rs.getBigDecimal("arunWriteOffBaseQty") : this.ZERO;
                        if (arunWriteOffBaseQty.abs().compareTo(unWriteOffBaseQty.abs()) <= 0) continue;
                        throw new OtherBillBizException(OtherBillBizException.WRITEPURINWAREHSBILLERROR, new Object[]{otherBillInfo.getNumber(), new Integer(rs.getInt("arseq")), number, new Integer(rs.getInt("imseq"))});
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)("sql is :" + bf.toString()), (Throwable)e);
                    throw new BOSException("sql is :" + bf.toString(), (Throwable)e);
                }
            }
        }
    }

    protected boolean isReqSCMCalculate(Context ctx, OtherBillInfo info) throws EASBizException, BOSException {
        boolean isSrcProxyBill;
        if (info.isIsReverseBill() || info.isIsAllowanceBill() || info.isIsTransBill()) {
            return false;
        }
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)info.getBillType())) {
            return false;
        }
        if (info.getSourceBillType() == null || VerificateBillTypeEnum.OTHER.equals((Object)info.getSourceBillType())) {
            return false;
        }
        boolean bl = isSrcProxyBill = !VerificateBillTypeEnum.ArAgentBizBill.equals((Object)info.getSourceBillType());
        if (null == this.isRelationSCM) {
            boolean isStartparam = ArApParamHelper.isRelationSCM(ctx, info.getCompany().getId().toString(), this._getOwnedSys(ctx));
            this.isRelationSCM = isStartparam;
        }
        return info.isIsSCMBill() || this.isRelationSCM != false && !isSrcProxyBill;
    }

    private void checkBillInBadAcct(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        StringBuffer checkSql = new StringBuffer(50);
        checkSql.append("select fid from T_AR_BadAcct where fbillid = '").append(pk.toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        try {
            if (rs.next()) {
                throw new OtherBillBizException(OtherBillBizException.BAD_ACCT_CANNOT_UNAUDIT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unPassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        int j;
        IRowSet rowSet;
        this.addSameCoreBillEntrySeqLock(ctx, pk);
        this.checkBillInBadAcct(ctx, pk);
        boolean isCanUnAuditSwap = false;
        isCanUnAuditSwap = OtherBillSwapHelper.unAuditCheckSwap(ctx, pk, true);
        OtherBillInfo info = this.getOtherBillInfo(ctx, pk, this.getSelectors());
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeBizProcess(info.getCompany(), info.getBillDate());
        this.checkIsInQueue(ctx, info);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setAuditDate(null);
        info.setAuditor(null);
        sql.append("update t_ar_otherBill set fbillstatus=" + new Integer(1) + ",fauditdate=null,fauditorid=null where fid='" + pk.toString() + "'");
        list.add(sql.toString());
        EnactmentServiceFactory.createEnactService((Context)ctx).abortProcessByHoldedObjectId(pk.toString());
        if (info.isIsBizBill()) {
            StringBuffer sb = new StringBuffer("");
            sb.append("UPDATE T_IM_SaleIssueBill AS sibill SET FIsGenBizAR = 0");
            sb.append(" WHERE EXISTS (SELECT 1 FROM T_AR_OtherBill arbill");
            sb.append(" INNER JOIN T_BOT_Relation relation ON arbill.FID = relation.FDestObjectID");
            sb.append(" WHERE arbill.FID = '").append(pk.toString()).append("'");
            sb.append(" AND relation.FSrcObjectID = sibill.FID)");
            list.add(sb.toString());
            DBUtil.execBatchSql((Context)ctx, list, (boolean)true);
            ArApBillHelper.updateArApVerifyStatus(info);
            this.updatePartial(ctx, (CoreBaseInfo)info, this.getSelectorForAudit());
            InvoiceUtils.dispose(ctx, "unaudit", pk.toString());
            return;
        }
        String tableName = "T_AR_OtherBill";
        String tableEntryName = "T_AR_OtherBillEntry";
        String srcEntryTable = "T_AP_OtherBillEntry";
        String srcTable = "T_AP_OtherBill";
        String srcRecPayTable = "T_CAS_ReceivingBill";
        String srcRecPayEntryTab = "T_CAS_ReceivingBillEntry";
        String recPayParentStr = "FReceivingBillID";
        String destBosType = ArApConstants.AR_OBILL_TYPE.toString();
        sql.setLength(0);
        sql.append("select srcArEntry.FID FEntryID,srcArBill.FID FID,arBill.FID FDestID,arEntry.FID FDestEntryID,").append("\n");
        sql.append("isnull(arEntry.FRecievePayAmount,0) FThisAmt,isnull(arEntry.FRecievePayAmountLocal,0) FThisLocalAmt ").append("\n");
        sql.append("from ").append(tableEntryName).append(" arEntry ").append("\n");
        sql.append("inner join ").append(tableName).append(" arBill on arBill.FID = arEntry.FParentID ").append("\n");
        sql.append("inner join ").append(tableEntryName).append(" srcArEntry on srcArEntry.FID = arEntry.FSourceBillEntryID ").append("\n");
        sql.append("inner join ").append(tableName).append(" srcArBill on srcArBill.FID = srcArEntry.FParentID ").append("\n");
        sql.append("inner join ").append(srcRecPayEntryTab).append(" rbe on rbe.FSourceBillEntryID  = srcArEntry.FID ").append("\n");
        sql.append("inner join ").append(srcRecPayTable).append(" rb on rb.FID = rbe.").append(recPayParentStr).append("\n");
        sql.append("inner join ").append(srcEntryTable).append(" apEntry on rbe.FID = apEntry.FSourceBillEntryID ").append("\n");
        sql.append("inner join ").append(srcTable).append(" apBill on apBill.FID = apEntry.FParentID ").append("\n");
        sql.append("where arEntry.FParentID = '").append(info.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (info.isIsTransBill() || info.isIsAllowanceBill()) {
            if (!this.isCoopBillEdit(ctx, info) || !info.isIsCoopBuild() || rs.size() <= 0) {
                this.reverse4arap(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, info);
            }
            if (info.isIsAllowanceBill()) {
                int j2;
                info.setVerifyAmount(this.ZERO);
                info.setVerifyAmountLocal(this.ZERO);
                info.setUnVerifyAmount(info.getAmount());
                info.setUnVerifyAmountLocal(info.getAmountLocal());
                OtherBillentryInfo entry = null;
                OtherBillPlanInfo plan = null;
                for (j2 = 0; j2 < info.getEntry().size(); ++j2) {
                    entry = info.getEntry().get(j2);
                    entry.setUnVerifyAmount(entry.getVerifyAmount());
                    entry.setUnVerifyAmountLocal(entry.getVerifyAmountLocal());
                    entry.setVerifyAmount(this.ZERO);
                    entry.setVerifyAmountLocal(this.ZERO);
                }
                ArApBillHelper.updateArApVerifyStatus(info);
                this.reverseCoreBill4allowance(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, info);
                for (j2 = 0; j2 < info.getRecievePlan().size(); ++j2) {
                    plan = info.getRecievePlan().get(j2);
                    plan.setUnVerifyAmount(plan.getVerifyAmount());
                    plan.setUnVerifyAmountLocal(plan.getVerifyAmountLocal());
                    plan.setVerifyAmount(this.ZERO);
                    plan.setVerifyAmountLocal(this.ZERO);
                }
            }
            this.reverse4RecPay(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, info);
        }
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            ArApBillHelper.updateArApVerifyStatus(info);
            this.updatePartial(ctx, (CoreBaseInfo)info, this.getSelectorForAudit());
        }
        InvoiceUtils.dispose(ctx, "unaudit", pk.toString());
        if (info.getPaymentType() != null && !"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(info.getPaymentType().getId().toString())) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.UNAUDIT);
        }
        IManualWriteOffFacade m = ManualWriteOffFacadeFactory.getLocalInstance((Context)ctx);
        m.inverseWriteOff(new String[]{pk.toString()});
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.UNAUDIT);
        ARDisposeUtil.dispose(ctx, info, DisposerActionEnum.ANTI_AUDIT);
        if (this.isReqSCMCalculate(ctx, info) || info.isIsReverseBill()) {
            sql.setLength(0);
            sql.append("select fSourceBillId,fCoreBillId from t_ar_otherbillentry where fparentid = ? group by fSourceBillId,fCoreBillId");
            rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            int rsSize = rowSet.size();
            String[] srcIdArr = new String[rsSize];
            String[][] idList = new String[rsSize][2];
            int i = 0;
            try {
                while (rowSet.next()) {
                    idList[i][0] = rowSet.getString(1);
                    idList[i][1] = rowSet.getString(2);
                    srcIdArr[i] = idList[i][0];
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            boolean isBatchWriteback = false;
            for (j = 0; j < info.getEntry().size(); ++j) {
                if (info.getEntry().get(j).getCoreBillType() == null || !"528d806a-0106-1000-e111-0194c0a812e6463ED552".equals(info.getEntry().get(j).getCoreBillType().getId().toString())) continue;
                isBatchWriteback = true;
                break;
            }
            if (isBatchWriteback) {
                this.batchWriteback(ctx, pk, BatchActionEnum.UNAUDIT);
            } else {
                int j3;
                IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)this.getBOSType(), (String[])srcIdArr);
                if (info.isIsReverseBill()) {
                    for (j3 = 0; j3 < handlers.length && handlers[j3] != null; ++j3) {
                        handlers[j3].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.AUDIT, new String[]{info.getSourceBillId().toString()}, idList);
                    }
                } else {
                    for (j3 = 0; j3 < handlers.length && handlers[j3] != null; ++j3) {
                        if (OtherBillTypeEnum.DebitAdjust.equals((Object)info.getBillType())) continue;
                        handlers[j3].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, new String[]{pk.toString()}, idList);
                    }
                }
                this.batchWriteback(ctx, pk, BatchActionEnum.UNAUDIT);
            }
            if (!info.isIsCoopBuild()) {
                String tablename = null;
                try {
                    tablename = "AR2SOWB_KSQL_0";
                    tablename = KsqlUtil.createTempTable((Context)ctx, (String)WriteBackSQLHelper.getAR2SOTempTableSQL((String)tablename));
                    String idStringList = WriteBackSQLHelper.getKeyIdList((String[])new String[]{pk.toString()});
                    String WB_TEMP = WriteBackSQLHelper.getAR2SOInsertTempSQL((String)idStringList, (String)tablename);
                    DbUtil.execute((Context)ctx, (String)WB_TEMP, (Object[])new Object[0]);
                    String WB_TEMP2 = WriteBackSQLHelper.createAR2SOArClosedStatusWriteSQL((com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, (String)idStringList, (String)tablename);
                    DbUtil.execute((Context)ctx, (String)WB_TEMP2, (Object[])new Object[0]);
                }
                finally {
                    if (tablename != null) {
                        KsqlUtil.releaseTempTable((Context)ctx, (String)tablename);
                    }
                }
            }
        }
        WriteBackFactory.getInstance().getWriteBackHandler(IncomeConfimBillInfo.getBosType(), OtherBillInfo.getBosType()).handle(ctx, BizActionEnum.UNAUDIT, null, (IObjectValue)info);
        if (this.getBooleanParamValue(ctx, "CONSIGNSALES") && info.getBizType() != null) {
            if (info.isIsReverseBill()) {
                this.updateInventroy(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, info.getSourceBillId().toString(), info.getBizType().getId().toString());
            } else {
                this.updateInventroy(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, pk.toString(), info.getBizType().getId().toString());
            }
        }
        if (this.isCoopBillEdit(ctx, info)) {
            if (info.isIsCoopBuild()) {
                this.writeBackSubstituteBill(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), null, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT);
                if (this.checkWriteCoreOrderBill(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), null)) {
                    this.writeBackCoreOrderBill(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), null, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT);
                }
            }
        } else {
            if (info.isIsGenCoopBill()) {
                sql.setLength(0);
                sql.append("SELECT rel.FDestObjectID FROM T_AR_OtherBill bill");
                sql.append(" INNER JOIN T_BOT_RELATION rel ON bill.FID = rel.FSrcObjectID");
                sql.append(" INNER JOIN T_SCM_BizType biztype ON bill.FBizTypeID = biztype.FID");
                sql.append(" WHERE rel.FDestEntityID = '48DA3A71' AND biztype.FNumber in ('310','311') AND bill.FID = ?");
                rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
                try {
                    if (rowSet.next()) {
                        String arPK = rowSet.getString("FDestObjectID");
                        rowSet = DBUtil.executeQuery((Context)ctx, (String)"select fSourceBillId,fCoreBillId from t_ap_otherbillentry where fparentid = ? group by fSourceBillId,fCoreBillId", (Object[])new Object[]{arPK});
                        int rsSize = rowSet.size();
                        String[] srcIdArr = new String[rsSize];
                        String[][] idList = new String[rsSize][2];
                        int i = 0;
                        while (rowSet.next()) {
                            idList[i][0] = rowSet.getString(1);
                            idList[i][1] = rowSet.getString(2);
                            srcIdArr[i] = idList[i][0];
                            ++i;
                        }
                        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)new com.kingdee.eas.fi.ap.OtherBillInfo().getBOSType(), (String[])srcIdArr);
                        for (int j4 = 0; j4 < handlers.length && handlers[j4] != null; ++j4) {
                            handlers[j4].handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, new String[]{arPK}, idList);
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (info.isIsTransOtherBill()) {
                    this.writeBackSubstituteBill(ctx, null, info, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT);
                }
                if (info.isIsGenCoopBill() && !info.isIsCoopBuild() && this.checkWriteCoreOrderBill(ctx, null, (IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                    this.writeBackCoreOrderBill(ctx, null, (IObjectPK)new ObjectUuidPK(info.getId().toString()), com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT);
                }
                this.deleteNextBill(ctx, info.getId().toString());
                this.updateGenCoopBill(ctx, info.getId().toString());
            }
            if (info.isIsCoopBuild()) {
                throw new OtherBillBizException(OtherBillBizException.COOPBILL_NOT_UNAUDIT);
            }
        }
        if (info.getBillType().equals((Object)OtherBillTypeEnum.DebitAdjust) && info.getSourceBillId() != null && info.getEntry() != null && info.getSourceBillType() != null && !VerificateBillTypeEnum.OTHER.equals((Object)info.getSourceBillType())) {
            StringBuffer sqljdtz = new StringBuffer();
            OtherBillentryCollection entryColl = info.getEntry();
            IBillType billype = BillTypeFactory.getLocalInstance((Context)ctx);
            HashMap<String, BillTypeInfo> typeMap = new HashMap<String, BillTypeInfo>();
            String billtypeId = null;
            BillTypeInfo typeInfo = null;
            for (j = 0; j < entryColl.size(); ++j) {
                OtherBillentryInfo entryInfo = entryColl.get(j);
                BillTypeInfo billtypeInfo = entryInfo.getCoreBillType();
                if (billtypeInfo == null || billtypeInfo.getId() == null) continue;
                billtypeId = billtypeInfo.getId().toString();
                if (!typeMap.containsKey(billtypeId)) {
                    typeInfo = billype.getBillTypeInfo("select headTable,entryTable where id = '" + billtypeId + "'");
                    typeMap.put(billtypeId, typeInfo);
                } else {
                    typeInfo = (BillTypeInfo)typeMap.get(billtypeId);
                }
                String headTable = typeInfo.getHeadTable();
                String entryTable = typeInfo.getEntryTable();
                sqljdtz.setLength(0);
                BigDecimal value = entryInfo.getRecievePayAmount();
                if (value == null) {
                    value = this.ZERO;
                }
                boolean isNegative = value.compareTo(this.ZERO) < 0;
                String entryId = entryInfo.getCoreBillEntryId();
                if ("T_SD_SaleOrder".equals(headTable) && "T_SD_SaleOrderEntry".equals(entryTable)) {
                    if (isNegative) {
                        sqljdtz.append("update T_SD_SaleOrderEntry AS soe set ftotalArAmount = ftotalArAmount + " + value.abs() + " where fid= '" + entryId + "'");
                    } else {
                        sqljdtz.append("update T_SD_SaleOrderEntry AS soe set ftotalArAmount = ftotalArAmount - " + value + " where fid= '" + entryId + "'");
                    }
                    sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleOrder so, T_AR_OTHERBILL ar");
                    sqljdtz.append(" WHERE ((so.FIsCentralBalance = 1 AND so.FCompanyOrgUnitID = ar.FCompanyID)");
                    sqljdtz.append(" OR (so.FIsCentralBalance = 0 AND soe.FCompanyOrgUnitID = ar.FCompanyID))");
                    sqljdtz.append(" AND so.FID = soe.FParentID");
                    sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                    list.add(sqljdtz.toString());
                    continue;
                }
                if ("T_SD_SaleReturns".equals(headTable) && "T_SD_SaleReturnsEntry".equals(entryTable)) {
                    if (isNegative) {
                        sqljdtz.append("update T_SD_SaleReturnsEntry AS sre set finvoicePrice = finvoicePrice - " + value.abs() + " where fid= '" + entryId + "'");
                    } else {
                        sqljdtz.append("update T_SD_SaleReturnsEntry AS sre set finvoicePrice = finvoicePrice + " + value + " where fid= '" + entryId + "'");
                    }
                    sqljdtz.append(" AND EXISTS (SELECT 1 FROM T_SD_SaleReturns sr, T_AR_OTHERBILL ar");
                    sqljdtz.append(" WHERE ((sr.FIsCentralBalance = 1 AND sr.FCompanyOrgUnitID = ar.FCompanyID)");
                    sqljdtz.append(" OR (sr.FIsCentralBalance = 0 AND sre.FCompanyOrgUnitID = ar.FCompanyID))");
                    sqljdtz.append(" AND sr.FID = sre.FParentID");
                    sqljdtz.append(" AND ar.FID = '").append(pk.toString()).append("')");
                    list.add(sqljdtz.toString());
                    continue;
                }
                if (!"T_IM_TransferOrderBill".equals(headTable) || !"T_IM_TransferOrderBillEntry".equals(entryTable)) continue;
                this.writeBackTransOrderSql(sqljdtz, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, entryInfo.getCoreBillEntryId(), true, value);
                list.add(sqljdtz.toString());
            }
        }
        this.returnBudget(ctx, info, 4);
        OtherBillInfo recycleInfo = null;
        if (info.isIsReverseBill()) {
            recycleInfo = (OtherBillInfo)info.clone();
            String billid = info.getId().toString();
            String sourceBillid = info.getSourceBillId().toString();
            StringBuffer sbsql = new StringBuffer();
            sbsql.append("UPDATE t_ar_otherbill SET FUnVerifyAmount = FAmount, FUnVerifyAmountLocal = FAmountLocal , ");
            sbsql.append("FVerifyAmount = 0, FVerifyAmountLocal = 0 ,FIsReversed=0, FVerifyStatus = ");
            sbsql.append(1);
            sbsql.append(" WHERE fid = '" + sourceBillid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("update t_ar_otherbillentry set FLockVerifyAmt=0,FLockVerifyAmtLocal=0,FVerifyAmount=0, ");
            sbsql.append("FVerifyAmountLocal=0, FLocalWrittenOffAmount = 0,FWrittenOffBaseQty = 0, ");
            sbsql.append("FUnwriteOffBaseQty = FBaseQty, FLocalUnwriteOffAmount = FRecievePayAmountLocal, ");
            sbsql.append("FLockUnVerifyAmt= FRecievePayAmount,FLockUnVerifyAmtLocal = FRecievePayAmountLocal, ");
            sbsql.append("FUnVerifyAmount = FRecievePayAmount,FUnVerifyAmountLocal = FRecievePayAmountLocal ");
            sbsql.append("where fparentid = '" + sourceBillid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("update t_ar_otherbillplan set FVerifyAmount=0,FVerifyAmountLocal=0,FUnVerifyAmount=FRecievePayAmount, FUnVerifyAmountLocal=FRecievePayAmountLocal,");
            sbsql.append("FUnLockAmount=FRecievePayAmount,FUnLockAmountLoc=FRecievePayAmountLocal,FLockAmount=0,FLockAmountLoc=0 ");
            sbsql.append("where fparentid = '" + sourceBillid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("delete from t_ar_otherbillplan where fparentid = '" + billid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("delete from t_ar_otherbillentry where fparentid = '" + billid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("delete from t_ar_otherbill where fid = '" + billid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
            sbsql.append("delete from t_bot_relation where fdestobjectid = '" + billid + "'");
            list.add(sbsql.toString());
            sbsql.setLength(0);
        }
        IObjectPK deleteLogPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_otherbill_delete");
        try {
            HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
            ids.add(pk);
            IRowSet rowSet2 = this.getReversedBizBillByFiBill(ctx, ids, true);
            if (rowSet2.size() > 0) {
                while (rowSet2.next()) {
                    if (rowSet2.getInt("FFiVouchered") != 1) continue;
                    throw new OtherBillBizException(OtherBillBizException.BIZBILLCANNOTREVERSED, new String[]{""});
                }
                rowSet2.beforeFirst();
                this.unReversedBizARAP(ctx, rowSet2, info.getCompany(), true);
                rowSet2.beforeFirst();
                HashSet<String> relationIdSet = new HashSet<String>();
                while (rowSet2.next()) {
                    relationIdSet.add(rowSet2.getString("bizentry.FParentID"));
                    relationIdSet.add(rowSet2.getString("bizentry.FSourceBillID"));
                }
                this.writeUnBizBillModeifyLog(ctx, info, relationIdSet);
            }
            DBUtil.execBatchSql((Context)ctx, list, (boolean)true);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)deleteLogPk);
        if (recycleInfo != null) {
            this.recycleNumber(ctx, (IObjectPK)new ObjectUuidPK(recycleInfo.getId().toString()), recycleInfo, true);
        }
        if (isCanUnAuditSwap) {
            OtherBillSwapHelper.deleteSwapBill(ctx, pk, true);
        }
    }

    @Override
    protected boolean isCoopBillEdit(Context ctx, ArApBillBaseInfo info) {
        return this.getBooleanParamValue(ctx, "AR_COOP_BILL_IS_EDIT");
    }

    private void updateGenCoopBill(Context ctx, String billID) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append("update t_ar_otherbill set FIsGenCoopBill = 0 where fid='").append(billID).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void reverseCoreBill4allowance(Context ctx, com.kingdee.eas.scm.common.BizActionEnum action, ArApBillBaseInfo info) throws EASBizException, BOSException {
        AR2SOWriteBackHandler handler = new AR2SOWriteBackHandler();
        String[] coreBillIds = info.getEntryFieldValues("coreBillId").toArray(new String[0]);
        String[] srcBillIds = info.getEntryFieldValues("sourceBillId").toArray(new String[0]);
        String[][] billids = new String[][]{srcBillIds, coreBillIds};
        handler.handle(ctx, action, new String[]{info.getId().toString()}, billids);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherBillInfo info = (OtherBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompany(), info.getBillDate());
        this.checkSourceCurrency(ctx, info.getEntries(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"AROtherBill", (Locale)ctx.getLocale()));
        if (info.getAsstActID() != null) {
            this.setAsstActNameMultiLang(ctx, info);
        }
        String companyID = info.getCompany() == null ? null : info.getCompany().getId().toString();
        Date billDate = info.getBillDate();
        int size = info.getEntry() != null ? info.getEntry().size() : 0;
        OtherBillentryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            entryInfo.setCompany(companyID);
            entryInfo.setBillDate(billDate);
            if (!info.isIsCoopBuild()) continue;
            entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
            entryInfo.setLocalUnwriteOffAmount(entryInfo.getRecievePayAmountLocal());
            entryInfo.setWittenOffBaseQty(this.ZERO);
            entryInfo.setLocalWrittenOffAmount(this.ZERO);
            if (!StringUtils.isEmpty((String)entryInfo.getRecAsstActID())) continue;
            if (info.getAsstActType() != null) {
                entryInfo.setRecAsstActType(info.getAsstActType());
            }
            if (StringUtils.isEmpty((String)info.getAsstActID())) continue;
            entryInfo.setRecAsstActID(info.getAsstActID());
            entryInfo.setRecAsstActName(info.getAsstActName());
            entryInfo.setRecAsstActNumber(info.getAsstActNumber());
        }
        this.setVerifyStatus(info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    private void setAsstActNameMultiLang(Context ctx, OtherBillInfo info) throws BOSException {
        BOSUuid uuid = BOSUuid.read((String)info.getAsstActID().trim());
        BOSObjectType objType = uuid.getType();
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue ov = dynamicObject.getValue(objType, "select name where id = '" + info.getAsstActID().trim() + "'");
        info.setAsstActName(this.getAsstActName(ov, ArApConstants.L1), ArApConstants.L1);
        info.setAsstActName(this.getAsstActName(ov, ArApConstants.L2), ArApConstants.L2);
        info.setAsstActName(this.getAsstActName(ov, ArApConstants.L3), ArApConstants.L3);
        OtherBillentryCollection entryCol = info.getEntry();
        if (entryCol == null || entryCol.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            if (entryCol.get(i).getRecAsstActID() == null || entryCol.get(i).getRecAsstActID().length() == 0) continue;
            idSet.add(entryCol.get(i).getRecAsstActID());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IObjectCollection collection = dynamicObject.getCollection(objType, view);
        int csize = entryCol.size();
        for (int n = 0; n < csize; ++n) {
            OtherBillentryInfo entryInfo = entryCol.get(n);
            if (entryInfo.getRecAsstActID() != null && entryInfo.getRecAsstActID().length() != 0 && collection.containsKey((Object)BOSUuid.read((String)entryInfo.getRecAsstActID()))) {
                ov = collection.getObject((Object)BOSUuid.read((String)entryInfo.getRecAsstActID()));
                entryInfo.setRecAsstActName(this.getAsstActName(ov, ArApConstants.L1), ArApConstants.L1);
                entryInfo.setRecAsstActName(this.getAsstActName(ov, ArApConstants.L2), ArApConstants.L2);
                entryInfo.setRecAsstActName(this.getAsstActName(ov, ArApConstants.L3), ArApConstants.L3);
            }
            if (entryInfo.getOrderCustomer() != null) {
                if (entryInfo.getOrdCustName() == null) {
                    entryInfo.setOrdCustName(entryInfo.getOrderCustomer().getName());
                }
                if (entryInfo.getOrdCustNumber() == null) {
                    entryInfo.setOrdCustNumber(entryInfo.getOrderCustomer().getNumber());
                }
            }
            if (entryInfo.getServiceCustomer() == null) continue;
            if (entryInfo.getSerCustName() == null) {
                entryInfo.setSerCustName(entryInfo.getServiceCustomer().getName());
            }
            if (entryInfo.getSerCustNumber() != null) continue;
            entryInfo.setSerCustNumber(entryInfo.getServiceCustomer().getNumber());
        }
    }

    private String getAsstActName(IObjectValue ov, Locale locale) {
        if (ov == null) {
            return null;
        }
        return ov.get("name", locale) != null ? ov.get("name", locale).toString() : null;
    }

    @Override
    protected void _createReceivingBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseCollection otherBillCol = this.getBillList(ctx, new String[]{pk.toString()});
        OtherBillInfo otherBillInfo = (OtherBillInfo)otherBillCol.get(0);
        String recBillBosType = new ReceivingBillInfo().getBOSType().toString();
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(otherBillCol, recBillBosType, DefineSysEnum.BTP);
        if (botMappingCollection.size() < 1) {
            throw new OtherBillBizException(OtherBillBizException.NOBOTRULENOTCREATERECBILL);
        }
        BOTMappingInfo botp = ArApBillHelper.getFirstBotpWithSpecifyProp(ctx, botMappingCollection, "company", null, false);
        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = ArApServerUtils.transformForBotpWithMutex(ctx, otherBillCol, recBillBosType, (IObjectPK)new ObjectUuidPK(botp.getId().toString()), true);
        if (result != null) {
            IObjectCollection collection = result.getBills();
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                ReceivingBillInfo recevbillInfo = (ReceivingBillInfo)collection.getObject(i);
                if (recevbillInfo.getCU() == null || !recevbillInfo.getCU().getId().toString().equals(otherBillInfo.getCU().getId().toString())) {
                    recevbillInfo.setCU(otherBillInfo.getCU());
                }
                recevbillInfo.setBillStatus(com.kingdee.eas.fi.cas.BillStatusEnum.SAVE);
                if (null == recevbillInfo.getSourceType()) {
                    recevbillInfo.setSourceType(SourceTypeEnum.AR);
                }
                recevbillInfo.setPaymentType(otherBillInfo.getPaymentType());
                ibtpManager.saveRelations((CoreBillBaseInfo)recevbillInfo, result.getBOTRelationCollection());
            }
        }
    }

    @Override
    protected boolean _doBlankOut(Context ctx, IObjectPK objectPK) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("id"));
        OtherBillInfo billInfo = this.getOtherBillInfo(ctx, objectPK, selector);
        billInfo.setBillStatus(BillStatusEnum.DELETED);
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        iOtherBill.update(objectPK, (CoreBaseInfo)billInfo);
        String fid = "";
        StringBuffer delSB = new StringBuffer();
        delSB.append(" SELECT relation.FID AS FID ");
        delSB.append(" FROM T_BOT_Relation AS relation ");
        delSB.append(" where (relation.FSrcEntityID = 'FC910EF3' or relation.FDestEntityID = 'FC910EF3')");
        delSB.append(" and (relation.FSrcObjectID = '").append(billInfo.getId()).append("' ");
        delSB.append(" or relation.FDestObjectID = '").append(billInfo.getId()).append("') ");
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)delSB.toString());
            while (result.next()) {
                fid = result.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!fid.equals("")) {
            IBOTRelation iRel = BOTRelationFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pkRelation = new ObjectUuidPK(BOSUuid.read((String)fid));
            iRel.delete((IObjectPK)pkRelation);
        }
        return true;
    }

    private void updateInventroy(Context ctx, com.kingdee.eas.scm.common.BizActionEnum bizAction, String billId, String bizTypeId) throws BOSException, EASBizException {
        if ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(billId, bizAction);
        }
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws EASBizException, BOSException {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected IArApBillEntryBase getEntryBizInterface(Context ctx) throws BOSException {
        return OtherBillentryFactory.getLocalInstance(ctx);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK[] pks, CoreBillBaseCollection coreBillCollection) throws BOSException, EASBizException {
        super._unpassAudit(ctx, pks, coreBillCollection);
        IObjectPK[] pkstemp = new IObjectPK[]{};
        WriteBackNetOrderHandleFactory.headHandle((Context)ctx, (String)this.getBOSType().toString(), (com.kingdee.eas.scm.common.BizActionEnum)com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, (IObjectPK[])pkstemp);
    }

    @Override
    protected void _updateNoService(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.innerUpdate(ctx, pk, model);
    }

    public boolean isSameNumberForRec(Context ctx, ReceivingBillInfo recevbillInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)recevbillInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (recevbillInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)recevbillInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (recevbillInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)recevbillInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < filter.getFilterItems().size(); ++j) {
            if (j != 0) {
                sb.append(" and #" + j);
                continue;
            }
            sb.append("#" + j);
        }
        filter.setMaskString(sb.toString());
        IReceivingBill iReceiv = ReceivingBillFactory.getLocalInstance((Context)ctx);
        return iReceiv.exists(filter);
    }

    protected ReceivingBillInfo getNewNumberForRec(Context ctx, ReceivingBillInfo recevbillInfo, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)strCompanyID)) {
            throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
        }
        String number = "";
        number = iCodingRuleManager.getNumber((IObjectValue)recevbillInfo, strCompanyID, customString);
        recevbillInfo.setNumber(number);
        if (this.isSameNumberForRec(ctx, recevbillInfo)) {
            return this.getNewNumberForRec(ctx, recevbillInfo, strCompanyID, customString);
        }
        return recevbillInfo;
    }

    @Override
    protected void _cancelAppointmentVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        OtherBillInfo info = this.getOtherBillInfo(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_otherbill_CancelAppointmentVoucher");
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_UNAUDIT_NOT);
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
        if (info.getBillDate().before(currentPeriod.getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_INITBILL_NOT);
        }
        if (info.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_ARVOUCHER_PERMITOPERATION_NOT);
        }
        if (!info.isIsAppointVoucher()) {
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new OtherBillInfo().getBOSType().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.getId(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            BOTRelationCollection botRelationCollection = iBotRelation.getCollection(view);
            if (botRelationCollection.size() == 1) {
                throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_CREATED_NOT);
            }
        }
        if (!info.isIsAppointVoucher() || info.getVoucher() == null) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELVOUCHER_EXIST_NOT);
        }
        String destObjectId = info.getVoucher().getId().toString();
        String srcObjectId = info.getId().toString();
        FilterInfo filterInfo2 = new FilterInfo();
        IBOTRelation iBOTRelation2 = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelationCollection2 = null;
        EntityViewInfo view2 = new EntityViewInfo();
        view2.getSelector().add(new SelectorItemInfo("id"));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new OtherBillInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view2.setFilter(filterInfo2);
        botRelationCollection2 = iBOTRelation2.getCollection(view2);
        if (botRelationCollection2.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection2.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation2.delete((IObjectPK)pkbot);
        }
        info.setVoucher(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setIsAppointVoucher(false);
        info.setFiVouchered(false);
        info.setAccountant(null);
        this._update(ctx, pk, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _cancelAppointmentAccount(Context ctx, IObjectPK pk, Boolean bizAccountFlag, Boolean oppAccountFlag) throws BOSException, EASBizException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        if (!this._exists(ctx, pk)) {
            throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
        }
        OtherBillInfo info = this.getOtherBillInfo(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"ar_otherbill_CancelAppointmentSubject");
        if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELSUBJECT_UNAUDIT_NOT);
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
        if (info.getBillDate().before(currentPeriod.getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.POINT_CANCELSUBJECT_INITBILL_NOT);
        }
        if (info.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_ARSUBJECT_PERMITOPERATION_NOT);
        }
        AbstractObjectCollection arApEntryCol = info.getEntries();
        ArApBillEntryBaseInfo arApEntry2 = null;
        for (ArApBillEntryBaseInfo arApEntry2 : arApEntryCol) {
            if (bizAccountFlag.booleanValue()) {
                arApEntry2.setAccount(null);
            }
            if (oppAccountFlag.booleanValue()) {
                arApEntry2.setOppAccount(null);
            }
            ArApServerUtils.appointmentAccount4Verify(ctx, arApEntry2.getId().toString(), arApEntry2.getAccount(), arApEntry2.getOppAccount(), currentPeriod);
        }
        this._update(ctx, pk, (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected HashMap _appointmentAccount(Context ctx, IObjectPK[] pk, AccountViewInfo accountViewInfo, AccountViewInfo oppAccountInfo) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
        if (pk == null || pk.length == 0) {
            return hashMap;
        }
        ObjectUuidPK opk = new ObjectUuidPK(pk[0].toString());
        BOSObjectType bosType = opk.getObjectType();
        String bostypeStr = bosType.toString();
        StringBuffer strBuf = new StringBuffer();
        int j = pk.length - 1;
        for (int i = 0; i <= j; ++i) {
            strBuf.append("'").append(pk[i].toString()).append("'");
            if (i == j) continue;
            strBuf.append(",");
        }
        if ("FC910EF3".equals(bostypeStr)) {
            AbstractObjectCollection arApEntryCol = null;
            ArApBillEntryBaseInfo arApEntry2 = null;
            OtherBillInfo otherBillInfo = null;
            OtherBillCollection otherColl = this.getOtherBillCollection(ctx, "where id in (" + strBuf.toString() + ")");
            PeriodInfo currentPeriod = null;
            for (int i = 0; i < pk.length; ++i) {
                otherBillInfo = otherColl.get(i);
                IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)otherBillInfo.getBOSType(), null, (String)otherBillInfo.getNumber(), (String)this.LOG_ITEM_APPOINTMENT_SUBJECT);
                if (!otherBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                    throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_UNAUDIT_NOT);
                }
                if (currentPeriod == null) {
                    currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, otherBillInfo.getCompany());
                }
                if (otherBillInfo.getBillDate().before(currentPeriod.getBeginDate())) {
                    throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT);
                }
                if (otherBillInfo.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
                    throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_ARPROXYBILL_NOT);
                }
                arApEntryCol = otherBillInfo.getEntries();
                for (ArApBillEntryBaseInfo arApEntry2 : arApEntryCol) {
                    if (accountViewInfo != null && accountViewInfo.getId() != null) {
                        arApEntry2.setAccount(accountViewInfo);
                    }
                    if (oppAccountInfo == null || oppAccountInfo.getId() == null) continue;
                    arApEntry2.setOppAccount(oppAccountInfo);
                }
                if (arApEntry2 != null) {
                    ArApServerUtils.appointmentAccount4Verify(ctx, arApEntry2.getId().toString(), arApEntry2.getAccount(), arApEntry2.getOppAccount(), currentPeriod);
                }
                this._update(ctx, (IObjectPK)new ObjectUuidPK(otherBillInfo.getId()), (IObjectValue)otherBillInfo);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
        } else {
            String ids = ArrayUtil.getStringFromArr((Object[])pk);
            HashSet<String> set = new HashSet<String>();
            int size = pk.length;
            for (int i = 0; i < size; ++i) {
                set.add(pk[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("seq");
            sic.add("head.id");
            sic.add("head.number");
            sic.add("head.billDate");
            sic.add("head.billStatus");
            sic.add("head.company.id");
            sic.add("head.sourceBillType");
            sic.add("account");
            sic.add("oppAccount");
            view.setSelector(sic);
            OtherBillentryCollection col = OtherBillentryFactory.getLocalInstance(ctx).getOtherBillentryCollection(view);
            HashSet<String> numberSet = new HashSet<String>(col.size());
            ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>(col.size());
            if (col != null && col.size() > 0) {
                OtherBillentryInfo entry = null;
                OtherBillInfo info = null;
                PeriodInfo currentPeriod = null;
                int size2 = col.size();
                for (int i = 0; i < size2; ++i) {
                    entry = col.get(0);
                    info = entry.getHead();
                    if (!numberSet.contains(info.getNumber())) {
                        numberSet.add(info.getNumber());
                        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)this.LOG_ITEM_APPOINTMENT_SUBJECT);
                        logPks.add(logPK);
                    }
                    if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                        throw new OtherBillBizException(OtherBillBizException.ENTRY_POINT_SUBJECT_UNAUDIT_NOT, new Object[]{info.getNumber(), entry.getSeq()});
                    }
                    if (currentPeriod == null) {
                        currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, info.getCompany());
                    }
                    if (info.getBillDate().before(currentPeriod.getBeginDate())) {
                        throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT_1, new Object[]{info.getNumber(), entry.getSeq()});
                    }
                    if (info.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
                        throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_ARPROXYBILL_NOT_1, new Object[]{info.getNumber(), entry.getSeq()});
                    }
                    if (accountViewInfo != null && accountViewInfo.getId() != null) {
                        entry.setAccount(accountViewInfo);
                    }
                    if (oppAccountInfo != null && oppAccountInfo.getId() != null) {
                        entry.setOppAccount(oppAccountInfo);
                    }
                    ArApServerUtils.appointmentAccount4Verify(ctx, entry.getId().toString(), entry.getAccount(), entry.getOppAccount(), currentPeriod);
                }
            }
            StringBuilder sql = new StringBuilder(300);
            sql.append("update t_ar_otherbillentry ");
            if (accountViewInfo != null && oppAccountInfo != null && accountViewInfo.getId() != null && oppAccountInfo.getId() != null) {
                sql.append("set FAccountID='" + accountViewInfo.getId().toString() + "',FOppAccountID='" + oppAccountInfo.getId().toString());
            } else if (accountViewInfo != null && accountViewInfo.getId() != null) {
                sql.append("set FAccountID='" + accountViewInfo.getId().toString());
            } else if (oppAccountInfo != null && oppAccountInfo.getId() != null) {
                sql.append("set FOppAccountID='" + oppAccountInfo.getId().toString());
            }
            sql.append("' where fid in (" + ids + ")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            for (int i = 0; i < logPks.size(); ++i) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)((IObjectPK)logPks.get(i)));
            }
        }
        hashMap.put("Msg", sb);
        return hashMap;
    }

    @Override
    protected HashMap _checkAppointmentAccount(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
        CurrencyInfo tmpCurrencyInfo = null;
        OtherBillInfo otherBillInfo = null;
        StringBuffer strBuf = new StringBuffer();
        int j = pk.length - 1;
        for (int i = 0; i <= j; ++i) {
            strBuf.append("'").append(pk[i].toString()).append("'");
            if (i == j) continue;
            strBuf.append(",");
        }
        OtherBillCollection otherColl = this.getOtherBillCollection(ctx, "where id in (" + strBuf.toString() + ")");
        for (int i = 0; i < pk.length; ++i) {
            otherBillInfo = otherColl.get(i);
            try {
                CurrencyInfo currencyInfo = otherBillInfo.getCurrency();
                if (i == 0) {
                    tmpCurrencyInfo = currencyInfo;
                }
                this.verifyBill(ctx, tmpCurrencyInfo, i, otherBillInfo);
                continue;
            }
            catch (Exception e) {
                sb.append(otherBillInfo.getNumber());
                sb.append(e.getMessage() + "\r\n");
            }
        }
        hashMap.put("Msg", sb);
        hashMap.put("tmpCurrencyInfo", (StringBuffer)tmpCurrencyInfo);
        return hashMap;
    }

    private void verifyBill(Context ctx, CurrencyInfo tmpCurrencyInfo, int i, OtherBillInfo otherBillInfo) throws OtherBillBizException, BOSException, EASBizException {
        if (!otherBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_UNAUDIT_NOT);
        }
        PeriodInfo currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, otherBillInfo.getCompany());
        if (otherBillInfo.getBillDate().before(currentPeriod.getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT);
        }
        CurrencyInfo currencyInfo = otherBillInfo.getCurrency();
        if (tmpCurrencyInfo == null || !tmpCurrencyInfo.getId().equals((Object)currencyInfo.getId())) {
            throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_DIFCURRENCY_NOT);
        }
    }

    @Override
    protected void _splitBill(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        OtherBillInfo otherBillInfo = null;
        OtherBillInfo motherBillInfo = null;
        OtherBillInfo childBillInfo = null;
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("*"));
        selectorColl.add(new SelectorItemInfo("entry.*"));
        selectorColl.add(new SelectorItemInfo("entry.material.id"));
        selectorColl.add(new SelectorItemInfo("entry.material.pricePrecision"));
        selectorColl.add(new SelectorItemInfo("entry.assistUnit.id"));
        selectorColl.add(new SelectorItemInfo("entry.assistUnit.qtyPrecision"));
        selectorColl.add(new SelectorItemInfo("recievePlan.*"));
        otherBillInfo = this.getOtherBillInfo(ctx, billId, selectorColl);
        this.canSplit(ctx, otherBillInfo);
        motherBillInfo = (OtherBillInfo)otherBillInfo.clone();
        childBillInfo = (OtherBillInfo)otherBillInfo.clone();
        String childNumber = this.getChildNumber(ctx, motherBillInfo.getNumber(), 1);
        childBillInfo.setId(null);
        childBillInfo.setCreateTime(null);
        childBillInfo.setCreator(null);
        childBillInfo.setAuditor(null);
        childBillInfo.setAuditDate(null);
        childBillInfo.setNumber(childNumber);
        OtherBillentryCollection motherEntryCollection = motherBillInfo.getEntry();
        OtherBillentryCollection childEntryCollection = childBillInfo.getEntry();
        OtherBillentryCollection otherEntryCollection = otherBillInfo.getEntry();
        OtherBillentryInfo motherEntryInfo = null;
        OtherBillentryInfo childEntryInfo = null;
        OtherBillentryInfo otherEntryInfo = null;
        HashSet<String> assistUnitIDSet = new HashSet<String>();
        HashSet<String> materialIDSet = new HashSet<String>();
        int k = motherEntryCollection.size();
        for (int j = 0; j < k; ++j) {
            motherEntryInfo = motherEntryCollection.get(j);
            childEntryInfo = childEntryCollection.get(j);
            childEntryInfo.setId(null);
            childEntryInfo.setHead(null);
            this.splitBillEntry(ctx, motherEntryInfo, childEntryInfo, otherBillInfo);
            if (motherEntryInfo.getAssistUnit() != null) {
                assistUnitIDSet.add(motherEntryInfo.getAssistUnit().getId().toString());
            }
            if (motherEntryInfo.getMaterial() == null) continue;
            materialIDSet.add(motherEntryInfo.getMaterial().getId().toString());
        }
        motherBillInfo.setIsSplitBill(true);
        motherBillInfo.setAmountLocal(this.ZERO);
        ArApBillHelper.calculate(ctx, motherBillInfo, null);
        HashMap<String, Integer> assistUnitQtyPrecision = new HashMap<String, Integer>();
        String key = null;
        if (assistUnitIDSet.size() > 0 && materialIDSet.size() > 0) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("material.id"));
            view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
            view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", assistUnitIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MultiMeasureUnitCollection multiUnitColl = multiUnit.getMultiMeasureUnitCollection(view);
            int size = multiUnitColl.size();
            for (int i = 0; i < size; ++i) {
                key = multiUnitColl.get(i).getMaterial().getId().toString() + multiUnitColl.get(i).getMeasureUnit().getId().toString();
                if (assistUnitQtyPrecision.containsKey(key)) continue;
                assistUnitQtyPrecision.put(key, multiUnitColl.get(i).getQtyPrecision());
            }
        }
        MaterialInfo materialInfo = null;
        MeasureUnitInfo assistUnitInfo = null;
        int k2 = motherEntryCollection.size();
        for (int j = 0; j < k2; ++j) {
            motherEntryInfo = motherEntryCollection.get(j);
            childEntryInfo = childEntryCollection.get(j);
            otherEntryInfo = otherEntryCollection.get(j);
            materialInfo = otherEntryInfo.getMaterial();
            assistUnitInfo = otherEntryInfo.getAssistUnit();
            childEntryInfo.setQuantity(otherEntryInfo.getQuantity().subtract(motherEntryInfo.getQuantity()));
            childEntryInfo.setBaseQty(otherEntryInfo.getBaseQty().subtract(motherEntryInfo.getBaseQty()));
            childEntryInfo.setUnInvoiceReqQty(childEntryInfo.getQuantity());
            if (materialInfo != null && assistUnitInfo != null) {
                if (otherEntryInfo.getQuantity().compareTo(this.ZERO) != 0) {
                    key = materialInfo.getId().toString() + assistUnitInfo.getId().toString();
                    motherEntryInfo.setAssistQty(motherEntryInfo.getQuantity().multiply(otherEntryInfo.getAssistQty()).divide(otherEntryInfo.getQuantity(), assistUnitQtyPrecision.get(key) == null ? 10 : Integer.parseInt(assistUnitQtyPrecision.get(key).toString()), 4));
                    childEntryInfo.setAssistQty(otherEntryInfo.getAssistQty().subtract(motherEntryInfo.getAssistQty()));
                } else {
                    childEntryInfo.setAssistQty(this.ZERO);
                }
            }
            childEntryInfo.setAmount(otherEntryInfo.getAmount().subtract(motherEntryInfo.getAmount()));
            childEntryInfo.setAmountLocal(otherEntryInfo.getAmountLocal().subtract(motherEntryInfo.getAmountLocal()));
            childEntryInfo.setRecievePayAmount(otherEntryInfo.getRecievePayAmount().subtract(motherEntryInfo.getRecievePayAmount()));
            childEntryInfo.setRecievePayAmountLocal(otherEntryInfo.getRecievePayAmountLocal().subtract(motherEntryInfo.getRecievePayAmountLocal()));
            childEntryInfo.setDiscountAmount(otherEntryInfo.getDiscountAmount().subtract(motherEntryInfo.getDiscountAmount()));
            childEntryInfo.setDiscountAmountLocal(otherEntryInfo.getDiscountAmountLocal().subtract(motherEntryInfo.getDiscountAmountLocal()));
            childEntryInfo.setTaxAmount(otherEntryInfo.getTaxAmount().subtract(motherEntryInfo.getTaxAmount()));
            childEntryInfo.setTaxAmountLocal(otherEntryInfo.getTaxAmountLocal().subtract(motherEntryInfo.getTaxAmountLocal()));
            childEntryInfo.setVerifyAmount(otherEntryInfo.getVerifyAmount().subtract(motherEntryInfo.getVerifyAmount()));
            childEntryInfo.setVerifyAmountLocal(otherEntryInfo.getVerifyAmountLocal().subtract(motherEntryInfo.getVerifyAmountLocal()));
            childEntryInfo.setUnVerifyAmount(otherEntryInfo.getUnVerifyAmount().subtract(motherEntryInfo.getUnVerifyAmount()));
            childEntryInfo.setUnVerifyAmountLocal(otherEntryInfo.getUnVerifyAmountLocal().subtract(motherEntryInfo.getUnVerifyAmountLocal()));
            childEntryInfo.setHisUnVerifyAmount(otherEntryInfo.getHisUnVerifyAmount().subtract(motherEntryInfo.getHisUnVerifyAmount()));
            childEntryInfo.setHisUnVerifyAmountLocal(otherEntryInfo.getHisUnVerifyAmountLocal().subtract(motherEntryInfo.getHisUnVerifyAmountLocal()));
            childEntryInfo.setLockUnVerifyAmt(otherEntryInfo.getLockUnVerifyAmt().subtract(motherEntryInfo.getLockUnVerifyAmt()));
            childEntryInfo.setLockUnVerifyAmtLocal(otherEntryInfo.getLockUnVerifyAmtLocal().subtract(motherEntryInfo.getLockUnVerifyAmtLocal()));
            childEntryInfo.setInvoiceReqQty(this.ZERO);
            childEntryInfo.setInvoiceReqBaseQty(this.ZERO);
            childEntryInfo.setUnInvoiceReqQty(childEntryInfo.getQuantity());
            childEntryInfo.setUnInvoiceReqBaseQty(childEntryInfo.getBaseQty());
            childEntryInfo.setInvoiceReqAmount(this.ZERO);
            childEntryInfo.setInvoiceReqAmountLocal(this.ZERO);
            childEntryInfo.setUnInvoiceReqAmount(childEntryInfo.getRecievePayAmount());
            childEntryInfo.setUnInvoiceReqAmountLocal(childEntryInfo.getRecievePayAmountLocal());
            if (childEntryInfo.isIsPresent() || childEntryInfo.getQuantity().compareTo(this.ZERO) == 0) continue;
            childEntryInfo.setRealPrice(childEntryInfo.getAmount().divide(childEntryInfo.getQuantity(), materialInfo == null ? 6 : materialInfo.getPricePrecision(), 4));
            childEntryInfo.setActualPrice(childEntryInfo.getRecievePayAmount().divide(childEntryInfo.getQuantity(), materialInfo == null ? 6 : materialInfo.getPricePrecision(), 4));
        }
        childBillInfo.sumEntry();
        OtherBillPlanCollection motherPlanCollection = motherBillInfo.getRecievePlan();
        OtherBillPlanCollection childPlanCollection = childBillInfo.getRecievePlan();
        OtherBillPlanCollection otherPlanCollection = otherBillInfo.getRecievePlan();
        OtherBillPlanInfo motherPlanInfo = null;
        OtherBillPlanInfo childPlanInfo = null;
        OtherBillPlanInfo otherPlanInfo = null;
        BigDecimal recieveAmount = new BigDecimal("0.00");
        BigDecimal recieveAmountLocal = new BigDecimal("0.00");
        boolean splitFlag = false;
        boolean isPositiveNum = false;
        boolean isNegativeNum = false;
        OtherBillPlanInfo planInfo = null;
        Iterator otherIterator = otherPlanCollection.iterator();
        while (otherIterator.hasNext()) {
            planInfo = (OtherBillPlanInfo)otherIterator.next();
            if (planInfo.getRecievePayAmountLocal().compareTo(this.ZERO) > 0) {
                isPositiveNum = true;
                continue;
            }
            isNegativeNum = true;
        }
        int k3 = otherPlanCollection.size();
        for (int j = 0; j < k3; ++j) {
            motherPlanInfo = motherPlanCollection.get(j);
            childPlanInfo = childPlanCollection.get(j);
            if (splitFlag) {
                motherPlanInfo.setId(null);
                childPlanInfo.setId(null);
                childPlanInfo.setParent(null);
                continue;
            }
            otherPlanInfo = otherPlanCollection.get(j);
            recieveAmount = recieveAmount.add(otherPlanInfo.getRecievePayAmount());
            recieveAmountLocal = recieveAmountLocal.add(otherPlanInfo.getRecievePayAmountLocal());
            if ((!isPositiveNum || isNegativeNum || motherBillInfo.getAmountLocal().compareTo(recieveAmountLocal) > 0) && (isPositiveNum || !isNegativeNum || motherBillInfo.getAmountLocal().compareTo(recieveAmountLocal) < 0)) continue;
            childPlanInfo.setRecievePayAmount(recieveAmount.subtract(motherBillInfo.getAmount()));
            childPlanInfo.setRecievePayAmountLocal(recieveAmountLocal.subtract(motherBillInfo.getAmountLocal()));
            if (childPlanInfo.getRecievePayAmountLocal().compareTo(this.ZERO) != 0) {
                childPlanInfo.setId(null);
                childPlanInfo.setParent(null);
            }
            motherPlanInfo.setRecievePayAmount(otherPlanInfo.getRecievePayAmount().subtract(childPlanInfo.getRecievePayAmount()));
            motherPlanInfo.setRecievePayAmountLocal(otherPlanInfo.getRecievePayAmountLocal().subtract(childPlanInfo.getRecievePayAmountLocal()));
            splitFlag = true;
        }
        Iterator motherIterator = motherPlanCollection.iterator();
        while (motherIterator.hasNext()) {
            planInfo = (OtherBillPlanInfo)motherIterator.next();
            if ((!isPositiveNum || !isNegativeNum) && planInfo.getId() != null) continue;
            motherIterator.remove();
        }
        Iterator childIterator = childPlanCollection.iterator();
        while (childIterator.hasNext()) {
            planInfo = (OtherBillPlanInfo)childIterator.next();
            if ((!isPositiveNum || !isNegativeNum) && planInfo.getId() == null) continue;
            childIterator.remove();
        }
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
            if (motherPlanCollection.size() == 0 && childPlanCollection.size() == 0) {
                planInfo = otherPlanCollection.get(0);
                motherPlanInfo = new OtherBillPlanInfo();
                motherPlanInfo.setRecievePayDate(planInfo.getRecievePayDate());
                motherPlanInfo.setRecievePayAmountLocal(motherBillInfo.getAmountLocal());
                motherPlanInfo.setRecievePayAmount(motherBillInfo.getAmount());
                motherPlanCollection.add(motherPlanInfo);
                childPlanInfo = new OtherBillPlanInfo();
                childPlanInfo.setRecievePayDate(planInfo.getRecievePayDate());
                childPlanInfo.setRecievePayAmountLocal(childBillInfo.getAmountLocal());
                childPlanInfo.setRecievePayAmount(childBillInfo.getAmount());
                childPlanCollection.add(childPlanInfo);
            }
        } else if (OtherBillTypeEnum.ExpenseInvoice.equals((Object)otherBillInfo.getBillType()) && childPlanCollection.size() == 0) {
            motherIterator = motherPlanCollection.iterator();
            while (motherIterator.hasNext()) {
                planInfo = (OtherBillPlanInfo)motherIterator.next();
                planInfo.setId(null);
                planInfo.setParent(null);
                childPlanCollection.add(planInfo);
            }
        }
        ObjectUuidPK motherBillPK = new ObjectUuidPK(motherBillInfo.getId());
        childBillInfo.setIsSplitBill(true);
        childBillInfo.setReqCalculate4Srv(false);
        OtherBillentryInfo entryInfo = null;
        Iterator childIterator2 = childEntryCollection.iterator();
        while (childIterator2.hasNext()) {
            entryInfo = (OtherBillentryInfo)childIterator2.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            entryInfo.setBaseQty(this.ONE);
        }
        IObjectPK newPK = super._submit(ctx, (IObjectValue)childBillInfo);
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("destEntityID", (Object)this.getBOSType().toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("destObjectID", (Object)motherBillPK.toString());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            ev.setFilter(filter);
            BOTRelationCollection botRelationCol = iBOTRelation.getCollection(ev);
            String bosType = new OtherBillInfo().getBOSType().toString();
            int k4 = botRelationCol.size();
            for (int j = 0; j < k4; ++j) {
                BOTRelationInfo botRelationInfo = botRelationCol.get(j);
                BOTRelationInfo childRelationInfo = new BOTRelationInfo();
                childRelationInfo.setSrcObjectID(botRelationInfo.getSrcObjectID());
                childRelationInfo.setDestEntityID(bosType);
                childRelationInfo.setSrcEntityID(botRelationInfo.getSrcEntityID());
                childRelationInfo.setDestObjectID(newPK.toString());
                childRelationInfo.setOperatorID("unknown");
                childRelationInfo.setType(0);
                iBOTRelation.addnew(childRelationInfo);
            }
        }
        Iterator motherIterator2 = motherEntryCollection.iterator();
        while (motherIterator2.hasNext()) {
            entryInfo = (OtherBillentryInfo)motherIterator2.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            motherIterator2.remove();
        }
        Iterator childIterator3 = childEntryCollection.iterator();
        while (childIterator3.hasNext()) {
            entryInfo = (OtherBillentryInfo)childIterator3.next();
            if (entryInfo.getQuantity().compareTo(this.ZERO) != 0) continue;
            childIterator3.remove();
        }
        super.innerUpdate(ctx, (IObjectPK)motherBillPK, (IObjectValue)motherBillInfo);
        childBillInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
        childBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        childBillInfo.setBillStatus(BillStatusEnum.AUDITED);
        super._update(ctx, newPK, (IObjectValue)childBillInfo);
        DbUtil.execute((Context)ctx, (String)"update t_ar_otherbill set flastupdatetime = null, flastupdateuserid = null where fid = ?", (Object[])new Object[]{newPK.toString()});
    }

    private void canSplit(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        if (!BillStatusEnum.AUDITED.equals((Object)otherBillInfo.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
        if (otherBillInfo.isIsBizBill()) {
            throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
        }
        if ("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(otherBillInfo.getPaymentType().getId().toString())) {
            throw new OtherBillBizException(OtherBillBizException.CASHSALE_FORBIDDEN);
        }
        if (otherBillInfo.isFiVouchered()) {
            throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
        }
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType()) && VerificateBillTypeEnum.ArAgentBizBill.equals((Object)otherBillInfo.getSourceBillType())) {
            throw new OtherBillBizException(OtherBillBizException.VERIFICATEBILLTYPE_ISAGENT);
        }
        if (OtherBillTypeEnum.OtherReceivable.equals((Object)otherBillInfo.getBillType())) {
            throw new OtherBillBizException(OtherBillBizException.BILLTYPE_ISOTHER);
        }
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
            throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTCANNOT);
        }
        if (otherBillInfo.getLockAmt().compareTo(this.ZERO) != 0) {
            throw new OtherBillBizException(OtherBillBizException.LOCKAMT_NOTZERO);
        }
        CompanyOrgUnitInfo currentCompany = otherBillInfo.getCompany();
        SystemStatusCtrolInfo arapStatus = CommonServerUtils.getSysStatusCtrolInfo(ctx, currentCompany, this._getOwnedSys(ctx));
        if (otherBillInfo.getBillDate().before(arapStatus.getCurrentPeriod().getBeginDate())) {
            throw new OtherBillBizException(OtherBillBizException.BILLDATEBEFORECURRENTPERIOD);
        }
        BigDecimal sumLocalWrittenOffAmount = new BigDecimal("0.00");
        BigDecimal sumLocalUnwriteOffAmount = new BigDecimal("0.00");
        BigDecimal sumApportionAmtLocal = new BigDecimal("0.00");
        BigDecimal sumRecievePayAmountLocal = new BigDecimal("0.00");
        OtherBillentryCollection entryCol = otherBillInfo.getEntry();
        for (int j = 0; j < entryCol.size(); ++j) {
            OtherBillentryInfo entryInfo = entryCol.get(j);
            if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
                sumLocalWrittenOffAmount = sumLocalWrittenOffAmount.add(entryInfo.getLocalWrittenOffAmount());
                sumLocalUnwriteOffAmount = sumLocalUnwriteOffAmount.add(entryInfo.getLocalUnwriteOffAmount());
                if (entryInfo.getInvoiceNumber() == null && entryInfo.getInvoicedAmt().compareTo(this.ZERO) == 0) continue;
                throw new OtherBillBizException(OtherBillBizException.ENTRY_ISINVOICED);
            }
            if (!OtherBillTypeEnum.ExpenseInvoice.equals((Object)otherBillInfo.getBillType())) continue;
            sumApportionAmtLocal = sumApportionAmtLocal.add(entryInfo.getApportionAmtLocal() == null ? this.ZERO : entryInfo.getApportionAmtLocal());
            sumRecievePayAmountLocal = sumRecievePayAmountLocal.add(entryInfo.getRecievePayAmountLocal());
        }
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType()) && (otherBillInfo.isIsInvoiced() || otherBillInfo.isIsMakeInvoiced() || otherBillInfo.isInvoiceReq())) {
            throw new OtherBillBizException(OtherBillBizException.HASDESTBILL);
        }
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType()) && (sumLocalWrittenOffAmount.compareTo(this.ZERO) == 0 || sumLocalUnwriteOffAmount.compareTo(this.ZERO) == 0)) {
            throw new OtherBillBizException(OtherBillBizException.ENTRY_NOTPARTWRITTENOFF);
        }
        if (OtherBillTypeEnum.ExpenseInvoice.equals((Object)otherBillInfo.getBillType()) && (sumApportionAmtLocal.compareTo(this.ZERO) == 0 || sumApportionAmtLocal.compareTo(sumRecievePayAmountLocal) >= 0)) {
            throw new OtherBillBizException(OtherBillBizException.ENTRY_NOTPARTAPPORTION);
        }
    }

    private String getChildNumber(Context ctx, String number, int n) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("00");
        sb.append(String.valueOf(n));
        if (sb.length() > 3) {
            sb.delete(0, sb.length() - 3);
        }
        String childNumber = number + sb.toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)childNumber));
        if (this.exists(ctx, filter)) {
            return this.getChildNumber(ctx, number, n + 1);
        }
        return childNumber;
    }

    private void splitBillEntry(Context ctx, OtherBillentryInfo motherEntryInfo, OtherBillentryInfo childEntryInfo, OtherBillInfo otherBillInfo) throws EASBizException, BOSException {
        OtherBillentryInfo cloneMotherEntryInfo = (OtherBillentryInfo)motherEntryInfo.clone();
        if (OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType())) {
            motherEntryInfo.setBaseQty(cloneMotherEntryInfo.getWittenOffBaseQty());
            childEntryInfo.setBaseQty(cloneMotherEntryInfo.getUnwriteOffBaseQty());
            motherEntryInfo.setWittenOffBaseQty(cloneMotherEntryInfo.getWittenOffBaseQty());
            motherEntryInfo.setUnwriteOffBaseQty(this.ZERO);
            childEntryInfo.setWittenOffBaseQty(this.ZERO);
            childEntryInfo.setUnwriteOffBaseQty(cloneMotherEntryInfo.getUnwriteOffBaseQty());
            motherEntryInfo.setLocalWrittenOffAmount(cloneMotherEntryInfo.getLocalWrittenOffAmount());
            motherEntryInfo.setLocalUnwriteOffAmount(this.ZERO);
            childEntryInfo.setLocalWrittenOffAmount(this.ZERO);
            childEntryInfo.setLocalUnwriteOffAmount(cloneMotherEntryInfo.getLocalUnwriteOffAmount());
            motherEntryInfo.setAmountLocal(cloneMotherEntryInfo.getLocalWrittenOffAmount());
        } else if (OtherBillTypeEnum.ExpenseInvoice.equals((Object)otherBillInfo.getBillType())) {
            motherEntryInfo.setApportionAmtLocal(cloneMotherEntryInfo.getApportionAmtLocal());
            childEntryInfo.setApportionAmtLocal(this.ZERO);
            if (cloneMotherEntryInfo.getQuantity().compareTo(this.ONE) != 0) {
                motherEntryInfo.setLocalUnwriteOffAmount(cloneMotherEntryInfo.getApportionAmtLocal());
                childEntryInfo.setLocalUnwriteOffAmount(cloneMotherEntryInfo.getAmountLocal().subtract(motherEntryInfo.getLocalUnwriteOffAmount()));
                motherEntryInfo.setRecievePayAmountLocal(motherEntryInfo.getLocalWrittenOffAmount());
                if (cloneMotherEntryInfo.getAmountLocal().compareTo(this.ZERO) != 0) {
                    motherEntryInfo.setQuantity(motherEntryInfo.getApportionAmtLocal().multiply(cloneMotherEntryInfo.getQuantity()).divide(cloneMotherEntryInfo.getAmountLocal(), 10, 4));
                    childEntryInfo.setQuantity(cloneMotherEntryInfo.getQuantity().subtract(motherEntryInfo.getQuantity()));
                }
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface(Context ctx) throws BOSException {
        return OtherBillFactory.getLocalInstance(ctx);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue objectValue = collection.getObject(i);
            if (!(objectValue instanceof OtherBillInfo)) continue;
            OtherBillInfo otherBillInfo = (OtherBillInfo)objectValue;
            this._handleAfterTransform(ctx, action, (IObjectValue)otherBillInfo);
        }
    }

    private void setDefaultCustomerTaxInfo(Context ctx, OtherBillInfo info) throws EASBizException, BOSException {
        boolean isDefault;
        IObjectCollection col;
        IObjectValue customerTaxInfo;
        AsstActTypeInfo asstActTypeInfo = info.getAsstActType();
        if ("T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject()) && (customerTaxInfo = MakeInvoiceUtils.getDefaultCustomerTaxInfo(ctx, info.getAsstActID(), null, info.getCompany().getId().toString())) != null && (col = (IObjectCollection)customerTaxInfo.get("entries")).size() != 0 && (isDefault = ((Boolean)col.getObject(0).get("isDefault")).booleanValue())) {
            info.setComInvoiceName((String)customerTaxInfo.get("recCompanyName"));
            info.setTaxNo((String)customerTaxInfo.get("taxNumber"));
            info.setAddressAndTel((String)customerTaxInfo.get("addressTel"));
            info.setOBankAndAcountNum((String)customerTaxInfo.get("bankAccount"));
            if (info.getInvoiceType() == null || PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)info.getInvoiceType())) {
                info.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)((String)col.getObject(0).get("invoiceType"))));
            }
        }
    }

    private IObjectValue setDefaultCustomerMailInfo(Context ctx, OtherBillInfo info) throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comOrgUnitId", info.getCompany().getId().toString());
        param.put("customerId", info.getAsstActID());
        IObjectValue defaultEntry = MakeInvoiceUtils.getDefaultCustomerMailInfo(ctx, param);
        if (defaultEntry != null) {
            info.setDisInvoicer((String)defaultEntry.get("contacts"));
            info.setRecBillAdress((String)defaultEntry.get("address"));
            info.setRecBillEmail((String)defaultEntry.get("mailbox"));
            info.setRecBillComName((String)defaultEntry.get("companyName"));
            info.setMailNumber((String)defaultEntry.get("postalcode"));
            info.setRecBillPhone((String)defaultEntry.get("telephone"));
        }
        return defaultEntry;
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        BillBaseCollection collection = new BillBaseCollection();
        collection.addObject(objectValue);
        ArApServerUtils.checkBillStatusForBotp(ctx, (IObjectCollection)collection, new String[]{SALE_ISSUE_BILL_BOS_TYPE, "C48A423A"});
        if (objectValue instanceof OtherBillInfo) {
            CurrencyInfo baseCurrency;
            OtherBillInfo info = (OtherBillInfo)objectValue;
            CurrencyInfo currency = info.getCurrency();
            if (ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)(baseCurrency = info.getCompany().getBaseCurrency()))) {
                info.setExchangeRate(BigDecimal.ONE);
            }
            this.setMultiEntryAccountDefault(ctx, info);
        }
        super._handleAfterTransform(ctx, action, objectValue);
        Map<String, Boolean> saleInfoMap = this.getSaleIssueBillIsGenBizAr(ctx, (IObjectCollection)collection);
        if (objectValue instanceof OtherBillInfo) {
            OtherBillInfo otherBillInfo = (OtherBillInfo)objectValue;
            if (otherBillInfo.getEntry() != null && !otherBillInfo.getEntry().isEmpty()) {
                OtherBillentryInfo entry = otherBillInfo.getEntry().get(0);
                if (IncomeConfimBillInfo.getBosType().equals(BOSUuid.read((String)entry.getSourceBillId()).getType().toString())) {
                    otherBillInfo.setIsIncomeConfirm(true);
                }
            }
            String companyId = null == otherBillInfo.getCompany() ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : otherBillInfo.getCompany().getId().toString();
            boolean isHandleBizARPointNormal = ArApParamHelper.isHandleBizARPointNormal(ctx, companyId);
            otherBillInfo.setPreRecAmount(this.ZERO);
            otherBillInfo.setThisArAmount(otherBillInfo.getAmount());
            this.extendField(ctx, otherBillInfo);
            this.caculateDiffLocalCurrencyLocalAmount(ctx, otherBillInfo);
            this.setBizBillSelect(otherBillInfo, saleInfoMap, isHandleBizARPointNormal);
            this.setPaymentType(ctx, otherBillInfo);
            boolean isInvoiceBill = OtherBillTypeEnum.InvoiceBill.equals((Object)otherBillInfo.getBillType());
            this.handleBaseUnit(ctx, otherBillInfo, isInvoiceBill);
            if (MakeInvoiceUtils.isSupport()) {
                if (otherBillInfo.getInvoiceType() == null) {
                    otherBillInfo.setInvoiceType(PayInvoiceTypeEnum.DEFAULTTYPE);
                }
                this.setDefaultCustomerTaxInfo(ctx, otherBillInfo);
                this.setDefaultCustomerMailInfo(ctx, otherBillInfo);
            }
            if (null == otherBillInfo.getCU()) {
                otherBillInfo.setCU(null == otherBillInfo.getCompany() ? null : otherBillInfo.getCompany().getCU());
            }
        }
    }

    private Map<String, Boolean> getSaleIssueBillIsGenBizAr(Context ctx, IObjectCollection collection) throws BOSException {
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance((Context)ctx);
        StringBuffer oqlBuffer = new StringBuffer();
        oqlBuffer.append("select id,isGenBizAR where id in (");
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objectValue = collection.getObject(i);
            if (i > 0) {
                oqlBuffer.append(",");
            }
            if (objectValue instanceof OtherBillInfo) {
                OtherBillInfo otherBillInfo = (OtherBillInfo)objectValue;
                OtherBillentryCollection entries = otherBillInfo.getEntry();
                int eSize = entries.size();
                for (int k = 0; k < eSize; ++k) {
                    OtherBillentryInfo entryInfo;
                    String srcBillId;
                    if (k > 0) {
                        oqlBuffer.append(",");
                    }
                    if ((srcBillId = (entryInfo = entries.get(k)).getSourceBillId()) == null || "".equals(srcBillId)) {
                        oqlBuffer.append("''");
                        continue;
                    }
                    BOSObjectType bosType = BOSUuid.read((String)srcBillId).getType();
                    if (!StringUtils.isEmpty((String)srcBillId) && SALE_ISSUE_BILL_BOS_TYPE.equals(bosType.toString())) {
                        oqlBuffer.append("'").append(entryInfo.getSourceBillId()).append("'");
                        continue;
                    }
                    oqlBuffer.append("''");
                }
                continue;
            }
            oqlBuffer.append("''");
        }
        oqlBuffer.append(" )");
        SaleIssueBillCollection saleCollection = iSaleIssueBill.getSaleIssueBillCollection(oqlBuffer.toString());
        HashMap<String, Boolean> saleInfoMap = new HashMap<String, Boolean>();
        int size2 = saleCollection.size();
        for (int i = 0; i < size2; ++i) {
            SaleIssueBillInfo saleInfo = saleCollection.get(i);
            saleInfoMap.put(saleInfo.getId().toString(), saleInfo.isIsGenBizAR());
        }
        return saleInfoMap;
    }

    protected void setBizBillSelect(OtherBillInfo otherBillInfo, Map<String, Boolean> saleInfoMap, boolean isHandleBizARPointNormal) {
        boolean isSelected = false;
        if (isHandleBizARPointNormal) {
            OtherBillentryCollection entries = otherBillInfo.getEntry();
            boolean matchCount = false;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                OtherBillentryInfo entryInfo = entries.get(i);
                String srcBillId = entryInfo.getSourceBillId();
                Boolean isGenBizAP = saleInfoMap.get(srcBillId);
                if (null == isGenBizAP || isGenBizAP.booleanValue()) continue;
                isSelected = true;
            }
        }
        otherBillInfo.setIsBizBill(isSelected);
    }

    protected void caculateDiffLocalCurrencyLocalAmount(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        if (info.isIsCoopBuild()) {
            String companyID = info.getCompany().getId().toString();
            String sourceCompanyID = CoopUtils.getSourceCompanyID(ctx, info.getEntry().get(0).getSourceBillId().toString());
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo("select baseExchangeTable.id,baseCurrency.id,baseCurrency.precision where id = '" + companyID + "'");
            String destLocalCurrencyID = company.getBaseCurrency().getId().toString();
            if (destLocalCurrencyID != null && !"".equals(destLocalCurrencyID) && !sourceCompanyID.equals(companyID)) {
                int precision = company.getBaseCurrency().getPrecision();
                if (precision == 0) {
                    precision = 2;
                }
                ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, company, info.getCurrency(), info.getBillDate());
                BigDecimal converRate = new BigDecimal("1.0");
                boolean isDirectExchangeRate = true;
                if (rateInfo != null) {
                    converRate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
                    isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(rateInfo);
                }
                OtherBillPlanCollection planColl = info.getRecievePlan();
                int size = planColl.size();
                for (int i = 0; i < size; ++i) {
                    OtherBillPlanInfo planInfo = planColl.get(i);
                    planInfo.setRecievePayAmountLocal(BaseDataUtil.caculateLocalAmount(planInfo.getRecievePayAmount(), converRate, isDirectExchangeRate, precision));
                    planInfo.setVerifyAmountLocal(BaseDataUtil.caculateLocalAmount(planInfo.getVerifyAmount(), converRate, isDirectExchangeRate, precision));
                }
                OtherBillentryCollection entryColl = info.getEntry();
                BigDecimal totalAmountLocal = new BigDecimal("0.0");
                int size2 = entryColl.size();
                for (int i = 0; i < size2; ++i) {
                    OtherBillentryInfo entryInfo = entryColl.get(i);
                    BigDecimal amountLocal = BaseDataUtil.caculateLocalAmount(entryInfo.getAmount(), converRate, isDirectExchangeRate, precision);
                    totalAmountLocal = totalAmountLocal.add(amountLocal);
                    entryInfo.setAmountLocal(amountLocal);
                    entryInfo.setRecievePayAmountLocal(BaseDataUtil.caculateLocalAmount(entryInfo.getRecievePayAmount(), converRate, isDirectExchangeRate, precision));
                }
                info.setExchangeRate(converRate);
            }
        }
    }

    protected void setInfoBotpNumber(Context ctx, ArApBillBaseInfo info) throws BOSException, EASBizException {
        OtherBillentryInfo entryInfo;
        String sourceBillID;
        OtherBillInfo otherBill = (OtherBillInfo)info;
        OtherBillentryCollection entry = otherBill.getEntry();
        if (entry.size() > 0 && (sourceBillID = (entryInfo = entry.get(0)).getSourceBillId()) != null && !"".equalsIgnoreCase(sourceBillID)) {
            IOtherBill iarOtherBill = OtherBillFactory.getLocalInstance(ctx);
            com.kingdee.eas.fi.ap.IOtherBill iapOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(sourceBillID);
            if (iarOtherBill.exists((IObjectPK)pk)) {
                OtherBillInfo arOtherBill = iarOtherBill.getOtherBillInfo("select number where id = '" + sourceBillID + "'");
                info.setNumber("**" + arOtherBill.getNumber());
            } else if (iapOtherBill.exists((IObjectPK)pk)) {
                com.kingdee.eas.fi.ap.OtherBillInfo apOtherBill = iapOtherBill.getOtherBillInfo("select number where id = '" + sourceBillID + "'");
                info.setNumber("**" + apOtherBill.getNumber());
            }
        }
    }

    @Override
    protected HashMap _buildDebitAdjust(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        int j;
        HashMap<String, Object> hm = null;
        if (paramMap == null) {
            return hm;
        }
        if (paramMap.get("createTo") == null) {
            SelectorItemCollection transSelectors;
            BOSObjectType bizType = (BOSObjectType)paramMap.get("bizType");
            String cuId = paramMap.get("cuId").toString();
            String selectId = paramMap.get("idArray").toString();
            OtherBillInfo info = (OtherBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(selectId), transSelectors = (SelectorItemCollection)paramMap.get("botpSelectors"));
            if (info == null) {
                throw new ObjectNotFoundException();
            }
            BOTMappingInfo btpMappingInfo = null;
            try {
                btpMappingInfo = ArApBillHelper.getBotpMapping4DebitAdjust(ctx, bizType, cuId, selectId, (IObjectValue)info, (IntEnum)OtherBillTypeEnum.DebitAdjust);
                if (btpMappingInfo == null) {
                    throw new BOTPException(BOTPException.MAPPINGNUMZERO);
                }
            }
            catch (Exception e) {
                logger.error((Object)"ArApBillHelper.getBotpMappingInfo failed", (Throwable)e);
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
            CoreBillBaseCollection coll = null;
            coll = new CoreBillBaseCollection();
            if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.DEBITADJUSTUNAUDIT);
            }
            if (info.isIsBizBill()) {
                throw new OtherBillBizException(OtherBillBizException.BIZARAPBILLCANNOTCREATETO);
            }
            OtherBillentryCollection destEntrys = info.getEntry();
            ArrayList entryID = (ArrayList)paramMap.get("selectEntryId");
            boolean deleteentry = false;
            if (entryID != null && entryID.size() != 0) {
                deleteentry = true;
            }
            OtherBillentryInfo destEntryInfo = null;
            Iterator it = destEntrys.iterator();
            while (it.hasNext()) {
                destEntryInfo = (OtherBillentryInfo)it.next();
                if (!deleteentry || entryID.contains(destEntryInfo.getId().toString())) continue;
                it.remove();
            }
            coll.add((CoreBillBaseInfo)info);
            try {
                OtherBillInfo otherBillInfo = null;
                BTPTransformResult btpResult = null;
                IBTPManager iBTPManager = null;
                iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                if (bizType != null && btpMappingInfo != null && btpMappingInfo.getId() != null) {
                    btpResult = iBTPManager.transform(coll, bizType.toString(), (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()));
                }
                if (btpResult == null) {
                    throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
                }
                otherBillInfo = (OtherBillInfo)btpResult.getBills().getObject(0);
                otherBillInfo.setId(null);
                otherBillInfo.setNumber(this.getJDTZNumber(ctx, coll.get(0).getId(), coll.get(0).getNumber()));
                otherBillInfo.setIsNeedVoucher(true);
                UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
                Date now = new Date();
                Calendar cal = Calendar.getInstance();
                cal.setTime(now);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                otherBillInfo.setCreator(currentUser);
                otherBillInfo.setCreateTime(new Timestamp(now.getTime()));
                if (otherBillInfo.getEntries() != null) {
                    BigDecimal recPayAmount = this.ZERO;
                    BigDecimal recPayAmountLocal = this.ZERO;
                    OtherBillentryInfo entryInfo = null;
                    for (int i = 0; i < otherBillInfo.getEntries().size(); ++i) {
                        entryInfo = (OtherBillentryInfo)otherBillInfo.getEntries().getObject(i);
                        if (entryInfo.getMaterial() != null) {
                            entryInfo.setMaterial(entryInfo.getMaterial());
                            entryInfo.setMaterialName(entryInfo.getMaterial().getName());
                        }
                        if (entryInfo.getOrderCustomer() != null) {
                            entryInfo.setOrdCustName(entryInfo.getOrderCustomer().getName());
                            entryInfo.setOrdCustNumber(entryInfo.getOrderCustomer().getNumber());
                            entryInfo.setOrderCustomer(entryInfo.getOrderCustomer());
                        }
                        if (entryInfo.getServiceCustomer() != null) {
                            entryInfo.setSerCustName(entryInfo.getServiceCustomer().getName());
                            entryInfo.setSerCustNumber(entryInfo.getServiceCustomer().getNumber());
                            entryInfo.setServiceCustomer(entryInfo.getServiceCustomer());
                        }
                        recPayAmount = entryInfo.getRecievePayAmount() != null ? entryInfo.getRecievePayAmount() : this.ZERO;
                        recPayAmountLocal = entryInfo.getRecievePayAmountLocal() != null ? entryInfo.getRecievePayAmountLocal() : this.ZERO;
                        entryInfo.setUnVerifyAmount(recPayAmount);
                        entryInfo.setUnVerifyAmountLocal(recPayAmountLocal);
                        entryInfo.setVerifyAmount(this.ZERO);
                        entryInfo.setVerifyAmountLocal(this.ZERO);
                        entryInfo.setLockUnVerifyAmt(recPayAmount);
                        entryInfo.setLockUnVerifyAmtLocal(recPayAmountLocal);
                        entryInfo.setLockVerifyAmt(this.ZERO);
                        entryInfo.setLockVerifyAmtLocal(this.ZERO);
                        entryInfo.setBadAmount(this.ZERO);
                        entryInfo.setBadAmountLocal(this.ZERO);
                        entryInfo.setLocalUnwriteOffAmount(recPayAmountLocal);
                        entryInfo.setLocalWrittenOffAmount(this.ZERO);
                        entryInfo.setHisUnVerifyAmount(entryInfo.getLockUnVerifyAmt());
                        entryInfo.setHisUnVerifyAmountLocal(entryInfo.getLockUnVerifyAmtLocal());
                        entryInfo.setApportionAmtLocal(this.ZERO);
                        entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
                        entryInfo.setUnInvoiceReqQty(entryInfo.getQuantity());
                        entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
                        entryInfo.setInvoiceReqQty(this.ZERO);
                        entryInfo.setInvoiceReqBaseQty(this.ZERO);
                        entryInfo.setUnInvoiceReqAmount(entryInfo.getRecievePayAmount());
                        entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getRecievePayAmountLocal());
                        entryInfo.setInvoiceReqAmount(this.ZERO);
                        entryInfo.setInvoiceReqAmountLocal(this.ZERO);
                    }
                }
                otherBillInfo.sumEntry();
                ArApBillHelper.generatePlan(ctx, otherBillInfo);
                this.setMultiEntryAccountDefault(ctx, otherBillInfo);
                String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(bizType.toString(), "editUI");
                hm = new HashMap<String, Object>();
                hm.put("btpResult", btpResult);
                hm.put("DestBillEditUIClassName", destBillEditUIClassName);
            }
            catch (BOSException e) {
                logger.error((Object)"_buildDebitAdjust", (Throwable)e);
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
            catch (BTPException e) {
                logger.error((Object)"_buildDebitAdjust", (Throwable)e);
                throw new OtherBillBizException(BTPException.BOTTRANSFORMCLASSERROR);
            }
        }
        SelectorItemCollection botpSelectors = (SelectorItemCollection)paramMap.get("botpSelectors");
        HashSet<String> idList = new HashSet<String>((List)paramMap.get("idList"));
        HashSet<String> entriesKeys = new HashSet<String>((List)paramMap.get("entriesKey"));
        Set srcDebitAdjustId = (Set)paramMap.get("srcDebitAdjustId");
        HashSet<String> srcBuildDebitAdjustId = new HashSet<String>();
        HashSet<String> srcId = new HashSet<String>();
        CoreBillBaseCollection collections = null;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        entityViewInfo.put("selector", (Object)botpSelectors);
        FilterInfo filterInfo = new FilterInfo();
        String strIdLists = OtherBillControllerBean.objectArray2String(idList.toArray(), ",");
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)strIdLists, CompareType.INCLUDE));
        sbFormula.append("(#0 ");
        filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(104)));
        sbFormula.append("and #1) ");
        filterInfo.setMaskString(sbFormula.toString());
        entityViewInfo.setFilter(filterInfo);
        collections = OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
        OtherBillInfo info = null;
        OtherBillentryInfo entryInfo = null;
        boolean isStart = false;
        boolean isSetStart = false;
        for (j = 0; j < collections.size(); ++j) {
            info = (OtherBillInfo)collections.get(j);
            if (!isSetStart) {
                // empty if block
            }
            isSetStart = true;
            if (!isStart || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            idList.add(info.getId().toString());
            for (int i = 0; i < info.getEntries().size(); ++i) {
                entryInfo = (OtherBillentryInfo)info.getEntries().getObject(i);
                entriesKeys.add(entryInfo.getId().toString());
                srcBuildDebitAdjustId.add(entryInfo.getSourceBillId());
            }
        }
        if (srcDebitAdjustId != null && srcDebitAdjustId.size() > 0) {
            sbFormula = new StringBuffer();
            entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.put("selector", (Object)botpSelectors);
            filterInfo = new FilterInfo();
            strIdLists = OtherBillControllerBean.objectArray2String(srcDebitAdjustId.toArray(), ",");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
            sbFormula.append(" #0 ");
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", null, CompareType.NOTEQUALS));
            sbFormula.append("and #1 ");
            filterInfo.setMaskString(sbFormula.toString());
            entityViewInfo.setFilter(filterInfo);
            collections = OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
            for (j = 0; j < collections.size(); ++j) {
                info = (OtherBillInfo)collections.get(j);
                isSetStart = true;
                if (!isStart) continue;
                srcBuildDebitAdjustId.add(info.getId().toString());
                srcId.add(info.getSourceBillId().toString());
            }
        }
        HashSet<String> collset = new HashSet<String>();
        collset.addAll(srcBuildDebitAdjustId);
        collset.addAll(srcId);
        sbFormula = new StringBuffer();
        entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        entityViewInfo.put("selector", (Object)botpSelectors);
        filterInfo = new FilterInfo();
        strIdLists = OtherBillControllerBean.objectArray2String(collset.toArray(), ",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        sbFormula.append(" #0 ");
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)strIdLists, CompareType.INCLUDE));
        sbFormula.append("or #1 ");
        filterInfo.setMaskString(sbFormula.toString());
        entityViewInfo.setFilter(filterInfo);
        collections = OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
        for (int j2 = 0; j2 < collections.size(); ++j2) {
            info = (OtherBillInfo)collections.get(j2);
            isSetStart = true;
            if (!isStart || !info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
            idList.add(info.getId().toString());
            for (int i = 0; i < info.getEntries().size(); ++i) {
                entryInfo = (OtherBillentryInfo)info.getEntries().getObject(i);
                entriesKeys.add(entryInfo.getId().toString());
            }
        }
        sbFormula = new StringBuffer();
        entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("*");
        entityViewInfo.put("selector", (Object)botpSelectors);
        filterInfo = new FilterInfo();
        strIdLists = OtherBillControllerBean.objectArray2String(idList.toArray(), ",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        sbFormula.append("#0 ");
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(3), CompareType.EQUALS));
        sbFormula.append(" and #1 ");
        filterInfo.setMaskString(sbFormula.toString());
        entityViewInfo.setFilter(filterInfo);
        collections = OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(entityViewInfo);
        this.removeUnSelect(entriesKeys, collections, "entry");
        hm = new HashMap();
        hm.put("collBill", collections);
        return hm;
    }

    protected String getJDTZNumber(Context ctx, BOSUuid uuid, String billNumber) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("number");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)uuid.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)OtherBillTypeEnum.DebitAdjust));
        entityViewInfo.setFilter(filterInfo);
        OtherBillCollection collection = OtherBillFactory.getLocalInstance(ctx).getOtherBillCollection(entityViewInfo);
        HashSet<String> srcNumber = new HashSet<String>();
        HashSet<String> desNumber = new HashSet<String>();
        String number = null;
        for (int i = 0; i < collection.size(); ++i) {
            OtherBillInfo billinfo = collection.get(i);
            srcNumber.add(billinfo.getNumber());
            number = billNumber + "JDTZ" + this.getNumberFormater(3, new StringBuffer(i + 1 + ""));
            desNumber.add(number);
        }
        desNumber.removeAll(srcNumber);
        Iterator it = desNumber.iterator();
        if (it.hasNext()) {
            return (String)it.next();
        }
        return billNumber + "JDTZ" + this.getNumberFormater(3, new StringBuffer(collection.size() + 1 + ""));
    }

    private String getNumberFormater(int length, StringBuffer farmaterNumber) {
        StringBuffer fr = new StringBuffer();
        for (int i = 0; i < length - farmaterNumber.length(); ++i) {
            fr.append("0");
        }
        farmaterNumber.insert(0, fr.toString());
        return farmaterNumber.toString();
    }

    private void removeUnSelect(Set entriesKey, CoreBillBaseCollection sourceBillCollection, String entryName) {
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            CoreBillBaseInfo bills = sourceBillCollection.get(i);
            boolean isHasSelect = false;
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                isHasSelect = false;
                if (entriesKey.contains(cInfo.get("id").toString())) {
                    isHasSelect = true;
                    continue;
                }
                if (isHasSelect) continue;
                iters.remove();
            }
        }
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            buffer.append(objs[i] == null ? "null" : objs[i].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    @Override
    protected void _editVouch(Context ctx, String billId) throws BOSException, EASBizException {
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        int total = sourceBillPkList.length;
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        IObjectPK logPK = null;
        if (total > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (botpSelectors != null) {
                botpSelectors.add(new SelectorItemInfo("number"));
                entityViewInfo.setSelector(botpSelectors);
            }
            entityViewInfo.getSelector().add(new SelectorItemInfo("billStatus"));
            FilterInfo filterInfo = new FilterInfo();
            String strIdLists = StringUtils.arrayToString((Object[])sourceBillPkList, (String)",");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            CoreBillBaseCollection billColl = this.getCoreBillBaseCollection(ctx, entityViewInfo);
            block0: for (int i = 0; i < sourceBillPkList.length; ++i) {
                for (int j = 0; j < billColl.size(); ++j) {
                    if (!sourceBillPkList[i].toString().equals(billColl.get(j).getId().toString())) continue;
                    allSourceBillCollection.addObject((IObjectValue)billColl.get(j));
                    continue block0;
                }
            }
            StringBuffer billNumber = new StringBuffer("");
            int size = allSourceBillCollection.size();
            for (int i = 0; i < size; ++i) {
                billNumber.append(billColl.get(i).getNumber()).append("  ");
            }
            if (total > 0) {
                logPK = LogUtil.beginLog((Context)ctx, (String)(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"78_OtherBillListUI", (Locale)ctx.getOriginLocale()) + EASResource.getString((String)AR_RESOURCE, (String)"voucher_log", (Locale)ctx.getOriginLocale())), (BOSObjectType)BOSUuid.getBOSObjectType((String)sourceBillPkList[0].toString(), (boolean)true), null, (String)billNumber.toString(), (String)"ar_otherbill_makevoucher");
            }
        }
        DAPTransformResult result = super.generateVoucher(ctx, allSourceBillCollection, botMappingPK);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, logPK);
        }
        return result;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        String[] billIDs = new String[sourceBillCollection.size()];
        CoreBillBaseCollection billColl = new CoreBillBaseCollection();
        billColl.addObjectCollection(sourceBillCollection);
        String companyId = null;
        if (billColl != null && billColl.size() > 0) {
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                billIDs[i] = billColl.get(i).getId().toString();
            }
            this._isCanCreateVoucher(ctx, billIDs, companyId);
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _isCanCreateVoucher(Context ctx, String[] ids, String companyId) throws BOSException, EASBizException {
        IOtherBill otherbill = OtherBillFactory.getLocalInstance(ctx);
        OtherBillInfo otherbillInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("billStatus"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ArApBillUtil.convertObjectToSet(ids), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        OtherBillCollection otherBillColl = otherbill.getOtherBillCollection(view);
        for (int i = 0; i < otherBillColl.size(); ++i) {
            otherbillInfo = otherBillColl.get(i);
            if (BillStatusEnum.AUDITED.equals((Object)otherbillInfo.getBillStatus())) continue;
            throw new OtherBillBizException(OtherBillBizException.NOTAUDITED);
        }
    }

    protected void generateVoucherWfTrigger(Context ctx, IObjectPK[] sourceBillPkList) throws EASBizException, BOSException {
        if (sourceBillPkList.length == 1) {
            this.generateVoucher(ctx, sourceBillPkList[0]);
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    private void writeBackWhenInitBill(Context ctx, OtherBillInfo info, boolean isSubmited) throws EASBizException, BOSException {
        if (info.getSourceBillType() != null && VerificateBillTypeEnum.SaleOrder == info.getSourceBillType() && info.isIsInitializeBill()) {
            AR2SOWriteBackHandler handler = new AR2SOWriteBackHandler();
            if (isSubmited) {
                handler.handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.UNAUDIT, new String[]{info.getId().toString()}, (String[][])null);
            } else {
                handler.handle(ctx, com.kingdee.eas.scm.common.BizActionEnum.SUBMIT, new String[]{info.getId().toString()}, (String[][])null);
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks, CoreBillBaseCollection coreBillCollection) throws BOSException, EASBizException {
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            ArApBillBaseInfo billInfo = this.canUnpassAudit(ctx, pks[i], null);
            if (billInfo == null) {
                return;
            }
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)(BOSObjectType.create((String)"FC910EF3").equals((Object)billInfo.getBOSType()) ? EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"78_OtherBillListUI", (Locale)ctx.getOriginLocale()) : EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"2_OtherBillListUI", (Locale)ctx.getOriginLocale()) + EASResource.getString((String)AR_RESOURCE, (String)"unaudit_log", (Locale)ctx.getOriginLocale())), (BOSObjectType)billInfo.getBOSType(), null, (String)billInfo.getNumber(), (String)"ar_otherbill_antiAudit");
            this.unPassAudit(ctx, pks[i], (IObjectValue)billInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    @Override
    protected void _reverseBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this.createReverseBill(ctx, pks);
    }

    protected void extendField(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection profitCollection;
        OrgUnitInfo profitInfo;
        if (info.getSaleOrg() != null && info.getSaleOrg().getId() != null && (profitInfo = (profitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(info.getSaleOrg().getId().toString(), 2, 6)).get(0)) != null) {
            ProfitCenterOrgUnitInfo profitCenterInfo = new ProfitCenterOrgUnitInfo();
            profitCenterInfo.setId(profitInfo.getId());
            info.setProfitCenter(profitCenterInfo);
        }
    }

    private Timestamp getPlanInvoiceDate(OtherBillInfo otherBillInfo) {
        Date planInvoiceDate = otherBillInfo.getPlanInvoiceDate();
        try {
            Object instance = Class.forName("com.kingdee.eas.fi.ar.app.OtherBillPlanInvoiceDate").newInstance();
            Method method = instance.getClass().getDeclaredMethod("getPlanInvoiceDate", Date.class);
            Object result = method.invoke(instance, otherBillInfo.getPlanInvoiceDate());
            if (result instanceof Timestamp) {
                return (Timestamp)result;
            }
        }
        catch (Exception e) {
            logger.error((Object)" call com.kingdee.eas.fi.ar.app.OtherBillPlanInvoiceDate failed.");
        }
        if (planInvoiceDate != null && planInvoiceDate.after(new Date())) {
            return null;
        }
        return new Timestamp(System.currentTimeMillis());
    }

    protected void setPaymentType(Context ctx, ArApBillBaseInfo info) throws EASBizException, BOSException {
        if (info.getPaymentType() != null) {
            PaymentTypeInfo paymentTypeCredit = null;
            PaymentTypeInfo paymentTypeCurrency = null;
            String paymentTypeCreditId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
            String paymentTypeCurrencyId = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
            if ("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5".equals(info.getPaymentType().getId().toString())) {
                paymentTypeCredit = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeCreditId));
                info.setPaymentType(paymentTypeCredit);
            } else if ("40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(info.getPaymentType().getId().toString())) {
                paymentTypeCurrency = PaymentTypeFactory.getLocalInstance((Context)ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeCurrencyId));
                info.setPaymentType(paymentTypeCurrency);
            }
        }
    }

    @Override
    protected void _enableNotJoinAccountBad(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isNotJoinBadAccount"));
        selector.add(new SelectorItemInfo("id"));
        OtherBillInfo billInfo = this.getOtherBillInfo(ctx, billId, selector);
        if (billInfo.isIsNotJoinBadAccount()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{"\"\u4e0d\u53c2\u4e0e\u574f\u8d26\u8ba1\u63d0\"\u5df2\u5f00\u542f"});
        }
        billInfo.setIsNotJoinBadAccount(true);
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        iOtherBill.update(billId, (CoreBaseInfo)billInfo);
    }

    @Override
    protected void _disableNotJoinAccountBad(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isNotJoinBadAccount"));
        selector.add(new SelectorItemInfo("id"));
        OtherBillInfo billInfo = this.getOtherBillInfo(ctx, billID, selector);
        if (!billInfo.isIsNotJoinBadAccount()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{"\"\u4e0d\u53c2\u4e0e\u574f\u8d26\u8ba1\u63d0\"\u5df2\u5173\u95ed"});
        }
        billInfo.setIsNotJoinBadAccount(false);
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        iOtherBill.update(billID, (CoreBaseInfo)billInfo);
    }

    @Override
    protected boolean _rePreVerify(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        String sql = "select 1 where isPreVerify = 1 and billID ='" + info.getId().toString() + "'";
        boolean isExists = VerificationBillentryFactory.getLocalInstance(ctx).exists(sql);
        if (isExists) {
            return false;
        }
        try {
            this.autoPreVerify(ctx, info);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return false;
        }
        return true;
    }

    @Override
    protected String getTableNameForReverseSave() {
        return "T_AR_OtherBill";
    }

    private void setMultiEntryAccountDefault(Context ctx, OtherBillInfo info) throws BOSException, EASBizException {
        AccountViewInfo entryDefaultAccount = this.getEntryDefaultAccount(ctx, info, true);
        if (entryDefaultAccount != null) {
            OtherBillentryCollection collection = info.getEntry();
            for (int i = 0; i < collection.size(); ++i) {
                OtherBillentryInfo entry = collection.get(i);
                if (entry.getAccount() != null) continue;
                entry.setAccount(entryDefaultAccount);
            }
        }
    }

    protected Set<String> getEntrySrcIdSet(OtherBillInfo info) {
        HashSet<String> entrySrcIdSet = new HashSet<String>();
        String entrySrcId = null;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entrySrcId = info.getEntry().get(i).getSourceBillId();
            if (StringUtils.isEmpty((String)entrySrcId)) continue;
            entrySrcIdSet.add(entrySrcId);
        }
        return entrySrcIdSet;
    }
}

