/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanFactory;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class OtherBillPlanImport
extends AbstractDataTransmission {
    String[] DECIMAL_FIELDS = new String[]{"FRecievePayAmount", "FRecievePayAmountLocal", "FVerifyAmount", "FVerifyAmountLocal"};
    String[] DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal"};
    String[] STRING_FIELDS = new String[]{"FRemark"};
    String[] STRING_OBJS = new String[]{"remark"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherBillPlanFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        boolean isAddNew = true;
        ICoreBase iOtherBillPlan = this.getController(ctx);
        try {
            OtherBillPlanInfo info = (OtherBillPlanInfo)coreBaseInfo;
            int seq = info.getSeq();
            IOtherBill iOtherBillNew = OtherBillFactory.getLocalInstance(ctx);
            BOSUuid parentId = info.getParent().getId();
            BOSUuid entryId = null;
            if (parentId != null) {
                ObjectUuidPK pk = new ObjectUuidPK(parentId);
                OtherBillInfo oldBillInfo = iOtherBillNew.getOtherBillInfo((IObjectPK)pk);
                OtherBillPlanCollection collection = oldBillInfo.getRecievePlan();
                boolean isOver = this.checkAmtIsOver(oldBillInfo.getAmount(), info.getRecievePayAmount(), collection, seq);
                if (isOver) {
                    throw new TaskExternalException("The Record Amount Is Over!");
                }
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    OtherBillPlanInfo entryInfo = (OtherBillPlanInfo)iter.next();
                    if (entryInfo.getSeq() != seq) continue;
                    isAddNew = false;
                    entryId = entryInfo.getId();
                    break;
                }
            }
            if (isAddNew) {
                iOtherBillPlan.addnew(coreBaseInfo);
            } else {
                info.setId(entryId);
                iOtherBillPlan.update((IObjectPK)new ObjectUuidPK(entryId), (CoreBaseInfo)info);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private boolean checkAmtIsOver(BigDecimal amount, BigDecimal recievePayAmount, OtherBillPlanCollection collection, int seq) throws TaskExternalException {
        OtherBillPlanInfo planInfo;
        boolean flag = false;
        Object bizInfo = null;
        BigDecimal tmp = new BigDecimal("0.00");
        Iterator iter = collection.iterator();
        while (iter.hasNext() && (seq != (planInfo = (OtherBillPlanInfo)iter.next()).getSeq() || amount.compareTo(recievePayAmount) < 0)) {
            tmp = tmp.add(planInfo.getRecievePayAmount());
        }
        if (tmp.compareTo(amount) > 0) {
            flag = true;
        }
        return flag;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        String str;
        Object data;
        OtherBillPlanInfo entryInfo;
        block16: {
            entryInfo = new OtherBillPlanInfo();
            try {
                data = ((DataToken)hsData.get((Object)"FNumber")).data;
                if (data != null) {
                    str = data.toString();
                    if (str != null && str.trim().length() > 0) {
                        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
                        OtherBillCollection collection = iOtherBill.getOtherBillCollection("where number ='" + str + "'");
                        if (collection == null || collection.size() == 0) {
                            throw new TaskExternalException("Import The Plan Record Error!");
                        }
                        OtherBillInfo otherBillInfo = collection.get(0);
                        OtherBillPlanCollection entryCollection = otherBillInfo.getRecievePlan();
                        entryInfo.setParent(otherBillInfo);
                        if (entryCollection != null && entryCollection.size() > 0) {
                            entryInfo.setSeq(this.getMaxRowNum(entryCollection));
                        } else {
                            entryInfo.setSeq(1);
                        }
                    }
                    break block16;
                }
                throw new TaskExternalException("FOtherBillId  not found!!!!");
            }
            catch (BOSException bex) {
                Logger.error((Throwable)bex);
                throw new TaskExternalException("process otherbillid  error!!!!");
            }
        }
        try {
            data = ((DataToken)hsData.get((Object)"FSeq")).data;
            if (data == null) {
                throw new TaskExternalException("FSeq is not found!");
            }
            str = data.toString();
            entryInfo.setSeq(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            throw new TaskExternalException("FSeq is not number!");
        }
        for (i = 0; i < this.DECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.DECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                entryInfo.setBigDecimal(this.DECIMAL_OBJS[i], (BigDecimal)value);
                continue;
            }
            catch (Exception nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException("[" + this.DECIMAL_OBJS[i] + "] format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object objVal = ((DataToken)hsData.get((Object)"FRecievePayDate")).data;
        String sDate = (String)objVal;
        try {
            Date vcDate = DateTimeUtils.parseDate((String)sDate, (String)"dd/MM/yyyy");
            entryInfo.setDate("recievePayDate", vcDate);
        }
        catch (ParseException e) {
            throw new TaskExternalException(" the Date must be in format of yyyy-MM-dd ");
        }
        return entryInfo;
    }

    private int getMaxRowNum(OtherBillPlanCollection entryCollection) {
        int max = 0;
        int temp = 0;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            OtherBillPlanInfo info = entryCollection.get(i);
            if (info == null || (temp = info.getSeq()) <= max) continue;
            max = temp;
        }
        return max;
    }
}

