/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.app.RptSqlTemplate;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Locale;

public abstract class RptSwapBillSql
extends RptSqlTemplate {
    @Override
    public String materialClause() {
        return " -1 FEntrySeq, null FEntryId, null FMaterialId, null FExpenseItemId, 0 FQuantity, ";
    }

    @Override
    public String entryMaterialJoinClause() {
        return "";
    }

    @Override
    public String swapEntryJoinClause() {
        return "\r\n inner join " + this.tableName() + "Entry AS entry on t1.FId = entry.FParentId";
    }

    private void joinClause(ItemRptQueryParam param, StringBuffer sql) {
        sql.append(" INNER JOIN ");
        sql.append(param.getAdminOrgTempTable());
        sql.append(" T5 ON ");
        sql.append(" ( ");
        sql.append("t1.");
        sql.append(this.fldAdmin());
        sql.append(" = T5.fid");
        if (param.isIncludeNullAdmin()) {
            sql.append(" OR (");
            sql.append("t1.");
            sql.append(this.fldAdmin());
            sql.append(" IS NULL ");
            sql.append(" AND T5.fid IS NULL");
            sql.append(" )");
        }
        sql.append(" ) ");
        sql.append(" INNER JOIN ");
        sql.append(param.getPersonTempTable());
        sql.append(" T6 ON ");
        sql.append(" ( ");
        sql.append("t1.");
        sql.append(this.fldPerson());
        sql.append(" = T6.fid");
        if (param.isIncludeNullPerson()) {
            sql.append(" OR (");
            sql.append("t1.");
            sql.append(this.fldPerson());
            sql.append(" IS NULL ");
            sql.append(" AND T6.fid IS NULL");
            sql.append(" )");
        }
        sql.append(" ) ");
    }

    private void whereClause(ItemRptQueryParam param, StringBuffer sql) {
        if (!param.isAllCurrency()) {
            sql.append(" and t1.").append(this.fldCurrency()).append(" = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        sql.append(this.specifiedWhere((ArApQueryParam)param));
        if (!param.isIncludeBizBill()) {
            sql.append(this.setExcludeBizBill());
        }
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("  and t1.").append(this.fldCussTypeId());
        sql.append(" = '").append(param.getCussTypeId());
        sql.append("' and t1.FCOMPANYID = '");
        sql.append(param.getCompanyId()).append("' ");
        sql.append("  and t1.").append(this.fldDate());
        sql.append(" >= {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("}  and t1.").append(this.fldDate());
        sql.append(" < {");
        sql.append(dtFormat.format(param.getEndDate()));
        sql.append("} ");
    }

    public String getSwapQuerySql(ItemRptQueryParam param, Locale locale) {
        boolean fSpAdminOrg = !StringUtils.isEmpty((String)param.getAdminOrgTempTable()) || !StringUtils.isEmpty((String)param.getPersonTempTable());
        String nameFld = "FName_" + locale.getLanguage();
        StringBuffer sql = new StringBuffer();
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" select t1.FID FBillId, baseCurrency.FNumber FBaseCurrNum ,");
            sql.append(" baseCurrency.").append(nameFld);
            sql.append(" FBaseCurrency, t3.").append(nameFld);
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" select t1.FID FBillId, t2.FNumber FCurrNum ,");
            sql.append(" t2.").append(nameFld);
            sql.append(" FCurrency, baseCurrency.FNumber FBaseCurrNum , baseCurrency.").append(nameFld);
            sql.append(" FBaseCurrency, t3.").append(nameFld);
        }
        sql.append(" FCussType,  ");
        sql.append(" t4.FNumber FCussNum, t4.").append(nameFld);
        sql.append(" FCussName, t4.FId FCussAcctId,");
        sql.append(" T5.").append(nameFld).append(" FAdminOrg,");
        sql.append(" T5.FNumber FAdminOrgNum, ");
        sql.append("t1.");
        sql.append(this.fldAdmin()).append(" FAdminOrgId, ");
        sql.append(" T6.").append(nameFld).append(" FPerson,");
        sql.append(" T6.FNumber FPersonNum, ");
        sql.append("t1.");
        sql.append(this.fldPerson()).append(" FPersonId, ");
        sql.append(" t1.").append(this.fldDate());
        sql.append(" FBizDate,  ").append("222");
        sql.append(" FBillType, ").append(this.fldRecPayType(nameFld));
        sql.append(" FRecPayType, t1.FNumber FBillNum, ");
        sql.append(" vType.").append(nameFld).append(" FVoucherType,");
        sql.append(" N'' || ").append(this.fldVouNumber()).append(" FVoucherNum, ");
        sql.append(this.isBill() ? this.fldDescription() : " N'' ");
        sql.append(" FDescription,  ");
        boolean fShowMaterialItem = param.isShowMaterialItem();
        if (fShowMaterialItem) {
            sql.append(this.contractEntryClause());
        } else {
            sql.append(this.contractClause());
        }
        if (fShowMaterialItem) {
            sql.append(this.materialClause());
        }
        sql.append(this.amtClause(fSpAdminOrg, fShowMaterialItem, param));
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" 0 FBalanceAmtLocal,  '").append(param.getPeriodId());
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append(" 0 FBalanceAmt, 0 FBalanceAmtLocal, '").append(param.getPeriodId());
        }
        sql.append("' FPeriodId, t7.FPeriodYear, t7.FPeriodNumber, ");
        sql.append(this.mainBillType());
        sql.append(" FMainBillType, ").append(2);
        sql.append(" FDataType,newbosid('ARAPItem') FBosID");
        sql.append(" from ").append(this.tableName()).append(" AS t1");
        if ("base".equals(param.getCurrencyId())) {
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
            sql.append(" INNER JOIN T_BD_Currency baseCurrency ON baseCurrency.FID=company.FBaseCurrencyID");
        } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
            sql.append("  inner join T_BD_Currency AS t2 ON t1.");
            sql.append(this.fldCurrency()).append(" = t2.FID ");
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID=t1.FCompanyId").append("\r\n");
            sql.append(" INNER JOIN T_BD_Currency baseCurrency ON baseCurrency.FID=company.FBaseCurrencyID");
        }
        sql.append("  inner join t_bd_asstActType t3 on t1.");
        sql.append(this.fldCussTypeId()).append(" = t3.FID ");
        sql.append("  inner join ").append(param.getCussAcctTempTable());
        sql.append(" t4 on t1.").append(this.fldAsstActId()).append(" = t4.FID ");
        sql.append("  left join T_GL_Voucher voucher on ");
        sql.append(" t1.FVoucherID = voucher.FId");
        sql.append("  left join T_BD_VoucherTypes vType on ");
        sql.append(" voucher.FVoucherTypeID = vType.FId");
        sql.append(fSpAdminOrg ? this.swapEntryJoinClause() : "");
        this.joinClause(param, sql);
        sql.append("  inner join t_bd_period t7 on ");
        sql.append(" t7.FId = '").append(param.getPeriodId()).append("' ");
        sql.append(this.recPayTypeJoinClause());
        sql.append(this.vouNumJoinClause());
        if (fShowMaterialItem) {
            sql.append(this.entryMaterialJoinClause());
        }
        sql.append("  where 1= 1");
        this.whereClause(param, sql);
        if (fSpAdminOrg && !this.isBill() && !fShowMaterialItem) {
            if ("base".equals(param.getCurrencyId())) {
                sql.append("  group by t1.FId, baseCurrency.FNumber");
                sql.append(", baseCurrency.").append(nameFld);
            } else if (!"base".equals(param.getCurrencyId()) && param.isBaseCurrency()) {
                sql.append("  group by t1.FId, t2.FNumber");
                sql.append(", t2.").append(nameFld);
                sql.append(", baseCurrency.FNumber, baseCurrency.").append(nameFld);
            }
            sql.append(", t3.").append(nameFld);
            sql.append(", t4.").append(nameFld);
            sql.append(", t4.FNumber, t4.FId, t5.").append(nameFld);
            sql.append(",  t5.FNumber");
            sql.append(", vType.").append(nameFld);
            sql.append(", ").append(this.fldVouNumber());
            sql.append(", t1.").append(this.fldAdmin());
            sql.append(", t6.").append(nameFld);
            sql.append(", t6.FNumber,  ");
            sql.append("t1.").append(this.fldPerson());
            sql.append(", t1.").append(this.fldDate());
            sql.append(", t1.FBillType, t1.FNumber");
            sql.append(", t7.FPeriodYear, t7.FPeriodNumber");
            sql.append(fShowMaterialItem ? ", entry.FId, entry.FMaterialId" : "");
        }
        return sql.toString();
    }
}

