/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.UnSettledDetailRptParam;
import com.kingdee.eas.fi.ar.app.AbstractUnSettledDetailRptFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UnSettledDetailRptFacadeControllerBean
extends AbstractUnSettledDetailRptFacadeControllerBean {
    public static final String CR = "\r\n";

    @Override
    protected Map _getData(Context ctx, UnSettledDetailRptParam param) throws BOSException, EASBizException {
        try {
            String tempTable = param.getTempTable();
            int totalRowCount = 0;
            if (param.isNewQuery() || StringUtils.isEmpty((String)tempTable)) {
                tempTable = this.createTempTable(ctx, param);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(1) as count from " + tempTable));
                while (rs.next()) {
                    totalRowCount = rs.getInt("count");
                }
            }
            int startIndex = param.getStartIndex();
            int endIndex = param.getEndIndex();
            StringBuffer sb = new StringBuffer();
            sb.append("select").append(" fCurrencyId, fCurrencyName,fCompanyId, fCompanyName, fAsstActNumber, fAsstActName, fDepartmentName,").append(" fPersonName, fBillDate, fBillKind, fBillTypeName, fBillNumber,").append(CR).append(" fDescription, fArUnSettledAmt, fRecUnSettledAmt, fIsSummaryRow, fBillId").append(CR).append(" from ").append(tempTable).append(" order by fCurrencyName, fAsstActNumber");
            if (param.isSummaryByDepartment()) {
                sb.append(", fDepartmentName");
            }
            if (param.isSummaryByPerson()) {
                sb.append(", fPersonName");
            }
            sb.append(", fBillDate, fBillKind, fBillNumber");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (int)(startIndex - 1), (int)(endIndex - startIndex + 1));
            ArrayList gridData = new ArrayList();
            HashMap<String, Object> rowData = null;
            BigDecimal unSettledBalance = param.getPrevUnSettledBalance();
            if (param.isNewQuery() || unSettledBalance == null) {
                unSettledBalance = BigDecimal.ZERO;
            }
            String billKind = null;
            String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
            int _id = startIndex;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal arUnSettledAmtSummary = BigDecimal.ZERO;
            BigDecimal recUnSettledAmtSummary = BigDecimal.ZERO;
            while (rs.next()) {
                rowData = new HashMap<String, Object>();
                gridData.add(rowData);
                rowData.put("id", _id++);
                rowData.put("fCurrencyId", rs.getString("fCurrencyId"));
                rowData.put("fCurrencyName", rs.getString("fCurrencyName"));
                rowData.put("fCompanyId", rs.getString("fCompanyId"));
                rowData.put("fCompanyName", rs.getString("fCompanyName"));
                rowData.put("fAsstActNumber", rs.getString("fAsstActNumber"));
                rowData.put("fAsstActName", rs.getString("fAsstActName"));
                rowData.put("fDepartmentName", rs.getString("fDepartmentName"));
                rowData.put("fPersonName", rs.getString("fPersonName"));
                rowData.put("fBillDate", StringUtils.isEmpty((String)rs.getString("fBillDate")) ? "" : df.format(rs.getDate("fBillDate")));
                rowData.put("fBillTypeName", rs.getString("fBillTypeName"));
                rowData.put("fBillNumber", rs.getString("fBillNumber"));
                rowData.put("fDescription", rs.getString("fDescription"));
                rowData.put("fIsSummaryRow", rs.getString("fIsSummaryRow"));
                rowData.put("fbillid", rs.getString("fBillId"));
                BigDecimal arUnSettledAmt = rs.getBigDecimal("fArUnSettledAmt");
                BigDecimal recUnSettledAmt = rs.getBigDecimal("fRecUnSettledAmt");
                rowData.put("fArUnSettledAmt", arUnSettledAmt);
                rowData.put("fRecUnSettledAmt", recUnSettledAmt);
                int isSummaryRow = rs.getInt("fIsSummaryRow");
                if (isSummaryRow == 1) {
                    rowData.put("fDescription", sumLbl);
                    unSettledBalance = BigDecimal.ZERO;
                    continue;
                }
                billKind = rs.getString("fBillKind");
                if (billKind.startsWith("0")) {
                    if (arUnSettledAmt == null) {
                        arUnSettledAmt = BigDecimal.ZERO;
                    }
                    unSettledBalance = unSettledBalance.add(arUnSettledAmt);
                    rowData.put("fUnSettledBalance", unSettledBalance);
                } else {
                    if (recUnSettledAmt == null) {
                        recUnSettledAmt = BigDecimal.ZERO;
                    }
                    unSettledBalance = unSettledBalance.subtract(recUnSettledAmt);
                    rowData.put("fUnSettledBalance", unSettledBalance);
                }
                arUnSettledAmtSummary = arUnSettledAmtSummary.add(arUnSettledAmt);
                recUnSettledAmtSummary = recUnSettledAmtSummary.add(recUnSettledAmt);
            }
            Map<String, BigDecimal> summaryData = new HashMap<String, BigDecimal>();
            summaryData.put("fArUnSettledAmt", arUnSettledAmtSummary);
            summaryData.put("fRecUnSettledAmt", recUnSettledAmtSummary);
            summaryData.put("fUnSettledBalance", arUnSettledAmtSummary.subtract(recUnSettledAmtSummary));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("currentPageSummaryData", ((HashMap)summaryData).clone());
            summaryData = ArApBillUtil.getSummaryData4TempTable(ctx, tempTable, new String[]{"fArUnSettledAmt", "fRecUnSettledAmt"}, " fIsSummaryRow = 0");
            if (summaryData.get("fArUnSettledAmt") != null && summaryData.get("fRecUnSettledAmt") != null) {
                summaryData.put("fUnSettledBalance", ((BigDecimal)summaryData.get("fArUnSettledAmt")).subtract((BigDecimal)summaryData.get("fRecUnSettledAmt")));
            }
            result.put("allPageSummaryData", summaryData);
            result.put("gridData", gridData);
            result.put("tempTable", tempTable);
            result.put("asstActTempTable", param.getCussAcctTempTable());
            result.put("totalRowCount", totalRowCount);
            result.put("prevUnSettledBalance", unSettledBalance);
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tempTableName) throws BOSException {
        TempTableUtil.releasTempTable(ctx, tempTableName);
    }

    private String createTempTable(Context ctx, UnSettledDetailRptParam param) throws BOSException, EASBizException {
        String tempTable = param.getTempTable();
        if (!StringUtils.isEmpty((String)tempTable)) {
            TempTableUtil.releasTempTable(ctx, tempTable);
            TempTableUtil.releasTempTable(ctx, param.getCussAcctTempTable());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(" KSQL_SEQ INT IDENTITY (1, 1) NOT NULL ").append(",fCurrencyId varchar(44)").append(",fCurrencyName nvarchar(255)").append(",fCompanyId varchar(44)").append(",fCompanyName nvarchar(255)").append(",fAsstActNumber nvarchar(80)").append(",fAsstActName nvarchar(255)").append(",fDepartmentName nvarchar(255)").append(",fPersonName nvarchar(255)").append(",fBillDate dateTime").append(",fBillKind nvarchar(20)").append(",fBillTypeName nvarchar(80)").append(",fBillNumber nvarchar(80)").append(",fDescription nvarchar(255)").append(",fArUnSettledAmt NUMERIC(17,4)").append(",fRecUnSettledAmt NUMERIC(17,4)").append(",fIsSummaryRow int").append(",fBillId varchar(44)");
        sb.append(")");
        tempTable = TempTableUtil.createTempTable(ctx, sb.toString());
        if (param.getCompanyIds() instanceof List) {
            ArApReportHelper.getCussAcctTempTbl(ctx, param, param.getCompanyIds());
        } else {
            ArApReportHelper.getCussAcctTempTbl(ctx, param, Arrays.asList(param.getCompanyIds()));
        }
        String fieldSql = " fCurrencyId, fCurrencyName,fCompanyId, fCompanyName, fAsstActNumber, fAsstActName, fDepartmentName, fPersonName, fBillDate, fBillKind, fBillTypeName, fBillNumber, fDescription, fArUnSettledAmt, fRecUnSettledAmt, fIsSummaryRow, fBillId";
        sb = new StringBuffer();
        sb.append("insert into ").append(tempTable).append(" (KSQL_SEQ, ").append(fieldSql).append(")").append(CR);
        String locale = ctx.getLocale().toString();
        sb.append("select ").append(fieldSql).append(" from (").append(CR);
        int statisticsObject = param.getStatisticsObject();
        if (statisticsObject == 0 || statisticsObject == 2) {
            sb.append(this.getArapInsertSql(param, locale)).append(CR);
        }
        if (statisticsObject == 2) {
            sb.append(" union all").append(CR);
        }
        if (statisticsObject == 1 || statisticsObject == 2) {
            sb.append(this.getRecPayInsertSql(param, locale)).append(CR);
        }
        sb.append(") temp ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        StringBuffer groupBySb = new StringBuffer();
        if (param.isSummaryByCurrency()) {
            if (groupBySb.length() > 0) {
                groupBySb.append(", ");
            }
            groupBySb.append("fCurrencyName");
        }
        if (param.isSummaryByAsstAct()) {
            if (groupBySb.length() > 0) {
                groupBySb.append(", ");
            }
            groupBySb.append("fAsstActNumber,fAsstActName");
        }
        if (param.isSummaryByDepartment()) {
            if (groupBySb.length() > 0) {
                groupBySb.append(", ");
            }
            groupBySb.append("fDepartmentName");
        }
        if (param.isSummaryByPerson()) {
            if (groupBySb.length() > 0) {
                groupBySb.append(", ");
            }
            groupBySb.append("fPersonName");
        }
        sb = new StringBuffer();
        sb.append("insert into ").append(tempTable).append(" (KSQL_SEQ, fIsSummaryRow, ").append(groupBySb).append(", fArUnSettledAmt, fRecUnSettledAmt").append(")");
        sb.append("select 1 as fIsSummaryRow, ").append(groupBySb).append(", sum(fArUnSettledAmt) as fArUnSettledAmt, sum(fRecUnSettledAmt) as fRecUnSettledAmt").append(" from ").append(tempTable).append(" group by ").append(groupBySb);
        DbUtil.execute((Context)ctx, (String)sb.toString());
        return tempTable;
    }

    private String getArapInsertSql(UnSettledDetailRptParam param, String locale) {
        String tableName = param.isArRpt() ? "T_AR_OtherBill" : "T_AP_OtherBill";
        String[] billTypeArr = param.getArapBillType();
        int billTypeFirstNum = param.isArRpt() ? 1 : 2;
        HashMap billTypeMap = new HashMap(){
            {
                this.put("101", OtherBillTypeEnum.getEnum((int)101).getAlias());
                this.put("102", OtherBillTypeEnum.getEnum((int)102).getAlias());
                this.put("103", OtherBillTypeEnum.getEnum((int)103).getAlias());
                this.put("104", OtherBillTypeEnum.getEnum((int)104).getAlias());
                this.put("201", OtherBillType.getEnum((int)201).getAlias());
                this.put("202", OtherBillType.getEnum((int)202).getAlias());
                this.put("203", OtherBillType.getEnum((int)203).getAlias());
                this.put("204", OtherBillType.getEnum((int)204).getAlias());
            }
        };
        String[] strArr = null;
        String str = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select head.fCurrencyId AS fCurrencyId").append(CR).append(", currency.fName_").append(locale).append(" AS fCurrencyName").append(CR).append(", head.fCompanyId AS fCompanyId").append(CR).append(", orgUnit.fName_").append(locale).append(" AS fCompanyName").append(CR).append(", asstAct.fNumber AS fAsstActNumber").append(CR).append(", asstAct.fName AS fAsstActName").append(CR).append(", department.fName_").append(locale).append(" AS fDepartmentName").append(CR).append(", person.fName_").append(locale).append(" AS fPersonName").append(CR).append(", head.fBillDate AS fBillDate").append(CR).append(", to_char(concat('0', head.fBillType)) AS fBillKind").append(CR).append(", case head.fBillType ").append(" when ").append(billTypeFirstNum).append("01").append(" then N'").append(billTypeMap.get(billTypeFirstNum + "01").toString()).append("'").append(CR).append(" when ").append(billTypeFirstNum).append("02").append(" then N'").append(billTypeMap.get(billTypeFirstNum + "02").toString()).append("'").append(CR).append(" when ").append(billTypeFirstNum).append("03").append(" then N'").append(billTypeMap.get(billTypeFirstNum + "03").toString()).append("'").append(CR).append(" when ").append(billTypeFirstNum).append("04").append(" then N'").append(billTypeMap.get(billTypeFirstNum + "04").toString()).append("'").append(CR).append(" end AS fBillTypeName").append(CR).append(", head.fNumber AS fBillNumber").append(CR).append(", head.fDescription AS fDescription").append(CR).append(", head.fUnVerifyAmount AS fArUnSettledAmt").append(CR).append(", 0 AS fRecUnSettledAmt").append(CR).append(", 0 AS fIsSummaryRow").append(CR).append(", head.fid AS fBillId").append(CR).append(" from ").append(tableName).append(" AS head").append(CR).append(" inner join T_BD_Currency AS currency on head.fCurrencyId = currency.fid").append(CR).append(" inner join T_BD_PaymentType AS paymentType on head.fPaymentTypeId = paymentType.fid").append(CR).append(" left outer join T_ORG_Admin AS department on head.fAdminOrgUnitId = department.fid").append(CR).append(" left outer join T_BD_Person AS person on head.fPersonId = person.fid").append(CR).append(" left outer join T_ORG_BaseUnit AS orgUnit on head.fCompanyId = orgUnit.fid").append(CR).append(" inner join ").append(param.getCussAcctTempTable()).append(" AS asstAct on head.fAsstActID = asstAct.fid").append(CR).append(" where head.fCompanyId in ('").append(CollectionUtil.join(param.getCompanyIds(), "','")).append("')").append(CR).append(" and head.fUnVerifyAmount != 0").append(" and head.fBillStatus = ").append(3).append(CR).append(" and head.fBillDate >= {d'").append(new Date(param.getBillDateFrom().getTime())).append("'}").append(CR).append(" and head.fBillDate <= {d'").append(new Date(param.getBillDateTo().getTime())).append("'}").append(CR).append(" and head.fAsstActTypeId = '").append(param.getCussTypeId()).append("'").append(CR).append(" and head.fAsstActID in (select fid from ").append(param.getCussAcctTempTable()).append(")").append(CR);
        if (param.getCurrencyId() != null && !param.getCurrencyId().equals("all")) {
            sb.append(" and head.fCurrencyId = '").append(param.getCurrencyId()).append("'").append(CR);
        }
        if (param.getCussAcctFromIds() != null) {
            sb.append(" and asstAct.fid in ('").append(CollectionUtil.join(param.getCussAcctFromIds(), "','")).append("')").append(CR);
        } else {
            if (param.getCussAcctFromNum() != null) {
                str = param.getCussAcctFromNum();
                sb.append(" and asstAct.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getCussAcctToNum() != null) {
                str = param.getCussAcctToNum();
                sb.append(" and asstAct.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (param.getAdminOrgUnitIds() != null) {
            strArr = param.getAdminOrgUnitIds();
            sb.append(" and department.fid in ('").append(CollectionUtil.join(strArr, "','")).append("')").append(CR);
        } else {
            if (param.getAdminOrgUnitNumberFrom() != null) {
                str = param.getAdminOrgUnitNumberFrom();
                sb.append(" and department.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getAdminOrgUnitNumberTo() != null) {
                str = param.getAdminOrgUnitNumberTo();
                sb.append(" and department.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (param.getBizPersonIds() != null) {
            strArr = param.getBizPersonIds();
            sb.append(" and person.fid in ('").append(CollectionUtil.join(strArr, "','")).append("')").append(CR);
        } else {
            if (param.getBizPersonNumberFrom() != null) {
                str = param.getBizPersonNumberFrom();
                sb.append(" and person.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getBizPersonNumberTo() != null) {
                str = param.getBizPersonNumberTo();
                sb.append(" and person.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (billTypeArr != null) {
            String billTypeSql = CollectionUtil.join(billTypeArr, ",");
            sb.append(" and head.fBillType in (").append(billTypeSql).append(")").append(CR);
        }
        if (param.isIncludeBizBill()) {
            if (param.isBizBillOnly()) {
                sb.append(" and head.fIsBizBill = 1").append(CR);
            }
        } else {
            sb.append(" and head.fIsBizBill = 0").append(CR);
        }
        if (param.isCash()) {
            if (param.isCashOnly()) {
                sb.append(" and paymentType.fNumber in ('001', '003')").append(CR);
            }
        } else {
            sb.append(" and paymentType.fNumber not in ('001', '003')").append(CR);
        }
        return sb.toString();
    }

    private String getRecPayInsertSql(UnSettledDetailRptParam param, String locale) {
        String tableName = param.isArRpt() ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill";
        int billStatus = param.isArRpt() ? 14 : 15;
        String billTypeTableName = param.isArRpt() ? "T_CAS_ReceivingBillType" : "T_CAS_PaymentBillType";
        String billTypeFieldName = param.isArRpt() ? "FRecBillTypeID" : "FPayBillTypeID";
        String asstActTypeFieldName = param.isArRpt() ? "fpayerTypeId" : "fpayeeTypeId";
        String asstActFieldName = param.isArRpt() ? "fpayerID" : "fpayeeID";
        String[] strArr = null;
        String str = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select head.fCurrencyId AS fCurrencyId").append(CR).append(", currency.fName_").append(locale).append(" AS fCurrencyName").append(CR).append(", head.fCompanyId AS fCompanyId").append(CR).append(", orgUnit.fName_").append(locale).append(" AS fCompanyName").append(CR).append(", asstAct.fNumber AS fAsstActNumber").append(CR).append(", asstAct.fName AS fAsstActName").append(CR).append(", department.fName_").append(locale).append(" AS fDepartmentName").append(CR).append(", person.fName_").append(locale).append(" AS fPersonName").append(CR).append(", head.fBizDate AS fBillDate").append(CR).append(", to_char(concat('1',billType.fNumber)) AS fBillKind").append(CR).append(", billType.fName_").append(locale).append(" AS fBillTypeName").append(CR).append(", head.fNumber AS fBillNumber").append(CR).append(", head.fDescription AS fDescription").append(CR).append(", 0 AS fArUnSettledAmt").append(CR).append(", head.fUnVerifiedAmt AS fRecUnSettledAmt").append(CR).append(", 0 AS fisSummaryRow").append(CR).append(", head.fid AS fBillId").append(CR).append(" from ").append(tableName).append(" AS head").append(CR).append(" inner join T_BD_Currency AS currency on head.fCurrencyId = currency.fid").append(CR).append(" inner join T_BD_PaymentType AS paymentType on head.fPaymentTypeId = paymentType.fid").append(CR).append(" left outer join T_ORG_Admin AS department on head.fAdminOrgUnitId = department.fid").append(CR).append(" left outer join T_BD_Person AS person on head.fPersonId = person.fid").append(CR).append(" left outer join T_ORG_BaseUnit AS orgUnit on head.fCompanyId = orgUnit.fid").append(CR).append(" inner join ").append(billTypeTableName).append(" AS billType on head.").append(CR).append(billTypeFieldName).append(" = billType.fid").append(CR).append(" inner join ").append(param.getCussAcctTempTable()).append(" AS asstAct on head.").append(asstActFieldName).append(" = asstAct.fid").append(CR).append(" where head.fCompanyId in ('").append(CollectionUtil.join(param.getCompanyIds(), "','")).append("')").append(CR).append(" and head.fUnVerifiedAmt != 0").append(" and head.fBillStatus = ").append(billStatus).append(CR).append(" and head.fBizDate >= {d'").append(new Date(param.getBillDateFrom().getTime())).append("'}").append(CR).append(" and head.fBizDate <= {d'").append(new Date(param.getBillDateTo().getTime())).append("'}").append(CR).append(" and head.").append(asstActTypeFieldName).append(" = '").append(param.getCussTypeId()).append("'").append(CR).append(" and head.").append(asstActFieldName).append(" in (select fid from ").append(param.getCussAcctTempTable()).append(")").append(CR);
        if (param.getCurrencyId() != null && !param.getCurrencyId().equals("all")) {
            sb.append(" and head.fCurrencyId = '").append(param.getCurrencyId()).append("'").append(CR);
        }
        if (param.getCussAcctFromIds() != null) {
            sb.append(" and asstAct.fid in ('").append(CollectionUtil.join(param.getCussAcctFromIds(), "','")).append("')").append(CR);
        } else {
            if (param.getCussAcctFromNum() != null) {
                str = param.getCussAcctFromNum();
                sb.append(" and asstAct.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getCussAcctToNum() != null) {
                str = param.getCussAcctToNum();
                sb.append(" and asstAct.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (param.getAdminOrgUnitIds() != null) {
            strArr = param.getAdminOrgUnitIds();
            sb.append(" and department.fid in ('").append(CollectionUtil.join(strArr, "','")).append("')").append(CR);
        } else {
            if (param.getAdminOrgUnitNumberFrom() != null) {
                str = param.getAdminOrgUnitNumberFrom();
                sb.append(" and department.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getAdminOrgUnitNumberTo() != null) {
                str = param.getAdminOrgUnitNumberTo();
                sb.append(" and department.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (param.getBizPersonIds() != null) {
            strArr = param.getBizPersonIds();
            sb.append(" and person.fid in ('").append(CollectionUtil.join(strArr, "','")).append("')").append(CR);
        } else {
            if (param.getBizPersonNumberFrom() != null) {
                str = param.getBizPersonNumberFrom();
                sb.append(" and person.fNumber >= '").append(str).append("'").append(CR);
            }
            if (param.getBizPersonNumberTo() != null) {
                str = param.getBizPersonNumberTo();
                sb.append(" and person.fNumber <= '").append(str).append("'").append(CR);
            }
        }
        if (param.getRecBillType() != null) {
            sb.append(" and head.").append(billTypeFieldName).append(" in ('").append(CollectionUtil.join(param.getRecBillType(), "','")).append("')").append(CR);
        }
        if (param.isCash()) {
            if (param.isCashOnly()) {
                sb.append(" and paymentType.fNumber in ('001', '003')").append(CR);
            }
        } else {
            sb.append(" and paymentType.fNumber not in ('001', '003')").append(CR);
        }
        return sb.toString();
    }
}

