/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.RecDeleteService;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.util.StringUtil;
import java.util.HashSet;

public class ArRecDeleteService
extends RecDeleteService {
    protected boolean isHasValue = false;

    private ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, IObjectPK pk, ReceivingBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.pk = pk;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
    }

    public void beforeDelete() throws EASBizException, BOSException {
        super.beforeDelete();
        String tableName = "T_CAS_ReceivingBillEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = this.info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (this.info.getEntries().get(i) == null) continue;
            idSet.add(this.info.getEntries().get(i).getId().toString());
        }
        if (ArApRecPayServerHelper.isExistsBizFlowField((Context)this.ctx, (String)tableName) && ArApRecPayServerHelper.isHasBizFlowValue((Context)this.ctx, (String)tableName, idSet)) {
            this.isHasValue = true;
        }
        if (!this.info.isIsInitializeBill() && !this.info.isIsTransBill()) {
            ArApRecPayServerHelper.injectBizFlow((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.DELETE);
        }
        if (this.isHasValue) {
            HashSet<String> sourceIDSet = new HashSet<String>();
            for (int i = 0; i < this.info.getEntries().size(); ++i) {
                ReceivingBillEntryInfo recEntryInfo = this.info.getEntries().get(i);
                if (StringUtil.isEmpty((String)recEntryInfo.getSourceBillId())) continue;
                sourceIDSet.add(recEntryInfo.getSourceBillId().toString());
            }
            ArApBillReverseHelper.reversePlanAmount(this.ctx, true, sourceIDSet);
        }
        if (!this.isHasValue) {
            this.writeBackInitBill(this.ctx, this.info);
        }
    }

    public void afterDelete() throws EASBizException, BOSException {
        super.afterDelete();
    }

    private void writeBackInitBill(Context ctx, ReceivingBillInfo info) throws BOSException {
        try {
            if (info != null && info.isIsInitializeBill() && BillStatusEnum.SUBMIT == info.getBillStatus()) {
                String disposerName = "com.kingdee.eas.scm.sd.sale.SaleOrderDisposer";
                IReceivingDisposer disposer = (IReceivingDisposer)Class.forName(disposerName).newInstance();
                BillDisposerAction disposerAction = new BillDisposerAction();
                disposerAction.setDestBill((CoreBaseInfo)info);
                disposerAction.setActionType(DisposerActionEnum.CANCEL_REC);
                disposer.dispose(ctx, disposerAction);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

