/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.fi.ar.app.util.ArApSwapSQLHelper;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ArApSwapUtils {
    public static final int LEN = 10000;

    public static void swapBeforeEndDate(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_VerTable, String temp_TranTable, Date curEndDate, boolean isRec) throws BOSException, SQLException {
        ArApSwapUtils.updateZeroData(ctx, temp_SwapBill, temp_SwapBillEntry, curEndDate, isRec);
        ArApSwapUtils.updateNotZeroData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, isRec);
    }

    private static void updateZeroData(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, Date curEndDate, boolean isRec) {
        if (isRec) {
            ArApSwapUtils.updateZeroMethod(ctx, temp_SwapBill, curEndDate, "ar", isRec);
            ArApSwapUtils.updateZeroMethod(ctx, temp_SwapBill, curEndDate, "rec", isRec);
        } else {
            ArApSwapUtils.updateZeroMethod(ctx, temp_SwapBill, curEndDate, "ap", isRec);
            ArApSwapUtils.updateZeroMethod(ctx, temp_SwapBill, curEndDate, "pay", isRec);
        }
    }

    private static void updateNotZeroData(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_VerTable, String temp_TranTable, Date curEndDate, boolean isRec) throws BOSException, SQLException {
        if (isRec) {
            ArApSwapUtils.updateNotZeroMethod(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, "ar", isRec);
            ArApSwapUtils.updateNotZeroMethod(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, "rec", isRec);
        } else {
            ArApSwapUtils.updateNotZeroMethod(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, "ap", isRec);
            ArApSwapUtils.updateNotZeroMethod(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, "pay", isRec);
        }
    }

    private static void updateOtherBillSQL(Context ctx, boolean isDirMode, List paramsBillList, boolean isZero, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append("T_" + (isRec ? "AR" : "AP") + "_OtherBill").append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (isZero) {
            strBuf.append("FUnVerifyAmountLocal=0,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        } else if (isDirMode) {
            strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount*?,").append("\r\n");
        } else {
            strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount/?,").append("\r\n");
        }
        strBuf.append("FLastExhangeRate=?").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FID=?;").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsBillList);
    }

    private static void updateOtherBillEntrySQL(Context ctx, boolean isDirMode, List paramsEntryList, boolean isZero, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append("T_" + (isRec ? "AR" : "AP") + "_OtherBillentry").append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (isZero) {
            strBuf.append("FUnVerifyAmountLocal=0,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
            strBuf.append("FLockUnVerifyAmtLocal=0--\u672a\u9501\u5b9a\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FParentID =?;").append("\r\n");
        } else {
            strBuf.append("FVerifyAmountLocal=?,").append("\r\n");
            if (isDirMode) {
                strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount*?,").append("\r\n");
                strBuf.append("FLockUnVerifyAmtLocal=FLockUnVerifyAmt*?").append("\r\n");
            } else {
                strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount/?,").append("\r\n");
                strBuf.append("FLockUnVerifyAmtLocal=FLockUnVerifyAmt/?").append("\r\n");
            }
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FParentID=?").append("\r\n");
            strBuf.append("AND FID=?;").append("\r\n");
        }
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsEntryList);
    }

    private static void updateRecPayBillSQL(Context ctx, boolean isDirMode, List paramsBillList, boolean isZero, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append("T_CAS_" + (isRec ? "ReceivingBill" : "PaymentBill")).append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (isZero) {
            strBuf.append("FUnVerifiedAmtLoc=0,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        } else if (isDirMode) {
            strBuf.append("FUnVerifiedAmtLoc=FUnVerifiedAmt*?,").append("\r\n");
        } else {
            strBuf.append("FUnVerifiedAmtLoc=FUnVerifiedAmt/?,").append("\r\n");
        }
        strBuf.append("FLastExhangeRate=?").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FID=?;").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsBillList);
    }

    private static void updateRecPayBillEntrySQL(Context ctx, boolean isDirMode, List paramsEntryList, boolean isZero, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append("T_CAS_" + (isRec ? "ReceivingBill" : "PaymentBill") + "Entry").append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (isZero) {
            strBuf.append("FUnVcLocAmount=0,--\u672a\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
            strBuf.append("FUnLockLocAmt=0--\u672a\u9501\u5b9a\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND " + (isRec ? "FReceivingBillID" : "FPaymentBillID") + "=?").append("\r\n");
        } else {
            strBuf.append("FLocalAmtVc=?,").append("\r\n");
            if (isDirMode) {
                strBuf.append("FUnVcLocAmount=FUnVcAmount*?,").append("\r\n");
                strBuf.append("FUnLockLocAmt=FUnLockAmt*?").append("\r\n");
            } else {
                strBuf.append("FUnVcLocAmount=FUnVcAmount/?,").append("\r\n");
                strBuf.append("FUnLockLocAmt=FUnLockAmt/?").append("\r\n");
            }
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND " + (isRec ? "FReceivingBillID" : "FPaymentBillID") + "=?").append("\r\n");
            strBuf.append("AND FID=?;").append("\r\n");
        }
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsEntryList);
    }

    private static void updateSwapTempBillSQL(Context ctx, boolean isDirMode, String temp_SwapBill, List paramsTempList) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append(temp_SwapBill).append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (isDirMode) {
            strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount*?").append("\r\n");
        } else {
            strBuf.append("FUnVerifyAmountLocal=FUnVerifyAmount/?").append("\r\n");
        }
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FBillID=?;").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsTempList);
    }

    private static void updateSwapTempEntrySQL(Context ctx, String temp_SwapBillEntry, List paramsTempEntryList) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("UPDATE").append("\r\n");
        strBuf.append(temp_SwapBillEntry).append("\r\n");
        strBuf.append("SET").append("\r\n");
        strBuf.append("FAmtLocalAfter=?,").append("\r\n");
        strBuf.append("FRateGainLoss=?").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FBillID=?").append("\r\n");
        strBuf.append("AND FEntryID=?;").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsTempEntryList);
    }

    public static void updateData(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_VerTable, String temp_TranTable, Date curEndDate, String billClass, boolean isDirMode, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("bill.FBillID,--\u5355\u636eID").append("\r\n");
        strBuf.append("bill.FSwapRateAfter,--\u6700\u540e\u8c03\u6c47\u6c47\u7387").append("\r\n");
        strBuf.append("entry.FEntryID,--\u5206\u5f55ID").append("\r\n");
        strBuf.append("ISNULL(entry.FVerifyAmountLocal, 0) + ISNULL(verEntry.FThisVerificateAmtLoc, 0) + ISNULL(tranTableA.FSwapAmtUnVcLocal, 0) - ISNULL(tranTableB.FSwapAmtVcLocal, 0) verifyAmountLocal,--\u5df2\u7ed3\u7b97\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("entry.FAmount,--\u91d1\u989d\u539f\u5e01(\u672a\u7ed3\u7b97\u91d1\u989d)").append("\r\n");
        strBuf.append("entry.FAmtLocalBefore,--\u8c03\u6c47\u524d\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("entry.FConvertMode--\u6298\u7b97\u65b9\u5f0f").append("\r\n");
        strBuf.append("FROM " + temp_SwapBill + " bill").append("\r\n");
        strBuf.append("INNER JOIN " + temp_SwapBillEntry + " entry ON entry.FBillID=bill.FBillID").append("\r\n");
        strBuf.append("LEFT JOIN (").append("\r\n");
        strBuf.append("SELECT FBillID, FEntryID, SUM(FThisVerificateAmtLoc) FThisVerificateAmtLoc").append("\r\n");
        strBuf.append("FROM " + temp_VerTable).append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("GROUP BY FBillID,FEntryID").append("\r\n");
        strBuf.append(") verEntry ON verEntry.FBillID=entry.FBillID AND verEntry.FEntryID=entry.FEntryID").append("\r\n");
        strBuf.append("LEFT JOIN (").append("\r\n");
        strBuf.append("SELECT FSourceBillId, FSourceBillEntryId, SUM(FSwapAmtUnVcLocal) FSwapAmtUnVcLocal").append("\r\n");
        strBuf.append("FROM " + temp_TranTable).append("\r\n");
        strBuf.append("WHERE FAmtLocal>=0").append("\r\n");
        strBuf.append("GROUP BY FSourceBillId, FSourceBillEntryId").append("\r\n");
        strBuf.append(") tranTableA ON tranTableA.FSourceBillId=entry.FBillID AND tranTableA.FSourceBillEntryId=entry.FEntryID").append("\r\n");
        strBuf.append("LEFT JOIN (").append("\r\n");
        strBuf.append("SELECT FSourceBillId, FSourceBillEntryId, SUM(FSwapAmtVcLocal) FSwapAmtVcLocal").append("\r\n");
        strBuf.append("FROM " + temp_TranTable).append("\r\n");
        strBuf.append("WHERE FAmtLocal<0").append("\r\n");
        strBuf.append("GROUP BY FSourceBillId, FSourceBillEntryId").append("\r\n");
        strBuf.append(") tranTableB ON tranTableB.FSourceBillId=entry.FBillID AND tranTableB.FSourceBillEntryId=entry.FEntryID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND entry.FAmount<>0").append("\r\n");
        strBuf.append("AND bill.FBillClass='" + billClass + "'").append("\r\n");
        strBuf.append("AND bill.FBillDate<={d '" + curEndDate + "'}").append("\r\n");
        if (isDirMode) {
            strBuf.append("AND entry.FConvertMode=0 OR entry.FConvertMode IS NULL").append("\r\n");
        } else {
            strBuf.append("AND entry.FConvertMode<>0 AND entry.FConvertMode IS NOT NULL").append("\r\n");
        }
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            ArrayList<Object[]> paramsBillList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsEntryList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsTempList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsTempEntryList = new ArrayList<Object[]>();
            while (rs.next()) {
                String billID = rs.getString("FBillID");
                String entryID = rs.getString("FEntryID");
                BigDecimal swapRateAfter = rs.getBigDecimal("FSwapRateAfter");
                BigDecimal amount = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("FAmount"));
                BigDecimal verifyAmountLocal = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("verifyAmountLocal"));
                BigDecimal amtLocalBefore = UIRuleUtil.getBigDecimal((Object)rs.getBigDecimal("FAmtLocalBefore"));
                int convertMode = UIRuleUtil.getIntValue((Object)rs.getObject("FConvertMode"));
                paramsBillList.add(new Object[]{swapRateAfter, swapRateAfter, billID});
                paramsEntryList.add(new Object[]{verifyAmountLocal, swapRateAfter, swapRateAfter, billID, entryID});
                paramsTempList.add(new Object[]{swapRateAfter, billID});
                BigDecimal amtLocalAfter = BigDecimal.ZERO;
                amtLocalAfter = convertMode == 0 ? amount.multiply(swapRateAfter) : amount.divide(swapRateAfter, 2, 4);
                BigDecimal lossAndGain = amtLocalAfter.subtract(amtLocalBefore);
                paramsTempEntryList.add(new Object[]{amtLocalAfter, lossAndGain, billID, entryID});
            }
            if (billClass.equals("ar") || billClass.equals("ap")) {
                ArApSwapUtils.updateOtherBillSQL(ctx, isDirMode, paramsBillList, false, isRec);
                ArApSwapUtils.updateOtherBillEntrySQL(ctx, isDirMode, paramsEntryList, false, isRec);
            } else if (billClass.equals("rec") || billClass.equals("pay")) {
                ArApSwapUtils.updateRecPayBillSQL(ctx, isDirMode, paramsBillList, false, isRec);
                ArApSwapUtils.updateRecPayBillEntrySQL(ctx, isDirMode, paramsEntryList, false, isRec);
            }
            ArApSwapUtils.updateSwapTempBillSQL(ctx, isDirMode, temp_SwapBill, paramsTempList);
            ArApSwapUtils.updateSwapTempEntrySQL(ctx, temp_SwapBillEntry, paramsTempEntryList);
            start = ++count * len + 1;
        }
    }

    public static void updateNotZeroMethod(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, String temp_VerTable, String temp_TranTable, Date curEndDate, String billClass, boolean isRec) throws BOSException, SQLException {
        ArApSwapUtils.updateData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, billClass, true, isRec);
        ArApSwapUtils.updateData(ctx, temp_SwapBill, temp_SwapBillEntry, temp_VerTable, temp_TranTable, curEndDate, billClass, false, isRec);
    }

    public static void updateZeroMethod(Context ctx, String temp_SwapBill, Date curEndDate, String billClass, boolean isRec) {
        try {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("SELECT ").append("\r\n");
            strBuf.append("bill.FBillID,--\u5355\u636eID").append("\r\n");
            strBuf.append("bill.FSwapRateAfter--\u6700\u540e\u8c03\u6c47\u6c47\u7387").append("\r\n");
            strBuf.append("FROM " + temp_SwapBill + " bill").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND bill.FUnVerifyAmount=0").append("\r\n");
            strBuf.append("AND bill.FBillClass='" + billClass + "'").append("\r\n");
            strBuf.append("AND bill.FBillDate<={d '" + curEndDate + "'}").append("\r\n");
            RptRowSet rs = null;
            int start = 0;
            int len = 10000;
            int count = 0;
            while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
                ArrayList<Object[]> paramsBillList = new ArrayList<Object[]>();
                ArrayList<Object[]> paramsEntryList = new ArrayList<Object[]>();
                while (rs.next()) {
                    String billID = rs.getString("FBillID");
                    BigDecimal swapRateAfter = rs.getBigDecimal("FSwapRateAfter");
                    paramsBillList.add(new Object[]{swapRateAfter, billID});
                    paramsEntryList.add(new Object[]{billID});
                }
                if (billClass.equals("ar") || billClass.equals("ap")) {
                    ArApSwapUtils.updateOtherBillSQL(ctx, true, paramsBillList, true, isRec);
                    ArApSwapUtils.updateOtherBillEntrySQL(ctx, true, paramsEntryList, true, isRec);
                } else if (billClass.equals("rec") || billClass.equals("pay")) {
                    ArApSwapUtils.updateRecPayBillSQL(ctx, true, paramsBillList, true, isRec);
                    ArApSwapUtils.updateRecPayBillEntrySQL(ctx, true, paramsEntryList, true, isRec);
                }
                start = ++count * len + 1;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateProxyBill(Context ctx, String temp_SwapBill, String temp_SwapBillEntry, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("SELECT ").append("\r\n");
        strBuf.append("billEntry.FSourceBillEntryId,--\u6765\u6e90\u5355\u636e\u5206\u5f55ID").append("\r\n");
        strBuf.append("swapBill.FSwapRateAfter,--\u8c03\u6c47\u540e\u6c47\u7387").append("\r\n");
        strBuf.append("swapBillEntry.FAmtLocalAfter--\u8c03\u6c47\u540e\u91d1\u989d\u672c\u4f4d\u5e01").append("\r\n");
        strBuf.append("FROM T_" + (isRec ? "AR" : "AP") + "_OtherBillEntry billEntry").append("\r\n");
        strBuf.append("INNER JOIN " + temp_SwapBill + " swapBill ON swapBill.FBillID=billEntry.FParentID").append("\r\n");
        strBuf.append("INNER JOIN " + temp_SwapBillEntry + " swapBillEntry ON swapBillEntry.FBillID=swapBill.FBillID AND swapBillEntry.FEntryID=billEntry.FID").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND swapBillEntry.FBillClass='" + (isRec ? "ar" : "ap") + "'").append("\r\n");
        RptRowSet rs = null;
        int start = 0;
        int len = 10000;
        int count = 0;
        while ((rs = ArApSwapSQLHelper.executeQuery(ctx, strBuf.toString(), null, start, len)).getRowCount() != 0) {
            ArrayList<Object[]> paramsBillList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramsEntryList = new ArrayList<Object[]>();
            while (rs.next()) {
                ObjectUuidPK pk;
                String sourceBillEntryId = UIRuleUtil.getString((Object)rs.getObject("FSourceBillEntryId"));
                if ("".equals(sourceBillEntryId) || !"B9C098D2".equals(UIRuleUtil.getString((Object)(pk = new ObjectUuidPK(sourceBillEntryId)).getObjectType()))) continue;
                BigDecimal swapRateAfter = UIRuleUtil.getBigDecimal((Object)rs.getObject("FSwapRateAfter"));
                BigDecimal amtLocalAfter = UIRuleUtil.getBigDecimal((Object)rs.getObject("FAmtLocalAfter"));
                if (isRec) {
                    paramsBillList.add(new Object[]{swapRateAfter, sourceBillEntryId});
                    paramsEntryList.add(new Object[]{amtLocalAfter, sourceBillEntryId});
                    continue;
                }
                paramsEntryList.add(new Object[]{swapRateAfter, amtLocalAfter, sourceBillEntryId});
            }
            if (paramsBillList.size() > 0 || paramsEntryList.size() > 0) {
                ArApSwapUtils.updateProxyBillSQL(ctx, paramsBillList, paramsEntryList, isRec);
            }
            start = ++count * len + 1;
        }
    }

    private static void updateProxyBillSQL(Context ctx, List paramsBillList, List paramsEntryList, boolean isRec) throws BOSException {
        StringBuffer strBuf = new StringBuffer();
        if (isRec) {
            strBuf.append("UPDATE ").append("\r\n");
            strBuf.append("T_ARP_ProxyBill").append("\r\n");
            strBuf.append("SET").append("\r\n");
            strBuf.append("FLastExhangeRate=?").append("\r\n");
            strBuf.append("WHERE 1=1").append("\r\n");
            strBuf.append("AND FID=(SELECT FParentID FROM T_ARP_ProxyBillEntry WHERE 1=1 AND FID =?)").append("\r\n");
            DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsBillList);
            strBuf.setLength(0);
        }
        strBuf.append("UPDATE ").append("\r\n");
        strBuf.append("T_ARP_ProxyBillEntry").append("\r\n");
        strBuf.append("SET").append("\r\n");
        if (!isRec) {
            strBuf.append("FPayLastExhangeRate=?,").append("\r\n");
        }
        strBuf.append((isRec ? "FRecUnVerifyAmtL" : "FPayUnVerifyAmtL") + "=?").append("\r\n");
        strBuf.append("WHERE 1=1").append("\r\n");
        strBuf.append("AND FID=?").append("\r\n");
        DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), (List)paramsEntryList);
    }
}

