/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.GregorianCalendar;

public class BaseDataUtil {
    public static final String NULL_REPLACE = "z";
    public static final BigDecimal ZERO = new BigDecimal("0.0");

    public static Date downTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateDown = new Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public static Date upTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + 1);
        Date dateUp = new Date(calendarUp.getTime().getTime());
        return dateUp;
    }

    public static String getNumberFromCodeRule(Context ctx, BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String sysNumber = null;
        String companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)billInfo);
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        }
        return sysNumber;
    }

    public static AsstActTypeInfo getAsstActType(Context ctx, String cpID, String asstHGAttribute) throws BOSException, EASBizException {
        AsstActTypeInfo asstInfo = null;
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection("select *,asstActType.*  where isAccountCussent = 1 and company.id = '" + cpID + "'");
        int count = asstActTypeColl.size();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            if (!asstHGAttribute.equalsIgnoreCase(value.getAsstActType().getAsstHGAttribute())) continue;
            asstInfo = value.getAsstActType();
            break;
        }
        return asstInfo;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, java.util.Date date) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()));
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (company.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = company.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static boolean isDirectExchangeRate(ExchangeRateInfo rateInfo) {
        if (rateInfo == null) {
            return true;
        }
        boolean isDirectExchange = false;
        if (rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = true;
        }
        return isDirectExchange;
    }

    public static BigDecimal caculateLocalAmount(BigDecimal amount, BigDecimal converRate, boolean isDirectExchangeRate, int precision) {
        if (amount == null) {
            return new BigDecimal("0.0");
        }
        if (isDirectExchangeRate) {
            return amount.multiply(converRate).setScale(precision, 4);
        }
        if (converRate.compareTo(ZERO) != 0) {
            return amount.divide(converRate, precision, 4);
        }
        return amount.multiply(converRate).setScale(precision, 4);
    }

    public static PeriodInfo getPeriod(Context ctx, String periodID) throws BOSException, EASBizException {
        if (periodID == null || "".equalsIgnoreCase(periodID)) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(periodID);
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)pk);
    }

    public static String getCurrentAccountTableID(Context ctx, PeriodInfo period, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String companyId = companyInfo.getId().toString();
        String currentAccountTableID = null;
        if (period != null && companyInfo.getAccountTable() != null) {
            currentAccountTableID = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyId, (String)companyInfo.getAccountTable().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        } else if (period == null && companyInfo.getAccountTable() != null) {
            return companyInfo.getAccountTable().getId().toString();
        }
        return currentAccountTableID;
    }

    private static String getBindingProperty() {
        return null;
    }

    public static void rolbackNumber(Context ctx, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)coreBillInfo);
        String strBindProp = BaseDataUtil.getBindingProperty();
        if (strBindProp != null && strBindProp.trim().length() > 0) {
            if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, strCompanyID, strBindProp) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, strCompanyID, strBindProp)) {
                iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, strCompanyID, strBindProp, "", coreBillInfo.getNumber());
            }
        } else if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, strCompanyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, strCompanyID, coreBillInfo.getNumber());
        }
    }
}

