/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.app.web.BillCreateService;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class ARBillCreateService
extends BillCreateService {
    public ARBillCreateService(Context context) {
        super(context);
    }

    @Override
    public int getOrgType() {
        return 1;
    }

    @Override
    public String getPermissionItem() {
        return "fi_ar_ArOtherBill_Add";
    }

    @Override
    public CoreBillBaseInfo createDefaultBill(OrgUnitInfo mainOrg, Map otherInformation) throws EASBizException, BOSException {
        OtherBillInfo info = new OtherBillInfo();
        Date date = null;
        boolean isInitBill = false;
        if (otherInformation != null && otherInformation.containsKey("isInitBill")) {
            isInitBill = (Boolean)otherInformation.get("isInitBill");
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)mainOrg;
        ObjectUuidPK companypk = new ObjectUuidPK(company.getId().toString());
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("cu.number"));
        selCol.add(new SelectorItemInfo("name"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("baseCurrency.id"));
        selCol.add(new SelectorItemInfo("baseExchangeTable.id"));
        selCol.add(new SelectorItemInfo("accountTable.id"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)companypk, selCol);
        ObjectUuidPK currencypk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)currencypk);
        info.setCompany(company);
        info.setCU(company.getCU());
        info.setCurrency(currency);
        if (isInitBill) {
            info.setIsInitializeBill(true);
            BaseService bs = new BaseService(this.getContext());
            date = bs.getBeforeSysDate(true, 12, company.getId().toString());
        } else {
            date = ArApServerUtils.getBizDateBySystem(this.getContext(), true, company);
        }
        info.setExchangeRate(BigDecimal.ONE);
        info.setBillType(OtherBillTypeEnum.InvoiceBill);
        info.setIsInTax(true);
        info.setBillDate(date);
        info.setBizDate(date);
        info.setBillStatus(BillStatusEnum.SAVE);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        ObjectUuidPK userpk = new ObjectUuidPK(this.getContext().getCaller().toString());
        creator = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)userpk);
        info.setCreator(creator);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        ObjectUuidPK pk = new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5");
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)this.getContext());
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)pk);
        info.setPaymentType(paymentTypeInfo);
        info.setAsstActType(this.getAsstActType(company, SystemEnum.ACCOUNTSRECEIVABLE));
        info.setIsInTax(true);
        info.setIsPriceWithoutTax(true);
        info.setSaleOrg(this.getDefaultSaleOrgUnit(company));
        info.setSourceBillType(VerificateBillTypeEnum.OTHER);
        OtherBillPlanInfo recievePlan = new OtherBillPlanInfo();
        recievePlan.setRecievePayDate(date);
        recievePlan.setRecievePayAmount(BigDecimal.ZERO);
        recievePlan.setRecievePayAmountLocal(BigDecimal.ZERO);
        recievePlan.setVerifyAmount(BigDecimal.ZERO);
        recievePlan.setVerifyAmountLocal(BigDecimal.ZERO);
        info.getRecievePlan().add(recievePlan);
        return info;
    }

    protected SaleOrgUnitInfo getDefaultSaleOrgUnit(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        SaleOrgUnitInfo currentPurOrgUnit;
        if (companyOrgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo currentOrgUnit = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)1));
        if (currentOrgUnit != null && currentOrgUnit.isIsCompanyOrgUnit() && currentOrgUnit.getId().toString().equals(companyOrgUnitInfo.getId().toString()) && currentOrgUnit.isIsPurchaseOrgUnit() && (currentPurOrgUnit = (SaleOrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)2))) != null && currentPurOrgUnit.isIsBizUnit()) {
            return currentPurOrgUnit;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isBizUnit"));
        OrgUnitCollection orgUnitColl = (OrgUnitCollection)OtherBillFactory.getLocalInstance(this.getContext()).getFromUnit(companyOrgUnitInfo.getId().toString(), 1, 2, viewInfo);
        int size = orgUnitColl.size();
        for (int i = 0; i < size; ++i) {
            if (!((SaleOrgUnitInfo)orgUnitColl.get(i)).isIsBizUnit()) continue;
            return (SaleOrgUnitInfo)orgUnitColl.get(i);
        }
        return null;
    }
}

