/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFacadeFactory;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.IBaseServiceFacade;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ArApBillService {
    protected abstract boolean isArBill(ArApBillBaseInfo var1);

    protected abstract boolean isAr();

    protected abstract SystemEnum getSysEnum();

    protected abstract Context getContext();

    protected abstract String getPermissionItemByStatus(String var1);

    protected abstract String getOrgFilterByCompany(String var1, int var2) throws EASBizException, BOSException;

    protected abstract String getCostCenterFilter(String var1) throws EASBizException, BOSException;

    protected abstract String getProjectFilter(String var1) throws EASBizException, BOSException;

    protected abstract String getTracknumberFilter(String var1) throws EASBizException, BOSException;

    public Map<String, Object> getUIcache(String companyid, String status, Map otherInformation) throws EASBizException, BOSException {
        Context ctx = this.getContext();
        HashMap<String, Object> map = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = null;
        if (companyid != null && companyid.length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", new Boolean(false));
        ArApBillBaseInfo infoObj = null;
        if (otherInformation != null) {
            infoObj = (ArApBillBaseInfo)otherInformation.get("infoObj");
        }
        ArApBillBaseInfo info = null;
        if (this.isAr()) {
            info = new OtherBillInfo();
            ((AbstractOtherBillInfo)info).getEntry().add(new OtherBillentryInfo());
            if (infoObj != null && infoObj instanceof IncomeConfimBillInfo) {
                info = new IncomeConfimBillInfo();
                ((IncomeConfimBillInfo)info).getEntry().add(new IncomeConfimEntryInfo());
            }
        } else {
            info = new com.kingdee.eas.fi.ap.OtherBillInfo();
            ((com.kingdee.eas.fi.ap.OtherBillInfo)info).getEntry().add(new com.kingdee.eas.fi.ap.OtherBillentryInfo());
        }
        boolean isInitBill = false;
        if (otherInformation != null && otherInformation.containsKey("isInitBill")) {
            isInitBill = (Boolean)otherInformation.get("isInitBill");
        }
        map.put("isInit", isInitBill);
        map.put("permissionItem", this.getPermissionItemByStatus(status));
        map.put("billInfo", info);
        map.put("bosType", new OtherBillInfo().getBOSType());
        ArApSysParamInfo result = ArApBillFacadeFactory.getLocalInstance((Context)ctx).getSysParams(company, map);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", result.getCompany());
        params.put("isImportBillModifiable", result.isImportBillModifiable());
        CurrencyInfo currencyInfo = result.getBaseCurrency();
        if (currencyInfo != null && currencyInfo.getPrecision() == 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("precision"));
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId().toString()), selector);
        }
        params.put("baseCurrency", currencyInfo);
        params.put("currentAccountTableID", result.getCurrentAccountTableID());
        params.put("apSystemStatus", result.getSysStatus(SystemEnum.ACCOUNTSPAYABLE));
        params.put("arSystemStatus", result.getSysStatus(SystemEnum.ACCOUNTSRECEIVABLE));
        params.put("imSystemStatus", result.getSysStatus(SystemEnum.INVENTORYMANAGEMENT));
        params.put("paramValue", result.getParamValueMap());
        params.put("currentPeriod", result.getCurrentPeriod(null));
        params.put("CUId", result.getCUId());
        params.put("isRelationSCM", result.isRelationSCM());
        params.put("defaultAsstActType", result.getDefaultAsstActType());
        StringBuffer sb = new StringBuffer();
        sb.append(" select FPayConditionID from T_BD_PayConditionReference ");
        sb.append("where (FAssignCompanyID = '");
        sb.append(companyid);
        sb.append("') ");
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                set.add("'" + rs.getString("FPayConditionID") + "'");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)result.getCompany().getId().toString(), CompareType.EQUALS));
        if (set.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INNER));
            filter.setMaskString("#0 OR #1");
        }
        params.put("payConditionFilter", filter.toString());
        if (this.isAr()) {
            params.put("saleOrg2CompanyFilter", this.getOrgFilterByCompany(companyid, 2));
        } else {
            params.put("purOrg2CompanyFilter", this.getOrgFilterByCompany(companyid, 3));
        }
        filter = new FilterInfo();
        AsstActTypeCollection col = result.getAsstActTypeColl();
        set.clear();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            set.add(col.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        params.put("asstActTypeFilter", filter.toString());
        params.put("costCenterFilter", this.getCostCenterFilter(companyid));
        params.put("adminFilter", "CU.id='" + result.getCUId() + "'");
        params.put("isAuditNow", result.isAuditNow());
        params.put("projectfilter", this.getProjectFilter(companyid));
        params.put("tracknumberfilter", this.getTracknumberFilter(companyid));
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection profitCollection = iOrgUnitRelation.getFromUnit(companyid, 1, 6);
        StringBuilder sqlIDs = new StringBuilder();
        if (profitCollection != null && profitCollection.size() > 0) {
            for (int i = 0; i < profitCollection.size(); ++i) {
                OrgUnitInfo orgUnitInfo = profitCollection.get(i);
                if ("".equals(sqlIDs.toString())) {
                    sqlIDs.append("'").append(orgUnitInfo.getId().toString()).append("'");
                    continue;
                }
                sqlIDs.append(",'").append(orgUnitInfo.getId().toString()).append("'");
            }
        }
        params.put("profitCenterFilterIds", sqlIDs.toString());
        if (infoObj != null) {
            String excTableid = "";
            String basecurrencyid = "";
            if (company != null) {
                if (company.getBaseExchangeTable() != null) {
                    excTableid = company.getBaseExchangeTable().getId().toString();
                } else {
                    company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
                    excTableid = company.getBaseExchangeTable().getId().toString();
                }
                if (company.getBaseCurrency() != null) {
                    basecurrencyid = company.getBaseCurrency().getId().toString();
                }
            }
            String currencyid = infoObj.getCurrency().getId().toString();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String billDate = dateFormat.format(infoObj.getBillDate());
            Map exchangeData = PayRequestBillFacadeFactory.getLocalInstance(ctx).getExchange(excTableid, basecurrencyid, currencyid, billDate);
            params.put("exchangeData", exchangeData);
            String payerCurrencyID = null;
            if (infoObj instanceof com.kingdee.eas.fi.ap.OtherBillInfo && ((com.kingdee.eas.fi.ap.OtherBillInfo)infoObj).getPayerCurrency() != null) {
                payerCurrencyID = ((com.kingdee.eas.fi.ap.OtherBillInfo)infoObj).getPayerCurrency().getId().toString();
            }
            if (payerCurrencyID != null) {
                Map payerExchangeData = PayRequestBillFacadeFactory.getLocalInstance(ctx).getExchange(excTableid, basecurrencyid, payerCurrencyID, billDate);
                params.put("payerExchangeData", payerExchangeData);
            }
        }
        if (infoObj != null && company != null && company.getCU() != null && infoObj.getAsstActID() != null) {
            try {
                boolean isContrast;
                AccountViewInfo accountViewInfo = ArApBillUtil.getKAClassAccount(ctx, company.getId().toString(), infoObj.getAsstActID(), this.isArBill(infoObj), this.isAr(), 0);
                IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
                if (accountViewInfo != null && !(isContrast = iContrastAcct.isContrastAccount(company.getCU().getId().toString(), company.getId().toString(), accountViewInfo.getId().toString(), this.isAr() ? AccountControlAttribute.AR : AccountControlAttribute.AP))) {
                    accountViewInfo = null;
                }
                params.put("accountViewInfo", accountViewInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        ArrayList ids = new ArrayList();
        if (infoObj != null) {
            AbstractObjectCollection entrys = (AbstractObjectCollection)infoObj.get("entry");
            ArApBillEntryBaseInfo entryInfo = null;
            int size2 = entrys.size();
            for (int i = 0; i < size2; ++i) {
                entryInfo = (ArApBillEntryBaseInfo)entrys.getObject(i);
                MaterialInfo material = entryInfo.getMaterial();
                MeasureUnitInfo measureUnit = entryInfo.getMeasureUnit();
                MeasureUnitInfo baseMeasureUnit = entryInfo.getBaseUnit();
                MeasureUnitInfo assistUnit = entryInfo.getAssistUnit();
                if (material == null || measureUnit == null) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(String.valueOf(material.get("id")));
                list.add(String.valueOf(measureUnit.get("id")));
                list.add(baseMeasureUnit != null ? String.valueOf(baseMeasureUnit.get("id")) : null);
                list.add(assistUnit != null ? String.valueOf(assistUnit.get("id")) : null);
                ids.add(list);
            }
            if (ids.size() > 0) {
                IBaseServiceFacade bsf = BaseServiceFacadeFactory.getLocalInstance(ctx);
                params.putAll(bsf.getMultiUnitData(ids));
            }
            if (infoObj.get("asstActID") != null && "37C67DFC".equals(BOSUuid.read((String)infoObj.get("asstActID").toString()).getType().toString())) {
                ISupplier spCtrl = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierInfo spInfo = (SupplierInfo)spCtrl.getValue("select id,taxRate where id = '" + infoObj.get("asstActID").toString() + "' ");
                params.put("supplierTaxRate", spInfo.getTaxRate());
            } else if (infoObj.get("asstActID") != null && "BF0C040E".equals(BOSUuid.read((String)infoObj.get("asstActID").toString()).getType().toString())) {
                ICustomer cCtrl = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerInfo customer = (CustomerInfo)cCtrl.getValue("select id,taxRate where id = '" + infoObj.get("asstActID").toString() + "' ");
                params.put("supplierTaxRate", customer.getTaxRate());
            }
        }
        Map billEditConfig = ArApBillHelper.queryBillEditConfig(ctx, this.isAr());
        params.put("billEditConfig", billEditConfig);
        return params;
    }
}

