/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.app.web.ARBillCreateService;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class IncomeConfimBillCreateService
extends ARBillCreateService {
    public IncomeConfimBillCreateService(Context context) {
        super(context);
    }

    @Override
    public String getPermissionItem() {
        return "fi_ar_IncomeConfirmBill_Add";
    }

    @Override
    public CoreBillBaseInfo createDefaultBill(OrgUnitInfo mainOrg, Map otherInformation) throws EASBizException, BOSException {
        IncomeConfimBillInfo info = new IncomeConfimBillInfo();
        Date date = null;
        boolean isInitBill = false;
        if (otherInformation != null && otherInformation.containsKey("isInitBill")) {
            isInitBill = (Boolean)otherInformation.get("isInitBill");
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)mainOrg;
        ObjectUuidPK companypk = new ObjectUuidPK(company.getId().toString());
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("cu.number"));
        selCol.add(new SelectorItemInfo("name"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("baseCurrency.id"));
        selCol.add(new SelectorItemInfo("baseExchangeTable.id"));
        selCol.add(new SelectorItemInfo("accountTable.id"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)companypk, selCol);
        ObjectUuidPK currencypk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)currencypk);
        info.setCompany(company);
        info.setCU(company.getCU());
        info.setCurrency(currency);
        if (isInitBill) {
            info.setIsInitializeBill(true);
            BaseService bs = new BaseService(this.getContext());
            date = bs.getBeforeSysDate(true, 12, company.getId().toString());
        } else {
            date = ArApServerUtils.getBizDateBySystem(this.getContext(), true, company);
        }
        info.setExchangeRate(BigDecimal.ONE);
        info.setBillType(IncomeConfimBillTypeEnum.SALE_INCOME);
        info.setIsInTax(true);
        info.setBillDate(date);
        info.setBizDate(date);
        info.setBillStatus(BillStatusEnum.SAVE);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        ObjectUuidPK userpk = new ObjectUuidPK(this.getContext().getCaller().toString());
        creator = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)userpk);
        info.setCreator(creator);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        ObjectUuidPK pk = new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5");
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)this.getContext());
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)pk);
        info.setPaymentType(paymentTypeInfo);
        info.setAsstActType(this.getAsstActType(company, SystemEnum.ACCOUNTSRECEIVABLE));
        info.setIsInTax(true);
        info.setIsPriceWithoutTax(true);
        info.setSaleOrg(this.getDefaultSaleOrgUnit(company));
        info.setSourceBillType(VerificateBillTypeEnum.OTHER);
        return info;
    }

    @Override
    public CoreBillEntryBaseInfo createBillEntry(String companyid, Map otherInformation) throws EASBizException, BOSException {
        return super.createBillEntry(companyid, otherInformation);
    }
}

