/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ReceivingBillService {
    private Context ctx;

    public ReceivingBillService(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getUIcache(String id, String companyid) throws EASBizException, BOSException {
        ReceivingBillCollection col = null;
        ReceivingBillInfo recInfo = null;
        if (id != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            evi.setFilter(filter);
            col = ReceivingBillFactory.getLocalInstance((Context)this.getContext()).getReceivingBillCollection(evi);
        }
        if (col != null && col.size() > 0) {
            recInfo = col.get(0);
        }
        return this.getUIcache(recInfo);
    }

    public Map<String, Object> getUIcache(ReceivingBillInfo recInfo) throws EASBizException, BOSException {
        boolean isImportBillCannotModi;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (recInfo == null) {
            return params;
        }
        String companyid = recInfo.getCompany().getId().toString();
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getCacheCurrentPeriod(12, companyid);
        if (currentPeriod == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            String name = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid), sic).getName();
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{name + " " + SystemEnum.ACCOUNTSRECEIVABLE.getAlias()});
        }
        params.put("projectfilter", this.getProjectFilter(companyid));
        params.put("tracknumberfilter", this.getTracknumberFilter(companyid));
        Object col = null;
        String srcBosType = null;
        boolean isBotpBill = false;
        String sParamValue = ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()), (String)"G003");
        boolean bl = isImportBillCannotModi = sParamValue != null && ("true".equalsIgnoreCase(sParamValue) || "1".equals(sParamValue));
        if (recInfo.isIsImport() && isImportBillCannotModi) {
            throw new OtherBillBizException(OtherBillBizException.IMPORTBILL);
        }
        ReceivingBillEntryInfo entry = recInfo.getEntries().get(0);
        if (entry != null && entry.getSourceBillId() != null) {
            srcBosType = BOSUuid.read((String)entry.getSourceBillId()).getType().toString();
        }
        boolean isarStart = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).isStart(12, companyid);
        params.put("srcBosType", srcBosType);
        PaymentTypeInfo creditPayInfo = PaymentTypeFactory.getLocalInstance((Context)this.getContext()).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        params.put("creditPay", creditPayInfo);
        params.put("isarStart", isarStart);
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection profitCollection = iOrgUnitRelation.getFromUnit(companyid, 1, 6);
        StringBuilder sqlIDs = new StringBuilder();
        if (profitCollection != null && profitCollection.size() > 0) {
            for (int i = 0; i < profitCollection.size(); ++i) {
                OrgUnitInfo orgUnitInfo = profitCollection.get(i);
                if ("".equals(sqlIDs.toString())) {
                    sqlIDs.append("'").append(orgUnitInfo.getId().toString()).append("'");
                    continue;
                }
                sqlIDs.append(",'").append(orgUnitInfo.getId().toString()).append("'");
            }
        }
        params.put("profitCenterFilterIds", sqlIDs.toString());
        if (recInfo != null && recInfo.getCurrency() != null) {
            String excTableid = "";
            String basecurrencyid = "";
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            if (company != null && company.getBaseExchangeTable() != null) {
                excTableid = company.getBaseExchangeTable().getId().toString();
            } else {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
                excTableid = company.getBaseExchangeTable().getId().toString();
            }
            if (company != null && company.getBaseCurrency() != null) {
                basecurrencyid = company.getBaseCurrency().getId().toString();
            }
            String currencyid = recInfo.getCurrency().getId().toString();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String billDate = dateFormat.format(recInfo.getBizDate() == null ? new Date() : recInfo.getBizDate());
            Map exchangeData = PayRequestBillFacadeFactory.getLocalInstance(this.ctx).getExchange(excTableid, basecurrencyid, currencyid, billDate);
            params.put("exchangeData", exchangeData);
        }
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyid);
        keyMap.put("AR_039", companyPK);
        keyMap.put("RECBILL_AUDIT_NOW", companyPK);
        keyMap.put("CS131", companyPK);
        HashMap paramValueMap = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(keyMap);
        params.put("paramValue", paramValueMap);
        String customerTypeId = ArApBillHelper.getAsstactTypeCustomerId(this.ctx);
        params.put("customerTypeId", customerTypeId);
        return params;
    }

    private String getProjectFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    private String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    public ReceivingBillInfo createNewModel(ReceivingBillInfo billInfo, String operate) throws BOSException, EASBizException {
        billInfo.setSourceType(SourceTypeEnum.AR);
        billInfo.setSourceSysType(SourceTypeEnum.AR);
        if (operate == null) {
            billInfo.setIsInitializeBill(false);
            PaymentTypeInfo pamenttype = new PaymentTypeInfo();
            pamenttype = PaymentTypeFactory.getLocalInstance((Context)this.getContext()).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
            billInfo.setPaymentType(pamenttype);
            billInfo.setBizDate(ArApServerUtils.getBizDateBySystem(this.ctx, true, billInfo.getCompany()));
            ReceivingBillTypeInfo defaultBillTypeInfo = this.getDefaultBillType();
            if (null != defaultBillTypeInfo && DeletedStatusEnum.DELETED.equals((Object)defaultBillTypeInfo.getDeletedStatus())) {
                defaultBillTypeInfo = null;
            }
            if (defaultBillTypeInfo != null) {
                billInfo.setRecBillType(defaultBillTypeInfo);
                billInfo.setSourceSysType(defaultBillTypeInfo.getSourceSysType());
            } else {
                billInfo.setRecBillType(null);
            }
            AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
            if (billInfo.getCompany() != null) {
                String companyid = billInfo.getCompany().getId().toString();
                asstActTypeInfo = this.getAsstActType(companyid);
                billInfo.setPayerType(asstActTypeInfo);
            } else {
                billInfo.setPayerType(null);
            }
        } else if ("copy".equals(operate)) {
            Date d = null;
            d = billInfo.isIsInitializeBill() ? new BaseService(this.ctx).getBeforeSysDate(true, 12, billInfo.getCompany().getId().toString()) : ArApServerUtils.getBizDateBySystem(this.ctx, true, billInfo.getCompany());
            billInfo.setBizDate(d);
            if (!ArApBillUtil.verifyAsstActIgnore(this.ctx, billInfo.getCompany(), billInfo.getPayerID(), false).booleanValue()) {
                billInfo.setPayerID(null);
                billInfo.setPayerNumber(null);
                billInfo.setPayerName(null);
            }
        }
        return billInfo;
    }

    private AsstActTypeInfo getAsstActType(String companyid) throws EASBizException, BOSException {
        AsstActTypeInfo info = null;
        AsstActTypeInfo oldInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyid);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        info = asstActTypeColl.get(0).getAsstActType();
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            oldInfo = asstActTypeColl.get(i).getAsstActType();
            if (!oldInfo.getRealtionDataObject().equals("T_BD_Customer")) continue;
            info = oldInfo;
            break;
        }
        return info;
    }

    protected ReceivingBillTypeInfo getDefaultBillType() throws BOSException {
        ReceivingBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"100", CompareType.EQUALS));
        ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance((Context)this.ctx).getReceivingBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }
}

