/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app.webservice.util;

import com.kingdee.eas.fi.ar.app.webservice.util.WrongArgumentException;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BillPropertiesReader {
    private Document doc = null;
    private static String WRONGBILLTYPE = "wrong bill type";

    public BillPropertiesReader(String xmlData, String billType) throws SAXException, IOException, WrongArgumentException {
        try {
            this.doc = XMLUtil.builderDocument((String)xmlData);
            if (!this.checkBillType(billType)) {
                throw new WrongArgumentException(WRONGBILLTYPE, "1008");
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e.getMessage());
        }
    }

    public Map getHeadProperties(String elementName) {
        HashMap head = XMLUtil.getBillHead((Document)this.doc);
        return head;
    }

    public List getEntriesProperties(String elementXPath) {
        ArrayList entries = null;
        try {
            entries = XMLUtil.getBillEntries((Document)this.doc, (String)elementXPath);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return entries;
    }

    private boolean checkBillType(String billType) {
        Element root = this.doc.getDocumentElement();
        String rootName = root.getNodeName();
        return billType.equals(rootName);
    }
}

