/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.util;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.util.BadAcctImporter;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalCSVDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalTextDataReader;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BadAcctImportHelper {
    private static final Logger logger = Logger.getLogger(BadAcctImportHelper.class);
    private static final String RES = "com.kingdee.eas.fi.ar.client.VerificateResource";
    private static final int AR_FIELD_NUMBER = 11;
    private File dataFile = null;
    private String postFix = null;

    public BadAcctImportHelper(File file) {
        this.dataFile = file;
    }

    private void setPathFix(String path) {
        this.postFix = path.substring(path.lastIndexOf(".") + 1);
    }

    private AbstractExternalDataReader getFileReader() throws TaskExternalException {
        ExternalCSVDataReader fileReader = null;
        String path = this.dataFile.getAbsolutePath();
        int lastDotInd = path.lastIndexOf(".");
        if (lastDotInd == -1 || lastDotInd + 1 == path.length()) {
            String msg = EASResource.getString((String)RES, (String)"UnknownFileType");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        this.postFix = path.substring(lastDotInd + 1);
        if (this.postFix.equalsIgnoreCase("csv")) {
            fileReader = new ExternalCSVDataReader();
        } else if (this.postFix.equalsIgnoreCase("txt")) {
            fileReader = new ExternalTextDataReader();
        } else if (this.postFix.equalsIgnoreCase("xls")) {
            fileReader = new ExternalExcelDataReader();
        }
        if (fileReader == null) {
            String msg = EASResource.getString((String)RES, (String)"UnsupportedFile");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        fileReader.setLocacle(SysContext.getSysContext().getLocale());
        return fileReader;
    }

    public ImportLog importData() throws Exception {
        ImportLog log = new ImportLog();
        log.dataFile = this.dataFile.getAbsolutePath();
        this.setPathFix(this.dataFile.getAbsolutePath());
        AbstractExternalDataReader fileReader = this.getFileReader();
        if (fileReader == null) {
            String msg = EASResource.getString((String)RES, (String)"UnknownFileType");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        try {
            fileReader.openFile(this.dataFile.getAbsolutePath());
        }
        catch (FileFormatNotStandardException ex) {
            log.errList.add(ex.getMessage());
            return log;
        }
        fileReader.calculatorRowCount();
        CoreBaseInfo billInfo = null;
        Map dataRow = null;
        Object grpNum = null;
        ArrayList<Object> errGrpNum = new ArrayList<Object>();
        ExternalStructInfo fieldsInfo = fileReader.getExternalStructInfo();
        ArrayList fieldNameList = fieldsInfo.getFieldCollection();
        ArrayList<String> headDefineFieldList = new ArrayList<String>();
        ArrayList<String> entryDefineFieldList = new ArrayList<String>();
        while (fileReader.hasNext()) {
            fileReader.getCurrentRow();
            try {
                dataRow = fileReader.getNext();
            }
            catch (Exception ex) {
                ++log.billCount;
                throw new TaskExternalException(ex.getMessage());
            }
            if (dataRow == null || dataRow.size() == 0) continue;
            ++log.billCount;
            try {
                for (int i = 0; i < fieldNameList.size(); ++i) {
                    String defineFieldName = ((FieldPropertyInfo)fieldNameList.get(i)).toString();
                    if (defineFieldName.indexOf("#") > -1) {
                        headDefineFieldList.add(defineFieldName);
                        continue;
                    }
                    if (defineFieldName.indexOf("*") <= -1) continue;
                    entryDefineFieldList.add(defineFieldName);
                }
                if (fieldNameList.size() < 11) {
                    throw new TaskExternalException("field count is wrong.");
                }
                BadAcctImporter badAcctImporter = new BadAcctImporter();
                billInfo = badAcctImporter.transfer(dataRow, headDefineFieldList);
                badAcctImporter.submit(billInfo);
                ++log.newCount;
            }
            catch (Exception e) {
                logger.error((Object)e);
                String errMsg = "";
                errMsg = e.getMessage() == null ? ImportDataUtil.getResource("SystemError") : e.getMessage();
                ++log.failCount;
                errGrpNum.add(grpNum);
                log.errList.add("[" + log.billCount + "] row,[" + errMsg + "]");
            }
        }
        return log;
    }
}

