/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ImportException;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Calendar;

public class ImportDataUtil {
    public static final String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
    public static final String AP_RESOURCE_PATH = "com.kingdee.eas.fi.ap.APImportData";
    public static final String IS_AR = "1";
    public static final String IS_AP = "2";
    private static final BigDecimal MAX_VALUE = new BigDecimal("1000000000000");
    private static final BigDecimal MIN_VALUE = new BigDecimal("-0.0000000001");
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final BigDecimal ONE = new BigDecimal("1");
    public BigDecimal exchangeRate = ONE;
    public static final int quantityPrecision = 2;
    public static final int ratePrecision = 2;
    public static final int pricePrecision = 2;

    public static String getResource(String strKey, String str) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return str.equals(IS_AR) ? EASResource.getString((String)AR_RESOURCE_PATH, (String)strKey) : EASResource.getString((String)AP_RESOURCE_PATH, (String)strKey);
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)AR_RESOURCE_PATH, (String)strKey);
    }

    public static String getResourceFromAP(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)AP_RESOURCE_PATH, (String)strKey);
    }

    public static boolean isPlusData(String str) {
        BigDecimal qty = ImportDataUtil.toBigDecimal(str);
        if (qty != null && (qty.compareTo(MAX_VALUE) == 1 || qty.compareTo(MIN_VALUE) == -1)) {
            return false;
        }
        return qty != null;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof String || obj instanceof StringBuffer) {
                String str = obj.toString().trim();
                if (str.matches("-?\\d+\\.?\\d*")) {
                    return new BigDecimal(str);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean checkIsVerifyamount(String fieldName) {
        boolean temp = false;
        if (fieldName != null && fieldName.length() > 11 && fieldName.equalsIgnoreCase("verifyAmount")) {
            temp = true;
        }
        return temp;
    }

    public static boolean checkIsVerifyamountLocal(String fieldName) {
        boolean temp = false;
        if (fieldName != null && fieldName.length() > 16 && fieldName.equalsIgnoreCase("verifyamountLocal")) {
            temp = true;
        }
        return temp;
    }

    public static boolean checkIsPositiveRate(String fieldName, String amt) {
        String temp = null;
        if (fieldName != null && fieldName.length() > 4) {
            temp = fieldName.substring(fieldName.length() - 4);
            if (!fieldName.equalsIgnoreCase("discountRate") && temp != null && temp.equalsIgnoreCase("rate")) {
                return ImportDataUtil.isPlusData(amt);
            }
        }
        return true;
    }

    public static BigDecimal getTaxAmount(BigDecimal amount, BigDecimal taxRate) {
        amount = amount == null ? ZERO : amount;
        taxRate = taxRate == null ? new BigDecimal("0.17") : ImportDataUtil.getLittleRate(taxRate);
        return amount.multiply(taxRate).setScale(2, 4);
    }

    public static BigDecimal getRecAmount(BigDecimal amount, BigDecimal taxAmount) {
        amount = amount == null ? ZERO : amount;
        taxAmount = taxAmount == null ? ZERO : taxAmount;
        return amount.add(taxAmount).setScale(2, 4);
    }

    public static BigDecimal getActualTaxPrice(BigDecimal taxPrice, BigDecimal discountRate) {
        BigDecimal actualTaxPrice = ZERO;
        taxPrice = taxPrice == null ? ZERO : taxPrice;
        discountRate = discountRate == null ? ZERO : ImportDataUtil.getLittleRate(discountRate);
        actualTaxPrice = ONE.subtract(discountRate).multiply(taxPrice);
        return actualTaxPrice.setScale(2, 4);
    }

    public static BigDecimal getDiscountRate(BigDecimal discountAmt, BigDecimal amount) {
        BigDecimal discountRate = discountAmt.divide(amount, 2, 4);
        return discountRate.setScale(2, 4);
    }

    public static BigDecimal getDiscountAmount(BigDecimal taxPrice, BigDecimal quantity, BigDecimal discountRate) {
        taxPrice = taxPrice == null ? ZERO : taxPrice;
        quantity = quantity == null ? ZERO : quantity;
        discountRate = discountRate == null ? ZERO : ImportDataUtil.getLittleRate(discountRate);
        return taxPrice.multiply(quantity).multiply(discountRate).setScale(2, 4);
    }

    public static BigDecimal getAmount(BigDecimal price, BigDecimal quantity, BigDecimal discountRate) {
        price = price == null ? ZERO : price;
        quantity = quantity == null ? ZERO : quantity;
        discountRate = discountRate == null ? ZERO : ImportDataUtil.getLittleRate(discountRate);
        return price.multiply(quantity).multiply(ONE.subtract(discountRate)).setScale(2, 4);
    }

    public static BigDecimal computeTaxPrice(BigDecimal taxRate, BigDecimal price) {
        taxRate = taxRate == null ? new BigDecimal("0.17") : ImportDataUtil.getLittleRate(taxRate);
        price = price == null ? ZERO : price;
        BigDecimal taxPrice = taxRate.add(ONE).multiply(price);
        taxPrice = taxPrice.setScale(2, 4);
        return taxPrice;
    }

    public static BigDecimal computePrice(BigDecimal taxRate, BigDecimal taxPrice) {
        taxRate = taxRate == null ? new BigDecimal("0.17") : ImportDataUtil.getLittleRate(taxRate);
        taxPrice = taxPrice == null ? ZERO : taxPrice.setScale(2, 4);
        BigDecimal price = taxPrice.divide(taxRate.add(ONE), 2, 4);
        return price;
    }

    public static BigDecimal getLittleRate(BigDecimal ratePercent) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return new BigDecimal("0.00");
        }
        int length = ratePercent.toString().length();
        if (length < 4) {
            length = 4;
        }
        rate = ratePercent.divide(new BigDecimal("100.0"), 2, 4);
        return rate;
    }

    public static ExchangeRateInfo getExchangeRateInfo(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo) throws Exception {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = ImportDataUtil.getCompanyInfo();
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)currencyInfo.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyInfo.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        return erInfo;
    }

    public static CompanyOrgUnitInfo getCompanyInfo() throws Exception {
        CompanyOrgUnitInfo defalutOrgInfo = null;
        ObjectUuidPK compk = ImportDataUtil.getCompanyPK();
        ICompanyOrgUnit comorg = null;
        comorg = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        defalutOrgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return defalutOrgInfo;
    }

    public static ObjectUuidPK getCompanyPK() throws Exception {
        CompanyOrgUnitInfo comobj = SysContext.getSysContext().getCurrentFIUnit();
        ObjectUuidPK compk = null;
        if (comobj == null) {
            throw new ImportException(ImportException.CHANGE2REALCOMPANY);
        }
        if (comobj.isIsOnlyUnion()) {
            throw new ImportException(ImportException.CURRENTCOMPANYISUNION);
        }
        compk = new ObjectUuidPK(BOSUuid.read((String)comobj.get("id").toString()));
        return compk;
    }

    public static boolean checkVerifyAmt(BigDecimal recAmt, BigDecimal verifyAmt, BigDecimal unVerifyAmt) {
        BigDecimal temp;
        boolean ret = true;
        if (verifyAmt == null) {
            verifyAmt = ZERO;
        }
        if (unVerifyAmt == null) {
            unVerifyAmt = ZERO;
        }
        if ((temp = verifyAmt.add(unVerifyAmt)).compareTo(recAmt) != 0) {
            ret = false;
        }
        return ret;
    }

    public static void printEntityInfo() {
        String clientMetaPath = "w:\\apusic\\metas\\";
        MetaDataLoaderFactory.setClientMetaDataPath((String)clientMetaPath);
        IMetaDataLoader imdl = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fi.ap.app.T_AP_OtherBillEntry");
        DataTableInfo eoi = imdl.getDataTable((IMetaDataPK)pk);
        ColumnCollection colCollection = eoi.getColumns();
        ColumnInfo column = null;
        for (int i = 0; i < colCollection.size(); ++i) {
            column = colCollection.get(i);
        }
    }

    public static void main(String[] args) {
    }
}

