/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.ApVerificationFacadeFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ArApVerifyCommonFacadeFactory;
import com.kingdee.eas.fi.arap.app.AbstractARAPCommonServerFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.ArApVerifyUtil;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ARAPCommonServerFacadeControllerBean
extends AbstractARAPCommonServerFacadeControllerBean {
    private static final long serialVersionUID = -3941044680191973217L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ARAPCommonServerFacadeControllerBean");
    public static final String CHECK_ACCOUNT_RANGE_NUMBER = "CHECK_ACCOUNT_RANGE";
    public static final String CHECK_GAIN_AND_LOSS = "CHECK_GAIN_AND_LOSS";
    public static final String CHECK_ACCOUNT_DAP_VALUE = "DAP_RELATION";
    public static final String AP_VERIFY_BILL_BOSTYPE = "2F368848";
    public static final String AR_VERIFY_BILL_BOSTYPE = "3C41FD86";
    public static final String CR = "\r\n";
    protected static final String DELIMIT_FH = ";";

    @Override
    protected int _getVerificated(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null || "".equals(billID)) {
            return 0;
        }
        int value = 0;
        boolean hasAR = false;
        boolean hasAP = false;
        StringBuffer arsql = new StringBuffer("");
        arsql.append("select fid from t_ar_verificationbillentry where fbillid='").append(billID).append("'");
        StringBuffer apsql = new StringBuffer("");
        apsql.append("select fid from t_ap_verificationbillentry where fbillid='").append(billID).append("'");
        StringBuffer badsql = new StringBuffer("");
        badsql.append("select base.fid from t_ar_verificationbill base,t_ar_verificationbillentry  entry where base.fid=entry.fparentid and entry.fid='");
        Connection connection = null;
        Statement pstmtar = null;
        Statement pstmtap = null;
        Statement pstmtbd = null;
        IRowSet rsar = null;
        IRowSet rsap = null;
        IRowSet rsbd = null;
        try {
            rsar = DbUtil.executeQuery((Context)ctx, (String)arsql.toString());
            rsap = DbUtil.executeQuery((Context)ctx, (String)apsql.toString());
            if (rsar.next()) {
                String id = rsar.getString("fid");
                badsql.append(id).append("'");
                badsql.append(" and base.fverificationtype !=111 and   base.fverificationtype !=112");
                rsbd = DbUtil.executeQuery((Context)ctx, (String)badsql.toString());
                if (rsbd.next()) {
                    hasAR = true;
                }
            }
            if (rsap.next()) {
                hasAP = true;
            }
            if (hasAR && hasAP) {
                value = 3;
            } else if (hasAR && !hasAP) {
                value = 1;
            } else if (!hasAR && hasAP) {
                value = 2;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsar, pstmtar);
            SQLUtils.cleanup(rsbd, pstmtbd);
            SQLUtils.cleanup((ResultSet)rsap, pstmtap, connection);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean _isDAPCheckAccount(Context ctx) throws BOSException, EASBizException {
        boolean val;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            StringBuffer sql = new StringBuffer("select FValue from T_ARAP_CommonParam ");
            sql.append(" where fnumber='").append(CHECK_ACCOUNT_RANGE_NUMBER).append("'");
            conn = null;
            pstmt = null;
            rs = null;
            val = true;
            try {
                String value;
                conn = CommonServerUtils.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                rs = pstmt.executeQuery();
                if (!rs.next() || (value = rs.getString("fvalue")) == null) break block4;
                val = CHECK_ACCOUNT_DAP_VALUE.equalsIgnoreCase(value);
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return val;
    }

    @Override
    protected IRowSet _getDefinitionData(Context ctx, boolean isARBill, Set ids) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        String lang = ctx.getLocale().getLanguage();
        StringBuffer oql = new StringBuffer(" SELECT FID,MATERIAL_NUMBE, MATERIAL_NAME,MATERIAL_MODEL,BASEMEASUREUNIT_NAME \r\n");
        oql.append(" ,MULTIMEASUREUNIT_QTYPRECISION ,ENTRY_FBASEQTY  \r\n");
        oql.append(" ,to_decimal(ENTRY_AMOUNT,21,4) as ENTRY_AMOUNT  \r\n");
        oql.append(" ,to_decimal(ENTRY_RECIEVEPAYAMOUNT,21,4) as ENTRY_RECIEVEPAYAMOUNT \r\n");
        oql.append(" ,to_decimal(round((CASE WHEN (ENTRY_FBASEQTY = 0) THEN 0 ELSE to_decimal(ENTRY_AMOUNT,21,8) /to_decimal(ENTRY_FBASEQTY,21,8) end ),8) ,21,8) as ENTRY_PRICE \r\n");
        oql.append(" ,to_decimal(round((CASE WHEN (ENTRY_FBASEQTY  = 0) THEN 0 ELSE to_decimal(ENTRY_RECIEVEPAYAMOUNT,21,8) /to_decimal(ENTRY_FBASEQTY,21,8) end),8) ,21,8) as ENTRY_TAXPRICE \r\n");
        oql.append(" FROM ( \r\n");
        oql.append(" SELECT OTHERBILL.FID AS FID, MATERIAL.FNumber AS MATERIAL_NUMBE,MATERIAL.FName_").append(lang).append(" AS MATERIAL_NAME, MATERIAL.FModel AS MATERIAL_MODEL \r\n");
        oql.append(" ,BASEMEASUREUNIT.FName_").append(lang).append(" AS BASEMEASUREUNIT_NAME,MULTIMEASUREUNIT.FQtyPrecision AS  MULTIMEASUREUNIT_QTYPRECISION \r\n");
        oql.append(" ,SUM(CASE WHEN (ENTRY.FBaseQty IS NULL) THEN 0 ELSE ENTRY.FBaseQty END) AS ENTRY_FBASEQTY  \r\n");
        oql.append(isARBill ? " " : " ,SUM(CASE WHEN (ENTRY.FRequestedPayAmt IS NULL) THEN 0 ELSE ENTRY.FRequestedPayAmt END) AS ENTRY_FREQUESTEDPAYAMT  \r\n");
        oql.append(" ,SUM(ENTRY.FAmount) AS ENTRY_AMOUNT  \r\n");
        oql.append(" ,SUM(ENTRY.FrecievePayAmount) AS ENTRY_RECIEVEPAYAMOUNT  \r\n");
        oql.append(" FROM \r\n").append(isARBill ? "T_AR_OtherBill" : "T_AP_OtherBill").append(" AS OTHERBILL \r\n");
        oql.append(" RIGHT OUTER JOIN ").append(isARBill ? "T_AR_OtherBillentry" : "T_AP_OtherBillentry").append(" AS ENTRY \r\n");
        oql.append(" ON ENTRY.FParentID = OTHERBILL.FID \r\n");
        oql.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL \r\n");
        oql.append(" ON ENTRY.FMaterialID = MATERIAL.FID \r\n");
        oql.append(" LEFT OUTER JOIN T_BD_MeasureUnit  AS BASEMEASUREUNIT \r\n");
        oql.append(" ON ENTRY.Fbaseunitid = BASEMEASUREUNIT.FID \r\n");
        oql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit   AS MULTIMEASUREUNIT \r\n");
        oql.append(" ON ENTRY.Fbaseunitid = MULTIMEASUREUNIT.FMeasureUnitID  and ENTRY.FMaterialID = MULTIMEASUREUNIT.FMaterialid \r\n");
        oql.append(" where OTHERBILL.FID in(");
        Object[] idObj = ids.toArray();
        int size = idObj.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'" + idObj[i].toString() + "'");
        }
        oql.append(") \r\n");
        oql.append(" and OTHERBILL.FBillType not in(").append(isARBill ? "101,103" : "201,203").append(") \r\n");
        oql.append(" GROUP BY  OTHERBILL.FID,MATERIAL.FNumber, MATERIAL.FName_").append(lang).append(",MATERIAL.FModel \r\n");
        oql.append(" ,BASEMEASUREUNIT.FName_").append(lang).append(" ,MULTIMEASUREUNIT.FQtyPrecision \r\n");
        oql.append(" ) AS BILL ");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        return iRowSet;
    }

    @Override
    protected Collection _autoVerifyByCoreNum(Context ctx, Collection pks, VerificationEnum veriType, boolean isFromMain) throws BOSException, EASBizException {
        return ArVerificationFacadeFactory.getLocalInstance(ctx).autoVerifyByCoreNum(pks, veriType, isFromMain);
    }

    @Override
    protected List _autoVerify(Context ctx, String companyId, Set idSet, boolean isAR) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        MappingConditionEntryCollection mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '" + (isAR ? "003" : "007") + "' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            String billId = String.valueOf(it.next());
            FilterInfo mainFilter = new FilterInfo();
            mainFilter.getFilterItems().add(new FilterItemInfo("entry.lockUnVerifyAmt", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.EQUALS));
            mainFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0, CompareType.EQUALS));
            FilterInfo secFilter = new FilterInfo();
            secFilter.setMaskString("1 = 1");
            secFilter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.INCLUDE));
            secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            secFilter.getFilterItems().add(new FilterItemInfo("entries.unLockAmt", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            secFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            if (isAR) {
                secFilter.getFilterItems().add(new FilterItemInfo("payerID", null, CompareType.ISNOT));
                secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            }
            secFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)(isAR ? 14 : 15), CompareType.EQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            secFilter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)(isAR ? 100 : 101), CompareType.EQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
            if (isAR) {
                secFilter.getFilterItems().add(new FilterItemInfo("entryRecBillType.isSaleRec", (Object)Boolean.TRUE, CompareType.EQUALS));
                secFilter.setMaskString(secFilter.getMaskString() + " AND (#" + (secFilter.getFilterItems().size() - 1));
                secFilter.getFilterItems().add(new FilterItemInfo("entryRecBillType.isPreRec", (Object)Boolean.TRUE, CompareType.EQUALS));
                secFilter.setMaskString(secFilter.getMaskString() + " OR #" + (secFilter.getFilterItems().size() - 1) + ")");
            } else {
                secFilter.getFilterItems().add(new FilterItemInfo("payBillType.isPurPay", (Object)Boolean.TRUE, CompareType.EQUALS));
                secFilter.setMaskString(secFilter.getMaskString() + " AND (#" + (secFilter.getFilterItems().size() - 1));
                secFilter.getFilterItems().add(new FilterItemInfo("payBillType.isPrePay", (Object)Boolean.TRUE, CompareType.EQUALS));
                secFilter.setMaskString(secFilter.getMaskString() + " OR #" + (secFilter.getFilterItems().size() - 1) + ")");
            }
            WriteOffCommonParams params = new WriteOffCommonParams();
            params.setFlowWriteOff(true);
            params.setFlowWfBillId(billId);
            params.setFromMain(false);
            params.put((Object)"isAR", (Object)isAR);
            if (isAR) {
                params.put((Object)"veriType", (Object)VerificationEnum.AR_Rec);
                params.put((Object)"veriTypeAB", (Object)VerificationEnum.AR_Rec_AB);
            } else {
                params.put((Object)"veriType", (Object)VerificationEnum.AP_Pay);
                params.put((Object)"veriTypeAB", (Object)VerificationEnum.AP_Pay_AB);
            }
            params.setStrategy("verification");
            params.setCompanyId(companyId);
            params.setMainEntityId(isAR ? "FC910EF3" : "48DA3A71");
            params.setSecEntityId(isAR ? "FA44FD5B" : "40284E81");
            params.setMainQueryName(isAR ? "com.kingdee.eas.fi.ar.app.OtherBill" : "com.kingdee.eas.fi.ap.app.OtherBillQuery");
            params.setSecQueryName(isAR ? "com.kingdee.eas.fi.cas.ReceivingBillQuery" : "com.kingdee.eas.fi.cas.PaymentBillQuery");
            params.setMainEntryIdField("entry.id");
            params.setSecEntryIdField("entries.id");
            params.put((Object)"mainFilter", (Object)mainFilter);
            params.put((Object)"secFilter", (Object)secFilter);
            params.put((Object)"mainSorter", (Object)ArApVerifyUtil.getSortItemColl(ctx, companyId, isAR));
            SorterItemCollection secSorter = new SorterItemCollection();
            secSorter.add(new SorterItemInfo("bizDate"));
            params.put((Object)"secSorter", (Object)secSorter);
            IWriteOffCommonFacade iWriteOffCommonFacade = WriteOffCommonFacadeFactory.getLocalInstance((Context)ctx);
            MappingConditionEntryInfo mappingInfo = new MappingConditionEntryInfo();
            mappingInfo.getMappingField().addCollection(this.getSameSideMappingField(new String[]{"paymentType.id", "entries.coreBillNumber", "entries.coreBillEntrySeq"}));
            params.put((Object)"mappingEntryInfo", (Object)mappingInfo);
            List list = iWriteOffCommonFacade.flowWriteOffSameSide(params);
            if (list != null) {
                result.addAll(list);
            }
            int size = mappingEntryColl.size();
            for (int i = 0; i < size; ++i) {
                params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
                list = iWriteOffCommonFacade.flowWriteOff(params);
                if (list == null) continue;
                result.addAll(list);
            }
        }
        ArApServerUtils.wrietOffBizLogForAutoVerification(ctx, result, companyId, "_autoVerify");
        return result;
    }

    protected MappingFieldCollection getSameSideMappingField(String[] field) {
        MappingFieldCollection coll = new MappingFieldCollection();
        MappingFieldInfo info = null;
        int len = field.length;
        for (int i = 0; i < len; ++i) {
            info = new MappingFieldInfo();
            info.setSecField(field[i]);
            coll.add(info);
        }
        return coll;
    }

    @Override
    protected IRowSet _getPayRequestCoverTDData(Context ctx, Set ids) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        Object[] idObj = ids.toArray();
        StringBuffer buf = new StringBuffer();
        buf.append("select currency.fPrecision as FPrecision from t_bd_currency currency").append(" inner join t_ap_payRequestBill bill on bill.fCurrencyID = currency.fid").append(" where bill.fid = '").append(idObj[0].toString()).append("'");
        int precision = -1;
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        try {
            if (iRowSet.next()) {
                precision = iRowSet.getInt("FPrecision");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer bufTmp = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            bufTmp.append("0");
        }
        buf.setLength(0);
        String lang = ctx.getLocale().getLanguage();
        buf.append("SELECT billImageMap.FImageNumber as billImageNumber, head.fNumber as number").append(", companyTab.fName_").append(lang).append(" as company").append(", head.fBizDate as billDate, person.fName_").append(lang).append(" as applier").append(CR).append(", currencyTab.fName_").append(lang).append(" as currency").append(", head.FRequestReason as requestReason").append(", case when charindex('.', SUM(entry.FAuditAmount))> 0").append(" then tochar(round(SUM(entry.FAuditAmount), ").append(precision).append("))").append(" else concat(tochar(SUM(entry.FAuditAmount)), '.").append(bufTmp.toString()).append("')").append(" end as amount").append(", entry.FAsstActName as asstActName").append(CR).append(" FROM t_ap_payRequestBill head").append(CR).append(" LEFT OUTER JOIN t_ap_payRequestBillEntry entry ON head.fid = entry.fParentId").append(CR).append(" LEFT OUTER JOIN T_WSC_BillImageMap billImageMap ON head.fid = billImageMap.fBillId").append(CR).append(" LEFT OUTER JOIN T_BD_Person person ON head.FApplyerID = person.fid").append(CR).append(" LEFT OUTER JOIN T_BD_Currency currencyTab ON head.fCurrencyId = currencyTab.fid").append(CR).append(" LEFT OUTER JOIN T_ORG_Company companyTab ON head.fCompanyId = companyTab.fid").append(CR).append(" WHERE head.fid = '").append(idObj[0].toString()).append("'").append(CR);
        buf.append(" GROUP BY billImageMap.FImageNumber, head.fNumber, head.fBizDate, head.FRequestReason").append(CR).append(", companyTab.fName_").append(lang).append(", person.fName_").append(lang).append(", currencyTab.fName_").append(lang).append(", entry.FAsstActName");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        return iRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean _isCheckGainAndLoss(Context ctx) throws BOSException, EASBizException {
        boolean val;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            StringBuffer sql = new StringBuffer("select FValue from T_ARAP_CommonParam ");
            sql.append(" where fnumber='").append(CHECK_GAIN_AND_LOSS).append("'");
            conn = null;
            pstmt = null;
            rs = null;
            val = true;
            try {
                String value;
                conn = CommonServerUtils.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                rs = pstmt.executeQuery();
                if (!rs.next() || (value = rs.getString("fvalue")) == null) break block4;
                val = Boolean.valueOf(value);
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return val;
    }

    @Override
    protected void _autoVerifyNoCondition(Context ctx, RecPayBillInfo info, boolean isAR) throws BOSException, EASBizException {
        ArApBillEntryBaseInfo otherEntryInfo;
        String string;
        WriteOffCommonParams wfParams = new WriteOffCommonParams();
        FilterInfo upFilter = null;
        FilterInfo queryFilter = null;
        FilterInfo mainFilter = new FilterInfo();
        FilterInfo secFilter = new FilterInfo();
        try {
            upFilter = new FilterInfo("billstatus = 3");
            queryFilter = new FilterInfo("(billStatus = 15) AND (sourceType = 101) ");
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        FilterItemInfo itemInfo = null;
        itemInfo = new FilterItemInfo("id", (Object)info.getSourceBillId());
        mainFilter.getFilterItems().add(itemInfo);
        itemInfo = new FilterItemInfo("id", (Object)info.getId().toString());
        secFilter.getFilterItems().add(itemInfo);
        String mainEntityId = null;
        if (isAR) {
            new OtherBillInfo();
            string = OtherBillInfo.getBosType().toString();
        } else {
            new OtherBillInfo();
            string = OtherBillInfo.getBosType().toString();
        }
        mainEntityId = string;
        wfParams.setMainEntityId(mainEntityId);
        wfParams.setSecEntityId(info.getBOSType().toString());
        wfParams.setMainQueryName("com.kingdee.eas.fi.ap.app.OtherBillQuery");
        wfParams.setSecQueryName("com.kingdee.eas.fi.cas.ArApVerifyPaymentBillQuery");
        wfParams.setMappingEntryId("V+jayttxQnecqhgnjy79EJVAboA=");
        wfParams.setMainEntryIdField("entry.id");
        wfParams.setSecEntryIdField("entries.id");
        wfParams.setBizDate(new Date());
        wfParams.setCompanyId(info.getCompany().getId().toString());
        wfParams.setSameSideFirst(false);
        wfParams.put((Object)"isAutoWriteOff", (Object)Boolean.FALSE);
        wfParams.put((Object)"isHeadView", (Object)false);
        wfParams.put((Object)"isAR", (Object)Boolean.FALSE);
        wfParams.put((Object)"veriType", (Object)VerificationEnum.AP_Pay);
        wfParams.put((Object)"veriTypeAB", (Object)VerificationEnum.AP_Pay_AB);
        wfParams.setStrategy("verification");
        PaymentBillEntryCollection payEntryCol = (PaymentBillEntryCollection)info.get("entries");
        PaymentBillEntryInfo entryInfo = payEntryCol.get(0);
        String sourceBillId = entryInfo.getSourceBillId();
        AbstractObjectCollection entryCol = null;
        WriteOffCommonInfo writeOffInfo = null;
        ArrayList<WriteOffCommonInfo> mainList = new ArrayList<WriteOffCommonInfo>();
        ArrayList<WriteOffCommonInfo> secList = new ArrayList<WriteOffCommonInfo>();
        ArApBillBaseInfo otherBillInfo = null;
        SelectorItemCollection selCol = this.getOtherBillSelector();
        otherBillInfo = isAR ? OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), selCol) : com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), selCol);
        entryCol = otherBillInfo.getEntries();
        int size = entryCol.size();
        for (int i = 0; i < size && (otherEntryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i)).getLockVerifyAmt().compareTo(otherEntryInfo.getVerifyAmount()) != 0; ++i) {
            writeOffInfo = new WriteOffCommonInfo();
            writeOffInfo.setAmount(otherEntryInfo.getLockVerifyAmt().subtract(otherEntryInfo.getVerifyAmount()));
            writeOffInfo.setLocalAmount(otherEntryInfo.getLockVerifyAmtLocal().subtract(otherEntryInfo.getVerifyAmountLocal()));
            writeOffInfo.setBillId(sourceBillId);
            writeOffInfo.setEntryId(otherEntryInfo.getId().toString());
            writeOffInfo.setLastUpdateTime((Date)otherBillInfo.getLastUpdateTime());
            writeOffInfo.setBillNumber(otherBillInfo.getNumber());
            mainList.add(writeOffInfo);
        }
        writeOffInfo = new WriteOffCommonInfo();
        writeOffInfo.setAmount(entryInfo.getAmount());
        writeOffInfo.setLocalAmount(entryInfo.getLocalAmt());
        writeOffInfo.setBillId(sourceBillId);
        writeOffInfo.setEntryId(entryInfo.getId().toString());
        writeOffInfo.setLastUpdateTime((Date)info.getLastUpdateTime());
        writeOffInfo.setBillNumber(info.getNumber());
        secList.add(writeOffInfo);
        wfParams.setMainList(mainList);
        wfParams.setSecList(secList);
        wfParams.put((Object)"upQueryFilter", upFilter.clone());
        wfParams.put((Object)"downQueryFilter", queryFilter.clone());
        wfParams.put((Object)"isFromBOTP", (Object)true);
        List result = ArApVerifyCommonFacadeFactory.getLocalInstance(ctx).manualWriteOff(wfParams);
        ArApServerUtils.wrietOffBizLogForAutoVerification(ctx, result, wfParams.getCompanyId(), "_autoVerifyNoCondition");
    }

    protected SelectorItemCollection getOtherBillSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("id"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("lastUpdateTime"));
        selCol.add(new SelectorItemInfo("entry.amount"));
        selCol.add(new SelectorItemInfo("entry.localAmt"));
        selCol.add(new SelectorItemInfo("entry.lockVerifyAmt"));
        selCol.add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
        selCol.add(new SelectorItemInfo("entry.verifyAmount"));
        selCol.add(new SelectorItemInfo("entry.verifyAmountLocal"));
        selCol.add(new SelectorItemInfo("entry.unVerifyAmount"));
        selCol.add(new SelectorItemInfo("entry.unVerifyAmountLocal"));
        selCol.add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
        selCol.add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
        return selCol;
    }

    @Override
    protected Set _checkHasVerifyBillInfo(Context ctx, Set validSet) throws BOSException, EASBizException {
        HashSet<String> verficationBillIdSet = new HashSet<String>();
        if (validSet.size() == 0) {
            return verficationBillIdSet;
        }
        StringBuilder idBuilder = new StringBuilder();
        for (Object idObj : validSet) {
            idBuilder.append("'").append(idObj.toString()).append("'").append(",");
        }
        String idStr = idBuilder.substring(0, idBuilder.length() - 1);
        StringBuilder arSqlStr = new StringBuilder();
        arSqlStr.append("SELECT FPARENTID");
        arSqlStr.append(" FROM T_AR_VERIFICATIONBILLENTRY");
        arSqlStr.append(" WHERE FBILLID IN (");
        arSqlStr.append(idStr);
        arSqlStr.append(")");
        StringBuilder apSqlStr = new StringBuilder();
        apSqlStr.append("SELECT FPARENTID");
        apSqlStr.append(" FROM T_AP_VERIFICATIONBILLENTRY");
        apSqlStr.append(" WHERE FBILLID IN (");
        apSqlStr.append(idStr);
        apSqlStr.append(")");
        IRowSet rsar = null;
        IRowSet rsap = null;
        try {
            rsar = DbUtil.executeQuery((Context)ctx, (String)arSqlStr.toString());
            while (rsar.next()) {
                verficationBillIdSet.add(rsar.getString("FPARENTID"));
            }
            rsap = DbUtil.executeQuery((Context)ctx, (String)apSqlStr.toString());
            while (rsap.next()) {
                verficationBillIdSet.add(rsap.getString("FPARENTID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsar);
                SQLUtils.cleanup(rsap);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsar);
        SQLUtils.cleanup((ResultSet)rsap);
        return verficationBillIdSet;
    }

    @Override
    protected void _antiVerify(Context ctx, Set verficationBillIdSet) throws BOSException, EASBizException {
        ArrayList<String> arVerficationBillIdList = new ArrayList<String>();
        ArrayList<String> apVerficationBillIdList = new ArrayList<String>();
        for (Object idObj : verficationBillIdSet) {
            String bosTypeStr = BOSUuid.read((String)idObj.toString()).getType().toString();
            if (bosTypeStr.equals(AR_VERIFY_BILL_BOSTYPE)) {
                arVerficationBillIdList.add(idObj.toString());
                continue;
            }
            if (!bosTypeStr.equals(AP_VERIFY_BILL_BOSTYPE)) continue;
            apVerficationBillIdList.add(idObj.toString());
        }
        int arIdsSize = arVerficationBillIdList.size();
        if (arIdsSize > 0) {
            String[] arIdArr = new String[arIdsSize];
            for (int i = 0; i < arIdsSize; ++i) {
                arIdArr[i] = (String)arVerficationBillIdList.get(i);
            }
            ArVerificationFacadeFactory.getLocalInstance(ctx).unVerification(arIdArr);
        }
        int apIdsSize = apVerficationBillIdList.size();
        if (apVerficationBillIdList.size() > 0) {
            String[] apIdArr = new String[apIdsSize];
            for (int i = 0; i < apIdsSize; ++i) {
                apIdArr[i] = (String)apVerficationBillIdList.get(i);
            }
            ApVerificationFacadeFactory.getLocalInstance(ctx).unVerification(apIdArr);
        }
    }

    @Override
    protected Object[] _getPreRecPayF7Value(Context ctx, String companyId, String preBillNumbers, boolean isAR) throws BOSException, EASBizException {
        Object[] objArr = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet numberSet = Sets.newHashSet((Object[])preBillNumbers.split(DELIMIT_FH));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("bizDate");
        sic.add("amount");
        if (isAR) {
            sic.add("payerNumber");
            sic.add("payerName");
            sic.add("payerID");
        } else {
            sic.add("payeeNumber");
            sic.add("payeeName");
            sic.add("payeeID");
        }
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("entries.id");
        sic.add("entries.seq");
        sic.add("entries.lockAmt");
        sic.add("entries.lockLocAmt");
        sic.add("entries.unLockAmt");
        sic.add("entries.unLockLocAmt");
        viewInfo.setSelector(sic);
        SorterItemInfo si = new SorterItemInfo("number");
        si.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(si);
        CoreBaseCollection col = null;
        col = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx).getCollection(viewInfo) : PaymentBillFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (col.size() > 0) {
            objArr = new Object[col.size()];
            for (int i = 0; i < col.size(); ++i) {
                objArr[i] = col.get(i);
            }
        }
        return objArr;
    }
}

