/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.FileVoucherBillInfo;
import com.kingdee.eas.fi.gl.app.FileVoucherBillInstance;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ARAPFileVoucherBillInstanceImpl
implements FileVoucherBillInstance {
    public FileVoucherBillInfo getBillInfo(Context ctx, String billId, String billBosType) throws BOSException, EASBizException {
        return this.getBillInfoForARAP(ctx, billId, billBosType);
    }

    private FileVoucherBillInfo getBillInfoForARAP(Context ctx, String billId, String bosType) throws BOSException, EASBizException {
        FileVoucherBillInfo billInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        if ("D001019A".equals(bosType)) {
            sic.add(new SelectorItemInfo("auditAmount"));
        } else {
            sic.add(new SelectorItemInfo("amount"));
        }
        sic.add(new SelectorItemInfo("billstatus"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        SelectorItemCollection verificationSic = new SelectorItemCollection();
        verificationSic.add(new SelectorItemInfo("id"));
        verificationSic.add(new SelectorItemInfo("name"));
        verificationSic.add(new SelectorItemInfo("number"));
        verificationSic.add(new SelectorItemInfo("verificationType"));
        verificationSic.add(new SelectorItemInfo("creator.id"));
        verificationSic.add(new SelectorItemInfo("creator.name"));
        verificationSic.add(new SelectorItemInfo("company.id"));
        verificationSic.add(new SelectorItemInfo("company.number"));
        verificationSic.add(new SelectorItemInfo("company.name"));
        if ("FC910EF3".equals(bosType)) {
            sic.add(new SelectorItemInfo("billType"));
            OtherBillInfo info = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setAmount(info.getAmount());
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillStatus(info.getBillStatus().getAlias());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSRECEIVABLE.getAlias());
            billInfo.setBillType(info.getBillType().getAlias());
            billInfo.setCompany(info.getCompany());
        } else if ("48DA3A71".equals(bosType)) {
            sic.add(new SelectorItemInfo("billType"));
            com.kingdee.eas.fi.ap.OtherBillInfo info = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setAmount(info.getAmount());
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillStatus(info.getBillStatus().getAlias());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSPAYABLE.getAlias());
            billInfo.setBillType(info.getBillType().getAlias());
            billInfo.setCompany(info.getCompany());
        } else if ("FA44FD5B".equals(bosType)) {
            sic.add(new SelectorItemInfo("recBillType.name"));
            ReceivingBillInfo info = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setAmount(info.getAmount());
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillStatus(info.getBillStatus().getAlias());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSRECEIVABLE.getAlias());
            billInfo.setBillType(info.getRecBillType().getName());
            billInfo.setCompany(info.getCompany());
        } else if ("40284E81".equals(bosType)) {
            sic.add(new SelectorItemInfo("payBillType.name"));
            PaymentBillInfo info = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setAmount(info.getAmount());
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillStatus(info.getBillStatus().getAlias());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSPAYABLE.getAlias());
            billInfo.setBillType(info.getPayBillType().getName());
            billInfo.setCompany(info.getCompany());
        } else if ("3C41FD86".equals(bosType)) {
            VerificationBillInfo info = VerificationBillFactory.getLocalInstance(ctx).getVerificationBillInfo((IObjectPK)new ObjectUuidPK(billId), verificationSic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSRECEIVABLE.getAlias());
            billInfo.setBillType(info.getVerificationType().getAlias());
            billInfo.setCompany(info.getCompany());
        } else if ("2F368848".equals(bosType)) {
            com.kingdee.eas.fi.ap.VerificationBillInfo info = com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx).getVerificationBillInfo((IObjectPK)new ObjectUuidPK(billId), verificationSic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setBillCreator(info.getCreator());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillSystem(SystemEnum.ACCOUNTSPAYABLE.getAlias());
            billInfo.setBillType(info.getVerificationType().getAlias());
            billInfo.setCompany(info.getCompany());
        } else if ("D001019A".equals(bosType)) {
            PayRequestBillInfo info = PayRequestBillFactory.getLocalInstance(ctx).getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(billId), sic);
            billInfo = new FileVoucherBillInfo();
            billInfo.setBillCreator(info.getCreator());
            billInfo.setAmount(info.getAuditAmount());
            billInfo.setBillNumber(info.getNumber());
            billInfo.setBillStatus(info.getBillStatus().getAlias());
            billInfo.setBillType(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"PayReqBill", (Locale)ctx.getLocale()));
            billInfo.setBillSystem(SystemEnum.ACCOUNTSPAYABLE.getAlias());
            billInfo.setCompany(info.getCompany());
        }
        return billInfo;
    }

    public Set getVoucherIdSet(Context ctx, String bosType, String billId) throws BOSException {
        Set set = null;
        if ("FC910EF3".equals(bosType) || "48DA3A71".equals(bosType) || "3C41FD86".equals(bosType) || "2F368848".equals(bosType)) {
            set = this.getOtherBillIDSet(ctx, bosType, billId);
        } else if ("FA44FD5B".equals(bosType) || "40284E81".equals(bosType)) {
            set = this.getRecPayIDSet(ctx, bosType, billId);
        } else if ("D001019A".equals(bosType)) {
            set = this.getPayRequestBillIDSet(ctx, bosType, billId);
        }
        return set;
    }

    public Set getPayRequestBillIDSet(Context ctx, String bosType, String billId) throws BOSException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        String tableName = "T_CAS_PAYMENTBILL";
        try {
            StringBuilder sqlBuilder = new StringBuilder(100);
            sqlBuilder.append(" select rel.FDESTOBJECTID from T_BOT_RELATION rel");
            sqlBuilder.append(" left join " + tableName + " bill on rel.FSRCOBJECTID = bill.FID ");
            sqlBuilder.append(" left join T_BOT_RELATION rel1 on rel1.FDESTOBJECTID = rel.FSRCOBJECTID ");
            sqlBuilder.append(" where rel.FSRCENTITYID = ? and rel.FDESTENTITYID = ? ");
            sqlBuilder.append(" and rel1.FSRCENTITYID = ? and rel1.FSRCOBJECTID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{"40284E81", "2652E01E", bosType, billId});
            while (rs.next()) {
                voucherIdSet.add(rs.getString("FDESTOBJECTID"));
            }
            if (voucherIdSet.size() > 0) {
                return voucherIdSet;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherIdSet;
    }

    public Set getOtherBillIDSet(Context ctx, String bosType, String billId) throws BOSException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        try {
            StringBuffer sql = new StringBuffer(" select FDESTOBJECTID from T_BOT_RELATION where FSRCENTITYID = ? and FSRCOBJECTID =? and FDESTENTITYID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bosType, billId, "2652E01E"});
            while (rs.next()) {
                voucherIdSet.add(rs.getString("FDESTOBJECTID"));
            }
            if (voucherIdSet.size() > 0) {
                return voucherIdSet;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherIdSet;
    }

    public Set getRecPayIDSet(Context ctx, String bosType, String billId) throws BOSException {
        String tableName = null;
        int sourceType = 0;
        if ("FA44FD5B".equals(bosType)) {
            tableName = "T_CAS_RECEIVINGBILL";
            sourceType = 100;
        } else if ("40284E81".equals(bosType)) {
            tableName = "T_CAS_PAYMENTBILL";
            sourceType = 101;
        }
        HashSet<String> voucherIdSet = new HashSet<String>();
        try {
            StringBuilder sqlBuilder = new StringBuilder(" select FDESTOBJECTID from T_BOT_RELATION rel");
            sqlBuilder.append(" left join " + tableName + " bill on rel.FSRCOBJECTID = bill.FID ");
            sqlBuilder.append(" where FSRCENTITYID = ? and FSRCOBJECTID = ? and FDESTENTITYID = ? ");
            sqlBuilder.append(" and bill.FSOURCETYPE = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{bosType, billId, "2652E01E", sourceType});
            while (rs.next()) {
                voucherIdSet.add(rs.getString("FDESTOBJECTID"));
            }
            if (voucherIdSet.size() > 0) {
                return voucherIdSet;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherIdSet;
    }
}

