/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.ImportException;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanCollection;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.fi.arap.AbstractProxyBillInfo;
import com.kingdee.eas.fi.arap.IProxyBill;
import com.kingdee.eas.fi.arap.ProxyBillCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryInfo;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.ProxyBillInfo;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanInfo;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.arap.app.AbstractARAPImportFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.ProxyBillDataImporter;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.BaseDataValidator;
import com.kingdee.eas.fi.arap.util.invoice.MakeInvoiceUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ARAPImportFacadeControllerBean
extends AbstractARAPImportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ARAPImportFacadeControllerBean");
    private CurrencyInfo baseCurrency = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private boolean isInitBill = false;
    private boolean arIsStart = true;
    private boolean isFinish = false;
    private boolean isConnSCM = false;
    private boolean isImportDataByRule = false;
    private List idList = new ArrayList();
    private CoreBaseInfo coreInfo = null;
    private Map isContrastAccountCache = new HashMap();
    protected final String[] AR_PLAN_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_RR", "FRecievePayAmountLocal_RR", "FVerifyAmount_RR", "FVerifyAmountLocal_RR"};
    protected final String[] AR_PLAN_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal"};
    protected final String[] AP_PLAN_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_PP", "FRecievePayAmountLocal_PP", "FVerifyAmount_PP", "FVerifyAmountLocal_PP"};
    protected final String[] AP_PLAN_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal"};
    private final String[] AR_DECIMAL_FIELDS = new String[]{"FExchangeRate", "FTotalBadAmount", "FTotalBadAmountLocal"};
    private final String[] AR_DECIMAL_OBJS = new String[]{"exchangeRate", "totalBadAmount", "totalBadAmountLocal"};
    private final String[] AR_ENTRY_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_E", "FRecievePayAmountLocal_E", "FVerifyAmount_E", "FVerifyAmountLocal_E", "FQuantity", "FPrice", "FTaxPrice", "FTaxRate", "FTaxAmount", "FBadAmout", "FLocalBadAmout", "FTaxAmountLocal", "FActualPrice", "FDiscountType", "FDiscountRate", "FDiscountAmount", "FDiscountAmountLocal", "FAmount_E", "FAmountLocal_E", "FAssistQty", "FRealPrice"};
    private final String[] AR_ENTRY_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal", "quantity", "price", "taxPrice", "taxRate", "taxAmount", "badAmount", "badAmountLocal", "taxAmountLocal", "actualPrice", "discountType", "discountRate", "discountAmount", "discountAmountLocal", "amount", "amountLocal", "assistQty", "realPrice"};
    private final String[] AP_DECIMAL_FIELDS = new String[]{"FExchangeRate"};
    private final String[] AP_DECIMAL_OBJS = new String[]{"exchangeRate"};
    private final String[] AP_ENTRY_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_E", "FRecievePayAmountLocal_E", "FVerifyAmount_E", "FVerifyAmountLocal_E", "FQuantity", "FPrice", "FTaxPrice", "FTaxRate", "FTaxAmount", "FTaxAmountLocal", "FActualPrice", "FDiscountType", "FDiscountRate", "FDiscountAmount", "FDiscountAmountLocal", "FAmount_E", "FAmountLocal_E", "FAssistQty", "FRealPrice"};
    private final String[] AP_ENTRY_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal", "quantity", "price", "taxPrice", "taxRate", "taxAmount", "taxAmountLocal", "actualPrice", "discountType", "discountRate", "discountAmount", "discountAmountLocal", "amount", "amountLocal", "assistQty", "realPrice"};
    private final String[] DATE_FIELDS = new String[]{"FBillDate", "FBizDate"};
    private final String[] DATE_OBJS = new String[]{"billDate", "bizDate"};
    private final String[] STRING_FIELDS = new String[]{"FAsstActNumber", "FAbstractName"};
    private final String[] STRING_OBJS = new String[]{"asstActNumber", "abstractName"};
    private final String[] ENTRY_STRING_FIELDS = new String[]{"FRemark_E", "FCoreBillNum"};
    private final String[] ENTRY_STRING_OBJS = new String[]{"remark", "coreBillNumber"};
    private SystemEnum defaultSysEnum;
    private SystemStatusCtrolInfo invStatus = null;
    private SystemStatusCtrolInfo cachedSysStatus = null;
    private SystemStatusCtrolInfo otherSysStatus = null;

    @Override
    protected IObjectPK _transfer(Context ctx, Hashtable hsData, String bill, ArrayList headDefineFieldList, ArrayList entryDefineFieldList) throws BOSException, EASBizException {
        if (bill == null || bill.trim().length() <= 0) {
            return null;
        }
        bill = bill.trim();
        try {
            boolean isAR;
            if (!bill.equalsIgnoreCase("PROXY")) {
                this.currentCompany = ARAPImportHelper.getCompany(ctx, hsData, "FCompanyID");
                this.baseCurrency = this.currentCompany.getBaseCurrency();
                if (this.baseCurrency == null) {
                    throw new ImportException(ImportException.CANNOTGETLOCALCURRENCY);
                }
            }
            this.defaultSysEnum = (isAR = ((Boolean)hsData.get("isAR")).booleanValue()) ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
            boolean isSCM = (Boolean)hsData.get("isSCM");
            this.isConnSCM = (Boolean)hsData.get("isConnSCM");
            if (isSCM) {
                this.invStatus = ArApBillHelper.getSysStatusCtrolInfo(ctx, this.currentCompany, SystemEnum.INVENTORYMANAGEMENT);
                if (this.isConnSCM) {
                    this.cachedSysStatus = ArApBillHelper.getSysStatusCtrolInfo(ctx, this.currentCompany, this.defaultSysEnum);
                    if (this.cachedSysStatus == null || this.cachedSysStatus.getStartPeriod() == null || this.cachedSysStatus.getCurrentPeriod() == null) {
                        throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.defaultSysEnum.getAlias()});
                    }
                }
            } else if (!bill.equalsIgnoreCase("PROXY")) {
                this.cachedSysStatus = ArApBillHelper.getSysStatusCtrolInfo(ctx, this.currentCompany, this.defaultSysEnum);
                if (this.cachedSysStatus == null || this.cachedSysStatus.getStartPeriod() == null || this.cachedSysStatus.getCurrentPeriod() == null) {
                    throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + " " + this.defaultSysEnum.getAlias()});
                }
                SystemEnum otherSys = this.defaultSysEnum == SystemEnum.ACCOUNTSPAYABLE ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
                this.otherSysStatus = ArApBillHelper.getSysStatusCtrolInfo(ctx, this.currentCompany, otherSys);
                this.startPeriod = this.cachedSysStatus.getStartPeriod();
                this.arIsStart = this.cachedSysStatus.isIsStart();
                this.currentPeriod = this.cachedSysStatus.getCurrentPeriod();
            }
            if (!bill.equalsIgnoreCase("PROXY") && this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName()});
            }
            this.isImportDataByRule = (Boolean)hsData.get("isImportDataByRule");
            if (bill.equalsIgnoreCase("AR")) {
                return this._importAROtherBill(ctx, hsData, headDefineFieldList, entryDefineFieldList);
            }
            if (bill.equalsIgnoreCase("AP")) {
                return this._importAPOtherBill(ctx, hsData, headDefineFieldList, entryDefineFieldList);
            }
            if (bill.equalsIgnoreCase("PROXY")) {
                hsData.put("IsImportDataByRule", this.isImportDataByRule);
                return this._importProxyOtherBill(ctx, hsData, headDefineFieldList, entryDefineFieldList);
            }
        }
        catch (TaskExternalException ex) {
            logger.error((Object)ex);
            throw new BOSException(ArApBillUtil.printExceptionMsg((Exception)((Object)ex)), (Throwable)ex);
        }
        return null;
    }

    private IObjectPK _importProxyOtherBill(Context ctx, Hashtable hsData, ArrayList headDefineFieldList, ArrayList entryDefineFieldList) throws TaskExternalException, EASBizException, BOSException {
        ProxyBillDataImporter proxy = new ProxyBillDataImporter(ctx);
        Map<String, Object> result = proxy.transfer(hsData, headDefineFieldList, entryDefineFieldList);
        Object proxyInfo = result.get("proxyBillInfo");
        Object proxyEntry = result.get("proxyBillEntryInfo");
        Object proxyPlan = result.get("proxyBillPlanInfo");
        this.transferProxyExtend(ctx, hsData, (ProxyBillInfo)proxyInfo, (ProxyBillEntryInfo)proxyEntry, (ProxyBillReceivePlanInfo)proxyPlan);
        IObjectPK pk = proxy.submit((CoreBaseInfo)proxyInfo);
        if (pk != null) {
            this.idList.add(pk.toString());
            if (this.coreInfo == null) {
                this.coreInfo = (CoreBaseInfo)proxyInfo;
            }
        }
        return pk;
    }

    @Override
    protected void _transferProxyExtend(Context ctx, Hashtable hsData, ProxyBillInfo proxyInfo, ProxyBillEntryInfo proxyBillEntryInfo, ProxyBillReceivePlanInfo proxyBillPlanInfo) throws BOSException {
    }

    private IObjectPK _importAPOtherBill(Context ctx, Hashtable hsData, ArrayList headDefineFieldList, ArrayList entryDefineFieldList) throws TaskExternalException, EASBizException, BOSException {
        BaseDataValidator baseDataValidator;
        boolean validate;
        int i;
        com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo = new com.kingdee.eas.fi.ap.OtherBillInfo();
        String str = null;
        boolean isUpdateBill = false;
        Date date = null;
        date = ARAPImportHelper.getDataDate(ctx, hsData, "FBillDate");
        if (date == null) {
            String msg = null;
            HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
            SimpleDateFormat dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
            msg = dtformat.toPattern().contains("/") ? ARAPImportFacadeControllerBean.getString("Date1Format_Wrong", ctx) : ARAPImportFacadeControllerBean.getString("DateFormat_Wrong", ctx);
            msg = MessageFormat.format(msg, "FBillDate");
            throw new TaskExternalException(msg);
        }
        otherBillInfo.setBillDate(date);
        this.isInitBill = otherBillInfo.getBillDate().before(this.startPeriod.getBeginDate());
        this.checkOrgPermission(ctx, false, this.isInitBill);
        this.isFinish = otherBillInfo.getBillDate().before(this.currentPeriod.getBeginDate());
        if (this.arIsStart && this.isInitBill) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Cannot_InitBill_Wrong", ctx));
        }
        if (!this.isInitBill && this.isFinish) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Cannot_FinistBill_Wrong", ctx));
        }
        otherBillInfo.setIsInitializeBill(this.isInitBill);
        str = ARAPImportHelper.getDataString(hsData, "FNumber");
        if (str != null) {
            otherBillInfo.setNumber(str);
            try {
                com.kingdee.eas.fi.ap.IOtherBill iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
                EntityViewInfo viewInfo = ARAPImportFacadeControllerBean.getAscDefaultEntVByNum(str);
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                com.kingdee.eas.fi.ap.OtherBillCollection collection = iOtherBill.getOtherBillCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    otherBillInfo = collection.get(0);
                    if (!otherBillInfo.getAsstActNumber().equals(((DataToken)hsData.get((Object)"FAsstActNumber")).data)) {
                        throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FBillNumber_IsExist", ctx));
                    }
                    if (3 == otherBillInfo.getBillStatus().getValue()) {
                        throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("BillStatusAudited", ctx));
                    }
                    isUpdateBill = true;
                }
                isUpdateBill = false;
            }
            catch (Exception e) {
                throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), (Throwable)e);
            }
        } else if (this.isImportDataByRule) {
            isUpdateBill = false;
        } else {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("NumberNoFound", ctx));
        }
        CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        ExchangeRateInfo exgRateInfo = null;
        try {
            if (this.currentCompany != null && currency != null) {
                exgRateInfo = ARAPImportHelper.getExchangeRateInfo(ctx, this.currentCompany, currency);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(ex), (Throwable)ex);
        }
        if (exgRateInfo != null) {
            scale = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                scale = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        for (i = 0; i < this.AP_DECIMAL_FIELDS.length; ++i) {
            BigDecimal amtVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AP_DECIMAL_FIELDS[i]);
            otherBillInfo.setBigDecimal(this.AP_DECIMAL_OBJS[i], amtVal.setScale(scale, 4));
            this.setCheckField(this.AP_DECIMAL_FIELDS[i], amtVal, ctx);
        }
        otherBillInfo.setLastExhangeRate(otherBillInfo.getExchangeRate().setScale(scale, 4));
        if (this.baseCurrency != null && this.baseCurrency.getId().equals((Object)currency.getId()) && BigDecimal.ONE.compareTo(otherBillInfo.getExchangeRate()) != 0) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("EXCHANGE_RATE_ERROR", ctx));
        }
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            date = ARAPImportHelper.getDataDate(ctx, hsData, this.DATE_FIELDS[i]);
            if (date == null) continue;
            otherBillInfo.setDate(this.DATE_OBJS[i], date);
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
            otherBillInfo.setString(this.STRING_OBJS[i], str);
        }
        otherBillInfo.setBillStatus(BillStatusEnum.SAVE);
        otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
        otherBillInfo.setBillType(ARAPImportHelper.getAPBillType(hsData, "FBillType"));
        boolean isInTax = true;
        boolean isPriceWiTax = true;
        if (OtherBillType.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
            isPriceWiTax = false;
        }
        otherBillInfo.setIsInTax(isInTax);
        otherBillInfo.setIsPriceWithoutTax(isPriceWiTax);
        otherBillInfo.setIsBizBill(ARAPImportHelper.getDataboolean(hsData, "FIsBizBill"));
        PaymentTypeInfo paymentType = ARAPImportHelper.getPaymentTypeInfo(ctx, hsData, "FPaymentTypeID");
        if (paymentType != null && ("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equals(paymentType.getId().toString()) || "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(paymentType.getId().toString()))) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("PaymentType_Is_Error", ctx));
        }
        otherBillInfo.setPaymentType(paymentType);
        otherBillInfo.setPurchaseGroup(ARAPImportHelper.getPurchaseGroupInfo(ctx, hsData, "FPurchaseGroupID"));
        otherBillInfo.setCurrency(ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID"));
        otherBillInfo.setSettleType(ARAPImportHelper.getSettlementTypeInfo(ctx, hsData, "FSettleTypeID"));
        otherBillInfo.setCU(this.currentCompany.getCU());
        otherBillInfo.setCompany(this.currentCompany);
        otherBillInfo.setAdminOrgUnit(ARAPImportHelper.getAdminOrgUnitInfo(ctx, hsData, "FAdminOrgUnitID"));
        otherBillInfo.setPerson(ARAPImportHelper.getPersonInfo(ctx, hsData, "FPersonID"));
        PurchaseOrgUnitInfo info = ARAPImportHelper.getPurchaseOrg(ctx, hsData, "FPurOrgID");
        if (info == null && !this.isInitBill && this.isConnSCM && otherBillInfo.getBillType().getValue() != 201) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("APInvoiceBill_Org_IsNull", ctx));
        }
        otherBillInfo.setPurOrg(info);
        AsstActTypeInfo asstActTypeInfo = ARAPImportHelper.getAsstActTypeInfo(ctx, hsData, "FAsstActTypeID");
        otherBillInfo.setAsstActType(asstActTypeInfo);
        if (!this.checkAsstAccID(ctx, asstActTypeInfo, hsData, otherBillInfo)) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("AsstActNumber_Wrong", ctx));
        }
        if (!ARAPImportHelper.isExistAsstActByCompany(ctx, this.currentCompany, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID())) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", ctx));
        }
        if (!this.checkAsstActStatus(ctx, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID())) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotApproved", ctx));
        }
        otherBillInfo.setCashDiscount(ARAPImportHelper.getCashDiscountInfo(ctx, hsData, "FCashDiscountID"));
        if (!this.checkBillDate(otherBillInfo, ctx)) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("BizDate_BillDate_Wrong", ctx));
        }
        com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo = this.transferAPEntry(ctx, hsData, otherBillInfo, otherBillInfo.getNumber(), entryDefineFieldList, isUpdateBill);
        this.checkEntryVerifyAmount(ctx, otherBillInfo, scale, exgRateInfo, entryInfo);
        com.kingdee.eas.fi.ap.OtherBillPlanInfo planInfo = this.transferAPPlan(ctx, hsData, otherBillInfo, isUpdateBill);
        this.transferAPExtend(ctx, hsData, otherBillInfo, entryInfo, planInfo);
        IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        boolean isContrast = false;
        String key = "";
        if (entryInfo.getAccount() != null) {
            key = otherBillInfo.getCU().getId().toString() + otherBillInfo.getCompany().getId().toString() + entryInfo.getAccount().getId().toString() + AccountControlAttribute.AP.getValue();
            if (this.isContrastAccountCache.get(key) != null) {
                isContrast = (Boolean)this.isContrastAccountCache.get(key);
            } else {
                isContrast = iContrastAcct.isContrastAccount(otherBillInfo.getCU().getId().toString(), otherBillInfo.getCompany().getId().toString(), entryInfo.getAccount().getId().toString(), AccountControlAttribute.AP);
                this.isContrastAccountCache.put(key, isContrast);
            }
            if (!isContrast) {
                throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.ACCOUNT_NOT_CONTRAST);
            }
        }
        if (!(StringUtils.isEmpty((String)otherBillInfo.getAsstActID()) || this.isInitBill || (validate = (baseDataValidator = new BaseDataValidator(otherBillInfo.getCompany().getId().toString(), QueryDataAccessFactory.getLocalInstance((Context)ctx))).validate(otherBillInfo.getAsstActID())))) {
            BOSUuid uuid = BOSUuid.read((String)otherBillInfo.getAsstActID());
            IObjectValue asscactInfo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"ASST_FREEZE", (Locale)ctx.getLocale(), (Object[])new Object[]{asscactInfo.get("name")}));
        }
        ARAPImportHelper.checkCalculate(ctx, otherBillInfo, otherBillInfo.getNumber());
        return this._saveAPBill(ctx, hsData, otherBillInfo);
    }

    protected void checkEntryVerifyAmount(Context ctx, ArApBillBaseInfo otherBillInfo, int scale, ExchangeRateInfo exgRateInfo, ArApBillEntryBaseInfo entryInfo) throws TaskExternalException {
        String exceptionMsg = ArApBillHelper.checkEntryAmountForInitBill(ctx, otherBillInfo, scale, exgRateInfo, entryInfo);
        if (!StringUtils.isEmpty((String)exceptionMsg)) {
            throw new TaskExternalException(exceptionMsg);
        }
    }

    private com.kingdee.eas.fi.ap.OtherBillentryInfo transferAPEntry(Context ctx, Hashtable hsData, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, Object numberdata, ArrayList entryDefineFieldList, boolean isUpdateBill) throws TaskExternalException, BOSException {
        com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        com.kingdee.eas.fi.ap.OtherBillentryCollection entryCollection = null;
        String FAmount_E = ARAPImportHelper.getDataString(hsData, "FAmount_E");
        if (FAmount_E == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FAmount_E_IsNull", ctx));
        }
        String FAmountLocal_E = ARAPImportHelper.getDataString(hsData, "FAmountLocal_E");
        if (FAmountLocal_E == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FAmountLocal_E_IsNull", ctx));
        }
        String FRecievePayAmount_E = ARAPImportHelper.getDataString(hsData, "FRecievePayAmount_E");
        if (FRecievePayAmount_E == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("AP", "FRecievePayAmount_E_IsNull", ctx));
        }
        String FRecievePayAmountLocal_E = ARAPImportHelper.getDataString(hsData, "FRecievePayAmountLocal_E");
        if (FRecievePayAmountLocal_E == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FRecievePayAmountLocal_E_IsNull", ctx));
        }
        try {
            String data = ARAPImportHelper.getDataString(hsData, "FSeq_E");
            if (data != null) {
                int seq = Integer.parseInt(data);
                entryCollection = otherBillInfo.getEntry();
                int num = entryCollection.size();
                for (int i = 0; i < num; ++i) {
                    com.kingdee.eas.fi.ap.OtherBillentryInfo tempEntryInfo = entryCollection.get(i);
                    if (tempEntryInfo.getSeq() != seq) continue;
                    entryInfo = tempEntryInfo;
                    isUpdateEntry = true;
                }
                if (!isUpdateEntry) {
                    entryInfo = new com.kingdee.eas.fi.ap.OtherBillentryInfo();
                    entryInfo.setHead(otherBillInfo);
                    entryInfo.setSeq(seq);
                    entryInfo.setCompany(String.valueOf(otherBillInfo.getCompany().getId()));
                    entryInfo.setBillDate(otherBillInfo.getBillDate());
                    this.createAPEntryInfo(ctx, otherBillInfo, entryInfo, hsData, entryDefineFieldList, isUpdateEntry);
                    entryCollection.add(entryInfo);
                }
                otherBillInfo.put("entry", (Object)entryCollection);
            } else if (!isUpdateBill) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("EntrySeq_NoFound", ctx));
            }
        }
        catch (NumberFormatException e) {
            String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg, (Throwable)e);
        }
        return entryInfo;
    }

    private void createAPEntryInfo(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo, Hashtable hsData, ArrayList entryDefineFieldList, boolean isUpdateEntry) throws TaskExternalException, BOSException {
        int i;
        AccountViewInfo account = null;
        String str = null;
        BigDecimal decVal = null;
        CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
        for (i = 0; i < this.AP_ENTRY_DECIMAL_FIELDS.length; ++i) {
            decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AP_ENTRY_DECIMAL_FIELDS[i]);
            try {
                if (decVal != null) {
                    if (this.AP_ENTRY_DECIMAL_FIELDS[i].indexOf("Local") != -1) {
                        decVal = decVal.setScale(scaleLocal, 4);
                    } else if (this.AP_ENTRY_DECIMAL_FIELDS[i].indexOf("Amount") != -1) {
                        decVal = decVal.setScale(scale, 4);
                    }
                    if (!ImportDataUtil.checkIsPositiveRate(this.AP_ENTRY_DECIMAL_OBJS[i], decVal.toString())) {
                        String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
                        msg = MessageFormat.format(msg, this.AP_ENTRY_DECIMAL_FIELDS[i]);
                        throw new TaskExternalException(msg);
                    }
                    if (ImportDataUtil.checkIsVerifyamount(this.AP_ENTRY_DECIMAL_OBJS[i]) && this.isInitBill) {
                        entryInfo.setBigDecimal("unVerifyAmount", entryInfo.getBigDecimal("recievePayAmount").subtract(decVal));
                    }
                    if (ImportDataUtil.checkIsVerifyamountLocal(this.AP_ENTRY_DECIMAL_OBJS[i]) && this.isInitBill) {
                        entryInfo.setBigDecimal("unVerifyAmountLocal", entryInfo.getBigDecimal("recievePayAmountLocal").subtract(decVal));
                    }
                    if (!ImportDataUtil.checkIsVerifyamount(this.AP_ENTRY_DECIMAL_OBJS[i]) && !ImportDataUtil.checkIsVerifyamountLocal(this.AP_ENTRY_DECIMAL_OBJS[i])) {
                        entryInfo.setBigDecimal(this.AP_ENTRY_DECIMAL_OBJS[i], decVal);
                        continue;
                    }
                    if (!this.isInitBill) continue;
                    entryInfo.setBigDecimal(this.AP_ENTRY_DECIMAL_OBJS[i], decVal);
                    continue;
                }
                entryInfo.setBigDecimal(this.AP_ENTRY_DECIMAL_OBJS[i], ARAPImportHelper.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
                msg = MessageFormat.format(msg, this.AP_ENTRY_DECIMAL_FIELDS[i]);
                throw new TaskExternalException(msg);
            }
        }
        for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
            entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
        }
        OtherBillType billType = otherBillInfo.getBillType();
        entryInfo.setCoreBillEntrySeq(ARAPImportHelper.getCoreBillSeq(ctx, hsData));
        entryInfo.setIsQtyZero(ARAPImportHelper.getDataboolean(hsData, "FIsQtyZero"));
        try {
            MeasureUnitInfo unit = ARAPImportHelper.getMeasureUnitInfo(ctx, hsData, "FMeatureUnit");
            entryInfo.setMeasureUnit(unit);
            if (billType.getValue() == 202) {
                MaterialInfo material = ARAPImportHelper.getMaterialInfo(ctx, hsData, "FMaterialID");
                if (material == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Material_Wrong", ctx));
                }
                if (unit == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("MeasureUnit_Wrong", ctx));
                }
                entryInfo.setMaterial(material);
                entryInfo.setMaterialName(material.getName());
                entryInfo.setBaseUnit(material.getBaseUnit());
                entryInfo.setMaterialModel(material.getModel());
                AsstAttrValueInfo asstAttrValueInfo = ARAPImportHelper.getAsstAttrValueInfo(ctx, hsData, "FASSISTPROPERTYID");
                entryInfo.setAssistProperty(asstAttrValueInfo);
                entryInfo.setBaseQty(ARAPImportHelper.getBaseUnitQty(ctx, unit, material, entryInfo.getQuantity()));
            } else {
                ExpenseTypeInfo expenseItem = ARAPImportHelper.getExpenseItemInfo(ctx, hsData, "FExpenseItemID");
                if (expenseItem == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("ExpenseItem_Wrong", ctx));
                }
                entryInfo.setExpenseItem(expenseItem);
                entryInfo.setBaseUnit(unit);
                entryInfo.setBaseQty(entryInfo.getQuantity());
            }
            entryInfo.setCoreBillType(ARAPImportHelper.getBillType(ctx, hsData, "FCoreBillType"));
            account = ARAPImportHelper.getAccountViewInfo(ctx, hsData, "FAccountID", this.currentCompany.getId().toString());
            if (this.isInitBill && account == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("AP_Account_Is_Null", ctx));
            }
            entryInfo.setAccount(account);
            entryInfo.setAssistUnit(ARAPImportHelper.getMeasureUnitInfo(ctx, hsData, "FAssistUnitID"));
            entryInfo.setOppAccount(ARAPImportHelper.getAccountViewInfo(ctx, hsData, "FOppAccountID", this.currentCompany.getId().toString()));
            if (entryInfo.getQuantity().compareTo(ARAPImportHelper.ZERO) == 0 && otherBillInfo.getBillType().getValue() == 203) {
                entryInfo.setQuantity(new BigDecimal(1.0));
            }
            if (!this.isInitBill) {
                entryInfo.setVerifyAmount(ARAPImportHelper.ZERO);
                entryInfo.setVerifyAmountLocal(ARAPImportHelper.ZERO);
                entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount());
                entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal());
            }
            entryInfo.setLockVerifyAmt(entryInfo.getVerifyAmount());
            entryInfo.setLockVerifyAmtLocal(entryInfo.getVerifyAmountLocal());
            entryInfo.setLockUnVerifyAmt(entryInfo.getUnVerifyAmount());
            entryInfo.setLockUnVerifyAmtLocal(entryInfo.getUnVerifyAmountLocal());
            ARAPImportHelper.setAPBillAmtFromEntry(otherBillInfo, entryInfo, isUpdateEntry);
            if (otherBillInfo.isIsInitializeBill()) {
                entryInfo.setHisUnVerifyAmount(entryInfo.getUnVerifyAmount());
                entryInfo.setHisUnVerifyAmountLocal(entryInfo.getUnVerifyAmountLocal());
            }
            entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
            entryInfo.setLocalUnwriteOffAmount(entryInfo.getRecievePayAmountLocal());
            entryInfo.setApportionAmount(ARAPImportHelper.ZERO);
            entryInfo.setUnApportionAmount(entryInfo.getAmountLocal());
            BigDecimal totalAmount = otherBillInfo.getTotalAmount();
            otherBillInfo.setThisApAmount(otherBillInfo.getAmount());
            BigDecimal totalTax = otherBillInfo.getTotalTax();
            if (totalAmount == null) {
                totalAmount = ARAPImportHelper.ZERO;
            }
            if (totalTax == null) {
                totalTax = ARAPImportHelper.ZERO;
            }
            otherBillInfo.setTotalAmount(totalAmount.add(entryInfo.getAmount()));
            otherBillInfo.setTotalTax(totalTax.add(entryInfo.getTaxAmount()));
            otherBillInfo.setTotalTaxAmount(otherBillInfo.getTotalAmount().add(otherBillInfo.getTotalTax()));
            otherBillInfo.setThisApAmount(otherBillInfo.getAmount());
            BigDecimal totalAmountLocal = null != otherBillInfo.getTotalAmountLocal() ? otherBillInfo.getTotalAmountLocal() : ARAPImportHelper.ZERO;
            BigDecimal totalTaxLocal = null != otherBillInfo.getTotalTaxLocal() ? otherBillInfo.getTotalTaxLocal() : ARAPImportHelper.ZERO;
            otherBillInfo.setTotalAmountLocal(totalAmountLocal.add(entryInfo.getAmountLocal()));
            otherBillInfo.setTotalTaxLocal(totalTaxLocal.add(entryInfo.getTaxAmountLocal()));
            if (entryInfo.isIsQtyZero()) {
                entryInfo.setQuantity(BigDecimal.ZERO);
                entryInfo.setAssistQty(BigDecimal.ZERO);
                entryInfo.setPrice(BigDecimal.ZERO);
                entryInfo.setTaxPrice(BigDecimal.ZERO);
                entryInfo.setRealPrice(BigDecimal.ZERO);
                entryInfo.setActualPrice(BigDecimal.ZERO);
                entryInfo.setDiscountAmount(BigDecimal.ZERO);
                entryInfo.setDiscountAmountLocal(BigDecimal.ZERO);
                entryInfo.setDiscountRate(BigDecimal.ZERO);
                entryInfo.setDiscountType(DiscountModeEnum.NULL);
            }
            this.setMakeInvoiceReqRelationFields(entryInfo);
        }
        catch (BaseException ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg((Exception)((Object)ex)), (Throwable)ex);
        }
    }

    private com.kingdee.eas.fi.ap.OtherBillPlanInfo transferAPPlan(Context ctx, Hashtable hsData, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, boolean isUpdateBill) throws TaskExternalException {
        Object data = null;
        com.kingdee.eas.fi.ap.OtherBillPlanInfo planInfo = null;
        boolean isUpdatePlan = false;
        com.kingdee.eas.fi.ap.OtherBillPlanCollection planCollection = null;
        int ind = 0;
        boolean isNeedCheck = false;
        try {
            data = ((DataToken)hsData.get((Object)"FSeq_PP")).data;
            if (data != null && data.toString().trim().length() > 0) {
                int size;
                int seq = Integer.parseInt(data.toString());
                planCollection = otherBillInfo.getPayPlan();
                int num = planCollection.size();
                for (int i = 0; i < num; ++i) {
                    com.kingdee.eas.fi.ap.OtherBillPlanInfo tempPlanInfo = planCollection.get(i);
                    if (tempPlanInfo.getSeq() != seq) continue;
                    planInfo = tempPlanInfo;
                    isUpdatePlan = true;
                    ind = i;
                }
                if (!isUpdatePlan) {
                    planInfo = new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
                    planInfo.setParent(otherBillInfo);
                    planInfo.setSeq(seq);
                    isNeedCheck = this.createPlanInfo_AP(ctx, otherBillInfo, planInfo, hsData, isUpdatePlan);
                    planCollection.add(planInfo);
                } else {
                    isNeedCheck = this.createPlanInfo_AP(ctx, otherBillInfo, planInfo, hsData, isUpdatePlan);
                    planCollection.set(ind, planInfo);
                }
                otherBillInfo.put("payPlan", (Object)planCollection);
                if (isNeedCheck && hsData.get("size") != null && (size = Integer.parseInt(hsData.get("size").toString())) == 1) {
                    this.checkAmount_AP(ctx, otherBillInfo);
                }
            }
        }
        catch (NumberFormatException e) {
            String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg);
        }
        return planInfo;
    }

    private boolean createPlanInfo_AP(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo, com.kingdee.eas.fi.ap.OtherBillPlanInfo planInfo, Hashtable hsData, boolean isUpdatePlan) throws TaskExternalException {
        try {
            boolean isNeedCheck = false;
            CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
            int scale = 4;
            if (currency != null) {
                scale = currency.getPrecision();
            }
            int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
            for (int i = 0; i < this.AP_PLAN_DECIMAL_FIELDS.length; ++i) {
                try {
                    BigDecimal value = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AP_PLAN_DECIMAL_FIELDS[i]);
                    if (value != null) {
                        if (this.AP_PLAN_DECIMAL_FIELDS[i].indexOf("Local") != -1) {
                            planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], value.setScale(scaleLocal, 4));
                        } else {
                            planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], value.setScale(scale, 4));
                        }
                        isNeedCheck = true;
                        continue;
                    }
                    if ("FRecievePayAmount_PP".equals(this.AP_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], otherBillInfo.getAmount().setScale(scale, 4));
                        continue;
                    }
                    if ("FRecievePayAmountLocal_PP".equals(this.AP_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], otherBillInfo.getAmountLocal().setScale(scaleLocal, 4));
                        continue;
                    }
                    if ("FVerifyAmount_PP".equals(this.AP_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], otherBillInfo.getVerifyAmount().setScale(scale, 4));
                        continue;
                    }
                    if (!"FVerifyAmountLocal_PP".equals(this.AP_PLAN_DECIMAL_FIELDS[i])) continue;
                    planInfo.setBigDecimal(this.AP_PLAN_DECIMAL_OBJS[i], otherBillInfo.getVerifyAmountLocal().setScale(scaleLocal, 4));
                    continue;
                }
                catch (Exception nex) {
                    logger.error((Object)nex);
                    String msg = ARAPImportHelper.getString("NumberField_Wrong", ctx);
                    msg = MessageFormat.format(msg, this.AP_PLAN_DECIMAL_FIELDS[i]);
                    throw new TaskExternalException(msg);
                }
            }
            planInfo.setUnLockAmount(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmount()));
            planInfo.setUnLockAmountLoc(planInfo.getRecievePayAmountLocal().subtract(planInfo.getVerifyAmountLocal()));
            planInfo.setLockAmount(planInfo.getVerifyAmount());
            planInfo.setLockAmountLoc(planInfo.getVerifyAmountLocal());
            planInfo.setUnVerifyAmount(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmount()));
            planInfo.setUnVerifyAmountLocal(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmountLocal()));
            Date date = ARAPImportHelper.getDataDate(ctx, hsData, "FRecievePayDate_PP");
            if (date != null) {
                planInfo.setDate("recievePayDate", date);
            } else {
                planInfo.setDate("recievePayDate", otherBillInfo.getBillDate());
            }
            return isNeedCheck;
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg((Exception)((Object)ex)));
        }
    }

    private void checkAmount_AP(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo) throws TaskExternalException {
        int i;
        BigDecimal recievePayAmountSum = new BigDecimal(0.0);
        BigDecimal recievePayAmountLocalSum = new BigDecimal(0.0);
        BigDecimal verifyAmountSum = new BigDecimal(0.0);
        BigDecimal verifyAmountLocalSum = new BigDecimal(0.0);
        BigDecimal recievePayAmountSum_PP = new BigDecimal(0.0);
        BigDecimal recievePayAmountLocalSum_PP = new BigDecimal(0.0);
        BigDecimal verifyAmountSum_PP = new BigDecimal(0.0);
        BigDecimal verifyAmountLocalSum_PP = new BigDecimal(0.0);
        com.kingdee.eas.fi.ap.OtherBillentryCollection entryCollection = otherBillInfo.getEntry();
        com.kingdee.eas.fi.ap.OtherBillPlanCollection planCollection = otherBillInfo.getPayPlan();
        for (i = 0; i < entryCollection.size(); ++i) {
            recievePayAmountSum = recievePayAmountSum.add(entryCollection.get(i).getRecievePayAmount());
            recievePayAmountLocalSum = recievePayAmountLocalSum.add(entryCollection.get(i).getRecievePayAmountLocal());
            verifyAmountSum = verifyAmountSum.add(entryCollection.get(i).getVerifyAmount());
            verifyAmountLocalSum = verifyAmountLocalSum.add(entryCollection.get(i).getVerifyAmountLocal());
        }
        for (i = 0; i < planCollection.size(); ++i) {
            recievePayAmountSum_PP = recievePayAmountSum_PP.add(planCollection.get(i).getRecievePayAmount());
            recievePayAmountLocalSum_PP = recievePayAmountLocalSum_PP.add(planCollection.get(i).getRecievePayAmountLocal());
            verifyAmountSum_PP = verifyAmountSum_PP.add(planCollection.get(i).getVerifyAmount());
            verifyAmountLocalSum_PP = verifyAmountLocalSum_PP.add(planCollection.get(i).getVerifyAmountLocal());
        }
        if (recievePayAmountSum.compareTo(recievePayAmountSum_PP) != 0) {
            String msg = ARAPImportHelper.getString("recievePayAmount_PP_Wrong", ctx);
            msg = MessageFormat.format(msg, "FRecievePayAmount_PP");
            throw new TaskExternalException(msg);
        }
        if (recievePayAmountLocalSum.compareTo(recievePayAmountLocalSum_PP) != 0) {
            String msg = ARAPImportHelper.getString("recievePayAmountLocal_PP_Wrong", ctx);
            msg = MessageFormat.format(msg, "FRecievePayAmountLocal_PP");
            throw new TaskExternalException(msg);
        }
        if (verifyAmountSum.compareTo(verifyAmountSum_PP) != 0) {
            String msg = ARAPImportHelper.getString("verifyAmount_PP_Wrong", ctx);
            msg = MessageFormat.format(msg, "FVerifyAmount_PP");
            throw new TaskExternalException(msg);
        }
        if (verifyAmountLocalSum.compareTo(verifyAmountLocalSum_PP) != 0) {
            String msg = ARAPImportHelper.getString("verifyAmountLocal_PP_Wrong", ctx);
            msg = MessageFormat.format(msg, "FVerifyAmountLocal_PP");
            throw new TaskExternalException(msg);
        }
    }

    private IObjectPK _importAROtherBill(Context ctx, Hashtable hsData, ArrayList headDefineFieldList, ArrayList entryDefineFieldList) throws TaskExternalException, EASBizException, BOSException {
        int i;
        OtherBillInfo otherBillInfo = new OtherBillInfo();
        String str = null;
        boolean isUpdateBill = false;
        Date date = null;
        date = ARAPImportHelper.getDataDate(ctx, hsData, "FBillDate");
        if (date == null) {
            if (date == null) {
                String msg = ARAPImportFacadeControllerBean.getString("DateIsNull", ctx);
                throw new TaskExternalException(msg);
            }
            String msg = null;
            HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
            SimpleDateFormat dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
            msg = dtformat.toPattern().contains("/") ? ARAPImportFacadeControllerBean.getString("Date1Format_Wrong", ctx) : ARAPImportFacadeControllerBean.getString("DateFormat_Wrong", ctx);
            msg = MessageFormat.format(msg, "FBillDate");
            throw new TaskExternalException(msg);
        }
        otherBillInfo.setBillDate(date);
        boolean isRedType = ARAPImportHelper.getDataboolean(hsData, "FRedBlueType");
        otherBillInfo.setRedBlueType(isRedType);
        this.isInitBill = otherBillInfo.getBillDate().before(this.startPeriod.getBeginDate());
        this.checkOrgPermission(ctx, true, this.isInitBill);
        this.isFinish = otherBillInfo.getBillDate().before(this.currentPeriod.getBeginDate());
        if (this.isInitBill && this.arIsStart) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Cannot_InitBill_Wrong", ctx));
        }
        if (!this.isInitBill && this.isFinish) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Cannot_FinistBill_Wrong", ctx));
        }
        otherBillInfo.setIsInitializeBill(this.isInitBill);
        str = ARAPImportHelper.getDataString(hsData, "FNumber");
        if (str != null) {
            otherBillInfo.setNumber(str);
            try {
                IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
                EntityViewInfo viewInfo = ARAPImportFacadeControllerBean.getAscDefaultEntVByNum_ar(str);
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("cu.id", (Object)this.currentCompany.getCU().getId().toString()));
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                OtherBillCollection collection = iOtherBill.getOtherBillCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    otherBillInfo = collection.get(0);
                    if (!otherBillInfo.getAsstActNumber().equals(((DataToken)hsData.get((Object)"FAsstActNumber")).data)) {
                        throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FBillNumber_IsExist", ctx));
                    }
                    if (3 == otherBillInfo.getBillStatus().getValue()) {
                        throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("BillStatusAudited", ctx));
                    }
                    isUpdateBill = true;
                }
                isUpdateBill = false;
            }
            catch (Exception e) {
                throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), (Throwable)e);
            }
        } else if (this.isImportDataByRule) {
            isUpdateBill = false;
        } else {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("NumberNoFound", ctx));
        }
        CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        for (int i2 = 0; i2 < this.AR_DECIMAL_FIELDS.length; ++i2) {
            BigDecimal decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_DECIMAL_FIELDS[i2]);
            decVal = decVal.setScale(scale, 4);
            otherBillInfo.setBigDecimal(this.AR_DECIMAL_OBJS[i2], decVal);
            this.setCheckField(this.AR_DECIMAL_FIELDS[i2], decVal, ctx);
        }
        ExchangeRateInfo exgRateInfo = null;
        try {
            if (this.currentCompany != null && currency != null) {
                exgRateInfo = ARAPImportHelper.getExchangeRateInfo(ctx, this.currentCompany, currency);
                if (this.baseCurrency != null && this.baseCurrency.getId().equals((Object)currency.getId()) && BigDecimal.ONE.compareTo(otherBillInfo.getExchangeRate()) != 0) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("EXCHANGE_RATE_ERROR", ctx));
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(ex), (Throwable)ex);
        }
        if (exgRateInfo != null) {
            scale = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                scale = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        otherBillInfo.setLastExhangeRate(otherBillInfo.getExchangeRate());
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            date = ARAPImportHelper.getDataDate(ctx, hsData, this.DATE_FIELDS[i]);
            otherBillInfo.setDate(this.DATE_OBJS[i], date);
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
            otherBillInfo.setString(this.STRING_OBJS[i], str);
        }
        otherBillInfo.setBillStatus(BillStatusEnum.SAVE);
        otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
        otherBillInfo.setBillType(ARAPImportHelper.getARBillType(hsData, "FBillType"));
        boolean isInTax = true;
        boolean isPriceWiTax = true;
        if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
            isPriceWiTax = false;
        }
        otherBillInfo.setIsInTax(isInTax);
        otherBillInfo.setIsPriceWithoutTax(isPriceWiTax);
        otherBillInfo.setIsBizBill(ARAPImportHelper.getDataboolean(hsData, "FIsBizBill"));
        PaymentTypeInfo paymentType = ARAPImportHelper.getPaymentTypeInfo(ctx, hsData, "FPaymentTypeID");
        if (paymentType != null && ("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5".equals(paymentType.getId().toString()) || "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(paymentType.getId().toString()))) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("PaymentType_Is_Error", ctx));
        }
        otherBillInfo.setPaymentType(paymentType);
        otherBillInfo.setSaleGroup(ARAPImportHelper.getSaleGroupInfo(ctx, hsData, "FSaleGroupID"));
        otherBillInfo.setCurrency(ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID"));
        otherBillInfo.setSettleType(ARAPImportHelper.getSettlementTypeInfo(ctx, hsData, "FSettleTypeID"));
        otherBillInfo.setCU(this.currentCompany.getCU());
        otherBillInfo.setCompany(this.currentCompany);
        otherBillInfo.setAdminOrgUnit(ARAPImportHelper.getAdminOrgUnitInfo(ctx, hsData, "FAdminOrgUnitID"));
        otherBillInfo.setPerson(ARAPImportHelper.getPersonInfo(ctx, hsData, "FPersonID"));
        SaleOrgUnitInfo saleOrg = ARAPImportHelper.getSaleOrgUnitInfo(ctx, hsData, "FSaleOrgID");
        if (saleOrg == null && !this.isInitBill && this.isConnSCM && otherBillInfo.getBillType().getValue() != 101) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("ARInvoiceBill_Org_IsNull", ctx));
        }
        otherBillInfo.setSaleOrg(saleOrg);
        AsstActTypeInfo asstActTypeInfo = ARAPImportHelper.getAsstActTypeInfo(ctx, hsData, "FAsstActTypeID");
        otherBillInfo.setAsstActType(asstActTypeInfo);
        if (!this.checkAsstAccID(ctx, asstActTypeInfo, hsData, otherBillInfo)) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("AsstActNumber_Wrong", ctx));
        }
        this.handleCustomerTaxAndMail(ctx, otherBillInfo, asstActTypeInfo);
        if (!ARAPImportHelper.isExistAsstActByCompany(ctx, this.currentCompany, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID())) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", ctx));
        }
        if (!this.checkAsstActStatus(ctx, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID())) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotApproved", ctx));
        }
        otherBillInfo.setCashDiscount(ARAPImportHelper.getCashDiscountInfo(ctx, hsData, "FCashDiscountID"));
        if (!this.checkBillDate(otherBillInfo, ctx)) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("BizDate_BillDate_Wrong", ctx));
        }
        Object objVal = null;
        String fieldName = null;
        for (int i3 = 0; i3 < headDefineFieldList.size(); ++i3) {
            fieldName = headDefineFieldList.get(i3).toString();
            objVal = ((DataToken)hsData.get((Object)fieldName)).data;
            otherBillInfo.put(fieldName.substring(1), objVal);
        }
        OtherBillentryInfo entryInfo = this.transferAREntry(ctx, hsData, otherBillInfo, otherBillInfo.getNumber(), entryDefineFieldList, isUpdateBill);
        this.checkEntryVerifyAmount(ctx, otherBillInfo, scale, exgRateInfo, entryInfo);
        OtherBillPlanInfo planInfo = this.transferARPlan(ctx, hsData, otherBillInfo, isUpdateBill);
        this.transferARExtend(ctx, hsData, otherBillInfo, entryInfo, planInfo);
        String key = "";
        boolean isContrast = false;
        IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        if (entryInfo.getAccount() != null) {
            key = otherBillInfo.getCU().getId().toString() + otherBillInfo.getCompany().getId().toString() + entryInfo.getAccount().getId().toString() + AccountControlAttribute.AR.getValue();
            if (this.isContrastAccountCache.get(key) != null) {
                isContrast = (Boolean)this.isContrastAccountCache.get(key);
            } else {
                isContrast = iContrastAcct.isContrastAccount(otherBillInfo.getCU().getId().toString(), otherBillInfo.getCompany().getId().toString(), entryInfo.getAccount().getId().toString(), AccountControlAttribute.AR);
                this.isContrastAccountCache.put(key, isContrast);
            }
            if (!isContrast) {
                throw new OtherBillBizException(OtherBillBizException.ACCOUNT_NOT_CONTRAST);
            }
        }
        ARAPImportHelper.checkCalculate(ctx, otherBillInfo, otherBillInfo.getNumber());
        return this._saveARBill(ctx, hsData, otherBillInfo);
    }

    private void handleCustomerTaxAndMail(Context ctx, OtherBillInfo otherBillInfo, AsstActTypeInfo asstActTypeInfo) throws EASBizException, BOSException {
        if ("T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            boolean isDefault;
            IObjectCollection col;
            IObjectValue customerTaxInfo = MakeInvoiceUtils.getDefaultCustomerTaxInfo(ctx, otherBillInfo.getAsstActID(), null, otherBillInfo.getCompany().getId().toString());
            if (customerTaxInfo != null && (col = (IObjectCollection)customerTaxInfo.get("entries")).size() != 0 && (isDefault = ((Boolean)col.getObject(0).get("isDefault")).booleanValue())) {
                otherBillInfo.setComInvoiceName((String)customerTaxInfo.get("recCompanyName"));
                otherBillInfo.setTaxNo((String)customerTaxInfo.get("taxNumber"));
                otherBillInfo.setAddressAndTel((String)customerTaxInfo.get("addressTel"));
                otherBillInfo.setOBankAndAcountNum((String)customerTaxInfo.get("bankAccount"));
                otherBillInfo.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)((String)col.getObject(0).get("invoiceType"))));
            }
            this.setDefaultCustomerMailInfo(ctx, otherBillInfo);
        }
    }

    private IObjectValue setDefaultCustomerMailInfo(Context ctx, OtherBillInfo info) throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comOrgUnitId", info.getCompany().getId().toString());
        param.put("customerId", info.getAsstActID());
        IObjectValue defaultEntry = MakeInvoiceUtils.getDefaultCustomerMailInfo(ctx, param);
        if (defaultEntry != null) {
            info.setDisInvoicer((String)defaultEntry.get("contacts"));
            info.setRecBillAdress((String)defaultEntry.get("mailbox"));
            info.setRecBillEmail((String)defaultEntry.get("mailbox"));
            info.setRecBillComName((String)defaultEntry.get("companyName"));
            info.setMailNumber((String)defaultEntry.get("postalcode"));
            info.setRecBillPhone((String)defaultEntry.get("telephone"));
        }
        return defaultEntry;
    }

    private OtherBillentryInfo transferAREntry(Context ctx, Hashtable hsData, OtherBillInfo otherBillInfo, Object numberdata, ArrayList entryDefineFieldList, boolean isUpdateBill) throws TaskExternalException, BOSException {
        String data = null;
        OtherBillentryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        OtherBillentryCollection entryCollection = null;
        try {
            data = ARAPImportHelper.getDataString(hsData, "FSeq_E");
            if (data == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FSeq_E_IsNull", ctx));
            }
            String FAmount_E = ARAPImportHelper.getDataString(hsData, "FAmount_E");
            if (FAmount_E == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FAmount_E_IsNull", ctx));
            }
            String FAmountLocal_E = ARAPImportHelper.getDataString(hsData, "FAmountLocal_E");
            if (FAmountLocal_E == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FAmountLocal_E_IsNull", ctx));
            }
            String FRecievePayAmount_E = ARAPImportHelper.getDataString(hsData, "FRecievePayAmount_E");
            if (FRecievePayAmount_E == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FRecievePayAmount_E_IsNull", ctx));
            }
            String FRecievePayAmountLocal_E = ARAPImportHelper.getDataString(hsData, "FRecievePayAmountLocal_E");
            if (FRecievePayAmountLocal_E == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FRecievePayAmountLocal_E_IsNull", ctx));
            }
            if (data != null) {
                int seq = Integer.parseInt(data.toString());
                entryCollection = otherBillInfo.getEntry();
                int num = entryCollection.size();
                for (int i = 0; i < num; ++i) {
                    OtherBillentryInfo tempEntryInfo = entryCollection.get(i);
                    if (tempEntryInfo.getSeq() != seq) continue;
                    entryInfo = tempEntryInfo;
                    isUpdateEntry = true;
                }
                if (!isUpdateEntry) {
                    entryInfo = new OtherBillentryInfo();
                    entryInfo.setHead(otherBillInfo);
                    entryInfo.setSeq(seq);
                    entryInfo.setCompany(String.valueOf(otherBillInfo.getCompany().getId()));
                    entryInfo.setBillDate(otherBillInfo.getBillDate());
                    this.createAREntryInfo(ctx, otherBillInfo, entryInfo, hsData, entryDefineFieldList, isUpdateEntry);
                    entryCollection.add(entryInfo);
                }
                otherBillInfo.put("entry", (Object)entryCollection);
            } else if (!isUpdateBill) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("EntrySeq_NoFound", ctx));
            }
        }
        catch (NumberFormatException e) {
            String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg);
        }
        return entryInfo;
    }

    private OtherBillPlanInfo transferARPlan(Context ctx, Hashtable hsData, OtherBillInfo otherBillInfo, boolean isUpdateBill) throws TaskExternalException {
        Object data = null;
        OtherBillPlanInfo planInfo = null;
        boolean isUpdatePlan = false;
        OtherBillPlanCollection planCollection = null;
        int ind = 0;
        boolean isNeedCheck = false;
        try {
            data = ((DataToken)hsData.get((Object)"FSeq_RR")).data;
            if (data != null && data.toString().trim().length() > 0) {
                int size;
                int seq = Integer.parseInt(data.toString());
                planCollection = otherBillInfo.getRecievePlan();
                int num = planCollection.size();
                for (int i = 0; i < num; ++i) {
                    OtherBillPlanInfo tempPlanInfo = planCollection.get(i);
                    if (tempPlanInfo.getSeq() != seq) continue;
                    planInfo = tempPlanInfo;
                    isUpdatePlan = true;
                    ind = i;
                }
                if (!isUpdatePlan) {
                    planInfo = new OtherBillPlanInfo();
                    planInfo.setParent(otherBillInfo);
                    planInfo.setSeq(seq);
                    isNeedCheck = this.createPlanInfo(ctx, otherBillInfo, planInfo, hsData, isUpdatePlan);
                    planCollection.add(planInfo);
                } else {
                    isNeedCheck = this.createPlanInfo(ctx, otherBillInfo, planInfo, hsData, isUpdatePlan);
                    planCollection.set(ind, planInfo);
                }
                otherBillInfo.put("receivePlan", (Object)planCollection);
                if (isNeedCheck && hsData.get("size") != null && (size = Integer.parseInt(hsData.get("size").toString())) == 1) {
                    this.checkAmount(ctx, otherBillInfo);
                }
            }
        }
        catch (NumberFormatException e) {
            String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg);
        }
        return planInfo;
    }

    private boolean createPlanInfo(Context ctx, OtherBillInfo otherBillInfo, OtherBillPlanInfo planInfo, Hashtable hsData, boolean isUpdatePlan) throws TaskExternalException {
        try {
            boolean isNeedCheck = false;
            CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
            int scale = currency.getPrecision();
            int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
            for (int i = 0; i < this.AR_PLAN_DECIMAL_FIELDS.length; ++i) {
                try {
                    BigDecimal value = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_PLAN_DECIMAL_FIELDS[i]);
                    if (value != null) {
                        if (this.AR_PLAN_DECIMAL_FIELDS[i].indexOf("Local") != -1) {
                            planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], value.setScale(scaleLocal, 4));
                        } else {
                            planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], value.setScale(scale, 4));
                        }
                        isNeedCheck = true;
                        continue;
                    }
                    if ("FRecievePayAmount_RR".equals(this.AR_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], otherBillInfo.getAmount().setScale(scale, 4));
                        continue;
                    }
                    if ("FRecievePayAmountLocal_RR".equals(this.AR_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], otherBillInfo.getAmountLocal().setScale(scaleLocal, 4));
                        continue;
                    }
                    if ("FVerifyAmount_RR".equals(this.AR_PLAN_DECIMAL_FIELDS[i])) {
                        planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], otherBillInfo.getVerifyAmount().setScale(scale, 4));
                        continue;
                    }
                    if (!"FVerifyAmountLocal_RR".equals(this.AR_PLAN_DECIMAL_FIELDS[i])) continue;
                    planInfo.setBigDecimal(this.AR_PLAN_DECIMAL_OBJS[i], otherBillInfo.getVerifyAmountLocal().setScale(scaleLocal, 4));
                    continue;
                }
                catch (Exception nex) {
                    logger.error((Object)nex);
                    String msg = ARAPImportHelper.getString("NumberField_Wrong", ctx);
                    msg = MessageFormat.format(msg, this.AR_PLAN_DECIMAL_FIELDS[i]);
                    throw new TaskExternalException(msg);
                }
            }
            planInfo.setUnLockAmount(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmount()));
            planInfo.setUnLockAmountLoc(planInfo.getRecievePayAmountLocal().subtract(planInfo.getVerifyAmountLocal()));
            planInfo.setLockAmount(planInfo.getVerifyAmount());
            planInfo.setLockAmountLoc(planInfo.getVerifyAmountLocal());
            planInfo.setUnVerifyAmount(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmount()));
            planInfo.setUnVerifyAmountLocal(planInfo.getRecievePayAmount().subtract(planInfo.getVerifyAmountLocal()));
            Date date = ARAPImportHelper.getDataDate(ctx, hsData, "FRecievePayDate_RR");
            if (date != null) {
                planInfo.setDate("recievePayDate", date);
            } else {
                planInfo.setDate("recievePayDate", otherBillInfo.getBillDate());
            }
            return isNeedCheck;
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg((Exception)((Object)ex)));
        }
    }

    private void checkAmount(Context ctx, OtherBillInfo otherBillInfo) throws TaskExternalException {
        int i;
        BigDecimal recievePayAmountSum = new BigDecimal(0.0);
        BigDecimal recievePayAmountLocalSum = new BigDecimal(0.0);
        BigDecimal verifyAmountSum = new BigDecimal(0.0);
        BigDecimal verifyAmountLocalSum = new BigDecimal(0.0);
        BigDecimal recievePayAmountSum_RR = new BigDecimal(0.0);
        BigDecimal recievePayAmountLocalSum_RR = new BigDecimal(0.0);
        BigDecimal verifyAmountSum_RR = new BigDecimal(0.0);
        BigDecimal verifyAmountLocalSum_RR = new BigDecimal(0.0);
        OtherBillentryCollection entryCollection = otherBillInfo.getEntry();
        OtherBillPlanCollection planCollection = otherBillInfo.getRecievePlan();
        for (i = 0; i < entryCollection.size(); ++i) {
            recievePayAmountSum = recievePayAmountSum.add(entryCollection.get(i).getRecievePayAmount());
            recievePayAmountLocalSum = recievePayAmountLocalSum.add(entryCollection.get(i).getRecievePayAmountLocal());
            verifyAmountSum = verifyAmountSum.add(entryCollection.get(i).getVerifyAmount());
            verifyAmountLocalSum = verifyAmountLocalSum.add(entryCollection.get(i).getVerifyAmountLocal());
        }
        for (i = 0; i < planCollection.size(); ++i) {
            recievePayAmountSum_RR = recievePayAmountSum_RR.add(planCollection.get(i).getRecievePayAmount());
            recievePayAmountLocalSum_RR = recievePayAmountLocalSum_RR.add(planCollection.get(i).getRecievePayAmountLocal());
            verifyAmountSum_RR = verifyAmountSum_RR.add(planCollection.get(i).getVerifyAmount());
            verifyAmountLocalSum_RR = verifyAmountLocalSum_RR.add(planCollection.get(i).getVerifyAmountLocal());
        }
        if (recievePayAmountSum.compareTo(recievePayAmountSum_RR) != 0) {
            String msg = ARAPImportHelper.getString("recievePayAmount_RR_Wrong", ctx);
            msg = MessageFormat.format(msg, "FRecievePayAmount_RR");
            throw new TaskExternalException(msg);
        }
        if (recievePayAmountLocalSum.compareTo(recievePayAmountLocalSum_RR) != 0) {
            String msg = ARAPImportHelper.getString("recievePayAmountLocal_RR_Wrong", ctx);
            msg = MessageFormat.format(msg, "FRecievePayAmountLocal_RR");
            throw new TaskExternalException(msg);
        }
        if (verifyAmountSum.compareTo(verifyAmountSum_RR) != 0) {
            String msg = ARAPImportHelper.getString("verifyAmount_RR_Wrong", ctx);
            msg = MessageFormat.format(msg, "FVerifyAmount_RR");
            throw new TaskExternalException(msg);
        }
        if (verifyAmountLocalSum.compareTo(verifyAmountLocalSum_RR) != 0) {
            String msg = ARAPImportHelper.getString("verifyAmountLocal_RR_Wrong", ctx);
            msg = MessageFormat.format(msg, "FVerifyAmountLocal_RR");
            throw new TaskExternalException(msg);
        }
    }

    private void createAREntryInfo(Context ctx, OtherBillInfo otherBillInfo, OtherBillentryInfo entryInfo, Hashtable hsData, ArrayList entryDefineFieldList, boolean isUpdateEntry) throws TaskExternalException, BOSException {
        int i;
        AccountViewInfo account = null;
        String str = null;
        CurrencyInfo currency = ARAPImportHelper.getCurrencyInfo(ctx, hsData, "FCurrencyID");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
        BigDecimal decVal = null;
        for (i = 0; i < this.AR_ENTRY_DECIMAL_FIELDS.length; ++i) {
            decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_ENTRY_DECIMAL_FIELDS[i]);
            if (decVal != null) {
                if (this.AR_ENTRY_DECIMAL_FIELDS[i].indexOf("Local") != -1) {
                    decVal = decVal.setScale(scaleLocal, 4);
                } else if (this.AR_ENTRY_DECIMAL_FIELDS[i].indexOf("Amount") != -1) {
                    decVal = decVal.setScale(scale, 4);
                }
                if (!ImportDataUtil.checkIsPositiveRate(this.AR_ENTRY_DECIMAL_OBJS[i], decVal.toString())) {
                    String msg = ARAPImportFacadeControllerBean.getString("NumberField_Wrong", ctx);
                    msg = MessageFormat.format(msg, this.AR_ENTRY_DECIMAL_FIELDS[i]);
                    throw new TaskExternalException(msg);
                }
                if (ImportDataUtil.checkIsVerifyamount(this.AR_ENTRY_DECIMAL_OBJS[i]) && this.isInitBill) {
                    entryInfo.setBigDecimal("unVerifyAmount", entryInfo.getBigDecimal("recievePayAmount").subtract(decVal));
                }
                if (ImportDataUtil.checkIsVerifyamountLocal(this.AR_ENTRY_DECIMAL_OBJS[i]) && this.isInitBill) {
                    entryInfo.setBigDecimal("unVerifyAmountLocal", entryInfo.getBigDecimal("recievePayAmountLocal").subtract(decVal));
                }
                if (!ImportDataUtil.checkIsVerifyamount(this.AR_ENTRY_DECIMAL_OBJS[i]) && !ImportDataUtil.checkIsVerifyamountLocal(this.AR_ENTRY_DECIMAL_OBJS[i])) {
                    entryInfo.setBigDecimal(this.AR_ENTRY_DECIMAL_OBJS[i], decVal);
                    continue;
                }
                if (!this.isInitBill) continue;
                entryInfo.setBigDecimal(this.AR_ENTRY_DECIMAL_OBJS[i], decVal);
                continue;
            }
            entryInfo.setBigDecimal(this.AR_ENTRY_DECIMAL_OBJS[i], ARAPImportHelper.ZERO);
        }
        for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
            entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
        }
        entryInfo.setCoreBillEntrySeq(ARAPImportHelper.getCoreBillSeq(ctx, hsData));
        entryInfo.setIsQtyZero(ARAPImportHelper.getDataboolean(hsData, "FIsQtyZero"));
        OtherBillTypeEnum billType = otherBillInfo.getBillType();
        try {
            MeasureUnitInfo unit = ARAPImportHelper.getMeasureUnitInfo(ctx, hsData, "FMeatureUnit");
            entryInfo.setMeasureUnit(unit);
            if (billType.getValue() == 102) {
                MaterialInfo material = ARAPImportHelper.getMaterialInfo(ctx, hsData, "FMaterialID");
                if (material == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("Material_IsNull", ctx));
                }
                if (unit == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("MeasureUnit_IsNull", ctx));
                }
                entryInfo.setMaterial(material);
                entryInfo.setMaterialName(material.getName());
                entryInfo.setBaseUnit(material.getBaseUnit());
                entryInfo.setMaterialModel(material.getModel());
                AsstAttrValueInfo asstAttrValueInfo = ARAPImportHelper.getAsstAttrValueInfo(ctx, hsData, "FASSISTPROPERTYID");
                entryInfo.setAssistProperty(asstAttrValueInfo);
                entryInfo.setBaseQty(ARAPImportHelper.getBaseUnitQty(ctx, unit, material, entryInfo.getQuantity()));
            } else {
                ExpenseTypeInfo expenseItem = ARAPImportHelper.getExpenseItemInfo(ctx, hsData, "FExpenseItemID");
                if (expenseItem == null) {
                    throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("ExpenseItem_Wrong", ctx));
                }
                entryInfo.setExpenseItem(expenseItem);
                entryInfo.setBaseUnit(unit);
                entryInfo.setBaseQty(entryInfo.getQuantity());
            }
            entryInfo.setCoreBillType(ARAPImportHelper.getBillType(ctx, hsData, "FCoreBillType"));
            account = ARAPImportHelper.getAccountViewInfo(ctx, hsData, "FAccountID", this.currentCompany.getId().toString());
            if (this.isInitBill && account == null) {
                throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("AR_Account_Is_Null", ctx));
            }
            entryInfo.setAccount(account);
            entryInfo.setAssistUnit(ARAPImportHelper.getMeasureUnitInfo(ctx, hsData, "FAssistUnitID"));
            entryInfo.setOppAccount(ARAPImportHelper.getAccountViewInfo(ctx, hsData, "FOppAccountID", this.currentCompany.getId().toString()));
            entryInfo.setDiscountType(ARAPImportHelper.getDiscountTypeInfo(ctx, hsData, "FDiscountType"));
            if (entryInfo.getQuantity().compareTo(ARAPImportHelper.ZERO) == 0 && otherBillInfo.getBillType().getValue() == 103) {
                entryInfo.setQuantity(new BigDecimal(1.0));
            }
            if (!this.isInitBill) {
                entryInfo.setVerifyAmount(ARAPImportHelper.ZERO);
                entryInfo.setVerifyAmountLocal(ARAPImportHelper.ZERO);
                entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount());
                entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal());
            }
            entryInfo.setLockVerifyAmt(entryInfo.getVerifyAmount());
            entryInfo.setLockVerifyAmtLocal(entryInfo.getVerifyAmountLocal());
            entryInfo.setLockUnVerifyAmt(entryInfo.getUnVerifyAmount());
            entryInfo.setLockUnVerifyAmtLocal(entryInfo.getUnVerifyAmountLocal());
            ARAPImportHelper.setARBillAmtFromEntry(otherBillInfo, entryInfo, isUpdateEntry);
            if (otherBillInfo.isIsInitializeBill()) {
                entryInfo.setHisUnVerifyAmount(entryInfo.getUnVerifyAmount());
                entryInfo.setHisUnVerifyAmountLocal(entryInfo.getUnVerifyAmountLocal());
            }
            entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
            entryInfo.setLocalUnwriteOffAmount(entryInfo.getRecievePayAmountLocal());
            BigDecimal totalAmount = otherBillInfo.getTotalAmount();
            otherBillInfo.setThisArAmount(otherBillInfo.getAmount());
            BigDecimal totalTax = otherBillInfo.getTotalTax();
            if (totalAmount == null) {
                totalAmount = ARAPImportHelper.ZERO;
            }
            if (totalTax == null) {
                totalTax = ARAPImportHelper.ZERO;
            }
            otherBillInfo.setTotalAmount(totalAmount.add(entryInfo.getAmount()));
            otherBillInfo.setTotalTax(totalTax.add(entryInfo.getTaxAmount()));
            otherBillInfo.setTotalTaxAmount(otherBillInfo.getTotalAmount().add(otherBillInfo.getTotalTax()));
            BigDecimal totalAmountLocal = null != otherBillInfo.getTotalAmountLocal() ? otherBillInfo.getTotalAmountLocal() : ARAPImportHelper.ZERO;
            BigDecimal totalTaxLocal = null != otherBillInfo.getTotalTaxLocal() ? otherBillInfo.getTotalTaxLocal() : ARAPImportHelper.ZERO;
            otherBillInfo.setTotalAmountLocal(totalAmountLocal.add(entryInfo.getAmountLocal()));
            otherBillInfo.setTotalTaxLocal(totalTaxLocal.add(entryInfo.getTaxAmountLocal()));
            if ("BF0C040E".equals(BOSUuid.read((String)otherBillInfo.getAsstActID()).getType().toString())) {
                CustomerInfo customer = new CustomerInfo();
                customer.setId(BOSUuid.read((String)otherBillInfo.getAsstActID()));
                entryInfo.setOrderCustomer(customer);
                entryInfo.setOrdCustName(otherBillInfo.getAsstActName());
                entryInfo.setOrdCustNumber(otherBillInfo.getAsstActNumber());
                entryInfo.setServiceCustomer(customer);
                entryInfo.setSerCustName(otherBillInfo.getAsstActName());
                entryInfo.setSerCustNumber(otherBillInfo.getAsstActNumber());
                entryInfo.setRecAsstActType(otherBillInfo.getAsstActType());
                entryInfo.setRecAsstActID(otherBillInfo.getAsstActID());
                entryInfo.setRecAsstActName(otherBillInfo.getAsstActName());
                entryInfo.setRecAsstActNumber(otherBillInfo.getAsstActNumber());
            }
            if (entryInfo.isIsQtyZero()) {
                entryInfo.setQuantity(BigDecimal.ZERO);
                entryInfo.setAssistQty(BigDecimal.ZERO);
                entryInfo.setPrice(BigDecimal.ZERO);
                entryInfo.setTaxPrice(BigDecimal.ZERO);
                entryInfo.setRealPrice(BigDecimal.ZERO);
                entryInfo.setActualPrice(BigDecimal.ZERO);
                entryInfo.setDiscountAmount(BigDecimal.ZERO);
                entryInfo.setDiscountAmountLocal(BigDecimal.ZERO);
                entryInfo.setDiscountRate(BigDecimal.ZERO);
                entryInfo.setDiscountType(DiscountModeEnum.NULL);
            }
            this.setMakeInvoiceReqRelationFields(entryInfo);
        }
        catch (BaseException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg((Exception)((Object)ex)));
        }
    }

    private void setMakeInvoiceReqRelationFields(ArApBillEntryBaseInfo entryInfo) {
        entryInfo.setInvoiceReqQty(BigDecimal.ZERO);
        entryInfo.setInvoiceReqBaseQty(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqQty(entryInfo.getQuantity());
        entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
        entryInfo.setInvoiceReqAmount(BigDecimal.ZERO);
        entryInfo.setInvoiceReqAmountLocal(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqAmount(entryInfo.getRecievePayAmount());
        entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getRecievePayAmountLocal());
    }

    private void setCheckField(String fieldName, BigDecimal value, Context ctx) throws TaskExternalException {
        if (fieldName.trim().equals("FAmount")) {
            if (value == null || value.compareTo(ARAPImportHelper.ZERO) == 0) {
                throw new TaskExternalException("FAmount is empty!");
            }
        } else if (fieldName.trim().equals("FAmountLocal")) {
            if (value == null || value.compareTo(ARAPImportHelper.ZERO) == 0) {
                throw new TaskExternalException("FAmountLocal is empty!");
            }
        } else if (fieldName.trim().equals("FExchangeRate") && (value == null || value.compareTo(ARAPImportHelper.ZERO) == 0)) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FExchangeRate_IsNull", ctx));
        }
    }

    boolean checkAsstAccID(Context ctx, AsstActTypeInfo asstActTypeInfo, Hashtable hsData, ArApBillBaseInfo otherBillInfo) throws TaskExternalException {
        String tableName;
        boolean flag = false;
        String str = ARAPImportHelper.getDataString(hsData, "FAsstActNumber");
        if (str == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("FAsstActNumber_IsNull", ctx));
        }
        String fId = null;
        String fName = null;
        String fNumber = null;
        if (str != null && asstActTypeInfo != null && asstActTypeInfo.getDefaultQueryName() != null && (tableName = asstActTypeInfo.getRealtionDataObject()) != null && tableName.length() > 0) {
            try {
                RowSet rs = null;
                rs = ARAPImportHelper.getAsstActInfo(ctx, str, asstActTypeInfo);
                while (rs.next()) {
                    flag = true;
                    fId = rs.getString("fid");
                    fName = rs.getString("fname");
                    fNumber = rs.getString("fnumber");
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), (Throwable)e);
            }
        }
        otherBillInfo.setAsstActID(fId);
        otherBillInfo.setAsstActName(fName);
        otherBillInfo.setAsstActNumber(fNumber);
        return flag;
    }

    private boolean checkBillDate(ArApBillBaseInfo otherBillInfo, Context ctx) throws TaskExternalException {
        boolean ret = true;
        Date bizDate = otherBillInfo.getBizDate();
        if (bizDate == null) {
            throw new TaskExternalException(ARAPImportFacadeControllerBean.getString("BizDateIsNull", ctx));
        }
        Date billDate = otherBillInfo.getBillDate();
        if (billDate.before(bizDate)) {
            ret = false;
        }
        return ret;
    }

    private IObjectPK _saveAPBill(Context ctx, Hashtable hsData, com.kingdee.eas.fi.ap.OtherBillInfo otherBillInfo) throws TaskExternalException {
        String errMsg = null;
        try {
            com.kingdee.eas.fi.ap.IOtherBill iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            if (otherBillInfo.getId() == null || !iOtherBill.exists((IObjectPK)new ObjectUuidPK(otherBillInfo.getId()))) {
                if (otherBillInfo.getPayPlan() == null) {
                    com.kingdee.eas.fi.ap.OtherBillPlanCollection planColl = new com.kingdee.eas.fi.ap.OtherBillPlanCollection();
                    otherBillInfo.put("payPlan", (Object)planColl);
                }
                if (otherBillInfo.getPayPlan().size() == 0) {
                    com.kingdee.eas.fi.ap.OtherBillPlanInfo newOtherBillPlanInfo = new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
                    newOtherBillPlanInfo.setParent(otherBillInfo);
                    newOtherBillPlanInfo.setSeq(1);
                    newOtherBillPlanInfo.setRecievePayDate(otherBillInfo.getBillDate());
                    newOtherBillPlanInfo.setRecievePayAmount(otherBillInfo.getAmount());
                    newOtherBillPlanInfo.setRecievePayAmountLocal(otherBillInfo.getAmountLocal());
                    newOtherBillPlanInfo.setUnLockAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                    newOtherBillPlanInfo.setUnLockAmountLoc(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                    newOtherBillPlanInfo.setUnVerifyAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                    newOtherBillPlanInfo.setUnVerifyAmountLocal(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                    newOtherBillPlanInfo.setVerifyAmount(otherBillInfo.getVerifyAmount());
                    newOtherBillPlanInfo.setVerifyAmountLocal(otherBillInfo.getVerifyAmountLocal());
                    newOtherBillPlanInfo.setLockAmount(otherBillInfo.getVerifyAmount());
                    newOtherBillPlanInfo.setLockAmountLoc(otherBillInfo.getVerifyAmountLocal());
                    com.kingdee.eas.fi.ap.OtherBillPlanCollection planColl = otherBillInfo.getPayPlan();
                    planColl.add(newOtherBillPlanInfo);
                    otherBillInfo.put("payPlan", (Object)planColl);
                }
                otherBillInfo.setIsImportBill(true);
                otherBillInfo.setReqCalculate4Srv(false);
                IObjectPK pk = iOtherBill.save((CoreBaseInfo)otherBillInfo);
                this.idList.add(pk.toString());
                if (this.coreInfo == null) {
                    this.coreInfo = otherBillInfo;
                }
                return pk;
            }
            if (otherBillInfo.getPayPlan().size() == 1) {
                com.kingdee.eas.fi.ap.OtherBillPlanInfo newOtherBillPlanInfo = otherBillInfo.getPayPlan().get(0);
                newOtherBillPlanInfo.setRecievePayAmount(otherBillInfo.getAmount());
                newOtherBillPlanInfo.setRecievePayAmountLocal(otherBillInfo.getAmountLocal());
                newOtherBillPlanInfo.setUnLockAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                newOtherBillPlanInfo.setUnLockAmountLoc(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                newOtherBillPlanInfo.setUnVerifyAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                newOtherBillPlanInfo.setUnVerifyAmountLocal(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                newOtherBillPlanInfo.setVerifyAmount(otherBillInfo.getVerifyAmount());
                newOtherBillPlanInfo.setVerifyAmountLocal(otherBillInfo.getVerifyAmountLocal());
                newOtherBillPlanInfo.setLockAmount(otherBillInfo.getVerifyAmount());
                newOtherBillPlanInfo.setLockAmountLoc(otherBillInfo.getVerifyAmountLocal());
            }
            if (hsData.get("size") != null) {
                int planCount = Integer.parseInt(hsData.get("size").toString());
                if (otherBillInfo.getPayPlan() != null && otherBillInfo.getPayPlan().size() > 0 && planCount > 1) {
                    this.checkAmount_AP(ctx, otherBillInfo);
                }
            }
            otherBillInfo.put("import", "aaa");
            iOtherBill.update((IObjectPK)new ObjectUuidPK(otherBillInfo.getId()), (CoreBaseInfo)otherBillInfo);
            return new ObjectUuidPK(otherBillInfo.getId());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            errMsg = ex.getMessage() == null ? ARAPImportFacadeControllerBean.getString("SystemError", ctx) : ex.getMessage();
            throw new TaskExternalException(errMsg);
        }
    }

    private IObjectPK _saveARBill(Context ctx, Hashtable hsData, OtherBillInfo otherBillInfo) throws TaskExternalException {
        String errMsg = null;
        try {
            IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
            if (otherBillInfo.getId() == null || !iOtherBill.exists((IObjectPK)new ObjectUuidPK(otherBillInfo.getId()))) {
                if (otherBillInfo.getRecievePlan() == null) {
                    OtherBillPlanCollection planColl = new OtherBillPlanCollection();
                    otherBillInfo.put("recievePlan", (Object)planColl);
                }
                if (otherBillInfo.getRecievePlan().size() == 0) {
                    OtherBillPlanInfo newOtherBillPlanInfo = new OtherBillPlanInfo();
                    newOtherBillPlanInfo.setParent(otherBillInfo);
                    newOtherBillPlanInfo.setSeq(1);
                    newOtherBillPlanInfo.setRecievePayDate(otherBillInfo.getBillDate());
                    newOtherBillPlanInfo.setRecievePayAmount(otherBillInfo.getAmount());
                    newOtherBillPlanInfo.setRecievePayAmountLocal(otherBillInfo.getAmountLocal());
                    newOtherBillPlanInfo.setUnLockAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                    newOtherBillPlanInfo.setUnLockAmountLoc(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                    newOtherBillPlanInfo.setUnVerifyAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                    newOtherBillPlanInfo.setUnVerifyAmountLocal(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                    newOtherBillPlanInfo.setVerifyAmount(otherBillInfo.getVerifyAmount());
                    newOtherBillPlanInfo.setVerifyAmountLocal(otherBillInfo.getVerifyAmountLocal());
                    newOtherBillPlanInfo.setLockAmount(otherBillInfo.getVerifyAmount());
                    newOtherBillPlanInfo.setLockAmountLoc(otherBillInfo.getVerifyAmountLocal());
                    OtherBillPlanCollection planColl = otherBillInfo.getRecievePlan();
                    planColl.add(newOtherBillPlanInfo);
                    otherBillInfo.put("recievePlan", (Object)planColl);
                }
                otherBillInfo.setIsImportBill(true);
                otherBillInfo.setReqCalculate4Srv(false);
                IObjectPK pk = iOtherBill.save((CoreBaseInfo)otherBillInfo);
                this.idList.add(pk.toString());
                if (this.coreInfo == null) {
                    this.coreInfo = otherBillInfo;
                }
                return pk;
            }
            if (otherBillInfo.getRecievePlan().size() == 1) {
                OtherBillPlanInfo newOtherBillPlanInfo = otherBillInfo.getRecievePlan().get(0);
                newOtherBillPlanInfo.setRecievePayAmount(otherBillInfo.getAmount());
                newOtherBillPlanInfo.setRecievePayAmountLocal(otherBillInfo.getAmountLocal());
                newOtherBillPlanInfo.setUnLockAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                newOtherBillPlanInfo.setUnLockAmountLoc(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                newOtherBillPlanInfo.setUnVerifyAmount(otherBillInfo.getAmount().subtract(otherBillInfo.getVerifyAmount()));
                newOtherBillPlanInfo.setUnVerifyAmountLocal(otherBillInfo.getAmountLocal().subtract(otherBillInfo.getVerifyAmountLocal()));
                newOtherBillPlanInfo.setVerifyAmount(otherBillInfo.getVerifyAmount());
                newOtherBillPlanInfo.setVerifyAmountLocal(otherBillInfo.getVerifyAmountLocal());
                newOtherBillPlanInfo.setLockAmount(otherBillInfo.getVerifyAmount());
                newOtherBillPlanInfo.setLockAmountLoc(otherBillInfo.getVerifyAmountLocal());
            }
            if (hsData.get("size") != null) {
                int planCount = Integer.parseInt(hsData.get("size").toString());
                if (otherBillInfo.getRecievePlan() != null && otherBillInfo.getRecievePlan().size() > 0 && planCount > 1) {
                    this.checkAmount(ctx, otherBillInfo);
                }
            }
            otherBillInfo.put("import", "aaa");
            iOtherBill.update((IObjectPK)new ObjectUuidPK(otherBillInfo.getId()), (CoreBaseInfo)otherBillInfo);
            return new ObjectUuidPK(otherBillInfo.getId());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            errMsg = ex.getMessage() == null ? ARAPImportFacadeControllerBean.getString("SystemError", ctx) : ex.getMessage();
            throw new TaskExternalException(errMsg);
        }
    }

    private static EntityViewInfo getAscDefaultEntVByNum(String number) {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("billStatus"));
        entityView.getSelector().add(new SelectorItemInfo("totalAmount"));
        entityView.getSelector().add(new SelectorItemInfo("totalTax"));
        entityView.getSelector().add(new SelectorItemInfo("totalTaxAmount"));
        entityView.getSelector().add(new SelectorItemInfo("redBlueType"));
        entityView.getSelector().add(new SelectorItemInfo("entry.*"));
        entityView.getSelector().add(new SelectorItemInfo("payPlan.*"));
        entityView.getSelector().add(new SelectorItemInfo("amountLocal"));
        entityView.getSelector().add(new SelectorItemInfo("amount"));
        entityView.getSelector().add(new SelectorItemInfo("asstActNumber"));
        entityView.getSelector().add(new SelectorItemInfo("totalTaxLocal"));
        entityView.getSelector().add(new SelectorItemInfo("totalAmountLocal"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        entityView.setFilter(filter);
        return entityView;
    }

    private static EntityViewInfo getAscDefaultEntVByNum_ar(String number) {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("billStatus"));
        entityView.getSelector().add(new SelectorItemInfo("totalAmount"));
        entityView.getSelector().add(new SelectorItemInfo("totalTax"));
        entityView.getSelector().add(new SelectorItemInfo("totalTaxAmount"));
        entityView.getSelector().add(new SelectorItemInfo("redBlueType"));
        entityView.getSelector().add(new SelectorItemInfo("entry.*"));
        entityView.getSelector().add(new SelectorItemInfo("recievePlan.*"));
        entityView.getSelector().add(new SelectorItemInfo("amountLocal"));
        entityView.getSelector().add(new SelectorItemInfo("amount"));
        entityView.getSelector().add(new SelectorItemInfo("asstActNumber"));
        entityView.getSelector().add(new SelectorItemInfo("totalTaxLocal"));
        entityView.getSelector().add(new SelectorItemInfo("totalAmountLocal"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        entityView.setFilter(filter);
        return entityView;
    }

    public static String getString(String resName, Context ctx) {
        return ARAPImportFacadeControllerBean.getString("AR", resName, ctx);
    }

    public static String getString(String SysType, String resName, Context ctx) {
        String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
        String AP_RESOURCE_PATH = "com.kingdee.eas.fi.ap.APImportData";
        if (SysType.equals("AR")) {
            return ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        if (SysType.equals("AP")) {
            return ResourceBase.getString((String)AP_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        return null;
    }

    @Override
    protected ImportLog _batchTransfer(Context ctx, List hsDataList, String bill, List headDefineFieldListList, List entryDefineFieldListList) throws BOSException, EASBizException {
        Hashtable hsData = null;
        bill = bill.trim();
        this.isImportDataByRule = this.getImportParam(ctx, bill);
        this.idList = new ArrayList();
        ImportLog log = new ImportLog();
        String summary_msg = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"154_IMPORT_SUMMARY", (Locale)ctx.getLocale());
        int size = hsDataList.size();
        for (int i = 0; i < size; ++i) {
            try {
                if (hsDataList.get(i) == null) continue;
                hsData = (Hashtable)hsDataList.get(i);
                if ((bill.equalsIgnoreCase("AR") || bill.equalsIgnoreCase("AP")) && i == size - 1) {
                    hsData.put("size", size);
                }
                this._transfer(ctx, hsData, bill, (ArrayList)headDefineFieldListList.get(i), (ArrayList)entryDefineFieldListList.get(i));
                ++log.newCount;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)ArApBillUtil.printExceptionMsg(e), (Throwable)e);
                String errMsg = "";
                errMsg = e.getMessage() == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"SystemError", (Locale)ctx.getLocale()) : (e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
                ++log.failCount;
                log.errList.add(MessageFormat.format(summary_msg, i + 1, errMsg));
            }
        }
        if (this.isImportDataByRule && log.newCount > 0) {
            Serializable info = null;
            String tableName = null;
            if (bill.equalsIgnoreCase("AR")) {
                info = new OtherBillInfo();
                tableName = "T_AR_OtherBill";
            } else if (bill.equalsIgnoreCase("AP")) {
                info = new com.kingdee.eas.fi.ap.OtherBillInfo();
                tableName = "T_AP_OtherBill";
            } else if (bill.equalsIgnoreCase("PROXY")) {
                info = new ProxyBillInfo();
                tableName = "T_ARP_ProxyBill";
            }
            String companyId = null;
            if (this.coreInfo != null && (info = this.coreInfo).get("company") != null) {
                companyId = ((CoreBaseInfo)info.get("company")).get("id").toString();
            }
            if (this.idList != null && this.idList.size() > 0) {
                HashSet<String> idSet = new HashSet<String>();
                int size2 = this.idList.size();
                for (int i = 0; i < size2; ++i) {
                    idSet.add(this.idList.get(i).toString());
                }
                this.updateBatchNumber(ctx, companyId, idSet, bill);
            }
        }
        return log;
    }

    private void updateBillNumber(Context ctx, Map<String, String> numbers, String tableName, Object[] ids) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        boolean isBatch = false;
        try {
            if (numbers == null || numbers.size() == 0 || ids == null || ids.length == 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("UPDATE " + tableName + " SET FNumber = ? WHERE FID = ?");
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                pstmt.setString(1, numbers.get(ids[i]));
                pstmt.setString(2, String.valueOf(ids[i]));
                pstmt.addBatch();
                isBatch = true;
            }
            if (isBatch) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, conn);
        }
    }

    @Override
    protected void _transferAPExtend(Context ctx, Hashtable hsData, ArApBillBaseInfo billInfo, ArApBillEntryBaseInfo entryInfo, ArApBillPlanBaseInfo planInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _transferARExtend(Context ctx, Hashtable hsData, ArApBillBaseInfo billInfo, ArApBillEntryBaseInfo entryInfo, ArApBillPlanBaseInfo planInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _updateBatchNumber(Context ctx, String companyId, Set idSet, String bill) throws BOSException, EASBizException {
        IArApBillBase iOtherBill;
        String tableName = null;
        AbstractObjectCollection collection = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        if (bill.equalsIgnoreCase("AR")) {
            tableName = "T_AR_OtherBill";
            iOtherBill = OtherBillFactory.getLocalInstance(ctx);
            collection = iOtherBill.getOtherBillCollection(ev);
        } else if (bill.equalsIgnoreCase("AP")) {
            tableName = "T_AP_OtherBill";
            iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            collection = iOtherBill.getOtherBillCollection(ev);
        } else if (bill.equalsIgnoreCase("PROXY")) {
            tableName = "T_ARP_ProxyBill";
            IProxyBill iProxyBill = ProxyBillFactory.getLocalInstance(ctx);
            collection = iProxyBill.getProxyBillCollection(ev);
        }
        if (idSet != null && idSet.size() > 0) {
            Map<String, String> numbers = this.batchArApGenNumber(ctx, (IObjectCollection)collection, bill);
            this.updateBillNumber(ctx, numbers, tableName, idSet.toArray());
        }
    }

    private Map<String, String> batchArApGenNumber(Context ctx, IObjectCollection col, String bill) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashMap<String, AbstractObjectCollection> companyMap = new HashMap<String, AbstractObjectCollection>();
        AbstractObjectCollection groupCol = null;
        for (int i = 0; i < col.size(); ++i) {
            Serializable info;
            if (bill.equalsIgnoreCase("AR") || bill.equalsIgnoreCase("AP")) {
                info = (ArApBillBaseInfo)col.getObject(i);
                if (companyMap.containsKey(info.getCompany().getId().toString())) {
                    groupCol = (IObjectCollection)companyMap.get(info.getCompany().getId().toString());
                } else {
                    groupCol = new ArApBillBaseCollection();
                    companyMap.put(info.getCompany().getId().toString(), groupCol);
                }
                groupCol.addObject((IObjectValue)info);
                continue;
            }
            if (!bill.equalsIgnoreCase("PROXY")) continue;
            info = (ProxyBillInfo)col.getObject(i);
            if (companyMap.containsKey(((AbstractProxyBillInfo)info).getCompanyOrgUnit().getId().toString())) {
                groupCol = (IObjectCollection)companyMap.get(((AbstractProxyBillInfo)info).getCompanyOrgUnit().getId().toString());
            } else {
                groupCol = new ProxyBillCollection();
                companyMap.put(((AbstractProxyBillInfo)info).getCompanyOrgUnit().getId().toString(), groupCol);
            }
            groupCol.addObject((IObjectValue)info);
        }
        for (Map.Entry entry : companyMap.entrySet()) {
            IObjectValue info = ((IObjectCollection)entry.getValue()).getObject(0);
            IObjectCollection entryCol = (IObjectCollection)entry.getValue();
            String[] numbers = null;
            if (info == null || !iCodingRuleManager.isExist(info, (String)entry.getKey())) continue;
            numbers = iCodingRuleManager.getBatchNumber((IObjectCollection)entry.getValue(), (String)entry.getKey(), "", null);
            for (int i = 0; i < entryCol.size(); ++i) {
                CoreBillBaseInfo value = (CoreBillBaseInfo)entryCol.getObject(i);
                numberMap.put(value.getId().toString(), numbers[i]);
            }
        }
        return numberMap;
    }

    @Override
    protected boolean _getImportParam(Context ctx, String bill) throws BOSException, EASBizException {
        boolean isByRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"0000", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"importDataByRule", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
            if (collection == null || collection.size() == 0) {
                return isByRule;
            }
            ParamItemInfo info = collection.get(0);
            String value = info.getValue();
            if (value != null && value.equals("true")) {
                isByRule = true;
            }
        }
        catch (Exception e) {
            isByRule = false;
        }
        return isByRule;
    }

    private boolean checkAsstActStatus(Context ctx, AsstActTypeInfo asstActType, String asstActId) throws BOSException, EASBizException {
        try {
            String relationDataObject = ARAPImportHelper.getRelationDataObject(ctx, asstActType);
            boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
            boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
            if (fCust || fSupp) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT FUsedStatus from ").append(relationDataObject);
                sb.append(" WHERE FID = '").append(asstActId).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                boolean result = true;
                while (rs.next()) {
                    result = rs.getInt("FUsedStatus") == 1;
                }
                return result;
            }
            return true;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkOrgPermission(Context ctx, boolean isAR, boolean isInit) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        String permItemName = null;
        permItemName = isInit ? (isAR ? "fi_ar_InitBill_import" : "fi_ap_InitBill_import") : (isAR ? "fi_ar_ArOtherBill_Import" : "fi_ap_ApOtherBill_import");
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(this.currentCompany.getCU().getId().toString());
            FullOrgUnitCollection orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, permItemName);
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(this.currentCompany.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{this.currentCompany.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e));
        }
    }
}

