/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ARAPRCException;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.paramconvertor.ContrastGLRptParamConvertor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ARAPRCRptBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ARAPRCRptBaseService");
    public static final String NEW_LINE = " \r\n ";
    protected Context ctx;

    public Map tableHead() throws BOSException, EASBizException {
        return new HashMap();
    }

    protected void RCRptBaseService(Context ctx) {
        this.ctx = ctx;
    }

    public String createTable(Context ctx, boolean fAR, ContrastGLQueryParam param) throws BOSException, EASBizException {
        String tableID = TempTableUtil.createTempTable(ctx, this.tempContrastTbl());
        this.insertData(ctx, fAR, tableID, param);
        return tableID;
    }

    public String createTable(Context ctx, boolean fAR, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        this.ctx = ctx;
        ContrastGLQueryParam param = this.getRptParam(ctx, fAR, companyId, period);
        if (param == null) {
            throw new ARAPRCException(ARAPRCException.NOTDEFAULTEXCEPTION);
        }
        return this.createTable(ctx, fAR, param);
    }

    public String tempContrastTbl() {
        StringBuilder tbl = new StringBuilder(200);
        tbl.append("(Fid VARCHAR(44),FProject int,");
        tbl.append("FAccount nvarchar(100),FCurrency nvarchar(100),");
        tbl.append("FCussTypeID nvarchar(100),");
        tbl.append("FCussType nvarchar(400),FAsstActId VARCHAR(44),");
        tbl.append("FCussNum nvarchar(100),FCussName nvarchar(100),");
        tbl.append("FArapAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append("FGLAmt decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append("FDiffAmt decimal(28, 10) NOT NULL DEFAULT 0 ,");
        tbl.append("FAccountID VARCHAR(44),FCurrencyID VARCHAR(44),");
        tbl.append("Fisdiff int default 0)");
        return tbl.toString();
    }

    public Map getData(Context ctx, boolean fAR, String companyId, PeriodInfo period) throws BOSException, EASBizException {
        this.ctx = ctx;
        ContrastGLQueryParam param = this.getRptParam(ctx, fAR, companyId, period);
        if (param == null) {
            throw new ARAPRCException(ARAPRCException.NOTDEFAULTEXCEPTION);
        }
        String tableID = this.createTable(ctx, fAR, param);
        HashMap<String, Object> datasMap = new HashMap<String, Object>(10);
        datasMap.put("tempTable", tableID);
        datasMap.put("isByBillSum", param.isByBillSum());
        datasMap.put("isBySum", param.isBySum());
        datasMap.put("isHasItem", param.isHasItem());
        datasMap.put("hasUnRegVoucher", param.isHasUnRegVoucher());
        datasMap.put("isContrastByBillAccount", param.isContrastByBillAccount());
        return datasMap;
    }

    public void insertData(Context ctx, boolean fAR, String tableID, ContrastGLQueryParam param) throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(200);
        buf.append("CREATE TABLE TEML_KSQL_0 ").append(CommonServerUtils.defineContrastTempTbl(false));
        TempTablePool tempPool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = tempPool.createTempTable(buf.toString());
            tempPool.createIndex(tempTable, "fisSum", false, false);
            param.setTempTable(tempTable);
            ContrastGLFacadeFactory.getLocalInstance(ctx).prepareContrastData(param, fAR);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        buf.setLength(0);
        String fid = " newbosid('12345678') as fid, ";
        String columns = " FAccount, FCurrency, FCussTypeID, FCussType, FCussAcct, FCussNum, FCussName, ";
        buf.append("insert into ").append(tableID).append(" (fid, FProject, ").append(NEW_LINE).append(" FAccount, FCurrency, FCussTypeID, FCussType, FAsstActId, FCussNum, FCussName, FArapAmt, ").append(NEW_LINE).append(" FGLAmt, FDiffAmt, FAccountID, FCurrencyID, fisdiff) ").append(NEW_LINE).append(" select ").append(fid).append(1).append(", ").append(NEW_LINE).append(columns).append("FArStartAmt, ").append(NEW_LINE).append(" FGLStartAmt, FStartDiffAmt, FAccountID, FCurrencyID, fisdiff ").append(NEW_LINE).append(" from ").append(tempTable).append(" where FIsSum = 1 ").append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE).append(" select ").append(fid).append(2).append(", ").append(NEW_LINE).append(columns).append("FArDebitAmt, ").append(NEW_LINE).append(" FGLDebitAmt, FDebitDiffAmt, FAccountID, FCurrencyID, fisdiff ").append(NEW_LINE).append(" from ").append(tempTable).append(" where FIsSum = 1 ").append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE).append(" select ").append(fid).append(3).append(", ").append(NEW_LINE).append(columns).append("FArCreditAmt, ").append(NEW_LINE).append(" FGLCreditAmt, FCreditDiffAmt, FAccountID, FCurrencyID, fisdiff ").append(NEW_LINE).append(" from ").append(tempTable).append(" where FIsSum = 1 ").append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE).append(" select ").append(fid).append(4).append(", ").append(NEW_LINE).append(columns).append("FArBalanceAmt,").append(NEW_LINE).append(" FGLBalanceAmt, FBalanceDiffAmt, FAccountID, FCurrencyID, fisdiff ").append(NEW_LINE).append(" from ").append(tempTable).append(" where FIsSum = 1 ").append(NEW_LINE);
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }

    public ContrastGLQueryParam getRptParam(Context ctx, boolean fAR, String companyId, PeriodInfo periodInfo) throws BOSException, EASBizException {
        List accountIds;
        EntityViewInfo viewInfo;
        ContrastGLQueryParam param = new ContrastGLQueryParam();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String className = "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.ap.solution_ar_page";
        if (!fAR) {
            className = "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.ap.solution_ap_page";
        }
        try {
            viewInfo = ARAPRCRptBaseService.getQuerySolutionViewInfo(null, className, companyId, userID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
        if (solutionCol.size() > 0) {
            QuerySolutionInfo solutionInfo = solutionCol.get(0);
            if (solutionInfo != null && solutionInfo.getSolutionType() == SolutionTypeEnum.CUSTOMER_SOLUTION) {
                QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
                int size = queryPanels.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        CustomerParams cp = XMLBean.transStrToCommonCustParams((String)queryPanels.get(i).getCustomerParams());
                        ContrastGLRptParamConvertor convertor = new ContrastGLRptParamConvertor();
                        convertor.setRptParam((IReportQueryParam)param);
                        convertor.read(ctx, cp);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
                    }
                }
            }
        } else {
            return null;
        }
        int spPeriodYear = periodInfo.getPeriodYear();
        int spPeriodNum = periodInfo.getPeriodNumber();
        param.setPeriodYear(spPeriodYear);
        param.setPeriodNum(spPeriodNum);
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, companyId, periodInfo.getNumber(), fAR);
        if (isContrastByBillAccount) {
            param.setBySum(false);
            param.setByBillSum(false);
            param.setContrastByBillAccount(true);
        }
        if (null == (accountIds = param.getAcctFormula()) || accountIds.size() == 0) {
            return null;
        }
        Set oppositeAccountIdSet = ContrastGLFacadeFactory.getLocalInstance(ctx).getOppositeAccountIdSet(new HashSet(accountIds), spPeriodYear, spPeriodNum, fAR);
        boolean isEmpty = null == oppositeAccountIdSet || oppositeAccountIdSet.size() == 0;
        param.setQueryAll(!isEmpty);
        param.setOppositeAccountIdSet(oppositeAccountIdSet);
        return param;
    }

    public static EntityViewInfo getQuerySolutionViewInfo(String queryName, String parentPageName, String orgID, String userID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(2)));
        filter.getFilterItems().add(new FilterItemInfo("isUserDefaultSolu", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.setMaskString(" #0 AND #1 AND #2 AND #3 and #4 ");
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().decode("order by name");
        viewInfo.setSorter(sorterItemCollection);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)ARAPRCRptBaseService.getSelectorItemCollection());
        return viewInfo;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

