/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ApVerificationFacadeFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPInfo;
import com.kingdee.eas.fi.ap.InitDataInputAPentryCollection;
import com.kingdee.eas.fi.ap.InitDataInputAPentryInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.ar.InitDataInputARFactory;
import com.kingdee.eas.fi.ar.InitDataInputARInfo;
import com.kingdee.eas.fi.ar.InitDataInputARentryCollection;
import com.kingdee.eas.fi.ar.InitDataInputARentryInfo;
import com.kingdee.eas.fi.arap.app.AbstractArApInitDataInputFacadeControllerBean;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.sql.RowSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ArApInitDataInputFacadeControllerBean
extends AbstractArApInitDataInputFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArInitDataInputFacadeControllerBean");

    @Override
    protected CoreBillBaseInfo _getArBillData(Context ctx, String mainOrgUnitId, String currencyID) throws BOSException, EASBizException {
        return this.getArBillInfo(ctx, mainOrgUnitId, currencyID);
    }

    private CoreBillBaseInfo getArBillInfo(Context ctx, String mainOrgUnitId, String currencyID) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId));
        String companyID = companyInfo.getId().toString();
        if (StringUtils.isEmpty((CharSequence)currencyID)) {
            currencyID = companyInfo.getBaseCurrency().getId().toString();
        }
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        PeriodInfo periodInfo = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getStartPeriod(12, companyID);
        RowSet headrs = InitDataInputARFactory.getLocalInstance(ctx).getBillHead(companyID, currencyID, periodInfo.getBeginDate());
        RowSet rsDetail = InitDataInputARFactory.getLocalInstance(ctx).getBillDetail(companyID, currencyID);
        InitDataInputARInfo info = new InitDataInputARInfo();
        info.setCompany(companyInfo);
        info.setCurrency(currency);
        info.setStartPeriod(periodInfo);
        info.setExchangeRate(new BigDecimal("1"));
        info.put("accountTable", companyInfo.getAccountTable().getId().toString());
        info.setBizDate(this.changeDate(periodInfo.getBeginDate(), -1));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setCreator(userInfo);
        try {
            if (headrs.next()) {
                info.setId(BOSUuid.read((String)headrs.getString("id")));
            }
            InitDataInputARentryInfo entryInfo = null;
            int rowIndex = 0;
            Vector<String> vcTmp = new Vector<String>();
            HashMap<String, String> hmTmp = new HashMap<String, String>();
            StringBuffer sb = new StringBuffer();
            HashMap<String, AsstActTypeInfo> asstypeMap = new HashMap<String, AsstActTypeInfo>();
            HashMap asstMap = new HashMap();
            InitDataInputARentryCollection entrycol = new InitDataInputARentryCollection();
            AsstActTypeInfo defaultAcctCussType = ArVerificationFacadeFactory.getLocalInstance(ctx).getAsstActType("customer");
            while (rsDetail.next()) {
                int index;
                sb.setLength(0);
                sb.append(rsDetail.getString("bizType"));
                if ("202".equals(rsDetail.getString("bizType"))) {
                    sb.setLength(0);
                    sb.append("204");
                }
                sb.append(rsDetail.getString("acctcussType_id"));
                sb.append(rsDetail.getString("acctcuss_id"));
                sb.append(rsDetail.getString("adminOrgUnitId"));
                sb.append(rsDetail.getString("personId"));
                sb.append(rsDetail.getString("account_id"));
                int isFromBill = rsDetail.getInt("isFromBill");
                int isBillCollected = rsDetail.getInt("isBillCollected");
                int isImpFromGL = rsDetail.getInt("isImpFromGL");
                int isBizBill = rsDetail.getInt("isBizBill");
                if (isImpFromGL == 1 && vcTmp.size() > 0 && vcTmp.contains(sb.toString())) {
                    index = Integer.parseInt((String)hmTmp.get(sb.toString()));
                    entryInfo = entrycol.get(index);
                    entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                }
                if (isFromBill == 1 || isFromBill == 0 && isBillCollected == 0) {
                    entryInfo = new InitDataInputARentryInfo();
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    entryInfo.setBizDate(this.changeDate(periodInfo.getBeginDate(), -1));
                    entryInfo.setBizType(VerificateBillTypeEnum.getEnum((int)rsDetail.getInt("bizType")));
                    AsstActTypeInfo acctCussTypeInfo = this.getAcctCussType(ctx, rsDetail, asstypeMap, defaultAcctCussType);
                    entryInfo.setAcctCussType(acctCussTypeInfo);
                    asstypeMap.put(acctCussTypeInfo.getId().toString(), acctCussTypeInfo);
                    entryInfo.setAcctCussID(rsDetail.getString("acctcuss_id"));
                    IObjectValue acctCuss = this.getacctCuss(ctx, rsDetail, asstMap);
                    HashMap<String, Object> asstAct = new HashMap<String, Object>();
                    asstAct.put("name", acctCuss.get("name"));
                    asstAct.put("number", acctCuss.get("number"));
                    asstAct.put("id", rsDetail.getString("acctcuss_id"));
                    asstAct.put("bosType", BOSUuid.getBOSObjectType((String)rsDetail.getString("acctcuss_id"), (boolean)true).toString());
                    entryInfo.put("asstact", asstAct);
                    entryInfo.put("asstactname", acctCuss.get("name"));
                    entryInfo.put("asstactnumber", acctCuss.get("number"));
                    entryInfo.setAccount(this.getAccountViewInfo(rsDetail));
                    entryInfo.setAdminOrgUnit(this.getAdminOrgUnitInfo(rsDetail));
                    entryInfo.setPerson(this.getPersonInfo(rsDetail));
                    entryInfo.setInitYearDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("year_direction")));
                    entryInfo.setInitYearAmt(rsDetail.getBigDecimal("year_Amt"));
                    entryInfo.setInitYearAmtLocal(rsDetail.getBigDecimal("year_AmtLoc"));
                    entryInfo.setYearTotalCreditAmt(rsDetail.getBigDecimal("total_CreditAmt"));
                    entryInfo.setYearTotalCreditAmtLocal(rsDetail.getBigDecimal("total_CreditAmtLoc"));
                    entryInfo.setYearTotalDebitAmt(rsDetail.getBigDecimal("total_DebitAmt"));
                    entryInfo.setYearTotalDebitAmtLocal(rsDetail.getBigDecimal("total_DebitAmtLoc"));
                    entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                    entryInfo.setInitPeriodAmt(rsDetail.getBigDecimal("period_Amt"));
                    entryInfo.setInitPeriodAmtLocal(rsDetail.getBigDecimal("period_AmtLoc"));
                    entryInfo.setIsBizBill(rsDetail.getBoolean("isBizBill"));
                    entryInfo.setIsImpFromGL(rsDetail.getBoolean("isImpFromGL"));
                    entryInfo.put("isfrombill", isFromBill);
                    if (isFromBill == 1) {
                        entryInfo.setIsBillCollected(true);
                        vcTmp.add(sb.toString());
                        hmTmp.put(sb.toString(), rowIndex + "");
                    } else {
                        entryInfo.setIsBillCollected(false);
                    }
                    ++rowIndex;
                    entrycol.add(entryInfo);
                    continue;
                }
                if (isBillCollected != 1 || isFromBill != 0 || !vcTmp.contains(sb.toString())) continue;
                index = Integer.parseInt((String)hmTmp.get(sb.toString()));
                entryInfo = entrycol.get(index);
                entryInfo.setInitYearDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("year_direction")));
                entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                entryInfo.setInitYearAmt(rsDetail.getBigDecimal("year_Amt"));
                entryInfo.setInitYearAmtLocal(rsDetail.getBigDecimal("year_AmtLoc"));
                entryInfo.setYearTotalCreditAmt(rsDetail.getBigDecimal("total_CreditAmt"));
                entryInfo.setYearTotalCreditAmtLocal(rsDetail.getBigDecimal("total_CreditAmtLoc"));
                entryInfo.setYearTotalDebitAmt(rsDetail.getBigDecimal("total_DebitAmt"));
                entryInfo.setYearTotalDebitAmtLocal(rsDetail.getBigDecimal("total_DebitAmtLoc"));
            }
            info.getEntrys().addCollection(entrycol);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private PersonInfo getPersonInfo(RowSet rsDetail) throws SQLException {
        PersonInfo personInfo = null;
        String strUuid = rsDetail.getString("personId");
        if (strUuid != null && BOSUuid.isValid((String)strUuid, (boolean)true)) {
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rsDetail.getString("personId")));
            personInfo.setNumber(rsDetail.getString("person_number"));
            personInfo.setName(rsDetail.getString("person_name"));
        }
        return personInfo;
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(RowSet rsDetail) throws SQLException {
        String strUuid = rsDetail.getString("adminOrgUnitId");
        AdminOrgUnitInfo adminOrgInfo = null;
        if (strUuid != null && BOSUuid.isValid((String)strUuid, (boolean)true)) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setId(BOSUuid.read((String)rsDetail.getString("adminOrgUnitId")));
            adminOrgInfo.setNumber(rsDetail.getString("adminOrgUnit_number"));
            adminOrgInfo.setName(rsDetail.getString("adminOrgUnit_name"));
        }
        return adminOrgInfo;
    }

    private AccountViewInfo getAccountViewInfo(RowSet rsDetail) throws SQLException {
        String strUuid = rsDetail.getString("account_id");
        AccountViewInfo account = null;
        if (strUuid != null && BOSUuid.isValid((String)strUuid, (boolean)true)) {
            account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)rsDetail.getString("account_id")));
            account.setNumber(rsDetail.getString("account_number"));
            account.setName(rsDetail.getString("account_name"));
        }
        return account;
    }

    private IObjectValue getacctCuss(Context ctx, RowSet rsDetail, HashMap asstMap) throws BOSException, SQLException {
        String strUuid = rsDetail.getString("acctcuss_id");
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        IObjectValue objectValue1 = null;
        if (strUuid != null && BOSUuid.isValid((String)strUuid, (boolean)true)) {
            if (asstMap.containsKey(strUuid.trim())) {
                objectValue1 = (IObjectValue)asstMap.get(strUuid.trim());
            } else {
                BOSUuid uuid = BOSUuid.read((String)strUuid);
                ObjectUuidPK pk = new ObjectUuidPK(uuid);
                BOSObjectType objType = uuid.getType();
                objectValue1 = dynamicObject.getValue(objType, (IObjectPK)pk, sic);
                asstMap.put(strUuid.trim(), objectValue1);
            }
        }
        return objectValue1;
    }

    private AsstActTypeInfo getAcctCussType(Context ctx, RowSet rsDetail, HashMap asstypeMap, AsstActTypeInfo defaultAcctCussType) throws EASBizException, BOSException, SQLException {
        String strUuid = rsDetail.getString("acctcussType_id");
        AsstActTypeInfo acctCussTypeInfo = null;
        if (strUuid != null && BOSUuid.isValid((String)strUuid, (boolean)true)) {
            if (asstypeMap.containsKey(strUuid.trim())) {
                acctCussTypeInfo = (AsstActTypeInfo)asstypeMap.get(strUuid);
            } else {
                acctCussTypeInfo = new AsstActTypeInfo();
                acctCussTypeInfo.setId(BOSUuid.read((String)strUuid.trim()));
                acctCussTypeInfo.setName(rsDetail.getString("acctcussType_name"));
                acctCussTypeInfo.setNumber(rsDetail.getString("acctcussType_number"));
                acctCussTypeInfo.setDefaultQueryName(rsDetail.getString("acctcussType_query"));
                acctCussTypeInfo.setRealtionDataObject(rsDetail.getString("realtionDataObject"));
                asstypeMap.put(strUuid.trim(), acctCussTypeInfo);
            }
        } else if (defaultAcctCussType == null) {
            acctCussTypeInfo = defaultAcctCussType = ArVerificationFacadeFactory.getLocalInstance(ctx).getAsstActType("customer");
        }
        return acctCussTypeInfo;
    }

    public Date changeDate(Date date, int day) {
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    @Override
    protected CoreBillBaseInfo _getApBillData(Context ctx, String mainOrgUnitId, String currencyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId));
        String companyID = companyInfo.getId().toString();
        if (StringUtils.isEmpty((CharSequence)currencyID)) {
            currencyID = companyInfo.getBaseCurrency().getId().toString();
        }
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
        PeriodInfo periodInfo = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getStartPeriod(13, companyID);
        RowSet headrs = InitDataInputAPFactory.getLocalInstance(ctx).getBillHead(companyID, currencyID, periodInfo.getBeginDate());
        RowSet rsDetail = InitDataInputAPFactory.getLocalInstance(ctx).getBillDetail(companyID, currencyID);
        InitDataInputAPInfo info = new InitDataInputAPInfo();
        info.setCompany(companyInfo);
        info.setCurrency(currency);
        info.setStartPeriod(periodInfo);
        info.setExchangeRate(new BigDecimal("1"));
        info.put("accountTable", companyInfo.getAccountTable().getId().toString());
        info.setBizDate(this.changeDate(periodInfo.getBeginDate(), -1));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setCreator(userInfo);
        try {
            if (headrs.next()) {
                info.setId(BOSUuid.read((String)headrs.getString("id")));
            }
            InitDataInputAPentryInfo entryInfo = null;
            int rowIndex = 0;
            Vector<String> vcTmp = new Vector<String>();
            HashMap<String, String> hmTmp = new HashMap<String, String>();
            StringBuffer sb = new StringBuffer();
            HashMap<String, AsstActTypeInfo> asstypeMap = new HashMap<String, AsstActTypeInfo>();
            HashMap asstMap = new HashMap();
            InitDataInputAPentryCollection entrycol = new InitDataInputAPentryCollection();
            AsstActTypeInfo defaultAcctCussType = ApVerificationFacadeFactory.getLocalInstance(ctx).getAsstActType("customer");
            while (rsDetail.next()) {
                int index;
                sb.setLength(0);
                sb.append(rsDetail.getString("bizType"));
                if ("202".equals(rsDetail.getString("bizType"))) {
                    sb.setLength(0);
                    sb.append("204");
                }
                sb.append(rsDetail.getString("acctcussType_id"));
                sb.append(rsDetail.getString("acctcuss_id"));
                sb.append(rsDetail.getString("adminOrgUnitId"));
                sb.append(rsDetail.getString("personId"));
                sb.append(rsDetail.getString("account_id"));
                int isFromBill = rsDetail.getInt("isFromBill");
                int isBillCollected = rsDetail.getInt("isBillCollected");
                int isImpFromGL = rsDetail.getInt("isImpFromGL");
                int isBizBill = rsDetail.getInt("isBizBill");
                if (isImpFromGL == 1 && vcTmp.size() > 0 && vcTmp.contains(sb.toString())) {
                    index = Integer.parseInt((String)hmTmp.get(sb.toString()));
                    entryInfo = entrycol.get(index);
                    entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                }
                if (isFromBill == 1 || isFromBill == 0 && isBillCollected == 0) {
                    entryInfo = new InitDataInputAPentryInfo();
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                    entryInfo.setBizDate(this.changeDate(periodInfo.getBeginDate(), -1));
                    entryInfo.setBizType(VerificateBillTypeEnum.getEnum((int)rsDetail.getInt("bizType")));
                    AsstActTypeInfo acctCussTypeInfo = this.getAcctCussType(ctx, rsDetail, asstypeMap, defaultAcctCussType);
                    entryInfo.setAcctCussType(acctCussTypeInfo);
                    asstypeMap.put(acctCussTypeInfo.getId().toString(), acctCussTypeInfo);
                    entryInfo.setAcctCussID(rsDetail.getString("acctcuss_id"));
                    IObjectValue acctCuss = this.getacctCuss(ctx, rsDetail, asstMap);
                    HashMap<String, Object> asstAct = new HashMap<String, Object>();
                    asstAct.put("name", acctCuss.get("name"));
                    asstAct.put("number", acctCuss.get("number"));
                    asstAct.put("id", rsDetail.getString("acctcuss_id"));
                    asstAct.put("bosType", BOSUuid.getBOSObjectType((String)rsDetail.getString("acctcuss_id"), (boolean)true).toString());
                    entryInfo.put("asstact", asstAct);
                    entryInfo.put("asstactname", acctCuss.get("name"));
                    entryInfo.put("asstactnumber", acctCuss.get("number"));
                    entryInfo.setAccount(this.getAccountViewInfo(rsDetail));
                    entryInfo.setAdminOrgUnit(this.getAdminOrgUnitInfo(rsDetail));
                    entryInfo.setPerson(this.getPersonInfo(rsDetail));
                    entryInfo.setInitYearDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("year_direction")));
                    entryInfo.setInitYearAmt(rsDetail.getBigDecimal("year_Amt"));
                    entryInfo.setInitYearAmtLocal(rsDetail.getBigDecimal("year_AmtLoc"));
                    entryInfo.setYearTotalCreditAmt(rsDetail.getBigDecimal("total_CreditAmt"));
                    entryInfo.setYearTotalCreditAmtLocal(rsDetail.getBigDecimal("total_CreditAmtLoc"));
                    entryInfo.setYearTotalDebitAmt(rsDetail.getBigDecimal("total_DebitAmt"));
                    entryInfo.setYearTotalDebitAmtLocal(rsDetail.getBigDecimal("total_DebitAmtLoc"));
                    entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                    entryInfo.setInitPeriodAmt(rsDetail.getBigDecimal("period_Amt"));
                    entryInfo.setInitPeriodAmtLocal(rsDetail.getBigDecimal("period_AmtLoc"));
                    entryInfo.setIsBizBill(rsDetail.getBoolean("isBizBill"));
                    entryInfo.setIsImpFromGL(rsDetail.getBoolean("isImpFromGL"));
                    entryInfo.put("isfrombill", isFromBill);
                    if (isFromBill == 1) {
                        entryInfo.setIsBillCollected(true);
                        vcTmp.add(sb.toString());
                        hmTmp.put(sb.toString(), rowIndex + "");
                    } else {
                        entryInfo.setIsBillCollected(false);
                    }
                    ++rowIndex;
                    entrycol.add(entryInfo);
                    continue;
                }
                if (isBillCollected != 1 || isFromBill != 0 || !vcTmp.contains(sb.toString())) continue;
                index = Integer.parseInt((String)hmTmp.get(sb.toString()));
                entryInfo = entrycol.get(index);
                entryInfo.setInitYearDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("year_direction")));
                entryInfo.setInitPeriodDirection(BalanceDirectionEnum.getEnum((int)rsDetail.getInt("period_direction")));
                entryInfo.setInitYearAmt(rsDetail.getBigDecimal("year_Amt"));
                entryInfo.setInitYearAmtLocal(rsDetail.getBigDecimal("year_AmtLoc"));
                entryInfo.setYearTotalCreditAmt(rsDetail.getBigDecimal("total_CreditAmt"));
                entryInfo.setYearTotalCreditAmtLocal(rsDetail.getBigDecimal("total_CreditAmtLoc"));
                entryInfo.setYearTotalDebitAmt(rsDetail.getBigDecimal("total_DebitAmt"));
                entryInfo.setYearTotalDebitAmtLocal(rsDetail.getBigDecimal("total_DebitAmtLoc"));
            }
            info.getEntrys().addCollection(entrycol);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }
}

