/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgCollection;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.IManageAccount;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;

public class ArApRecomputeJobHandler
implements IJobHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Job job) throws Exception {
        try {
            Context ctx = job.getContext();
            Object params = job.getParameters();
            CompanyOrgUnitInfo company = null;
            boolean isAR = Boolean.FALSE;
            Locale locale = null;
            UserInfo userInfo = null;
            int yearStart = 0;
            int periodStart = 0;
            boolean cbBillBalance = false;
            boolean cbAccountBalance = false;
            if (params != null && params instanceof Object[]) {
                Object[] parObjs = (Object[])params;
                isAR = (Boolean)parObjs[0];
                company = (CompanyOrgUnitInfo)parObjs[1];
                yearStart = (Integer)parObjs[2];
                periodStart = (Integer)parObjs[3];
                cbBillBalance = (Boolean)parObjs[4];
                cbAccountBalance = (Boolean)parObjs[5];
                locale = (Locale)parObjs[6];
                userInfo = (UserInfo)parObjs[7];
                if (userInfo != null && userInfo.getNumber() != null) {
                    userInfo = UserInfoUtils.getUserInfo4LoinModule((Context)ctx, (String)userInfo.getNumber().toString());
                }
                ctx.put((Object)"UserInfo", (Object)userInfo);
            } else {
                locale = LocaleUtils.locale_L2;
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String flag = null;
            MessageInfo msgInfo = new MessageInfo();
            String tranDefNumber = "";
            if (isAR) {
                flag = EASCommonResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ArRecomputeBalance", (Locale)locale);
                tranDefNumber = "SCM_FI_AR_002";
            } else {
                flag = EASCommonResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"ApRecomputeBalance", (Locale)locale);
                tranDefNumber = "SCM_FI_AP_002";
            }
            this.setMsgInfo(msgInfo, userId, company, flag, true, locale);
            boolean isSendMsg = false;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)tranDefNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            PerfSepCfgCollection col = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgCollection(view);
            if (col != null && col.size() > 0) {
                isSendMsg = col.get(0).isIsSendMsg();
            }
            try {
                IManageAccount ida = ManageAccountFactory.getLocalInstance(job.getContext());
                if (isAR) {
                    ida.reComputeArBalance(company, yearStart, periodStart, cbBillBalance, cbAccountBalance);
                } else {
                    ida.reComputeApBalance(company, yearStart, periodStart, cbBillBalance, cbAccountBalance);
                }
                JobLog log = new JobLog(JobLog.Type.Info, flag + this.getStrResource("Success"));
                job.saveMessage(log);
                msgInfo.setSendMsg(isSendMsg);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
            }
            catch (EASBizException e) {
                msgInfo.setSuccessed(false);
                msgInfo.setExecption(e.getMessage());
                msgInfo.setSendMsg(isSendMsg);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                throw e;
            }
            catch (BOSException be) {
                msgInfo.setSuccessed(false);
                msgInfo.setExecption(be.getMessage());
                msgInfo.setSendMsg(isSendMsg);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)msgInfo);
                throw be;
            }
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return new Boolean(true);
    }

    private void setMsgInfo(MessageInfo msgInfo, String userId, CompanyOrgUnitInfo company, String flag, boolean issuccessed, Locale locale) {
        msgInfo.setbizAction(flag);
        msgInfo.setOrgNumber(company.getName(locale) + "  (" + company.getNumber() + ")");
        msgInfo.setUserID(userId);
        msgInfo.setExecption("");
        msgInfo.setSuccessed(issuccessed);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }
}

