/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.AbstractArapWebQrySolFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ArapWebQrySolFacadeControllerBean
extends AbstractArapWebQrySolFacadeControllerBean {
    private static final long serialVersionUID = 1789045463455342134L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ArapWebQrySolFacadeControllerBean");

    public ShareTypeEnum getShareType(boolean isShare) {
        if (isShare) {
            return ShareTypeEnum.USER_NOORG_LEVEL;
        }
        return ShareTypeEnum.USER_LEVEL;
    }

    @Override
    protected Map _getQrySolResMap(Context ctx) throws BOSException, EASBizException {
        return this.getResources(ctx, "com.kingdee.eas.fi.arap.ArapWebBizCommonQueryResource", new String[]{"236_SOLUTION_SAVE_OK", "237_SOLUTION_SET_OK", "238_SOLUTION_DELETE_OK", "257_DEFAULT_SOLUTION", "340_HAS_SAME_SOLUTION", "259_PROCESS_QRY", "260_SAVE_SOL", "261_INPUT_SOLNAME", "262_SELECTED_ITEMS", "263_MORE", "264_CLLAPSE", "265_DELETE_SOL", "266_SET_DEFAULT", "267_SETUP", "268_COM_SOL", "207_REQUIRE_COMPANY", "269_SOL_NAME", "270_COM_ITEMS", "271_SOL_QRY", "287_DEFAULT_SOL", "403_UNFLOD", "404_PACK_UP", "405_CANCEL_DEFAULT", "406_SOLUTION_CALCEL_OK"});
    }

    @Override
    protected String _saveUserSolution(Context ctx, boolean isShare, String solutionName, String parentUIName, String filterJsonStr) throws BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        String solutionId = null;
        if (userId != null && solutionName != null && parentUIName != null && filterJsonStr != null) {
            QuerySolutionInfo solutionInfo = null;
            solutionId = this.getUserSolutionId(ctx, isShare, solutionName, parentUIName);
            if (!StringUtils.isEmpty((String)solutionId)) {
                solutionInfo = this.editUserSolution(ctx, isShare, solutionId, parentUIName, solutionName, filterJsonStr);
            } else {
                solutionInfo = this.addUserSolution(ctx, isShare, parentUIName, solutionName, filterJsonStr, userId);
                solutionId = solutionInfo.getId().toString();
            }
        }
        return solutionId;
    }

    @Override
    protected void _setUserDefaultSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        if (solutionId != null && parentUIName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("update T_QUERY_QuerySolution set FIsUserDefaultSolu = 0").append(" where FParentUIName = '").append(parentUIName).append("'").append(" and FOwner = '").append(ctx.getCaller().toString()).append("'").append(" and FIsUserDefaultSolu = 1");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb = new StringBuilder();
            sb.append("update T_QUERY_QuerySolution set FIsUserDefaultSolu = 1").append(" where fid = '").append(solutionId).append("'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    @Override
    protected void _unSetUserDefaultSolution(Context ctx, String parentUIName, String solutionId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_QUERY_QUERYSOLUTION set FIsUserDefaultSolu = 0 ");
        sql.append(" where  FParentUIName = '").append(parentUIName).append("'");
        sql.append(" and FIsUserDefaultSolu = 1 and FID = '").append(solutionId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _removeUserSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
    }

    @Override
    protected Map _getSolutionDetail(Context ctx, String solutionId) throws BOSException, EASBizException {
        HashMap<String, String> data = new HashMap<String, String>();
        if (solutionId != null && solutionId.length() > 0) {
            String customerParams = null;
            QuerySolutionInfo solutionInfo = null;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                QueryPanelInfo info = queryPanels.get(i0);
                customerParams = info.getCustomerParams();
            }
            if (customerParams != null) {
                data.put("searchFilter", customerParams);
                data.put("solution", (String)solutionInfo);
            }
        }
        return data;
    }

    @Override
    protected List _getUserSolutionList(Context ctx, boolean isShare, String parentUIName) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, isShare);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                solutions.add(info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }

    public String getUserSolutionId(Context ctx, boolean isShare, String solutionName, String parentUIName) throws BOSException {
        try {
            IRowSet rs;
            String loc = ctx.getLocale().toString();
            StringBuilder sb = new StringBuilder();
            sb.append("select fid from T_QUERY_QuerySolution").append(" where FParentUIName = '").append(parentUIName).append("'").append(" and FName_").append(loc).append(" = '").append(solutionName).append("'").append(" and FOwner = '").append(ctx.getCaller().toString()).append("'");
            if (!isShare) {
                sb.append(" and ForgID = '").append(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()).append("'");
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString())).next()) {
                return rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public boolean existSolution(Context ctx, boolean isShare, String solutionName, String parentUIName) throws BOSException {
        boolean isExists = false;
        try {
            Object queryName = null;
            IObjectPK userID = ctx.getCaller();
            BOSUuid orgID = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)solutionName);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("queryObjectName", queryName);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUIName);
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterItemInfo userOrgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(1));
            FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
            FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
            FilterItemInfo userLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(16));
            if (isShare) {
                filterInfo.getFilterItems().add(userLevelFilterItem);
                filterInfo.getFilterItems().add(ownerFilterItem);
            } else {
                filterInfo.getFilterItems().add(userOrgLevelFilterItem);
                filterInfo.getFilterItems().add(ownerFilterItem);
                filterInfo.getFilterItems().add(orgFilterItem);
            }
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            isExists = iSolution.exists(filterInfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return isExists;
    }

    public QuerySolutionInfo editUserSolution(Context ctx, boolean isShare, String solutionId, String parentUIName, String solutionName, String filterJsonStr) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionId));
            solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setShareType(this.getShareType(isShare));
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(filterJsonStr);
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getUserSolutionList(ctx, isShare, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            }
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public QueryPanelCollection getQueryPanelCollection(String filterJsonStr) throws EASBizException, BOSException {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        FilterInfo filter = new FilterInfo();
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        queryPanelInfo.setCustomerParams(filterJsonStr);
        QueryPanelCollection queryPanelCol = new QueryPanelCollection();
        queryPanelCol.add(queryPanelInfo);
        return queryPanelCol;
    }

    public QuerySolutionInfo addUserSolution(Context ctx, boolean isShare, String parentUIName, String solutionName, String filterJsonStr, String userId) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setShareType(this.getShareType(isShare));
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentUIName);
            solutionInfo.setIsUserDefaultSolu(false);
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            solutionInfo.setOrgID(ContextUtil.getCurrentFIUnit((Context)ctx).getId());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(filterJsonStr);
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName, boolean isShare) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("owner", (Object)ctx.getCaller().toString()));
        if (!isShare) {
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItemCollection());
        return viewInfo;
    }

    public SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    private Map<String, String> getResources(Context ctx, String resPath, String[] items) {
        ConcurrentHashMap<String, String> resItems = null;
        if (ctx != null && resPath != null && items != null && items.length > 0) {
            resItems = new ConcurrentHashMap<String, String>(items.length);
            for (String itemName : items) {
                resItems.put(itemName, EASCommonResource.getString((String)resPath, (String)itemName, (Locale)ctx.getLocale()));
            }
        }
        return resItems;
    }
}

