/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ElecInvoiceCollection;
import com.kingdee.eas.fi.arap.ElecInvoiceFactory;
import com.kingdee.eas.fi.arap.ElecInvoiceInfo;
import com.kingdee.eas.fi.arap.ElecInvoiceSettingCollection;
import com.kingdee.eas.fi.arap.ElecInvoiceSettingFactory;
import com.kingdee.eas.fi.arap.ElecInvoiceSettingInfo;
import com.kingdee.eas.fi.arap.IElecInvoice;
import com.kingdee.eas.fi.arap.IElecInvoiceSetting;
import com.kingdee.eas.fi.arap.SyncStatus;
import com.kingdee.eas.fi.arap.app.AbstractElecInvoiceSyncFacadeControllerBean;
import com.kingdee.eas.fi.arap.app.elecinvoice.InvoicePlatformImpl;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ElecInvoiceSyncFacadeControllerBean
extends AbstractElecInvoiceSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ElecInvoiceSyncFacadeControllerBean");

    @Override
    protected void _syncElecInvoice(Context ctx) throws BOSException, EASBizException {
        InvoicePlatformImpl invoiceAPI = new InvoicePlatformImpl();
        IElecInvoice elecInvoice = ElecInvoiceFactory.getLocalInstance(ctx);
        IElecInvoiceSetting invoiceSetting = ElecInvoiceSettingFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)true, CompareType.EQUALS));
        ElecInvoiceSettingCollection settings = invoiceSetting.getElecInvoiceSettingCollection(view);
        for (int i = 0; i < settings.size(); ++i) {
            ElecInvoiceSettingInfo setting = settings.get(i);
            try {
                String sbh = setting.getSbh();
                String secrets = setting.getSecrets();
                Date from = new Date(System.currentTimeMillis() - 31104000000L);
                Date to = new Date();
                long maxInvoiceDate = from.getTime();
                ElecInvoiceCollection invoices = invoiceAPI.getInvoice(sbh, secrets, from, to, 10);
                for (int j = 0; j < invoices.size(); ++j) {
                    ElecInvoiceInfo invoiceInfo = invoices.get(j);
                    if (invoiceInfo.getBizDate().getTime() > maxInvoiceDate) {
                        maxInvoiceDate = invoiceInfo.getBizDate().getTime();
                    }
                    invoiceInfo.setCompany(setting.getCompany());
                    if (elecInvoice.exists("where fphm='" + invoiceInfo.getFphm() + "'")) continue;
                    elecInvoice.addnew((CoreBaseInfo)invoiceInfo);
                }
                setting.setLastInvoiceDate(new Date(maxInvoiceDate));
                setting.setSyncStatus(SyncStatus.SUCCESS);
                setting.setLastSyncTime(new Timestamp(System.currentTimeMillis()));
                setting.setLastSyncLog(EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"getBillSuccess").getBytes("UTF-8"));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("lastInvoiceDate"));
                sic.add(new SelectorItemInfo("syncStatus"));
                sic.add(new SelectorItemInfo("syncTime"));
                sic.add(new SelectorItemInfo("syncLog"));
                invoiceSetting.updatePartial((CoreBaseInfo)setting, sic);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                setting.setSyncStatus(SyncStatus.FAIL);
                setting.setLastSyncTime(new Timestamp(System.currentTimeMillis()));
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                e.printStackTrace(writer);
                try {
                    setting.setLastSyncLog((e.getMessage() + "\n" + sw.toString()).getBytes("UTF-8"));
                }
                catch (Exception to) {
                    // empty catch block
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("syncStatus"));
                sic.add(new SelectorItemInfo("syncTime"));
                sic.add(new SelectorItemInfo("syncLog"));
                invoiceSetting.updatePartial((CoreBaseInfo)setting, sic);
            }
        }
    }
}

