/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ap.ApInvoiceEntryCollection;
import com.kingdee.eas.fi.ap.ApInvoiceEntryInfo;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryCollection;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.app.AbstractInvoiceVATEditUIHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import java.util.HashSet;

public class InvoiceVATEditUIHandler
extends AbstractInvoiceVATEditUIHandler {
    public static final String COL_MATERIAL = "material";
    public static final String COL_UNIT = "measureUnit";
    public static final String STATUS_VIEW = "VIEW";
    private static final BOSObjectType CUST_TYPE = new CustomerInfo().getBOSType();
    private static final BOSObjectType SUPP_TYPE = new SupplierInfo().getBOSType();

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.requestData(request, response, context);
        this.requestTableData(request, response, context);
    }

    protected void requestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)request.get("companyInfo");
        SystemEnum systemEnum = (SystemEnum)request.get("systemEnum");
        SystemStatusCtrolFactory.getLocalInstance((Context)context).getStartPeriod(new Integer(systemEnum.getValue()).intValue(), companyInfo.getId().toString());
        SystemStatusCtrolFactory.getLocalInstance((Context)context).getCacheCurrentPeriod(new Integer(systemEnum.getValue()).intValue(), companyInfo.getId().toString());
    }

    @Override
    protected void _handleActionBlankout(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionGTaxExport(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionPrintPreview(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPrintPreview(request, response, context);
        String methodName = (String)request.get("methodName");
        BOSObjectType bizObjType = (BOSObjectType)request.get("bizObjType");
        IObjectPK instancePK = (IObjectPK)request.get("instancePK");
        String instanceDetail = (String)request.get("instanceDetail");
        AppLogFactory.getLocalInstance((Context)context).writeLog(methodName, bizObjType, instancePK, instanceDetail);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        request.setValue((CoreBaseInfo)((InvoiceInfo)request.get("kdtEntries")));
        this.requestTableData(request, response, context);
    }

    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNext(request, response, context);
        this.requestTableData(request, response, context);
    }

    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPre(request, response, context);
        this.requestTableData(request, response, context);
    }

    protected void requestTableData(RequestContext request, ResponseContext response, Context context) throws Exception {
        Object invEntry;
        HashSet<BOSUuid> srcEntrySet;
        InvoiceInfo invoInfo = (InvoiceInfo)request.getValue();
        if (invoInfo == null) {
            return;
        }
        Boolean fBotNew = (Boolean)request.get("fBotNew");
        if (fBotNew == null) {
            return;
        }
        if (fBotNew.booleanValue() || STATUS_VIEW.equals(request.getState())) {
            String asstActId = invoInfo.getAsstActID();
            BOSUuid bosId = BOSUuid.read((String)asstActId);
            BOSObjectType bosType = bosId.getType();
            IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)context);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("name");
            selectors.add("number");
            if (bosType.equals((Object)CUST_TYPE) || bosType.equals((Object)SUPP_TYPE)) {
                selectors.add("address");
                selectors.add("parent.id");
                selectors.add("taxRegisterNo");
            }
            IObjectValue cussAcctInfo = iDynObj.getValue(bosId.getType(), (IObjectPK)new ObjectUuidPK(bosId), selectors);
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)request.get("companyInfo");
            if (cussAcctInfo != null) {
                if (cussAcctInfo instanceof CustomerInfo) {
                    this.setCustomerData2UI(context, (CustomerInfo)cussAcctInfo, companyInfo);
                } else if (cussAcctInfo instanceof SupplierInfo) {
                    this.setSupplierData2UI(context, (SupplierInfo)cussAcctInfo, companyInfo);
                }
            }
        }
        if (invoInfo instanceof ArInvoiceInfo) {
            Object arentryinfo;
            ArInvoiceInfo arinfo = (ArInvoiceInfo)invoInfo;
            ArInvoiceEntryCollection arcoll = arinfo.getEntries();
            srcEntrySet = new HashSet<BOSUuid>();
            invEntry = null;
            int j = arcoll.size();
            for (int i = 0; i < j; ++i) {
                arentryinfo = arcoll.get(i);
                if (arentryinfo.getMaterial() == null || arentryinfo.getMeasureUnit() == null) continue;
                String materialId = arentryinfo.getMaterial().getId().toString();
                String unitId = arentryinfo.getMeasureUnit().getId().toString();
                MultiMeasureUnitFactory.getLocalInstance((Context)context).getMultiUnit(materialId, unitId);
                if (arentryinfo.getBOSUuid("sourcebillentryid") == null) continue;
                srcEntrySet.add(arentryinfo.getBOSUuid("sourcebillentryid"));
            }
            if (srcEntrySet.size() != 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", srcEntrySet, CompareType.INCLUDE));
                view.setFilter(filter);
                view.getSelector().add("id");
                view.getSelector().add("recievePayAmount");
                view.getSelector().add("invoicedAmt");
                arentryinfo = OtherBillentryFactory.getLocalInstance(context).getArApBillEntryBaseCollection(view);
            }
        } else if (invoInfo instanceof ApInvoiceInfo) {
            ApInvoiceInfo apinfo = (ApInvoiceInfo)invoInfo;
            ApInvoiceEntryCollection apcoll = apinfo.getEntries();
            srcEntrySet = new HashSet();
            invEntry = null;
            int j = apcoll.size();
            for (int i = 0; i < j; ++i) {
                ApInvoiceEntryInfo apentryinfo = apcoll.get(i);
                if (apentryinfo.getMaterial() == null || apentryinfo.getMeasureUnit() == null) continue;
                String materialId = apentryinfo.getMaterial().getId().toString();
                String unitId = apentryinfo.getMeasureUnit().getId().toString();
                MultiMeasureUnitFactory.getLocalInstance((Context)context).getMultiUnit(materialId, unitId);
                if (apentryinfo.getBOSUuid("sourcebillentryid") == null) continue;
                srcEntrySet.add(apentryinfo.getBOSUuid("sourcebillentryid"));
            }
            if (srcEntrySet.size() != 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", srcEntrySet, CompareType.INCLUDE));
                view.setFilter(filter);
                view.getSelector().add("id");
                view.getSelector().add("recievePayAmount");
                view.getSelector().add("invoicedAmt");
                ArApBillEntryBaseCollection arApBillEntryBaseCollection = com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(context).getArApBillEntryBaseCollection(view);
            }
        }
    }

    protected void setCustomerData2UI(Context context, CustomerInfo cussAcctInfo, CompanyOrgUnitInfo companyInfo) throws Exception {
        StringBuffer oql = new StringBuffer();
        oql.append("select bank, bankAccount, phone where ");
        oql.append(" companyOrgUnit.id = '").append(companyInfo.getId());
        oql.append("' and customer.id = '");
        oql.append(cussAcctInfo.getString("id")).append("' ");
        EntityViewInfo view = new EntityViewInfo(oql.toString());
        ICustomerCompanyInfo iCustComp = CustomerCompanyInfoFactory.getLocalInstance((Context)context);
        iCustComp.getCustomerCompanyInfoCollection(view);
    }

    protected void setSupplierData2UI(Context context, SupplierInfo cussAcctInfo, CompanyOrgUnitInfo companyInfo) throws Exception {
        StringBuffer oql = new StringBuffer();
        oql.append("select bankName, bankAccount, phone where ");
        oql.append(" companyOrgUnit.id = '").append(companyInfo.getId());
        oql.append("' and supplier.id = '");
        oql.append(cussAcctInfo.getString("id")).append("' ");
        EntityViewInfo view = new EntityViewInfo(oql.toString());
        ISupplierCompanyInfo iCustComp = SupplierCompanyInfoFactory.getLocalInstance((Context)context);
        iCustComp.getSupplierCompanyInfoCollection(view);
    }
}

