/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApRelationEntryInfo;
import com.kingdee.eas.fi.ar.ArShutAccountFactory;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.IOtherBillentry;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.IProxyBill;
import com.kingdee.eas.fi.arap.ProxyBillAgent;
import com.kingdee.eas.fi.arap.ProxyBillBizException;
import com.kingdee.eas.fi.arap.ProxyBillCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryAgent;
import com.kingdee.eas.fi.arap.ProxyBillEntryCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryInfo;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.ProxyBillInfo;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanAgent;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanCollection;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanInfo;
import com.kingdee.eas.fi.arap.app.AbstractProxyBillControllerBean;
import com.kingdee.eas.fi.arap.app.ProxyBillSwapHelper;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProxyBillControllerBean
extends AbstractProxyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ProxyBillControllerBean");
    private final BigDecimal ZERO = new BigDecimal("0");
    private static final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArapResource";
    private static final BOSObjectType arotherBillBosType = new OtherBillInfo().getBOSType();
    private static final BOSObjectType apotherBillBosType = new com.kingdee.eas.fi.ap.OtherBillInfo().getBOSType();

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this._exists(ctx, "where isInitializeBill=1 and id='" + pk.toString() + "'")) {
            String str = ResourceBase.getString((String)ARAP_RESOURCE, (String)"LogTitle", (Locale)ctx.getLocale());
            return str + super._getLogInfo(ctx, pk);
        }
        return super._getLogInfo(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String companyID;
        SelectorItemCollection selects = new SelectorItemCollection();
        selects.add(new SelectorItemInfo("number"));
        selects.add(new SelectorItemInfo("BillStatus"));
        ProxyBillInfo proxyBill = this.getProxyBillInfo(ctx, pk, selects);
        if (BillStatusEnum.AUDITED.equals((Object)proxyBill.getBillStatus())) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_HAS_AUDITED);
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)proxyBill, companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)proxyBill)) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)proxyBill, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)proxyBill, companyID, proxyBill.getNumber());
        }
        super._delete(ctx, pk);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        Date currentDate = new Date();
        boolean exist = this.exists(ctx, pk);
        if (!exist) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ProxyBillInfo proxyBillInfo = this.getProxyBillInfo(ctx, pk);
        boolean directSumbit = false;
        if (proxyBillInfo.getLastUpdateUser() == null || proxyBillInfo.getLastUpdateTime() == null) {
            directSumbit = true;
        }
        if (BillStatusEnum.AUDITED.equals((Object)proxyBillInfo.getBillStatus())) {
            throw new ProxyBillBizException(ProxyBillBizException.AGAIN_AUDITED);
        }
        if (BillStatusEnum.SAVE.equals((Object)proxyBillInfo.getBillStatus())) {
            throw new ProxyBillBizException(ProxyBillBizException.SAVING_NOTAUDIT);
        }
        this.checkIsInQueue(ctx, proxyBillInfo);
        proxyBillInfo.setAuditor(currentUser);
        proxyBillInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
        proxyBillInfo.setBillStatus(BillStatusEnum.AUDITED);
        if (ArApParamHelper.isProxyBillSamePersion(ctx, proxyBillInfo.getCompanyOrgUnit().getId().toString()) && ArApBillHelper.idEquals((CoreBaseInfo)proxyBillInfo.getCreator(), (CoreBaseInfo)currentUser)) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAME_PERSON);
        }
        this.makeOtherARBill(ctx, proxyBillInfo);
        super._passAudit(ctx, pk, (IObjectValue)proxyBillInfo);
        if (directSumbit) {
            DbUtil.execute((Context)ctx, (String)("update T_ARP_ProxyBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + pk.toString() + "'"));
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        boolean exist = this._exists(ctx, pk);
        if (!exist) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ProxyBillInfo proxyBillInfo = this.getProxyBillInfo(ctx, pk);
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeBizProcess(proxyBillInfo.getCompanyOrgUnit(), proxyBillInfo.getBillDate());
        boolean isInitBill = this.isInitBill(ctx, proxyBillInfo);
        Date billDate = proxyBillInfo.getBillDate();
        ObjectUuidPK iopk = new ObjectUuidPK(BOSUuid.read((String)proxyBillInfo.getCompanyOrgUnit().getId().toString()));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)iopk);
        Date beginDate = periodInfo.getBeginDate();
        if (!isInitBill && billDate.before(beginDate)) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_DATE_ISBEFOREPERIOD);
        }
        if (proxyBillInfo.isFiVouchered()) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_ISVOUHERED);
        }
        if (BillStatusEnum.SUBMITED.equals((Object)proxyBillInfo.getBillStatus())) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_ISSUBMITED);
        }
        if (BillStatusEnum.SAVE.equals((Object)proxyBillInfo.getBillStatus())) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_ISSAVING);
        }
        if (this.isZeroSomeFieldByPk(ctx, pk)) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_LOCKVERIFYAMT_ISZERO);
        }
        if (this.isExistsTraceDownByPk(ctx, pk)) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_TRACEDOWN_ISEXISTS);
        }
        if (!ProxyBillSwapHelper.checkSwap(ctx, pk)) {
            throw new ProxyBillBizException(ProxyBillBizException.SWAP_UNAUDIT);
        }
        if (ArApParamHelper.isProxyBillSameAuditor(ctx, proxyBillInfo.getCompanyOrgUnit().getId().toString()) && !ArApBillHelper.idEquals((CoreBaseInfo)proxyBillInfo.getAuditor(), (CoreBaseInfo)currentUser)) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAMEAUDITOR_PERSON);
        }
        CompanyOrgUnitInfo curCompany = proxyBillInfo.getCompanyOrgUnit();
        boolean apIsStart = ApServerUtils.apIsStart(ctx, curCompany);
        boolean arIsStart = ArServerUtils.arIsStart(ctx, curCompany);
        if (isInitBill && (apIsStart || arIsStart)) {
            throw new ProxyBillBizException(ProxyBillBizException.BILL_ARAPSYSTEM_ISFINISH);
        }
        ProxyBillSwapHelper.deleteDestSwapBill(ctx, pk);
        this.checkIsInQueue(ctx, proxyBillInfo);
        this.removeOtherARBill(ctx, proxyBillInfo);
        proxyBillInfo.setAuditor(null);
        proxyBillInfo.setAuditDate(null);
        proxyBillInfo.setBillStatus(BillStatusEnum.SAVE);
        this._update(ctx, pk, (IObjectValue)proxyBillInfo);
        super._unpassAudit(ctx, pk, (IObjectValue)proxyBillInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProxyBillInfo info = (ProxyBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(info.getCompanyOrgUnit(), info.getBillDate());
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected HashMap getBOTPDestBills(Context ctx, String aBosType) throws BOTPException, BOSException {
        HashMap<String, String> ret = new HashMap<String, String>();
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        String targetTypeAndAliasString = iBOTMapping.getTargetBillTypeList(aBosType);
        String[] targetTypeAndAlias = StringUtils.split((String)targetTypeAndAliasString, (String)"|");
        String targetBillTypeString = targetTypeAndAlias[0];
        String targetAliasString = targetTypeAndAlias[1];
        String[] targetAlias = targetAliasString.split(",");
        if (targetBillTypeString.equals("")) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource", (String)"noDestBill", (Locale)ctx.getOriginLocale()));
        }
        String[] targetBillType = targetBillTypeString.split(",");
        for (int i = 0; i < targetBillType.length; ++i) {
            String targetBillDisplayName = targetAlias[i];
            ret.put(targetBillDisplayName, targetBillType[i]);
        }
        return ret;
    }

    protected BOTMappingCollection getRulesByDestBill(Context ctx, String aDestBosType, ProxyBillInfo srcInfo) throws BOTPException, BOSException, Exception {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)srcInfo);
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(sourceBillCollection, aDestBosType, DefineSysEnum.BTP);
        return botMappingCollection;
    }

    protected void makeOtherARBill(Context ctx, ProxyBillInfo info) throws EASBizException, BOSException {
        CtrlUnitInfo cu = (CtrlUnitInfo)CtrlUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(info.getCU().getId()));
        ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cu);
        boolean isAllMaterial = false;
        ProxyBillEntryCollection entryCol = info.getEntry();
        ProxyBillEntryInfo entryInfo = entryCol.get(0);
        if (entryInfo.getMaterial() != null) {
            isAllMaterial = true;
        }
        IObjectValue asst = this.getBizObject(ctx, info.getRecAsstActId());
        String destBillBosType = ArApConstants.AP_OBILL_TYPE.toString();
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
        billCollection.add((CoreBillBaseInfo)info);
        BOTMappingInfo apBtpMappingInfo = ArApBillHelper.getBotpMappingInfo(ctx, ArApConstants.PROXYBILL_TYPE, ArApConstants.AP_OBILL_TYPE, cu.getId().toString());
        if (apBtpMappingInfo == null) {
            throw new OtherBillBizException(OtherBillBizException.CANNOTGETARAPBOTP);
        }
        ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
        srcBillColsList.add(billCollection);
        ArrayList<String> botMappingPKCols = new ArrayList<String>();
        botMappingPKCols.add(apBtpMappingInfo.getId().toString());
        BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBillColsList, destBillBosType, botMappingPKCols);
        IObjectCollection destBillCols = btpResult.getBills();
        BigDecimal totalAmount = null;
        BigDecimal totalTax = null;
        BigDecimal totalPayAmount = null;
        BigDecimal unVeriAmount = null;
        BigDecimal unVeriAmountLocal = null;
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            ProxyBillEntryInfo aProxyBillEntryInfo;
            int j;
            totalAmount = this.ZERO;
            totalTax = this.ZERO;
            totalPayAmount = this.ZERO;
            unVeriAmount = this.ZERO;
            unVeriAmountLocal = this.ZERO;
            com.kingdee.eas.fi.ap.OtherBillInfo destBillInfo = (com.kingdee.eas.fi.ap.OtherBillInfo)btpResult.getBills().getObject(i);
            destBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            destBillInfo.setBillDate(info.getBillDate());
            destBillInfo.setBizDate(info.getBizDate());
            destBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            destBillInfo.setSourceBillType(VerificateBillTypeEnum.ApAgentBizBill);
            if (isAllMaterial) {
                destBillInfo.setBillType(OtherBillType.InvoiceBill);
            } else {
                destBillInfo.setBillType(OtherBillType.ExpenseInvoice);
            }
            destBillInfo.setIsInitializeBill(info.isIsInitializeBill());
            destBillInfo.setLastExhangeRate(info.getRecExchangeRate());
            ArrayList<String> sourceBillLists = new ArrayList<String>();
            int destentryCount = destBillInfo.getEntry().size();
            for (int destCount = 0; destCount < destentryCount; ++destCount) {
                OtherBillentryInfo aOtherBillentryInfo = destBillInfo.getEntry().get(destCount);
                aOtherBillentryInfo.setVerifyAmount(aOtherBillentryInfo.getRecievePayAmount().subtract(aOtherBillentryInfo.getUnVerifyAmount()));
                aOtherBillentryInfo.setLockVerifyAmt(aOtherBillentryInfo.getRecievePayAmount().subtract(aOtherBillentryInfo.getLockUnVerifyAmt()));
                totalAmount = totalAmount.add(aOtherBillentryInfo.getAmount());
                totalPayAmount = totalPayAmount.add(aOtherBillentryInfo.getRecievePayAmount());
                unVeriAmount = unVeriAmount.add(aOtherBillentryInfo.getLockUnVerifyAmt());
                unVeriAmountLocal = unVeriAmountLocal.add(aOtherBillentryInfo.getLockUnVerifyAmtLocal());
                if (aOtherBillentryInfo.getTaxAmount() != null) {
                    totalTax = totalTax.add(aOtherBillentryInfo.getTaxAmount());
                }
                sourceBillLists.add(aOtherBillentryInfo.getSourceBillEntryId().toString());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            HashSet<String> dateSet = new HashSet<String>();
            BigDecimal verifyAmount = SysConstant.BIGZERO;
            BigDecimal verifyAmountLocal = SysConstant.BIGZERO;
            BigDecimal reVerifyAmount = SysConstant.BIGZERO;
            BigDecimal reVerifyAmountLocal = SysConstant.BIGZERO;
            int entryCount = info.getEntry().size();
            for (j = 0; j < entryCount; ++j) {
                aProxyBillEntryInfo = info.getEntry().get(j);
                if (!sourceBillLists.contains(aProxyBillEntryInfo.getId().toString())) continue;
                dateSet.add(sdf.format(aProxyBillEntryInfo.getPayableAmtDate()));
                verifyAmount = verifyAmount.add(aProxyBillEntryInfo.getPayVerifyAmt());
                verifyAmountLocal = verifyAmountLocal.add(aProxyBillEntryInfo.getPayVerifyAmt().multiply(aProxyBillEntryInfo.getPayExchangeRate()));
                reVerifyAmount = reVerifyAmount.add(aProxyBillEntryInfo.getPayableAmt());
                reVerifyAmountLocal = reVerifyAmountLocal.add(aProxyBillEntryInfo.getPayableAmtLocal());
            }
            if (dateSet.size() == 1) {
                com.kingdee.eas.fi.ap.OtherBillPlanInfo adestBillPlanInfo = new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
                int entryCount2 = info.getEntry().size();
                for (int j2 = 0; j2 < entryCount2; ++j2) {
                    ProxyBillEntryInfo aProxyBillEntryInfo2 = info.getEntry().get(j2);
                    if (!sourceBillLists.contains(aProxyBillEntryInfo2.getId().toString())) continue;
                    adestBillPlanInfo.setRecievePayDate(aProxyBillEntryInfo2.getPayableAmtDate());
                    adestBillPlanInfo.setVerifyAmount(verifyAmount);
                    adestBillPlanInfo.setVerifyAmountLocal(verifyAmountLocal);
                    adestBillPlanInfo.setRecievePayDate(aProxyBillEntryInfo2.getPayableAmtDate());
                    adestBillPlanInfo.setRecievePayAmount(reVerifyAmount);
                    adestBillPlanInfo.setRecievePayAmountLocal(reVerifyAmountLocal);
                    destBillInfo.getPayPlan().add(adestBillPlanInfo);
                    break;
                }
            } else {
                entryCount = info.getEntry().size();
                for (j = 0; j < entryCount; ++j) {
                    aProxyBillEntryInfo = info.getEntry().get(j);
                    if (!sourceBillLists.contains(aProxyBillEntryInfo.getId().toString())) continue;
                    com.kingdee.eas.fi.ap.OtherBillPlanInfo adestBillPlanInfo = new com.kingdee.eas.fi.ap.OtherBillPlanInfo();
                    adestBillPlanInfo.setRecievePayDate(aProxyBillEntryInfo.getPayableAmtDate());
                    adestBillPlanInfo.setVerifyAmount(aProxyBillEntryInfo.getPayVerifyAmt());
                    adestBillPlanInfo.setVerifyAmountLocal(aProxyBillEntryInfo.getPayVerifyAmt().multiply(aProxyBillEntryInfo.getPayExchangeRate()));
                    adestBillPlanInfo.setRecievePayDate(aProxyBillEntryInfo.getPayableAmtDate());
                    adestBillPlanInfo.setRecievePayAmount(aProxyBillEntryInfo.getPayableAmt());
                    adestBillPlanInfo.setRecievePayAmountLocal(aProxyBillEntryInfo.getPayableAmtLocal());
                    destBillInfo.getPayPlan().add(adestBillPlanInfo);
                }
            }
            destBillInfo.verifyPlan();
            destBillInfo.setTotalAmount(totalAmount);
            destBillInfo.setTotalTax(totalTax);
            destBillInfo.setAmount(totalPayAmount);
            destBillInfo.setUnVerifyAmount(unVeriAmount);
            destBillInfo.setUnVerifyAmountLocal(unVeriAmountLocal);
            destBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
            destBillInfo.setReqCalculate4Srv(true);
            destBillInfo.setAmountLocal(this.ZERO);
            ArApBillHelper.calculate(ctx, destBillInfo, null);
            destBillInfo.setExtendedProperty("ignoreWorkflow", "True");
            iBTPManager.submitRelations((CoreBillBaseInfo)destBillInfo, btpResult.getBOTRelationCollection());
            String sql = "update t_ap_otherBill set fbillstatus=?,fauditdate=?,fauditorid=? where fid=? ";
            UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
            Object[] params = new Object[]{new Integer(3), new java.sql.Date(System.currentTimeMillis()), currentUser.getId().toString(), destBillInfo.getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        destBillBosType = ArApConstants.AR_OBILL_TYPE.toString();
        billCollection.add((CoreBillBaseInfo)info);
        BOTMappingInfo btpMappingInfo = ArApBillHelper.getBotpMappingInfo(ctx, ArApConstants.PROXYBILL_TYPE, ArApConstants.AR_OBILL_TYPE, cu.getId().toString());
        if (btpMappingInfo == null) {
            throw new OtherBillBizException(OtherBillBizException.CANNOTGETARAPBOTP);
        }
        btpResult = iBTPManager.transform(billCollection, destBillBosType, (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId()));
        destBillCols = btpResult.getBills();
        int count2 = destBillCols.size();
        for (int i = 0; i < count2; ++i) {
            int j;
            totalAmount = this.ZERO;
            totalTax = this.ZERO;
            OtherBillInfo destBillInfo = (OtherBillInfo)btpResult.getBills().getObject(i);
            destBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            destBillInfo.setBillDate(info.getBillDate());
            destBillInfo.setBizDate(info.getBizDate());
            destBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            destBillInfo.setSourceBillType(VerificateBillTypeEnum.ArAgentBizBill);
            if (isAllMaterial) {
                destBillInfo.setBillType(OtherBillTypeEnum.InvoiceBill);
            } else {
                destBillInfo.setBillType(OtherBillTypeEnum.ExpenseInvoice);
            }
            destBillInfo.setIsInitializeBill(info.isIsInitializeBill());
            OtherBillentryCollection entrys = destBillInfo.getEntry();
            for (j = 0; j < entrys.size(); ++j) {
                if (entrys.get(j).getAmount() != null) {
                    totalAmount = totalAmount.add(entrys.get(j).getAmount());
                }
                if (entrys.get(j).getTaxAmount() != null) {
                    totalTax = totalTax.add(entrys.get(j).getTaxAmount());
                }
                entrys.get(j).setVerifyAmount(entrys.get(j).getRecievePayAmount().subtract(entrys.get(j).getUnVerifyAmount()));
                entrys.get(j).setLockVerifyAmt(entrys.get(j).getRecievePayAmount().subtract(entrys.get(j).getLockUnVerifyAmt()));
                if (asst instanceof CustomerInfo) {
                    entrys.get(j).setOrderCustomer((CustomerInfo)asst);
                    entrys.get(j).setServiceCustomer((CustomerInfo)asst);
                    continue;
                }
                entrys.get(j).setOrderCustomer(null);
                entrys.get(j).setServiceCustomer(null);
            }
            destBillInfo.setTotalAmount(totalAmount);
            destBillInfo.setTotalTax(totalTax);
            int entryCount = info.getReceivePlan().size();
            for (j = 0; j < entryCount; ++j) {
                OtherBillPlanInfo adestBillPlanInfo = new OtherBillPlanInfo();
                ProxyBillReceivePlanInfo aProxyReceivePlanInfo = info.getReceivePlan().get(j);
                adestBillPlanInfo.setRecievePayDate(aProxyReceivePlanInfo.getReceivableDate());
                adestBillPlanInfo.setVerifyAmount(aProxyReceivePlanInfo.getVerifyAmount());
                adestBillPlanInfo.setVerifyAmountLocal(aProxyReceivePlanInfo.getVerifyAmountLoc());
                adestBillPlanInfo.setRecievePayAmount(aProxyReceivePlanInfo.getReceivableAmt());
                adestBillPlanInfo.setRecievePayAmountLocal(aProxyReceivePlanInfo.getReceivableAmtLo());
                destBillInfo.getRecievePlan().add(adestBillPlanInfo);
            }
            destBillInfo.verifyPlan();
            destBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
            destBillInfo.setReqCalculate4Srv(true);
            destBillInfo.setAmountLocal(this.ZERO);
            ArApBillHelper.calculate(ctx, destBillInfo, null);
            destBillInfo.setExtendedProperty("ignoreWorkflow", "True");
            iBTPManager.submitRelations((CoreBillBaseInfo)destBillInfo, btpResult.getBOTRelationCollection());
            String sql = "update t_ar_otherBill set fbillstatus=?,fauditdate=?,fauditorid=? where fid=? ";
            UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
            Object[] params = new Object[]{new Integer(3), new java.sql.Date(System.currentTimeMillis()), currentUser.getId().toString(), destBillInfo.getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    protected IObjectValue getBizObject(Context ctx, String id) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IObjectValue objVal = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk, sic);
        return objVal;
    }

    @Override
    protected void _createArAp(Context ctx, IObjectPK Id) throws BOSException {
        try {
            this.makeOtherARBill(ctx, this.getProxyBillInfo(ctx, Id));
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    protected boolean isZeroSomeFieldByPk(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ArrayList destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(pk.toString(), apotherBillBosType.toString());
        Object[] idObj = destObjIdList.toArray();
        StringBuffer billids = new StringBuffer();
        int size = idObj.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                billids.append(",");
            }
            billids.append("'" + idObj[i].toString() + "'");
        }
        boolean isTrue = com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(ctx).exists("where head in(" + billids.toString() + ") and ( lockVerifyAmt<>0 )");
        if (!isTrue) {
            destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(pk.toString(), arotherBillBosType.toString());
            idObj = destObjIdList.toArray();
            billids = new StringBuffer();
            int size2 = idObj.length;
            for (int i = 0; i < size2; ++i) {
                if (i > 0) {
                    billids.append(",");
                }
                billids.append("'" + idObj[i].toString() + "'");
            }
            isTrue = OtherBillentryFactory.getLocalInstance(ctx).exists("where head in(" + billids.toString() + ") and ( lockVerifyAmt<>0 )");
        }
        return isTrue;
    }

    protected boolean isExistsTraceDownByPk(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ArrayList destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(pk.toString(), apotherBillBosType.toString());
        String strIdLists = StringUtils.arrayToString((Object[])destObjIdList.toArray(), (String)",");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)apotherBillBosType.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)strIdLists, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        BOTRelationCollection botRelaCol = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        boolean isTrue = false;
        if (botRelaCol != null && !botRelaCol.isEmpty()) {
            isTrue = true;
        }
        if (!isTrue) {
            destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(pk.toString(), arotherBillBosType.toString());
            strIdLists = StringUtils.arrayToString((Object[])destObjIdList.toArray(), (String)",");
            view = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)arotherBillBosType.toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)strIdLists, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            botRelaCol = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
            if (botRelaCol != null && !botRelaCol.isEmpty()) {
                isTrue = true;
            }
        }
        return isTrue;
    }

    protected void removeOtherARBill(Context ctx, ProxyBillInfo proxyBillInfo) throws EASBizException, BOSException {
        ArrayList destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(proxyBillInfo.getId().toString(), apotherBillBosType.toString());
        Object[] idObj = destObjIdList.toArray();
        com.kingdee.eas.fi.ap.IOtherBill apotherbill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        int size = idObj.length;
        for (int i = 0; i < size; ++i) {
            apotherbill.delete("where id ='" + idObj[i].toString() + "'");
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(idObj[i].toString(), apotherBillBosType.toString());
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(proxyBillInfo.getId().toString(), apotherBillBosType.toString());
        }
        destObjIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(proxyBillInfo.getId().toString(), arotherBillBosType.toString());
        idObj = destObjIdList.toArray();
        IOtherBill arotherbill = OtherBillFactory.getLocalInstance(ctx);
        int size2 = idObj.length;
        for (int i = 0; i < size2; ++i) {
            arotherbill.delete("where id ='" + idObj[i].toString() + "'");
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationByDestObjId(idObj[i].toString(), arotherBillBosType.toString());
            BOTRelationFactory.getLocalInstance((Context)ctx).removeRelationBySrcObjId(proxyBillInfo.getId().toString(), arotherBillBosType.toString());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(proxyBillInfo.getCompanyOrgUnit(), proxyBillInfo.getBillDate());
        this.checkIsInQueue(ctx, proxyBillInfo);
        boolean isAddNew = true;
        if (proxyBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(proxyBillInfo.getId()))) {
            isAddNew = false;
        }
        if (proxyBillInfo.getCU() == null) {
            proxyBillInfo.setCU(super.getCU(ctx, (ObjectBaseInfo)proxyBillInfo));
        }
        this.checkValid(ctx, proxyBillInfo);
        this.checkNumber(ctx, isAddNew, proxyBillInfo);
        super._checkNumberDup(ctx, null, (IObjectValue)proxyBillInfo);
        proxyBillInfo.setBillStatus(BillStatusEnum.SUBMITED);
        if (proxyBillInfo.get("asstTypeInfoNew") != null) {
            proxyBillInfo.setRecAsstActType((AsstActTypeInfo)proxyBillInfo.get("asstTypeInfoNew"));
        }
        if (proxyBillInfo.get("asstActInfoNew") != null) {
            IObjectValue ov = (IObjectValue)proxyBillInfo.get("asstActInfoNew");
            proxyBillInfo.setRecAsstActId(ov.getString("id"));
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L1), LocaleUtils.locale_L1);
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L2), LocaleUtils.locale_L2);
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L3), LocaleUtils.locale_L3);
            proxyBillInfo.setRecAsstActNum(ov.getString("number"));
        }
        this.checkAsstActValid(ctx, proxyBillInfo);
        IObjectPK pk = super._submit(ctx, (IObjectValue)proxyBillInfo);
        if (!this._isInitBill(ctx, pk.toString()) && ArApParamHelper.isProxyBillAuditNow(ctx, proxyBillInfo.getCompanyOrgUnit().getId().toString())) {
            this.passAudit(ctx, pk, proxyBillInfo);
        }
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)("update T_ARP_ProxyBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + pk.toString() + "'"));
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private void checkIsInQueue(Context ctx, ProxyBillInfo proxyBillInfo) throws BOSException, EASBizException {
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        String companyNumber = null;
        if (proxyBillInfo.getCompanyOrgUnit() != null && proxyBillInfo.getCompanyOrgUnit().getNumber() != null) {
            companyNumber = proxyBillInfo.getCompanyOrgUnit().getNumber();
        } else {
            CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select number where id = '" + proxyBillInfo.getCompanyOrgUnit().getId().toString() + "'");
            companyNumber = currentCompany.getNumber();
        }
        if (companyNumber != null) {
            if (createJobFacade.checkDuplicateTask("SCM_FI_AR_001" + companyNumber)) {
                throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
            }
            if (createJobFacade.checkDuplicateTask("SCM_FI_AP_001" + companyNumber)) {
                throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)model;
        ArShutAccountFactory.getLocalInstance(ctx).checkBeforeAddBill(proxyBillInfo.getCompanyOrgUnit(), proxyBillInfo.getBillDate());
        this.checkIsInQueue(ctx, proxyBillInfo);
        boolean isAddNew = true;
        if (proxyBillInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(proxyBillInfo.getId()))) {
            isAddNew = false;
        }
        if (!isAddNew) {
            pk = new ObjectUuidPK(proxyBillInfo.getId());
            ProxyBillInfo oldBillInfo = this.getProxyBillInfo(ctx, (IObjectPK)pk);
            if (oldBillInfo.getBillStatus().getValue() >= 2) {
                throw new ProxyBillBizException(ProxyBillBizException.SUBMMITED_CANNNOTSAVE);
            }
            proxyBillInfo.setCU(oldBillInfo.getCU());
        }
        if (proxyBillInfo.getRecExchangeRate() == null) {
            throw new OtherBillBizException(OtherBillBizException.EXCHANGERATE_NOTNULL);
        }
        this.checkNumber(ctx, isAddNew, proxyBillInfo);
        proxyBillInfo.setBillStatus(BillStatusEnum.SAVE);
        if (proxyBillInfo.get("asstTypeInfoNew") != null) {
            proxyBillInfo.setRecAsstActType((AsstActTypeInfo)proxyBillInfo.get("asstTypeInfoNew"));
        }
        if (proxyBillInfo.get("asstActInfoNew") != null) {
            IObjectValue ov = (IObjectValue)proxyBillInfo.get("asstActInfoNew");
            proxyBillInfo.setRecAsstActId(ov.getString("id"));
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L1), LocaleUtils.locale_L1);
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L2), LocaleUtils.locale_L2);
            proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L3), LocaleUtils.locale_L3);
            proxyBillInfo.setRecAsstActNum(ov.getString("number"));
        }
        super._checkNumberDup(ctx, null, (IObjectValue)proxyBillInfo);
        pk = super._save(ctx, (IObjectValue)proxyBillInfo);
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)("update T_ARP_ProxyBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + pk.toString() + "'"));
        }
        return pk;
    }

    public static BigDecimal getQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty, Context ctx) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        if (unitInfo == null || otherUnitInfo == null) {
            return SysConstant.BIGZERO;
        }
        BigDecimal targetQty = qty = qty == null ? SysConstant.BIGZERO : qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null) {
                scale = othermultiUnifInfo.getQtyPrecision();
            } else {
                baseQty = SysConstant.BIGZERO;
            }
            targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
        }
        return targetQty;
    }

    private void checkNumber(Context ctx, boolean isAddNew, ProxyBillInfo proxyBillInfo) throws BOSException, EASBizException {
        if (isAddNew && this.isRuleAutoNumber(ctx, proxyBillInfo, null)) {
            ObjectUuidPK pk = new ObjectUuidPK(proxyBillInfo.getId());
            if (!StringUtils.isEmpty((String)proxyBillInfo.getNumber())) {
                if (this.isSameNumberNoCU(ctx, (IObjectPK)pk, (IObjectValue)proxyBillInfo)) {
                    this.getNewNumber(ctx, (IObjectValue)proxyBillInfo, proxyBillInfo.getCompanyOrgUnit().getId().toString(), null);
                }
            } else {
                this.getNewNumber(ctx, (IObjectValue)proxyBillInfo, proxyBillInfo.getCompanyOrgUnit().getId().toString(), null);
            }
        } else if (!isAddNew && StringUtils.isEmpty((String)proxyBillInfo.getNumber())) {
            throw new ProxyBillBizException(ProxyBillBizException.NUMBER_NOTSET);
        }
    }

    public boolean isAutoNum() {
        return true;
    }

    protected boolean isRuleAutoNumber(Context ctx, ProxyBillInfo proxyBillInfo, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager;
        if (StringUtils.isEmpty((String)strCompanyID)) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        return (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)proxyBillInfo, strCompanyID);
    }

    protected IObjectValue getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        String number = "";
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)model;
        number = iCodingRuleManager.getNumber((IObjectValue)proxyBillInfo, strCompanyID, customString);
        proxyBillInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(proxyBillInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)proxyBillInfo)) {
            return this.getNewNumber(ctx, (IObjectValue)proxyBillInfo, strCompanyID, customString);
        }
        return proxyBillInfo;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)proxyBillInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (proxyBillInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)proxyBillInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (proxyBillInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)proxyBillInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return super._exists(ctx, filter);
    }

    protected boolean isSameNumberNoCU(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)proxyBillInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IProxyBill iProxyBill = ProxyBillFactory.getLocalInstance(ctx);
        ProxyBillCollection collection = iProxyBill.getProxyBillCollection(view);
        return collection != null && collection.size() > 0;
    }

    private void checkValid(Context ctx, ProxyBillInfo proxyBillInfo) throws BOSException, EASBizException {
        if (proxyBillInfo == null) {
            return;
        }
        if (proxyBillInfo.getNumber() == null || proxyBillInfo.getNumber().length() == 0) {
            throw new ProxyBillBizException(ProxyBillBizException.NUMBER_NOSET);
        }
        if (proxyBillInfo.getCompanyOrgUnit() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.COMPANY_NOTSET);
        }
        if (proxyBillInfo.getBillDate() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.BILLDATE_NOTSET);
        }
        if (proxyBillInfo.getRecAsstActType() == null) {
            if (proxyBillInfo.get("asstTypeInfoNew") != null) {
                proxyBillInfo.setRecAsstActType((AsstActTypeInfo)proxyBillInfo.get("asstTypeInfoNew"));
            } else {
                throw new ProxyBillBizException(ProxyBillBizException.ASSTACTTYPE_NOTSET);
            }
        }
        if (proxyBillInfo.getRecAsstActId() == null || proxyBillInfo.getRecAsstActId().length() == 0) {
            if (proxyBillInfo.get("asstActInfoNew") != null) {
                IObjectValue ov = (IObjectValue)proxyBillInfo.get("asstActInfoNew");
                proxyBillInfo.setRecAsstActId(ov.getString("id"));
                proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L1), LocaleUtils.locale_L1);
                proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L2), LocaleUtils.locale_L2);
                proxyBillInfo.setRecAsstActName((String)ov.get("name", LocaleUtils.locale_L3), LocaleUtils.locale_L3);
                proxyBillInfo.setRecAsstActNum(ov.getString("number"));
            } else {
                throw new ProxyBillBizException(ProxyBillBizException.ACCTCUSSENT_NOTSET);
            }
        }
        if (proxyBillInfo.getRecCurrency() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.CURRENCY_NOTSET);
        }
        if (proxyBillInfo.getRecExchangeRate() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.EXCHANGERATE_NOTSET);
        }
        if (proxyBillInfo.getEntry() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_NOTEXIST);
        }
        if (proxyBillInfo.getReceivePlan() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_NOTEXIST);
        }
        this.checkEntryValid(proxyBillInfo);
        this.checkPlanValid(proxyBillInfo);
        if (proxyBillInfo.getRecAmount() == null) {
            throw new ProxyBillBizException(ProxyBillBizException.RECAMT_NOTSET);
        }
        if (proxyBillInfo.isIsImportBill()) {
            boolean isContrast;
            IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
            ProxyBillEntryInfo proxyEInfo = null;
            HashSet<String> arAccountSet = new HashSet<String>();
            HashSet<String> apAccountSet = new HashSet<String>();
            int size = proxyBillInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                proxyEInfo = proxyBillInfo.getEntry().get(i);
                if (proxyEInfo.getRecAccount() != null) {
                    arAccountSet.add(proxyEInfo.getRecAccount().getId().toString());
                }
                if (proxyEInfo.getPayAccount() == null) continue;
                apAccountSet.add(proxyEInfo.getPayAccount().getId().toString());
            }
            if (arAccountSet.size() > 0) {
                isContrast = true;
                Iterator iterator = arAccountSet.iterator();
                while (iterator.hasNext()) {
                    isContrast = iContrastAcct.isContrastAccount(proxyBillInfo.getCU().getId().toString(), proxyBillInfo.getCompanyOrgUnit().getId().toString(), iterator.next().toString(), AccountControlAttribute.AR);
                    if (isContrast) continue;
                    throw new OtherBillBizException(OtherBillBizException.ACCOUNT_NOT_CONTRAST);
                }
            }
            if (apAccountSet.size() > 0) {
                isContrast = true;
                Iterator iterator = apAccountSet.iterator();
                while (iterator.hasNext()) {
                    isContrast = iContrastAcct.isContrastAccount(proxyBillInfo.getCU().getId().toString(), proxyBillInfo.getCompanyOrgUnit().getId().toString(), iterator.next().toString(), AccountControlAttribute.AP);
                    if (isContrast) continue;
                    throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.ACCOUNT_NOT_CONTRAST);
                }
            }
        }
    }

    private void checkEntryValid(ProxyBillInfo billInfo) throws ProxyBillBizException, OtherBillBizException {
        ProxyBillEntryCollection entryCol = billInfo.getEntry();
        ProxyBillEntryInfo entryInfo = null;
        int num = entryCol.size();
        if (num == 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_NOTEXIST);
        }
        BigDecimal totalAmount = this.ZERO;
        BigDecimal totalAmountLocal = this.ZERO;
        BigDecimal totalVerifyAmount = this.ZERO;
        BigDecimal totalVerifyAmountLocal = this.ZERO;
        BigDecimal totalUnVerifyAmount = this.ZERO;
        BigDecimal totalUnVerifyAmountLocal = this.ZERO;
        BigDecimal totalBadAmount = this.ZERO;
        BigDecimal totalBadAmountLocal = this.ZERO;
        BigDecimal recAmount = this.ZERO;
        BigDecimal recAmountLocal = this.ZERO;
        BigDecimal payAmount = this.ZERO;
        BigDecimal payAmountLocal = this.ZERO;
        BigDecimal verifyAmount = this.ZERO;
        BigDecimal verifyAmountLocal = this.ZERO;
        BigDecimal unVerifyAmount = this.ZERO;
        BigDecimal unVerifyAmountLocal = this.ZERO;
        BigDecimal badAmount = this.ZERO;
        BigDecimal badAmountLocal = this.ZERO;
        BigDecimal payVerifyAmount = this.ZERO;
        BigDecimal payVerifyAmountLocal = this.ZERO;
        BigDecimal payUnVerifyAmount = this.ZERO;
        BigDecimal payUnVerifyAmountLocal = this.ZERO;
        boolean isAllMaterial = false;
        boolean isAllExpenseItem = false;
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCol.get(i);
            recAmount = entryInfo.getReceivableAmt();
            recAmountLocal = entryInfo.getReceivableAmtLo();
            verifyAmount = entryInfo.getRecVerifyAmt();
            verifyAmountLocal = entryInfo.getRecVerifyAmtLoc();
            unVerifyAmount = entryInfo.getRecUnVerifyAmt();
            unVerifyAmountLocal = entryInfo.getRecUnVerifyAmtL();
            badAmount = entryInfo.getRecBadAmount();
            badAmountLocal = entryInfo.getRecBadAmountLoc();
            payAmount = entryInfo.getPayableAmt();
            payAmountLocal = entryInfo.getPayableAmtLocal();
            payVerifyAmount = entryInfo.getPayVerifyAmt();
            payVerifyAmountLocal = entryInfo.getPayVerifyAmtLoc();
            payUnVerifyAmount = entryInfo.getPayUnVerifyAmt();
            payUnVerifyAmountLocal = entryInfo.getPayUnVerifyAmtL();
            if (entryInfo.getMaterial() != null) {
                isAllMaterial = true;
            }
            if (entryInfo.getExpenseItem() != null) {
                isAllExpenseItem = true;
            }
            if (entryInfo.getMaterial() == null && entryInfo.getExpenseItem() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.MATERIAL_NOSET);
            }
            if (entryInfo.getMaterial() != null && entryInfo.getUnit() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.MEATUREUNIT_NOSET);
            }
            if (recAmount == null) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_RECAMT_NOTSET);
            }
            totalAmount = totalAmount.add(recAmount);
            if (recAmountLocal == null) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_RECAMTLOC_NOTSET);
            }
            totalAmountLocal = totalAmountLocal.add(recAmountLocal);
            verifyAmount = verifyAmount == null ? this.ZERO : verifyAmount;
            totalVerifyAmount = totalVerifyAmount.add(verifyAmount);
            verifyAmountLocal = verifyAmountLocal == null ? this.ZERO : verifyAmountLocal;
            totalVerifyAmountLocal = totalVerifyAmountLocal.add(verifyAmountLocal);
            unVerifyAmount = unVerifyAmount == null ? this.ZERO : unVerifyAmount;
            totalUnVerifyAmount = totalUnVerifyAmount.add(unVerifyAmount);
            unVerifyAmountLocal = unVerifyAmountLocal == null ? this.ZERO : unVerifyAmountLocal;
            totalUnVerifyAmountLocal = totalUnVerifyAmountLocal.add(unVerifyAmountLocal);
            badAmount = badAmount == null ? this.ZERO : badAmount;
            totalBadAmount = totalBadAmount.add(badAmount);
            badAmountLocal = badAmountLocal == null ? this.ZERO : badAmountLocal;
            totalBadAmountLocal = totalBadAmountLocal.add(badAmountLocal);
            if (verifyAmount.add(unVerifyAmount).compareTo(recAmount) != 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_AMT_ERROR);
            }
            if (verifyAmountLocal.add(unVerifyAmountLocal).compareTo(recAmountLocal) != 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_AMT_ERROR);
            }
            if (badAmount.compareTo(verifyAmount) > 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_REC_BADAMT_ERROR);
            }
            if (badAmountLocal.compareTo(verifyAmountLocal) > 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_REC_BADAMT_ERROR);
            }
            if (entryInfo.getPayAsstActType() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAY_ASSTACTTYPE_NOTSET);
            }
            if (entryInfo.getPayAsstActId() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAY_ASSTACTID_NOTSET);
            }
            if (entryInfo.getPayCurrency() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAY_CURRENCY_NOTSET);
            }
            if (entryInfo.getPayExchangeRate() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAY_EXCHANGERATE_NOTSET);
            }
            if (payAmount == null) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_PAYAMT_NOTSET);
            }
            if (payAmountLocal == null) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_PAYAMTLOC_NOTSET);
            }
            if (entryInfo.getPayAmount() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAYAMT_NOTSET);
            }
            if (entryInfo.getPayAmountLocal() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAYAMTLOC_NOTSET);
            }
            payVerifyAmount = payVerifyAmount == null ? this.ZERO : payVerifyAmount;
            payVerifyAmountLocal = payVerifyAmountLocal == null ? this.ZERO : payVerifyAmountLocal;
            payUnVerifyAmount = payUnVerifyAmount == null ? this.ZERO : payUnVerifyAmount;
            BigDecimal bigDecimal = payUnVerifyAmountLocal = payUnVerifyAmountLocal == null ? this.ZERO : payUnVerifyAmountLocal;
            if (payVerifyAmount.add(payUnVerifyAmount).compareTo(payAmount) != 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_PAY_AMT_ERROR);
            }
            if (payVerifyAmountLocal.add(payUnVerifyAmountLocal).compareTo(payAmountLocal) != 0) {
                throw new ProxyBillBizException(ProxyBillBizException.ENTRY_PAY_AMTLOC_ERROR);
            }
            if (entryInfo.getPayableAmtDate() == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PAYDATE_NOSET);
            }
            if (!billInfo.isIsInitializeBill()) continue;
            if (entryInfo.getRecAccount() == null) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{EASResource.getString((String)ARAP_RESOURCE, (String)"RecAccount_Is_Null")});
            }
            if (entryInfo.getPayAccount() != null) continue;
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{EASResource.getString((String)ARAP_RESOURCE, (String)"PayAccount_Is_Null")});
        }
        if (isAllMaterial && isAllExpenseItem) {
            throw new ProxyBillBizException(ProxyBillBizException.MATERIALANDEXPENSEITEMEXIST);
        }
        if (billInfo.getRecAmount().compareTo(totalAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRYAMOUNT_NOTEQUALSHEADAMOUNT);
        }
        if (billInfo.getRecVerifyAmt().compareTo(totalVerifyAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_VERAMT_NOTEQUALSHEADAMOUNT);
        }
        if (billInfo.getRecUnVerifyAmt().compareTo(totalUnVerifyAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_UNVERAMT_NOTEQUALSHEADAMOUNT);
        }
        if (billInfo.getRecBadAmount().compareTo(totalBadAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_BADAMT_NOTEQUALSHEADAMOUNT);
        }
        if (totalVerifyAmount.add(totalUnVerifyAmount).compareTo(billInfo.getRecAmount()) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.HEADAMOUNT_ERROR);
        }
        if (billInfo.getRecBadAmount().compareTo(billInfo.getRecVerifyAmt()) > 0) {
            throw new ProxyBillBizException(ProxyBillBizException.HEAD_BADAMT_ERROR);
        }
    }

    private void checkPlanValid(ProxyBillInfo billInfo) throws ProxyBillBizException, OtherBillBizException {
        ProxyBillReceivePlanCollection planCol = billInfo.getReceivePlan();
        ProxyBillReceivePlanInfo planInfo = null;
        int num = planCol.size();
        if (num == 0) {
            throw new ProxyBillBizException(ProxyBillBizException.ENTRY_NOTEXIST);
        }
        BigDecimal totalAmount = this.ZERO;
        BigDecimal amount = this.ZERO;
        BigDecimal totalVerifyAmount = this.ZERO;
        BigDecimal verifyAmount = this.ZERO;
        for (int i = 0; i < num; ++i) {
            planInfo = planCol.get(i);
            amount = planInfo.getReceivableAmt();
            verifyAmount = planInfo.getVerifyAmount();
            if (amount == null) {
                throw new ProxyBillBizException(ProxyBillBizException.PLAN_RECAMT_NOTSET);
            }
            totalAmount = totalAmount.add(amount);
            verifyAmount = verifyAmount == null ? this.ZERO : verifyAmount;
            totalVerifyAmount = totalVerifyAmount.add(verifyAmount);
        }
        if (billInfo.getRecAmount().compareTo(totalAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.PLANAMOUNT_NOTQUEALSHEADAMOUNT);
        }
        if (billInfo.getRecVerifyAmt().compareTo(totalVerifyAmount) != 0) {
            throw new ProxyBillBizException(ProxyBillBizException.PLANVERIFYAMT_NOTQUEALSHEADAMOUNT1);
        }
        if (num > 1) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            HashSet<String> dateSet = new HashSet<String>();
            for (int j = 0; j < num; ++j) {
                if (planCol.get(j).getReceivableDate() == null) continue;
                dateSet.add(sdf.format(planCol.get(j).getReceivableDate()));
            }
            if (dateSet.size() == 1) {
                throw new OtherBillBizException(OtherBillBizException.BILLDATECHECKERROR);
            }
        }
    }

    private boolean isInitBill(Context ctx, ProxyBillInfo proxyBillInfo) throws BOSException, EASBizException {
        Date billDate;
        PeriodInfo startPeriod;
        CompanyOrgUnitInfo company = proxyBillInfo.getCompanyOrgUnit();
        Date arStartDate = null;
        if (company != null && company.getId() != null && (startPeriod = ArServerUtils.getArStartPeriod(ctx, company)) != null) {
            arStartDate = startPeriod.getBeginDate();
        }
        return (billDate = proxyBillInfo.getBillDate()) != null && arStartDate != null && billDate.before(arStartDate);
    }

    @Override
    protected boolean _isInitBill(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        ProxyBillInfo proxyBillInfo = this.getProxyBillInfo(ctx, (IObjectPK)pk);
        return this.isInitBill(ctx, proxyBillInfo);
    }

    @Override
    protected int _getBillType(Context ctx, String billId) throws BOSException, EASBizException {
        Date billDate;
        PeriodInfo startPeriod;
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        ProxyBillInfo proxyBillInfo = this.getProxyBillInfo(ctx, (IObjectPK)pk);
        CompanyOrgUnitInfo company = proxyBillInfo.getCompanyOrgUnit();
        Date arStartDate = null;
        if (company != null && company.getId() != null && (startPeriod = ArServerUtils.getArStartPeriod(ctx, company)) != null) {
            arStartDate = startPeriod.getBeginDate();
        }
        if ((billDate = proxyBillInfo.getBillDate()) != null && arStartDate != null && billDate.before(arStartDate)) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        if (srcBillVO != null && srcBillVO instanceof ProxyBillInfo) {
            ProxyBillInfo bill = (ProxyBillInfo)srcBillVO;
            BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
            if (botRelation != null && !"2652E01E".equals(botRelation.getDestEntityID())) {
                super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
                return;
            }
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                bill.setFiVouchered(false);
                bill.setVoucherNumber(null);
                bill.setAccountant(null);
                bill.setVoucherType(null);
                bill.setVoucher(null);
                this.setArApOtherBillInfo(ctx, bill.getId().toString(), null, null, 0);
                bill.setIsNeedVoucher(this.getbooleanValue(1));
                DbUtil.execute((Context)ctx, (String)"DELETE FROM T_AR_ArApRelationEntry WHERE FDestObjectID = ?", (Object[])new Object[]{botRelation.getDestObjectID()});
            } else {
                String voucherId = botRelation.getDestObjectID();
                IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
                VoucherInfo voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectStringPK(voucherId));
                String voucherNumber = voucherInfo.getNumber();
                bill.setFiVouchered(true);
                bill.setVoucherNumber(voucherNumber);
                bill.setVoucherType(voucherInfo.getVoucherType());
                bill.setVoucher(voucherInfo);
                bill.setAccountant(CommonServerUtils.getCurrentUser(ctx).getPerson());
                this.setArApOtherBillInfo(ctx, bill.getId().toString(), voucherInfo, CommonServerUtils.getCurrentUser(ctx), 1);
                bill.setIsNeedVoucher(this.getbooleanValue(0));
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    Connection conn = null;
                    try {
                        conn = this.getConnection(ctx);
                        IORMappingDAO idao = ORMappingDAO.getInstance((BOSObjectType)ArApConstants.ARAPRELATIONENTRY_TYPE, (Context)ctx, (Connection)conn);
                        BOTRelationEntryInfo botRelationEntryInfo2 = null;
                        ArApRelationEntryInfo relEntryInfo = null;
                        int relSize = 0;
                        for (BOTRelationEntryInfo botRelationEntryInfo2 : botRelation.getRelationEntries()) {
                            relEntryInfo = new ArApRelationEntryInfo();
                            relEntryInfo.setSrcObjectID(botRelationEntryInfo2.getSrcObjectID());
                            relEntryInfo.setDestObjectID(botRelationEntryInfo2.getDestObjectID());
                            relEntryInfo.setSrcEntryID(botRelationEntryInfo2.getSrcEntryID());
                            relEntryInfo.setDestEntryID(botRelationEntryInfo2.getDestEntryID());
                            relEntryInfo.setDate(Calendar.getInstance().getTime());
                            idao.addNewBatch((IObjectValue)relEntryInfo);
                            if (++relSize <= 2000) continue;
                            idao.executeBatch();
                            relSize = 0;
                        }
                        if (relSize > 0) {
                            idao.executeBatch();
                        }
                    }
                    finally {
                        SQLUtils.cleanup((Connection)conn);
                    }
                }
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private boolean getbooleanValue(int origin) {
        return origin == 1;
    }

    private void setArApOtherBillInfo(Context ctx, String billId, VoucherInfo voucherInfo, UserInfo userInfo, int fIsVoucher) throws BOSException {
        StringBuffer strSql = new StringBuffer();
        StringBuffer valStr = new StringBuffer();
        String strAccountId = "";
        String fVoucherID = "";
        String voucherId = null;
        String voucherNumber = "";
        String voucherTypeId = "";
        if (voucherInfo != null && userInfo != null) {
            voucherId = voucherInfo.getId().toString();
            voucherNumber = voucherInfo.getNumber();
            voucherTypeId = voucherInfo.getVoucherType().getId().toString();
            strAccountId = userInfo.getId().toString();
            fVoucherID = voucherId;
            valStr.append(" FVoucherID = '").append(fVoucherID).append("', ");
            valStr.append(" FFiVouchered = ").append(fIsVoucher).append(", ");
            valStr.append(" FAccountantID = '").append(strAccountId).append("', ");
            valStr.append(" FVoucherNumber = '").append(voucherNumber).append("', ");
            valStr.append(" FVoucherTypeID = '").append(voucherTypeId).append("' ");
        } else {
            valStr.append(" FVoucherID = null,");
            valStr.append(" FFiVouchered = ").append(fIsVoucher).append(", ");
            valStr.append(" FAccountantID = null,");
            valStr.append(" FVoucherNumber = null,");
            valStr.append(" FVoucherTypeID = null ");
        }
        strSql.append("Update T_AR_OtherBill set ");
        strSql.append(valStr.toString());
        strSql.append(" Where Fid IN ");
        strSql.append(" ( ");
        strSql.append(" SELECT ArBill.Fid");
        strSql.append(" FROM T_AR_Otherbill AS ArBill");
        strSql.append(" LEFT OUTER JOIN T_AR_OtherBillEntry ArBillEntry ON ArBill.FId = ArBillEntry.FParentID");
        strSql.append(" LEFT OUTER JOIN T_ARP_ProxyBillEntry AS ProxyBillEntry ON ArBillEntry.FSourceBillEntryId = ProxyBillEntry.FID");
        strSql.append(" WHERE ");
        strSql.append(" ProxyBillEntry.FParentID = '").append(billId).append("') ");
        strSql.append("\n");
        DBUtil.execute((Context)ctx, (String)strSql.toString());
        strSql.setLength(0);
        strSql.append("Update T_AP_OtherBill set ");
        strSql.append(valStr.toString());
        strSql.append(" Where Fid IN ");
        strSql.append(" ( ");
        strSql.append(" SELECT ApBill.Fid");
        strSql.append(" FROM T_AP_Otherbill AS ApBill");
        strSql.append(" LEFT OUTER JOIN T_AP_OtherBillEntry ApBillEntry ON ApBill.FId = ApBillEntry.FParentID");
        strSql.append(" LEFT OUTER JOIN T_ARP_ProxyBillEntry AS ProxyBillEntry ON ApBillEntry.FSourceBillEntryId = ProxyBillEntry.FID");
        strSql.append(" WHERE ");
        strSql.append(" ProxyBillEntry.FParentID = '").append(billId).append("' )");
        DBUtil.execute((Context)ctx, (String)strSql.toString());
    }

    @Override
    protected void _auditInitBill(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected ProxyBillInfo _createNewData(Context ctx, boolean isInitBill) throws BOSException, EASBizException {
        ProxyBillAgent objectValue = ProxyBillAgent.create();
        objectValue.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Date now = new Date();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        objectValue.setCreateTime(new Timestamp(now.getTime()));
        objectValue.setCompanyOrgUnit(company);
        objectValue.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        objectValue.setRecExchangeRate(new BigDecimal("1"));
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        String companyId = company.getId().toString();
        PeriodInfo startPeriod = ictrol.getStartPeriod(12, companyId);
        PeriodInfo currentPeriod = ictrol.getCacheCurrentPeriod(12, companyId);
        if (isInitBill) {
            now = ArApBillHelper.getBeforeSysDate(startPeriod);
        } else if (now.before(currentPeriod.getBeginDate())) {
            now = currentPeriod.getBeginDate();
        }
        objectValue.setBillDate(DateTimeUtils.truncateDate((Date)now));
        objectValue.setBizDate(DateTimeUtils.truncateDate((Date)now));
        if (objectValue.getReceivePlan() != null) {
            Date now1 = new Date();
            if (isInitBill) {
                now1 = ArApBillHelper.getBeforeSysDate(startPeriod);
            } else if (now1.before(currentPeriod.getBeginDate())) {
                now1 = currentPeriod.getBeginDate();
            }
            ProxyBillReceivePlanAgent planInfo = null;
            planInfo = ProxyBillReceivePlanAgent.create();
            planInfo.setReceivableDate(DateTimeUtils.truncateDate((Date)now));
            objectValue.getReceivePlan().add(planInfo);
        }
        if (objectValue.getEntry() != null) {
            ProxyBillEntryAgent entryInfo = null;
            entryInfo = ProxyBillEntryAgent.create();
            entryInfo.setPayExchangeRate(null);
            entryInfo.setPayableAmtDate(DateTimeUtils.truncateDate((Date)new Date()));
            objectValue.getEntry().add(entryInfo);
        }
        return objectValue;
    }

    @Override
    protected void _editVouch(Context ctx, String billId) throws BOSException, EASBizException {
    }

    @Override
    protected int _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        int success = 0;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        ProxyBillCollection ProxyBillCol = this.getProxyBillCollection(ctx, entityView);
        ProxyBillInfo proxyinfo = null;
        int n = ProxyBillCol.size();
        for (int i = 0; i < n; ++i) {
            proxyinfo = ProxyBillCol.get(i);
            if (proxyinfo != null && BillStatusEnum.AUDITED.equals((Object)proxyinfo.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.BILLSTATUS_NOTSAVED);
            }
            this.submit(ctx, (CoreBaseInfo)proxyinfo);
            ++success;
        }
        return success;
    }

    private void checkAsstActValid(Context ctx, ProxyBillInfo proxyBillInfo) throws EASBizException, BOSException {
        if (!this.isExistAsstActByCompany(ctx, proxyBillInfo.getCompanyOrgUnit(), proxyBillInfo.getRecAsstActType(), proxyBillInfo.getRecAsstActId())) {
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTBELONGCOMORG);
        }
        ProxyBillEntryCollection entryCol = proxyBillInfo.getEntry();
        ProxyBillEntryInfo entryInfo = null;
        int num = entryCol.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCol.get(i);
            if (this.isExistAsstActByCompany(ctx, proxyBillInfo.getCompanyOrgUnit(), entryInfo.getPayAsstActType(), entryInfo.getPayAsstActId())) continue;
            throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTBELONGCOMORG);
        }
    }

    protected boolean isExistAsstActByCompany(Context ctx, CompanyOrgUnitInfo comOrgInfo, AsstActTypeInfo assactTypeInfo, String asstActId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        String relationDataObject = assactTypeInfo.getRealtionDataObject();
        if (relationDataObject == null) {
            assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()));
            relationDataObject = assactTypeInfo.getRealtionDataObject();
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean isexists = false;
        if (fCust) {
            sql.append(" SELECT CUSTOMER.FID FROM T_BD_Customer AS CUSTOMER ");
            sql.append(" INNER JOIN T_BD_CustomerCompanyInfo AS CUSTOMERCOMPANYINFO ");
            sql.append(" ON CUSTOMER.FID = CUSTOMERCOMPANYINFO.FCustomerID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON CUSTOMERCOMPANYINFO.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and CUSTOMER.fid= ? ");
        } else if (fSupp) {
            sql.append(" SELECT SUPPLIER.FID FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" INNER JOIN T_BD_SupplierCompanyInfo AS SUPPLIERCOMPANY ");
            sql.append(" ON SUPPLIER.FID = SUPPLIERCOMPANY.FSupplierID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON SUPPLIERCOMPANY.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and SUPPLIER.fid= ? ");
        } else {
            return true;
        }
        Object[] param = new Object[]{comOrgInfo.getId().toString(), asstActId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rowSet.size() > 0) {
            isexists = true;
        } else {
            logger.info((Object)("CompanyID: " + comOrgInfo.getId().toString() + " AsstActID: " + asstActId));
        }
        return isexists;
    }

    @Override
    protected void _appointmentAccount(Context ctx, IObjectPK[] billId, ArrayList entryIdSet, AccountViewInfo arAccountViewInfo, AccountViewInfo arOppAccountInfo, AccountViewInfo apAccountViewInfo, AccountViewInfo apOppAccountInfo) throws BOSException, EASBizException {
        HashMap<String, PeriodInfo> arCurrentPeriodMap = new HashMap<String, PeriodInfo>();
        HashMap<String, PeriodInfo> apCurrentPeriodMap = new HashMap<String, PeriodInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("BillDate");
        sic.add("BillStatus");
        sic.add("CompanyOrgUnit.*");
        sic.add("Entry.payAccount");
        sic.add("Entry.payOppAccount");
        sic.add("Entry.recAccount");
        sic.add("Entry.recOppAccount");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<IObjectPK>(Arrays.asList(billId)), CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.setSelector(sic);
        ProxyBillCollection ProxyBillCol = this.getProxyBillCollection(ctx, entityView);
        ProxyBillInfo proxyInfo = null;
        PeriodInfo currentPeriod = null;
        PeriodInfo apCurrentPeriod = null;
        int n = ProxyBillCol.size();
        for (int i = 0; i < n; ++i) {
            proxyInfo = ProxyBillCol.get(i);
            String companyID = proxyInfo.getCompanyOrgUnit().getId().toString();
            currentPeriod = (PeriodInfo)arCurrentPeriodMap.get(companyID);
            apCurrentPeriod = (PeriodInfo)apCurrentPeriodMap.get(companyID);
            if (currentPeriod == null) {
                currentPeriod = ArServerUtils.getArCurrentPeriod(ctx, proxyInfo.getCompanyOrgUnit());
                arCurrentPeriodMap.put(companyID, currentPeriod);
            }
            if (apCurrentPeriod == null) {
                apCurrentPeriod = ApServerUtils.getApCurrentPeriod(ctx, proxyInfo.getCompanyOrgUnit());
                apCurrentPeriodMap.put(companyID, apCurrentPeriod);
            }
            if (proxyInfo.getBillDate().before(currentPeriod.getBeginDate())) {
                throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_INITBILL_NOT);
            }
            if (!BillStatusEnum.AUDITED.equals((Object)proxyInfo.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.POINT_SUBJECT_UNAUDIT_NOT);
            }
            for (int j = 0; j < proxyInfo.getEntry().size(); ++j) {
                ProxyBillEntryInfo entryInfo = proxyInfo.getEntry().get(i);
                if (entryIdSet.contains(entryInfo.getId().toString())) {
                    if (arAccountViewInfo != null) {
                        entryInfo.setRecAccount(arAccountViewInfo);
                    }
                    if (arOppAccountInfo != null) {
                        entryInfo.setRecOppAccount(arOppAccountInfo);
                    }
                    if (apAccountViewInfo != null) {
                        entryInfo.setPayAccount(apAccountViewInfo);
                    }
                    if (apOppAccountInfo != null) {
                        entryInfo.setPayOppAccount(apOppAccountInfo);
                    }
                    entryIdSet.remove(entryInfo.getId().toString());
                }
                this.updateArApAccountInfo(ctx, entryInfo, arCurrentPeriodMap, apCurrentPeriodMap);
            }
            this.updatePartial(ctx, (CoreBaseInfo)proxyInfo, sic);
        }
    }

    protected void updateArApAccountInfo(Context ctx, ProxyBillEntryInfo proxyBillEntry, Map arCurrentPeriodMap, Map apCurrentPeriodMap) throws EASBizException, BOSException {
        PeriodInfo currentPeriod;
        ArApBillEntryBaseInfo entryInfo;
        int i;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        IOtherBillentry IArBill = OtherBillentryFactory.getLocalInstance(ctx);
        com.kingdee.eas.fi.ap.IOtherBillentry IApBill = com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(ctx);
        sic.add("account");
        sic.add("oppAccount");
        sic.add("verifyAmount");
        sic.add("head.billDate");
        sic.add("head.company");
        filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", (Object)proxyBillEntry.getId(), CompareType.EQUALS));
        ev.setSelector(sic);
        ev.setFilter(filter);
        OtherBillentryCollection arEntryCol = IArBill.getOtherBillentryCollection(ev);
        com.kingdee.eas.fi.ap.OtherBillentryCollection apEntryCol = IApBill.getOtherBillentryCollection(ev);
        for (i = 0; i < arEntryCol.size(); ++i) {
            entryInfo = arEntryCol.get(i);
            currentPeriod = (PeriodInfo)arCurrentPeriodMap.get(entryInfo.getParent().getCompany().getId().toString());
            entryInfo.setAccount(proxyBillEntry.getRecAccount());
            entryInfo.setOppAccount(proxyBillEntry.getRecOppAccount());
            if (entryInfo.getVerifyAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            ArApServerUtils.appointmentAccount4Verify(ctx, entryInfo.getId().toString(), entryInfo.getAccount(), entryInfo.getOppAccount(), currentPeriod);
        }
        for (i = 0; i < apEntryCol.size(); ++i) {
            entryInfo = apEntryCol.get(i);
            currentPeriod = (PeriodInfo)apCurrentPeriodMap.get(entryInfo.getParent().getCompany().getId().toString());
            entryInfo.setAccount(proxyBillEntry.getPayAccount());
            entryInfo.setOppAccount(proxyBillEntry.getPayOppAccount());
            if (entryInfo.getVerifyAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            ArApServerUtils.appointmentAccount4Verify(ctx, entryInfo.getId().toString(), entryInfo.getAccount(), entryInfo.getOppAccount(), currentPeriod);
        }
        IArBill.updatePartialBatchData((IObjectCollection)arEntryCol, sic);
        IApBill.updatePartialBatchData((IObjectCollection)apEntryCol, sic);
    }

    @Override
    protected void _canVoucher(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (null == idSet || idSet.isEmpty()) {
            return;
        }
        String resClassName = "com.kingdee.eas.fi.ar.ArApBillResource";
        Locale locale = ctx.getLocale();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        evi.setSelector(sic);
        ProxyBillCollection proxyBillCollection = this.getProxyBillCollection(ctx, evi);
        if (idSet.size() != proxyBillCollection.size()) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)resClassName, (String)"BILL_NOT_EXIST_TRY_AGAIN", (Locale)locale)});
        }
        CompanyOrgUnitInfo companyOrgUnit = proxyBillCollection.get(0).getCompanyOrgUnit();
        boolean arIsRelatedAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)companyOrgUnit);
        boolean isGlStart = CommonServerUtils.glIsStart(ctx, companyOrgUnit);
        if (!arIsRelatedAccount) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)resClassName, (String)"isNotRelateGL", (Locale)locale, (Object[])new Object[]{SystemEnum.ACCOUNTSRECEIVABLE.getAlias()})});
        }
        if (!isGlStart) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)resClassName, (String)"GLIsNotStarted", (Locale)locale, (Object[])new Object[]{SystemEnum.ACCOUNTSRECEIVABLE.getAlias()})});
        }
        ICreateJobFacade iJob = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        if (iJob.checkDuplicateTask("SCM_FI_AR_001" + companyOrgUnit.getNumber())) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)resClassName, (String)"ArClosrAccountIsInQueue", (Locale)locale)});
        }
        if (iJob.checkDuplicateTask("SCM_FI_AP_001" + companyOrgUnit.getNumber())) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)resClassName, (String)"ApClosrAccountIsInQueue", (Locale)locale)});
        }
        for (int i = 0; i < proxyBillCollection.size(); ++i) {
            ProxyBillInfo proxyBillInfo = proxyBillCollection.get(i);
            String exceptionHead = "\u3010" + proxyBillInfo.getNumber() + "\u3011: ";
            if (!BillStatusEnum.AUDITED.equals((Object)proxyBillInfo.getBillStatus())) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{exceptionHead + ResourceBase.getString((String)resClassName, (String)"billIsUnAudited", (Locale)locale)});
            }
            if (proxyBillInfo.isFiVouchered()) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{exceptionHead + ResourceBase.getString((String)resClassName, (String)"billIsFiVouchered", (Locale)locale)});
            }
            if (!proxyBillInfo.isIsInitializeBill()) continue;
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{exceptionHead + ResourceBase.getString((String)resClassName, (String)"billIsFiVouchered", (Locale)locale)});
        }
    }
}

