/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ImportException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.fi.arap.IProxyBill;
import com.kingdee.eas.fi.arap.ProxyBillCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryCustomCollection;
import com.kingdee.eas.fi.arap.ProxyBillEntryCustomInfo;
import com.kingdee.eas.fi.arap.ProxyBillEntryInfo;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.ProxyBillInfo;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanCollection;
import com.kingdee.eas.fi.arap.ProxyBillReceivePlanInfo;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ProxyBillDataImporter {
    private static final Logger logger = CoreUIObject.getLogger(ProxyBillDataImporter.class);
    private BigDecimal amountVal = null;
    private BigDecimal amountLocalVal = null;
    private BigDecimal exchangeRateVal = null;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal ONE = new BigDecimal("1");
    private CurrencyInfo baseCurrency = null;
    private CompanyOrgUnitInfo currentCompany = null;
    String[] DECIMAL_FIELDS = new String[]{"FRecAmount", "FRecAmountLocal", "FExchangeRate_AR"};
    String[] DECIMAL_OBJS = new String[]{"RecAmount", "RecAmountLocal", "RecExchangeRate"};
    Context ctx = null;
    String[] DATE_FIELDS = new String[]{"FBillDate", "FCreateTime", "FBizDate"};
    String[] DATE_OBJS = new String[]{"BillDate", "createTime", "BizDate"};
    String[] STRING_FIELDS = new String[]{"FNumber", "FAsstActNumber_AR", "FAsstActName_AR", "FSummary"};
    String[] STRING_OBJS = new String[]{"number", "RecAsstActNum", "RecAsstActName", "description"};
    String[] ENTRY_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_AR", "FRecievePayAmountLocal_AR", "FQuantity", "FPrice_AR", "FActualPrice_AR", "FTaxPrice_AR", "FTaxRate_AR", "FTaxAmount_AR", "FTaxAmountLocal_AR", "FBadAmount", "FLocalBadAmount", "FAmount_AR", "FAmountLocal_AR", "FDiscountAmount_AR", "FDiscountRate_AR", "FExchangeRate_AP", "FRecievePayAmount_AP", "FRecievePayAmountLocal_AP", "FQuantity", "FPrice_AP", "FActualPrice_AP", "FTaxPrice_AP", "FTaxRate_AP", "FTaxAmount_AP", "FTaxAmountLocal_AP", "FAmount_AP", "FAmountLocal_AP", "FRecievePayAmount_PP", "FRecievePayAmountLocal_PP", "FDiscountAmount_AP", "FDiscountRate_AP"};
    String[] ENTRY_DECIMAL_OBJS = new String[]{"ReceivableAmt", "ReceivableAmtLo", "RecQty", "RecPrice", "RecRealTaxPrice", "RecTaxPrice", "RecTaxRate", "RecTax", "RecTaxLocal", "RecBadAmount", "RecBadAmountLoc", "RecAmount", "RecAmountLocal", "RecDiscountAmt", "RecDiscountRate", "PayExchangeRate", "PayableAmt", "PayableAmtLocal", "PayQty", "PayPrice", "PayRealTaxPrice", "PayTaxPrice", "PayTaxRate", "PayTax", "PayTaxLocal", "PayAmount", "PayAmountLocal", "PayableAmt", "PayableAmtLocal", "PayDiscountAmt", "PayDiscountRate"};
    String[] ENTRY_DATE_FIELDS = new String[]{"FRecievePayDate_PP"};
    String[] ENTRY_DATE_OBJS = new String[]{"PayableAmtDate"};
    String[] PLAN_DECIMAL_FIELDS = new String[]{"FRecievePayAmount_RP", "FRecievePayAmountLocal_RP"};
    String[] PLAN_DECIMAL_OBJS = new String[]{"ReceivableAmt", "ReceivableAmtLo"};
    String[] ENTRY_STRING_FIELDS = new String[]{"FAsstActNumber_AP", "FAsstActName_AP"};
    String[] ENTRY_STRING_OBJS = new String[]{"PayAsstActNum", "PayAsstActName"};
    String[] PLAN_STRING_FIELDS = new String[]{"FRemark__RP"};
    String[] PLAN_STRING_OBJS = new String[]{"RecRemark"};
    private PeriodInfo arStartPeriod = null;
    private PeriodInfo arCurrentPeriod = null;
    private PeriodInfo apStartPeriod = null;
    private PeriodInfo apCurrentPeriod = null;
    private boolean isARInitBill = false;
    private boolean isARFinish = false;
    private boolean isAPInitBill = false;
    private boolean isAPFinish = false;
    private boolean arIsStart = true;
    private boolean apIsStart = true;

    public IObjectPK submit(CoreBaseInfo coreBaseInfo) throws TaskExternalException, ImportException {
        ICoreBase iProxyBill = this.getController();
        ProxyBillInfo proxyBillInfo = (ProxyBillInfo)coreBaseInfo;
        try {
            if (coreBaseInfo.getId() == null || !iProxyBill.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                if (proxyBillInfo.getReceivePlan() != null && proxyBillInfo.getReceivePlan().size() == 0) {
                    ProxyBillReceivePlanInfo newProxyBillReceivePlanInfo = new ProxyBillReceivePlanInfo();
                    newProxyBillReceivePlanInfo.setParent(proxyBillInfo);
                    newProxyBillReceivePlanInfo.setSeq(1);
                    newProxyBillReceivePlanInfo.setReceivableDate(proxyBillInfo.getBillDate());
                    newProxyBillReceivePlanInfo.setReceivableAmt(proxyBillInfo.getRecAmount());
                    newProxyBillReceivePlanInfo.setReceivableAmtLo(proxyBillInfo.getRecAmountLocal());
                    newProxyBillReceivePlanInfo.setVerifyAmount(new BigDecimal(0));
                    newProxyBillReceivePlanInfo.setVerifyAmountLoc(new BigDecimal(0));
                    newProxyBillReceivePlanInfo.setUnVerifyAmount(new BigDecimal(0));
                    newProxyBillReceivePlanInfo.setUnVerifyAmountL(new BigDecimal(0));
                    ProxyBillReceivePlanCollection planColl = new ProxyBillReceivePlanCollection();
                    planColl.add(newProxyBillReceivePlanInfo);
                    proxyBillInfo.put("ReceivePlan", (Object)planColl);
                }
                proxyBillInfo.setIsImportBill(true);
                return iProxyBill.save((CoreBaseInfo)proxyBillInfo);
            }
            proxyBillInfo.put("import", "aaa");
            iProxyBill.update((IObjectPK)new ObjectUuidPK(proxyBillInfo.getId()), (CoreBaseInfo)proxyBillInfo);
            return new ObjectUuidPK(proxyBillInfo.getId());
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)ex));
            throw new ImportException(ImportException.PROXYERROR);
        }
    }

    protected ICoreBase getController() throws TaskExternalException {
        try {
            return ProxyBillFactory.getLocalInstance(this.ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public ProxyBillDataImporter(Context ctx) throws TaskExternalException, ImportException {
        try {
            this.ctx = ctx;
            this.currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (this.currentCompany.getBaseCurrency() == null) {
                throw new ImportException(ImportException.CANNOTGETLOCALCURRENCY);
            }
            this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
            this.arStartPeriod = ArServerUtils.getArStartPeriod(ctx, this.currentCompany);
            this.apStartPeriod = ApServerUtils.getApStartPeriod(ctx, this.currentCompany);
            this.arIsStart = ArServerUtils.arIsStart(ctx, this.currentCompany);
            this.apIsStart = ApServerUtils.apIsStart(ctx, this.currentCompany);
            this.arCurrentPeriod = ArServerUtils.getArCurrentPeriod(ctx, this.currentCompany);
            this.apCurrentPeriod = ApServerUtils.getApCurrentPeriod(ctx, this.currentCompany);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new ImportException(ImportException.CANNOTGETSYSCONTEXT);
        }
    }

    public Map<String, Object> transfer(Hashtable hsData, ArrayList headDefineFieldList, ArrayList entryDefineFieldList) throws TaskExternalException, ImportException {
        int i;
        if (this.arStartPeriod == null || this.apStartPeriod == null) {
            try {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany});
            }
            catch (OtherBillBizException e) {
                throw new ImportException(ImportException.PROXYNUMBERERROR, (Throwable)((Object)e));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ProxyBillInfo proxyBillInfo = new ProxyBillInfo();
        Object objVal = null;
        String str = null;
        boolean isUpdateBill = false;
        boolean isImportDataByRule = false;
        if (hsData.get("IsImportDataByRule") != null) {
            isImportDataByRule = (Boolean)hsData.get("IsImportDataByRule");
        }
        str = ARAPImportHelper.getDataString(hsData, "FNumber");
        this.currentCompany = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        if (str != null) {
            proxyBillInfo.setNumber(str);
            try {
                IProxyBill iProxyBill = ProxyBillFactory.getLocalInstance(this.ctx);
                EntityViewInfo viewInfo = ProxyBillDataImporter.getAscDefaultEntVByNum(str);
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.name", (Object)this.currentCompany.getName().toString()));
                ProxyBillCollection collection = iProxyBill.getProxyBillCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    proxyBillInfo = collection.get(0);
                    if (3 == proxyBillInfo.getBillStatus().getValue()) {
                        throw new TaskExternalException(ARAPImportHelper.getString("BillStatusAudited", this.ctx));
                    }
                    isUpdateBill = true;
                }
                isUpdateBill = false;
            }
            catch (BOSException e) {
                throw new ImportException(ImportException.PROXYNUMBERERROR, e);
            }
        } else if (isImportDataByRule) {
            isUpdateBill = false;
        } else {
            throw new ImportException(ImportException.PROXYNUMBERERROR);
        }
        Date date = null;
        for (int i2 = 0; i2 < this.DATE_FIELDS.length; ++i2) {
            date = ARAPImportHelper.getDataDate(this.ctx, hsData, this.DATE_FIELDS[i2]);
            if (date == null) continue;
            proxyBillInfo.setDate(this.DATE_OBJS[i2], date);
        }
        if (null == proxyBillInfo.getBizDate()) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("BizDateIsNull", this.ctx));
        }
        if (null == proxyBillInfo.getBillDate()) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("DateIsNull", this.ctx));
        }
        if (proxyBillInfo.getBillDate().before(this.arStartPeriod.getBeginDate())) {
            this.isARInitBill = true;
        }
        if (proxyBillInfo.getBillDate().before(this.arCurrentPeriod.getBeginDate())) {
            this.isARFinish = true;
        }
        if (this.arIsStart && this.isARInitBill) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("Cannot_InitBill_Wrong", this.ctx));
        }
        if (!this.isARInitBill && this.isARFinish) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("Cannot_FinistBill_Wrong", this.ctx));
        }
        if (proxyBillInfo.getBillDate().before(this.apStartPeriod.getBeginDate())) {
            this.isAPInitBill = true;
        }
        if (proxyBillInfo.getBillDate().before(this.apCurrentPeriod.getBeginDate())) {
            this.isAPFinish = true;
        }
        if (this.apIsStart && this.isAPInitBill) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("Cannot_InitBill_Wrong", this.ctx));
        }
        if (!this.isAPInitBill && this.isAPFinish) {
            throw new TaskExternalException(ProxyBillDataImporter.getString("Cannot_FinistBill_Wrong", this.ctx));
        }
        BigDecimal decVal = null;
        for (i = 0; i < this.DECIMAL_FIELDS.length; ++i) {
            decVal = ARAPImportHelper.getDataDeciaml(this.ctx, hsData, this.DECIMAL_FIELDS[i]);
            proxyBillInfo.setBigDecimal(this.DECIMAL_OBJS[i], decVal);
            this.setCheckField(this.DECIMAL_FIELDS[i], decVal);
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
            if (str == null) continue;
            proxyBillInfo.setString(this.STRING_OBJS[i], str);
        }
        Object data = null;
        try {
            int i3;
            int num;
            int seq;
            proxyBillInfo.setCompanyOrgUnit(this.currentCompany);
            proxyBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.ctx));
            proxyBillInfo.setRecCurrency(ARAPImportHelper.getCurrencyInfo(this.ctx, hsData, "FCurrencyID_AR"));
            proxyBillInfo.setAdminOrgUnit(ARAPImportHelper.getAdminOrgUnitInfo(this.ctx, hsData, "FAdminOrgID"));
            proxyBillInfo.setRecAsstActType(ARAPImportHelper.getAsstActTypeInfo(this.ctx, hsData, "FAsstActTypeID_AR"));
            if (!this.checkAsstAccID(proxyBillInfo.getRecAsstActType(), hsData, proxyBillInfo, null, 1)) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNumber_Wrong", this.ctx));
            }
            if (!ARAPImportHelper.isExistAsstActByCompany(this.ctx, this.currentCompany, proxyBillInfo.getRecAsstActType(), proxyBillInfo.getRecAsstActId())) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", this.ctx));
            }
            if (!this.checkBillDate(proxyBillInfo)) {
                throw new TaskExternalException(ARAPImportHelper.getString("BizDate_BillDate_Wrong", this.ctx));
            }
            if (this.isARInitBill && this.isAPInitBill) {
                proxyBillInfo.setIsInitializeBill(true);
            } else {
                proxyBillInfo.setIsInitializeBill(false);
            }
            for (int i4 = 0; i4 < headDefineFieldList.size(); ++i4) {
                String fieldName = headDefineFieldList.get(i4).toString();
                objVal = ((DataToken)hsData.get((Object)fieldName)).data;
                proxyBillInfo.put(fieldName.substring(1), objVal);
            }
            ProxyBillEntryInfo entryInfo = null;
            ProxyBillReceivePlanInfo planInfo = null;
            boolean isUpdateEntry = false;
            boolean isUpdatePlan = false;
            int ind = 0;
            try {
                str = ARAPImportHelper.getDataString(hsData, "FSeq");
                if (str != null) {
                    seq = Integer.parseInt(str);
                    ProxyBillEntryCollection entryCollection = proxyBillInfo.getEntry();
                    num = entryCollection.size();
                    for (i3 = 0; i3 < num; ++i3) {
                        ProxyBillEntryInfo tempEntryInfo = entryCollection.get(i3);
                        if (tempEntryInfo.getSeq() != seq) continue;
                        entryInfo = tempEntryInfo;
                        isUpdateEntry = true;
                        ind = i3;
                    }
                    if (!isUpdateEntry) {
                        entryInfo = new ProxyBillEntryInfo();
                        entryInfo.setHead(proxyBillInfo);
                        entryInfo.setSeq(seq);
                        this.createEntryInfo(proxyBillInfo, entryInfo, hsData, entryDefineFieldList, isUpdateEntry);
                        entryCollection.add(entryInfo);
                    } else if (!isImportDataByRule) {
                        String msg = ARAPImportHelper.getString("BillNumDuplicate", this.ctx);
                        msg = MessageFormat.format(msg, proxyBillInfo.getNumber(), seq + "");
                        throw new TaskExternalException(msg);
                    }
                    result.put("proxyBillEntryInfo", entryInfo);
                    proxyBillInfo.put("Entry", (Object)entryCollection);
                } else if (!isUpdateBill) {
                    throw new TaskExternalException(ARAPImportHelper.getString("EntrySeq_NoFound", this.ctx));
                }
            }
            catch (NumberFormatException e) {
                String msg = ARAPImportHelper.getString("NumberField_Wrong", this.ctx);
                msg = MessageFormat.format(msg, "FSeq");
                throw new TaskExternalException(msg);
            }
            try {
                data = ((DataToken)hsData.get((Object)"FSeq_RP")).data;
                if (data != null && data.toString().trim().length() > 0) {
                    seq = Integer.parseInt(data.toString());
                    ProxyBillReceivePlanCollection planCollection = proxyBillInfo.getReceivePlan();
                    num = planCollection.size();
                    for (i3 = 0; i3 < num; ++i3) {
                        ProxyBillReceivePlanInfo tempPlanInfo = planCollection.get(i3);
                        if (tempPlanInfo.getSeq() != seq) continue;
                        planInfo = tempPlanInfo;
                        isUpdatePlan = true;
                        ind = i3;
                    }
                    if (!isUpdatePlan) {
                        planInfo = new ProxyBillReceivePlanInfo();
                        planInfo.setParent(proxyBillInfo);
                        planInfo.setSeq(seq);
                        this.createPlanInfo(proxyBillInfo, planInfo, hsData, isUpdatePlan);
                        planCollection.add(planInfo);
                    } else {
                        this.createPlanInfo(proxyBillInfo, planInfo, hsData, isUpdatePlan);
                        planCollection.set(ind, planInfo);
                    }
                    result.put("proxyBillPlanInfo", planInfo);
                    proxyBillInfo.put("ReceivePlan", (Object)planCollection);
                }
            }
            catch (NumberFormatException e) {
                String msg = ARAPImportHelper.getString("NumberField_Wrong", this.ctx);
                msg = MessageFormat.format(msg, "FSeq");
                throw new TaskExternalException(msg);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        result.put("proxyBillInfo", proxyBillInfo);
        return result;
    }

    private void createEntryInfo(ProxyBillInfo proxyBillInfo, ProxyBillEntryInfo entryInfo, Hashtable hsData, ArrayList entryDefineFieldList, boolean isUpdateEntry) throws TaskExternalException {
        Object data = null;
        String str = null;
        try {
            int i;
            entryInfo.setPayCurrency(ARAPImportHelper.getCurrencyInfo(this.ctx, hsData, "FCurrencyID_AP"));
            BigDecimal decVal = null;
            for (i = 0; i < this.ENTRY_DECIMAL_FIELDS.length; ++i) {
                decVal = ARAPImportHelper.getDataDeciaml(this.ctx, hsData, this.ENTRY_DECIMAL_FIELDS[i]);
                entryInfo.setBigDecimal(this.ENTRY_DECIMAL_OBJS[i], decVal);
                if (decVal == null || ImportDataUtil.checkIsPositiveRate(this.ENTRY_DECIMAL_OBJS[i], decVal.toString())) continue;
                throw new ImportException(ImportException.TAXRATECANNOTNEGATIVE);
            }
            for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
                str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
                entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
            }
            Date date = null;
            for (int i2 = 0; i2 < this.ENTRY_DATE_FIELDS.length; ++i2) {
                date = ARAPImportHelper.getDataDate(this.ctx, hsData, this.ENTRY_DATE_FIELDS[i2]);
                entryInfo.setDate(this.ENTRY_DATE_OBJS[i2], date);
            }
            entryInfo.setPayAsstActType(ARAPImportHelper.getAsstActTypeInfo(this.ctx, hsData, "FAsstActTypeID_AP"));
            if (!this.checkAsstAccID(entryInfo.getPayAsstActType(), hsData, null, entryInfo, 2)) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNumber_Wrong", this.ctx));
            }
            if (!ARAPImportHelper.isExistAsstActByCompany(this.ctx, this.currentCompany, entryInfo.getPayAsstActType(), entryInfo.getPayAsstActId())) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", this.ctx));
            }
            MeasureUnitInfo unit = ARAPImportHelper.getMeasureUnitInfo(this.ctx, hsData, "FMeatureUnit");
            MaterialInfo info = ARAPImportHelper.getMaterialInfo(this.ctx, hsData, "FMaterialID");
            ExpenseTypeInfo enpenseItemInfo = ARAPImportHelper.getExpenseItemInfo(this.ctx, hsData, "FExpenseItemID");
            if (info != null && enpenseItemInfo != null) {
                throw new TaskExternalException(ARAPImportHelper.getString("MATERIALANDEXPENSEITEMEXIST", this.ctx));
            }
            if (info != null) {
                if (unit == null) {
                    IMeasureUnit iunit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getId(), CompareType.EQUALS));
                    filterInfo.setMaskString("#0");
                    viewInfo.setFilter(filterInfo);
                    MeasureUnitCollection unitCollection = iunit.getMeasureUnitCollection();
                    if (unitCollection != null && unitCollection.size() > 0) {
                        unit = unitCollection.get(0);
                    }
                }
                entryInfo.setMaterial(info);
                entryInfo.setUnit(unit);
            }
            if (enpenseItemInfo != null) {
                entryInfo.setExpenseItem(enpenseItemInfo);
                entryInfo.setUnit(unit);
            }
            ProxyBillEntryCustomInfo customInfo = new ProxyBillEntryCustomInfo();
            for (int i3 = 0; i3 < entryDefineFieldList.size(); ++i3) {
                String fieldName = entryDefineFieldList.get(i3).toString();
                data = ((DataToken)hsData.get((Object)fieldName)).data;
                customInfo.put(fieldName.substring(1), data);
            }
            if (entryDefineFieldList.size() > 0) {
                ProxyBillEntryCustomCollection entryCustomCollection = new ProxyBillEntryCustomCollection();
                entryCustomCollection.add(customInfo);
                entryInfo.put("Custom", (Object)entryCustomCollection);
            }
            entryInfo.setRecUnVerifyAmt(entryInfo.getReceivableAmt());
            entryInfo.setRecUnVerifyAmtL(entryInfo.getReceivableAmtLo());
            entryInfo.setPayUnVerifyAmt(entryInfo.getPayableAmt());
            entryInfo.setPayUnVerifyAmtL(entryInfo.getPayableAmtLocal());
            this.setBillAmtFromEntry(proxyBillInfo, entryInfo, isUpdateEntry);
            entryInfo.setRecAccount(ARAPImportHelper.getAccountViewInfo(this.ctx, hsData, "FAccount_AR", null));
            entryInfo.setRecOppAccount(ARAPImportHelper.getAccountViewInfo(this.ctx, hsData, "FOppAccount_AR", null));
            entryInfo.setPayAccount(ARAPImportHelper.getAccountViewInfo(this.ctx, hsData, "FAccount_AP", null));
            entryInfo.setPayOppAccount(ARAPImportHelper.getAccountViewInfo(this.ctx, hsData, "FOppAccount_AP", null));
            if (proxyBillInfo.getBillDate().before(this.arStartPeriod.getBeginDate())) {
                if (entryInfo.getRecAccount() == null) {
                    throw new ImportException(ImportException.INITBILLACCOUNT_REC);
                }
                if (entryInfo.getPayAccount() == null) {
                    throw new ImportException(ImportException.INITBILLACCOUNT_PAY);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void createPlanInfo(ProxyBillInfo proxyBillInfo, ProxyBillReceivePlanInfo planInfo, Hashtable hsData, boolean isUpdatePlan) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        for (i = 0; i < this.PLAN_DECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.PLAN_DECIMAL_FIELDS[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    value = new BigDecimal(o.toString());
                    if (value == null) continue;
                    planInfo.setBigDecimal(this.PLAN_DECIMAL_OBJS[i], (BigDecimal)value);
                    continue;
                }
                planInfo.setBigDecimal(this.PLAN_DECIMAL_OBJS[i], new BigDecimal(0.0));
                continue;
            }
            catch (Exception nex) {
                logger.error((Object)nex);
                String msg = ARAPImportHelper.getString("NumberField_Wrong", this.ctx);
                msg = MessageFormat.format(msg, this.PLAN_DECIMAL_FIELDS[i]);
                throw new TaskExternalException(msg);
            }
        }
        for (i = 0; i < this.PLAN_STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.PLAN_STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            planInfo.setString(this.PLAN_STRING_OBJS[i], (String)value);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        o = ((DataToken)hsData.get((Object)"FRecievePayDate_RP")).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                String msg = ARAPImportHelper.getString("DateFormat_Wrong", this.ctx);
                msg = MessageFormat.format(msg, "FRecievePayDate_RP");
                throw new TaskExternalException(msg);
            }
            if (o != null && (value = (Date)o) != null) {
                planInfo.setDate("ReceivableDate", (Date)value);
            }
        }
        if (!this.checkPlanDate(proxyBillInfo, planInfo)) {
            throw new TaskExternalException(ARAPImportHelper.getString("PlanDate_BillDate_R_Wrong", this.ctx));
        }
    }

    private void setCheckField(String fieldName, BigDecimal value) throws ImportException {
        if (fieldName.trim().equals("FRecAmount")) {
            if (value == null || value.compareTo(ZERO) == 0) {
                throw new ImportException(ImportException.RECAMOUNTISNULL);
            }
            this.amountVal = value;
        } else if (fieldName.trim().equals("FRecAmountLocal")) {
            if (value == null || value.compareTo(ZERO) == 0) {
                throw new ImportException(ImportException.RECAMOUNTLOCINNULL);
            }
            this.amountLocalVal = value;
        } else if (fieldName.trim().equals("FExchangeRate_AR")) {
            if (value == null) {
                throw new ImportException(ImportException.EXCHANGERATEISNULL);
            }
            this.exchangeRateVal = value.compareTo(ZERO) == 0 ? ONE : value;
        }
    }

    private boolean getExchangeRate(BigDecimal exchangeRate, CurrencyInfo currency) throws Exception {
        boolean isDirectExchange = true;
        ExchangeRateInfo rateInfo = null;
        if (!currency.getId().equals((Object)this.baseCurrency.getId()) && (rateInfo = ARAPImportHelper.getExchangeRateInfo(this.ctx, this.currentCompany, currency)) != null) {
            if (rateInfo.getExchangeAux() == null) {
                return true;
            }
            isDirectExchange = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode());
        }
        return isDirectExchange;
    }

    private BigDecimal getLocalAmount(BigDecimal exchangeRate, CurrencyInfo currency, BigDecimal amount) throws Exception {
        boolean isDirectExchange = this.getExchangeRate(exchangeRate, currency);
        if (amount == null) {
            return ZERO;
        }
        BigDecimal localAmount = ZERO;
        localAmount = isDirectExchange ? amount.multiply(exchangeRate) : amount.divide(exchangeRate, this.baseCurrency.getPrecision(), 4);
        return localAmount;
    }

    private void setBillAmtFromEntry(ProxyBillInfo proxyBillInfo, ProxyBillEntryInfo proxyBillEntryInfo, boolean isUpdateEntry) {
        ProxyBillEntryCollection c = proxyBillInfo.getEntry();
        BigDecimal temp = new BigDecimal(0);
        BigDecimal exchangeRate = proxyBillInfo.getRecExchangeRate();
        if (c.size() == 0) {
            temp = temp.add(proxyBillEntryInfo.getReceivableAmt());
        } else {
            Iterator itrEntry = c.iterator();
            if (!isUpdateEntry) {
                while (itrEntry.hasNext()) {
                    ProxyBillEntryInfo entryTmp = (ProxyBillEntryInfo)itrEntry.next();
                    temp = temp.add(entryTmp.getReceivableAmt());
                }
                temp = temp.add(proxyBillEntryInfo.getReceivableAmt());
            } else {
                while (itrEntry.hasNext()) {
                    ProxyBillEntryInfo entryTmp = (ProxyBillEntryInfo)itrEntry.next();
                    if (entryTmp.getSeq() == proxyBillEntryInfo.getSeq()) {
                        temp = temp.add(proxyBillEntryInfo.getReceivableAmt());
                        continue;
                    }
                    temp = temp.add(entryTmp.getReceivableAmt());
                }
            }
        }
        proxyBillInfo.setRecAmount(temp);
        proxyBillInfo.setRecUnVerifyAmt(temp);
        exchangeRate = exchangeRate.compareTo(ZERO) == 0 ? ONE : exchangeRate;
        proxyBillInfo.setRecExchangeRate(exchangeRate);
        temp = temp.multiply(proxyBillInfo.getRecExchangeRate());
        proxyBillInfo.setRecAmountLocal(temp);
        proxyBillInfo.setRecUnVerifyAmtL(temp);
        if (proxyBillInfo.getReceivePlan().size() == 1) {
            ProxyBillReceivePlanInfo newPlanInfo = proxyBillInfo.getReceivePlan().get(0);
            newPlanInfo.setReceivableAmt(proxyBillInfo.getRecAmount());
        }
    }

    private String checkOtherBillEntryInfo(ProxyBillInfo proxyBillInfo, ProxyBillEntryInfo info) {
        String errMsg = null;
        BigDecimal recQty = info.getRecQty();
        BigDecimal recTaxRate = info.getRecTaxRate() == null ? ZERO : info.getRecTaxRate();
        BigDecimal recPrice = info.getRecPrice();
        BigDecimal recTaxPrice = info.getRecTaxPrice();
        BigDecimal recDiscountRate = info.getRecDiscountRate();
        BigDecimal recDiscountAmt = info.getRecDiscountAmt();
        BigDecimal actualRecTaxPrice = ZERO;
        BigDecimal recAmtTemp = ZERO;
        BigDecimal recAmount = info.getRecAmount();
        BigDecimal recTaxAmount = ZERO;
        BigDecimal receivableAmt = ZERO;
        actualRecTaxPrice = ImportDataUtil.getActualTaxPrice(recTaxPrice, recDiscountRate);
        if (actualRecTaxPrice.compareTo(info.getRecRealTaxPrice()) != 0) {
            return ARAPImportHelper.getString("ActualPrice_Wrong", this.ctx);
        }
        recAmtTemp = ImportDataUtil.getAmount(recPrice, recQty, recDiscountRate);
        if (recAmtTemp.compareTo(info.getRecAmount()) != 0) {
            return ARAPImportHelper.getString("Amount_E_Wrong", this.ctx);
        }
        recTaxAmount = ImportDataUtil.getTaxAmount(recAmount, recTaxRate);
        if (recTaxAmount.compareTo(info.getRecTax()) != 0) {
            return ARAPImportHelper.getString("TaxAmount_Wrong", this.ctx);
        }
        receivableAmt = ImportDataUtil.getRecAmount(recAmount, recTaxAmount);
        if (receivableAmt.compareTo(info.getReceivableAmt()) != 0) {
            return ARAPImportHelper.getString("RecAmount_Wrong", this.ctx);
        }
        if (recDiscountAmt.compareTo(ImportDataUtil.ZERO) != 0 && recDiscountRate.compareTo(ImportDataUtil.ZERO) != 0) {
            BigDecimal temp = ImportDataUtil.getDiscountAmount(recTaxPrice, recQty, recDiscountRate);
            if (temp.compareTo(recDiscountAmt) != 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
        } else {
            if (recDiscountAmt.compareTo(ImportDataUtil.ZERO) != 0 && recDiscountRate.compareTo(ImportDataUtil.ZERO) == 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
            if (recDiscountAmt.compareTo(ImportDataUtil.ZERO) == 0 && recDiscountRate.compareTo(ImportDataUtil.ZERO) != 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
        }
        BigDecimal payQty = info.getPayQty();
        BigDecimal payTaxRate = info.getPayTaxRate() == null ? ZERO : info.getPayTaxRate();
        BigDecimal payPrice = info.getPayPrice();
        BigDecimal payTaxPrice = info.getPayTaxPrice();
        BigDecimal payDiscountRate = info.getPayDiscountRate();
        BigDecimal payDiscountAmt = info.getPayDiscountAmt();
        BigDecimal actualPayTaxPrice = ZERO;
        BigDecimal payAmtTemp = ZERO;
        BigDecimal payAmount = info.getPayAmount();
        BigDecimal payTaxAmount = ZERO;
        BigDecimal payableAmt = ZERO;
        actualPayTaxPrice = ImportDataUtil.getActualTaxPrice(payTaxPrice, payDiscountRate);
        if (actualPayTaxPrice.compareTo(info.getPayRealTaxPrice()) != 0) {
            return ARAPImportHelper.getString("ActualPrice_Wrong", this.ctx);
        }
        payAmtTemp = ImportDataUtil.getAmount(payPrice, payQty, payDiscountRate);
        if (payAmtTemp.compareTo(info.getPayAmount()) != 0) {
            return ARAPImportHelper.getString("Amount_E_Wrong", this.ctx);
        }
        payTaxAmount = ImportDataUtil.getTaxAmount(payAmount, payTaxRate);
        if (payTaxAmount.compareTo(info.getPayTax()) != 0) {
            return ARAPImportHelper.getString("TaxAmount_Wrong", this.ctx);
        }
        payableAmt = ImportDataUtil.getRecAmount(payAmount, payTaxAmount);
        if (payableAmt.compareTo(info.getPayableAmt()) != 0) {
            return ARAPImportHelper.getString("Entry_PayAmount_Wrong", this.ctx);
        }
        if (payDiscountAmt.compareTo(ImportDataUtil.ZERO) != 0 && payDiscountRate.compareTo(ImportDataUtil.ZERO) != 0) {
            BigDecimal temp = ImportDataUtil.getDiscountAmount(payTaxPrice, payQty, payDiscountRate);
            if (temp.compareTo(payDiscountAmt) != 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
        } else {
            if (payDiscountAmt.compareTo(ImportDataUtil.ZERO) != 0 && payDiscountRate.compareTo(ImportDataUtil.ZERO) == 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
            if (payDiscountAmt.compareTo(ImportDataUtil.ZERO) == 0 && payDiscountRate.compareTo(ImportDataUtil.ZERO) != 0) {
                return ARAPImportHelper.getString("DisRate_DisAmt_R_Wrong", this.ctx);
            }
        }
        return errMsg;
    }

    private String checkExchangeAndAmount(ProxyBillInfo billInfo, ProxyBillEntryInfo entryInfo) throws Exception {
        String errMsg = null;
        BigDecimal amountLocal = ZERO;
        BigDecimal taxAmountLocal = ZERO;
        BigDecimal recievePayAmountLocal = ZERO;
        amountLocal = this.getLocalAmount(billInfo.getRecExchangeRate(), billInfo.getRecCurrency(), entryInfo.getRecAmount());
        if (amountLocal.compareTo(entryInfo.getRecAmountLocal()) != 0) {
            return ARAPImportHelper.getString("AmountLocal_E_Wrong", this.ctx);
        }
        taxAmountLocal = this.getLocalAmount(billInfo.getRecExchangeRate(), billInfo.getRecCurrency(), entryInfo.getRecTax());
        if (taxAmountLocal.compareTo(entryInfo.getRecTaxLocal()) != 0) {
            return ARAPImportHelper.getString("TaxAmountLocal_Wrong", this.ctx);
        }
        recievePayAmountLocal = this.getLocalAmount(billInfo.getRecExchangeRate(), billInfo.getRecCurrency(), entryInfo.getReceivableAmt());
        if (recievePayAmountLocal.compareTo(entryInfo.getReceivableAmtLo()) != 0) {
            return ARAPImportHelper.getString("RecievePayAmountLocal_E_Wrong", this.ctx);
        }
        BigDecimal payAmountLocal = ZERO;
        BigDecimal payTaxAmountLocal = ZERO;
        BigDecimal payRecievePayAmountLocal = ZERO;
        payAmountLocal = this.getLocalAmount(entryInfo.getPayExchangeRate(), entryInfo.getPayCurrency(), entryInfo.getPayAmount());
        if (payAmountLocal.compareTo(entryInfo.getPayAmountLocal()) != 0) {
            return ARAPImportHelper.getString("AmountLocal_E_Wrong", this.ctx);
        }
        payTaxAmountLocal = this.getLocalAmount(entryInfo.getPayExchangeRate(), entryInfo.getPayCurrency(), entryInfo.getPayTax());
        if (payTaxAmountLocal.compareTo(entryInfo.getPayTaxLocal()) != 0) {
            return ARAPImportHelper.getString("TaxAmountLocal_Wrong", this.ctx);
        }
        payRecievePayAmountLocal = this.getLocalAmount(entryInfo.getPayExchangeRate(), entryInfo.getPayCurrency(), entryInfo.getPayableAmt());
        if (payRecievePayAmountLocal.compareTo(entryInfo.getPayableAmtLocal()) != 0) {
            return ARAPImportHelper.getString("Entry_PayAmountLocal_E_Wrong", this.ctx);
        }
        return errMsg;
    }

    private boolean checkAsstAccID(AsstActTypeInfo asstActTypeInfo, Hashtable hsData, ProxyBillInfo proxyBillInfo, ProxyBillEntryInfo entryInfo, int isEntry) throws TaskExternalException, BOSException {
        String tableName;
        boolean flag = false;
        String str = null;
        String fieldName = "";
        String fId = null;
        String fName = null;
        fieldName = isEntry == 1 ? "FAsstActNumber_AR" : "FAsstActNumber_AP";
        str = ARAPImportHelper.getDataString(hsData, fieldName);
        if (str != null && asstActTypeInfo != null && asstActTypeInfo.getDefaultQueryName() != null && (tableName = asstActTypeInfo.getRealtionDataObject()) != null && tableName.length() > 0) {
            try {
                RowSet rs = ARAPImportHelper.getAsstActInfo(this.ctx, str, asstActTypeInfo);
                while (rs.next()) {
                    flag = true;
                    fId = rs.getString("fid");
                    fName = rs.getString("fname");
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (isEntry == 1) {
            proxyBillInfo.setRecAsstActId(fId);
            proxyBillInfo.setRecAsstActName(fName, LocaleUtils.locale_L1);
            proxyBillInfo.setRecAsstActName(fName, LocaleUtils.locale_L2);
            proxyBillInfo.setRecAsstActName(fName, LocaleUtils.locale_L3);
        } else {
            entryInfo.setPayAsstActId(fId);
            entryInfo.setPayAsstActName(fName, LocaleUtils.locale_L1);
            entryInfo.setPayAsstActName(fName, LocaleUtils.locale_L2);
            entryInfo.setPayAsstActName(fName, LocaleUtils.locale_L3);
        }
        return flag;
    }

    private boolean checkBillDate(ProxyBillInfo proxyBillInfo) throws TaskExternalException {
        boolean ret = true;
        Date bizDate = proxyBillInfo.getBizDate();
        Date billDate = proxyBillInfo.getBillDate();
        if (billDate.before(bizDate)) {
            ret = false;
        }
        return ret;
    }

    private boolean checkPlanDate(ProxyBillInfo proxyBillInfo, ProxyBillReceivePlanInfo proxyBillReceivePlanInfo) throws TaskExternalException {
        Date billDate;
        boolean ret = true;
        Date recievePayDate = proxyBillReceivePlanInfo.getReceivableDate();
        if (recievePayDate.before(billDate = proxyBillInfo.getBillDate())) {
            ret = false;
        }
        return ret;
    }

    private static EntityViewInfo getAscDefaultEntVByNum(String number) {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("name"));
        entityView.getSelector().add(new SelectorItemInfo("BillStatus"));
        entityView.getSelector().add(new SelectorItemInfo("Entry.*"));
        entityView.getSelector().add(new SelectorItemInfo("ReceivePlan.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        entityView.setFilter(filter);
        return entityView;
    }

    public static String getString(String resName, Context ctx) {
        return ProxyBillDataImporter.getString("AR", resName, ctx);
    }

    public static String getString(String SysType, String resName, Context ctx) {
        String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
        String AP_RESOURCE_PATH = "com.kingdee.eas.fi.ap.APImportData";
        if (SysType.equals("AR")) {
            return ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        if (SysType.equals("AP")) {
            return ResourceBase.getString((String)AP_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        return null;
    }
}

