/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.CommRptRouteConfigFacadeFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APDisposeUtil;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApRelationEntryInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IArApBillPlanBase;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillPlanFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.fi.arap.IVerificationBillBase;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryCollection;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.app.AbstractVerificationBillBaseControllerBean;
import com.kingdee.eas.fi.arap.app.VerificationStrategy;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.scm.framework.util.SCMThreadLocalUtil;
import com.kingdee.eas.scm.framework.writeoff.app.ExtendStoreFieldsHandler;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class VerificationBillBaseControllerBean
extends AbstractVerificationBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.VerificationBillBaseControllerBean");
    private static Logger wfLogger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.writeoff");
    protected String entryTab = null;
    public static final String CR = " \r\n ";
    public static final String RES = "com.kingdee.eas.fi.arap.ARAPAutoGenerateResource";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource";
    ArApBillHelper helper = new ArApBillHelper();
    private String verifyTempTable = null;
    public static final String RT = " \r\n ";
    public static final String verifyTempTableDefine = " CREATE TABLE TEML_KSQL_0 (FBILLID VARCHAR(44),  FENTRYID VARCHAR(44),  FTHISVERIFICATEAMT DECIMAL(19, 4) NOT NULL DEFAULT 0,  FTHISVERIFICATEAMTLOC DECIMAL(19, 4) NOT NULL DEFAULT 0,  FISFROMBOTP INT,  FISPREVERIFY INT,  FBILLTYPE INT,  FParentID VARCHAR(44) ) ";
    private Set<String> cacheIds = new HashSet<String>();
    private List<String> tmpTabList = new LinkedList<String>();

    private void _setBillDate(Context ctx, VerificationBillBaseInfo veriBill) throws BOSException, EASBizException {
        IObjectCollection entry = (IObjectCollection)veriBill.get("entrys");
        Date billDate = null;
        Date veriDate = veriBill.getBizDate();
        Date maxBillDate = null;
        CompanyOrgUnitInfo curCompany = veriBill.getCompany();
        SystemStatusCtrolInfo sysStatusInfo = ArApBillHelper.getSysStatusCtrolInfo(ctx, curCompany, this.getSysEnum());
        String msg = ResourceBase.getString((String)RES, (String)"151_VerificationBillBaseControllerBean", (Locale)ctx.getLocale());
        if (sysStatusInfo == null) {
            throw new ARAPVerifynException(ARAPVerifynException.COMMON, new Object[]{msg});
        }
        PeriodInfo curPeriod = sysStatusInfo.getCurrentPeriod();
        for (int i = 0; i < entry.size(); ++i) {
            billDate = ((VerificationBillBaseEntryInfo)entry.getObject(i)).getBillDate();
            if (maxBillDate != null && !maxBillDate.before(billDate)) continue;
            maxBillDate = billDate;
        }
        if (entry.size() > 0 && maxBillDate != null) {
            veriBill.setBizDate(ArApBillHelper.getVerifiedDate(maxBillDate, curPeriod));
            if (veriDate != null && (veriDate.after(maxBillDate) || veriDate.equals(maxBillDate))) {
                veriBill.setBizDate(veriDate);
            }
        }
    }

    protected SystemEnum getSysEnum() {
        return null;
    }

    private void _setGainLoss(VerificationBillBaseInfo veriBill, boolean isGainLoss) {
        if (veriBill == null) {
            return;
        }
        boolean isSameSide = false;
        IObjectCollection entrys = (IObjectCollection)veriBill.get("entrys");
        BigDecimal mainGainAndLoss = BaseDataUtil.ZERO;
        BigDecimal topAmtLoc = BaseDataUtil.ZERO;
        BigDecimal botAmtLoc = BaseDataUtil.ZERO;
        BigDecimal topAmt = BaseDataUtil.ZERO;
        BigDecimal botAmt = BaseDataUtil.ZERO;
        boolean isSameCurrency = true;
        int entrySize = entrys.size();
        VerificationBillBaseEntryInfo entry = null;
        VerificateBillTypeEnum topBillType = null;
        if (veriBill.getMainBillType().equals((Object)veriBill.getSecondBillType())) {
            isSameSide = true;
        }
        isSameCurrency = veriBill.isIsSameCurrency();
        switch (veriBill.getVerificationType().getValue()) {
            case 103: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 109: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 101: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 107: {
                topBillType = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 203: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 209: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 113: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 114: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 104: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 110: {
                topBillType = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 211: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 212: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 204: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 210: {
                topBillType = VerificateBillTypeEnum.PaymentBill;
                break;
            }
            case 201: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 207: {
                topBillType = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            default: {
                return;
            }
        }
        BigDecimal thisVeriAmtLoc = null;
        for (int i = 0; i < entrySize; ++i) {
            entry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
            thisVeriAmtLoc = entry.getThisVerificateAmtLoc();
            if (isSameSide && thisVeriAmtLoc.compareTo(BaseDataUtil.ZERO) > 0 || !isSameSide && entry.getBillType().getValue() == topBillType.getValue()) {
                topAmtLoc = topAmtLoc.add(thisVeriAmtLoc);
                topAmt = topAmt.add(entry.getThisVerificateAmt());
            } else {
                botAmtLoc = botAmtLoc.add(thisVeriAmtLoc);
            }
            if (isSameCurrency || entry.getBillType().getValue() == topBillType.getValue()) continue;
            botAmt = botAmt.add(entry.getThisVerificateAmt());
        }
        if (isSameSide) {
            mainGainAndLoss = botAmtLoc.add(topAmtLoc);
            botAmt = topAmt.negate();
        } else {
            mainGainAndLoss = botAmtLoc.subtract(topAmtLoc);
            if (isSameCurrency) {
                botAmt = topAmt;
            }
        }
        if (mainGainAndLoss.compareTo(BaseDataUtil.ZERO) != 0 && isGainLoss) {
            VerificationBillBaseEntryCollection entryColl = new VerificationBillBaseEntryCollection();
            for (int i = 0; i < entrySize; ++i) {
                entry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
                thisVeriAmtLoc = entry.getThisVerificateAmtLoc();
                if ((!isSameSide || thisVeriAmtLoc.compareTo(BaseDataUtil.ZERO) <= 0) && (isSameSide || entry.getBillType().getValue() != topBillType.getValue())) continue;
                entryColl.add(entry);
            }
            BigDecimal hasGainAndLoss = BaseDataUtil.ZERO;
            BigDecimal hasGainAndLossLoc = BaseDataUtil.ZERO;
            BigDecimal temp = null;
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal thisGainAndLoss;
                entry = (VerificationBillBaseEntryInfo)entryColl.getObject(i);
                thisVeriAmtLoc = entry.getThisVerificateAmtLoc();
                if ((!isSameSide || thisVeriAmtLoc.compareTo(BaseDataUtil.ZERO) <= 0) && (isSameSide || entry.getBillType().getValue() != topBillType.getValue())) continue;
                temp = entry.getThisVerificateAmt();
                hasGainAndLoss = hasGainAndLoss.add(temp);
                if (i == size - 1) {
                    thisGainAndLoss = mainGainAndLoss.subtract(hasGainAndLossLoc);
                } else if (topAmtLoc.compareTo(BaseDataUtil.ZERO) == 0) {
                    thisGainAndLoss = BaseDataUtil.ZERO;
                    hasGainAndLossLoc = BaseDataUtil.ZERO;
                } else {
                    thisGainAndLoss = thisVeriAmtLoc.multiply(mainGainAndLoss).divide(topAmtLoc, mainGainAndLoss.scale(), 4);
                    hasGainAndLossLoc = hasGainAndLossLoc.add(thisGainAndLoss);
                }
                if (!isGainLoss) continue;
                entry.setGainAndLoss(thisGainAndLoss);
            }
        }
        if (isGainLoss) {
            veriBill.setGainAndLoss(mainGainAndLoss);
        }
        veriBill.setMainThisVerificateAmt(topAmt);
        veriBill.setMainThisVerificateAmtLoc(topAmtLoc);
        veriBill.setSecondThisVerificateAmt(botAmt);
        veriBill.setSecondThisVerificateAmtLoc(botAmtLoc);
    }

    protected void writeBackStockTransferBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR, VerificationEnum verifyType) throws BOSException {
        StringBuilder sbEntry;
        VerificateBillTypeEnum veriBillType = VerificateBillTypeEnum.OtherReceiveBill;
        String veriType = "101,107,103,109";
        String stockBillCol = "FTotalAccountReceivable";
        String entryComCol = "FIssueCompanyOrgUnitID";
        String headComCol = "FIssueCompanyOrgUnitID";
        String veriAdd = "+";
        String billEntryTab = "T_AR_OtherBillEntry";
        String veriTabHead = "T_AR_VerificationBill";
        StringBuilder bizType1 = new StringBuilder(150);
        StringBuilder bizType2 = new StringBuilder(150);
        ArrayList<String> batchSql = new ArrayList<String>();
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt,FEntryID)").append(" \r\n ");
        if (!isAR) {
            stockBillCol = "FTotalAccountPayable";
            veriBillType = VerificateBillTypeEnum.OtherPaymentBill;
            veriType = "201,207,203,209";
            billEntryTab = "T_AP_OtherBillEntry";
            veriTabHead = "T_AP_VerificationBill";
            bizType1.append("'").append("d8e80652-0117-1000-e000-04c5c0a812202407435C").append("',");
            bizType1.append("'").append("ltQJK8kihHPgQKjAYj1jAyQHQ1w=").append("',");
            bizType1.append("'").append("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType1.append("'").append("ltQJdddQMebgQKjAYj1j1yQHQ1w=").append("'");
            bizType2.append("'").append("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=").append("'");
            entryComCol = "FReceiveCompanyOrgUnitID";
            headComCol = "FReceiptCompanyOrgUnitID";
            if (verifyType == VerificationEnum.AP_AR || verifyType == VerificationEnum.AP_AR_AB) {
                sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
                sbInnerSql.append(" From T_AR_OtherBillEntry arEntry").append(" \r\n ").append(" inner join ").append(this.verifyTempTable).append(" veriEntry ");
                sbInnerSql.append(" on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
                sbInnerSql.append(" inner join ").append(veriTabHead).append(" veriBill ");
                sbInnerSql.append(" on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
                sbInnerSql.append(" inner join T_IM_TransferOrderBillEntry stEntry ");
                sbInnerSql.append(" on stEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
                sbInnerSql.append(" inner join T_IM_TransferOrderBill orderBill ");
                sbInnerSql.append(" on stEntry.fparentid = orderBill.fid ").append(" \r\n ");
                sbInnerSql.append(" where fbillType = ").append(8).append(" \r\n ");
                sbInnerSql.append(" and veriBill.FVerificationType IN (").append(veriType).append(" \r\n ");
                sbInnerSql.append(")");
                sbInnerSql.append(" and ((veriBill.FCompanyID=stEntry.FIssueCompanyOrgUnitID");
                sbInnerSql.append(" and orderBill.FBizTypeID in (").append(bizType1.toString()).append("))").append(" \r\n ");
                sbInnerSql.append(" or (veriBill.FCompanyID=orderBill.FIssueCompanyOrgUnitID");
                sbInnerSql.append(" and orderBill.FBizTypeID IN (").append(bizType2.toString()).append(")");
                sbInnerSql.append(" )) group by arEntry.FCoreBillEntryId");
                DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
                sbEntry = new StringBuilder(300).append(" update T_IM_TransferOrderBillEntry set ");
                sbEntry.append(" (FTotalAccountReceivable, fid) = (").append(" \r\n ");
                sbEntry.append(" SELECT isnull(FTotalAccountReceivable, 0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_IM_TransferOrderBillEntry.fid ").append(" \r\n ");
                sbEntry.append(" from ").append(tempTable);
                sbEntry.append(" result ").append(" \r\n ");
                sbEntry.append(" where T_IM_TransferOrderBillEntry.fid = result.FEntryID ");
                sbEntry.append(") where T_IM_TransferOrderBillEntry.fid in ( select FEntryID from ").append(tempTable).append(")");
                batchSql.add(sbEntry.toString());
            }
        } else {
            bizType1.append("'").append("d8e80652-0117-1000-e000-04c5c0a812202407435C").append("',");
            bizType1.append("'").append("ltQJK8kihHPgQKjAYj1jAyQHQ1w=").append("'");
            bizType2.append("'").append("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJdddQMebgQKjAYj1j1yQHQ1w=").append("',");
            bizType2.append("'").append("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=").append("'");
            if (verifyType == VerificationEnum.AR_AP || verifyType == VerificationEnum.AR_AP_AB) {
                sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt,arEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
                sbInnerSql.append(" From T_AP_OtherBillEntry arEntry ").append(" \r\n ");
                sbInnerSql.append("  inner join ").append(this.verifyTempTable).append(" veriEntry ");
                sbInnerSql.append(" on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
                sbInnerSql.append(" inner join ").append(veriTabHead).append(" veriBill ");
                sbInnerSql.append(" on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
                sbInnerSql.append(" inner join T_IM_TransferOrderBillEntry stEntry ");
                sbInnerSql.append(" on stEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
                sbInnerSql.append(" inner join T_IM_TransferOrderBill orderBill ");
                sbInnerSql.append(" on stEntry.fparentid = orderBill.fid ").append(" \r\n ");
                sbInnerSql.append(" where fbillType = ").append(9).append(" \r\n ");
                sbInnerSql.append(" and veriBill.FVerificationType IN (").append(veriType);
                sbInnerSql.append(")").append(" \r\n ");
                sbInnerSql.append(" and ((veriBill.FCompanyID=stEntry.FReceiveCompanyOrgUnitID");
                sbInnerSql.append(" and orderBill.FBizTypeID in(").append(bizType1.toString()).append("))").append(" \r\n ");
                sbInnerSql.append(" or (veriBill.FCompanyID = orderBill.FReceiptCompanyOrgUnitID");
                sbInnerSql.append(" and orderBill.FBizTypeID IN (").append(bizType2.toString()).append(")");
                sbInnerSql.append(" )) group by arEntry.FCoreBillEntryId");
                DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
                sbEntry = new StringBuilder(300).append(" update T_IM_TransferOrderBillEntry set ");
                sbEntry.append(" (FTotalAccountPayable, fid) = (").append(" \r\n ");
                sbEntry.append(" SELECT isnull(FTotalAccountPayable, 0) ").append(veriAdd).append(" result.fthisVerificateAmt,T_IM_TransferOrderBillEntry.fid ").append(" \r\n ");
                sbEntry.append(" from ").append(tempTable);
                sbEntry.append(" result ").append(" \r\n ");
                sbEntry.append(" where T_IM_TransferOrderBillEntry.fid = result.FEntryID ").append(" \r\n ");
                sbEntry.append(") where T_IM_TransferOrderBillEntry.fid in ( select FEntryID from ").append(tempTable).append(")");
                batchSql.add(sbEntry.toString());
            }
        }
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
        sbInnerSql.append(" From ").append(billEntryTab).append(" arEntry ").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(this.verifyTempTable).append(" veriEntry ");
        sbInnerSql.append(" on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(veriTabHead).append(" veriBill ");
        sbInnerSql.append(" on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        sbInnerSql.append(" inner join T_IM_TransferOrderBillEntry stEntry ");
        sbInnerSql.append(" on stEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_IM_TransferOrderBill orderBill ");
        sbInnerSql.append(" on stEntry.fparentid = orderBill.fid ").append(" \r\n ");
        sbInnerSql.append(" where veriEntry.fbillType = ").append(veriBillType.getValue()).append(" \r\n ");
        sbInnerSql.append(" and veriBill.FVerificationType IN (").append(veriType).append(")");
        sbInnerSql.append(" and ((veriBill.FCompanyID=stEntry.").append(entryComCol);
        sbInnerSql.append(" and orderBill.FBizTypeID in (").append(bizType1.toString()).append("))").append(" \r\n ");
        sbInnerSql.append(" or (veriBill.FCompanyID = orderBill.").append(headComCol);
        sbInnerSql.append(" and orderBill.FBizTypeID IN (").append(bizType2.toString()).append(")");
        sbInnerSql.append(" )) group by arEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry2 = new StringBuilder(300);
        sbEntry2.append(" update T_IM_TransferOrderBillEntry set ");
        sbEntry2.append(" (").append(stockBillCol).append(",fid) = (").append(" \r\n ");
        sbEntry2.append(" SELECT isnull(").append(stockBillCol).append(",0) ").append(veriAdd).append(" result.fthisVerificateAmt,T_IM_TransferOrderBillEntry.fid ");
        sbEntry2.append(" from ").append(tempTable2).append(" result ").append(" \r\n ");
        sbEntry2.append(" where T_IM_TransferOrderBillEntry.fid = result.FEntryID ");
        sbEntry2.append(") where T_IM_TransferOrderBillEntry.fid in (select FEntryID from ").append(tempTable2).append(")");
        batchSql.add(sbEntry2.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
    }

    private IObjectPK writeLog(Context ctx, IObjectPK billPK, VerificationBillBaseInfo billInfo) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        coll.addObject((IObjectValue)billInfo);
        IObjectPK[] pks = this.batchWriteLog(ctx, billPK, (IObjectCollection)coll);
        if (null != pks) {
            return pks[0];
        }
        return null;
    }

    private IObjectPK[] batchWriteLog(Context ctx, IObjectPK billPK, IObjectCollection coll) throws BOSException, EASBizException {
        if (null == coll) {
            return null;
        }
        ArrayList<IObjectPK> pks = new ArrayList<IObjectPK>(coll.size());
        BOSObjectType bostype = coll.getObject(0).getBOSType();
        Map<VerificationEnum, StringBuilder> typeMap = this.splitByVerificatonType(coll, null);
        boolean isSingle = coll.size() == 1;
        for (VerificationEnum billType : typeMap.keySet()) {
            String logItemName = null;
            if (billType.equals((Object)VerificationEnum.AP_Pay) || billType.equals((Object)VerificationEnum.AP_Pay_AB)) {
                logItemName = "fi_ap_PurVerify";
            } else if (billType.equals((Object)VerificationEnum.AP_AR) || billType.equals((Object)VerificationEnum.AP_AR_AB)) {
                logItemName = "fi_ap_ApVerifyAr";
            } else if (billType.equals((Object)VerificationEnum.Pay_Rec) || billType.equals((Object)VerificationEnum.Pay_Rec_AB)) {
                logItemName = "fi_ap_PayVerifyRec";
            } else if (billType.equals((Object)VerificationEnum.PrePay_PreRec) || billType.equals((Object)VerificationEnum.PrePay_PreRec_AB)) {
                logItemName = "fi_ap_PrePayVerifyPreRec";
            } else if (billType.equals((Object)VerificationEnum.AR_Rec) || billType.equals((Object)VerificationEnum.AR_Rec_AB)) {
                logItemName = "fi_ar_RecVerify";
            } else if (billType.equals((Object)VerificationEnum.AR_AP) || billType.equals((Object)VerificationEnum.AR_AP_AB)) {
                logItemName = "fi_ar_ArVerifyAp";
            } else if (billType.equals((Object)VerificationEnum.Rec_Pay) || billType.equals((Object)VerificationEnum.Rec_Pay_AB)) {
                logItemName = "fi_ar_RecVerifyPay";
            } else if (billType.equals((Object)VerificationEnum.PreRec_PrePay) || billType.equals((Object)VerificationEnum.PreRec_PrePay_AB)) {
                logItemName = "fi_ar_PreRecVerifyPrePay";
            }
            if (isSingle) {
                pks.add(LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bostype, (IObjectPK)billPK, (String)typeMap.get(billType).toString(), (String)logItemName));
                continue;
            }
            pks.add(LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bostype, null, (String)typeMap.get(billType).toString(), (String)logItemName));
        }
        return pks.toArray(new IObjectPK[pks.size()]);
    }

    protected void recycleNum(Context ctx, String ids, boolean isAr) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        StringBuffer selStr = new StringBuffer();
        VerificationBillBaseInfo billInfo = null;
        String headTB = null;
        if (isAr) {
            billInfo = new VerificationBillInfo();
            headTB = "T_AR_VERIFICATIONBILL";
        } else {
            billInfo = new com.kingdee.eas.fi.ap.VerificationBillInfo();
            headTB = "T_AP_VERIFICATIONBILL";
        }
        selStr.append("Select Fnumber, FCompanyID ");
        selStr.append(" FROM ");
        selStr.append(headTB);
        selStr.append(" WHERE ");
        selStr.append(" FID IN (");
        selStr.append(ids);
        selStr.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selStr.toString());
        try {
            ArrayList<String> list = new ArrayList<String>();
            CodingRuleInfo codeRuleInfo = null;
            boolean isRecycleNumber = false;
            String companyId = null;
            while (rowSet.next()) {
                if (codeRuleInfo == null) {
                    companyId = rowSet.getString(2);
                    codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)billInfo, companyId);
                    if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)billInfo, companyId) || codeRuleInfo != null && codeRuleInfo.isIsaddnewbreak()) {
                        isRecycleNumber = true;
                    }
                }
                list.add(rowSet.getString(1));
            }
            if (isRecycleNumber) {
                iCodingRuleManager.recycleBatchNumber((IObjectValue)billInfo, companyId, list.toArray(new String[list.size()]));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected IObjectPK writeUnVeriLog(Context ctx, String ids, boolean isAR) throws BOSException {
        String logItem = null;
        logItem = isAR ? "fi_ar_Verify_Unverify" : "fi_ap_Verify_unVerification";
        return this.writeLog(ctx, ids, logItem, isAR);
    }

    protected IObjectPK writeVoucherLog(Context ctx, String ids, boolean isAR) throws BOSException {
        String logItem = null;
        logItem = isAR ? "fi_ar_Verify_GenVoucher" : "fi_ap_Verify_GenVoucher";
        return this.writeLog(ctx, ids, logItem, isAR);
    }

    private IObjectPK writeLog(Context ctx, String ids, String logItem, boolean isAR) throws BOSException {
        VerificationBillBaseInfo bill = null;
        String oql = "select number where id in(" + ids + ")";
        StringBuffer sbNumber = new StringBuffer();
        CoreBaseCollection coll = this.getCollection(ctx, oql);
        for (int i = 0; i < coll.size(); ++i) {
            bill = (VerificationBillBaseInfo)coll.getObject(i);
            sbNumber.append(bill.getNumber());
            sbNumber.append(",");
        }
        if (sbNumber.length() > 0) {
            sbNumber.deleteCharAt(sbNumber.length() - 1);
        }
        if (bill != null) {
            return LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bill.getBOSType(), null, (String)sbNumber.toString(), (String)logItem);
        }
        return null;
    }

    protected void writeBackArApBillPlan(Context ctx, String ids, boolean veriOrUnVeri) throws BOSException, EASBizException {
        int i;
        int size;
        CoreBaseCollection coreBaseColl;
        ArApBillBaseInfo otherBillInfo;
        AbstractObjectCollection otherBillColl;
        FilterItemInfo idFilter;
        FilterInfo fiterInfo;
        EntityViewInfo view;
        IArApBillPlanBase iBillPlan;
        IArApBillBase iBill;
        HashSet<String> arSet = new HashSet<String>();
        HashSet<String> apSet = new HashSet<String>();
        this.setVerifyTempTable(ctx, ids);
        String id = null;
        StringBuilder veriSb = new StringBuilder(150);
        veriSb.append("select fbillType, FbillID");
        veriSb.append(" from ");
        veriSb.append(this.verifyTempTable).append(" \r\n ");
        veriSb.append(" WHERE fbillType in (").append(8);
        veriSb.append(",").append(9).append(")");
        veriSb.append(" group by FbillID, fbillType ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)veriSb.toString());
        try {
            while (rowSet.next()) {
                id = rowSet.getString(2);
                if (id == null || "".equals(id)) continue;
                if (rowSet.getInt(1) == 8) {
                    arSet.add(id);
                    continue;
                }
                apSet.add(id);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (arSet.size() > 0) {
            iBill = OtherBillFactory.getLocalInstance(ctx);
            iBillPlan = OtherBillPlanFactory.getLocalInstance(ctx);
            view = new EntityViewInfo();
            fiterInfo = new FilterInfo();
            idFilter = new FilterItemInfo("id", arSet, CompareType.INCLUDE);
            fiterInfo.getFilterItems().add(idFilter);
            view.setFilter(fiterInfo);
            view.getSelector().add(new SelectorItemInfo("recievePlan.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayDate"));
            view.getSelector().add(new SelectorItemInfo("verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.amount"));
            view.getSelector().add(new SelectorItemInfo("entry.taxAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
            otherBillColl = iBill.getOtherBillCollection(view);
            otherBillInfo = null;
            coreBaseColl = new CoreBaseCollection();
            size = otherBillColl.size();
            for (i = 0; i < size; ++i) {
                otherBillInfo = otherBillColl.get(i);
                otherBillInfo.verifyPlan();
                coreBaseColl.addObjectCollection((IObjectCollection)((AbstractOtherBillInfo)otherBillInfo).getRecievePlan());
            }
            iBillPlan.update(coreBaseColl);
        }
        if (apSet.size() > 0) {
            iBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
            iBillPlan = com.kingdee.eas.fi.ap.OtherBillPlanFactory.getLocalInstance(ctx);
            view = new EntityViewInfo();
            fiterInfo = new FilterInfo();
            idFilter = new FilterItemInfo("id", apSet, CompareType.INCLUDE);
            fiterInfo.getFilterItems().add(idFilter);
            view.setFilter(fiterInfo);
            view.getSelector().add(new SelectorItemInfo("payPlan.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("payPlan.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("payPlan.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("payPlan.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("payPlan.recievePayDate"));
            view.getSelector().add(new SelectorItemInfo("verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.amount"));
            view.getSelector().add(new SelectorItemInfo("entry.taxAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
            otherBillColl = iBill.getOtherBillCollection(view);
            otherBillInfo = null;
            coreBaseColl = new CoreBaseCollection();
            size = otherBillColl.size();
            for (i = 0; i < size; ++i) {
                otherBillInfo = otherBillColl.get(i);
                otherBillInfo.verifyPlan();
                coreBaseColl.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.AbstractOtherBillInfo)otherBillInfo).getPayPlan());
            }
            iBillPlan.update(coreBaseColl);
        }
    }

    private void releaseTempTable(Context ctx) {
        if (null != this.verifyTempTable) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.verifyTempTable);
        }
    }

    private void setVerifyTempTable(Context ctx, String ids) throws BOSException {
        if (this.cacheIds.contains(ids) && null != this.verifyTempTable) {
            return;
        }
        this.cacheIds.clear();
        this.releaseTempTable(ctx);
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            this.verifyTempTable = t.createTempTable(verifyTempTableDefine);
            this.cacheIds.add(ids);
            t.createIndex(this.verifyTempTable, "FBillID", false, false);
            t.createIndex(this.verifyTempTable, "FEntryID", false, false);
            t.createIndex(this.verifyTempTable, "FParentID", false, false);
        }
        catch (Exception e) {
            logger.error((Object)"create tempTable or index error", (Throwable)e);
        }
        StringBuilder buf = new StringBuilder(600).append("INSERT INTO ").append(this.verifyTempTable).append(" \r\n ").append(" (FBillID, FEntryID, FThisVerificateAmt, FThisVerificateAmtLoc, FIsFromBOTP, fisPreVerify, FBillType, FParentID)").append(" \r\n ").append(" SELECT FBillID, FEntryID, FThisVerificateAmt, FThisVerificateAmtLoc, FIsFromBOTP, fisPreVerify, FBillType, FParentID").append(" \r\n ").append(" FROM ").append(this.entryTab);
        SCMSqlUtil.Result rs = SCMSqlUtil.convertIds((Context)ctx, (String)ids.replace("'", "").replace(" ", ""));
        if (SCMSqlUtil.resultTypeEnum.simple.equals((Object)rs.getResultType())) {
            buf.append(" Where FParentID in (").append(rs.getPlaceholder()).append(") ");
            DBUtil.execute((Context)ctx, (String)buf.toString(), (Object[])rs.getParameters());
        } else if (SCMSqlUtil.resultTypeEnum.complex.equals((Object)rs.getResultType())) {
            buf.append(" entry INNER JOIN ").append(rs.getTempTable()).append(" tmp ON entry.FParentID = tmp.fid");
            DBUtil.execute((Context)ctx, (String)buf.toString());
            SCMSqlUtil.releasTempTable((Context)ctx, (String)rs.getTempTable());
        } else {
            throw new BOSException(rs.getErrorMsg());
        }
    }

    protected void writeBackArOtherBill(Context ctx, Object obj_FromBOTP, String ids, boolean veriOrUnVeri, boolean needCalcLockAmt) throws BOSException, EASBizException {
        String rt = " \r\n";
        String veriAdd = "+";
        String veriSub = "-";
        if (!veriOrUnVeri) {
            veriAdd = "-";
            veriSub = "+";
        }
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuffer arVerifyEnumList = new StringBuffer(200);
        arVerifyEnumList.append(" where ve.FBillType in (").append(2);
        arVerifyEnumList.append(" ,").append(11);
        arVerifyEnumList.append(" ,").append(8);
        arVerifyEnumList.append(") ");
        this.setVerifyTempTable(ctx, ids);
        StringBuilder strSQL = new StringBuilder(600);
        strSQL.append("Update T_AR_Otherbill set (FVerifyAmount,FVerifyAmountLocal,FUnVerifyAmount,FUnVerifyAmountLocal) = ").append(rt);
        strSQL.append("(\tSelect \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\tisnull(FVerifyAmount,0)\t\t").append(veriAdd).append("result.FThisVerificateAmt,\t").append(rt);
        strSQL.append("\t\t\tisnull(FVerifyAmountLocal,0)\t").append(veriAdd).append("result.FThisVerificateAmtLoc,").append(rt);
        strSQL.append("\t\t\tisnull(FUnVerifyAmount,0)\t\t").append(veriSub).append("result.FThisVerificateAmt ,\t").append(rt);
        strSQL.append("\t\t\tisnull(FUnVerifyAmountLocal,0) ").append(veriSub).append("result.FThisVerificateAmtLoc\t").append(rt);
        strSQL.append("\t\tFrom\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FBillId,\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\t\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(arVerifyEnumList.toString()).append(rt);
        strSQL.append("\t\t\tGroup by ve.FBillId) result\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tWhere result.FBillId = T_AR_Otherbill.FID \t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append("Update T_Ar_Otherbillentry set \t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmount, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmountLocal, \t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmount, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmountLocal \t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tisnull(FVerifyAmount,0)\t\t").append(veriAdd).append("result.FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\tisnull(FVerifyAmountLocal,0)\t").append(veriAdd).append("result.FThisVerificateAmtLoc,\t").append(rt);
        strSQL.append("\t\tisnull(FUnVerifyAmount,0)\t\t").append(veriSub).append("result.FThisVerificateAmt ,\t\t").append(rt);
        strSQL.append("\t\tisnull(FUnVerifyAmountLocal,0) ").append(veriSub).append("result.FThisVerificateAmtLoc\t\t").append(rt);
        strSQL.append("\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t(select result1.FEntryID FEntryID,sum(result1.FThisVerificateAmt) FThisVerificateAmt ").append(rt);
        strSQL.append("\t,sum(result1.FThisVerificateAmtLoc) FThisVerificateAmtLoc").append(rt);
        strSQL.append(" from (select\t\t \t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t").append(rt);
        strSQL.append("\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t\t\t").append(rt);
        strSQL.append("\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc \t\t").append(rt);
        strSQL.append("\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(arVerifyEnumList.toString()).append(rt);
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") as result1\tgroup by result1.FEntryID) \tresult\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_Ar_Otherbillentry.FID);\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append(" update T_AR_Otherbill set (FverifyStatus) = ( ").append(rt);
        strSQL.append(" \tSelect (case when (isnull(result.FAmount,0) = 0 and result.FBillStatus =  ").append(3).append(rt);
        strSQL.append(" \tor isnull(result.FAmount,0) <> 0 and isnull(result.FunVerifyAmount,0) = 0) then ").append(3).append(rt);
        strSQL.append(" \twhen (isnull(result.FAmount,0) = 0 and result.FBillStatus <>  ").append(3).append(rt);
        strSQL.append(" \tor isnull(result.FAmount,0) <> 0 and isnull(result.FVerifyAmount,0) = 0) then ").append(1).append(rt);
        strSQL.append(" \telse ").append(2).append(" end) ").append(rt);
        strSQL.append(" \tfrom( ").append(rt);
        strSQL.append(" \t\tselect bill.fid as fBillId,bill.FBillStatus as FBillStatus ").append(rt);
        strSQL.append(" \t\t, max(abs(isnull(entry.FRecievePayAmount,0))) as famount  ").append(rt);
        strSQL.append(" \t\t,max(abs(isnull(entry.FunVerifyAmount,0))) as FunVerifyAmount ").append(rt);
        strSQL.append(" \t\t,max(abs(isnull(entry.FVerifyAmount,0))) as  FVerifyAmount  ").append(rt);
        strSQL.append(" \t\tfrom ").append(this.verifyTempTable).append(" ve  ").append(rt);
        strSQL.append(" \t\tinner join T_AR_Otherbill bill on bill.fid = ve.fBillId ").append(rt);
        strSQL.append(" \t\tinner join T_AR_OtherbillEntry entry on entry.FParentID = bill.fid ").append(rt);
        strSQL.append(arVerifyEnumList.toString()).append(rt);
        strSQL.append("      \tgroup by bill.fid,bill.FBillStatus ").append(rt);
        strSQL.append(" \t) as result  ").append(rt);
        strSQL.append(" \twhere result.FBillId =  T_AR_Otherbill.fid ").append(rt);
        strSQL.append(" ) ").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append("Update T_Ar_Otherbillentry set \t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(" FLockVerifyAmt, ").append(rt);
        strSQL.append("\tFLockVerifyAmtLocal,").append(rt);
        strSQL.append("\tFLockUnVerifyAmt,").append(rt);
        strSQL.append("\tFLockUnVerifyAmtLocal\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(" FLockVerifyAmt ").append(veriAdd).append(" result.FLockVerifyAmt1,\t \t").append(rt);
        strSQL.append("\tFLockVerifyAmtLocal  ").append(veriAdd).append(" result.FLockVerifyAmtLocal1 ,\t").append(rt);
        strSQL.append("\tFLockUnVerifyAmt\t ").append(veriSub).append("result.FLockUnVerifyAmt1 ,\t\t").append(rt);
        strSQL.append("\tFLockUnVerifyAmtLocal").append(veriSub).append("result.FLockUnVerifyAmtLocal1\t").append(rt);
        strSQL.append("\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t(select result1.FEntryID FEntryID ").append(rt);
        strSQL.append(" ,sum(result1.FLockVerifyAmt) FLockVerifyAmt1 ").append(rt);
        strSQL.append(" ,sum(result1.FLockVerifyAmtLocal) FLockVerifyAmtLocal1 ").append(rt);
        strSQL.append(",sum(result1.FLockUnVerifyAmt) FLockUnVerifyAmt1 ").append(rt);
        strSQL.append(",sum(result1.FLockUnVerifyAmtLocal) FLockUnVerifyAmtLocal1 ").append(rt);
        strSQL.append(" from (select\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP\t\t\t\t\t\t").append(rt);
        if (needCalcLockAmt) {
            strSQL.append(",sum(ve.FThisVerificateAmt) FLockVerifyAmt").append(rt);
            strSQL.append(" ,sum(ve.FThisVerificateAmtLoc)  FLockVerifyAmtLocal").append(rt);
            strSQL.append(",sum(ve.FThisVerificateAmt) FLockUnVerifyAmt  ").append(rt);
            strSQL.append(",sum(ve.FThisVerificateAmtLoc) FLockUnVerifyAmtLocal   ").append(rt);
        } else {
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmt else 0 end) FLockVerifyAmt").append(rt);
            strSQL.append(" ,sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmtLoc else 0 end)  FLockVerifyAmtLocal").append(rt);
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmt else 0 end) FLockUnVerifyAmt  ").append(rt);
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmtLoc else 0 end) FLockUnVerifyAmtLocal   ").append(rt);
        }
        strSQL.append("\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(arVerifyEnumList.toString()).append(rt);
        if (!needCalcLockAmt) {
            strSQL.append(" and fisPreVerify = 0 ").append(rt);
        }
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") as result1\tgroup by result1.FEntryID) \tresult\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_Ar_Otherbillentry.FID);\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        boolean isAr = true;
        this.checkAmtAfterVerify(ctx, ids, veriOrUnVeri, isAr);
    }

    protected void writeBackApOtherBill(Context ctx, Object obj_FromBOTP, String ids, boolean veriOrUnVeri, boolean needCalcLockAmt) throws BOSException, EASBizException {
        String rt = " \r\n";
        String veriAdd = "+";
        String veriSub = "-";
        if (!veriOrUnVeri) {
            veriAdd = "-";
            veriSub = "+";
        }
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuilder apVerifyEnumList = new StringBuilder(100);
        apVerifyEnumList.append(" WHERE ve.FBillType in( ").append(0);
        apVerifyEnumList.append(" ,").append(10);
        apVerifyEnumList.append(" , ").append(9);
        apVerifyEnumList.append(" , ").append(17);
        apVerifyEnumList.append(") ").append(" \r\n ");
        this.setVerifyTempTable(ctx, ids);
        StringBuilder strSQL = new StringBuilder(600);
        strSQL.append("Update T_AP_Otherbill set \t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmount, \t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmountLocal, \t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmount, \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmountLocal \t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tSelect \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\tisnull(FVerifyAmount,0) \t \t ").append(veriAdd).append(" result.FThisVerificateAmt,\t ").append(rt);
        strSQL.append("\t\t\tisnull(FVerifyAmountLocal,0) \t ").append(veriAdd).append(" result.FThisVerificateAmtLoc,").append(rt);
        strSQL.append("\t\t\tisnull(FUnVerifyAmount,0) \t ").append(veriSub).append(" result.FThisVerificateAmt ,").append(rt);
        strSQL.append("\t\t\tisnull(FUnVerifyAmountLocal,0) ").append(veriSub).append(" result.FThisVerificateAmtLoc").append(rt);
        strSQL.append("\t\tFrom\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FBillId,\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(apVerifyEnumList.toString()).append(rt);
        strSQL.append("\t\t\tGroup by ve.FBillId) result\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tWhere result.FBillId = T_AP_Otherbill.FID \t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append("Update T_AP_Otherbillentry set \t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmount, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFVerifyAmountLocal, \t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmount, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFUnVerifyAmountLocal \t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tisnull(FVerifyAmount,0)\t\t").append(veriAdd).append(" result.FThisVerificateAmt, \t\t").append(rt);
        strSQL.append("\t\tisnull(FVerifyAmountLocal,0)  ").append(veriAdd).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FUnVerifyAmount,0) \t").append(veriSub).append(" result.FThisVerificateAmt ,\t\t").append(rt);
        strSQL.append("\t\tisnull(FUnVerifyAmountLocal,0) ").append(veriSub).append(" result.FThisVerificateAmtLoc\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t(select result1.FEntryID FEntryID,sum(result1.FThisVerificateAmt) FThisVerificateAmt ").append(rt);
        strSQL.append("\t,sum(result1.FThisVerificateAmtLoc) FThisVerificateAmtLoc ").append(rt);
        strSQL.append(" from (select\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(apVerifyEnumList.toString()).append(rt);
        strSQL.append("\t\t\tGroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") as result1\tgroup by result1.FEntryID) \tresult\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_AP_Otherbillentry.FID\t\t\t\t\t").append(rt);
        strSQL.append(");\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append(" update T_AP_Otherbill set (FverifyStatus) = ( ").append(rt);
        strSQL.append(" \tSelect (case when (isnull(result.FAmount,0) = 0 and result.FBillStatus =  ").append(3).append(rt);
        strSQL.append(" \tor isnull(result.FAmount,0) <> 0 and isnull(result.FunVerifyAmount,0) = 0) then ").append(3).append(rt);
        strSQL.append(" \twhen (isnull(result.FAmount,0) = 0 and result.FBillStatus <>  ").append(3).append(rt);
        strSQL.append(" \tor isnull(result.FAmount,0) <> 0 and isnull(result.FVerifyAmount,0) = 0) then ").append(1).append(rt);
        strSQL.append(" \telse ").append(2).append(" end) ").append(rt);
        strSQL.append(" \tfrom( ").append(rt);
        strSQL.append(" \t\tselect bill.fid as fBillId,bill.FBillStatus as FBillStatus ").append(rt);
        strSQL.append(" \t\t, max(abs(isnull(entry.FRecievePayAmount,0))) as famount  ").append(rt);
        strSQL.append(" \t\t,max(abs(isnull(entry.FunVerifyAmount,0))) as FunVerifyAmount ").append(rt);
        strSQL.append(" \t\t,max(abs(isnull(entry.FVerifyAmount,0))) as  FVerifyAmount  ").append(rt);
        strSQL.append(" \t\tfrom ").append(this.verifyTempTable).append(" ve  ").append(rt);
        strSQL.append(" \t\tinner join T_AP_Otherbill bill on bill.fid = ve.fBillId ").append(rt);
        strSQL.append(" \t\tinner join T_AP_OtherbillEntry entry on entry.FParentID = bill.fid ").append(rt);
        strSQL.append(apVerifyEnumList.toString()).append(rt);
        strSQL.append("      \tgroup by bill.fid,bill.FBillStatus ").append(rt);
        strSQL.append(" \t) as result  ").append(rt);
        strSQL.append(" \twhere result.FBillId =  T_AP_Otherbill.fid ").append(rt);
        strSQL.append(" ) ").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append("Update T_AP_Otherbillentry set \t\t\t\t\t\t").append(rt);
        strSQL.append(" (\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(" FLockVerifyAmt, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tFLockVerifyAmtLocal, \t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tFLockUnVerifyAmt, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tFLockUnVerifyAmtLocal \t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(" FLockVerifyAmt \t\t").append(veriAdd).append("result.FLockVerifyAmt1  ,").append(rt);
        strSQL.append("\tFLockVerifyAmtLocal ").append(veriAdd).append(" result.FLockVerifyAmtLocal1,").append(rt);
        strSQL.append("\tFLockUnVerifyAmt \t  ").append(veriSub).append(" result.FLockUnVerifyAmt1,").append(rt);
        strSQL.append("\tFLockUnVerifyAmtLocal ").append(veriSub).append(" result.FLockUnVerifyAmtLocal1\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t(select result1.FEntryID FEntryID ").append(rt);
        strSQL.append(" ,sum(result1.FLockVerifyAmt) FLockVerifyAmt1 ").append(rt);
        strSQL.append(" ,sum(result1.FLockVerifyAmtLocal) FLockVerifyAmtLocal1 ").append(rt);
        strSQL.append(",sum(result1.FLockUnVerifyAmt) FLockUnVerifyAmt1 ").append(rt);
        strSQL.append(",sum(result1.FLockUnVerifyAmtLocal) FLockUnVerifyAmtLocal1 ").append(rt);
        strSQL.append(" from (select\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        String tempVerifyTempTable = null;
        if (needCalcLockAmt) {
            String AP2PayVerifyIdStr = ArApBillHelper.ids2SqlString(this.getAP2PayVerifyIdSet(ctx, ids));
            if (!StringUtils.isEmpty((String)AP2PayVerifyIdStr)) {
                TempTablePool t = TempTablePool.getInstance((Context)ctx);
                try {
                    tempVerifyTempTable = t.createTempTable(verifyTempTableDefine);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                StringBuilder sql = new StringBuilder(100);
                sql.append(" insert into ").append(tempVerifyTempTable).append(" select * from ").append(this.verifyTempTable).append(" where FParentID in (").append(AP2PayVerifyIdStr).append(")");
                DBUtil.execute(ctx, new String[]{sql.toString()});
                strSQL.append(",sum(ve.FThisVerificateAmt) FLockVerifyAmt").append(rt);
                strSQL.append(",sum(ve.FThisVerificateAmtLoc)  FLockVerifyAmtLocal").append(rt);
                strSQL.append(",sum(ve.FThisVerificateAmt) FLockUnVerifyAmt  ").append(rt);
                strSQL.append(",sum(ve.FThisVerificateAmtLoc) FLockUnVerifyAmtLocal   ").append(rt);
            } else {
                strSQL.append(",0 FLockVerifyAmt ").append(rt);
                strSQL.append(",0 FLockVerifyAmtLocal ").append(rt);
                strSQL.append(",0 FLockUnVerifyAmt ").append(rt);
                strSQL.append(",0 FLockUnVerifyAmtLocal ").append(rt);
            }
        } else {
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmt else 0 end) FLockVerifyAmt").append(rt);
            strSQL.append(" ,sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmtLoc else 0 end)  FLockVerifyAmtLocal").append(rt);
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmt else 0 end) FLockUnVerifyAmt  ").append(rt);
            strSQL.append(",sum(case when isnull(ve.FIsFromBOTP,0) = 0 then ve.FThisVerificateAmtLoc else 0 end) FLockUnVerifyAmtLocal   ").append(rt);
        }
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        if (tempVerifyTempTable != null) {
            strSQL.append(tempVerifyTempTable).append(rt);
        } else {
            strSQL.append(this.verifyTempTable).append(rt);
        }
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(apVerifyEnumList.toString()).append(rt);
        if (!needCalcLockAmt) {
            strSQL.append(" and fisPreVerify = 0 ").append(rt);
        }
        strSQL.append("\t\t\tGroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") as result1\tgroup by result1.FEntryID) \tresult\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_AP_Otherbillentry.FID\t\t\t\t\t").append(rt);
        strSQL.append(");\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        boolean isAr = false;
        this.checkAmtAfterVerify(ctx, ids, veriOrUnVeri, isAr);
        if (tempVerifyTempTable != null) {
            DBUtil.releaseTempTable(ctx, tempVerifyTempTable);
        }
    }

    protected void writeBackReceiveBill(Context ctx, String ids, boolean veriOrUnVeri, boolean needCalcLockAmt) throws BOSException, EASBizException {
        String rt = " \r\n";
        String veriAdd = "+";
        String veriSub = "-";
        if (!veriOrUnVeri) {
            veriAdd = "-";
            veriSub = "+";
        }
        this.setVerifyTempTable(ctx, ids);
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_CAS_ReceivingBill set ").append(rt);
        strSQL.append("(FVerifiedAmt,").append(rt);
        strSQL.append("FVerifiedAmtLoc,FUnVerifiedAmt,FUnVerifiedAmtLoc ").append(rt);
        strSQL.append(") =").append(rt);
        strSQL.append("(").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tisnull(FVerifiedAmt,0) \t \t ").append(veriAdd).append(" result.FThisVerificateAmt,\t ").append(rt);
        strSQL.append("\tisnull(FVerifiedAmtLoc,0) \t ").append(veriAdd).append(" result.FThisVerificateAmtLoc,").append(rt);
        strSQL.append("\tisnull(FUnVerifiedAmt,0) \t \t ").append(veriSub).append(" result.FThisVerificateAmt,\t ").append(rt);
        strSQL.append("\tisnull(FUnVerifiedAmtLoc,0) \t ").append(veriSub).append(" result.FThisVerificateAmtLoc").append(rt);
        strSQL.append("\tFrom\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FBillId,\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere ve.FBillType = ").append(new Integer(6)).append(rt);
        strSQL.append("\t\t\tGroup by ve.FBillId) result\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tWhere result.FBillId = T_CAS_ReceivingBill.FID \t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append(" update T_CAS_ReceivingBill set (FverifyStatus) = ").append(rt);
        strSQL.append(" (Select (case when isnull(FVerifiedAmt,0) = 0 then ").append(1);
        strSQL.append(" when isnull(FUnVerifiedAmt,0) = 0 then ").append(3);
        strSQL.append(" else ").append(2).append(" end) ");
        strSQL.append(" from(select distinct ve.fBillId as fBillId ");
        strSQL.append(" from  ");
        strSQL.append(this.verifyTempTable);
        strSQL.append(" ve ");
        strSQL.append("\twhere ve.FBillType = ").append(new Integer(6));
        strSQL.append(" ) as result");
        strSQL.append(" where result.FBillId =  T_CAS_ReceivingBill.fid)");
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append("Update T_CAS_ReceivingBillEntry set \t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFAmountVc, \t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFLocalAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunVcAmount, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunVcLocAmount, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFactualAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFactualLocAmtVc, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFrebateAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFrebateLocAmtVc \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tisnull(FAmountVc,0) \t\t").append(veriAdd).append(" result.FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\tisnull(FLocalAmtVc,0)\t\t").append(veriAdd).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FunVcAmount,0) \t").append(veriSub).append(" result.FThisVerificateAmt ,\t\t").append(rt);
        strSQL.append("\t\tisnull(FunVcLocAmount,0)  ").append(veriSub).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FactualAmtVc,0) \t").append(veriAdd).append(" result.FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\tisnull(FactualLocAmtVc,0) ").append(veriAdd).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FrebateAmtVc,0) \t").append(veriAdd).append(" result.FThisVerificateAmt , \t").append(rt);
        strSQL.append("\t\tisnull(FrebateLocAmtVc,0) ").append(veriAdd).append(" result.FThisVerificateAmtLoc \t").append(rt);
        strSQL.append("\t\t From \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc \t\t\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tWhere ve.FBillType = ").append(new Integer(6)).append(rt);
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t)as result\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_CAS_ReceivingBillEntry.FID\t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append("Update T_CAS_ReceivingBillEntry set \t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFlockAmt, \t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFLockLocAmt, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunLockAmt, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunLockLocAmt \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        if (needCalcLockAmt) {
            strSQL.append("\t\tisnull(FlockAmt,0) \t\t").append(veriAdd).append(" result.FThisVerificateAmt, ").append(rt);
            strSQL.append("\t\tisnull(FLockLocAmt,0) \t").append(veriAdd).append(" result.FThisVerificateAmtLoc,").append(rt);
            strSQL.append("\t\tisnull(FunLockAmt,0) \t\t").append(veriSub).append(" result.FThisVerificateAmt , ").append(rt);
            strSQL.append("\t\tisnull(FunLockLocAmt,0)\t").append(veriSub).append(" result.FThisVerificateAmtLoc\t").append(rt);
        } else {
            strSQL.append("\t\tisnull(FlockAmt,0) \t\t").append(veriAdd).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmt else 0 end, ").append(rt);
            strSQL.append("\t\tisnull(FLockLocAmt,0) \t").append(veriAdd).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmtLoc else 0 end,").append(rt);
            strSQL.append("\t\tisnull(FunLockAmt,0) \t\t").append(veriSub).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmt else 0 end , ").append(rt);
            strSQL.append("\t\tisnull(FunLockLocAmt,0)\t").append(veriSub).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmtLoc else 0 end\t").append(rt);
        }
        strSQL.append("\t\t From \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc \t\t\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tWhere ve.FBillType = ").append(new Integer(6)).append(rt);
        if (!needCalcLockAmt) {
            strSQL.append(" and fisPreVerify = 0 ").append(rt);
        }
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t)as result\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_CAS_ReceivingBillEntry.FID\t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.checkAmtAfterVerifyForRecPay(ctx, ids, veriOrUnVeri, true);
    }

    protected void writeBackPaymentBill(Context ctx, String ids, boolean veriOrUnVeri, boolean needCalcLockAmt) throws BOSException, EASBizException {
        String rt = " \r\n";
        String veriAdd = "+";
        String veriSub = "-";
        if (!veriOrUnVeri) {
            veriAdd = "-";
            veriSub = "+";
        }
        this.setVerifyTempTable(ctx, ids);
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuilder strSQL = new StringBuilder(500);
        strSQL.append("Update T_CAS_PaymentBill set ").append(rt);
        strSQL.append("(FVerifiedAmt,").append(rt);
        strSQL.append("FVerifiedAmtLoc,FUnVerifiedAmt,FUnVerifiedAmtLoc ").append(rt);
        strSQL.append(") =").append(rt);
        strSQL.append("(").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tisnull(FVerifiedAmt,0) \t \t ").append(veriAdd).append(" result.FThisVerificateAmt,\t ").append(rt);
        strSQL.append("\tisnull(FVerifiedAmtLoc,0) \t ").append(veriAdd).append(" result.FThisVerificateAmtLoc,").append(rt);
        strSQL.append("\tisnull(FUnVerifiedAmt,0) \t \t ").append(veriSub).append(" result.FThisVerificateAmt,\t ").append(rt);
        strSQL.append("\tisnull(FUnVerifiedAmtLoc,0) \t ").append(veriSub).append(" result.FThisVerificateAmtLoc").append(rt);
        strSQL.append("\tFrom\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FBillId,\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc ").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t \tWhere ve.FBillType = ").append(new Integer(4)).append(rt);
        strSQL.append("\t\tGroup by ve.FBillId) result\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tWhere result.FBillId = T_CAS_PaymentBill.FID \t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append(rt);
        strSQL.append(" update T_CAS_PaymentBill set (FverifyStatus) = ").append(rt);
        strSQL.append(" (Select (case when isnull(FVerifiedAmt,0) = 0 then ").append(1).append(rt);
        strSQL.append(" when isnull(FUnVerifiedAmt,0) = 0 then ").append(3);
        strSQL.append(" else ").append(2).append(" end) ").append(rt);
        strSQL.append(" from (select distinct ve.fBillId as fBillId").append(rt);
        strSQL.append(" from ");
        strSQL.append(this.verifyTempTable);
        strSQL.append(" ve ").append(rt);
        strSQL.append(" where ve.FBillType = ").append(new Integer(4));
        strSQL.append(" ) as result").append(rt);
        strSQL.append(" where result.FBillId =  T_CAS_PaymentBill.fid)");
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append("Update T_CAS_PaymentBillEntry set \t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFAmountVc, \t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFLocalAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunVcAmount, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunVcLocAmount, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFactualAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFactualLocAmtVc, \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFrebateAmtVc, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFrebateLocAmtVc \t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tisnull(FAmountVc,0)\t\t").append(veriAdd).append(" result.FThisVerificateAmt, \t\t").append(rt);
        strSQL.append("\t\tisnull(FLocalAmtVc,0)\t\t").append(veriAdd).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FunVcAmount,0)\t\t").append(veriSub).append(" result.FThisVerificateAmt , \t").append(rt);
        strSQL.append("\t\tisnull(FunVcLocAmount,0)\t").append(veriSub).append(" result.FThisVerificateAmtLoc, \t").append(rt);
        strSQL.append("\t\tisnull(FactualAmtVc,0) \t").append(veriAdd).append(" result.FThisVerificateAmt, \t\t").append(rt);
        strSQL.append("\t\tisnull(FactualLocAmtVc,0) ").append(veriAdd).append(" result.FThisVerificateAmtLoc ,\t").append(rt);
        strSQL.append("\t\tisnull(FrebateAmtVc,0) \t").append(veriAdd).append(" result.FThisVerificateAmt , \t").append(rt);
        strSQL.append("\t\tisnull(FrebateLocAmtVc,0) ").append(veriAdd).append(" result.FThisVerificateAmtLoc \t").append(rt);
        strSQL.append("\t\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc \t\t\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\tWhere ve.FBillType = ").append(new Integer(4)).append(rt);
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP)as result\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_CAS_PaymentBillEntry.FID\t\t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        strSQL.setLength(0);
        strSQL.append("Update T_CAS_PaymentBillEntry set \t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFlockAmt, \t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFLockLocAmt, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunLockAmt, \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\tFunLockLocAmt \t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(") =\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\tSelect \t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        if (needCalcLockAmt) {
            strSQL.append("\t\tisnull(FlockAmt,0) ").append(veriAdd).append(" result.FThisVerificateAmt ,").append(rt);
            strSQL.append("\t\tisnull(FLockLocAmt,0)").append(veriAdd).append(" result.FThisVerificateAmtLoc,").append(rt);
            strSQL.append("\t\tisnull(FunLockAmt,0) ").append(veriSub).append(" result.FThisVerificateAmt , \t").append(rt);
            strSQL.append("\t\tisnull(FunLockLocAmt,0)\t").append(veriSub).append(" result.FThisVerificateAmtLoc ").append(rt);
        } else {
            strSQL.append("\tisnull(FlockAmt,0) ").append(veriAdd).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmt else 0 end ,").append(rt);
            strSQL.append("\t\tisnull(FLockLocAmt,0)").append(veriAdd).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmtLoc else 0 end,").append(rt);
            strSQL.append("\t\tisnull(FunLockAmt,0) ").append(veriSub).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmt else 0 end , \t").append(rt);
            strSQL.append("\t\tisnull(FunLockLocAmt,0)\t").append(veriSub).append(" case when isnull(result.FIsFromBOTP,0) = 0 then result.FThisVerificateAmtLoc else 0 end ").append(rt);
        }
        strSQL.append("\t\tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t(Select ve.FEntryID,ve.FIsFromBOTP as FIsFromBOTP,\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmt) as  FThisVerificateAmt,\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\t\tsum(ve.FThisVerificateAmtLoc)  as FThisVerificateAmtLoc \t\t\t").append(rt);
        strSQL.append("\t\t \tFrom \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append(this.verifyTempTable).append(rt);
        strSQL.append("\t\tve   \t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\t\tWhere ve.FBillType = ").append(new Integer(4)).append(rt);
        if (!needCalcLockAmt) {
            strSQL.append("  And ve.FIsPreVerify = 0 ").append(rt);
        }
        strSQL.append("\t\tgroup by ve.FEntryID,ve.FIsFromBOTP)as result\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        strSQL.append("\t\twhere result.FEntryID = T_CAS_PaymentBillEntry.FID\t\t\t\t\t\t\t").append(rt);
        strSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").append(rt);
        batchSql.add(strSQL.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.checkAmtAfterVerifyForRecPay(ctx, ids, veriOrUnVeri, false);
    }

    protected void writeBackPurOrderBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt,FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
        StringBuilder fromStr = new StringBuilder(300);
        fromStr.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        fromStr.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromStr.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromStr.append(" inner join T_SM_PurOrderEntry spEntry ");
        fromStr.append(" on spEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
        fromStr.append(" inner join T_SM_PurOrder orderBill ");
        fromStr.append(" on spEntry.fparentid = orderBill.fid ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        StringBuilder sbWhere = new StringBuilder(200);
        sbWhere.append(" where veriEntry.fbillType = ");
        sbWhere.append(9).append(" \r\n ");
        sbWhere.append(" and veriBill.FVerificationType IN (");
        sbWhere.append(201).append(",");
        sbWhere.append(207).append(",");
        sbWhere.append(203).append(",");
        sbWhere.append(209).append(",");
        sbWhere.append(103).append(",");
        sbWhere.append(109);
        sbWhere.append(")").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" and ((orderBill.FIsCentralBalance=1 and veriBill.FCompanyID=orderBill.FCompanyOrgUnitID)");
        sbInnerSql.append(" or (orderBill.FIsCentralBalance=0 and veriBill.FCompanyID = spEntry.FCompanyOrgUnitID))").append(" \r\n ");
        sbInnerSql.append(" group by arEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_PurOrderEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurOrderEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable);
        sbEntry.append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_PurOrderEntry.fid = result.FEntryID ");
        sbEntry.append(") where T_SM_PurOrderEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append("Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, spEntry.fparentid ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" and ((orderBill.FIsCentralBalance=1 and veriBill.FCompanyID = orderBill.FCompanyOrgUnitID)");
        sbInnerSql.append(" or (orderBill.FIsCentralBalance=0 and veriBill.FCompanyID = spEntry.FCompanyOrgUnitID))").append(" \r\n ");
        sbInnerSql.append(" group by spEntry.fparentid");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_PurOrder set ");
        sbEntry.append("(FPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurOrder.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable2).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_PurOrder.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_PurOrder.fid in (select FEntryID from ").append(tempTable2).append(")");
        batchSql.add(sbEntry.toString());
        String tempTable3 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable3).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, spEntry.fSourceBillEntryId ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" and veriBill.FCompanyID = orderBill.FCompanyOrgUnitID ");
        sbInnerSql.append(" group by spEntry.fSourceBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_PurContractEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurContractEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable3).append(" result ");
        sbEntry.append(" where T_SM_PurContractEntry.fid = result.FEntryID ");
        sbEntry.append(") where T_SM_PurContractEntry.fid in (select FEntryID from ").append(tempTable3).append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
        this.cacheVerifyTempTable(tempTable3);
    }

    protected void writeBackPurOrderBillByTrans(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, srcEntry.FCoreBillEntryId ").append(" \r\n ");
        StringBuilder fromStr = new StringBuilder(150);
        fromStr.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        fromStr.append(" inner join T_AP_OtherBill arBill on arBill.FID = arEntry.FParentID").append(" \r\n ");
        fromStr.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromStr.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromStr.append(" inner join T_AP_OtherbillEntry srcEntry on srcEntry.FID = arEntry.FCoreBillEntryID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append(" inner join T_SM_PurOrderEntry spEntry ");
        sbInnerSql.append(" on spEntry.fid = srcEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_PurOrder orderBill ");
        sbInnerSql.append(" on spEntry.fparentid = orderBill.fid and orderBill.FSupplierID = arBill.FAsstActID ").append(" \r\n ");
        StringBuilder sbWhere = new StringBuilder(200);
        sbWhere.append(" where veriEntry.fbillType = ");
        sbWhere.append(9).append(" \r\n ");
        sbWhere.append(" and veriBill.FVerificationType IN (");
        sbWhere.append(201).append(",");
        sbWhere.append(207).append(",");
        sbWhere.append(203).append(",");
        sbWhere.append(209).append(",");
        sbWhere.append(103).append(",");
        sbWhere.append(109);
        sbWhere.append(")").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by srcEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_PurOrderEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurOrderEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable).append(" result ");
        sbEntry.append(" where T_SM_PurOrderEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_PurOrderEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, orderEntry.fparentid as FOrderID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append(" inner join T_SM_PurOrderEntry orderEntry ");
        sbInnerSql.append(" on orderEntry.fid = arEntry.FCoreBillentryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_PurOrder orderBill ");
        sbInnerSql.append(" on orderBill.fid = orderEntry.fparentid ").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by orderEntry.fparentid");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_PurOrder set ");
        sbEntry.append("(FPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurOrder.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable2).append(" result ");
        sbEntry.append(" where T_SM_PurOrder.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_PurOrder.fid in (select FEntryID from ").append(tempTable2).append(")");
        batchSql.add(sbEntry.toString());
        String tempTable3 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable3).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt,spEntry.fSourceBillEntryId as FEntryID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append(" inner join T_SM_PurOrderEntry spEntry ");
        sbInnerSql.append(" on spEntry.fid = srcEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_PurOrder orderBill ");
        sbInnerSql.append(" on spEntry.fparentid = orderBill.fid and orderBill.FSupplierID = arBill.FAsstActID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by spEntry.fSourceBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_PurContractEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_PurContractEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable3).append(" result ");
        sbEntry.append(" where T_SM_PurContractEntry.fid = result.FEntryID ");
        sbEntry.append(") where T_SM_PurContractEntry.fid in (select FEntryID from ").append(tempTable3).append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
        this.cacheVerifyTempTable(tempTable3);
    }

    protected void writeBackSubOrderBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        StringBuilder sbWhere = new StringBuilder(200);
        sbWhere.append(" where fbillType = ");
        sbWhere.append(9).append(" \r\n ");
        sbWhere.append(" and veriBill.FVerificationType IN (");
        sbWhere.append(201).append(",");
        sbWhere.append(207).append(",");
        sbWhere.append(203).append(",");
        sbWhere.append(209).append(",");
        sbWhere.append(103).append(",");
        sbWhere.append(109);
        sbWhere.append(")").append(" \r\n ");
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId ").append(" \r\n ");
        StringBuilder fromStr = new StringBuilder(200);
        fromStr.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        fromStr.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromStr.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromStr.append(" inner join T_SM_SubContractOrderEntry spEntry ");
        fromStr.append(" on spEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
        fromStr.append(" inner join T_SM_SubContractOrder orderBill ");
        fromStr.append(" on spEntry.fparentid = orderBill.fid ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by arEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_SubContractOrderEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_SubContractOrderEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_SubContractOrderEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_SubContractOrderEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, spEntry.fparentid as FOrderID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by spEntry.fparentid");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_SubContractOrder set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_SubContractOrder.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable2).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_SubContractOrder.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_SubContractOrder.fid in (select FEntryID from ").append(tempTable2).append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
    }

    protected void writeBackSubOrderBillByTrans(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        StringBuilder sbWhere = new StringBuilder(150);
        sbWhere.append(" where veriEntry.fbillType = ");
        sbWhere.append(9).append(" \r\n ");
        sbWhere.append(" and veriBill.FVerificationType IN (");
        sbWhere.append(201).append(",");
        sbWhere.append(207).append(",");
        sbWhere.append(203).append(",");
        sbWhere.append(209).append(",");
        sbWhere.append(103).append(",");
        sbWhere.append(109);
        sbWhere.append(")").append(" \r\n ");
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, srcEntry.FCoreBillEntryId ").append(" \r\n ");
        StringBuilder fromStr = new StringBuilder(300);
        fromStr.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        fromStr.append(" inner join T_AP_OtherBill arBill on arBill.FID = arEntry.FParentID").append(" \r\n ");
        fromStr.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromStr.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromStr.append(" inner join T_AP_OtherbillEntry srcEntry on srcEntry.FID = arEntry.FCoreBillEntryID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append(" inner join T_SM_SubContractOrderEntry spEntry ");
        sbInnerSql.append(" on spEntry.fid = srcEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_SubContractOrder orderBill ");
        sbInnerSql.append(" on spEntry.fparentid = orderBill.fid and orderBill.FSupplierID = arBill.FAsstActID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by srcEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_SubContractOrderEntry set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_SubContractOrderEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_SubContractOrderEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_SubContractOrderEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt,orderEntry.fparentid as FOrderID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromStr);
        sbInnerSql.append(" inner join T_SM_SubContractOrderEntry orderEntry ");
        sbInnerSql.append(" on orderEntry.fid = arEntry.FCoreBillentryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_SubContractOrder orderBill ");
        sbInnerSql.append(" on orderBill.fid = orderEntry.fparentid ").append(" \r\n ");
        sbInnerSql.append((CharSequence)sbWhere);
        sbInnerSql.append(" group by orderEntry.fparentid");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SM_SubContractOrder set ");
        sbEntry.append("(FTotalPaidAmount,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalPaidAmount,0) ").append(veriAdd).append(" result.fthisVerificateAmt, T_SM_SubContractOrder.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable2).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_SubContractOrder.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_SubContractOrder.fid in (select FEntryID from ").append(tempTable2).append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
    }

    protected void writeBackPurReturnBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        sbInnerSql.append(" where veriEntry.fbillType = ").append(9).append(" \r\n ");
        sbInnerSql.append(" and veriBill.FVerificationType IN (");
        sbInnerSql.append(201).append(",");
        sbInnerSql.append(207).append(",");
        sbInnerSql.append(203).append(",");
        sbInnerSql.append(209).append(",");
        sbInnerSql.append(103).append(",");
        sbInnerSql.append(109);
        sbInnerSql.append(")").append(" \r\n ");
        sbInnerSql.append(" group by arEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_PurReturnsEntry set ");
        sbEntry.append("(FTotalReturnAmt,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalReturnAmt,0) ").append(veriAdd).append(" ABS(result.fthisVerificateAmt), T_SM_PurReturnsEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_PurReturnsEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_PurReturnsEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        DbUtil.execute((Context)ctx, (String)sbEntry.toString());
        this.cacheVerifyTempTable(tempTable);
    }

    protected void writeBackPurReturnBillByTrans(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt,srcEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" From T_AP_OtherBillEntry arEntry").append(" \r\n ");
        sbInnerSql.append(" inner join T_AP_OtherBill arBill on arBill.FID = arEntry.FParentID").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        sbInnerSql.append(" inner join T_AP_OtherbillEntry srcEntry on srcEntry.FID = arEntry.FCoreBillEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_PurReturnsEntry coreEntry on coreEntry.FID = srcEntry.FCoreBillEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SM_PurReturns coreBill on coreBill.FID = coreEntry.FParentID and coreBill.FSupplierID = arBill.FAsstActID ").append(" \r\n ");
        sbInnerSql.append(" where veriEntry.fbillType = ").append(9).append(" \r\n ");
        sbInnerSql.append(" and veriBill.FVerificationType IN (");
        sbInnerSql.append(201).append(",");
        sbInnerSql.append(207).append(",");
        sbInnerSql.append(203).append(",");
        sbInnerSql.append(209).append(",");
        sbInnerSql.append(103).append(",");
        sbInnerSql.append(109);
        sbInnerSql.append(")").append(" \r\n ");
        sbInnerSql.append(" group by srcEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SM_PurReturnsEntry set ");
        sbEntry.append("(FTotalReturnAmt,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalReturnAmt,0) ").append(veriAdd).append(" ABS(result.fthisVerificateAmt), T_SM_PurReturnsEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable).append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SM_PurReturnsEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SM_PurReturnsEntry.fid in (select FEntryID FROM ").append(tempTable).append(")");
        DbUtil.execute((Context)ctx, (String)sbEntry.toString());
        this.cacheVerifyTempTable(tempTable);
    }

    protected void writeBackSaleReturnBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, arEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
        sbInnerSql.append(" From T_AR_OtherBillEntry arEntry").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SD_SaleReturnsEntry sreEntry ");
        sbInnerSql.append(" on sreEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SD_SaleReturns srBill ");
        sbInnerSql.append(" on sreEntry.fparentid = srBill.fid ").append(" \r\n ");
        sbInnerSql.append(" where veriEntry.fbillType = ").append(8).append(" \r\n ");
        sbInnerSql.append(" and veriBill.FVerificationType IN (");
        sbInnerSql.append(101).append(",");
        sbInnerSql.append(107).append(",");
        sbInnerSql.append(203).append(",");
        sbInnerSql.append(209).append(",");
        sbInnerSql.append(103).append(",");
        sbInnerSql.append(109);
        sbInnerSql.append(")").append(" \r\n ");
        sbInnerSql.append(" and ((srBill.FIsCentralBalance=1 and veriBill.FCompanyID=srBill.FCompanyOrgUnitID)");
        sbInnerSql.append(" or (srBill.FIsCentralBalance=0 and veriBill.FCompanyID=sreEntry.FCompanyOrgUnitID))");
        sbInnerSql.append(" group by arEntry.FCoreBillEntryId ");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300).append(" update T_SD_SaleReturnsEntry set ");
        sbEntry.append("(FTotalReturnAmt, fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalReturnAmt,0) ").append(veriAdd).append(" ABS(result.fthisVerificateAmt), T_SD_SaleReturnsEntry.fid ").append(" \r\n ");
        sbEntry.append(" from ").append(tempTable);
        sbEntry.append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SD_SaleReturnsEntry.fid = result.FEntryID ").append(" \r\n ");
        sbEntry.append(") where T_SD_SaleReturnsEntry.fid in (select FEntryID from ").append(tempTable).append(")");
        DBUtil.execute((Context)ctx, (String)sbEntry.toString());
        this.cacheVerifyTempTable(tempTable);
    }

    protected void writeBackSaleReturnBillByTrans(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt, FEntryID)").append(" \r\n ");
        sbInnerSql.append(" Select sum(veriEntry.fthisVerificateAmt) as fthisVerificateAmt, srcEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
        sbInnerSql.append(" From T_AR_OtherBillEntry arEntry").append(" \r\n ");
        sbInnerSql.append(" inner join T_AR_OtherBill arBill on arBill.FID = arEntry.FParentID ").append(" \r\n ");
        sbInnerSql.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        sbInnerSql.append(" inner join T_AR_OtherbillEntry srcEntry on srcEntry.FID = arEntry.FCoreBillEntryID ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SD_SaleReturnsEntry sreEntry ");
        sbInnerSql.append(" on sreEntry.fid = srcEntry.FCoreBillEntryId ").append(" \r\n ");
        sbInnerSql.append(" inner join T_SD_SaleReturns srBill ");
        sbInnerSql.append(" on sreEntry.fparentid = srBill.fid and srBill.FRETURNSCUSTOMERID = arBill.FAsstActID ").append(" \r\n ");
        sbInnerSql.append(" where veriEntry.fbillType = ").append(8).append(" \r\n ");
        sbInnerSql.append(" and veriBill.FVerificationType IN (");
        sbInnerSql.append(101).append(",");
        sbInnerSql.append(107).append(",");
        sbInnerSql.append(203).append(",");
        sbInnerSql.append(209).append(",");
        sbInnerSql.append(103).append(",");
        sbInnerSql.append(109);
        sbInnerSql.append(")").append(" \r\n ");
        sbInnerSql.append(" group by srcEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300).append(" update T_SD_SaleReturnsEntry set ");
        sbEntry.append("(FTotalReturnAmt,fid) = (").append(" \r\n ");
        sbEntry.append(" SELECT isnull(FTotalReturnAmt,0) ").append(veriAdd).append(" ABS(result.fthisVerificateAmt), T_SD_SaleReturnsEntry.fid ");
        sbEntry.append(" from ").append(tempTable);
        sbEntry.append(" result ").append(" \r\n ");
        sbEntry.append(" where T_SD_SaleReturnsEntry.fid = result.FEntryID ");
        sbEntry.append(") where T_SD_SaleReturnsEntry.fid in (select FEntryID ");
        sbEntry.append(" from ").append(tempTable).append(")");
        DBUtil.execute((Context)ctx, (String)sbEntry.toString());
        this.cacheVerifyTempTable(tempTable);
    }

    public void createIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        TempTablePool t = TempTablePool.getInstance((Context)ctx);
        try {
            t.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void writeBackSaleOrderBill(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt,FEntryID)");
        sbInnerSql.append(" Select sum(isnull(veriEntry.fthisVerificateAmt,0)) as fthisVerificateAmt,arEntry.FCoreBillEntryId as FEntryID ");
        StringBuilder fromTable = new StringBuilder(300);
        fromTable.append(" From T_AR_OtherBillEntry arEntry").append(" \r\n ");
        fromTable.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromTable.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromTable.append(" inner join T_SD_SaleOrderEntry sdEntry ");
        fromTable.append(" on sdEntry.fid = arEntry.FCoreBillEntryId ").append(" \r\n ");
        fromTable.append(" inner join T_SD_SaleOrder orderBill ");
        fromTable.append(" on sdEntry.fparentid = orderBill.fid ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromTable);
        StringBuilder whereStr1 = new StringBuilder(200);
        whereStr1.append(" where veriEntry.fbillType = ").append(8).append(" \r\n ");
        whereStr1.append(" and veriBill.FVerificationType IN (");
        whereStr1.append(101).append(",");
        whereStr1.append(107).append(",");
        whereStr1.append(203).append(",");
        whereStr1.append(209).append(",");
        whereStr1.append(103).append(",");
        whereStr1.append(109);
        whereStr1.append(")").append(" \r\n ");
        whereStr1.append(" and ((orderBill.FIsCentralBalance=1 and veriBill.FCompanyID=orderBill.FCompanyOrgUnitID)").append(" \r\n ");
        whereStr1.append(" or (orderBill.FIsCentralBalance=0 and veriBill.FCompanyID = sdEntry.FCompanyOrgUnitID))");
        sbInnerSql.append((CharSequence)whereStr1);
        sbInnerSql.append(" group by arEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SD_SaleOrderEntry set ");
        sbEntry.append(" FTotalReceivedAmount = (");
        sbEntry.append(" SELECT isnull(FTotalReceivedAmount,0)").append(veriAdd).append(" result.fthisVerificateAmt ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable);
        sbEntry.append(" result ");
        sbEntry.append(" where T_SD_SaleOrderEntry.fid = result.FEntryID ");
        sbEntry.append(") WHERE  T_SD_SaleOrderEntry.fid IN (SELECT FEntryID ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable);
        sbEntry.append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt,FEntryID)");
        sbInnerSql.append(" Select sum(isnull(veriEntry.fthisVerificateAmt,0)) as fthisVerificateAmt, sdEntry.fSourceBillEntryId as FEntryID ");
        sbInnerSql.append((CharSequence)fromTable);
        sbInnerSql.append((CharSequence)whereStr1);
        sbInnerSql.append(" group by sdEntry.fSourceBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SD_SaleContractEntry set ");
        sbEntry.append(" FTotalReceivedAmt = (");
        sbEntry.append(" SELECT isnull(FTotalReceivedAmt,0)").append(veriAdd).append(" result.fthisVerificateAmt ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable2);
        sbEntry.append(" result ");
        sbEntry.append(" where T_SD_SaleContractEntry.fid = result.FEntryID ");
        sbEntry.append(") WHERE  T_SD_SaleContractEntry.fid IN (SELECT FEntryID ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable2);
        sbEntry.append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
    }

    protected void writeBackSaleOrderBillByTrans(Context ctx, String verifyBillIds, boolean veriOrUnVer, boolean isAR) throws BOSException {
        String veriAdd = "+";
        if (!veriOrUnVer) {
            veriAdd = "-";
        }
        this.setVerifyTempTable(ctx, verifyBillIds);
        StringBuilder sbInnerSql = new StringBuilder(500);
        String tempTable = this.createVerifyTempTable(ctx);
        sbInnerSql.append(" insert into ").append(tempTable).append("(fthisVerificateAmt,FEntryID)");
        sbInnerSql.append(" Select sum(isnull(veriEntry.fthisVerificateAmt,0)) as fthisVerificateAmt,srcEntry.FCoreBillEntryId as FEntryID ").append(" \r\n ");
        StringBuilder fromTable = new StringBuilder(300);
        fromTable.append(" From T_AR_OtherBillEntry arEntry").append(" \r\n ");
        fromTable.append(" inner join T_AR_OtherBill arBill on arBill.FID = arEntry.FParentID").append(" \r\n ");
        fromTable.append(" inner join ").append(this.verifyTempTable).append(" veriEntry on arEntry.fid = veriEntry.FEntryID ").append(" \r\n ");
        fromTable.append(" inner join t_").append(isAR ? "ar" : "ap").append("_verificationBill veriBill on veriEntry.fparentid = veriBill.fid ").append(" \r\n ");
        fromTable.append(" inner join T_AR_OtherbillEntry srcEntry on srcEntry.FID = arEntry.FCoreBillEntryID ").append(" \r\n ");
        fromTable.append(" inner join T_SD_SaleOrderEntry sdEntry ");
        fromTable.append(" on sdEntry.fid = srcEntry.FCoreBillEntryId ").append(" \r\n ");
        fromTable.append(" inner join T_SD_SaleOrder orderBill ");
        fromTable.append(" on sdEntry.fparentid = orderBill.fid and orderBill.FOrderCustomerID = arBill.FAsstActID ").append(" \r\n ");
        sbInnerSql.append((CharSequence)fromTable);
        StringBuilder whereStr1 = new StringBuilder(100);
        whereStr1.append(" where veriEntry.fbillType = ").append(8).append(" \r\n ");
        whereStr1.append(" and veriBill.FVerificationType IN (");
        whereStr1.append(101).append(",");
        whereStr1.append(107).append(",");
        whereStr1.append(203).append(",");
        whereStr1.append(209).append(",");
        whereStr1.append(103).append(",");
        whereStr1.append(109);
        whereStr1.append(")");
        sbInnerSql.append((CharSequence)whereStr1);
        sbInnerSql.append(" group by srcEntry.FCoreBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        StringBuilder sbEntry = new StringBuilder(300);
        sbEntry.append(" update T_SD_SaleOrderEntry set ");
        sbEntry.append(" FTotalReceivedAmount = (");
        sbEntry.append(" SELECT isnull(FTotalReceivedAmount,0)").append(veriAdd).append(" result.fthisVerificateAmt ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable);
        sbEntry.append(" result ");
        sbEntry.append(" where T_SD_SaleOrderEntry.fid = result.FEntryID ");
        sbEntry.append(") WHERE T_SD_SaleOrderEntry.fid IN (SELECT FEntryID ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable);
        sbEntry.append(")");
        ArrayList<String> batchSql = new ArrayList<String>();
        batchSql.add(sbEntry.toString());
        String tempTable2 = this.createVerifyTempTable(ctx);
        sbInnerSql.setLength(0);
        sbInnerSql.append(" insert into ").append(tempTable2).append("(fthisVerificateAmt,FEntryID)");
        sbInnerSql.append(" Select sum(isnull(veriEntry.fthisVerificateAmt,0)) as fthisVerificateAmt,sdEntry.fSourceBillEntryId as FEntryID ");
        sbInnerSql.append((CharSequence)fromTable);
        sbInnerSql.append((CharSequence)whereStr1);
        sbInnerSql.append(" group by sdEntry.fSourceBillEntryId");
        DbUtil.execute((Context)ctx, (String)sbInnerSql.toString());
        sbEntry.setLength(0);
        sbEntry.append(" update T_SD_SaleContractEntry set ");
        sbEntry.append(" FTotalReceivedAmt = (");
        sbEntry.append(" SELECT isnull(FTotalReceivedAmt,0)").append(veriAdd).append(" result.fthisVerificateAmt ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable2);
        sbEntry.append(" result ");
        sbEntry.append(" where T_SD_SaleContractEntry.fid = result.FEntryID ");
        sbEntry.append(") WHERE  T_SD_SaleContractEntry.fid IN (SELECT FEntryID ");
        sbEntry.append(" from ");
        sbEntry.append(tempTable2);
        sbEntry.append(")");
        batchSql.add(sbEntry.toString());
        DBUtil.execute(ctx, batchSql.toArray(new String[batchSql.size()]));
        this.cacheVerifyTempTable(tempTable);
        this.cacheVerifyTempTable(tempTable2);
    }

    public void addAttachment(Context ctx, String bosType, IObjectPK[] verifyPk) throws BOSException {
        if (null == verifyPk || verifyPk.length == 0) {
            return;
        }
        StringBuilder pkBuf = new StringBuilder(100);
        for (int i = 0; i < verifyPk.length; ++i) {
            pkBuf.append("'").append(verifyPk[i]).append("'");
            if (i == verifyPk.length - 1) continue;
            pkBuf.append(",");
        }
        Connection cn = null;
        Statement stmt = null;
        try {
            String assoType = Resrcs.getString((String)"ExistedAttachment", (Locale)ctx.getLocale());
            String locale = ctx.getLocale().toString();
            String system = "3C41FD86".equals(bosType) ? "AR" : "AP";
            cn = this.getConnection(ctx);
            stmt = cn.createStatement();
            StringBuilder sqlBuf = new StringBuilder(300).append("INSERT INTO T_BAS_BOATTCHASSO (FID, FBOID, FATTACHMENTID, FASSOBUSOBJTYPE, FASSOTYPE_" + locale + ") ").append(" \r\n ").append("SELECT NEWBOSID('").append("172F3A47").append("') AS FID, ").append(" \r\n ").append("SRC.FBOID, SRC.FATTACHMENTID, ").append(" \r\n ").append("'").append(bosType).append("', ").append(" \r\n ").append("'").append(assoType).append("' ").append(" \r\n ").append("FROM (").append(" \r\n ").append("  SELECT DISTINCT TAV.FID AS FBOID, ").append(" \r\n ").append("         TBBA.FATTACHMENTID ").append(" \r\n ").append("  FROM T_").append(system).append("_VERIFICATIONBILL TAV ").append(" \r\n ").append("  INNER JOIN T_").append(system).append("_VERIFICATIONBILLENTRY TAVB ON TAVB.FPARENTID = TAV.FID ").append(" \r\n ").append("  INNER JOIN T_BAS_BOATTCHASSO TBBA ON TAVB.FBILLID = TBBA.FBOID ").append(" \r\n ").append("  WHERE TAV.FID IN (").append(pkBuf.toString()).append(") ").append(" \r\n ").append(") SRC").append(" \r\n ").append(" LEFT JOIN T_BAS_BOATTCHASSO TBBAT ON SRC.FBOID = TBBAT.FBOID AND SRC.FATTACHMENTID = TBBAT.FATTACHMENTID ").append(" \r\n ").append(" WHERE TBBAT.FID IS NULL");
            stmt.execute(sqlBuf.toString());
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)stmt, (Connection)cn);
    }

    private Map<VerificationEnum, StringBuilder> splitByVerificatonType(IObjectCollection colls, IObjectPK[] verifyPk) {
        HashMap<VerificationEnum, StringBuilder> typeMap = new HashMap<VerificationEnum, StringBuilder>();
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            String Item;
            VerificationBillBaseInfo bill = (VerificationBillBaseInfo)colls.getObject(i);
            VerificationEnum verificationType = bill.getVerificationType();
            String string = Item = null == verifyPk ? bill.getNumber() : "'" + verifyPk[i] + "'";
            if (typeMap.containsKey(verificationType)) {
                ((StringBuilder)typeMap.get(verificationType)).append(",").append(Item);
                continue;
            }
            typeMap.put(verificationType, new StringBuilder(size * 44).append(Item));
        }
        return typeMap;
    }

    private String createVerifyTempTable(Context ctx) throws BOSException {
        StringBuilder createSql = new StringBuilder(200);
        createSql.append(" create table temp (fthisVerificateAmt decimal(19,4),FEntryID varchar(44)) ");
        String tempTable = null;
        if (this.tmpTabList.isEmpty()) {
            tempTable = DBUtil.createTempTable(ctx, createSql.toString());
            this.createIndex(ctx, tempTable, "FEntryID", false, true);
        } else {
            tempTable = this.tmpTabList.remove(0);
            DBUtil.execute((Context)ctx, (String)("DELETE FROM " + tempTable));
        }
        return tempTable;
    }

    private void cacheVerifyTempTable(String tableName) {
        this.tmpTabList.add(tableName);
    }

    private void releaseVerifyTempTable(Context ctx) throws EASBizException, BOSException {
        if (this.tmpTabList.size() > 0) {
            for (int i = 0; i < this.tmpTabList.size(); ++i) {
                DBUtil.releaseTempTable(ctx, this.tmpTabList.get(i));
            }
            this.tmpTabList.clear();
        }
    }

    private String getString(Map<String, Object> map, String key) {
        return null != map.get(key) ? map.get(key).toString() : null;
    }

    protected void updateVerifyEntry(Context ctx, String tmpTable, String bosType, String entryIDField, String ids, String idTmpTab) throws Exception {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        String realEntryIdField = VerificationStrategy.getLinkedField((String)entryIDField);
        StringBuilder buf = new StringBuilder(300);
        buf.append(" UPDATE ").append(this.entryTab).append(" as entry SET ").append(" \r\n ");
        buf.append(" (FComment, FMaterialID, FMaterialNumber, FMaterialName, FAccountID, FOppAccountID, ");
        if (VerificationStrategy.isArAp(bosType)) {
            buf.append(" FAdminOrgUnitID, FPersonID, FLastExhangeRate) = ").append(" \r\n ");
            buf.append(" ( select abstractName, ").append(" \r\n ");
            buf.append(" case when \"material.id\" is not null then \"material.id\" else \"expenseItem.id\" end As FMaterialID, ").append(" \r\n ");
            buf.append(" case when \"material.id\" is not null then \"material.number\" else \"expenseItem.number\" end As FMaterialNumber, ").append(" \r\n ");
            buf.append(" case when \"material.id\" is not null then \"material.name\" else \"expenseItem.name\" end As FMaterialName, ").append(" \r\n ");
            buf.append(" \"account.id\", \"oppAccount.id\", ").append(" \r\n ");
        } else if ("FA44FD5B".equals(bosType)) {
            buf.append(" FVeriRecPayTypeNumber, FVeriRecPayTypeName, FAdminOrgUnitID, FPersonID, FLastExhangeRate ) = ").append(" \r\n ");
            buf.append(" ( select description, \"expenseType.id\", \"expenseType.number\", \"expenseType.name\", ").append(" \r\n ");
            buf.append(" \"payeeAccount.id\", \"entryOppAccount.id\", \"entryRecBillType.number\", \"entryRecBillType.name\",").append(" \r\n ");
        } else if ("40284E81".equals(bosType)) {
            buf.append(" FVeriRecPayTypeNumber, FVeriRecPayTypeName, FAdminOrgUnitID, FPersonID, FLastExhangeRate) = ").append(" \r\n ");
            buf.append(" ( select description, \"expenseType.id\", \"expenseType.number\", \"expenseType.name\", ").append(" \r\n ");
            buf.append(" \"payerAccount.id\", \"entryOppAccount.id\", \"payBillType.number\", \"payBillType.name\", ").append(" \r\n ");
        }
        buf.append(" \"adminOrgUnit.id\", \"person.id\", lastExhangeRate ").append(" \r\n ");
        buf.append(" from ").append(tmpTable).append(" tmp ").append(" \r\n ");
        buf.append(" where tmp.id = entry.FBillID and tmp.").append(realEntryIdField).append(" = entry.FENTRYID )").append(" \r\n ");
        if (!StringUtils.isEmpty((String)idTmpTab)) {
            buf.append(" where entry.FParentID in (select fid from ").append(idTmpTab).append(" )").append(" \r\n ");
        } else {
            buf.append(" where entry.FParentID in (").append(ids).append(" )").append(" \r\n ");
        }
        buf.append(" and exists (select 1 from ").append(this.entryTab).append(" et inner join ").append(" \r\n ");
        buf.append(tmpTable).append(" tmp ").append(" \r\n ");
        buf.append(" on tmp.id = et.FBillID and tmp.").append(realEntryIdField).append(" = et.FENTRYID ").append(" \r\n ");
        if (!StringUtils.isEmpty((String)idTmpTab)) {
            buf.append(" where et.FParentID in (select fid from ").append(idTmpTab).append(" ) )").append(" \r\n ");
        } else {
            buf.append(" where et.FParentID in (").append(ids).append(" ) )").append(" \r\n ");
        }
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }

    protected void fillRemainVerifyEntryFields(Context ctx, IObjectPK[] verifyPk) throws Exception {
        boolean isUsePreMatch;
        Map map = SCMThreadLocalUtil.getThreadObject();
        Object obj = map.get("isUsePreMatch");
        boolean bl = isUsePreMatch = null != obj ? Boolean.valueOf(obj.toString()) : false;
        if (!isUsePreMatch || verifyPk.length == 0) {
            return;
        }
        String idTempTab = null;
        String mainTmpTable = this.getString(map, "mainTmpTable");
        String secTmpTable = this.getString(map, "secTmpTable");
        String ids = DBUtil.convertToIDStr(verifyPk);
        int maxCount = SCMSqlUtil.getLimitForIDTempTab((Context)ctx);
        if (verifyPk.length > maxCount) {
            idTempTab = SCMSqlUtil.convertIdArrToTempTab((Context)ctx, (String[])ids.replace("'", "").split(","));
        }
        String mainBosType = this.getString(map, "mainBosType");
        String secBosType = this.getString(map, "secBosType");
        String mainEntryIDField = this.getString(map, "mainEntryIDField");
        String secEntryIDField = this.getString(map, "secEntryIDField");
        this.updateVerifyEntry(ctx, mainTmpTable, mainBosType, mainEntryIDField, ids, idTempTab);
        this.updateVerifyEntry(ctx, secTmpTable, secBosType, secEntryIDField, ids, idTempTab);
    }

    protected IObjectPK[] _submitBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (null == colls || colls.size() == 0) {
            return null;
        }
        Object obj_FromBOTP = colls.getObject(0).get("_VerificationBillFromBOTP");
        boolean isARSys = colls.getObject(0) instanceof VerificationBillInfo;
        this.entryTab = isARSys ? "T_AR_VerificationBillentry" : "T_AP_VerificationBillentry";
        IObjectPK[] logPKs = this.batchWriteLog(ctx, null, colls);
        long start = System.currentTimeMillis();
        boolean veriOrUnVeri = true;
        StringBuilder logBuf = new StringBuilder(500);
        logBuf.append(isARSys ? "ARVERIFICATION" : "APVERIFICATION").append(": SUBMIT[");
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            VerificationBillBaseInfo billInfo = (VerificationBillBaseInfo)colls.getObject(i);
            logBuf.append(billInfo.getNumber());
            if (i > 0) {
                logBuf.append(";");
            }
            this.checkSameCurrencyVerifyAmount(billInfo);
        }
        logBuf.append("]");
        wfLogger.info((Object)logBuf.toString());
        IObjectPK[] verifyPk = super._submitBatchData(ctx, colls);
        try {
            this.fillRemainVerifyEntryFields(ctx, verifyPk);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        String bosType = isARSys ? "3C41FD86" : "2F368848";
        ExtendStoreFieldsHandler.storeField((Context)ctx, (String)bosType, (IObjectPK[])verifyPk);
        logger.info((Object)("verifyBill Submit end : " + (System.currentTimeMillis() - start) + " ms!"));
        if (verifyPk != null && verifyPk.length > 0) {
            this.addAttachment(ctx, bosType, verifyPk);
            boolean isCloseBillImage = "1".equals(SCMServerUtil.getDTTEMPPARAM((Context)ctx, (String)"isCloseBillImage"));
            if (!isCloseBillImage) {
                IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
                String imageNumber = null;
                int size2 = colls.size();
                for (int i = 0; i < size2; ++i) {
                    VerificationBillBaseInfo bill = (VerificationBillBaseInfo)colls.getObject(i);
                    imageNumber = image.getImageNumber(bosType, verifyPk[i].toString(), bill.getNumber());
                    if (!StringUtils.isEmpty((String)imageNumber)) continue;
                    imageNumber = image.genImageNumber(bosType, verifyPk[i].toString());
                }
            }
            Map<VerificationEnum, StringBuilder> typeMap = this.splitByVerificatonType(colls, verifyPk);
            Map.Entry<VerificationEnum, StringBuilder> me2 = null;
            for (Map.Entry<VerificationEnum, StringBuilder> me2 : typeMap.entrySet()) {
                String billId = me2.getValue().toString();
                VerificationEnum veriType = me2.getKey();
                start = System.currentTimeMillis();
                if (veriType == VerificationEnum.AR_Rec || veriType == VerificationEnum.AR_Rec_AB || veriType == VerificationEnum.AP_AR || veriType == VerificationEnum.AR_AP || veriType == VerificationEnum.AP_AR_AB || veriType == VerificationEnum.AR_AP_AB) {
                    this.writeBackArOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                    this.writeBackArApBillPlan(ctx, billId, veriOrUnVeri);
                    this.writeBackSaleOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackSaleOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackSaleReturnBill(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackSaleReturnBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackStockTransferBill(ctx, billId, veriOrUnVeri, true, veriType);
                }
                logger.info((Object)("AR Bill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
                start = System.currentTimeMillis();
                if (veriType == VerificationEnum.AP_Pay || veriType == VerificationEnum.AP_Pay_AB || veriType == VerificationEnum.AP_AR || veriType == VerificationEnum.AR_AP || veriType == VerificationEnum.AP_AR_AB || veriType == VerificationEnum.AR_AP_AB) {
                    this.writeBackApOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                    this.writeBackArApBillPlan(ctx, billId, veriOrUnVeri);
                    this.writeBackPurOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackPurOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackSubOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackSubOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackPurReturnBill(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackPurReturnBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                    this.writeBackStockTransferBill(ctx, billId, veriOrUnVeri, false, veriType);
                }
                logger.info((Object)("AP Bill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
                start = System.currentTimeMillis();
                if (veriType == VerificationEnum.AR_Rec || veriType == VerificationEnum.AR_Rec_AB || veriType == VerificationEnum.Rec_Pay || veriType == VerificationEnum.Rec_Pay_AB || veriType == VerificationEnum.Pay_Rec || veriType == VerificationEnum.Pay_Rec_AB || veriType == VerificationEnum.PreRec_PrePay || veriType == VerificationEnum.PreRec_PrePay_AB || veriType == VerificationEnum.PrePay_PreRec || veriType == VerificationEnum.PrePay_PreRec_AB || veriType == VerificationEnum.AR_BadAcctTB || veriType == VerificationEnum.AR_BadAcctTB_AB) {
                    this.writeBackReceiveBill(ctx, billId, veriOrUnVeri, false);
                }
                logger.info((Object)("receivingBill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
                start = System.currentTimeMillis();
                if (veriType == VerificationEnum.AP_Pay || veriType == VerificationEnum.AP_Pay_AB || veriType == VerificationEnum.Rec_Pay || veriType == VerificationEnum.Rec_Pay_AB || veriType == VerificationEnum.Pay_Rec || veriType == VerificationEnum.Pay_Rec_AB || veriType == VerificationEnum.PreRec_PrePay || veriType == VerificationEnum.PreRec_PrePay_AB || veriType == VerificationEnum.PrePay_PreRec || veriType == VerificationEnum.PrePay_PreRec_AB) {
                    this.writeBackPaymentBill(ctx, billId, veriOrUnVeri, false);
                }
                logger.info((Object)("paymentBill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
                this.dispose(ctx, billId, true);
                if (null == this.verifyTempTable) continue;
                DBUtil.releaseTempTable(ctx, this.verifyTempTable);
                this.verifyTempTable = null;
            }
            this.releaseVerifyTempTable(ctx);
            this.releaseTempTable(ctx);
            VerificationBillBaseInfo billInfo = null;
            VerificationBillBaseEntryInfo entryInfo2 = null;
            String number = null;
            logBuf.setLength(0);
            logBuf.append(isARSys ? "ARVERIFICATION" : "APVERIFICATION").append(":").append(" \r\n ");
            String UserName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            int size3 = colls.size();
            for (int i = 0; i < size3; ++i) {
                billInfo = (VerificationBillBaseInfo)colls.getObject(i);
                number = billInfo.getNumber();
                for (VerificationBillBaseEntryInfo entryInfo2 : (IObjectCollection)billInfo.get("entrys")) {
                    logBuf.append("[").append(number).append("][").append(entryInfo2.getBillNumber()).append("]").append("[").append(entryInfo2.getBillType()).append("]").append("[").append(entryInfo2.getEntryID().toString()).append("]").append("[").append(entryInfo2.getThisVerificateAmt()).append("]").append("[").append(entryInfo2.getThisVerificateAmtLoc()).append("]").append(", USER: ").append(UserName).append(" \r\n ");
                }
                logBuf.append(" \r\n ");
            }
            wfLogger.info((Object)logBuf.toString());
        }
        ArApServerUtils.batchAfterLog(ctx, logPKs);
        return verifyPk;
    }

    private void creatImageNumber(Context ctx, IObjectPK pk) throws BOSException {
        String bosType;
        IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        String imageNumber = image.getImageNumber(bosType = "3C41FD86", pk.toString());
        if (StringUtils.isEmpty((String)imageNumber)) {
            imageNumber = image.genImageNumber(bosType, pk.toString());
        }
    }

    private void checkSameCurrencyVerifyAmount(VerificationBillBaseInfo billInfo) throws OtherBillBizException {
        if (billInfo.getMainCurrency().getId().equals((Object)billInfo.getSecondCurrency().getId())) {
            BigDecimal mainThisVerificateAmt = billInfo.getMainThisVerificateAmt();
            mainThisVerificateAmt = mainThisVerificateAmt == null ? BigDecimal.ZERO : mainThisVerificateAmt;
            BigDecimal secondThisVerificateAmt = billInfo.getSecondThisVerificateAmt();
            BigDecimal bigDecimal = secondThisVerificateAmt = secondThisVerificateAmt == null ? BigDecimal.ZERO : secondThisVerificateAmt;
            if (((VerificationBillBaseEntryInfo)((IObjectCollection)billInfo.get("entrys")).getObject(0)).isVeriType()) {
                mainThisVerificateAmt = mainThisVerificateAmt.abs();
                secondThisVerificateAmt = secondThisVerificateAmt.abs();
            }
            if (mainThisVerificateAmt.compareTo(secondThisVerificateAmt) != 0) {
                throw new OtherBillBizException(OtherBillBizException.VERIFICATION_SAME_CURRENCY_SAME_VERIFY_AMT);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String bosType;
        long start = System.currentTimeMillis();
        VerificationBillBaseInfo billInfo = (VerificationBillBaseInfo)model;
        boolean isARSys = billInfo instanceof VerificationBillInfo;
        String string = bosType = isARSys ? "3C41FD86" : "2F368848";
        if (billInfo.isIsReverseBill()) {
            IObjectPK pk = super._addnew(ctx, model);
            this.addAttachment(ctx, bosType, new IObjectPK[]{pk});
            this.creatImageNumber(ctx, pk);
            return pk;
        }
        this.checkSameCurrencyVerifyAmount(billInfo);
        String orgID = billInfo.getCompany().getId().toString();
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, orgID);
        billInfo.setNumber(String.valueOf(number));
        IObjectPK logPK = this.writeLog(ctx, null, billInfo);
        Object obj_FromBOTP = billInfo.get("_VerificationBillFromBOTP");
        this.entryTab = isARSys ? "T_AR_VerificationBillentry" : "T_AP_VerificationBillentry";
        boolean veriOrUnVeri = true;
        this._setBillDate(ctx, billInfo);
        this.checkRedBlueEntry(ctx, billInfo);
        boolean isGainLoss = false;
        if (!billInfo.isIsSameCurrency() || billInfo.isIsSameCurrency() && !billInfo.getMainCurrency().getId().toString().equalsIgnoreCase(baseCurrency.getId().toString())) {
            isGainLoss = true;
        }
        this._setGainLoss(billInfo, isGainLoss);
        IObjectPK verifyPk = super._addnew(ctx, model);
        this.creatImageNumber(ctx, verifyPk);
        this.addAttachment(ctx, bosType, new IObjectPK[]{verifyPk});
        ExtendStoreFieldsHandler.storeField((Context)ctx, (String)billInfo.getBOSType().toString(), (IObjectPK[])new IObjectPK[]{verifyPk});
        logger.info((Object)("verifyBill Submit end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
        if (verifyPk != null && verifyPk.toString().length() != 0) {
            String billId = "'" + verifyPk.toString() + "'";
            VerificationEnum veriType = billInfo.getVerificationType();
            start = System.currentTimeMillis();
            if (veriType == VerificationEnum.AR_Rec || veriType == VerificationEnum.AR_Rec_AB || veriType == VerificationEnum.AP_AR || veriType == VerificationEnum.AR_AP || veriType == VerificationEnum.AP_AR_AB || veriType == VerificationEnum.AR_AP_AB) {
                this.writeBackArOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                this.writeBackArApBillPlan(ctx, billId, veriOrUnVeri);
                this.writeBackSaleOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackSaleOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackSaleReturnBill(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackSaleReturnBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackStockTransferBill(ctx, billId, veriOrUnVeri, true, veriType);
            }
            logger.info((Object)("AR Bill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
            start = System.currentTimeMillis();
            if (veriType == VerificationEnum.AP_Pay || veriType == VerificationEnum.AP_Pay_AB || veriType == VerificationEnum.AP_AR || veriType == VerificationEnum.AR_AP || veriType == VerificationEnum.AP_AR_AB || veriType == VerificationEnum.AR_AP_AB) {
                this.writeBackApOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                this.writeBackArApBillPlan(ctx, billId, veriOrUnVeri);
                this.writeBackPurOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackPurOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackSubOrderBill(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackSubOrderBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackPurReturnBill(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackPurReturnBillByTrans(ctx, billId, veriOrUnVeri, isARSys);
                this.writeBackStockTransferBill(ctx, billId, veriOrUnVeri, false, veriType);
            }
            logger.info((Object)("AP Bill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
            start = System.currentTimeMillis();
            if (veriType == VerificationEnum.AR_Rec || veriType == VerificationEnum.AR_Rec_AB || veriType == VerificationEnum.Rec_Pay || veriType == VerificationEnum.Rec_Pay_AB || veriType == VerificationEnum.Pay_Rec || veriType == VerificationEnum.Pay_Rec_AB || veriType == VerificationEnum.PreRec_PrePay || veriType == VerificationEnum.PreRec_PrePay_AB || veriType == VerificationEnum.PrePay_PreRec || veriType == VerificationEnum.PrePay_PreRec_AB || veriType == VerificationEnum.AR_BadAcctTB || veriType == VerificationEnum.AR_BadAcctTB_AB) {
                this.writeBackReceiveBill(ctx, billId, veriOrUnVeri, false);
            }
            logger.info((Object)("receivingBill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
            start = System.currentTimeMillis();
            if (veriType == VerificationEnum.AP_Pay || veriType == VerificationEnum.AP_Pay_AB || veriType == VerificationEnum.Rec_Pay || veriType == VerificationEnum.Rec_Pay_AB || veriType == VerificationEnum.Pay_Rec || veriType == VerificationEnum.Pay_Rec_AB || veriType == VerificationEnum.PreRec_PrePay || veriType == VerificationEnum.PreRec_PrePay_AB || veriType == VerificationEnum.PrePay_PreRec || veriType == VerificationEnum.PrePay_PreRec_AB) {
                this.writeBackPaymentBill(ctx, billId, veriOrUnVeri, false);
            }
            logger.info((Object)("paymentBill write end : " + (System.currentTimeMillis() - start) + " ms!" + new Date()));
            this.dispose(ctx, billId, true);
            this.releaseTempTable(ctx);
            this.releaseVerifyTempTable(ctx);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return verifyPk;
    }

    private void checkRedBlueEntry(Context ctx, VerificationBillBaseInfo billInfo) {
        if (billInfo != null) {
            IObjectCollection entry = (IObjectCollection)billInfo.get("entrys");
            boolean negFlag = false;
            boolean posFlag = false;
            int defaultBillType = 0;
            for (int index = 0; index < entry.size(); ++index) {
                if (index == 0 && this.getEntryInfo(entry, index) != null) {
                    defaultBillType = this.getEntryInfo(entry, index).getBillType().getValue();
                    continue;
                }
                if (defaultBillType == this.getEntryInfo(entry, index).getBillType().getValue()) continue;
                return;
            }
            for (int seq = 0; seq < entry.size(); ++seq) {
                if (BaseDataUtil.ZERO.compareTo(this.getVeriEntryAmt(entry, seq)) < 0) {
                    posFlag = true;
                }
                if (BaseDataUtil.ZERO.compareTo(this.getVeriEntryAmt(entry, seq)) <= 0) continue;
                negFlag = true;
            }
            if (negFlag && posFlag) {
                for (int j = 0; j < entry.size(); ++j) {
                    this.setEntryVeriType(entry, j, 1);
                }
            }
        }
    }

    private VerificationBillBaseEntryInfo getEntryInfo(IObjectCollection entry, int i) {
        if (entry != null && entry.getObject(i) instanceof VerificationBillBaseEntryInfo) {
            return (VerificationBillBaseEntryInfo)entry.getObject(i);
        }
        return null;
    }

    private BigDecimal getVeriEntryAmt(IObjectCollection entry, int i) {
        if (this.getEntryInfo(entry, i) != null) {
            return this.getEntryInfo(entry, i).getThisVerificateAmt();
        }
        return null;
    }

    private void setEntryVeriType(IObjectCollection entry, int i, int flag) {
        if (this.getEntryInfo(entry, i) != null) {
            this.getEntryInfo(entry, i).setVeriType(true);
        }
    }

    @Override
    protected boolean _writeBackBills(Context ctx, Collection pks, boolean isArSys) throws BOSException {
        if (pks == null) {
            return false;
        }
        StringBuffer pkStr = new StringBuffer();
        Iterator iter = pks.iterator();
        while (iter.hasNext()) {
            pkStr.append("'").append(iter.next().toString()).append("',");
        }
        boolean veriOrUnVeri = true;
        Object obj_FromBOTP = null;
        this.entryTab = isArSys ? "T_AR_VerificationBillentry" : "T_AP_VerificationBillentry";
        if (pkStr.length() != 0) {
            String billId = pkStr.deleteCharAt(pkStr.length() - 1).toString();
            try {
                this.writeBackArOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                this.writeBackApOtherBill(ctx, obj_FromBOTP, billId, veriOrUnVeri, false);
                this.writeBackReceiveBill(ctx, billId, veriOrUnVeri, false);
                this.writeBackPaymentBill(ctx, billId, veriOrUnVeri, false);
                if (!isArSys) {
                    this.writeBackPurOrderBill(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackPurOrderBillByTrans(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackSubOrderBill(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackSubOrderBillByTrans(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackPurReturnBill(ctx, billId, false, isArSys);
                    this.writeBackPurReturnBillByTrans(ctx, billId, false, isArSys);
                } else {
                    this.writeBackSaleOrderBill(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackSaleOrderBillByTrans(ctx, billId, veriOrUnVeri, isArSys);
                    this.writeBackSaleReturnBill(ctx, billId, false, isArSys);
                    this.writeBackSaleReturnBillByTrans(ctx, billId, false, isArSys);
                }
                this.writeBackStockTransferBill(ctx, billId, veriOrUnVeri, isArSys, VerificationEnum.AR_Rec);
                this.writeBackArApBillPlan(ctx, billId, veriOrUnVeri);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.releaseTempTable(ctx);
                try {
                    this.releaseVerifyTempTable(ctx);
                }
                catch (BOSException | EASBizException e) {
                    throw new BOSException(e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        block18: {
            block17: {
                block16: {
                    if (!BOTBillOperStateEnum.EDIT.equals((Object)billOperStateEnum)) break block17;
                    fAR = srcBillVO instanceof VerificationBillInfo != false;
                    company = ((VerificationBillBaseInfo)srcBillVO).getCompany();
                    arPeriod = CommonServerUtils.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSRECEIVABLE).getCurrentPeriod();
                    apPeriod = CommonServerUtils.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSPAYABLE).getCurrentPeriod();
                    if (arPeriod == null) {
                        arPeriod = apPeriod;
                    } else if (apPeriod == null) {
                        apPeriod = arPeriod;
                    }
                    conn = null;
                    pstmt = null;
                    rs = null;
                    sql = new StringBuffer("");
                    sql.append("SELECT vouentry.FIsHand, vouentry.FID FROM ");
                    sql.append(fAR != false ? "T_AR_VERIFICATIONBILL" : "T_AP_VERIFICATIONBILL").append(" bill");
                    sql.append(" INNER JOIN T_GL_VOUCHERENTRY vouentry ON bill.FVoucherID = vouentry.FBillID");
                    sql.append(" WHERE bill.FID = ?");
                    sql.append(" AND EXISTS (SELECT 1 FROM T_AR_CONTRASTACCOUNTVIEW account");
                    sql.append(" WHERE vouentry.FAccountID = account.FAccountID");
                    sql.append(" AND ((account.FSystem = 1 AND account.FPeriodYear = ? AND account.FPeriodNumber = ?)");
                    sql.append(" OR (account.FSystem = 2 AND account.FPeriodYear = ? AND account.FPeriodNumber = ?))");
                    sql.append(" AND account.FCompanyID = ?)");
                    try {
                        conn = this.getConnection(ctx);
                        pstmt = conn.prepareStatement(sql.toString());
                        pstmt.setString(1, srcBillPK.toString());
                        pstmt.setInt(2, arPeriod.getPeriodYear());
                        pstmt.setInt(3, arPeriod.getPeriodNumber());
                        pstmt.setInt(4, apPeriod.getPeriodYear());
                        pstmt.setInt(5, apPeriod.getPeriodNumber());
                        pstmt.setString(6, company.getId().toString());
                        rs = pstmt.executeQuery();
                        rowCount = 0;
                        while (rs.next()) {
                            if (rs.getInt(1) == 1) {
                                throw new OtherBillBizException(OtherBillBizException.VOUCHER_FROM_DAP);
                            }
                            ++rowCount;
                        }
                        if (rowCount <= 0) break block16;
                        sql.setLength(0);
                        sql.append("SELECT COUNT(0) FROM T_AR_ArApRelationEntry");
                        sql.append(" WHERE FDestObjectID = ? AND FSrcObjectID = ?");
                        pstmt = conn.prepareStatement(sql.toString());
                        pstmt.setString(1, ((BOTRelationInfo)relationInfo).getDestObjectID());
                        pstmt.setString(2, srcBillPK.toString());
                        rs = pstmt.executeQuery();
                        if (!rs.next() || (relationCount = rs.getInt(1)) != 0) break block16;
                        throw new OtherBillBizException(OtherBillBizException.DAP_RELATION_LOSS);
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable var16_23) {
                            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                            throw var16_23;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                break block18;
            }
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) {
                conn = null;
                try {
                    conn = this.getConnection(ctx);
                    idao = ORMappingDAO.getInstance((BOSObjectType)ArApConstants.ARAPRELATIONENTRY_TYPE, (Context)ctx, (Connection)conn);
                    botRelationEntryInfo = null;
                    relEntryInfo = null;
                    relSize = 0;
                    for (BOTRelationEntryInfo botRelationEntryInfo : ((BOTRelationInfo)relationInfo).getRelationEntries()) {
                        relEntryInfo = new ArApRelationEntryInfo();
                        relEntryInfo.setSrcObjectID(botRelationEntryInfo.getSrcObjectID());
                        relEntryInfo.setDestObjectID(botRelationEntryInfo.getDestObjectID());
                        relEntryInfo.setSrcEntryID(botRelationEntryInfo.getSrcEntryID());
                        relEntryInfo.setDestEntryID(botRelationEntryInfo.getDestEntryID());
                        relEntryInfo.setDate(Calendar.getInstance().getTime());
                        idao.addNewBatch((IObjectValue)relEntryInfo);
                        if (++relSize <= 2000) continue;
                        idao.executeBatch();
                        relSize = 0;
                    }
                    if (relSize <= 0) ** GOTO lbl99
                    idao.executeBatch();
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            } else if (BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) {
                DbUtil.execute((Context)ctx, (String)"DELETE FROM T_AR_ArApRelationEntry WHERE FDestObjectID = ?", (Object[])new Object[]{((BOTRelationInfo)relationInfo).getDestObjectID()});
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnum, relationInfo);
    }

    protected void reverse(Context ctx, IVerificationBillBase rmi, String[] idArr, Date verifyDate) throws BOSException, EASBizException {
        List<String> idList = Arrays.asList(idArr);
        HashSet<String> idSet = new HashSet<String>(idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (int j = 0; j < idList.size(); ++j) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(j));
                if (boolResult.booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)strResource, (String)"Error_ObjectUpdateLock_Request")));
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("isReversed", (Object)false));
            fi.getFilterItems().add(new FilterItemInfo("isReverseBill", (Object)false));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(fi);
            SelectorItemCollection sic = this.getSelector();
            ev.setSelector(sic);
            CoreBaseCollection blueCol = rmi.getCollection(ev);
            if (blueCol == null || blueCol.size() == 0 || blueCol.size() != idSet.size()) {
                Object[] arr = new String[]{ResourceBase.getString((String)RES, (String)"verification_condition_notInclude", (Locale)ctx.getLocale())};
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, arr);
            }
            VerificationBillBaseInfo blueInfo = (VerificationBillBaseInfo)blueCol.getObject(0);
            CompanyOrgUnitInfo company = blueInfo.getCompany();
            if (!this.verifyReverseDate(ctx, company, verifyDate)) {
                throw new ARAPVerifynException(ARAPVerifynException.REVERSEDATETOOEARLY);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date srcVerifyDate = blueInfo.getBizDate();
            if (DateUtil.dateDiff((Date)df.parse(df.format(srcVerifyDate)), (Date)verifyDate) < 0L) {
                throw new ARAPVerifynException(ARAPVerifynException.REVERSEDATEEARLIERTHANSRC);
            }
            StringBuffer idStr = new StringBuffer();
            boolean isFirst = true;
            int len = blueCol.size();
            for (int i = 0; i < len; ++i) {
                blueInfo = (VerificationBillBaseInfo)blueCol.get(i);
                if (!isFirst) {
                    idStr.append(", ");
                } else {
                    isFirst = false;
                }
                idStr.append("'").append(blueInfo.getId().toString()).append("'");
            }
            this.checkVerify(ctx, blueCol, idStr.toString());
            this.updateAssociateBills(ctx, idStr.toString(), false, true);
            CoreBaseCollection redCol = this.createRedVerificationBill(ctx, blueCol, verifyDate);
            Result ret = rmi.addnew(redCol);
            int len2 = blueCol.size();
            for (int i = 0; i < len2; ++i) {
                blueInfo = (VerificationBillBaseInfo)blueCol.get(i);
                blueInfo.setIsReversed(true);
            }
            rmi.update(blueCol);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
    }

    protected void checkVerify(Context ctx, CoreBaseCollection blueCol, String idStr) throws BOSException, EASBizException {
        this.checkHasBizBill(ctx, idStr);
        this.checkHasRedBlueRecPay(ctx, idStr);
    }

    protected void checkHasRedBlueRecPay(Context ctx, String idStr) throws BOSException, ARAPVerifynException {
        StringBuilder sqlBuilder = new StringBuilder(300);
        sqlBuilder.append("select FBILLID as id,FTHISVERIFICATEAMT as amt from ").append(this.entryTab).append(" veriEntry");
        sqlBuilder.append(" where veriEntry.fparentID in (").append(idStr).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        HashSet<String> bosTypeSet = new HashSet<String>();
        HashSet<Integer> symbolSet = new HashSet<Integer>();
        BOSObjectType bosType = null;
        try {
            String billId = null;
            BigDecimal amt = null;
            while (rs.next()) {
                billId = rs.getString("id");
                amt = rs.getBigDecimal("amt");
                symbolSet.add(amt.signum());
                bosType = new ObjectUuidPK(billId).getObjectType();
                bosTypeSet.add(bosType.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException("VerificationBillBaseControllerBean.checkHasRedBlueRecPay(Context, String)", (Throwable)e);
        }
        if (bosTypeSet.size() > 1) {
            return;
        }
        if (symbolSet.size() <= 1) {
            return;
        }
        if (null != bosType && !bosType.equals((Object)ArApConstants.PAY_TYPE) && !bosType.equals((Object)ArApConstants.REC_TYPE)) {
            return;
        }
        throw new ARAPVerifynException(ARAPVerifynException.HASREDBLUERECPAYNOTVERIFY);
    }

    protected void checkHasBizBill(Context ctx, String idStr) throws BOSException, ARAPVerifynException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select 1 from ").append(this.entryTab).append(" veriEntry");
        sqlBuilder.append(" join ").append(SystemEnum.ACCOUNTSPAYABLE.equals((Object)this.getSysEnum()) ? "T_AP_OTHERBILL" : "T_AR_OTHERBILL");
        sqlBuilder.append(" bill on veriEntry.fbillID = bill.fid");
        sqlBuilder.append(" where veriEntry.fparentID in (").append(idStr).append(") and bill.fisBizBill = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            if (rs.next()) {
                throw new ARAPVerifynException(ARAPVerifynException.BIZBILLVERIFICATIONBILLNOTVERIFY);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean verifyReverseDate(Context ctx, CompanyOrgUnitInfo company, Date verifyDate) throws BOSException, EASBizException {
        SystemStatusCtrolInfo sysStatusInfo = ArApBillHelper.getSysStatusCtrolInfo(ctx, company, this.getSysEnum());
        PeriodInfo currentPeriod = sysStatusInfo.getCurrentPeriod();
        Date beginDate = currentPeriod.getBeginDate();
        return DateUtil.dateDiff((Date)beginDate, (Date)verifyDate) >= 0L;
    }

    private CoreBaseCollection createRedVerificationBill(Context ctx, CoreBaseCollection blueCol, Date verifyDate) throws EASBizException, BOSException {
        CoreBaseCollection redCol = (CoreBaseCollection)blueCol.clone();
        int lenii = redCol.size();
        for (int ii = 0; ii < lenii; ++ii) {
            VerificationBillBaseInfo redInfo = (VerificationBillBaseInfo)redCol.getObject(ii);
            VerificationBillBaseInfo blueInfo = (VerificationBillBaseInfo)blueCol.getObject(ii);
            redInfo.setId(null);
            redInfo.setNumber(redInfo.getNumber() + "_reversed");
            redInfo.setVoucher(null);
            redInfo.setFiVouchered(false);
            redInfo.setVoucherNumber(null);
            BigDecimal mainThisVerificateAmt = redInfo.getMainThisVerificateAmt();
            BigDecimal mainThisVerificateAmtLoc = redInfo.getMainThisVerificateAmtLoc();
            redInfo.setMainThisVerificateAmt(mainThisVerificateAmt.negate());
            redInfo.setMainThisVerificateAmtLoc(mainThisVerificateAmtLoc.negate());
            redInfo.setSecondThisVerificateAmt(redInfo.getSecondThisVerificateAmt().negate());
            redInfo.setSecondThisVerificateAmtLoc(redInfo.getSecondThisVerificateAmtLoc().negate());
            redInfo.setGainAndLoss(redInfo.getGainAndLoss().negate());
            redInfo.setIsReversed(false);
            redInfo.setIsReverseBill(true);
            redInfo.setBizDate(verifyDate);
            redInfo.setReversedBillId(blueInfo.getId().toString());
            AbstractObjectCollection entrys = this.getVerificationEntrys(redInfo);
            int len = entrys.size();
            for (int i = 0; i < len; ++i) {
                VerificationBillBaseEntryInfo entry = (VerificationBillBaseEntryInfo)entrys.getObject(i);
                entry.setId(null);
                entry.setThisVerificateAmt(entry.getThisVerificateAmt().negate());
                entry.setThisVerificateAmtLoc(entry.getThisVerificateAmtLoc().negate());
                entry.setGainAndLoss(entry.getGainAndLoss().negate());
            }
        }
        return redCol;
    }

    protected abstract AbstractObjectCollection getVerificationEntrys(VerificationBillBaseInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unReverse(Context ctx, IVerificationBillBase rmi, String[] idArr) throws BOSException, EASBizException {
        List<String> idList = Arrays.asList(idArr);
        HashSet<String> idSet = new HashSet<String>(idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            VerificationBillBaseInfo redInfo;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (int j = 0; j < idList.size(); ++j) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(j));
                if (boolResult.booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)strResource, (String)"Error_ObjectUpdateLock_Request")));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("company.id");
            sic.add("bizDate");
            sic.add("reversedBillId");
            sic.add("entrys.id");
            sic.add("entrys.billID");
            sic.add("entrys.entryID");
            sic.add("entrys.thisVerificateAmt");
            sic.add("entrys.thisVerificateAmtLoc");
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("isReverseBill", (Object)true));
            fi.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)false));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(fi);
            ev.setSelector(sic);
            CoreBaseCollection redCol = rmi.getCollection(ev);
            HashMap<String, PeriodInfo> companyPeriodMap = new HashMap<String, PeriodInfo>();
            for (int i = redCol.size() - 1; i >= 0; --i) {
                redInfo = (VerificationBillBaseInfo)redCol.get(i);
                if (redInfo.getCompany() == null || redInfo.getCompany().getId() == null) {
                    redCol.remove(redCol.get(i));
                    continue;
                }
                PeriodInfo currentPeriod = (PeriodInfo)companyPeriodMap.get(redInfo.getCompany().getId().toString());
                if (currentPeriod == null) {
                    SystemStatusCtrolInfo sysStatusInfo = ArApBillHelper.getSysStatusCtrolInfo(ctx, redInfo.getCompany(), this.getSysEnum());
                    currentPeriod = sysStatusInfo.getCurrentPeriod();
                    companyPeriodMap.put(redInfo.getCompany().getId().toString(), currentPeriod);
                }
                Date beginDate = currentPeriod.getBeginDate();
                if (!redInfo.getBizDate().before(beginDate)) continue;
                redCol.remove(redCol.get(i));
            }
            if (redCol == null || redCol.size() <= 0 || redCol.size() != idSet.size()) {
                Object[] arr = new String[]{ResourceBase.getString((String)RES, (String)"verification_condition_notInclude", (Locale)ctx.getLocale())};
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, arr);
            }
            boolean isFirst = true;
            HashSet<String> tmpIdSet = new HashSet<String>();
            int len = redCol.size();
            for (int i = 0; i < len; ++i) {
                redInfo = (VerificationBillBaseInfo)redCol.get(i);
                tmpIdSet.add(redInfo.getId().toString());
            }
            String idStr = ArApBillHelper.ids2SqlString(tmpIdSet);
            this.checkBeforeUnReverse(ctx, tmpIdSet);
            this.updateAssociateBills(ctx, idStr, false, true);
            HashSet<String> blueIdSet = new HashSet<String>(redCol.size());
            Object[] redPks = new IObjectPK[redCol.size()];
            int len2 = redCol.size();
            for (int i = 0; i < len2; ++i) {
                redInfo = (VerificationBillBaseInfo)redCol.get(i);
                blueIdSet.add(redInfo.getReversedBillId());
                redPks[i] = new ObjectUuidPK(redInfo.getId());
            }
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("isReversed");
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", blueIdSet, CompareType.INCLUDE));
            ev = new EntityViewInfo();
            ev.setFilter(fi);
            ev.setSelector(sic);
            CoreBaseCollection blueCol = rmi.getCollection(ev);
            int len3 = blueCol.size();
            for (int i = 0; i < len3; ++i) {
                VerificationBillBaseInfo blueInfo = (VerificationBillBaseInfo)blueCol.get(i);
                blueInfo.setIsReversed(false);
            }
            rmi.update(blueCol);
            rmi.delete((IObjectPK[])redPks);
            if (null != redPks && redPks.length > 0) {
                FilterInfo delFilter = new FilterInfo();
                delFilter.getFilterItems().add(new FilterItemInfo("boID", (Object)StringUtils.arrayToString((Object[])redPks, (String)","), CompareType.INCLUDE));
                BoAttchAssoFactory.getLocalInstance((Context)ctx).delete(delFilter);
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
    }

    private void checkBeforeUnReverse(Context ctx, Set<String> idSet) throws BOSException, EASBizException {
        String veriIdOql = ArApBillHelper.ids2SqlString(idSet);
        Set<String> verifyAP2PaySet = this.getAP2PayVerifyIdSet(ctx, veriIdOql);
        HashSet<String> verifyPayrequest = new HashSet<String>();
        verifyPayrequest.addAll(idSet);
        verifyPayrequest.removeAll(verifyAP2PaySet);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT TOP 1 * FROM (").append(" \r\n ");
        sb.append(this.genSql4checkBeforeUnReverse("T_AR_OtherBillEntry", "FLockUnVerifyAmt", veriIdOql)).append(" \r\n ");
        if (!verifyAP2PaySet.isEmpty()) {
            sb.append(" UNION ALL ").append(" \r\n ");
            sb.append(this.genSql4checkBeforeUnReverse("T_AP_OtherBillEntry", "FLockUnVerifyAmt", ArApBillHelper.ids2SqlString(verifyAP2PaySet))).append(" \r\n ");
        }
        if (!verifyPayrequest.isEmpty()) {
            sb.append(" UNION ALL ").append(" \r\n ");
            sb.append(this.genPayReqSql4checkBeforeUnReverse(ArApBillHelper.ids2SqlString(verifyPayrequest))).append(" \r\n ");
        }
        sb.append(" UNION ALL ").append(" \r\n ");
        sb.append(this.genSql4checkBeforeUnReverse("T_CAS_PaymentBillEntry", "FUnLockAmt", veriIdOql)).append(" \r\n ");
        sb.append(" UNION ALL ").append(" \r\n ");
        sb.append(this.genSql4checkBeforeUnReverse("T_CAS_ReceivingBillEntry", "FUnLockAmt", veriIdOql)).append(" \r\n ");
        sb.append(" ) t1 WHERE SIGN(t1.veAmt) != SIGN(t1.entryUnLockAmt)").append(" \r\n ");
        sb.append(" OR ABS(veAmt) > ABS(entryUnLockAmt)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                throw new ARAPVerifynException(ARAPVerifynException.UNREVERSEGTUNLOCKAMT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String genSql4checkBeforeUnReverse(String billEntryTableName, String unLockAmtColumnName, String veriIdOql) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT SUM(ve.FThisVerificateAmt) * -1 veAmt, billEntry.").append(unLockAmtColumnName).append(" entryUnLockAmt FROM ").append(this.entryTab).append(" ve");
        sb.append(" INNER JOIN ").append(billEntryTableName).append(" billEntry ON ve.FEntryID = billEntry.fid");
        sb.append(" WHERE ve.fParentId in (").append(veriIdOql).append(")");
        sb.append(" group by ve.FEntryID, billEntry.").append(unLockAmtColumnName);
        return sb.toString();
    }

    protected void updateAssociateBills(Context ctx, String idList, boolean veriOrUnVeri, boolean needCalcLockAmt) throws BOSException, EASBizException {
        Object obj_FromBOTP = ctx.get((Object)"_VerificationBillFromBOTP");
        this.writeBackArOtherBill(ctx, obj_FromBOTP, idList, veriOrUnVeri, needCalcLockAmt);
        this.writeBackApOtherBill(ctx, obj_FromBOTP, idList, veriOrUnVeri, needCalcLockAmt);
        this.writeBackArApBillPlan(ctx, idList, veriOrUnVeri);
        this.writeBackReceiveBill(ctx, idList, veriOrUnVeri, needCalcLockAmt);
        this.writeBackPayRequestBill(ctx, idList, veriOrUnVeri);
        this.writeBackPaymentBill(ctx, idList, veriOrUnVeri, needCalcLockAmt);
        this.writeBackPurOrderBill(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackPurOrderBillByTrans(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackSubOrderBill(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackSubOrderBillByTrans(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackPurReturnBill(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackPurReturnBillByTrans(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackStockTransferBill(ctx, idList, veriOrUnVeri, false, VerificationEnum.AP_AR);
        this.writeBackSaleOrderBill(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackSaleOrderBillByTrans(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackSaleReturnBill(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackSaleReturnBillByTrans(ctx, idList, veriOrUnVeri, this.isAR());
        this.writeBackStockTransferBill(ctx, idList, veriOrUnVeri, true, VerificationEnum.AR_AP);
        this.dispose(ctx, idList, veriOrUnVeri);
        this.releaseTempTable(ctx);
        this.releaseVerifyTempTable(ctx);
    }

    protected void dispose(Context ctx, String veriBillIdsSqlStr, boolean veriOrUnVeri) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT bill.fid billId from ");
        sb.append(this.entryTab).append(" veriEntry INNER JOIN t_ap_otherBill bill on veriEntry.fBillId = bill.fid ");
        sb.append(" WHERE FParentId in (").append(veriBillIdsSqlStr).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> apBillIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                apBillIdSet.add(rs.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", apBillIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("entry.sourceBillID");
        ev.setFilter(fi);
        ev.setSelector(sic);
        OtherBillCollection col = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx).getOtherBillCollection(ev);
        APDisposeUtil.dispose(ctx, col, veriOrUnVeri ? DisposerActionEnum.VERIFY : DisposerActionEnum.UNVERIFY);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destCollection) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                BOTRelationInfo tempBotRelation = bOTRelationInfos.get(i);
                this._reverseSave(ctx, (IObjectPK)new ObjectStringPK(tempBotRelation.getSrcObjectID()), null, bOTBillOperStateEnum, (IObjectValue)tempBotRelation);
            }
            return;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String tableName = loader.getEntity(this.getBOSType()).getTable().getName();
        Connection conn = null;
        Statement stmt = null;
        try {
            String srcBillId;
            conn = this.getConnection(ctx);
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                StringBuffer pks = new StringBuffer("");
                for (int i = 0; i < srcBillPKs.length; ++i) {
                    pks.append("'").append(srcBillPKs[i].toString()).append("'");
                    pks.append(",");
                }
                if (pks.length() != 0) {
                    pks.deleteCharAt(pks.length() - 1);
                }
                String lockSql = "UPDATE " + tableName + " SET FLastUpdateTime = FLastUpdateTime WHERE FID IN (" + pks.toString() + ")";
                DbUtil.execute((Context)ctx, (String)lockSql);
                StringBuffer checkSql = new StringBuffer("");
                checkSql.append("SELECT fid  FROM ").append(tableName);
                checkSql.append(" WHERE FID IN (").append(pks.toString()).append(") and ffivouchered = 1");
                IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                if (checkResult.next()) {
                    throw new OtherBillBizException(OtherBillBizException.VOUCHERED);
                }
            }
            this.reverseSourceBill(ctx, conn, bOTBillOperStateEnum, bOTRelationInfos, tableName);
            if ("2652E01E".equals(bOTRelationInfos.get(0).getDestEntityID())) {
                ArApServerUtils.writeRecBillVoucherInfo4BadAcctCollect(ctx, bOTBillOperStateEnum, srcBillPKs);
            }
            if (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                int i;
                StringBuilder buf = new StringBuilder(120);
                buf.append(" (");
                int size = bOTRelationInfos.size();
                for (i = 0; i < size; ++i) {
                    srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    if (StringUtils.isEmpty((String)srcBillId)) continue;
                    buf.append("'").append(srcBillId).append("'");
                    if (i == size - 1) continue;
                    buf.append(",");
                }
                buf.append(" ) ");
                size = bOTRelationInfos.size();
                for (i = 0; i < size; ++i) {
                    String companyId;
                    BOTRelationInfo relationInfo = bOTRelationInfos.get(i);
                    String srcBillId2 = relationInfo.getSrcObjectID();
                    String destBillId = relationInfo.getDestObjectID();
                    String oql = "select id,company.id where id = '" + srcBillId2 + "'";
                    IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(this.getBOSType(), oql);
                    CompanyOrgUnitInfo company = ((VerificationBillBaseInfo)collection.getObject(0)).getCompany();
                    String string = companyId = company != null ? company.getId().toString() : "";
                    if (ArApParamHelper.isAR_045(ctx, companyId)) continue;
                    ArApServerUtils.canDapVoucherModifyEntry(ctx, buf.toString(), destBillId, companyId);
                }
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    BOTRelationInfo relationInfo = bOTRelationInfos.get(i);
                    srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    IORMappingDAO idao = ORMappingDAO.getInstance((BOSObjectType)ArApConstants.ARAPRELATIONENTRY_TYPE, (Context)ctx, (Connection)conn);
                    BOTRelationEntryInfo botRelationEntryInfo2 = null;
                    ArApRelationEntryInfo relEntryInfo = null;
                    int relSize = 0;
                    for (BOTRelationEntryInfo botRelationEntryInfo2 : relationInfo.getRelationEntries()) {
                        relEntryInfo = new ArApRelationEntryInfo();
                        relEntryInfo.setSrcObjectID(srcBillId);
                        relEntryInfo.setDestObjectID(destBillId);
                        relEntryInfo.setSrcEntryID(botRelationEntryInfo2.getSrcEntryID());
                        relEntryInfo.setDestEntryID(botRelationEntryInfo2.getDestEntryID());
                        relEntryInfo.setDate(Calendar.getInstance().getTime());
                        idao.addNewBatch((IObjectValue)relEntryInfo);
                        if (++relSize <= 2000) continue;
                        idao.executeBatch();
                        relSize = 0;
                    }
                    if (relSize <= 0) continue;
                    idao.executeBatch();
                }
            } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                stmt = conn.createStatement();
                String sql = null;
                BOTRelationInfo relationInfo = bOTRelationInfos.get(0);
                String destBillId = relationInfo.getDestObjectID();
                sql = "DELETE FROM T_AR_ArApRelationEntry WHERE FDestObjectID = '" + destBillId + "'";
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private void reverseSourceBill(Context ctx, Connection conn, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, String tableName) throws EASBizException, BOSException, SQLException {
        Object billInfo = null;
        String sql = "";
        if ("2652E01E".equals(bOTRelationInfos.get(0).getDestEntityID())) {
            Statement stmt = conn.createStatement();
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                BOTRelationInfo botRelation = bOTRelationInfos.get(i);
                String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                sql = BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) ? "update " + tableName + " set fvoucherid=null,fvouchernumber=null,fvouchertypeid=null,ffivouchered=0 where FID = '" + srcBillId + "'" : "Update " + tableName + " set (fvoucherid,fvouchernumber,fvouchertypeid,ffivouchered)= (select t2.fid,t2.fnumber,t2.fvouchertypeid,1 from t_gl_voucher t2 where t2.FID = '" + destBillId + "') where  " + tableName + ".FID = '" + srcBillId + "' ";
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
        }
    }

    private String getIdTempTble(Context ctx, String[] ids) throws BOSException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer createSql = new StringBuffer("create table tempTableName ( fid varchar(44))");
        String tempTableName = this.createTempTable(ctx, createSql.toString());
        ArrayList<String> sqlList = new ArrayList<String>();
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            sql.append("insert into ").append(tempTableName).append("(fid) values ('").append(ids[i]).append("');");
            sqlList.add(sql.toString());
            sql.setLength(0);
            if (sqlList.size() <= 200) continue;
            DBUtil.execBatchSql(ctx, sqlList, true);
            sqlList.clear();
        }
        DBUtil.execBatchSql(ctx, sqlList, true);
        return tempTableName;
    }

    public String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(this.getBOSType().toString());
            ais = this.resetAis(ctx, ais);
            TempTablePool pool = TempTablePool.getInstanceForRead((Context)ctx, (String)ais);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String resetAis(Context ctx, String ais) {
        Repository repo;
        if (ais.equals(ctx.getAIS()) && (repo = RepositoryFactory.getQueryRepository((Context)ctx)) != null) {
            return repo.getIdentity();
        }
        return ais;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("id"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("company.id"));
        selCol.add(new SelectorItemInfo("bizDate"));
        selCol.add(new SelectorItemInfo("mainAcctCussType"));
        selCol.add(new SelectorItemInfo("mainCurrency"));
        selCol.add(new SelectorItemInfo("secondAcctCussType"));
        selCol.add(new SelectorItemInfo("secondCurrency"));
        selCol.add(new SelectorItemInfo("voucher"));
        selCol.add(new SelectorItemInfo("voucherType"));
        selCol.add(new SelectorItemInfo("verificationType"));
        selCol.add(new SelectorItemInfo("fiVouchered"));
        selCol.add(new SelectorItemInfo("isSameCurrency"));
        selCol.add(new SelectorItemInfo("isSameCode"));
        selCol.add(new SelectorItemInfo("mainBillType"));
        selCol.add(new SelectorItemInfo("mainAcctCussID"));
        selCol.add(new SelectorItemInfo("mainAcctCussName"));
        selCol.add(new SelectorItemInfo("mainThisVerificateAmt"));
        selCol.add(new SelectorItemInfo("mainThisVerificateAmtLoc"));
        selCol.add(new SelectorItemInfo("gainAndLoss"));
        selCol.add(new SelectorItemInfo("secondBillType"));
        selCol.add(new SelectorItemInfo("secondAcctCussID"));
        selCol.add(new SelectorItemInfo("secondAcctCussName"));
        selCol.add(new SelectorItemInfo("secondThisVerificateAmt"));
        selCol.add(new SelectorItemInfo("secondThisVerificateAmtLoc"));
        selCol.add(new SelectorItemInfo("voucherNumber"));
        selCol.add(new SelectorItemInfo("isCashSalePur"));
        selCol.add(new SelectorItemInfo("isReversed"));
        selCol.add(new SelectorItemInfo("isReverseBill"));
        selCol.add(new SelectorItemInfo("reversedBillId"));
        selCol.add(new SelectorItemInfo("entrys.billType"));
        selCol.add(new SelectorItemInfo("entrys.billSubType"));
        selCol.add(new SelectorItemInfo("entrys.billID"));
        selCol.add(new SelectorItemInfo("entrys.entryID"));
        selCol.add(new SelectorItemInfo("entrys.billDate"));
        selCol.add(new SelectorItemInfo("entrys.billNumber"));
        selCol.add(new SelectorItemInfo("entrys.acctCussID"));
        selCol.add(new SelectorItemInfo("entrys.acctCussName"));
        selCol.add(new SelectorItemInfo("entrys.comment"));
        selCol.add(new SelectorItemInfo("entrys.thisVerificateAmt"));
        selCol.add(new SelectorItemInfo("entrys.thisVerificateAmtLoc"));
        selCol.add(new SelectorItemInfo("entrys.gainAndLoss"));
        selCol.add(new SelectorItemInfo("entrys.materialName"));
        selCol.add(new SelectorItemInfo("entrys.materialNumber"));
        selCol.add(new SelectorItemInfo("entrys.materialId"));
        selCol.add(new SelectorItemInfo("entrys.acctCussType"));
        selCol.add(new SelectorItemInfo("entrys.currency"));
        selCol.add(new SelectorItemInfo("entrys.account"));
        selCol.add(new SelectorItemInfo("entrys.adminOrgUnit"));
        selCol.add(new SelectorItemInfo("entrys.person"));
        selCol.add(new SelectorItemInfo("entrys.oppAccount"));
        selCol.add(new SelectorItemInfo("entrys.veriType"));
        selCol.add(new SelectorItemInfo("entrys.veriRecPayTypeName"));
        selCol.add(new SelectorItemInfo("entrys.veriRecPayTypeNumber"));
        selCol.add(new SelectorItemInfo("entrys.veriRecPayTypeId"));
        selCol.add(new SelectorItemInfo("entrys.isFromBOTP"));
        selCol.add(new SelectorItemInfo("entrys.lastExhangeRate"));
        selCol.add(new SelectorItemInfo("entrys.isPreVerify"));
        return selCol;
    }

    protected boolean isAR() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unVerify(Context ctx, Collection ids, boolean checkBizBill) throws BOSException, EASBizException {
        super.unVerify(ctx, ids, checkBizBill);
        boolean isEnable = WfEventListenerStateManager.getInstance().isEnable();
        if (isEnable) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        try {
            this.deleteImage(ctx, ids);
        }
        finally {
            if (isEnable) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unVerify(Context ctx, Collection billIDs, boolean checkBizBill) throws BOSException, EASBizException {
        boolean isAR = this.isAR();
        this.entryTab = isAR ? "T_Ar_VerificationBillentry" : "T_Ap_VerificationBillentry";
        Object obj_FromBOTP = ctx.get((Object)"_VerificationBillFromBOTP");
        boolean veriOrUnVeri = false;
        StringBuilder ids = new StringBuilder(100);
        Iterator iter = billIDs.iterator();
        HashSet<String> idSet = new HashSet<String>();
        String id = null;
        while (iter.hasNext()) {
            id = iter.next().toString();
            ids.append("'").append(id).append("',");
            idSet.add(id);
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        String idList = ids.toString();
        IObjectPK logPk = this.writeUnVeriLog(ctx, ids.toString(), isAR);
        ArrayList lockObjs = new ArrayList();
        try {
            this._unVeriCheck(ctx, idList, billIDs, lockObjs, checkBizBill);
            this.writeBackArOtherBill(ctx, obj_FromBOTP, idList, veriOrUnVeri, false);
            this.writeBackApOtherBill(ctx, obj_FromBOTP, idList, veriOrUnVeri, false);
            this.writeBackArApBillPlan(ctx, idList, veriOrUnVeri);
            this.writeBackReceiveBill(ctx, idList, veriOrUnVeri, false);
            this.writeBackPaymentBill(ctx, idList, veriOrUnVeri, false);
            this.writeBackPurOrderBill(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackPurOrderBillByTrans(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackSubOrderBill(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackSubOrderBillByTrans(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackPurReturnBill(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackPurReturnBillByTrans(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackStockTransferBill(ctx, idList, veriOrUnVeri, false, VerificationEnum.AP_AR);
            this.writeBackSaleOrderBill(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackSaleOrderBillByTrans(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackSaleReturnBill(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackSaleReturnBillByTrans(ctx, idList, veriOrUnVeri, isAR);
            this.writeBackStockTransferBill(ctx, idList, veriOrUnVeri, true, VerificationEnum.AR_AP);
            this.recycleNum(ctx, idList, isAR);
            this.dispose(ctx, idList, false);
            this.delete(ctx, " where id in (" + idList + ")");
            if (null != idSet && idSet.size() > 0) {
                FilterInfo delFilter = new FilterInfo();
                delFilter.getFilterItems().add(new FilterItemInfo("boID", idSet, CompareType.INCLUDE));
                BoAttchAssoFactory.getLocalInstance((Context)ctx).delete(delFilter);
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        finally {
            this.releaseTempTable(ctx);
            this.releaseVerifyTempTable(ctx);
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex.batchReleaseObjIDForUpdate(lockObjs);
            lockObjs.clear();
        }
    }

    protected void deleteImage(Context ctx, Collection billIDs) throws BOSException {
        if (billIDs == null && billIDs.size() == 0) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        IBillImageFacade billImgFac = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        Object uuid = null;
        boolean isArVerification = false;
        String deleteImageRemake = "";
        Iterator iter = billIDs.iterator();
        String id = null;
        while (iter.hasNext()) {
            id = iter.next().toString();
            BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteSSCAndImageDataByBillID(id, true);
        }
    }

    protected void _unVeriCheck(Context ctx, String ids, Collection billIDs, List lockObjs, boolean checkBizBill) throws BOSException, EASBizException {
    }

    protected void checkAmtAfterVerify(Context ctx, String ids, boolean veriOrUnVeri, boolean isAr) throws BOSException, EASBizException {
        String billTblName = isAr ? "T_AR_OTHERBILL" : "T_AP_OTHERBILL";
        String entryTblName = isAr ? "T_AR_OTHERBILLENTRY" : "T_AP_OTHERBILLENTRY";
        StringBuilder checkSql = new StringBuilder();
        this.setVerifyTempTable(ctx, ids);
        checkSql.append(" SELECT bill.FNUMBER as FNumber ");
        checkSql.append(" , CASE WHEN (entry.FRECIEVEPAYAMOUNT * entry.FUNVERIFYAMOUNT < 0 OR entry.FVERIFYAMOUNT + entry.FUNVERIFYAMOUNT <> entry.FRECIEVEPAYAMOUNT) THEN '1'  ");
        checkSql.append(" WHEN (entry.FRECIEVEPAYAMOUNT * entry.FLockUnVerifyAmt < 0 OR entry.FLOCKVERIFYAMT + entry.FLOCKUNVERIFYAMT <> entry.FRECIEVEPAYAMOUNT) THEN '2' END AS checkType ");
        checkSql.append(" FROM ").append(billTblName).append(" bill ");
        checkSql.append(" INNER JOIN ").append(entryTblName).append(" entry ");
        checkSql.append(" on bill.FID = entry.FPARENTID ");
        checkSql.append(" INNER JOIN ").append(this.verifyTempTable).append(" verify1");
        checkSql.append(" on verify1.FBILLID = bill.FID");
        checkSql.append(" and ((entry.FRECIEVEPAYAMOUNT * entry.FUNVERIFYAMOUNT < 0 OR entry.FVERIFYAMOUNT + entry.FUNVERIFYAMOUNT <> entry.FRECIEVEPAYAMOUNT) ");
        checkSql.append("OR (entry.FRECIEVEPAYAMOUNT * entry.FLockUnVerifyAmt < 0 OR entry.FLOCKVERIFYAMT + entry.FLOCKUNVERIFYAMT <> entry.FRECIEVEPAYAMOUNT)) ");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        HashSet<String> billNumberSet = new HashSet<String>();
        String checkType = "";
        try {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("FNumber"))) continue;
                billNumberSet.add(rowSet.getString("FNumber"));
                checkType = rowSet.getString("checkType");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (billNumberSet.size() > 0) {
            StringBuilder numberBuilder = new StringBuilder();
            for (String billNumber : billNumberSet) {
                numberBuilder.append(billNumber).append(",");
            }
            String billName = isAr ? ResourceBase.getString((String)RES, (String)"78_OtherBillListUI", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"2_OtherBillListUI", (Locale)ctx.getLocale());
            String operation = veriOrUnVeri ? ResourceBase.getString((String)RES, (String)"225_verify", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"unVerify", (Locale)ctx.getLocale());
            String numStr = numberBuilder.substring(0, numberBuilder.length() - 1);
            if ("1".equalsIgnoreCase(checkType)) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{ResourceBase.getString((String)RES, (String)"226_WRITE_BACK_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{billName, operation, numStr})});
            }
            if ("2".equalsIgnoreCase(checkType)) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{ResourceBase.getString((String)RES, (String)"LOCKAMT_WRITE_BACK_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{billName, operation, numStr})});
            }
        }
    }

    protected Set<String> getAP2PayVerifyIdSet(Context ctx, String ids) throws BOSException {
        StringBuilder checkStr = new StringBuilder();
        checkStr.append("SELECT ve.FID as FID, ve.FPARENTID as verifyBillId FROM ").append(this.entryTab).append(" ve");
        checkStr.append(" inner join T_CAS_PAYMENTBILLENTRY payEntry ");
        checkStr.append(" on ve.FENTRYID = payEntry.FID  ");
        checkStr.append(" INNER JOIN T_AP_OTHERBILLENTRY otherEntry ");
        checkStr.append(" on payEntry.FSOURCEBILLENTRYID = otherEntry.FID  ");
        checkStr.append(" where ve.FPARENTID in (").append(ids).append(")");
        checkStr.append(" union all ");
        checkStr.append(" SELECT ve.FID as FID, ve.FPARENTID as verifyBillId FROM ").append(this.entryTab).append(" ve");
        checkStr.append(" WHERE ve.FPARENTID in (").append(ids).append(")");
        checkStr.append(" AND ve.FISFROMBOTP = 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkStr.toString());
        HashSet<String> isAP2PayVerifyIdSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                isAP2PayVerifyIdSet.add(rowSet.getString("verifyBillId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        return isAP2PayVerifyIdSet;
    }

    protected void writeBackPayRequestBill(Context ctx, String ids, boolean veriOrUnVeri) throws BOSException, EASBizException {
        String unlockSymbol;
        StringBuilder selectStr = new StringBuilder();
        selectStr.append("SELECT payEntry.FSOURCEBILLID  as FSOURCEBILLID");
        selectStr.append(" ,payEntry.FSOURCEBILLENTRYID as FSOURCEBILLENTRYID");
        selectStr.append(" ,result.FEntryID as FEntryID");
        selectStr.append(" ,result.FThisVerificateAmt as FThisVerificateAmt");
        selectStr.append(" ,result.FThisVerificateAmtLoc as FThisVerificateAmtLoc");
        selectStr.append(" FROM T_CAS_PAYMENTBILLENTRY payEntry ");
        selectStr.append(" INNER JOIN (");
        selectStr.append("   SELECT ve.FEntryID AS FEntryID ");
        selectStr.append("   ,sum(ve.FThisVerificateAmt) AS FThisVerificateAmt");
        selectStr.append("   ,sum(ve.FThisVerificateAmtLoc) AS FThisVerificateAmtLoc");
        selectStr.append(" FROM  ").append(this.entryTab).append(" ve");
        selectStr.append(" WHERE ve.FPARENTID IN (").append(ids).append(")");
        selectStr.append("     AND FIsFromBOTP = 1");
        selectStr.append("     GROUP BY ve.FENTRYID");
        selectStr.append(" ) result ON result.FEntryID = payEntry.FId ");
        selectStr.append("INNER JOIN T_AP_PAYREQUESTBILL payReq ON payReq.FID = payEntry.FSOURCEBILLID ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectStr.toString());
        HashMap entryMap = new HashMap();
        HashMap sumEntryMap = new HashMap();
        HashSet<String> reqBillIdSet = new HashSet<String>();
        try {
            String sourceBillId = null;
            String sourceEntryId = null;
            BigDecimal thisVerifyAmt = BigDecimal.ZERO;
            BigDecimal thisVerifyAmtLoc = BigDecimal.ZERO;
            while (rowSet.next()) {
                sourceBillId = rowSet.getString("FSOURCEBILLID");
                sourceEntryId = rowSet.getString("FSOURCEBILLENTRYID");
                thisVerifyAmt = rowSet.getBigDecimal("FThisVerificateAmt");
                thisVerifyAmtLoc = rowSet.getBigDecimal("FThisVerificateAmtLoc");
                if (entryMap.get(sourceEntryId) != null) {
                    thisVerifyAmt = thisVerifyAmt.add((BigDecimal)((Map)entryMap.get(sourceEntryId)).get("thisVerifyAmt"));
                    thisVerifyAmtLoc = thisVerifyAmtLoc.add((BigDecimal)((Map)entryMap.get(sourceEntryId)).get("thisVerifyAmtLoc"));
                }
                if (sumEntryMap.get(sourceEntryId) != null) {
                    thisVerifyAmt = thisVerifyAmt.add((BigDecimal)((Map)sumEntryMap.get(sourceEntryId)).get("thisVerifyAmt"));
                    thisVerifyAmtLoc = thisVerifyAmtLoc.add((BigDecimal)((Map)sumEntryMap.get(sourceEntryId)).get("thisVerifyAmtLoc"));
                }
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                tempMap.put("sourceBillId", sourceBillId);
                tempMap.put("sourceEntryId", sourceEntryId);
                tempMap.put("thisVerifyAmt", thisVerifyAmt);
                tempMap.put("thisVerifyAmtLoc", thisVerifyAmtLoc);
                if (ApServerUtils.isPayReqSumEntry(sourceEntryId)) {
                    sumEntryMap.put(sourceEntryId, tempMap);
                } else {
                    entryMap.put(sourceEntryId, tempMap);
                }
                reqBillIdSet.add(sourceBillId);
            }
        }
        catch (SQLException e) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        if (entryMap.isEmpty() && sumEntryMap.isEmpty()) {
            return;
        }
        String lockSymbol = veriOrUnVeri ? "+" : "-";
        String string = unlockSymbol = veriOrUnVeri ? "-" : "+";
        if (!entryMap.isEmpty()) {
            PayRequestBillEntryInfo prEntryInfo;
            HashMap<String, PayRequestBillEntryInfo> IdPrInfoMap = new HashMap<String, PayRequestBillEntryInfo>();
            Set srcBillIdSet = entryMap.keySet();
            HashSet<String> billIdSet = new HashSet<String>();
            IPayRequestBillEntry iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setSelector(ArApSelectorFactory.getPayRequestBillEntrySelector(""));
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.exchange_rate"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.currency.id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.company.id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.company.baseCurrency.precision"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("parent.billDate"));
            FilterInfo entryFilter1 = new FilterInfo();
            entryFilter1.getFilterItems().add(new FilterItemInfo("id", srcBillIdSet, CompareType.INCLUDE));
            entityViewInfo.setFilter(entryFilter1);
            PayRequestBillEntryCollection prEntryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(entityViewInfo);
            for (int i = 0; i < prEntryColl.size(); ++i) {
                prEntryInfo = prEntryColl.get(i);
                IdPrInfoMap.put(prEntryInfo.getId().toString(), prEntryInfo);
                billIdSet.add(prEntryInfo.getParent().getId().toString());
            }
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE T_AP_PAYREQUESTBILLENTRY ");
            updateSql.append(" SET FLOCKAMOUNT = FLOCKAMOUNT ").append(lockSymbol).append("? ,");
            updateSql.append("     FLOCKAMOUNTLOC = FLOCKAMOUNTLOC ").append(lockSymbol).append("? ,");
            updateSql.append("     FUNLOCKAMOUNT = FUNLOCKAMOUNT ").append(unlockSymbol).append("? ,");
            updateSql.append("     FUNLOCKAMOUNTLOC = FUNLOCKAMOUNTLOC ").append(unlockSymbol).append("?");
            updateSql.append(" WHERE FID = ?");
            BigDecimal thisWriteBackAmt = BigDecimal.ZERO;
            BigDecimal thisWriteBackAmtLoc = BigDecimal.ZERO;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            String srcBillID = null;
            boolean isDirectExchangeRate = true;
            BigDecimal exchangeRate = BigDecimal.ZERO;
            int precision = 0;
            for (Map.Entry tempEntry : entryMap.entrySet()) {
                Map infoMap = (Map)tempEntry.getValue();
                prEntryInfo = (PayRequestBillEntryInfo)IdPrInfoMap.get((String)infoMap.get("sourceEntryId"));
                if (prEntryInfo == null) continue;
                if (null == srcBillID || !srcBillID.equals(prEntryInfo.getParent().getId().toString())) {
                    srcBillID = prEntryInfo.getParent().getId().toString();
                    isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(BaseDataUtil.getExchangeRate(ctx, prEntryInfo.getParent().getCompany(), prEntryInfo.getParent().getCurrency(), prEntryInfo.getParent().getBizDate()));
                    exchangeRate = prEntryInfo.getParent().getExchange_rate();
                    precision = prEntryInfo.getParent().getCompany().getBaseCurrency().getPrecision();
                }
                thisWriteBackAmt = (BigDecimal)infoMap.get("thisVerifyAmt");
                thisWriteBackAmtLoc = veriOrUnVeri ? (thisWriteBackAmt.compareTo(prEntryInfo.getUnLockAmount()) == 0 ? prEntryInfo.getUnLockAmountLoc() : BaseDataUtil.caculateLocalAmount(thisWriteBackAmt, exchangeRate, isDirectExchangeRate, precision)) : (thisWriteBackAmt.compareTo(prEntryInfo.getLockAmount()) == 0 ? prEntryInfo.getLockAmountLoc() : BaseDataUtil.caculateLocalAmount(thisWriteBackAmt, exchangeRate, isDirectExchangeRate, precision));
                Object[] params = new Object[]{thisWriteBackAmt, thisWriteBackAmtLoc, thisWriteBackAmt, thisWriteBackAmtLoc, infoMap.get("sourceEntryId")};
                paramsList.add(params);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
            IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
            IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
            ArApBillReverseHelper.writeBackSumEntry(iPayRequestBill, iPayRequestSumEntry, billIdSet);
        }
        if (!sumEntryMap.isEmpty()) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("UPDATE T_AP_PAYREQUESTSUMENTRY ");
            updateSql.append(" SET FLOCKAMOUNT = isnull(FLOCKAMOUNT, 0) ").append(lockSymbol).append("? ,");
            updateSql.append("     FLOCKAMOUNTLOC = isnull(FLOCKAMOUNTLOC, 0) ").append(lockSymbol).append("? ,");
            updateSql.append("     FUNLOCKAMOUNT = isnull(FUNLOCKAMOUNT, 0) ").append(unlockSymbol).append("? ,");
            updateSql.append("     FUNLOCKAMOUNTLOC = isnull(FUNLOCKAMOUNTLOC, 0) ").append(unlockSymbol).append("?");
            updateSql.append(" WHERE FID = ?");
            IPayRequestBillEntry iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            CoreBaseCollection needUpdateColl = new CoreBaseCollection();
            for (Map.Entry entry : entryMap.entrySet()) {
                Map infoMap = (Map)entry.getValue();
                Object[] params = new Object[]{infoMap.get("thisVerifyAmt"), infoMap.get("thisVerifyAmtLoc"), infoMap.get("thisVerifyAmt"), infoMap.get("thisVerifyAmtLoc"), infoMap.get("sourceEntryId")};
                paramsList.add(params);
                this.writeBackReqEntry(iPayRequestBillEntry, needUpdateColl, infoMap, veriOrUnVeri);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
            int size = needUpdateColl.size();
            if (size > 0) {
                iPayRequestBillEntry.update(needUpdateColl);
            }
        }
        String checkBillIds = ApServerUtils.getSqlIds(reqBillIdSet);
        StringBuilder checkSql = new StringBuilder();
        checkSql.append("SELECT bill.FNUMBER as FNUMBER");
        checkSql.append(" FROM T_AP_PAYREQUESTBILL bill");
        checkSql.append(" INNER JOIN T_AP_PAYREQUESTBILLENTRY entry ON BILL.FID = ENTRY.FPARENTID");
        checkSql.append(" WHERE bill.FID IN (").append(checkBillIds).append(")");
        checkSql.append(" AND ((entry.FAUDITAMOUNT * entry.FUNLOCKAMOUNT) < 0 ");
        checkSql.append(" OR (entry.FAUDITAMOUNT * entry.FLOCKAMOUNT) < 0 OR entry.FLOCKAMOUNT + entry.FUNLOCKAMOUNT <> entry.FAUDITAMOUNT);");
        IRowSet checkRowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        StringBuilder numStr = new StringBuilder();
        int index = 0;
        try {
            while (checkRowSet.next()) {
                if (0 == index) {
                    numStr.append(checkRowSet.getString("FNUMBER"));
                } else {
                    numStr.append(",").append(checkRowSet.getString("FNUMBER"));
                }
                ++index;
            }
        }
        catch (SQLException sQLException) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)sQLException);
        }
        if (index > 0) {
            throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{ResourceBase.getString((String)RES, (String)"223_WRITE_BACK_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{numStr})});
        }
        this.recordWriteBackLogs(ctx, ids, veriOrUnVeri);
    }

    protected void writeBackReqEntry(IPayRequestBillEntry iPayRequestBillEntry, CoreBaseCollection needUpdateColl, Map<String, Object> infoMap, boolean veriOrUnVeri) throws BOSException {
        BigDecimal thisVerifyAmt = (BigDecimal)infoMap.get("thisVerifyAmt");
        BigDecimal thisVerifyAmtLoc = (BigDecimal)infoMap.get("thisVerifyAmtLoc");
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(ArApSelectorFactory.getPayRequestBillEntrySelector(""));
        FilterInfo entryFilter1 = new FilterInfo();
        entryFilter1.getFilterItems().add(new FilterItemInfo("sumEntryID", infoMap.get("sourceEntryId"), CompareType.EQUALS));
        view.setFilter(entryFilter1);
        PayRequestBillEntryCollection entryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(view);
        if (null == entryColl || entryColl.size() == 0) {
            return;
        }
        Iterator entryCollIterator = entryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        BigDecimal LockAmt = BigDecimal.ZERO;
        BigDecimal LockAmtLoc = BigDecimal.ZERO;
        BigDecimal unLockAmt = BigDecimal.ZERO;
        BigDecimal unLockAmtLoc = BigDecimal.ZERO;
        BigDecimal rowAllanceAmt = BigDecimal.ZERO;
        BigDecimal rowAllanceAmtLoc = BigDecimal.ZERO;
        while (entryCollIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)entryCollIterator.next();
            LockAmt = entryInfo.getLockAmount();
            LockAmtLoc = entryInfo.getLockAmountLoc();
            unLockAmt = entryInfo.getUnLockAmount();
            unLockAmtLoc = entryInfo.getUnLockAmountLoc();
            rowAllanceAmt = veriOrUnVeri ? unLockAmt : LockAmt;
            BigDecimal bigDecimal = rowAllanceAmtLoc = veriOrUnVeri ? unLockAmtLoc : unLockAmtLoc;
            if (rowAllanceAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (rowAllanceAmt.compareTo(thisVerifyAmt) >= 0) {
                rowAllanceAmt = thisVerifyAmt;
                rowAllanceAmtLoc = thisVerifyAmtLoc;
            }
            if (veriOrUnVeri) {
                entryInfo.setLockAmount(entryInfo.getLockAmount().add(rowAllanceAmt));
                entryInfo.setLockAmountLoc(entryInfo.getLockAmountLoc().add(rowAllanceAmtLoc));
                entryInfo.setUnLockAmount(unLockAmt.subtract(rowAllanceAmt));
                entryInfo.setUnLockAmountLoc(unLockAmtLoc.subtract(rowAllanceAmtLoc));
            } else {
                entryInfo.setLockAmount(LockAmt.subtract(rowAllanceAmt));
                entryInfo.setLockAmountLoc(LockAmtLoc.subtract(rowAllanceAmtLoc));
                entryInfo.setUnLockAmount(entryInfo.getUnLockAmount().add(rowAllanceAmt));
                entryInfo.setUnLockAmountLoc(entryInfo.getUnLockAmountLoc().add(rowAllanceAmtLoc));
            }
            thisVerifyAmt = thisVerifyAmt.subtract(rowAllanceAmt);
            thisVerifyAmtLoc = thisVerifyAmtLoc.subtract(rowAllanceAmtLoc);
            needUpdateColl.add((CoreBaseInfo)entryInfo);
            if (thisVerifyAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
    }

    protected void recordWriteBackLogs(Context ctx, String ids, boolean veriOrUnVeri) throws BOSException {
        String opertion = veriOrUnVeri ? ResourceBase.getString((String)RES, (String)"unReverse", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"reverse", (Locale)ctx.getLocale());
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT T_ARAP_LOG (");
        insertSql.append("\tfsrcbillid,fsrcbillentryid");
        insertSql.append("\t,FLOCKVERIFYAMT ,FAmount");
        insertSql.append("\t,fdestbillid ,fdestbillentryid, fremark )");
        insertSql.append("SELECT result.fsrcbillid");
        insertSql.append("\t,result.fsrcbillentryid");
        insertSql.append("\t,result.FLOCKVERIFYAMT");
        insertSql.append("\t,result.FAmount");
        insertSql.append("\t,result.fdestbillid");
        insertSql.append("\t,result.fdestbillentryid");
        insertSql.append("\t,result.fremark");
        insertSql.append(" FROM (");
        insertSql.append("\tSELECT ve.FID AS fsrcbillid");
        insertSql.append("\t\t,ve.FPARENTID AS fsrcbillentryid");
        insertSql.append("\t\t,ve.FTHISVERIFICATEAMT AS FLOCKVERIFYAMT");
        insertSql.append("\t\t,reqEntry.FAUDITAMOUNT AS FAmount");
        insertSql.append("\t\t,reqEntry.FPARENTID AS fdestbillid");
        insertSql.append("\t\t,reqEntry.FID AS fdestbillentryid");
        insertSql.append("\t\t,'").append(ResourceBase.getString((String)RES, (String)"224_WRITE_BACK_LOG", (Locale)ctx.getLocale(), (Object[])new Object[]{opertion})).append("' as fremark ");
        insertSql.append("\tFROM ").append(this.entryTab).append(" ve");
        insertSql.append("\tINNER JOIN T_CAS_PAYMENTBILLENTRY payEntry");
        insertSql.append("\ton ve.FENTRYID = payEntry.FID ");
        insertSql.append("\tINNER JOIN T_AP_PAYREQUESTBILLENTRY reqEntry");
        insertSql.append("\ton reqEntry.FID = payEntry.FSOURCEBILLENTRYID ");
        insertSql.append("\twhere ve.FPARENTID in (").append(ids).append(")");
        insertSql.append(" union all");
        insertSql.append("\tSELECT ve.FID AS fsrcbillid");
        insertSql.append("\t\t,ve.FPARENTID AS fsrcbillentryid");
        insertSql.append("\t\t,ve.FTHISVERIFICATEAMT AS FLOCKVERIFYAMT");
        insertSql.append("\t\t,reqSumEntry.FAUDITAMOUNT AS FAmount");
        insertSql.append("\t\t,reqSumEntry.FPARENTID AS fdestbillid");
        insertSql.append("\t\t,reqSumEntry.FID AS fdestbillentryid");
        insertSql.append("\t\t,'").append(ResourceBase.getString((String)RES, (String)"225_WRITE_BACK_LOG", (Locale)ctx.getLocale(), (Object[])new Object[]{opertion})).append("' as fremark ");
        insertSql.append("\tFROM ").append(this.entryTab).append(" ve");
        insertSql.append("\tINNER JOIN T_CAS_PAYMENTBILLENTRY payEntry ");
        insertSql.append("\tON ve.FENTRYID = payEntry.FID");
        insertSql.append("\tINNER JOIN T_AP_PAYREQUESTSUMENTRY reqSumEntry");
        insertSql.append("\tON reqSumEntry.FID = payEntry.FSOURCEBILLENTRYID");
        insertSql.append("\tWHERE ve.FPARENTID in (").append(ids).append(")");
        insertSql.append(") as result");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    protected String genPayReqSql4checkBeforeUnReverse(String veriIdOql) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT (result.reverseAmt)* -1 as veAmt, result.entryAmt as entryUnLockAmt FROM ");
        sb.append(" (SELECT reqEntry.funLockAmount as entryAmt,sum(ve.FTHISVERIFICATEAMT) as reverseAmt FROM T_AP_VerificationBillentry ve");
        sb.append(" inner join T_cas_paymentbillentry payEntry");
        sb.append(" on ve.FENTRYID = payEntry.FID ");
        sb.append(" INNER JOIN T_ap_payrequestbillentry reqEntry");
        sb.append(" on payEntry.FSOURCEBILLENTRYID = reqEntry.FID ");
        sb.append(" where ve.FPARENTID in (").append(veriIdOql).append(")");
        sb.append(" group by reqEntry.FID,reqEntry.funLockAmount");
        sb.append(" union all ");
        sb.append(" SELECT sumEntry.funLockAmount as entryAmt,sum(ve.FTHISVERIFICATEAMT) as reverseAmt FROM T_AP_VerificationBillentry ve");
        sb.append(" inner join T_cas_paymentbillentry payEntry");
        sb.append(" on ve.FENTRYID = payEntry.FID ");
        sb.append(" INNER JOIN T_ap_payrequestSumentry sumEntry");
        sb.append(" on payEntry.FSOURCEBILLENTRYID = sumEntry.FID ");
        sb.append(" where ve.FPARENTID in (").append(veriIdOql).append(")");
        sb.append(" group by sumEntry.FID,sumEntry.funLockAmount) result");
        return sb.toString();
    }

    public boolean _needCheckRebuild4DAP(Context ctx) throws BOSException {
        return true;
    }

    private void checkAmtAfterVerifyForRecPay(Context ctx, String ids, boolean veriOrUnVeri, Boolean isRec) throws EASBizException, BOSException {
        String billTblName = isRec != false ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill";
        String entryTblName = isRec != false ? "T_CAS_ReceivingBillEntry" : "T_CAS_PaymentBillEntry";
        String billFields = isRec != false ? "FReceivingBillID" : "FPaymentBillID";
        Integer billType = isRec != false ? new Integer(6) : new Integer(4);
        this.setVerifyTempTable(ctx, ids);
        StringBuilder checkSql = new StringBuilder(300);
        checkSql.append(" SELECT bill.FNUMBER as FNumber ");
        checkSql.append(" , CASE WHEN (entry.fAmount * entry.fUnVcAmount  < 0 OR entry.FAMOUNTVC + entry.fUnVcAmount <> entry.fAmount) THEN '1' ");
        checkSql.append(" WHEN (entry.fAmount * entry.FUnLockAmt  < 0 OR entry.FLOCKAMT + entry.FUnLockAmt <> entry.fAmount ) THEN '2' END AS checkType");
        checkSql.append(" FROM ").append(billTblName).append(" bill ");
        checkSql.append(" INNER JOIN ").append(entryTblName).append(" entry ");
        checkSql.append(" on bill.FID = entry.").append(billFields).append(" ");
        checkSql.append(" INNER JOIN ").append(this.verifyTempTable).append(" verify1");
        checkSql.append(" on verify1.FBILLID = bill.FID");
        checkSql.append(" where verify1.FBillType = ").append(billType);
        checkSql.append(" and ((entry.fAmount * entry.fUnVcAmount  < 0 OR entry.FAMOUNTVC + entry.fUnVcAmount <> entry.fAmount) ");
        checkSql.append(" OR (entry.fAmount * entry.FUnLockAmt  < 0 OR entry.FLOCKAMT + entry.FUnLockAmt <> entry.fAmount ))");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        HashSet<String> billNumberSet = new HashSet<String>();
        String checkType = "";
        try {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("FNumber"))) continue;
                billNumberSet.add(rowSet.getString("FNumber"));
                checkType = rowSet.getString("checkType");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (billNumberSet.size() > 0) {
            StringBuilder numberBuilder = new StringBuilder();
            for (String billNumber : billNumberSet) {
                numberBuilder.append(billNumber).append(",");
            }
            String billName = isRec != false ? ResourceBase.getString((String)RES, (String)"104_ArApBillBaseControllerBean", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"105_ArApBillBaseControllerBean", (Locale)ctx.getLocale());
            String operation = veriOrUnVeri ? ResourceBase.getString((String)RES, (String)"225_verify", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"unVerify", (Locale)ctx.getLocale());
            String numStr = numberBuilder.substring(0, numberBuilder.length() - 1);
            if ("1".equalsIgnoreCase(checkType)) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{ResourceBase.getString((String)RES, (String)"226_WRITE_BACK_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{billName, operation, numStr})});
            }
            if ("2".equalsIgnoreCase(checkType)) {
                throw new OtherBillBizException(OtherBillBizException.ERROR, new Object[]{ResourceBase.getString((String)RES, (String)"LOCKAMT_WRITE_BACK_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{billName, operation, numStr})});
            }
        }
    }
}

