/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionCollection;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionEntryCollection;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionEntryFactory;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionEntryInfo;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionFactory;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionInfo;
import com.kingdee.eas.fi.arap.app.AbstractVerificationMappingSolutionControllerBean;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.LockResult;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VerificationMappingSolutionControllerBean
extends AbstractVerificationMappingSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.VerificationMappingSolutionControllerBean");

    @Override
    protected VerificationMappingSolutionEntryCollection _queryVerificationMappingSolution(Context ctx, boolean isAR, Set companyIds, SorterItemCollection sort) throws BOSException, EASBizException {
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        HashSet<String> mainorgunit = new HashSet<String>();
        if (companyIds != null) {
            for (Object orgId : companyIds) {
                if (!BOSUuid.isValid((String)((String)orgId), (boolean)true)) continue;
                mainorgunit.add((String)orgId);
            }
        }
        if (mainorgunit.isEmpty()) {
            return new VerificationMappingSolutionEntryCollection();
        }
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.company"));
        sorter = sort == null ? sorter : sort;
        sorter.add(new SorterItemInfo("seq"));
        VerificationMappingSolutionEntryCollection collection = this.commonQuery(ctx, systemEnum, mainorgunit, filter, sorter);
        return collection;
    }

    @Override
    protected VerificationMappingSolutionEntryCollection _querySolution4Schedule(Context ctx, boolean isAR, Set companyIds) throws BOSException, EASBizException {
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        HashSet<String> mainorgunit = new HashSet<String>();
        if (companyIds != null) {
            for (Object orgId : companyIds) {
                if (!BOSUuid.isValid((String)((String)orgId), (boolean)true)) continue;
                mainorgunit.add((String)orgId);
            }
        }
        if (mainorgunit.isEmpty()) {
            return new VerificationMappingSolutionEntryCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true, CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("parent.company"));
        sorter.add(new SorterItemInfo("seq"));
        VerificationMappingSolutionEntryCollection collection = this.commonQuery(ctx, systemEnum, mainorgunit, filter, sorter);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveSolution(Context ctx, VerificationMappingSolutionEntryInfo[] entrys, SystemEnum systemEnum) throws BOSException, EASBizException {
        if (entrys == null) {
            return;
        }
        HashSet<String> entryids = new HashSet<String>(entrys.length);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Date NOW = new Date();
        CoreBaseCollection saveCollection = new CoreBaseCollection();
        CoreBaseCollection collection = new CoreBaseCollection();
        HashSet<String> ids = new HashSet<String>();
        for (VerificationMappingSolutionEntryInfo entryInfo : entrys) {
            saveCollection.add((CoreBaseInfo)entryInfo);
            if (entryInfo.getId() != null) {
                entryids.add(entryInfo.getId().toString());
            }
            if (ids.contains(entryInfo.getParent().getId().toString())) continue;
            ids.add(entryInfo.getParent().getId().toString());
            VerificationMappingSolutionInfo info = entryInfo.getParent();
            if (info == null) continue;
            info.setLastUpdateUser(userInfo);
            info.setLastUpdateTime(new Timestamp(NOW.getTime()));
            collection.add((CoreBaseInfo)info);
        }
        HashMap<String, VerificationMappingSolutionInfo> parentMap = new HashMap<String, VerificationMappingSolutionInfo>();
        VerificationMappingSolutionEntryCollection beforeCol = new VerificationMappingSolutionEntryCollection();
        if (!entryids.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", entryids, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("mappingCondition.*");
            sic.add("parent.company.*");
            evi.setFilter(fi);
            evi.setSelector(sic);
            beforeCol = VerificationMappingSolutionEntryFactory.getLocalInstance(ctx).getVerificationMappingSolutionEntryCollection(evi);
            for (int i = 0; i < beforeCol.size(); ++i) {
                VerificationMappingSolutionEntryInfo entryInfo = beforeCol.get(i);
                VerificationMappingSolutionInfo info = entryInfo.getParent();
                parentMap.put(info.getId().toString(), info);
            }
        }
        LockResult lockResult = ArApServerUtils.requestLocks(ctx, Arrays.asList(ids.toArray(new String[0])));
        try {
            if (!lockResult.getErrorIds().isEmpty()) {
                HashSet<String> companyNames = new HashSet<String>(lockResult.getErrorIds().size());
                for (String errorId : lockResult.getErrorIds()) {
                    VerificationMappingSolutionInfo info = (VerificationMappingSolutionInfo)parentMap.get(errorId);
                    if (info == null) continue;
                    companyNames.add(info.getCompany().getName());
                }
                throw new ArApCommonException(ArApCommonException.VERIFICATION_ONGOING_TRY_AGAIN, new Object[]{String.join((CharSequence)",", companyNames)});
            }
            List<IObjectPK> logPks = this.beginSaveLog(ctx, systemEnum, saveCollection, beforeCol);
            SelectorItemCollection entrySic = new SelectorItemCollection();
            entrySic.add("isEnabled");
            entrySic.add("mappingCondition");
            VerificationMappingSolutionEntryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)saveCollection, entrySic);
            SelectorItemCollection billSic = new SelectorItemCollection();
            billSic.add("lastUpdateTime");
            billSic.add("lastUpdateUser");
            this.updatePartialBatchData(ctx, (IObjectCollection)collection, billSic);
            ArApServerUtils.batchAfterLog(ctx, logPks.toArray(new IObjectPK[0]));
        }
        finally {
            ArApServerUtils.releaseLocks(ctx, lockResult);
        }
    }

    private List<IObjectPK> beginSaveLog(Context ctx, SystemEnum systemEnum, CoreBaseCollection saveCollection, VerificationMappingSolutionEntryCollection beforeCol) throws BOSException {
        HashSet<String> mappingConditionIds = new HashSet<String>();
        for (int i = 0; i < saveCollection.size(); ++i) {
            VerificationMappingSolutionEntryInfo entryInfo = (VerificationMappingSolutionEntryInfo)saveCollection.get(i);
            if (entryInfo.getMappingCondition() == null || entryInfo.getMappingCondition().getId() == null) continue;
            mappingConditionIds.add(entryInfo.getMappingCondition().getId().toString());
        }
        MappingConditionEntryCollection mappingConditionEntryCollection = new MappingConditionEntryCollection();
        if (!mappingConditionIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", mappingConditionIds, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            evi.setFilter(fi);
            evi.setSelector(sic);
            mappingConditionEntryCollection = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection(evi);
        }
        HashMap<String, StringBuilder> logMap = new HashMap<String, StringBuilder>();
        String logTemplate = "\u3010%s\u3011\u7ed3\u7b97\u65b9\u5f0f: %s";
        for (int i = 0; i < beforeCol.size(); ++i) {
            MappingConditionEntryInfo afterMapping;
            String afterMappingName;
            VerificationMappingSolutionEntryInfo beforeInfo = beforeCol.get(i);
            VerificationMappingSolutionEntryInfo afterInfo = (VerificationMappingSolutionEntryInfo)saveCollection.get((Object)beforeInfo.getId());
            String companyId = beforeInfo.getParent().getCompany().getId().toString();
            StringBuilder logInfo = (StringBuilder)logMap.get(companyId);
            if (logInfo == null) {
                logInfo = new StringBuilder();
                logMap.put(companyId, logInfo);
            }
            String string = afterMappingName = (afterMapping = mappingConditionEntryCollection.get((Object)afterInfo.getMappingCondition().getId())) == null ? "" : afterMapping.getName();
            if (!afterInfo.getMappingCondition().getId().equals((Object)beforeInfo.getMappingCondition().getId())) {
                logInfo.append(String.format(logTemplate, beforeInfo.getVerificationMethod().getAlias(), String.format("\u5339\u914d\u65b9\u6848\u4ece\u3010%s\u3011\u6539\u4e3a\u3010%s\u3011", beforeInfo.getMappingCondition().getName(), afterMappingName)));
                logInfo.append("\n");
            }
            if (!(beforeInfo.isIsEnabled() ^ afterInfo.isIsEnabled())) continue;
            logInfo.append(String.format(logTemplate, beforeInfo.getVerificationMethod().getAlias(), String.format("\u662f\u5426\u542f\u7528\u4ece\u3010%s\u3011\u6539\u4e3a\u3010%s\u3011", BooleanEnum.getEnum((int)(beforeInfo.isIsEnabled() ? 1 : 0)), BooleanEnum.getEnum((int)(afterInfo.isIsEnabled() ? 1 : 0)))));
            logInfo.append("\n");
        }
        String logItem = SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)systemEnum) ? "fi_ar_verify_mappingSolutionSave" : "fi_ap_verify_mappingSolutionSave";
        ArrayList<IObjectPK> logPks = new ArrayList<IObjectPK>();
        BOSObjectType bosType = new VerificationMappingSolutionInfo().getBOSType();
        for (Map.Entry entry : logMap.entrySet()) {
            String logDetail = "";
            if (null != entry.getValue()) {
                logDetail = ((StringBuilder)entry.getValue()).toString();
            }
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)bosType, null, (String)logDetail, (String)logItem, (String)((String)entry.getKey()));
            logPks.add(logPk);
        }
        return logPks;
    }

    private VerificationMappingSolutionEntryCollection commonQuery(Context ctx, SystemEnum systemEnum, Set<String> mainorgunit, FilterInfo filter, SorterItemCollection sorter) throws BOSException, EASBizException {
        this.initSolution(ctx, mainorgunit, systemEnum);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        sic.add("*");
        sic.add("mappingCondition.*");
        sic.add("mappingCondition.mappingCondition");
        sic.add("parent.*");
        sic.add("parent.lastUpdateUser.*");
        sic.add("parent.creator.*");
        sic.add("parent.company.*");
        evi.setSorter(sorter);
        evi.setSelector(sic);
        fi.getFilterItems().add(new FilterItemInfo("parent.company", mainorgunit, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("parent.system", (Object)systemEnum, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("parent.isEnabled", (Object)true, CompareType.EQUALS));
        fi.mergeFilter(filter, "AND");
        return VerificationMappingSolutionEntryFactory.getLocalInstance(ctx).getVerificationMappingSolutionEntryCollection(evi);
    }

    private void initSolution(Context ctx, Set<String> mainorgunit, SystemEnum systemEnum) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company");
        fi.getFilterItems().add(new FilterItemInfo("company", mainorgunit, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("system", (Object)systemEnum, CompareType.EQUALS));
        evi.setSelector(sic);
        evi.setFilter(fi);
        VerificationMappingSolutionCollection collection = VerificationMappingSolutionFactory.getLocalInstance(ctx).getVerificationMappingSolutionCollection(evi);
        HashSet<String> existCompanyIds = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            existCompanyIds.add(collection.get(i).getCompany().getId().toString());
        }
        CoreBaseCollection saveCollection = new CoreBaseCollection();
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
        for (String orgId : mainorgunit) {
            if (existCompanyIds.contains(orgId)) continue;
            VerificationMappingSolutionInfo defaultSolution = VerificationMappingSolutionInfo.createDefaultSolution(orgId, systemEnum);
            defaultSolution.setCreator(creator);
            defaultSolution.setCreateTime(new Timestamp(System.currentTimeMillis()));
            saveCollection.add((CoreBaseInfo)defaultSolution);
        }
        VerificationMappingSolutionFactory.getLocalInstance(ctx).saveBatchData(saveCollection);
    }
}

