/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceSQLBuilder;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ArApBillAccountBalanceSQLBuilder
extends PeriodBalanceSQLBuilder {
    public static final String FIELD_SCENE_NUMBER = "FsceneNumber";
    public static final String FIELD_BILL_DATE = "FbillDate";
    public static final String SELECT_ITEM_ALL = "all";
    public static final String FIELD_IS_AR = "FisAr";
    public static final String BALANCE_FIELD_MODEL_ACCOUNT_ID = "account";
    public static final String BALANCE_FIELD_MODEL_ASSTACT_ID = "asstActID";
    public static final String BALANCE_FIELD_MODEL_CURRENCY_ID = "currencyID";
    public static final String BAD_ACCOUNT_DAUE_MODEL_NUMBER = "60701";
    private boolean isAr = false;
    private ContrastGLQueryParam param = null;
    public static final String Operator_Plus_Sign = "+";
    public static final String Operator_Minus_Sign = "-";

    public boolean isAr() {
        return this.isAr;
    }

    public ArApBillAccountBalanceSQLBuilder setAr(boolean isAr) {
        this.isAr = isAr;
        return this;
    }

    public ContrastGLQueryParam getParam() {
        return this.param;
    }

    public ArApBillAccountBalanceSQLBuilder setParam(ContrastGLQueryParam param) {
        this.param = param;
        return this;
    }

    public ArApBillAccountBalanceSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, String orgUnitID, PeriodInfo period) {
        super(balanceModelInfo, dataModelInfo, orgUnitID, period);
    }

    public String getExecuteLockName() {
        return this.dataModelInfo.getNumber();
    }

    protected String getSelectSQL() {
        String sql = super.getSelectSQL();
        String sceneNumber = this.dataModelInfo.getNumber();
        if (sceneNumber.startsWith("6030201") || sceneNumber.startsWith("7030201")) {
            sql = sql.replaceFirst("SELECT ", "SELECT  DISTINCT ");
        }
        return sql;
    }

    protected String getFieldSQL(BalanceFieldModelInfo fieldModel) {
        String fieldName = fieldModel.getFieldName();
        String value = null;
        if (fieldName.equalsIgnoreCase(FIELD_SCENE_NUMBER)) {
            value = "'" + this.dataModelInfo.getNumber() + "'";
        } else if (fieldName.equalsIgnoreCase(FIELD_IS_AR)) {
            value = this.isAr ? "1" : "0";
        } else if (fieldName.equalsIgnoreCase(FIELD_BILL_DATE) && DateFilterTypeEnum.BizDate.equals((Object)this.dataModelInfo.getDateFilterType())) {
            value = this.dataModelInfo.getBizDateField();
        } else {
            return super.getFieldSQL(fieldModel);
        }
        return value + " AS " + fieldName;
    }

    private String getFieldRealName(String fieldName) throws BOSException {
        String realFieldName = null;
        if (StringUtils.isEmpty((String)fieldName)) {
            return realFieldName;
        }
        BalanceFieldModelCollection fmColl = this.balanceModelInfo.getEntry();
        if (null == fmColl || fmColl.size() == 0) {
            return realFieldName;
        }
        BOSUuid balanceFieldModelID = null;
        for (int i = 0; i < fmColl.size(); ++i) {
            if (!fieldName.equalsIgnoreCase(fmColl.get(i).getName())) continue;
            balanceFieldModelID = fmColl.get(i).getId();
            break;
        }
        if (null == balanceFieldModelID) {
            throw new BOSException("field [" + fieldName + "] doesn't been found in BalanceFieldModel [" + this.balanceModelInfo.getNumber() + "]");
        }
        BalanceFieldDataModelCollection coll = this.dataModelInfo.getEntry();
        if (null == coll || coll.size() == 0) {
            return realFieldName;
        }
        for (int i = 0; i < coll.size(); ++i) {
            if (!balanceFieldModelID.equals((Object)coll.get(i).getBalanceField().getId())) continue;
            realFieldName = coll.get(i).getValueExpression();
            break;
        }
        return realFieldName;
    }

    private Set<String> getAccountIdSet() {
        HashSet<String> idSet = null;
        if (CommonUtils.isNotEmpty(this.param.getAcctFormula())) {
            String item = "";
            int size = this.param.getAcctFormula().size();
            idSet = new HashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                item = String.valueOf(this.param.getAcctFormula().get(i));
                if (Operator_Plus_Sign.equals(item) || Operator_Minus_Sign.equals(item)) continue;
                idSet.add(item);
            }
        }
        return idSet;
    }

    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        FilterInfo filter = super.getExtendFilter();
        FilterInfo extFilter = new FilterInfo();
        Set<String> idSet = null;
        idSet = this.param.isQueryAll() && this.param.isCalculateOpposite() ? this.param.getOppositeAccountIdSet() : this.getAccountIdSet();
        if (CommonUtils.isNotEmpty(idSet) && !StringUtils.isEmpty((String)this.dataModelInfo.getNumber()) && !this.dataModelInfo.getNumber().startsWith(BAD_ACCOUNT_DAUE_MODEL_NUMBER)) {
            String accountIdFieldName = this.getFieldRealName(BALANCE_FIELD_MODEL_ACCOUNT_ID);
            extFilter.getFilterItems().add(new FilterItemInfo(accountIdFieldName, idSet, CompareType.INCLUDE));
        }
        if (!(StringUtils.isEmpty((String)this.param.getCussTypeId()) || SELECT_ITEM_ALL.equals(this.param.getCussTypeId()) || StringUtils.isEmpty((String)this.param.getCussAcctId()))) {
            String asstActIdFieldName = this.getFieldRealName(BALANCE_FIELD_MODEL_ASSTACT_ID);
            extFilter.getFilterItems().add(new FilterItemInfo(asstActIdFieldName, (Object)this.param.getCussAcctId(), CompareType.INNER));
        }
        if (!StringUtils.isEmpty((String)this.param.getCurrencyId()) && !SELECT_ITEM_ALL.equals(this.param.getCurrencyId())) {
            String currencyIdFieldName = this.getFieldRealName(BALANCE_FIELD_MODEL_CURRENCY_ID);
            extFilter.getFilterItems().add(new FilterItemInfo(currencyIdFieldName, (Object)this.param.getCurrencyId(), CompareType.EQUALS));
        }
        if (extFilter.getFilterItems().size() > 0) {
            filter.mergeFilter(extFilter, "AND");
        }
        return filter;
    }
}

