/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.combTrans;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.combTrans.ICombTransfer;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCombTransferHandler
implements ICombTransfer {
    public static final String RESOURCE_NAME = "com.kingdee.eas.fi.arap.CombTransResource";
    private Context ctx;
    public BigDecimal diff = BigDecimal.ZERO;
    private String key;
    private String keyDesc;
    private List<CoreBillEntryBaseInfo> entryList = new ArrayList<CoreBillEntryBaseInfo>();
    private Map<String, Object> initData = new HashMap<String, Object>();
    private Map<String, CoreBillBaseInfo> billMap = new HashMap<String, CoreBillBaseInfo>();
    private Set<String> entryIdSet = new HashSet<String>();
    private BigDecimal allocationNum;
    public static final String ALLOCTION_PARAM_NAME = "AR_WCFT";

    @Override
    public Map combTransfer() throws EASBizException, BOSException {
        if (this.diff.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        if (this.entryList.size() == 0) {
            return null;
        }
        this.init();
        Map result = this.innerCombTransfer();
        return result;
    }

    @Override
    public Map innerCombTransfer() throws BOSException, EASBizException {
        this.adjustDiff(this.entryList);
        if (this.diff.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        this.innerCombTransfer();
        return null;
    }

    public void adjustDiff(List<CoreBillEntryBaseInfo> list) throws EASBizException, BOSException {
        if (list.size() == 0) {
            return;
        }
        Collections.sort(list, this.getComparator());
        BigDecimal allocationNum = this.getAllocationNum();
        for (int i = 0; i < list.size(); ++i) {
            BigDecimal allAmount;
            CoreBillEntryBaseInfo entryInfo = list.get(i);
            if (this.diff.abs().compareTo(allocationNum.abs()) >= 0) {
                allAmount = allocationNum;
                this.diff = this.diff.subtract(allocationNum);
            } else {
                allAmount = this.diff;
                this.diff = BigDecimal.ZERO;
            }
            if (allAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.computeAmount(entryInfo, allAmount);
                this.getEntryIdSet().add(entryInfo.getId().toString());
            }
            if (this.diff.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    public void init() {
        this.allocationNum = new BigDecimal(this.initData.get(ALLOCTION_PARAM_NAME).toString()).add(BigDecimal.ONE).divide(new BigDecimal(100));
        this.allocationNum = this.allocationNum.multiply(new BigDecimal(this.diff.signum()));
    }

    @Override
    public abstract void computeAmount(CoreBillEntryBaseInfo var1, BigDecimal var2) throws EASBizException, BOSException;

    @Override
    public BigDecimal getDiff() {
        return this.diff;
    }

    public void setDiff(BigDecimal diff) {
        this.diff = diff;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKeyDesc() {
        return this.keyDesc;
    }

    @Override
    public void setKeyDesc(String keyDesc) {
        this.keyDesc = keyDesc;
    }

    public BigDecimal getAllocationNum() {
        return this.allocationNum;
    }

    @Override
    public List<CoreBillEntryBaseInfo> getEntryList() {
        return this.entryList;
    }

    @Override
    public void setEntryList(List list) {
        this.entryList = list;
    }

    @Override
    public Map<String, CoreBillBaseInfo> getBillMap() {
        return this.billMap;
    }

    @Override
    public Set<String> getEntryIdSet() {
        return this.entryIdSet;
    }

    @Override
    public Context getCtx() {
        return this.ctx;
    }

    @Override
    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String getNumberField() {
        return "number";
    }

    @Override
    public String getEntryField() {
        return "entry";
    }

    @Override
    public String getCompanyField() {
        return "company";
    }

    @Override
    public void checkBeforeCombTransfer(CoreBillBaseCollection billColl) throws EASBizException, BOSException {
    }

    @Override
    public boolean checkEntryForCombTransfer(CoreBillEntryBaseInfo entry) {
        return true;
    }

    @Override
    public Map getInitData() {
        return this.initData;
    }

    @Override
    public Map initData() throws BOSException {
        HashMap paramMap = new HashMap();
        Object company = this.billMap.get(this.entryList.get(0).getId().toString()).get(this.getCompanyField());
        if (company != null) {
            paramMap.put(ALLOCTION_PARAM_NAME, ((CompanyOrgUnitInfo)company).getId().toString());
            paramMap = ArApParamHelper.getParamHashMap(this.ctx, paramMap);
        }
        this.initData.putAll(paramMap);
        return this.initData;
    }

    @Override
    public SelectorItemCollection getSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(this.getCompanyField() + ".id");
        sic.add(this.getCompanyField() + ".name");
        sic.add(this.getCompanyField() + ".number");
        sic.add(this.getCompanyField() + ".baseCurrency.precision");
        sic.add(this.getNumberField());
        return sic;
    }

    @Override
    public void checkPermissionItem(CoreBillBaseCollection billColl) throws EASBizException, BOSException {
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < billColl.size(); ++i) {
            Object ob = billColl.get(i).get(this.getCompanyField());
            if (ob == null || !(ob instanceof CompanyOrgUnitInfo)) continue;
            String companyId = ((CompanyOrgUnitInfo)ob).getId().toString();
            companyIdSet.add(companyId);
        }
        if (!companyIdSet.isEmpty()) {
            UserInfo currentUser = CommonServerUtils.getCurrentUser(this.ctx);
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
            for (String companyId : companyIdSet) {
                ObjectUuidPK userPK = new ObjectUuidPK(currentUser.getId());
                if (StringUtils.isEmpty((String)this.getPermissionItem())) continue;
                iPermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(companyId), this.getPermissionItem());
            }
        }
    }
}

