/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.elecinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ElecInvoiceCollection;
import com.kingdee.eas.fi.arap.ElecInvoiceEntryInfo;
import com.kingdee.eas.fi.arap.ElecInvoiceInfo;
import com.kingdee.eas.fi.arap.ElecInvoiceStatus;
import com.kingdee.eas.fi.arap.app.elecinvoice.GsonUtils;
import com.kingdee.eas.fi.arap.app.elecinvoice.InvoicePlatformInterface;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class InvoicePlatformImpl
implements InvoicePlatformInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.elecinvoice.InvoicePlatformImpl");
    private ElecInvoiceCollection invoiceColl = new ElecInvoiceCollection();
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public Map<String, Object> connect(String sbh, String secrets) {
        String url = InvoicePlatformImpl.getUrl() + "connect";
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(url);
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("sbh", sbh), new NameValuePair("secrets", secrets)};
            getMethod.setQueryString(params);
            int res_code = httpClient.executeMethod((HttpMethod)getMethod);
            if (res_code == 200) {
                String resp = getMethod.getResponseBodyAsString();
                Map respMap = (Map)GsonUtils.createGson().fromJson(resp, Map.class);
                int status = this.getInt(respMap, "status");
                respMap.put("status", status);
                return respMap;
            }
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            respMap.put("status", 12);
            respMap.put("message", this.getResourceStr("HTTPRequestFaile"));
            return respMap;
        }
        catch (IOException e) {
            logger.error((Object)e);
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            respMap.put("status", 12);
            respMap.put("message", this.getResourceStr("CannotConnectBill100") + e.getMessage());
            return respMap;
        }
    }

    @Override
    public ElecInvoiceCollection getInvoice(String sbh, String secrets, Date from, Date to, int rzzt) throws BOSException, EASBizException {
        int page = 1;
        this.invoiceColl = new ElecInvoiceCollection();
        while (this.getPageInvoice(sbh, secrets, dateFormat.format(from), dateFormat.format(to), rzzt, page)) {
            ++page;
        }
        return this.invoiceColl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getPageInvoice(String sbh, String secrets, String timeStampStart, String timeStampEnd, int rzzt, int page) throws BOSException {
        String getInvoiceList_uri = InvoicePlatformImpl.getUrl() + "getInvoiceList";
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(getInvoiceList_uri);
        ElecInvoiceCollection collection = new ElecInvoiceCollection();
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("sbh", sbh), new NameValuePair("secrets", secrets), new NameValuePair("timeStampStart", timeStampStart), new NameValuePair("timeStampEnd", timeStampEnd), new NameValuePair("rzzt", rzzt + ""), new NameValuePair("page", page + ""), new NameValuePair("mx", "1")};
            getMethod.setQueryString(params);
            int res_code = httpClient.executeMethod((HttpMethod)getMethod);
            if (res_code != 200) throw new BOSException(this.getResourceStr("HTTPPanmentStatueError"));
            String resp = getMethod.getResponseBodyAsString();
            Map respMap = (Map)GsonUtils.createGson().fromJson(resp, Map.class);
            int status = this.getInt(respMap, "status");
            if (status == 0) {
                boolean bl;
                int totalSize = this.getInt(respMap, "totalSize");
                int invoiceSize = this.getInt(respMap, "invoiceSize");
                List invoices = (List)respMap.get("invoices");
                int size = invoices.size();
                for (int i = 0; i < size; ++i) {
                    Map invoiceMap = (Map)invoices.get(i);
                    ElecInvoiceInfo invoiceInfo = new ElecInvoiceInfo();
                    this.invoiceColl.add(invoiceInfo);
                    invoiceInfo.setId(BOSUuid.create((BOSObjectType)invoiceInfo.getBOSType()));
                    invoiceInfo.setFpid(this.getInt(invoiceMap, "id"));
                    invoiceInfo.setNumber(this.getString(invoiceMap.get("fphm")));
                    invoiceInfo.setFphm(this.getString(invoiceMap.get("fphm")));
                    invoiceInfo.setFpdm(this.getString(invoiceMap.get("fpdm")));
                    invoiceInfo.setFwm(this.getString(invoiceMap.get("fwm")));
                    invoiceInfo.setBizDate(this.getDate(invoiceMap, "kprq"));
                    invoiceInfo.setFprx(this.getInt(respMap, "fpzt"));
                    invoiceInfo.setKpf_sbh(this.getString(invoiceMap.get("kpf_sbh")));
                    invoiceInfo.setKpf_name(this.getString(invoiceMap.get("kpf_mc")));
                    invoiceInfo.setSpf_sbh(this.getString(invoiceMap.get("spf_sbh")));
                    invoiceInfo.setSpf_name(this.getString(invoiceMap.get("spf_mc")));
                    invoiceInfo.setKp_amount(new BigDecimal(invoiceMap.get("kpje").toString()));
                    invoiceInfo.setStatus(ElecInvoiceStatus.NON_AP);
                    List items = (List)invoiceMap.get("items");
                    int sizej = items.size();
                    for (int j = 0; j < sizej; ++j) {
                        Map itemMap = (Map)items.get(j);
                        ElecInvoiceEntryInfo entry = new ElecInvoiceEntryInfo();
                        entry.setSeq(this.getInt(itemMap, "hh"));
                        entry.setCode(this.getString(itemMap.get("kjxm_dm")));
                        entry.setName(this.getString(itemMap.get("kjxm_mc")));
                        entry.setUnitprice(new BigDecimal(itemMap.get("dj").toString()));
                        entry.setUnit(this.getString(itemMap.get("dw")));
                        entry.setUnitprice(new BigDecimal(itemMap.get("je").toString()));
                        entry.setUnitprice(new BigDecimal(itemMap.get("sl").toString()));
                        entry.setSn(this.getString(itemMap.get("sn")));
                        invoiceInfo.getEntrys().add(entry);
                    }
                }
                if (totalSize > invoiceSize + 100 * page) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            try {
                throw new BOSException((String)respMap.get("message"));
            }
            catch (HttpException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean putAccount(String sbh, String secrets, String fphm) throws BOSException {
        String getInvoiceList_uri = InvoicePlatformImpl.getUrl() + "putAccount";
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(getInvoiceList_uri);
        ElecInvoiceCollection collection = new ElecInvoiceCollection();
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("sbh", sbh), new NameValuePair("secrets", secrets), new NameValuePair("fphm", fphm)};
            getMethod.setQueryString(params);
            int res_code = httpClient.executeMethod((HttpMethod)getMethod);
            if (res_code != 200) throw new BOSException(this.getResourceStr("HTTPPanmentStatueError"));
            String resp = getMethod.getResponseBodyAsString();
            Map respMap = (Map)GsonUtils.createGson().fromJson(resp, Map.class);
            int status = this.getInt(respMap, "status");
            if (status == 0) {
                boolean bl = true;
                return bl;
            }
            try {
                throw new BOSException((String)respMap.get("message"));
            }
            catch (HttpException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean unPutAccount(String sbh, String secrets, String fphm) throws BOSException {
        String getInvoiceList_uri = InvoicePlatformImpl.getUrl() + "unPutAccount";
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(getInvoiceList_uri);
        ElecInvoiceCollection collection = new ElecInvoiceCollection();
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("sbh", sbh), new NameValuePair("secrets", secrets), new NameValuePair("fphm", fphm)};
            getMethod.setQueryString(params);
            int res_code = httpClient.executeMethod((HttpMethod)getMethod);
            if (res_code != 200) throw new BOSException(this.getResourceStr("HTTPPanmentStatueError"));
            String resp = getMethod.getResponseBodyAsString();
            Map respMap = (Map)GsonUtils.createGson().fromJson(resp, Map.class);
            int status = this.getInt(respMap, "status");
            if (status == 0) {
                boolean bl = true;
                return bl;
            }
            try {
                throw new BOSException((String)respMap.get("message"));
            }
            catch (HttpException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    private String getString(Object val) {
        if (val != null) {
            return val.toString();
        }
        return "";
    }

    private int getInt(Map dataMap, String key) {
        if (dataMap.get(key) != null) {
            double val = (Double)dataMap.get(key);
            return (int)val;
        }
        return 0;
    }

    private Date getDate(Map dataMap, String key) {
        String val = (String)dataMap.get(key);
        String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(DATEFORMAT, Locale.US);
        try {
            return format.parse(val);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getUrl() {
        return "http://192.168.11.242:8080/fp100/api/v1/";
    }

    private String getResourceStr(String key) {
        String resClassName = "com.kingdee.eas.fi.arap.ArapAllResource";
        return EASResource.getString((String)resClassName, (String)key);
    }
}

