/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.qing.analysis;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.qing.data.domain.source.api.ITableDataProvider;
import com.kingdee.bos.qing.data.model.runtime.api.APIField;
import com.kingdee.bos.qing.data.model.runtime.api.APIFieldType;
import com.kingdee.bos.qing.data.model.runtime.api.APITable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArVirtualAgingRptFacadeFactory;
import com.kingdee.eas.fi.ar.IArVirtualAgingRptFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApAgingRptDataPrivider
implements ITableDataProvider {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.qing.analysis.ArApAgingRptDataPrivider");
    private int totalRowCount = 0;
    RptParams params = new RptParams();

    public APITable getTableStructure() {
        return null;
    }

    protected RptParams getArAgingRptResult(IVirtualRptBaseFacade iRpt, RptParams params) throws Exception {
        params.setObject("qryParam", (Object)this.getAgingQueryRptParam());
        params.setObject("qryParam-timeSetting", (Object)this.getAgingTimeQueryRptParam());
        RptParams rptRslt = iRpt.createTempTable(params);
        return rptRslt;
    }

    protected IReportQueryParam getAgingTimeQueryRptParam() {
        return null;
    }

    protected IReportQueryParam getAgingQueryRptParam() throws EASBizException, BOSException {
        return null;
    }

    protected List getCompanyIds() throws BOSException {
        ArrayList<String> companyIds = new ArrayList<String>();
        StringBuilder sql = new StringBuilder(100);
        sql.append("select distinct bill.fcompanyid  as companyId from ").append(this.getTableName()).append(" bill  ");
        sql.append("inner join T_ORG_COMPANY as company on bill.FCOMPANYID  = company.fid ");
        sql.append("inner join T_BD_SystemStatusCtrol ssc on bill.FCOMPANYID  = ssc.FCOMPANYID ");
        sql.append("inner join T_BD_SystemStatus ss on ssc.FSYSTEMSTATUSID  = ss.fid ");
        sql.append("where  bill.FBILLSTATUS  = 3 and ssc.FISSTART  = 1 and ss.FNAME = ").append(this.getSysEnum());
        IRowSet rs = DbUtilFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        try {
            while (rs.next()) {
                companyIds.add(rs.getString("companyId"));
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        return companyIds;
    }

    protected String getTableName() {
        return null;
    }

    protected int getSysEnum() {
        return 12;
    }

    public List<Object[]> getData(Integer pageNo, Integer pageSize, String selectedFields) {
        List<Object[]> result = new ArrayList<Object[]>();
        try {
            IArVirtualAgingRptFacade iRpt = ArVirtualAgingRptFacadeFactory.getRemoteInstance();
            int start = (pageNo - 1) * pageSize;
            int length = pageNo * pageSize;
            RptParams rptRslt = iRpt.query(this.params, start, length);
            RptRowSet rs = (RptRowSet)rptRslt.getObject("rowset");
            result = this.getResult(rs);
        }
        catch (Exception e) {
            logger.error((Object)("ArAgingRptDataPrivider.getData Error:" + e.getMessage()));
        }
        return result;
    }

    protected List<Object[]> getResult(RptRowSet rs) {
        int i;
        ArrayList<List> tempResult = new ArrayList<List>();
        if (rs.getRowCount() == 0) {
            return null;
        }
        List<APIField> fields = this.getTableFields();
        while (rs.next()) {
            int rowType = rs.getInt("FIsSum");
            if (rowType != 0) continue;
            ArrayList<Object> objList = new ArrayList<Object>();
            for (i = 0; i < fields.size(); ++i) {
                APIField field = fields.get(i);
                if (this.getValue(rs, field) == null) continue;
                objList.add(this.getValue(rs, field));
            }
            tempResult.add(objList);
            this.addAging(tempResult, rs);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (i = 0; i < tempResult.size(); ++i) {
            result.add(((List)tempResult.get(i)).toArray());
        }
        return result;
    }

    public void addAging(List<List> result, RptRowSet rs) {
        Map<String, String> agingColumnMap = this.getAgingColumnMap();
        ArrayList<String> firstObjArr = result.get(result.size() - 1);
        ArrayList<String> initObjArr = new ArrayList<String>();
        initObjArr.addAll(firstObjArr);
        Iterator<Map.Entry<String, String>> it = agingColumnMap.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            ArrayList<String> objArr;
            Map.Entry<String, String> entry = it.next();
            if (i == 0) {
                objArr = firstObjArr;
            } else {
                objArr = new ArrayList<String>();
                objArr.addAll(initObjArr);
                result.add(objArr);
            }
            objArr.add(entry.getValue());
            objArr.add((String)((Object)rs.getBigDecimal(entry.getKey())));
            ++i;
        }
    }

    protected Map<String, String> getAgingColumnMap() {
        LinkedHashMap<String, String> agingColumnMap = new LinkedHashMap<String, String>();
        RptTableHeader header = (RptTableHeader)this.params.getObject("header");
        Object[][] data = header.getLabels();
        int cols = data[0].length;
        String baseCurrencyText = ArApServerUtils.getStrResource(Locale.CHINESE, "BASE_CURRENCY", null);
        for (int i = 0; i < cols; ++i) {
            RptTableColumn rptCol = header.getColumn(i);
            String colName = rptCol.getName();
            if (colName == null || !colName.startsWith("ful_") && !colName.startsWith("fol_") && !colName.startsWith("fdueamt")) continue;
            if (colName.equalsIgnoreCase("FUL_t1_BSC")) {
                agingColumnMap.put(rptCol.getName(), (String)data[0][i]);
                continue;
            }
            agingColumnMap.put(rptCol.getName(), ((String)data[1][i]).replaceAll("\\(" + baseCurrencyText + "\\)", "").replaceAll(baseCurrencyText, ""));
        }
        return agingColumnMap;
    }

    protected Object getValue(RptRowSet rs, APIField field) {
        Object value = null;
        String columnName = field.getName();
        APIFieldType type = field.getDataType();
        if (columnName.startsWith("F")) {
            if (APIFieldType.STRING.equals((Object)type)) {
                value = rs.getString(columnName);
            } else if (APIFieldType.NUMBER.equals((Object)type)) {
                value = rs.getBigDecimal(columnName);
            }
        }
        return value;
    }

    protected List<APIField> getTableFields() {
        ArrayList<APIField> fields = new ArrayList<APIField>();
        fields.add(new APIField("FBaseCurrNum", ArApServerUtils.getStrResource(Locale.CHINESE, "BASE_CURRENCY_NUMBER", null), APIFieldType.STRING));
        fields.add(new APIField("FBaseCurrency", ArApServerUtils.getStrResource(Locale.CHINESE, "BASE_CURRENCY_NAME", null), APIFieldType.STRING));
        fields.add(new APIField("FCompLongNumber", ArApServerUtils.getStrResource(Locale.CHINESE, "COMPANY_LONG_NUMBER", null), APIFieldType.STRING));
        fields.add(new APIField("FCompany", ArApServerUtils.getStrResource(Locale.CHINESE, "COMPANY_NAME", null), APIFieldType.STRING));
        fields.add(new APIField("FAsstactnumber", ArApServerUtils.getStrResource(Locale.CHINESE, "ASSTACT_NUMBER", null), APIFieldType.STRING));
        fields.add(new APIField("FCussacct", ArApServerUtils.getStrResource(Locale.CHINESE, "ASSTACT_NAME", null), APIFieldType.STRING));
        fields.add(new APIField("FBalance_BSC", ArApServerUtils.getStrResource(Locale.CHINESE, "BALANCE_LOCAL", null), APIFieldType.NUMBER));
        fields.add(new APIField("expireDate", ArApServerUtils.getStrResource(Locale.CHINESE, "EXPIRE_DATE", null), APIFieldType.STRING));
        fields.add(new APIField("amount", ArApServerUtils.getStrResource(Locale.CHINESE, "AMOUNT_LOCAL", null), APIFieldType.NUMBER));
        return fields;
    }

    public Long getRowCount() {
        try {
            this.params.setObject("qryParam", (Object)this.getAgingQueryRptParam());
            this.params.setObject("qryParam-timeSetting", (Object)this.getAgingTimeQueryRptParam());
            IArVirtualAgingRptFacade iRpt = ArVirtualAgingRptFacadeFactory.getRemoteInstance();
            RptParams rptRslt = new RptParams();
            rptRslt = this.getArAgingRptResult(iRpt, rptRslt);
            this.params.setObject("header", rptRslt.getObject("header"));
            String tmpTable = rptRslt.getString("tempTable");
            AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
            this.totalRowCount = rptRslt.getInt("verticalCount");
            this.totalRowCount *= this.getAgingColumnMap().size();
            param.setTempTable(tmpTable);
        }
        catch (Exception e) {
            logger.error((Object)("ArAgingRptDataPrivider.getData Error:" + e.getMessage()));
        }
        return this.totalRowCount;
    }
}

