/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.reverse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.ArApBillBaseControllerBean;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.reverse.IReverse;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AbstractReverse
implements IReverse {
    protected ArApBillBaseInfo baseInfo;
    protected ArApBillBaseControllerBean arapBaseControllerBean;
    protected Context ctx;
    protected final BigDecimal ZERO = BigDecimal.ZERO;
    public final String UN_REVERSED_BASEQTY = "UN_REVERSED_BASEQTY";
    public final String IS_LAST_REVERSE_ENTRY = "IS_LAST_REVERSE_ENTRY";
    protected Map<String, ArApBillBaseInfo> reversedBillInfoMap = new HashMap<String, ArApBillBaseInfo>();
    protected Map<String, ArApBillEntryBaseInfo> reversedEntryInfoMap = new HashMap<String, ArApBillEntryBaseInfo>();
    protected Map<String, Boolean> isEntryFullWriteoffMap = new HashMap<String, Boolean>();
    protected ArApBillEntryBaseCollection reversedEntrys = new ArApBillEntryBaseCollection();

    public AbstractReverse(Context ctx, ArApBillBaseInfo baseInfo, ArApBillBaseControllerBean arapBaseControllerBean) {
        this.ctx = ctx;
        this.baseInfo = baseInfo;
        this.arapBaseControllerBean = arapBaseControllerBean;
    }

    @Override
    public void doReverse() throws BOSException, EASBizException {
        Map<String, String> bizBillMap = this.queryBizBill(this.baseInfo);
        if (bizBillMap.size() == 0) {
            return;
        }
        this.initEntryFullWriteOff(this.baseInfo);
        this.getReverseInfo(bizBillMap);
        this.calAmount();
        this.setReversedEntryDefaultValue();
        this.calReverseQty();
        this.dealInfo();
    }

    protected Map<String, String> queryBizBill(ArApBillBaseInfo baseInfo) throws BOSException {
        return null;
    }

    protected void getReverseInfo(Map<String, String> bizBillMap) throws BOSException {
        IArApBillEntryBase iArApBillEntryBase = this.getEntryBizInterface();
        if (iArApBillEntryBase == null) {
            return;
        }
        Set<String> entryIdSet = bizBillMap.keySet();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getEntrySelect());
        ArApBillEntryBaseCollection entryColl = iArApBillEntryBase.getArApBillEntryBaseCollection(ev);
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entry = (ArApBillEntryBaseInfo)entryColl.getObject(i);
            if (!entryIdSet.contains(entry.getId().toString())) continue;
            entry.put("UN_REVERSED_BASEQTY", entry.getBaseQty().subtract(entry.getReversedBaseQty()));
            this.reversedEntryInfoMap.put(entry.getId().toString(), entry);
        }
    }

    private void setReversedEntryDefaultValue() {
        for (Map.Entry<String, ArApBillEntryBaseInfo> mapEntry : this.reversedEntryInfoMap.entrySet()) {
            ArApBillEntryBaseInfo entry = mapEntry.getValue();
            this.setEntryDefaultValue(entry);
        }
    }

    protected void setEntryDefaultValue(ArApBillEntryBaseInfo reversedSrcEntryInfo) {
        reversedSrcEntryInfo.setBaseQty(this.ZERO);
        reversedSrcEntryInfo.setReversedBaseQty(this.ZERO);
        reversedSrcEntryInfo.setVerifyAmount(this.ZERO);
        reversedSrcEntryInfo.setVerifyAmountLocal(this.ZERO);
        reversedSrcEntryInfo.setUnVerifyAmount(reversedSrcEntryInfo.getRecievePayAmount());
        reversedSrcEntryInfo.setUnVerifyAmountLocal(reversedSrcEntryInfo.getRecievePayAmountLocal());
        reversedSrcEntryInfo.setLockVerifyAmt(this.ZERO);
        reversedSrcEntryInfo.setLockVerifyAmtLocal(this.ZERO);
        reversedSrcEntryInfo.setLockUnVerifyAmt(reversedSrcEntryInfo.getRecievePayAmount());
        reversedSrcEntryInfo.setLockUnVerifyAmtLocal(reversedSrcEntryInfo.getRecievePayAmountLocal());
    }

    protected void calAmount() throws BOSException {
        ArApBillEntryBaseInfo entry;
        HashSet<String> entryIdSet = new HashSet<String>();
        for (Map.Entry<String, ArApBillEntryBaseInfo> mapEntry : this.reversedEntryInfoMap.entrySet()) {
            entry = mapEntry.getValue();
            if (entry.getReversedBaseQty().compareTo(this.ZERO) == 0) continue;
            entryIdSet.add(entry.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            StringBuffer sb = new StringBuffer("");
            sb.append("SELECT entry.FSourceBillEntryID, -1 * SUM(entry.FAmount) AS FAmount, -1 * SUM(entry.FAmountLocal) AS FAmountLocal,");
            sb.append(" -1 * SUM(entry.FRecievePayAmount) AS FRecievePayAmount, -1 * SUM(entry.FRecievePayAmountLocal) AS FRecievePayAmountLocal,");
            sb.append(" -1 * SUM(entry.FDiscountAmount) AS FDiscountAmount, -1 * SUM(entry.FDiscountAmountLocal) AS FDiscountAmountLocal,");
            sb.append(" -1 * SUM(entry.FTAXAMOUNT) AS FTAXAMOUNT , -1 * SUM(entry.FTAXAMOUNTLOCAL) AS FTAXAMOUNTLOCAL ");
            sb.append(" FROM ").append(this.getTable()).append(" bill INNER JOIN ").append(this.getEntryTable()).append(" entry ON bill.FID = entry.FParentID");
            sb.append(" WHERE bill.FIsBizBill = 1 AND entry.FVerifyAmountLocal = entry.FRecievePayAmountLocal");
            sb.append(" AND bill.FCompanyID = '").append(this.baseInfo.getCompany().getId().toString()).append("'");
            sb.append(" AND entry.FSourceBillEntryID IN (").append(ArApBillHelper.ids2SqlString(entryIdSet));
            sb.append(") GROUP BY entry.FSourceBillEntryID");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
                while (rs.next()) {
                    if (!this.reversedEntryInfoMap.containsKey(rs.getString("FSourceBillEntryID"))) continue;
                    entry = this.reversedEntryInfoMap.get(rs.getString("FSourceBillEntryID"));
                    entry.setAmount(entry.getAmount().subtract(rs.getBigDecimal("FAmount")));
                    entry.setAmountLocal(entry.getAmountLocal().subtract(rs.getBigDecimal("FAmountLocal")));
                    entry.setRecievePayAmount(entry.getRecievePayAmount().subtract(rs.getBigDecimal("FRecievePayAmount")));
                    entry.setRecievePayAmountLocal(entry.getRecievePayAmountLocal().subtract(rs.getBigDecimal("FRecievePayAmountLocal")));
                    entry.setDiscountAmount(entry.getDiscountAmount().subtract(rs.getBigDecimal("FDiscountAmount")));
                    entry.setDiscountAmountLocal(entry.getDiscountAmountLocal().subtract(rs.getBigDecimal("FDiscountAmountLocal")));
                    entry.setTaxAmount(entry.getTaxAmount().subtract(rs.getBigDecimal("FTAXAMOUNT")));
                    entry.setTaxAmountLocal(entry.getTaxAmountLocal().subtract(rs.getBigDecimal("FTAXAMOUNTLOCAL")));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void calReverseQty() throws OtherBillBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealInfo() throws BOSException, EASBizException {
        int i;
        ArApBillEntryBaseInfo entry;
        if (this.reversedEntrys.size() == 0) {
            return;
        }
        IArApBillBase iArApBillBase = this.getBizInterface();
        if (iArApBillBase == null) {
            return;
        }
        HashSet<String> reversedBillIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.reversedEntrys.size(); ++i2) {
            entry = this.reversedEntrys.get(i2);
            entry.setSourceBillEntryId(entry.getId().toString());
            entry.setSourceBillId(entry.getParent().getId().toString());
            entry.setId(null);
            entry.setBaseQty(entry.getBaseQty().negate());
            entry.setDiscountAmount(entry.getDiscountAmount().negate());
            entry.setDiscountAmountLocal(entry.getDiscountAmountLocal().negate());
            entry.setReversedBaseQty(this.ZERO);
            entry.setQuantity(this.ZERO);
            reversedBillIdSet.add(entry.getParent().getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", reversedBillIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getBillSelect());
        ArApBillBaseCollection billColl = iArApBillBase.getArApBillBaseCollection(ev);
        for (i = 0; i < billColl.size(); ++i) {
            billColl.get(i).getEntries().clear();
        }
        for (i = 0; i < this.reversedEntrys.size(); ++i) {
            entry = this.reversedEntrys.get(i);
            billColl.get(entry.getParent().getId()).getEntries().addObject((IObjectValue)entry);
        }
        for (int i3 = 0; i3 < billColl.size(); ++i3) {
            IObjectPK newPK;
            ArApBillBaseInfo reversedInfo = billColl.get(i3);
            if (reversedInfo.getEntries().size() == 0) continue;
            String sourceBillID = reversedInfo.getId().toString();
            reversedInfo.setAmountLocal(this.ZERO);
            reversedInfo.setSourceBillId(this.baseInfo.getId().toString());
            reversedInfo.getPlans().clear();
            reversedInfo.setId(BOSUuid.create((BOSObjectType)reversedInfo.getId().getType()));
            reversedInfo.setBillDate(this.baseInfo.getBillDate());
            reversedInfo.setBizDate(this.baseInfo.getBizDate());
            reversedInfo.setFiVouchered(false);
            reversedInfo.setIsAppointVoucher(false);
            reversedInfo.setVoucher(null);
            reversedInfo.setVoucherNumber(null);
            reversedInfo.setVoucherType(null);
            reversedInfo.setPcaVouchered(false);
            reversedInfo.setIsInitializeBill(false);
            reversedInfo.setIsImportBill(false);
            reversedInfo.setIsImpFromGL(false);
            reversedInfo.setAbstractName(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"ReversedBizBill", (Locale)this.ctx.getLocale()) + " - " + reversedInfo.getNumber());
            reversedInfo.setAccountant(null);
            reversedInfo.setNumber(null);
            String companyID = reversedInfo.getCompany() == null ? null : reversedInfo.getCompany().getId().toString();
            Date billDate = reversedInfo.getBillDate();
            int size = reversedInfo.getEntries().size();
            for (int j = 0; j < size; ++j) {
                entry = (ArApBillEntryBaseInfo)reversedInfo.getEntries().getObject(j);
                entry.setCompany(companyID);
                entry.setBillDate(billDate);
            }
            ArApBillHelper.calculate(this.ctx, reversedInfo, null);
            try {
                WfEventListenerStateManager.getInstance().disableEventListener();
                newPK = iArApBillBase.submit((CoreBaseInfo)reversedInfo);
            }
            finally {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
            this.arapBaseControllerBean.requestBudget(this.ctx, reversedInfo, 3);
            String sql = "update " + this.getTable() + " set fbillstatus=?,fauditdate=?,fauditorid=? where fid=? ";
            Object[] params = new Object[]{new Integer(3), new Timestamp(System.currentTimeMillis()), CommonServerUtils.getCurrentUser(this.ctx).getId().toString(), newPK.toString()};
            DbUtil.execute((Context)this.ctx, (String)sql, (Object[])params);
            this.dealRelation(newPK, sourceBillID, this.baseInfo.getId().toString());
            this.arapBaseControllerBean.verifiedBizARAP(this.ctx, this.baseInfo, (ArApBillBaseInfo)iArApBillBase.getValue(newPK, this.getBillSelect()), true);
        }
    }

    protected void dealRelation(IObjectPK newPK, String bizBillId, String billId) throws BOSException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
        BOTRelationInfo botRelationInfo = new BOTRelationInfo();
        botRelationInfo.setSrcObjectID(bizBillId);
        botRelationInfo.setDestObjectID(newPK.toString());
        botRelationInfo.setSrcEntityID(BOSUuid.read((String)bizBillId).getType().toString());
        botRelationInfo.setDestEntityID(BOSUuid.read((String)newPK.toString()).getType().toString());
        botRelationInfo.setOperatorID("unknow");
        botRelationInfo.setType(0);
        iBOTRelation.addnew(botRelationInfo);
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select distinct a.fsrcObjectID as fsourceBillId from T_bot_relation a");
        sql.append(" inner join T_bot_relation b on a.fsrcObjectID = b.fsrcObjectID ");
        sql.append(" where a.fDestObjectID = ?");
        sql.append(" and a.fSrcEntityID = ?");
        sql.append(" and b.fDestObjectID = ?");
        Object[] params = new Object[]{billId, this.getSrcBosType(), bizBillId};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                BOTRelationInfo childRelationInfo = new BOTRelationInfo();
                childRelationInfo.setSrcObjectID(rowSet.getString("fsourceBillId"));
                childRelationInfo.setDestObjectID(newPK.toString());
                childRelationInfo.setSrcEntityID(this.getSrcBosType());
                childRelationInfo.setDestEntityID(BOSUuid.read((String)newPK.toString()).getType().toString());
                childRelationInfo.setOperatorID("unknown");
                childRelationInfo.setType(0);
                iBOTRelation.addnew(childRelationInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void initEntryFullWriteOff(ArApBillBaseInfo info) throws BOSException {
        AbstractObjectCollection entrys = info.getEntries();
        IObjectValue entryInfo = null;
        String entryId = null;
        String sourceBillEntryId = null;
        boolean isEntryFullWriteOff = false;
        HashSet<String> sourceIdSet = new HashSet<String>();
        HashMap<String, String> otherBilSourceBilRel = new HashMap<String, String>();
        BOSObjectType srcBillBosType = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entryInfo = entrys.getObject(i);
            entryId = entryInfo.getString("id");
            sourceBillEntryId = entryInfo.getString("sourceBillEntryId");
            isEntryFullWriteOff = entryInfo.getBoolean("isFullWriteOff");
            this.isEntryFullWriteoffMap.put(entryId, isEntryFullWriteOff);
            if (isEntryFullWriteOff || StringUtils.isEmpty((String)sourceBillEntryId)) continue;
            sourceIdSet.add(sourceBillEntryId);
            otherBilSourceBilRel.put(sourceBillEntryId, entryId);
            if (null != srcBillBosType) continue;
            srcBillBosType = BOSUuid.read((String)sourceBillEntryId).getType();
        }
        if (sourceIdSet.size() > 0) {
            IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            String oql = "select id, isFullWriteOff where id in (" + ArApBillHelper.ids2SqlString(sourceIdSet) + ")";
            IObjectCollection sourceBillEntryCollection = iObjectInstance.getCollection(srcBillBosType, oql);
            int sourceBillEntrySize = sourceBillEntryCollection.size();
            IObjectValue srcEntryInfo = null;
            String otherbilEntryId = null;
            for (int i = 0; i < sourceBillEntrySize; ++i) {
                srcEntryInfo = sourceBillEntryCollection.getObject(i);
                sourceBillEntryId = srcEntryInfo.getString("id");
                isEntryFullWriteOff = srcEntryInfo.getBoolean("isFullWriteOff");
                otherbilEntryId = (String)otherBilSourceBilRel.get(sourceBillEntryId);
                this.isEntryFullWriteoffMap.put(otherbilEntryId, isEntryFullWriteOff);
            }
        }
    }

    protected IArApBillEntryBase getEntryBizInterface() throws BOSException {
        return null;
    }

    protected IArApBillBase getBizInterface() throws BOSException {
        return null;
    }

    protected SelectorItemCollection getEntrySelect() {
        return null;
    }

    protected SelectorItemCollection getBillSelect() {
        return null;
    }

    protected String getEntryTable() {
        return null;
    }

    protected String getTable() {
        return null;
    }

    protected String getSrcBosType() {
        return null;
    }
}

