/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.reverse.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.app.ArApBillBaseControllerBean;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.app.reverse.AbstractReverse;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class IncomeConfirmBillRelationReverseImpl
extends AbstractReverse {
    public IncomeConfirmBillRelationReverseImpl(Context ctx, ArApBillBaseInfo baseInfo, ArApBillBaseControllerBean arapBaseControllerBean) {
        super(ctx, baseInfo, arapBaseControllerBean);
    }

    @Override
    public Map<String, String> queryBizBill(ArApBillBaseInfo baseInfo) throws BOSException {
        HashMap<String, String> bizBillMap = new HashMap<String, String>();
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)baseInfo;
        if (!info.getBillType().equals((Object)IncomeConfimBillTypeEnum.SALE_INCOME)) {
            return bizBillMap;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append(" SELECT ");
        sb.append(" bizentry.FParentID as billId,bizentry.FID as entryId");
        sb.append(", bizentry.FBaseQty - bizentry.FReversedBaseQty AS UnReversedBaseQty");
        sb.append(" FROM ").append(this.getEntryTable()).append(" bizentry");
        sb.append(" INNER JOIN ").append(this.getTable()).append(" bizbill ON bizentry.FParentID = bizbill.FID WHERE ");
        sb.append(" FSourceBillEntryID in (SELECT FSourceBillEntryID  FROM ").append(this.getDestEntryTable()).append(" where FPARENTID = ?) ");
        sb.append(" AND bizBill.FCompanyID = ? AND bizBill.FBillType = ").append(102);
        sb.append(" AND bizBill.FIsBizBill = 1 AND bizBill.FBillStatus = ").append(3);
        sb.append("AND bizentry.FBaseQty - bizentry.FReversedBaseQty <> 0");
        sb.append(" ORDER BY bizentry.FCoreBillNumber, bizentry.FCoreBillEntrySeq, bizBill.FBillDate");
        Object[] params = new Object[]{info.getId().toString(), info.getCompany().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                bizBillMap.put(rowSet.getString("entryId"), rowSet.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return bizBillMap;
    }

    @Override
    protected void calReverseQty() throws OtherBillBizException {
        AbstractObjectCollection entryColl = this.baseInfo.getEntries();
        Map<String, ArApBillEntryBaseInfo> srcBillEntryMap = this.getReverseMap();
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryColl.getObject(i);
            boolean isEntryFullWf = (Boolean)this.isEntryFullWriteoffMap.get(entryInfo.getId().toString());
            if (!srcBillEntryMap.containsKey(entryInfo.getSourceBillEntryId())) continue;
            ArApBillEntryBaseInfo reversedEntryInfo = srcBillEntryMap.get(entryInfo.getSourceBillEntryId());
            BigDecimal unReversedBaseQty = (BigDecimal)reversedEntryInfo.get("UN_REVERSED_BASEQTY");
            if (entryInfo.getBaseQty().signum() * unReversedBaseQty.signum() > 0) {
                if (entryInfo.getBaseQty().abs().compareTo(unReversedBaseQty.abs()) >= 0 || isEntryFullWf) {
                    reversedEntryInfo.setBaseQty(unReversedBaseQty);
                    reversedEntryInfo.put("IS_LAST_REVERSE_ENTRY", true);
                    entryInfo.setBaseQty(entryInfo.getBaseQty().subtract(unReversedBaseQty));
                    unReversedBaseQty = this.ZERO;
                } else {
                    reversedEntryInfo.setBaseQty(entryInfo.getBaseQty());
                    unReversedBaseQty = unReversedBaseQty.subtract(entryInfo.getBaseQty());
                    entryInfo.setBaseQty(this.ZERO);
                    reversedEntryInfo.setAmount(this.ZERO);
                    reversedEntryInfo.setAmountLocal(this.ZERO);
                    reversedEntryInfo.setRecievePayAmount(this.ZERO);
                    reversedEntryInfo.setRecievePayAmountLocal(this.ZERO);
                }
            } else {
                throw new OtherBillBizException(OtherBillBizException.SIGNUMNOTEQUALS);
            }
            this.reversedEntrys.add(reversedEntryInfo);
            reversedEntryInfo.put("UN_REVERSED_BASEQTY", unReversedBaseQty);
        }
    }

    private Map<String, ArApBillEntryBaseInfo> getReverseMap() {
        HashMap<String, ArApBillEntryBaseInfo> reverseMap = new HashMap<String, ArApBillEntryBaseInfo>();
        Collection coll = this.reversedEntryInfoMap.values();
        for (ArApBillEntryBaseInfo entry : coll) {
            reverseMap.put(entry.getSourceBillEntryId(), entry);
        }
        return reverseMap;
    }

    @Override
    protected IArApBillEntryBase getEntryBizInterface() throws BOSException {
        return OtherBillentryFactory.getLocalInstance(this.ctx);
    }

    @Override
    protected IArApBillBase getBizInterface() throws BOSException {
        return OtherBillFactory.getLocalInstance(this.ctx);
    }

    @Override
    protected String getEntryTable() {
        return "T_AR_OtherBillEntry";
    }

    @Override
    protected String getTable() {
        return "T_AR_OtherBill";
    }

    protected String getDestEntryTable() {
        return "T_AR_IncomeConfimEntry";
    }

    @Override
    protected String getSrcBosType() {
        return SCMConstant.BOSTYPE_SALEISSUE;
    }

    @Override
    protected SelectorItemCollection getEntrySelect() {
        SelectorItemCollection selector = ArApSelectorFactory.getArOtherbillEntrySelector(null);
        selector.add("head.id");
        SelectorItemCollection depSic = ArApBillHelper.getEntityDepPropertySelector(this.ctx, ArApConstants.AR_OBILLENTRY_TYPE, true, true, true, null);
        selector = ArApBillUtil.margeSelector(depSic, selector);
        return selector;
    }

    @Override
    protected SelectorItemCollection getBillSelect() {
        return ArApSelectorFactory.getArOtherbillSelector(true);
    }
}

