/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public abstract class BizSysPeriodHelper_Server {
    private TreeMap periodCache;
    private boolean fMax2CurrentPeriod = false;

    public BizSysPeriodHelper_Server(boolean fCurrentPeriod) {
        this.fMax2CurrentPeriod = fCurrentPeriod;
    }

    public abstract SystemEnum getSystemEnum();

    public PeriodInfo getStartPeriod(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo startPeriod = null;
        if (!companyInfo.isIsOnlyUnion()) {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)this.getSystemEnum(), (CompanyOrgUnitInfo)companyInfo);
        }
        return startPeriod;
    }

    public PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = null;
        currentPeriod = companyInfo.isIsOnlyUnion() ? PeriodUtils.getPeriodInfo((Date)new Date(), (CompanyOrgUnitInfo)companyInfo) : SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)this.getSystemEnum(), (CompanyOrgUnitInfo)companyInfo);
        return currentPeriod;
    }

    public PeriodCollection getPeriodc(Context ctx, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (this.fMax2CurrentPeriod) {
            return this.getPeriodsMax2Current(ctx, companyInfo, sysInfo);
        }
        return this.getCompanyAllPeriods(ctx, companyInfo, sysInfo);
    }

    private PeriodCollection getCompanyAllPeriods(Context ctx, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        boolean fBizUnit = !companyInfo.isIsOnlyUnion();
        PeriodInfo startPeriod = null;
        if (fBizUnit) {
            PeriodInfo periodInfo = startPeriod = sysInfo != null ? sysInfo.getStartPeriod(this.getSystemEnum()) : this.getStartPeriod(companyInfo);
            if (startPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (fBizUnit) {
            filterItems.add(new FilterItemInfo("beginDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        return periodc;
    }

    private PeriodCollection getPeriodsMax2Current(Context ctx, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws BOSException, EASBizException {
        PeriodInfo PeriodTo;
        PeriodInfo PeriodFrom;
        boolean fBizUnit = !companyInfo.isIsOnlyUnion();
        Date dateFrom = null;
        if (fBizUnit) {
            PeriodInfo startPeriod;
            PeriodInfo periodInfo = startPeriod = sysInfo != null ? sysInfo.getStartPeriod(this.getSystemEnum()) : this.getStartPeriod(companyInfo);
            if (startPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            dateFrom = startPeriod.getBeginDate();
        } else {
            PeriodInfo compFirstPeriod = this.getFirstPeriodInfo(ctx, companyInfo);
            if (compFirstPeriod == null) {
                throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
            }
            dateFrom = compFirstPeriod.getBeginDate();
        }
        PeriodInfo currentPeriod = sysInfo != null ? sysInfo.getCurrentPeriod(this.getSystemEnum()) : this.getCurrentPeriod(companyInfo);
        Timestamp dateTo = currentPeriod.getEndDate();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (fBizUnit) {
            filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateFrom), CompareType.GREATER_EQUALS));
            filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)dateTo), CompareType.LESS_EQUALS));
        }
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        if (fBizUnit) {
            filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5 ");
        } else {
            filter.setMaskString("(#0 and #1) and #2 and #3 ");
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0 && (PeriodFrom = PeriodUtils.getPeriodInfo(null, (Date)dateFrom, (CompanyOrgUnitInfo)companyInfo)).equals((Object)(PeriodTo = PeriodUtils.getPeriodInfo(null, (Date)dateTo, (CompanyOrgUnitInfo)companyInfo)))) {
            periodc.add(PeriodTo);
        }
        return periodc;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    private void cachePeriod(Context ctx, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        if (this.periodCache == null) {
            this.periodCache = new TreeMap();
        }
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = this.getPeriodc(ctx, companyInfo, sysInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        this.periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    public PeriodInfo getPeriodInfo(Context ctx, int year, int periodNumber, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        Map yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(year));
        if (pc == null || pc.size() == 0) {
            return null;
        }
        if (pc.get(periodNumber - 1) != null && pc.get(periodNumber - 1).getPeriodNumber() == periodNumber) {
            return pc.get(periodNumber - 1);
        }
        PeriodInfo info = null;
        for (int i = 0; i < pc.size(); ++i) {
            info = pc.get(i);
            if (info.getPeriodNumber() != periodNumber) continue;
            return info;
        }
        return null;
    }

    public PeriodInfo getFirstPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        int first = (Integer)yearMap.firstKey();
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(first));
        if (pc == null) {
            return null;
        }
        return pc.get(0);
    }

    public PeriodInfo getPrePeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        Map yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = null;
        if (period.getPeriodNumber() == 1) {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() - 1));
            if (pc != null && pc.size() > 0) {
                return pc.get(pc.size() - 1);
            }
        } else {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        }
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == 0) {
                return null;
            }
            return pc.get(i - 1);
        }
        return null;
    }

    public PeriodInfo getNextPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        Map yearMap;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, null);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public PeriodInfo getLastPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, null);
        }
        if ((yearMap = (TreeMap)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        int end = (Integer)yearMap.lastKey();
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(end));
        if (pc == null) {
            return null;
        }
        return pc.get(pc.size() - 1);
    }

    public PeriodCollection getPeriods(Context ctx, int fromYear, int fromNum, int toYear, int toNum, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return this.getPeriods(ctx, fromYear, fromNum, toYear, toNum, companyInfo, null);
    }

    public PeriodCollection getPeriods(Context ctx, int fromYear, int fromNum, int toYear, int toNum, CompanyOrgUnitInfo companyInfo, ArApSysParamInfo sysInfo) throws EASBizException, BOSException {
        Map yearMap;
        if (fromYear > toYear || fromYear == toYear && fromNum > toYear) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (this.periodCache == null || !this.periodCache.containsKey(companyPK)) {
            this.cachePeriod(ctx, companyInfo, sysInfo);
        }
        if ((yearMap = (Map)this.periodCache.get(companyPK)) == null || yearMap.isEmpty()) {
            return null;
        }
        PeriodCollection pc = (PeriodCollection)yearMap.get(new Integer(fromYear));
        if (pc == null || pc.size() == 0) {
            return null;
        }
        PeriodCollection rsltCols = new PeriodCollection();
        PeriodInfo periodInfo = null;
        int index = 0;
        int colSize = 0;
        for (int year = fromYear; year <= toYear; ++year) {
            pc = (PeriodCollection)yearMap.get(new Integer(year));
            colSize = pc.size();
            for (index = 0; index < colSize; ++index) {
                periodInfo = pc.get(index);
                if (!this.isInRange(periodInfo, fromYear, fromNum, toYear, toNum)) continue;
                rsltCols.add(periodInfo);
            }
        }
        return rsltCols;
    }

    private boolean isInRange(PeriodInfo periodInfo, int fromYear, int fromNum, int toYear, int toNum) {
        int year = periodInfo.getPeriodYear();
        boolean fBetween = year > fromYear && year < toYear;
        boolean fStartYear = false;
        boolean fEndYear = false;
        if (fromYear == toYear) {
            fEndYear = fStartYear = year == fromYear && periodInfo.getPeriodNumber() >= fromNum && periodInfo.getPeriodNumber() <= toNum;
        } else {
            fStartYear = year == fromYear && periodInfo.getPeriodNumber() >= fromNum;
            fEndYear = year == toYear && periodInfo.getPeriodNumber() <= toNum;
        }
        return fBetween || fStartYear || fEndYear;
    }
}

