/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IncomeConfimBillFactory;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.app.web.AbstractAppointmentVoucher;
import com.kingdee.eas.fi.arap.app.web.IAppointmentVoucher;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ARAPAppointmentVoucher
extends AbstractAppointmentVoucher
implements IAppointmentVoucher {
    private String billResourcePath = "com.kingdee.eas.fi.ar.ArApBillResource";
    protected String CashSaleflag = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
    protected String CashPurflag = "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5";
    public static final BigDecimal ZERO = SysConstant.BIGZERO;

    public ARAPAppointmentVoucher(Context context) {
        this.ctx = context;
    }

    private IArApBillBase getBizInterface(String bosType) throws BOSException {
        if ("48DA3A71".equals(bosType)) {
            return com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(this.ctx);
        }
        if (IncomeConfimBillInfo.getBosType().equalsIgnoreCase(bosType)) {
            return IncomeConfimBillFactory.getLocalInstance(this.ctx);
        }
        return OtherBillFactory.getLocalInstance(this.ctx);
    }

    @Override
    protected PeriodInfo getCurrentPeriod(int system, String companyid, String bostype) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyid);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)pk);
        ArApSysParamInfo cache = this.getCache(this.ctx, this.getSysEnum(bostype), company);
        return cache.getCurrentPeriod(cache.getSysEnum());
    }

    @Override
    public Map<String, Object> verifyBefore(String bosType, String companyid, String ids) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)bosType) || StringUtils.isEmpty((String)companyid) || StringUtils.isEmpty((String)ids)) {
            resultMap.put("state", "invalidArgs");
            return resultMap;
        }
        Map lockMap = this.requestLocks(ids);
        if (!Boolean.valueOf(lockMap.get("isSuccess").toString()).booleanValue() || Boolean.valueOf(lockMap.get("hasLockedBefore").toString()).booleanValue()) {
            resultMap.put("state", "lockErr");
            return resultMap;
        }
        HashSet idSet = (HashSet)lockMap.get("lockedIds");
        StringBuffer error = null;
        SystemEnum systemEnum = this.getSysEnum(bosType);
        String actionName = this.getArApBillResourceBy("APPOINTMENTVOUCHER");
        boolean isRelatedAccount = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).isRelatedAccount(companyid, systemEnum);
        if (!isRelatedAccount) {
            error = new StringBuffer();
            error.append(this.getArApBillResourceBy("isNotRelateGL", new Object[]{systemEnum.getAlias()}));
            resultMap.put("errMsg", error.toString());
            resultMap.put("state", "notRelateGL");
            this.releaseLocks(idSet);
            return resultMap;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ArApBillBaseCollection baseCol = this.getArApBillBaseCollection(bosType, idSet);
        ArApBillBaseInfo baseInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo("select id where id = '" + companyid + "'");
        ArApSysParamInfo cache = this.getCache(this.ctx, systemEnum, companyOrgUnitInfo);
        HashMap paramap = cache.getParamValueMap();
        StringBuilder msgBuilder = new StringBuilder();
        String msg = null;
        String billAlias = this.getBillAlias(bosType);
        error = new StringBuffer();
        int len = baseCol.size();
        for (int i = 0; i < len; ++i) {
            String cashflag;
            msgBuilder.setLength(0);
            baseInfo = baseCol.get(i);
            PaymentTypeInfo billPaymentType = baseInfo.getPaymentType();
            boolean isPayTypeCheckUnpass = false;
            if (this.CashSaleflag.equals(billPaymentType.getId().toString()) && paramap.containsKey("AR_RECVOUCHER_BILLTYPE_CASH")) {
                cashflag = paramap.get("AR_RECVOUCHER_BILLTYPE_CASH").toString();
                isPayTypeCheckUnpass = cashflag.equals("0");
            }
            if (this.CashPurflag.equals(billPaymentType.getId().toString()) && paramap.containsKey("AP_PAYVOUCHER_BILLTYPE_CASH")) {
                cashflag = paramap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
                isPayTypeCheckUnpass = cashflag.equals("0");
            }
            if (isPayTypeCheckUnpass) {
                msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), new OtherBillBizException(OtherBillBizException.CASH_APP_SUBJECT).getMessage()));
            }
            if (!baseInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                msg = this.getArApBillResourceBy("point_voucher_unaudit_not");
                if (msgBuilder.length() == 0) {
                    msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                } else {
                    msgBuilder.append(msg);
                }
            }
            if (baseInfo.getBillDate().before(cache.getCurrentPeriod(systemEnum).getBeginDate())) {
                msg = this.getArApBillResourceBy("point_voucher_initbill_not");
                if (msgBuilder.length() == 0) {
                    msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                } else {
                    msgBuilder.append(msg);
                }
            }
            if (baseInfo.getSourceBillType().equals((Object)VerificateBillTypeEnum.ApAgentBizBill)) {
                msg = this.getArApBillResourceBy("point_voucher_approxybill_not");
                if (msgBuilder.length() == 0) {
                    msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                } else {
                    msgBuilder.append(msg);
                }
            } else if (baseInfo.getSourceBillType().equals((Object)VerificateBillTypeEnum.ArAgentBizBill)) {
                msg = this.getArApBillResourceBy("point_voucher_arproxybill_not");
                if (msgBuilder.length() == 0) {
                    msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                } else {
                    msgBuilder.append(msg);
                }
            }
            IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.ctx);
            BOTRelationCollection botRelationCollection = null;
            view = new EntityViewInfo();
            filterInfo = new FilterInfo();
            if (!baseInfo.isIsAppointVoucher()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)bosType));
                filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)baseInfo.getId().toString(), CompareType.EQUALS));
                view.setFilter(filterInfo);
                botRelationCollection = iBotRelation.getCollection(view);
                if (botRelationCollection.size() > 0) {
                    msg = this.getArApBillResourceBy("point_voucher_created_not");
                    if (msgBuilder.length() == 0) {
                        msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                    } else {
                        msgBuilder.append(msg);
                    }
                }
            }
            if (baseInfo instanceof com.kingdee.eas.fi.ap.OtherBillInfo) {
                com.kingdee.eas.fi.ap.OtherBillInfo apInfo = (com.kingdee.eas.fi.ap.OtherBillInfo)baseInfo;
                if (apInfo.getBillType().getValue() != 203) {
                    if (msgBuilder.length() <= 0) continue;
                    error.append(msgBuilder.toString() + "<br>");
                    continue;
                }
                OtherBillentryCollection entryColl = apInfo.getEntry();
                BigDecimal apportAmount = new BigDecimal("0.00");
                BigDecimal amountLocal = new BigDecimal("0.00");
                BigDecimal apportionAmount = null;
                BigDecimal entryAmountLocal = null;
                for (int j = 0; j < entryColl.size(); ++j) {
                    apportionAmount = entryColl.get(j).getApportionAmount() != null ? entryColl.get(j).getApportionAmount() : new BigDecimal("0.00");
                    entryAmountLocal = entryColl.get(j).getAmountLocal() != null ? entryColl.get(j).getAmountLocal() : new BigDecimal("0.00");
                    apportAmount = apportAmount.add(apportionAmount);
                    amountLocal = amountLocal.add(entryAmountLocal);
                }
                BigDecimal unApportAmount = amountLocal.subtract(apportAmount);
                if (ZERO.compareTo(unApportAmount) != 0 && ZERO.compareTo(apportAmount) != 0) {
                    msg = MessageFormat.format(this.getArApBillResourceBy("HasUnApportAmount"), actionName, actionName);
                    if (msgBuilder.length() == 0) {
                        msgBuilder.append(this.verifyMsg(billAlias, baseInfo.getNumber(), msg));
                    } else {
                        msgBuilder.append(msg);
                    }
                }
            }
            if (msgBuilder.length() <= 0) continue;
            error.append(msgBuilder.toString() + "<br>");
        }
        if (error.length() > 0) {
            resultMap.put("errMsg", error.toString());
            resultMap.put("state", "unpass");
        } else {
            resultMap.put("state", "pass");
        }
        this.releaseLocks(idSet);
        return resultMap;
    }

    public String getArApBillResourceBy(String key) {
        Locale loc = this.ctx.getLocale();
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)key, (Locale)loc);
    }

    public String getArApBillResourceBy(String key, Object[] param) {
        Locale loc = this.ctx.getLocale();
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)key, (Locale)loc, (Object[])param);
    }

    @Override
    public Map<String, Object> appointmentVoucher(String bosType, String companyid, String ids, int periodYear, int periodNumber, String voucherTypeid, String vouchernumber) throws EASBizException, BOSException {
        Locale loc = this.ctx.getLocale();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        VoucherInfo voucherInfo = this.checkVoucher(companyid, periodYear, periodNumber, voucherTypeid, vouchernumber);
        if (voucherInfo == null) {
            resultMap.put("state", "fail");
            resultMap.put("errMsg", EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"60_RecPaypointmentVoucherUI", (Locale)loc));
            return resultMap;
        }
        PeriodInfo currentPeriod = this.getCurrentPeriod(this.getSysEnum(bosType).getValue(), companyid, bosType);
        boolean isBeforeCurrentPeriod = false;
        if (currentPeriod != null && currentPeriod.getPeriodYear() > periodYear) {
            isBeforeCurrentPeriod = true;
        } else if (currentPeriod.getPeriodYear() == periodYear && currentPeriod.getPeriodNumber() > periodNumber) {
            isBeforeCurrentPeriod = true;
        }
        if (isBeforeCurrentPeriod) {
            resultMap.put("state", "fail");
            resultMap.put("errMsg", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"canNotPointBeforeVoucher", (Locale)this.ctx.getLocale()));
            return resultMap;
        }
        Map lockMap = this.requestLocks(ids);
        HashSet idSet = (HashSet)lockMap.get("lockedIds");
        if (idSet != null && idSet.size() > 0) {
            ArApBillBaseCollection baseCol = this.getArApBillBaseCollection(bosType, idSet);
            ArApBillBaseInfo baseInfo = null;
            SystemEnum sysEnum = this.getSysEnum(bosType);
            IObjectPK logPK = null;
            BOSObjectType bosObjType = BOSUuid.create((String)bosType).getType();
            String arLogMsg = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"70_ArAppointmentVoucherUI", (Locale)loc);
            String apLogMsg = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"71_ArAppointmentVoucherUI", (Locale)loc);
            int len = baseCol.size();
            for (int i = 0; i < len; ++i) {
                baseInfo = baseCol.get(i);
                baseInfo.setVoucher(voucherInfo);
                baseInfo.setVoucherNumber(vouchernumber);
                baseInfo.setVoucherType(voucherInfo.getVoucherType());
                baseInfo.setIsAppointVoucher(true);
                baseInfo.setAccountant(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                if (sysEnum == SystemEnum.ACCOUNTSRECEIVABLE) {
                    logPK = LogUtil.beginLog((Context)this.ctx, (String)arLogMsg, (BOSObjectType)bosObjType, null, (String)(baseInfo.getNumber() + arLogMsg));
                } else if (sysEnum == SystemEnum.ACCOUNTSPAYABLE) {
                    logPK = LogUtil.beginLog((Context)this.ctx, (String)apLogMsg, (BOSObjectType)bosObjType, null, (String)(baseInfo.getNumber() + apLogMsg));
                }
                this.delBotpRelation(baseInfo.getId().toString());
                this.createBotpRelation(baseInfo.getId().toString(), baseInfo.getVoucher().getId().toString(), bosType);
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
            this.getBizInterface(bosType).batchAppointmentVoucher(idSet, baseInfo, sysEnum == SystemEnum.ACCOUNTSRECEIVABLE);
            if (baseInfo != null) {
                this.updateVoucherSrcBillId(baseInfo.getId().toString(), voucherInfo);
            }
            this.releaseLocks(idSet);
        }
        resultMap.put("state", "success");
        resultMap.put("voucherId", voucherInfo.getId().toString());
        return resultMap;
    }

    private ArApSysParamInfo getCache(Context ctx, SystemEnum sysEnum, CompanyOrgUnitInfo org) throws BOSException, EASBizException {
        LinkedHashMap<String, Object> uiParam = new LinkedHashMap<String, Object>();
        uiParam.put("sysEnum", sysEnum);
        uiParam.put("isSCM", false);
        ArApBillBaseInfo info = null;
        if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)sysEnum)) {
            info = new com.kingdee.eas.fi.ap.OtherBillInfo();
            uiParam.put("permissionItem", "fi_ap_ApOtherBill_View");
        } else {
            info = new OtherBillInfo();
            uiParam.put("permissionItem", "fi_ar_ArOtherBill_View");
        }
        uiParam.put("billInfo", info);
        IArApBillFacade iBillFacade = ArApBillFacadeFactory.getLocalInstance((Context)ctx);
        ArApSysParamInfo cache = iBillFacade.getSysParams(org, uiParam);
        return cache;
    }

    private ArApBillBaseCollection getArApBillBaseCollection(String bosType, Set billIdSet) throws BOSException, EASBizException {
        if (billIdSet == null || billIdSet.size() <= 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billIdSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        ArApBillBaseCollection baseCol = this.getBizInterface(bosType).getArApBillBaseCollection(view);
        return baseCol;
    }
}

