/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.IReceivingBillEntry;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppointmentAccountUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.AppointmentAccountUtil");
    private Context ctx;

    public AppointmentAccountUtil(Context context) {
        this.ctx = context;
    }

    public Class[] getParameterTypes() {
        return new Class[]{IObjectPK[].class, AccountViewInfo.class, ArrayList.class};
    }

    public BatchExecuteParamsEntry[] getParameters(String bosType, List<String> idList, String accountid, String oppAccountId) throws EASBizException, BOSException {
        if ("48DA3A71".equals(bosType) || "FC910EF3".equals(bosType) || "A8378ABC".equals(bosType)) {
            return this.getArapParams(idList, accountid, oppAccountId);
        }
        ArrayList<String> entryIdList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int len = idList.size();
        for (int i = 0; i < len; ++i) {
            sb.append(idList.get(i)).append(",");
        }
        if (sb.length() > 0) {
            boolean isRec = "FA44FD5B".equals(bosType);
            String parent = isRec ? "receivingBill.id" : "paymentBill.id";
            IReceivingBillEntry irp = isRec ? ReceivingBillEntryFactory.getLocalInstance((Context)this.ctx) : PaymentBillEntryFactory.getLocalInstance((Context)this.ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo(parent, (Object)sb.substring(0, sb.length() - 1), CompareType.INCLUDE));
            evi.setFilter(fi);
            CoreBaseCollection core = irp.getCollection(evi);
            int size = core.size();
            for (int i = 0; i < size; ++i) {
                entryIdList.add(core.get(i).get("id").toString());
            }
        }
        return this.getPayRecParams(bosType, idList, entryIdList, accountid, oppAccountId);
    }

    private BatchExecuteParamsEntry[] getArapParams(List<String> idList, String accountid, String oppAccountId) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        AccountViewInfo accountViewInfo = null;
        Class[] paramTypes = null;
        paramTypes = "true".equals(accountid) || "false".equals(accountid) ? new Class[]{IObjectPK[].class, Boolean.class, Boolean.class} : new Class[]{IObjectPK[].class, AccountViewInfo.class, AccountViewInfo.class};
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)this.ctx);
        AccountViewInfo accountViewInfoMain = null;
        if (!StringUtils.isEmpty((String)accountid) && BOSUuid.isValid((String)accountid, (boolean)true)) {
            accountViewInfoMain = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountid));
        }
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(idList.get(i))};
            entry.add((Object)pks);
            accountViewInfo = new AccountViewInfo();
            if ("true".equals(accountid) || "false".equals(accountid)) {
                entry.add((Object)Boolean.parseBoolean(accountid));
            } else {
                if (accountViewInfoMain != null) {
                    accountViewInfo = accountViewInfoMain;
                }
                entry.add((Object)accountViewInfo);
            }
            if ("true".equals(oppAccountId) || "false".equals(oppAccountId)) {
                entry.add((Object)Boolean.parseBoolean(oppAccountId));
            } else {
                accountViewInfo = new AccountViewInfo();
                if (!StringUtils.isEmpty((String)oppAccountId)) {
                    accountViewInfo.setId(BOSUuid.read((String)oppAccountId));
                }
                entry.add((Object)accountViewInfo);
            }
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    private BatchExecuteParamsEntry[] getPayRecParams(String bosType, List<String> idList, List<String> entryIdList, String accountid, String oppAccountId) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        AccountViewInfo accountViewInfo = null;
        Class[] paramTypes = null;
        paramTypes = "true".equals(accountid) || "false".equals(accountid) ? new Class[]{IObjectPK[].class, ArrayList.class} : new Class[]{IObjectPK[].class, AccountViewInfo.class, AccountViewInfo.class, ArrayList.class};
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(idList.get(i))};
            entry.add((Object)pks);
            if (!"true".equals(accountid) && !"false".equals(accountid)) {
                accountViewInfo = new AccountViewInfo();
                if (!StringUtils.isEmpty((String)accountid) && BOSUuid.isValid((String)accountid, (boolean)true)) {
                    accountViewInfo.setId(BOSUuid.read((String)accountid));
                }
                entry.add((Object)accountViewInfo);
            }
            if (!"true".equals(oppAccountId) && !"false".equals(oppAccountId)) {
                accountViewInfo = new AccountViewInfo();
                if (!StringUtils.isEmpty((String)oppAccountId)) {
                    accountViewInfo.setId(BOSUuid.read((String)oppAccountId));
                }
                entry.add((Object)accountViewInfo);
            }
            entry.add(entryIdList);
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return ((Object[])paramEntry.get(0))[0];
    }

    protected void dealwithResult(BatchExecuteResult exeResult, Map<String, Object> result, BatchExecuteParamsEntry[] params) {
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            int errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                result.put(this.getId(params[i]).toString(), exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            int errorCount = result.size();
            BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
            for (int i = 0; i < params.length; ++i) {
                Object id = this.getId(params[i]);
                ActionResult actionResult = actionResults.getActionResult(id);
                if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                result.put(id.toString(), actionResult.getMessage());
                ++errorCount;
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
    }

    protected List<String> requestLocks(Context ctx, List<String> toLockList, Map<String, Object> result) throws BOSException {
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(toLockList);
        ArrayList<String> lockedList = new ArrayList<String>(toLockList.size());
        if (lockMap != null) {
            for (int i = 0; i < toLockList.size(); ++i) {
                String id = toLockList.get(i);
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockedList.add(id);
                    continue;
                }
                result.put(id, "request mutex lock failed!");
            }
        }
        return lockedList;
    }

    protected void releaseLocks(Context ctx, List<String> lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> appointmentAccount(String bosType, String methodName, String accountId, String oppAccountId, String ids) throws EASBizException, BOSException {
        String[] billIDs = ids.split(",");
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> lockedList = null;
        BatchExecuteResult exeResult = new BatchExecuteResult(idList.size());
        try {
            lockedList = this.requestLocks(this.getContext(), idList, result);
            if (!result.isEmpty()) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_MutexSC_Request", (Locale)this.ctx.getLocale())});
            }
            BatchExecuteParamsEntry[] params = this.getParameters(bosType, lockedList, accountId, oppAccountId);
            Method method = null;
            try {
                method = bizCtrl.getClass().getMethod(methodName, params[0].getParamTypes());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            int size = params.length;
            for (int i = 0; i < size; ++i) {
                try {
                    method.invoke((Object)bizCtrl, params[i].toArray());
                    continue;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CasForArApException || e.getCause() instanceof OtherBillBizException || e.getCause() instanceof com.kingdee.eas.fi.ap.OtherBillBizException) {
                        exeResult.setException(i, e.getCause());
                        continue;
                    }
                    throw new BOSException((Throwable)e);
                }
            }
            this.dealwithResult(exeResult, result, params);
        }
        finally {
            this.releaseLocks(this.getContext(), lockedList);
        }
        return result;
    }

    private Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> verifyBefore(String billIDs) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean iscurrencyDif = false;
        String[] ids = billIDs.split(",");
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as currencycount from T_cas_paymentbill where fid in (");
        sql.append(this.getString(ids)).append(")");
        sql.append(" group by fcurrencyid");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        int currencycount = rs.size();
        iscurrencyDif = currencycount > 1;
        map.put("iscurrencyDif", iscurrencyDif);
        return map;
    }

    private String getString(String[] billIds) {
        StringBuffer buf = new StringBuffer();
        int len = billIds.length;
        for (int k = 0; k < len; ++k) {
            buf.append("'").append(billIds[k]).append("',");
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - 1);
        }
        return "null";
    }
}

