/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastGLCheckParam;
import com.kingdee.eas.fi.ar.ContrastGLException;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.IManageAccount;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.rc.ContrastCenterFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ArApClosePeriodService {
    private Context ctx;

    public ArApClosePeriodService(Context context) {
        this.ctx = context;
    }

    private String getPermission(boolean isAR, boolean isMultiOrg) {
        String permission = "";
        permission = isMultiOrg ? (isAR ? "fi_ar_CloseArAccount" : "mutiorg_fi_arap_CloseApAccount") : (isAR ? "fi_arap_CloseArAccount" : "fi_arap_CloseApAccount");
        return permission;
    }

    public Map getData(Context ctx, Map condition) throws BOSException, EASBizException {
        String orgFilterStr;
        BOSUuid userId;
        String sidx;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        LinkedList data = new LinkedList();
        result.put("records", Integer.valueOf(0));
        result.put("rows", data);
        String sord = condition.get("sord") == null ? "" : condition.get("sord").toString();
        String string = sidx = condition.get("sidx") == null ? "" : condition.get("sidx").toString();
        if (sord == null || "".equals(sord)) {
            sord = "asc";
        }
        boolean isAR = false;
        if (condition != null && condition.get("system") != null && "ar".equals(condition.get("system").toString())) {
            isAR = true;
        }
        boolean isMultiOrg = new Boolean(condition.get("isMultiOrg").toString());
        String loc = ctx.getLocale().toString();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, this.getPermission(isAR, isMultiOrg));
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.Company);
        FullOrgUnitCollection neworgs = new FullOrgUnitCollection();
        if (!isMultiOrg) {
            for (int i = 0; i < orgs.size(); ++i) {
                FullOrgUnitInfo tempOrgUnit = orgs.get(i);
                if (!tempOrgUnit.getId().equals((Object)orgUnitInfo.getId())) continue;
                neworgs.add(tempOrgUnit);
                break;
            }
            orgs = neworgs;
        }
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        StringBuffer orgFilter = new StringBuffer();
        String string2 = orgFilterStr = condition.get("orgFilter") == null ? "" : condition.get("orgFilter").toString();
        if (StringUtils.isEmpty((String)orgFilterStr)) {
            orgFilter.append("(");
            int length = orgs.size();
            for (int i = 0; i < length; ++i) {
                orgFilter.append("'" + orgs.get(i).getId() + "',");
            }
            orgFilter.deleteCharAt(orgFilter.length() - 1);
            orgFilter.append(")");
        } else {
            String[] orgsArray = orgFilterStr.split(",");
            orgFilter.append("(");
            int length = orgsArray.length;
            for (int i = 0; i < length; ++i) {
                orgFilter.append("'" + orgsArray[i] + "',");
            }
            orgFilter.deleteCharAt(orgFilter.length() - 1);
            orgFilter.append(")");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID, \n");
        sql.append("    c.FID FOrgID, c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth, p.FNUMBER FPeriodNumber \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 and fIsOnlyUnion =0 \n");
        sql.append(" and sc.fisstart = 1");
        if (isAR) {
            sql.append("    and s.FName = 12 \n");
        } else {
            sql.append("    and s.FName = 13 \n");
        }
        sql.append("    and c.FID in " + orgFilter + " \n");
        sql.append("\n");
        if (sidx != null && !"".equals(sidx) && ("orgNumber".equals(sidx) || "orgName".equals(sidx))) {
            sql.append(" order by f").append(sidx).append(" ").append(sord);
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = rowSet.getString("FID");
                String orgId = rowSet.getString("FOrgID");
                String orgNumber = rowSet.getString("FOrgNumber");
                String orgName = rowSet.getString("FOrgName");
                String periodId = rowSet.getString("FPeriodID");
                String periodMonth = rowSet.getString("FPeriodMonth");
                String periodYear = rowSet.getString("FPeriodYear");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodName = periodYear + this.getResourceStr("Year") + periodMonth + this.getResourceStr("Field");
                map.put("id", id);
                map.put("orgId", orgId);
                map.put("orgNumber", orgNumber);
                map.put("orgName", orgName);
                map.put("periodId", periodId);
                map.put("periodName", periodName);
                map.put("periodnumber", rowSet.getString("FPeriodNumber"));
                data.add(map);
            }
            int records = rowSet.size();
            result.put("records", Integer.valueOf(records));
            result.put("rows", data);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public Map closeCheck(Context ctx, Map condition) throws EASBizException, BOSException {
        HashMap<String, Object> error;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        int errorIndex = 0;
        boolean isAR = false;
        if (condition.get("system") != null && "ar".equals(condition.get("system").toString())) {
            isAR = true;
        }
        String id = (String)condition.get("id");
        String companyid = condition.get("orgId").toString();
        String periodid = condition.get("periodId").toString();
        int system = this.getSystem(isAR);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
        SystemEnum sysEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        boolean fRelateGL = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)companyInfo);
        if (!fRelateGL) {
            HashMap<String, Object> error2 = new HashMap<String, Object>();
            errors.add(error2);
            error2.put("id", id + "_" + ++errorIndex);
            error2.put("orgName", new ContrastGLException(ContrastGLException.NOT_CONN_GL).getMessage());
            error2.put("isError", true);
        }
        ContrastGLCheckParam param = new ContrastGLCheckParam();
        param.setAccountIds(this.getAccountList(ctx, companyInfo, periodInfo, system));
        param.setCheckBillAudited(true);
        param.setCheckBillVouchered(true);
        param.setCheckVoucherPeriod(false);
        param.setCheckVoucherRelatedBill(false);
        param.setchkCashVerifiBill(true);
        param.setCompanyId(condition.get("orgId").toString());
        IReportData reportData = ContrastGLFacadeFactory.getLocalInstance(ctx).checkAPGL(param);
        int size = reportData.size();
        ArrayList<Object> errorItems = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            ReportInfo info = (ReportInfo)reportData.getReportRowInfo(i);
            if (errorItems.contains(info.get("item"))) continue;
            error = new HashMap();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", info.get("item") + this.getResourceStr("Failu"));
            error.put("operation", this.getResourceStr("Detail"));
            error.put("isError", true);
            errors.add(error);
            errorItems.add(info.get("item"));
        }
        int contrastResult = 0;
        try {
            contrastResult = ContrastCenterFacadeFactory.getLocalInstance((Context)ctx).contrast(companyInfo, system, periodInfo);
        }
        catch (EASBizException e) {
            error = new HashMap<String, Object>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", e.getMessage());
            error.put("isError", true);
            error.put("isIgnore", false);
            error.put("operatfunction", "showContrastResult");
            error.put("orgId", companyid);
            error.put("companyname", companyInfo.getName());
            errors.add(error);
            return result;
        }
        if (contrastResult == 0) {
            HashMap<String, Object> error3 = new HashMap<String, Object>();
            error3.put("id", id + "_" + ++errorIndex);
            error3.put("orgName", this.getResourceStr("BalanceResult"));
            error3.put("operation", this.getResourceStr("Detail"));
            error3.put("isError", true);
            error3.put("isIgnore", false);
            error3.put("operatfunction", "showContrastResult");
            error3.put("orgId", companyid);
            error3.put("companyname", companyInfo.getName());
            errors.add(error3);
        }
        if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        result.put("status", "success");
        return result;
    }

    private List checkcanUnClose(String id, CompanyOrgUnitInfo companyInfo, PeriodInfo currPeriod, boolean isAR) throws EASBizException, BOSException {
        ArrayList errors = new ArrayList();
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
        String errorMsg = "";
        if (currPeriod.equals((Object)startPeriod)) {
            this.addError(errors, id, this.getResourceStr("CurrentFieldEqualCannotSettle"));
            return errors;
        }
        boolean apIsRltdAccunt = SystemStatusCtrolUtils.isRelAccount((Context)this.ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
        if (apIsRltdAccunt) {
            int result;
            SystemStatusCtrolUtils utils = new SystemStatusCtrolUtils();
            boolean isEqualsCurPeriodAndRelPeriod = utils.isEqualsCurPeriodAndRelPeriod(this.ctx, companyInfo.getId().toString(), systemEnum);
            if (isEqualsCurPeriodAndRelPeriod) {
                this.addError(errors, id, this.getResourceStr("CurrentFieldAndLedger"));
                return errors;
            }
            PeriodInfo glcurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
            if (currPeriod != null && glcurrentPeriod != null && (result = PeriodUtils.PeriodCompare((String)currPeriod.getId().toString(), (String)glcurrentPeriod.getId().toString())) == 0) {
                this.addError(errors, id, this.getResourceStr("APSysCurrentLeaderCannotUnSettle"));
                return errors;
            }
        }
        return errors;
    }

    private void addError(List errors, String id, String errorMsg) {
        this.addError(errors, id, errorMsg, null, null, null, null, null);
    }

    private void addError(List errors, String id, String errorMsg, String operation, String operatfunction, String periodId, String orgId, List gainAndLossIdList) {
        if (null == errors) {
            return;
        }
        HashMap<String, Object> error = new HashMap<String, Object>(10);
        error.put("id", id + "_" + (errors.size() + 1));
        error.put("orgName", errorMsg);
        error.put("isError", true);
        if (null != operation) {
            error.put("operation", operation);
            error.put("operatfunction", operatfunction);
            error.put("periodId", periodId);
            error.put("orgId", orgId);
        }
        error.put("gainAndLossIdList", gainAndLossIdList);
        errors.add(error);
    }

    private Map<String, Object> newError(String id, int errorIndex, String errorMsg, String operation, boolean isIgnore, String operatfunction, int periodnumber, CompanyOrgUnitInfo companyInfo) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("id", id + "_" + ++errorIndex);
        error.put("orgName", errorMsg);
        error.put("operation", operation);
        error.put("isError", true);
        error.put("isIgnore", isIgnore);
        error.put("operatfunction", operatfunction);
        error.put("orgId", companyInfo.getId().toString());
        error.put("companyname", companyInfo.getName());
        return error;
    }

    private List checkcanClose(IManageAccount iManageAccount, CompanyOrgUnitInfo companyInfo, PeriodInfo currPeriod, String id, boolean isRelatedGL, boolean glIsStart, boolean isAR) throws EASBizException, BOSException {
        int j;
        int size;
        ArrayList<String> gainAndLossIdList;
        CoreBaseCollection coll;
        Map isVoucherMap;
        String ischevkVoucher;
        String arap;
        Map isAuditedMap;
        Boolean isAudited;
        PeriodInfo nextNextPeriod;
        ArrayList errors = new ArrayList();
        String companyid = companyInfo.getId().toString();
        String periodid = currPeriod.getId().toString();
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)currPeriod);
        String errorMsg = null;
        if (nextPeriod == null) {
            this.addError(errors, id, this.getStrResource("next_period_error"));
        } else if (nextPeriod.isIsAdjustPeriod() && ((nextNextPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)nextPeriod)) == null || nextNextPeriod.getId() == null)) {
            errorMsg = MessageFormat.format(this.getStrResource("AdjustNextPeriodNotDefined_437"), companyInfo.getName(), nextPeriod.get("description"));
            this.addError(errors, id, errorMsg);
        }
        if (this.isAPRelationSCM(companyid, isAR)) {
            PeriodInfo scmCurPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (scmCurPeriodInfo == null) {
                this.addError(errors, id, this.getStrResource("scm_period_null"));
            } else if (PeriodUtils.PeriodCompare((String)scmCurPeriodInfo.getId().toString(), (String)currPeriod.getId().toString()) != 1) {
                this.addError(errors, id, this.getStrResource("scm_not_settle_account"));
            }
        }
        if ((isAudited = (Boolean)(isAuditedMap = iManageAccount.unAuditedOrVouchered4web("audited", arap = isAR ? "AR" : "AP", null, companyid)).get("checkResult")).booleanValue()) {
            errorMsg = this.getResourceStr("BillUnAuditOrUnRequest");
            this.addError(errors, id, errorMsg, this.getResourceStr("Detail"), "showUnAuditBill", periodid, companyid, null);
        }
        if ((ischevkVoucher = this.getSystemParams(companyid, isAR ? "AR_CHECK_VOUCHER_001" : "AP_CHECK_VOUCHER_001")).equals("true")) {
            isVoucherMap = ManageAccountFactory.getLocalInstance(this.ctx).unAuditedOrVouchered4web("vouchered", arap, null, companyid);
            Boolean isVouchered = (Boolean)isVoucherMap.get("checkResult");
            coll = (CoreBaseCollection)isVoucherMap.get("veriBillColl");
            gainAndLossIdList = new ArrayList<String>();
            if (coll != null) {
                size = coll.size();
                for (j = 0; j < size; ++j) {
                    gainAndLossIdList.add(((VerificationBillBaseInfo)coll.get(j)).getId().toString());
                }
            }
            if (isVouchered.booleanValue()) {
                errorMsg = this.getResourceStr("BillNoVercator");
                this.addError(errors, id, errorMsg, this.getResourceStr("Deal"), "showUnVoucheredBill", periodid, companyid, gainAndLossIdList);
            }
        }
        if (!ArApParamHelper.isDAPCheckAccount(this.ctx) && isRelatedGL && glIsStart) {
            isVoucherMap = ManageAccountFactory.getLocalInstance(this.ctx).unAuditedOrVouchered4web("vouchered", arap, "verifyBill", companyid);
            boolean hasVerificateBillNoVouchered = (Boolean)isVoucherMap.get("checkResult");
            coll = (CoreBaseCollection)isVoucherMap.get("veriBillColl");
            gainAndLossIdList = new ArrayList();
            if (coll != null) {
                size = coll.size();
                for (j = 0; j < size; ++j) {
                    gainAndLossIdList.add(((VerificationBillBaseInfo)coll.get(j)).getId().toString());
                }
            }
            boolean hasTransferBill = iManageAccount.isVoucherTransBill4web(arap, companyid);
            if (hasVerificateBillNoVouchered || hasTransferBill) {
                errorMsg = this.getResourceStr("verificate_transbill_not_vouchered");
                this.addError(errors, id, errorMsg, this.getResourceStr("Deal"), "showUnVoucheredBill", periodid, companyid, gainAndLossIdList);
            }
        }
        return errors;
    }

    private Map checkContrastResult(IManageAccount iManageAccount, CompanyOrgUnitInfo companyInfo, PeriodInfo currPeriod, String id, boolean isRelatedGL, boolean glIsStart, int errorIndex, boolean isIgnore, boolean isAR) throws EASBizException, BOSException {
        Map<String, Object> resultMap = null;
        String companyid = companyInfo.getId().toString();
        String iscontrast = this.getSystemParams(companyid, isAR ? "AR_ClosePeriod" : "AP_ClosePeriod_001");
        if (!isRelatedGL && iscontrast.equals("true")) {
            resultMap = this.newError(id, errorIndex, new ContrastGLException(ContrastGLException.NOT_CONN_GL).getMessage(), "", isIgnore, "", currPeriod.getNumber(), companyInfo);
        }
        int system = this.getSystem(isAR);
        if (isRelatedGL && glIsStart && iscontrast.equals("true")) {
            int contrastResult = 0;
            String errorMsg = "";
            try {
                contrastResult = ContrastCenterFacadeFactory.getLocalInstance((Context)this.ctx).contrast(companyInfo, system, currPeriod);
            }
            catch (Exception e) {
                errorMsg = this.getResourceStr("BalanceErroe") + (e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
                return this.newError(id, errorIndex, errorMsg, "", isIgnore, "", currPeriod.getNumber(), companyInfo);
            }
            if (contrastResult == 0) {
                errorMsg = this.getResourceStr("BalanceResult");
                resultMap = this.newError(id, errorIndex, errorMsg, this.getResourceStr("Detail"), isIgnore, "showContrastResult", currPeriod.getNumber(), companyInfo);
            }
        }
        return resultMap;
    }

    private String getStrResource(String resKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)this.ctx.getLocale());
    }

    public boolean isAPRelationSCM(String companyID, boolean isAR) throws BOSException, EASBizException {
        String value;
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String param = "AP_SCM_001";
        if (isAR) {
            param = "AR_SCM_001";
        }
        if ((value = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)pk, param)) == null && isAR) {
            return this.getDefaulParam("com.kingdee.eas.fi.ap.ap", param);
        }
        if (value == null && !isAR) {
            return this.getDefaulParam("com.kingdee.eas.fi.ar.ar", param);
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    private boolean getDefaulParam(String system, String number) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getLocalInstance((Context)this.ctx);
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(number).append("'");
        oql.append(" and subSysID ='").append(system).append("'");
        ParamCollection paramCollection = iParam.getParamCollection(oql.toString());
        ParamInfo paramInfo = null;
        if (paramCollection != null) {
            paramInfo = paramCollection.get(0);
            if (paramInfo != null) {
                return "true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue());
            }
            return true;
        }
        return true;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String companyID) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
        return company;
    }

    public void addSuccessInfo(Map resultMap, SystemEnum systemEnum, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (null == resultMap) {
            return;
        }
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + this.getResourceStr("Year") + periodMonth + this.getResourceStr("Field");
        resultMap.put("periodId", currentPeriod.getId().toString());
        resultMap.put("periodName", periodName);
        resultMap.put("status", "success");
    }

    public Map closePeriod(Context ctx, Map condition) throws EASBizException, BOSException {
        Map error;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String companyid = condition.get("orgId").toString();
        String currPeriodid = condition.get("periodId").toString();
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(ctx, companyid);
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid));
        boolean isAR = false;
        if (condition.get("system") != null && "ar".equals(condition.get("system").toString())) {
            isAR = true;
        }
        String id = (String)condition.get("id");
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        boolean isRelatedGL = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
        boolean glIsStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
        IManageAccount iManageAccount = ManageAccountFactory.getLocalInstance(ctx);
        List errors = this.checkcanClose(iManageAccount, companyInfo, periodInfo, id, isRelatedGL, glIsStart, isAR);
        result.put("status", "error");
        result.put("errors", errors);
        boolean isIgnore = false;
        if (condition.get("ignores") != null) {
            isIgnore = Boolean.parseBoolean(condition.get("ignores").toString());
        }
        if ((error = this.checkContrastResult(iManageAccount, companyInfo, periodInfo, id, isRelatedGL, glIsStart, errors.size(), isIgnore, isAR)) != null) {
            errors.add(error);
            result.put("errors", errors);
            if (!isIgnore || errors.size() > 1) {
                return result;
            }
        } else if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        iManageAccount.closeApAccount4web(companyid, isAR);
        this.addSuccessInfo(result, systemEnum, companyInfo);
        return result;
    }

    public Map unClosePeriod(Context ctx, Map condition) throws EASBizException, BOSException {
        String id;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        String companyid = condition.get("orgId").toString();
        String currPeriodid = condition.get("periodId").toString();
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid));
        boolean isAR = false;
        if (condition.get("system") != null && "ar".equals(condition.get("system").toString())) {
            isAR = true;
        }
        if ((errors = this.checkcanUnClose(id = (String)condition.get("id"), companyInfo, periodInfo, isAR)).size() > 0) {
            result.put("errors", errors);
            return result;
        }
        try {
            ManageAccountFactory.getLocalInstance(ctx).reverseCloseApAccount4web(companyid, isAR);
        }
        catch (EASBizException e) {
            this.addError(errors, id, e.getMessage());
            result.put("errors", errors);
            return result;
        }
        SystemEnum systemEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        this.addSuccessInfo(result, systemEnum, companyInfo);
        return result;
    }

    private String getSystemParams(String companyID, String paramNumber) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)pk, paramNumber);
        return value;
    }

    private List getAccountList(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, int system) throws EASBizException, BOSException {
        IRowSet rs = ContrastAccountViewFactory.getLocalInstance((Context)ctx).getAccountView(system, companyInfo, companyInfo.getAccountTable().getId().toString(), periodInfo.getPeriodYear(), periodInfo.getPeriodNumber());
        ArrayList<String> accountList = new ArrayList<String>();
        try {
            while (rs.next()) {
                accountList.add(rs.getString("FAccountID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return accountList;
    }

    private int getSystem(boolean isAR) {
        return isAR ? 12 : 13;
    }

    private String getResourceStr(String key) {
        String resClassName = "com.kingdee.eas.fi.arap.ArapAllResource";
        return EASResource.getString((String)resClassName, (String)key, (Locale)this.ctx.getOriginLocale());
    }
}

