/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.impl.PermissionService");
    private Context ctx;

    public BaseService(Context context) {
        this.ctx = context;
    }

    private Context getContext() {
        return this.ctx;
    }

    public OrgUnitInfo[] getAuthorizedOrgUnits(int orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(OrgType.getEnum((int)orgType), permissionItem);
        OrgUnitInfo[] orgs = new OrgUnitInfo[collection.size()];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            orgs[i] = collection.get(i);
        }
        return orgs;
    }

    public OrgUnitInfo[] getAuthorizedBizOrgUnits(int orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(OrgType.getEnum((int)orgType), permissionItem);
        if (collection == null || collection.size() == 0) {
            return new OrgUnitInfo[0];
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        OrgUnitInfo[] results = this.getOrgUnitInfosByType(keys, orgType);
        return results;
    }

    protected OrgUnitCollection getAuthOrgByPermItem(OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)this.getContext());
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(this.getContext().getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public OrgUnitInfo[] getOrgUnitInfosByType(Set<String> keys, int orgTypeValue) throws BOSException, EASBizException {
        OrgType orgType = OrgType.getEnum((int)orgTypeValue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("number"));
        view.setSorter(sortCol);
        view.setFilter(filter);
        view.setSelector(this.getOrgInfoSelector(orgType));
        Context ctx = this.getContext();
        OrgUnitInfo[] results = null;
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return results;
    }

    public SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
        }
        return selector;
    }

    public Map<String, Object> getContrastAccountF7(String companyid, int system, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int contrastAccountViewSystem = 1;
        if (system == 13) {
            contrastAccountViewSystem = 2;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        items.add(new FilterItemInfo("ContrastAccountView.system", (Object)contrastAccountViewSystem));
        items.add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        items.add(new FilterItemInfo("companyOrgUnit.id", (Object)companyid, CompareType.EQUALS));
        items.add(new FilterItemInfo("contrastCU.id", (Object)companyInfo.getCU().getId(), CompareType.EQUALS));
        PeriodInfo period = this.getCurrentPeriod(system, companyid);
        if (period != null) {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)period.getPeriodYear(), CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)period.getPeriodNumber(), CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)0, CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)0, CompareType.EQUALS));
        }
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2 AND #3 AND #4 AND #5");
        if ((accountTableID == null || accountTableID.length() < 2) && companyInfo.getAccountTable() != null) {
            accountTableID = companyInfo.getAccountTable().getId().toString();
        }
        if (baseCurrencyid == null && companyInfo.getBaseCurrency() != null) {
            baseCurrencyid = companyInfo.getBaseCurrency().getId().toString();
        }
        if (currentAccountTableID == null || currentAccountTableID.length() < 2) {
            currentAccountTableID = this.getCurrentAccountTableID(system, period, companyid, accountTableID);
        }
        int maskNo = items.size() - 1;
        if (currentAccountTableID != null && currentAccountTableID.length() > 0) {
            items.add(new FilterItemInfo("accountTableID.id", (Object)currentAccountTableID, CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo);
        }
        if (currencyID != null && !"".equals(currencyID)) {
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
            mask.append(" AND (#").append(++maskNo);
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
            items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#").append(++maskNo).append(" AND #").append(++maskNo).append(") ");
            if (baseCurrencyid != null && currencyID.equalsIgnoreCase(baseCurrencyid)) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                mask.append(" OR #").append(++maskNo).append(" ");
            }
            mask.append(" )");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", filter.toString());
        map.put("accountTable", accountTableID);
        map.put("oppFilter", this.getOppAccountFilter(system != 13, companyid, accountTableID, currencyID).toString());
        return map;
    }

    private FilterInfo getOppAccountFilter(boolean isAr, String companyId, String accountTableId, String currencyID) throws BOSException, EASBizException {
        List accountIDs;
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID.id", (Object)companyId));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        mask.append(" #0 and #1 and #2 and #3 ");
        IArApBillFacade iArApBillFacade = ArApBillFacadeFactory.getLocalInstance((Context)this.ctx);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        Map accountMap = iArApBillFacade.getContrastAccount(isAr, company, accountTableId, currencyID);
        if (accountMap != null && (accountIDs = (List)accountMap.get("accountIDs")).size() > 0) {
            String strIdLists = StringUtils.arrayToString((Object[])accountIDs.toArray(), (String)",");
            items.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.NOTINCLUDE));
        }
        return filter;
    }

    public Map<String, Object> getIncomeConfirmContrastAccountF7(String companyid, int system, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int contrastAccountViewSystem = 1;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        items.add(new FilterItemInfo("ContrastAccountView.system", (Object)contrastAccountViewSystem));
        items.add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        items.add(new FilterItemInfo("companyOrgUnit.id", (Object)companyid, CompareType.EQUALS));
        PeriodInfo period = this.getCurrentPeriod(system, companyid);
        if (period != null) {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)period.getPeriodYear(), CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)period.getPeriodNumber(), CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)0, CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)0, CompareType.EQUALS));
        }
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2 AND #3 AND #4 AND #5");
        if ((accountTableID == null || accountTableID.length() < 2) && companyInfo.getAccountTable() != null) {
            accountTableID = companyInfo.getAccountTable().getId().toString();
        }
        if (baseCurrencyid == null && companyInfo.getBaseCurrency() != null) {
            baseCurrencyid = companyInfo.getBaseCurrency().getId().toString();
        }
        if (currentAccountTableID == null || currentAccountTableID.length() < 2) {
            currentAccountTableID = this.getCurrentAccountTableID(system, period, companyid, accountTableID);
        }
        int maskNo = items.size() - 1;
        if (currentAccountTableID != null && currentAccountTableID.length() > 0) {
            items.add(new FilterItemInfo("accountTableID.id", (Object)currentAccountTableID, CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo);
        }
        if (currencyID != null && !"".equals(currencyID)) {
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
            mask.append(" AND (#").append(++maskNo);
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
            items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#").append(++maskNo).append(" AND #").append(++maskNo).append(") ");
            if (baseCurrencyid != null && currencyID.equalsIgnoreCase(baseCurrencyid)) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                mask.append(" OR #").append(++maskNo).append(" ");
            }
            mask.append(" )");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", filter.toString());
        map.put("accountTable", accountTableID);
        return map;
    }

    public String batchGetContrastAccountFilter(String[] companyids, int systemInt, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        Map<String, Object> m = null;
        for (int i = 0; i < companyids.length; ++i) {
            m = this.getContrastAccountF7(companyids[i], systemInt, currencyID, currentAccountTableID, baseCurrencyid, accountTableID);
            if (i > 0) {
                filter.append(" or ");
            }
            filter.append("(").append(m.get("filter")).append(")");
        }
        return filter.toString();
    }

    public PeriodInfo getCurrentPeriod(int system, String companyid) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        return ictrol.getCacheCurrentPeriod(system, companyid);
    }

    public PeriodInfo getStartPeriod(int system, String companyid) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        return ictrol.getStartPeriod(system, companyid);
    }

    public PeriodInfo getEarliestStartPeriod(int system, String[] companyids) throws BOSException, EASBizException {
        String CR = "\r\n";
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 ").append("\r\n");
        sql.append(" sysStaCtr.FStartPeriodID AS FStartPeriodID").append("\r\n");
        sql.append(" from  ").append("\r\n");
        sql.append(" T_BD_SystemStatusCtrol sysStaCtr ").append("\r\n");
        sql.append(" inner join T_BD_SystemStatus sysSta ").append("\r\n");
        sql.append(" \ton sysStaCtr.FSystemStatusID=sysSta.FID ").append("\r\n");
        sql.append(" inner join T_BD_Period period ").append("\r\n");
        sql.append(" \ton sysStaCtr.FStartPeriodID=period.FID ").append("\r\n");
        sql.append(" where ").append("\r\n");
        sql.append(" sysStaCtr.FCompanyID in ('").append(CollectionUtil.join(companyids, "','")).append("')").append("\r\n");
        sql.append(" and sysSta.FName=").append(system).append("\r\n");
        sql.append(" order by period.fBeginDate asc").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String periodid = rs.getString("FStartPeriodID");
                if (periodid == null || periodid.length() <= 0) continue;
                IPeriod iperiod = PeriodFactory.getLocalInstance((Context)this.ctx);
                return iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodid));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public Date getBeforeSysDate(boolean isInitBill, int system, String companyid) throws BOSException, EASBizException {
        PeriodInfo period = isInitBill ? this.getStartPeriod(system, companyid) : this.getCurrentPeriod(system, companyid);
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(period.getBeginDate());
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    public String getCurrentAccountTableID(int system, PeriodInfo period, String companyid, String accountTableID) throws EASBizException, BOSException {
        if (period == null) {
            period = this.getCurrentPeriod(system, companyid);
        }
        if (period == null) {
            period = this.getStartPeriod(system, companyid);
        }
        String currentAccountTableID = null;
        if (period != null && accountTableID != null) {
            AccountRefContrastInfo info = AccountRefContrastFactory.getLocalInstance((Context)this.getContext()).getLastAcctInfo(companyid, accountTableID, period.getPeriodYear(), period.getPeriodNumber());
            currentAccountTableID = info == null ? null : info.getEnabledAcctTable().getId().toString();
        } else if (period != null && accountTableID != null) {
            return accountTableID;
        }
        return currentAccountTableID;
    }

    public Map<String, Object> getCostCenterUnit(String adminOrgUnitId, String companyOrgUnitId) throws EASBizException, BOSException {
        OrgUnitCollection costCenterCollectionByOrg;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
        OrgUnitCollection costCenterCollection = iUtilRel.getToUnit(adminOrgUnitId, 0, 5);
        if (costCenterCollection.size() > 0 && (costCenterCollectionByOrg = iUtilRel.getFromUnit(companyOrgUnitId, 1, 5)).contains(costCenterCollection.get(0))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("costCenterUnit", costCenterCollection.get(0));
            return result;
        }
        return null;
    }

    public Map<String, Object> getMultiUnitData(List<List> ids) throws BOSException, EASBizException {
        MaterialInfo[] materialInfos = new MaterialInfo[ids.size()];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[ids.size()];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[ids.size()];
        MeasureUnitInfo[] measureAssistUnitInfos = new MeasureUnitInfo[ids.size()];
        MaterialInfo materialInfo = null;
        MeasureUnitInfo measureUnitInfo = null;
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)ids.get(i).get(0).toString()));
            materialInfos[i] = materialInfo;
            measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(1).toString()));
            measureUnitInfos[i] = measureUnitInfo;
            if (ids.get(i).get(2) != null) {
                measureUnitInfo = new MeasureUnitInfo();
                measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(2).toString()));
                measureBaseUnitInfos[i] = measureUnitInfo;
            }
            if (ids.get(i).get(3) == null) continue;
            measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(3).toString()));
            measureAssistUnitInfos[i] = measureUnitInfo;
        }
        SCMEntryDataVO inputVO = new SCMEntryDataVO();
        inputVO.setIsLoadingMmuPrecision(true);
        inputVO.setMaterialInfos(materialInfos);
        inputVO.setMeasureUnitInfos(measureUnitInfos);
        inputVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        inputVO.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        SCMEntryDataVO resultVO = SCMGroupFacadeFactory.getLocalInstance((Context)this.getContext()).loadComplexData(inputVO);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("MmuConvsRate", resultVO.getMmuConvsRate());
        result.put("MmuPrecisions", resultVO.getMmuPrecisions());
        return result;
    }

    public static SelectorItemCollection getBillSelectors(Boolean isAR) {
        return isAR != false ? ArApSelectorFactory.getArOtherbillSelector(true) : ArApSelectorFactory.getApOtherbillSelector(true);
    }

    public static SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("company.cu.id"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("bizdate"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("isPriceWithoutTax"));
        sic.add(new SelectorItemInfo("isBizBill"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.rowType.id"));
        sic.add(new SelectorItemInfo("entry.rowType.number"));
        sic.add(new SelectorItemInfo("entry.rowType.name"));
        sic.add(new SelectorItemInfo("entry.rowType.precision"));
        sic.add(new SelectorItemInfo("entry.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("entry.rowType.projectType"));
        sic.add(new SelectorItemInfo("entry.rowType.destinationType"));
        sic.add(new SelectorItemInfo("entry.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistAttr.id"));
        sic.add(new SelectorItemInfo("entry.expenseItem.name"));
        sic.add(new SelectorItemInfo("entry.expenseItem.number"));
        sic.add(new SelectorItemInfo("entry.measureUnit.id"));
        sic.add(new SelectorItemInfo("entry.measureUnit.number"));
        sic.add(new SelectorItemInfo("entry.measureUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.account.id"));
        sic.add(new SelectorItemInfo("entry.account.number"));
        sic.add(new SelectorItemInfo("entry.account.name"));
        sic.add(new SelectorItemInfo("entry.oppAccount.id"));
        sic.add(new SelectorItemInfo("entry.oppAccount.number"));
        sic.add(new SelectorItemInfo("entry.oppAccount.name"));
        sic.add(new SelectorItemInfo("entry.coreBillType.id"));
        sic.add(new SelectorItemInfo("entry.coreBillType.number"));
        sic.add(new SelectorItemInfo("entry.coreBillType.name"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.id"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.number"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.name"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.id"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.number"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.name"));
        sic.add(new SelectorItemInfo("entry.recAsstActNumber"));
        sic.add(new SelectorItemInfo("entry.recAsstActName"));
        sic.add(new SelectorItemInfo("entry.ordCustNumber"));
        sic.add(new SelectorItemInfo("entry.ordCustName"));
        sic.add(new SelectorItemInfo("entry.serCustNumber"));
        sic.add(new SelectorItemInfo("entry.serCustName"));
        sic.add(new SelectorItemInfo("entry.materialName"));
        sic.add(new SelectorItemInfo("entry.sourceBillId"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entry.project.id"));
        sic.add(new SelectorItemInfo("entry.project.name"));
        sic.add(new SelectorItemInfo("entry.project.number"));
        sic.add(new SelectorItemInfo("entry.trackNumberzc.id"));
        sic.add(new SelectorItemInfo("entry.trackNumberzc.name"));
        sic.add(new SelectorItemInfo("entry.trackNumberzc.number"));
        return sic;
    }

    public String getProjectF7Filer(String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)this.getContext()).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)this.getContext()).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getTrackNumberF7Filer(String orgid, String projectid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)this.getContext()).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)this.getContext()).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (projectid != null && projectid.trim().length() > 0) {
            String sql = "select FTrackNumberID from T_MM_ProjectCar where FProjectID = '" + projectid + "'";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }
}

