/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataPager {
    private Context ctx;

    public DataPager(Context context) {
        this.ctx = context;
    }

    private Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getFirstPage(Map<String, Object> params) throws BOSException, EASBizException {
        String tempTableName;
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        String[] columnModel = (String[])params.get("columnModel");
        Map colDataType = (Map)params.get("colDataType");
        String createSQL = this.builderCreateSQL(columnModel, colDataType);
        try {
            tempTableName = pool.createTempTable(createSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String selectSQL = (String)params.get("selectSQL");
        StringBuffer insertSqlSB = new StringBuffer();
        insertSqlSB.append("insert into ").append(tempTableName).append(" (KSQL_SEQ");
        for (int i = 0; i < columnModel.length; ++i) {
            insertSqlSB.append(",").append(columnModel[i]);
        }
        insertSqlSB.append(") ");
        insertSqlSB.append(selectSQL);
        DbUtil.execute((Context)this.getContext(), (String)insertSqlSB.toString());
        int row_count = 0;
        String countSql = "select count(*) row_count from " + tempTableName;
        IRowSet rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)countSql);
        try {
            if (rs.next()) {
                row_count = rs.getInt("row_count");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        params.put("temptablename", tempTableName);
        params.put("pageNumber", 1);
        Map<String, Object> data = this.getPage(params);
        data.put("row_count", row_count);
        data.put("temptablename", tempTableName);
        return data;
    }

    private String builderCreateSQL(String[] columnModel, Map columnDataType) {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("create table otherpayed_tablename (").append("KSQL_SEQ INT IDENTITY (1, 1) NOT NULL,");
        for (int i = 0; i < columnModel.length; ++i) {
            createTableSQL.append(columnModel[i]).append(" ").append(columnDataType.get(columnModel[i])).append(" null");
            if (i >= columnModel.length - 1) continue;
            createTableSQL.append(",");
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    public Map<String, Object> getPage(Map<String, Object> params) throws BOSException, EASBizException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        int pageSize = (Integer)params.get("page_rows");
        int pageNumber = (Integer)params.get("pageNumber");
        String[] columnModel = (String[])params.get("columnModel");
        int start = pageSize * (pageNumber - 1);
        int end = pageSize * pageNumber - 1;
        String selectSql = "select * from " + params.get("temptablename") + " where KSQL_SEQ between " + start + " and " + end;
        IRowSet rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)selectSql);
        ArrayList records = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (String column : columnModel) {
                    Object value = rs.getObject(column);
                    row.put(column, value);
                }
                records.add(row);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        data.put("records", records);
        return data;
    }

    public void releasTemptable(String tableName) throws EASBizException, BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        pool.releaseTable(tableName);
    }
}

