/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.web.AbstractAppointmentVoucher;
import com.kingdee.eas.fi.arap.app.web.IAppointmentVoucher;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.IRecPayBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillCollection;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RecPayAppointmentVoucher
extends AbstractAppointmentVoucher
implements IAppointmentVoucher {
    protected String cashSaleflag = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
    protected String cashPurflag = "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5";
    private String autoResourcePath = "com.kingdee.eas.fi.arap.ARAPAutoGenerateResource";
    private String arapResourcePath = "com.kingdee.eas.fi.arap.ArapResource";
    private String billResourcePath = "com.kingdee.eas.fi.ar.ArApBillResource";

    public RecPayAppointmentVoucher(Context context) {
        this.ctx = context;
    }

    private Map getParamMap(String companyid) throws EASBizException, BOSException {
        String[] paramnumbers = new String[]{"AP_PAYVOUCHER_BILLTYPE_CASH", "AR_RECVOUCHER_BILLTYPE_CASH"};
        HashMap paramMap = ParamControlFactory.getLocalInstance((Context)this.getContext()).getParamHashMap(paramnumbers, companyid);
        return paramMap;
    }

    @Override
    public Map<String, Object> appointmentVoucher(String bosType, String companyid, String ids, int periodYear, int periodNumber, String voucherTypeid, String vouchernumber) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        VoucherInfo voucher = this.checkVoucher(companyid, periodYear, periodNumber, voucherTypeid, vouchernumber);
        if (voucher == null) {
            resultMap.put("state", "fail");
            resultMap.put("errMsg", EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"60_RecPaypointmentVoucherUI"));
            return resultMap;
        }
        PeriodInfo currentPeriod = this.getCurrentPeriod(this.getSysEnum(bosType).getValue(), companyid, bosType);
        boolean isBeforeCurrentPeriod = false;
        if (currentPeriod != null && currentPeriod.getPeriodYear() > periodYear) {
            isBeforeCurrentPeriod = true;
        } else if (currentPeriod.getPeriodYear() == periodYear && currentPeriod.getPeriodNumber() > periodNumber) {
            isBeforeCurrentPeriod = true;
        }
        if (isBeforeCurrentPeriod) {
            resultMap.put("state", "fail");
            resultMap.put("errMsg", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"canNotPointBeforeVoucher", (Locale)this.ctx.getLocale()));
            return resultMap;
        }
        boolean ispay = true;
        StringBuffer error = new StringBuffer();
        String[] billIDs = ids.split(",");
        ArrayList sucessbillids = new ArrayList();
        Map paramMap = this.getParamMap(companyid);
        String cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString();
        Set<String> set = this.requestLocks(this.getContext(), billIDs, resultMap);
        EntityViewInfo viewBill = new EntityViewInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        filterInfoBill.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewBill.setFilter(filterInfoBill);
        viewBill.getSelector().add(new SelectorItemInfo("*"));
        if (ispay) {
            viewBill.getSelector().add(new SelectorItemInfo("payBillType.isPurPay"));
            viewBill.getSelector().add(new SelectorItemInfo("paymentType.id"));
        }
        CoreBaseCollection coreBaseCols = this.getBizInterface(bosType).getCollection(viewBill);
        this.appointment(sucessbillids, coreBaseCols, voucher);
        ArrayList<String> lockList = new ArrayList<String>();
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            lockList.add((String)set.toArray()[i]);
        }
        this.releaseLocks(this.getContext(), lockList);
        resultMap.put("state", "success");
        resultMap.put("voucherId", voucher.getId().toString());
        return resultMap;
    }

    @Override
    protected PeriodInfo getCurrentPeriod(int system, String companyid, String bostype) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        return ictrol.getCacheCurrentPeriod(system, companyid);
    }

    private void appointment(List sucessbillids, CoreBaseCollection coreBaseCols, VoucherInfo voucher) throws EASBizException, BOSException {
        RecPayBillInfo recPayBillInfo = null;
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.getContext());
        boolean isRecOrPay = false;
        IObjectPK logPK = null;
        int size = coreBaseCols.size();
        for (int index = 0; index < size; ++index) {
            recPayBillInfo = (RecPayBillInfo)coreBaseCols.get(index);
            if (sucessbillids.contains(recPayBillInfo.getId().toString())) continue;
            logPK = LogUtil.beginLog((Context)this.getContext(), (String)ResourceBase.getString((String)this.autoResourcePath, (String)"58_RecPaypointmentVoucherUI", (Locale)this.getContext().getLocale()), (BOSObjectType)new PaymentBillInfo().getBOSType(), null, (String)(recPayBillInfo.getNumber() + ResourceBase.getString((String)this.autoResourcePath, (String)"58_RecPaypointmentVoucherUI", (Locale)this.getContext().getLocale())));
            if (recPayBillInfo.getSourceType().equals((Object)SourceTypeEnum.AR)) {
                isRecOrPay = true;
            }
            recPayBillInfo.setVoucher(voucher);
            recPayBillInfo.setVoucherNumber(voucher.getNumber());
            recPayBillInfo.setVoucherType(voucher.getVoucherType());
            recPayBillInfo.setIsAppointVoucher(true);
            recPayBillInfo.setFiVouchered(true);
            ids.add(recPayBillInfo.getId());
            this.delBotpRelation(recPayBillInfo.getId().toString());
            this.createBotpRelation(recPayBillInfo.getId().toString(), recPayBillInfo.getVoucher().getId().toString(), isRecOrPay);
            LogUtil.afterLog((Context)this.getContext(), (IObjectPK)logPK);
        }
        ReceivingBillFactory.getLocalInstance((Context)this.getContext()).batchAppointmentVoucher(ids, recPayBillInfo, isRecOrPay);
        if (coreBaseCols != null && coreBaseCols.size() > 0 && voucher.getSourceBillId() == null && SourceType.HANDCRAFT.equals((Object)voucher.getSourceType())) {
            ObjectUuidPK vorcherID = new ObjectUuidPK(voucher.getId());
            voucher.setSourceBillId(coreBaseCols.get(0).getId().toString());
            iVoucher.update((IObjectPK)vorcherID, (CoreBaseInfo)voucher);
        }
    }

    private void createBotpRelation(String srcObjectId, String destObjectId, boolean isRecOrPay) throws BOSException, UuidException, EASBizException {
        if (StringUtils.isEmpty((String)srcObjectId) || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        BOTRelationCollection botRelationCollection = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        botRelationCollection = iBOTRelation.getCollection(view);
        if (botRelationCollection != null && botRelationCollection.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            info.setBOTMappingID(rotpmap.getBOTMappingID());
            info.setType(0);
            iBOTRelation.addnew(info);
        } else {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            if (isRecOrPay) {
                BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)this.getContext()).getBOTMappingCollection(" select id where SrcEntityName='FA44FD5B' and DestEntityName='2652E01E'");
                if (botMappingColl != null && botMappingColl.size() > 0) {
                    info.setBOTMappingID(botMappingColl.get(0).getId().toString());
                }
            } else {
                BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)this.getContext()).getBOTMappingCollection(" select id where SrcEntityName='40284E81' and DestEntityName='2652E01E'");
                if (botMappingColl != null && botMappingColl.size() > 0) {
                    info.setBOTMappingID(botMappingColl.get(0).getId().toString());
                }
            }
            info.setType(0);
            iBOTRelation.addnew(info);
        }
    }

    public String verify(Map paramMap, RecPayBillInfo recPayBillInfo, String companyid, SystemEnum sysEnum, String billAlias) throws EASBizException, BOSException {
        boolean isCanCreateVoucher;
        String msg;
        PaymentTypeInfo billPaymentType;
        ReceivingBillInfo billInfo;
        String cashflag = null;
        StringBuffer error = new StringBuffer();
        boolean isPurPay = false;
        boolean isAr = false;
        if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
            isAr = true;
        }
        if (isAr) {
            billInfo = (ReceivingBillInfo)recPayBillInfo;
            billPaymentType = billInfo.getPaymentType();
        } else {
            billInfo = (PaymentBillInfo)recPayBillInfo;
            billPaymentType = billInfo.getPaymentType();
            isPurPay = billInfo.getPayBillType().isIsPurPay();
        }
        if (this.cashSaleflag.equals(billPaymentType.getId().toString()) && paramMap.containsKey("AR_RECVOUCHER_BILLTYPE_CASH") && (cashflag = paramMap.get("AR_RECVOUCHER_BILLTYPE_CASH").toString()).equals("0")) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), new CasForArApException(CasForArApException.CASH_APP_SUBJECT).getMessage());
            error.append(msg).append("<br>");
        }
        if (this.cashPurflag.equals(billPaymentType.getId().toString()) && paramMap.containsKey("AP_PAYVOUCHER_BILLTYPE_CASH") && (cashflag = paramMap.get("AP_PAYVOUCHER_BILLTYPE_CASH").toString()).equals("0")) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), new CasForArApException(CasForArApException.CASH_APP_SUBJECT).getMessage());
            error.append(msg).append("<br>");
        }
        if (!(isCanCreateVoucher = this.isPayBillCreateVoucher(companyid)) && isPurPay) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "verificationbill_notcash_cannot_creatvo"));
            error.append(msg).append("<br>");
        }
        if (isAr) {
            HashSet<String> recBillTypeIDSet = new HashSet<String>();
            if (recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
                int length = ((ReceivingBillInfo)recPayBillInfo).getEntries().size();
                for (int i = 0; i < length; ++i) {
                    if (((ReceivingBillInfo)recPayBillInfo).getEntries().get(i).getRecBillType() == null || this.cashSaleflag.equals(String.valueOf(((ReceivingBillInfo)recPayBillInfo).getPaymentType().getId()))) continue;
                    recBillTypeIDSet.add(((ReceivingBillInfo)recPayBillInfo).getEntries().get(i).getRecBillType().getId().toString());
                }
            }
            if (recBillTypeIDSet.size() > 0) {
                boolean flag = true;
                isCanCreateVoucher = CasForArApUtil.isRecBillCreateVoucher(null, (String)companyid);
                if (!isCanCreateVoucher) {
                    EntityViewInfo view = new EntityViewInfo();
                    view.getSelector().add(new SelectorItemInfo("isPreSet"));
                    view.getSelector().add(new SelectorItemInfo("isSaleRec"));
                    view.getSelector().add(new SelectorItemInfo("preSetBillType.isSaleRec"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", recBillTypeIDSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    ReceivingBillTypeCollection recBillTypeColl = ReceivingBillTypeFactory.getRemoteInstance().getReceivingBillTypeCollection(view);
                    ReceivingBillTypeInfo recBillTypeInfo = null;
                    boolean isSaleRec = true;
                    int size = recBillTypeColl.size();
                    for (int i = 0; i < size; ++i) {
                        recBillTypeInfo = recBillTypeColl.get(i);
                        if (recBillTypeInfo.isIsPreSet()) {
                            isSaleRec = recBillTypeInfo.isSaleRec();
                        } else if (recBillTypeInfo.getPreSetBillType() != null) {
                            isSaleRec = recBillTypeInfo.getPreSetBillType().isSaleRec();
                        }
                        if (isSaleRec) continue;
                        flag = false;
                        break;
                    }
                }
                if (flag && !isCanCreateVoucher) {
                    msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "RecVerificationbill_notcash_cannot_creatvo"));
                    error.append(msg).append("<br>");
                }
            }
        }
        return error.toString();
    }

    private String verifyStatus(String bosType, RecPayBillInfo recPayBillInfo, String companyid, SystemEnum sysEnum, String billAlias) throws EASBizException, BOSException {
        String msg;
        boolean ispay = true;
        StringBuffer error = new StringBuffer();
        if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
            ispay = false;
        }
        if (ispay) {
            if (this.getBooleanParamValue(companyid, "Pay_Vou_001")) {
                if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_payment_not"));
                    error.append(msg).append("<br>");
                }
            } else if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_unaudit_not"));
                error.append(msg).append("<br>");
            }
        } else if (this.getBooleanParamValue(companyid, "Rec_Vou_001")) {
            if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
                msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_receiving_not"));
                error.append(msg).append("<br>");
            }
        } else if (!recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && !recPayBillInfo.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_unaudit_not"));
            error.append(msg).append("<br>");
        }
        if (!ispay && ((ReceivingBillInfo)recPayBillInfo).getPayerID() == null) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_AsstNullNoVoucher"));
            error.append(msg).append("<br>");
        }
        int system = sysEnum.getValue();
        if (recPayBillInfo.getBizDate().before(this.getCurrentPeriod(system, companyid, "").getBeginDate())) {
            msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_initbill_not"));
            error.append(msg).append("<br>");
        }
        return error.toString();
    }

    private String verivyVoucher(String bosType, RecPayBillInfo recPayBillInfo, SystemEnum sysEnum, String billAlias) throws EASBizException, BOSException {
        String msg = null;
        StringBuffer error = new StringBuffer();
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        BOTRelationCollection botRelationCollection = null;
        if (!recPayBillInfo.isIsAppointVoucher()) {
            iBotRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)sysEnum)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new PaymentBillInfo().getBOSType().toString(), CompareType.EQUALS));
            } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new ReceivingBillInfo().getBOSType().toString(), CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)recPayBillInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            botRelationCollection = iBotRelation.getCollection(view);
            if (botRelationCollection.size() > 0) {
                msg = this.verifyMsg(billAlias, recPayBillInfo.getNumber(), this.getReResource(this.billResourcePath, "point_voucher_created_not"));
                error.append(msg).append("<br>");
            }
        }
        return error.toString();
    }

    public boolean getBooleanParamValue(String sCompanyId, String paramNumber) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        value = ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)pk, (String)paramNumber);
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public boolean isPayBillCreateVoucher(String sCompanyId) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        checkType = Integer.parseInt(ParamManager.getParamValue((Context)this.getContext(), (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE"));
        return checkType != 0;
    }

    protected IRecPayBill getBizInterface(String bostype) throws EASBizException, BOSException {
        if (this.getSysEnum(bostype).equals((Object)SystemEnum.ACCOUNTSPAYABLE)) {
            return PaymentBillFactory.getLocalInstance((Context)this.getContext());
        }
        return ReceivingBillFactory.getLocalInstance((Context)this.getContext());
    }

    private String getReResource(String path, String str) throws EASBizException, BOSException {
        return ResourceBase.getString((String)path, (String)str, (Locale)this.getContext().getLocale());
    }

    public String getBOSEntityAlias(String bostype) throws EASBizException, BOSException {
        EntityObjectInfo info = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(BOSObjectType.create((String)bostype));
        return info.getAlias();
    }

    @Override
    public Map<String, Object> verifyBefore(String bosType, String companyid, String ids) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer error = new StringBuffer();
        SystemEnum systemEnum = this.getSysEnum(bosType);
        String billAlias = this.getBillAlias(bosType);
        boolean isRelatedAccount = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext()).isRelatedAccount(companyid, systemEnum);
        if (!isRelatedAccount) {
            error.append(ResourceBase.getString((String)this.billResourcePath, (String)"isNotRelateGL", (Locale)this.getContext().getLocale(), (Object[])new Object[]{systemEnum.getAlias()}));
            resultMap.put("state", "notRelateGL");
            resultMap.put("errMsg", error);
            return resultMap;
        }
        String[] billIDs = ids.split(",");
        Map paramMap = this.getParamMap(companyid);
        HashSet<String> set = new HashSet<String>();
        int size = billIDs.length;
        for (int i = 0; i < size; ++i) {
            set.add(billIDs[i]);
        }
        EntityViewInfo viewBill = new EntityViewInfo();
        FilterInfo filterInfoBill = new FilterInfo();
        filterInfoBill.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewBill.setFilter(filterInfoBill);
        viewBill.getSelector().add(new SelectorItemInfo("*"));
        if (SystemEnum.ACCOUNTSPAYABLE == systemEnum) {
            viewBill.getSelector().add(new SelectorItemInfo("payBillType.isPurPay"));
            viewBill.getSelector().add(new SelectorItemInfo("paymentType.id"));
        } else {
            viewBill.getSelector().add("entries.*");
        }
        RecPayBillCollection coreBaseCols = this.getBizInterface(bosType).getRecPayBillCollection(viewBill);
        error = new StringBuffer();
        int size2 = coreBaseCols.size();
        for (int i = 0; i < size2; ++i) {
            RecPayBillInfo recPayBillInfo = coreBaseCols.get(i);
            error.append(this.verify(paramMap, recPayBillInfo, companyid, systemEnum, billAlias));
            error.append(this.verifyStatus(bosType, recPayBillInfo, companyid, systemEnum, billAlias));
            error.append(this.verivyVoucher(bosType, recPayBillInfo, systemEnum, billAlias));
        }
        if (error.length() > 0) {
            resultMap.put("state", "unpass");
            resultMap.put("errMsg", error.toString());
        } else {
            resultMap.put("state", "pass");
        }
        return resultMap;
    }

    protected Set<String> requestLocks(Context ctx, String[] ids, Map<String, Object> result) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            idList.add(ids[i]);
        }
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(idList);
        HashSet<String> lockedList = new HashSet<String>();
        if (lockMap != null) {
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockedList.add(id);
                    continue;
                }
                result.put(id, EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)"ApplyMutualErrorSomeOneOperatoring"));
            }
        }
        return lockedList;
    }

    protected void releaseLocks(Context ctx, List<String> lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }
}

