/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.IWriteBackHandler;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractWriteBackHandler
implements IWriteBackHandler {
    public final String CR = "\r\n";
    public final String LOG_PROFIX = "************";
    protected final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArApRecPayCommonResource";
    protected Locale locale = LocaleUtils.locale_l2;

    @Override
    public void handle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue billInfo) throws EASBizException, BOSException {
        try {
            this.init(ctx);
            this.doHandle(ctx, bizAction, bizScene, billInfo);
        }
        catch (SQLException e) {
            throw new BOSException("AbstractWriteBackHandler.handle.SQLException", (Throwable)e);
        }
    }

    public void init(Context ctx) throws EASBizException, BOSException {
        this.locale = ctx.getLocale();
    }

    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
    }

    protected void addSqlLock(Context ctx, IObjectValue destBillInfo, String lockField, String lockBosType) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)lockBosType) || StringUtils.isEmpty((String)lockField) || destBillInfo == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        boolean bosTypeIsMatch = false;
        String id = null;
        AbstractObjectCollection entryColl = (AbstractObjectCollection)destBillInfo.get(this.getEntryFieldStr());
        IObjectValue entry = null;
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                entry = entryColl.getObject(i);
                id = entry.getString(lockField);
                if (StringUtils.isEmpty((String)id)) continue;
                if (!bosTypeIsMatch) {
                    if (!lockBosType.equals(BOSUuid.read((String)id).getType().toString())) {
                        return;
                    }
                    bosTypeIsMatch = true;
                }
                idSet.add(id);
            }
            if (idSet.size() > 0) {
                ArApServerUtils.addSQLLock(ctx, idSet);
            }
        }
    }

    protected void addSqlLockForSourceBill(Context ctx, IObjectValue destBillInfo, String lockBosType) throws EASBizException, BOSException {
        this.addSqlLock(ctx, destBillInfo, this.getSourceBillId(), lockBosType);
    }

    protected void addSqlLockForSourceBillEntry(Context ctx, IObjectValue destBillInfo, String lockBosType) throws EASBizException, BOSException {
        this.addSqlLock(ctx, destBillInfo, this.getSourceBillEntryId(), lockBosType);
    }

    protected void addSqlLockForCoreBill(Context ctx, IObjectValue destBillInfo, String lockBosType) throws EASBizException, BOSException {
        this.addSqlLock(ctx, destBillInfo, this.getCoreBillId(), lockBosType);
    }

    protected void addSqlLockForCoreBillEntry(Context ctx, IObjectValue destBillInfo, String lockBosType) throws EASBizException, BOSException {
        this.addSqlLock(ctx, destBillInfo, this.getCoreBillEntryId(), lockBosType);
    }

    protected String getEntryFieldStr() {
        return "entrys";
    }

    protected String getSourceBillId() {
        return "FSourceBillId";
    }

    protected String getSourceBillEntryId() {
        return "sourceBillEntryid";
    }

    protected String getCoreBillId() {
        return "coreBillId";
    }

    protected String getCoreBillEntryId() {
        return "coreBillEntryId";
    }

    protected void recordLog(Logger logger, Level level, String sql, Object params, String recordKey) {
        StringBuilder logBuilder = new StringBuilder(500);
        logBuilder.append("************").append(recordKey).append(" #begin# ").append("************").append("\r\n");
        logBuilder.append("************").append("SQL is :").append("\r\n");
        logBuilder.append(sql);
        logBuilder.append("************").append("PARAMS is :").append("\r\n");
        logBuilder.append(params);
        logBuilder.append("************").append(recordKey).append(" #end# ").append("************").append("\r\n");
        logger.log((Priority)level, (Object)logBuilder);
    }

    protected String getResource(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArApRecPayCommonResource", (String)key, (Locale)this.locale);
    }

    protected boolean getCheckParamValue(Context ctx, IObjectValue recPayBillInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)recPayBillInfo.getObjectValue("company");
        ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getId());
        String param = "false";
        if (recPayBillInfo instanceof ReceivingBillInfo) {
            param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AR_PreRecOverOrder");
        } else if (recPayBillInfo instanceof PaymentBillInfo) {
            param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "ORDERPAYMENT");
        }
        boolean value = true;
        if (param != null && param.length() != 0) {
            value = Boolean.valueOf(param);
        }
        return value;
    }
}

