/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.app.writeback.handler.IWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.AR2ICWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.DefaultWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.PAY2PCWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2APWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2PCWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2POWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4PayRequestBillHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4PurContractHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4PurOrderHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4SaleContractHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4SaleOrderHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4SubContractOrderHandler;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class WriteBackFactory {
    private static WriteBackFactory instance = new WriteBackFactory();
    private Map<String, IWriteBackHandler> handlerMap = new HashMap<String, IWriteBackHandler>();
    private final String SPLIT = "_";

    private WriteBackFactory() {
    }

    public static IWriteBackHandler getRefundWriteBackHandler(BOSObjectType type) {
        if (ArApConstants.PAYREQUEST_TYPE.equals((Object)type)) {
            return new Refund4PayRequestBillHandler();
        }
        if (ArApConstants.PURORDER_TYPE.equals((Object)type)) {
            return new Refund4PurOrderHandler();
        }
        if (ArApConstants.SUBCONTRACT_TYPE.equals((Object)type)) {
            return new Refund4SubContractOrderHandler();
        }
        if (ArApConstants.SALEORDER_TYPE.equals((Object)type)) {
            return new Refund4SaleOrderHandler();
        }
        if (ArApConstants.SALECONTRACT_TYPE.equals((Object)type)) {
            return new Refund4SaleContractHandler();
        }
        if (ArApConstants.PURCONTRACT_TYPE.equals((Object)type)) {
            return new Refund4PurContractHandler();
        }
        return null;
    }

    public void registerHandler() {
        this.handlerMap.put("78B50853_D001019A", new PR2PCWriteBackHandler());
        this.handlerMap.put("3171BFAD_D001019A", new PR2POWriteBackHandler());
        this.handlerMap.put("48DA3A71_D001019A", new PR2APWriteBackHandler());
        this.handlerMap.put("78B50853_40284E81", new PAY2PCWriteBackHandler());
        this.handlerMap.put("A8378ABC_FC910EF3", new AR2ICWriteBackHandler());
    }

    public IWriteBackHandler getWriteBackHandler(BOSObjectType srcBosType, BOSObjectType destBosType) {
        if (srcBosType == null || destBosType == null) {
            return DefaultWriteBackHandler.defaultHandler;
        }
        return this.getWriteBackHandler(srcBosType.toString(), destBosType.toString());
    }

    public IWriteBackHandler getWriteBackHandler(String srcBosType, String destBosType) {
        if (this.handlerMap.size() == 0) {
            this.registerHandler();
        }
        if (StringUtils.isEmpty((String)srcBosType) || StringUtils.isEmpty((String)destBosType)) {
            return DefaultWriteBackHandler.defaultHandler;
        }
        IWriteBackHandler handler = this.handlerMap.get(srcBosType + "_" + destBosType);
        if (handler == null) {
            handler = DefaultWriteBackHandler.defaultHandler;
        }
        return handler;
    }

    public static WriteBackFactory getInstance() {
        return instance;
    }
}

