/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PR2PCWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2PCWriteBackHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo && !(destBillInfo instanceof PayRequestBillInfo)) {
            return;
        }
        PayRequestBillInfo info = (PayRequestBillInfo)destBillInfo;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<String> contractEntryIds = new HashSet<String>();
        this.getWriteBackParam(ctx, info, bizAction, paramList, contractEntryIds, true);
        if (paramList.size() > 0) {
            bizScene = BizSceneEnum.RECPAY_SCENE;
        } else {
            this.addSqlLockForSourceBillEntry(ctx, destBillInfo, "E8D24BDF");
            this.getWriteBackParam(ctx, info, bizAction, paramList, contractEntryIds, false);
            bizScene = BizSceneEnum.PRE_RECPAY_SCENE;
        }
        if (paramList.size() == 0) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList, bizScene);
        boolean allowed = false;
        allowed = BizSceneEnum.PRE_RECPAY_SCENE == bizScene ? this.getCheckParamValue(ctx, destBillInfo) : true;
        if (!allowed) {
            this.doCheck(ctx, contractEntryIds, bizScene);
        }
    }

    protected void getWriteBackParam(Context ctx, PayRequestBillInfo info, BizActionEnum bizAction, List<Object[]> paramList, Set<String> contractEntryIds, boolean isIncludeAp) throws BOSException, SQLException, EASBizException {
        boolean isCloseOrUnClose = BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction);
        HashSet<String> entryIdSet = new HashSet<String>();
        if (isCloseOrUnClose) {
            PayRequestBillEntryCollection coll = info.getEntrys();
            for (int i = 0; i < coll.size(); ++i) {
                entryIdSet.add(coll.get(i).getId().toString());
            }
        }
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT purConEntry.FID AS CONTRACTENTRYID").append("\r\n");
        if (isCloseOrUnClose) {
            selectBuilder.append(" \t,sum(payReqEntry.FAuditAmount - FTotalPayAmt) as AMOUNT").append("\r\n");
        } else {
            selectBuilder.append(" \t,sum(payReqEntry.FAuditAmount) as AMOUNT").append("\r\n");
        }
        selectBuilder.append(" FROM T_AP_PayRequestBillEntry payReqEntry").append("\r\n");
        if (isIncludeAp) {
            selectBuilder.append(" INNER JOIN T_AP_OtherbillEntry otherEntry").append("\r\n");
            selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = payReqEntry.fid").append("\r\n");
            selectBuilder.append(" INNER JOIN T_SM_PurContractEntry purConEntry").append("\r\n");
            selectBuilder.append(" ON otherEntry.FSOURCEBILLENTRYID = purConEntry.FID").append("\r\n");
        } else {
            selectBuilder.append(" INNER JOIN T_SM_PurContractEntry purConEntry").append("\r\n");
            selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = purConEntry.FID").append("\r\n");
        }
        if (isCloseOrUnClose) {
            selectBuilder.append(" WHERE payReqEntry.Fid in (").append(ArApBillHelper.ids2SqlString(entryIdSet)).append(") ").append("\r\n");
        } else {
            selectBuilder.append(" WHERE payReqEntry.FParentID = '").append(info.getId().toString()).append("'").append("\r\n");
        }
        selectBuilder.append(" GROUP BY purConEntry.FID").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurContractEntryFTotalPreAmt1.selectSql";
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), null, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString());
        selectBuilder.setLength(0);
        String contractEntryId = "";
        if (isIncludeAp) {
            while (rowSet.next()) {
                contractEntryId = rowSet.getString("CONTRACTENTRYID");
                contractEntryIds.add(contractEntryId);
            }
            if (contractEntryIds.size() > 0) {
                ArApServerUtils.addSQLLock(ctx, contractEntryIds);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString());
            }
        }
        BigDecimal thisAmt = BigDecimal.ZERO;
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT");
            contractEntryId = rowSet.getString("CONTRACTENTRYID");
            if (isIncludeAp) {
                paramList.add(new Object[]{thisAmt, contractEntryId});
            } else {
                paramList.add(new Object[]{thisAmt, thisAmt, contractEntryId});
            }
            contractEntryIds.add(contractEntryId);
            srcAmtMap.put(contractEntryId, thisAmt);
        }
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList, BizSceneEnum bizScene) throws BOSException {
        String payAmtSymbol = BizActionEnum.AUDIT.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append(" UPDATE T_SM_PurContractEntry SET ").append("\r\n");
        updateBuilder.append("FTotalReqPayAmt = isnull(FTotalReqPayAmt,0) ").append(payAmtSymbol).append(" ? ").append("\r\n");
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            updateBuilder.append(",FTotalPreAmt = isnull(FTotalPreAmt,0) ").append(payAmtSymbol).append(" ? ").append("\r\n");
        }
        updateBuilder.append(" WHERE FID = ?");
        String recordKey = this.getClass() + ".writeBackPurContractEntryFTotalReqPayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void doCheck(Context ctx, Set<String> contractEntryIds, BizSceneEnum bizScene) throws BOSException, SQLException, ArApCommonException {
        String contractEntryIdStr = ListUtil.transList2String(contractEntryIds);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT DISTINCT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_SM_PurContractEntry ENTRY").append("\r\n");
        checkBuilder.append(" INNER JOIN T_SM_PurContract BILL").append("\r\n");
        checkBuilder.append(" ON ENTRY.FParentID = BILL.fid").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN ").append(contractEntryIdStr).append("\r\n");
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            checkBuilder.append(" AND ENTRY.FTotalPreAmt > Entry.FPrepayment").append("\r\n");
        }
        String recordKey = this.getClass() + ".writeBackPurContractEntryPrePayAmt.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), contractEntryIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        String billType = this.getResource("PUR_CONTRACT_BILL");
        String fieldName = this.getResource("PREPAY_TOTAL_AMT");
        if (exceptionNum.length() > 0) {
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }

    @Override
    protected boolean getCheckParamValue(Context ctx, IObjectValue billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)billInfo.getObjectValue("company");
        boolean allowed = ArApParamHelper.isPrePayAmtCanOverPurContractAmt(ctx, companyInfo.getId().toString());
        return allowed;
    }
}

