/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PR2POWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2POWriteBackHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo && !(destBillInfo instanceof PayRequestBillInfo)) {
            return;
        }
        PayRequestBillInfo info = (PayRequestBillInfo)destBillInfo;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<String> orderEntryIds = new HashSet<String>();
        this.addSqlLockForCoreBillEntry(ctx, destBillInfo, "26041CC5");
        this.getWriteBackParam(ctx, info, bizAction, paramList, orderEntryIds, true);
        if (paramList.size() > 0) {
            bizScene = BizSceneEnum.RECPAY_SCENE;
        } else {
            this.getWriteBackParam(ctx, info, bizAction, paramList, orderEntryIds, false);
            bizScene = BizSceneEnum.PRE_RECPAY_SCENE;
        }
        if (paramList.size() == 0) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList, bizScene);
        boolean allowed = false;
        allowed = BizSceneEnum.PRE_RECPAY_SCENE == bizScene ? this.getCheckParamValue(ctx, (IObjectValue)info) : true;
        if (!allowed) {
            this.doCheck(ctx, orderEntryIds, bizScene);
        }
    }

    protected void getWriteBackParam(Context ctx, PayRequestBillInfo info, BizActionEnum bizAction, List<Object[]> paramList, Set<String> orderEntryIds, boolean isIncludeAp) throws BOSException, SQLException, EASBizException {
        boolean isCloseOrUnClose = BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction);
        HashSet<String> entryIdSet = new HashSet<String>();
        if (isCloseOrUnClose) {
            PayRequestBillEntryCollection coll = info.getEntrys();
            for (int i = 0; i < coll.size(); ++i) {
                entryIdSet.add(coll.get(i).getId().toString());
            }
        }
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT purOrdEntry.FID AS ORDERENTRYID").append("\r\n");
        if (isCloseOrUnClose) {
            selectBuilder.append(" \t,sum(payReqEntry.FAuditAmount - payReqEntry.FTotalPayAmt) as AMOUNT").append("\r\n");
        } else {
            selectBuilder.append(" \t,sum(payReqEntry.FAuditAmount) as AMOUNT").append("\r\n");
        }
        selectBuilder.append(" FROM T_AP_PayRequestBillEntry payReqEntry").append("\r\n");
        if (isIncludeAp) {
            selectBuilder.append(" INNER JOIN T_AP_PayRequestBill payReq").append("\r\n");
            selectBuilder.append(" ON payReqEntry.FPARENTID = payReq.fid").append("\r\n");
            selectBuilder.append(" INNER JOIN T_AP_OtherbillEntry otherEntry").append("\r\n");
            selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = otherEntry.fid").append("\r\n");
            selectBuilder.append(" INNER JOIN T_SM_PurOrderEntry purOrdEntry").append("\r\n");
            selectBuilder.append(" ON otherEntry.FCoreBillEntryId = purOrdEntry.FID").append("\r\n");
            selectBuilder.append(" INNER JOIN T_SM_PurOrder purOrd").append("\r\n");
            selectBuilder.append(" ON purOrdEntry.FPARENTID = purOrd.FID").append("\r\n");
            selectBuilder.append(" where 1 = 1").append("\r\n");
            selectBuilder.append(" and ((purOrd.FIsCentralBalance = 1 and payReq.FCompanyId = purOrd.FCompanyOrgUnitID) or (purOrd.FIsCentralBalance = 0 and payReq.FCompanyId = purOrdEntry.FCompanyOrgUnitID))");
        } else {
            selectBuilder.append(" INNER JOIN T_SM_PurOrderEntry purOrdEntry").append("\r\n");
            selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = purOrdEntry.FID").append("\r\n");
            selectBuilder.append(" where 1 = 1");
        }
        if (isCloseOrUnClose) {
            selectBuilder.append(" and payReqEntry.Fid in (").append(ArApBillHelper.ids2SqlString(entryIdSet)).append(") ").append("\r\n");
        } else {
            selectBuilder.append(" and payReqEntry.FParentID = '").append(info.getId().toString()).append("'").append("\r\n");
        }
        selectBuilder.append(" GROUP BY purOrdEntry.FID").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurOrderEntryFTotalPreAmt1.selectSql";
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), null, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString());
        BigDecimal thisAmt = BigDecimal.ZERO;
        String orderEntryId = "";
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT");
            orderEntryId = rowSet.getString("ORDERENTRYID");
            if (isIncludeAp) {
                paramList.add(new Object[]{thisAmt, orderEntryId});
            } else {
                paramList.add(new Object[]{thisAmt, thisAmt, orderEntryId});
            }
            orderEntryIds.add(orderEntryId);
            srcAmtMap.put(orderEntryId, thisAmt);
        }
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList, BizSceneEnum bizScene) throws BOSException {
        String payAmtSymbol = BizActionEnum.AUDIT.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append(" UPDATE T_SM_PurOrderEntry SET ").append("\r\n");
        updateBuilder.append("FTotalReqPayAmt = isnull(FTotalReqPayAmt,0) ").append(payAmtSymbol).append(" ? ").append("\r\n");
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            updateBuilder.append(",FTotalPrePayAmt = isnull(FTotalPrePayAmt,0) ").append(payAmtSymbol).append(" ? ").append("\r\n");
        }
        updateBuilder.append(" WHERE FID = ?");
        String recordKey = this.getClass() + ".writeBackPurOrderEntryFTotalReqPayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void doCheck(Context ctx, Set<String> orderEntryIds, BizSceneEnum bizScene) throws BOSException, SQLException, ArApCommonException {
        String orderEntryIdStr = ListUtil.transList2String(orderEntryIds);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT DISTINCT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_SM_PurOrderEntry ENTRY").append("\r\n");
        checkBuilder.append(" INNER JOIN T_SM_PurOrder BILL").append("\r\n");
        checkBuilder.append(" ON ENTRY.FParentID = BILL.fid").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN ").append(orderEntryIdStr).append("\r\n");
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            checkBuilder.append(" AND ENTRY.FTotalPrePayAmt > Entry.FPrepayment").append("\r\n");
        }
        String recordKey = this.getClass() + ".writeBackPurOrderEntryPrePayAmt.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), orderEntryIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        if (exceptionNum.length() > 0) {
            String billType = this.getResource("PUR_ORDER_BILL");
            String fieldName = this.getResource("PREPAY_TOTAL_AMT");
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }

    @Override
    protected boolean getCheckParamValue(Context ctx, IObjectValue billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)billInfo.getObjectValue("company");
        boolean allowed = ArApParamHelper.isPrePayAmoutCanOverOrderPrepayAmt(ctx, companyInfo.getId().toString());
        return allowed;
    }
}

