/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.WriteBackFieldEnum;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApCommonUtil;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Refund4PayRequestBillHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4PayRequestBillHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo) {
            return;
        }
        Set<String> notNeedLockIds = this.getNotNeedLockIds(ctx, bizAction, destBillInfo);
        int size = ((PaymentBillEntryCollection)destBillInfo.get("entries")).size();
        if (notNeedLockIds.size() != size) {
            this.writeBackBillLockAmt(ctx, bizAction, destBillInfo, notNeedLockIds);
        }
        this.writeBackBillPayAmt(ctx, bizAction, destBillInfo);
    }

    private Set<String> getNotNeedLockIds(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        HashSet<String> notNeedLockIds = new HashSet<String>();
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT redEntry.FID as redEntryId").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY redEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY blueEntry ON redEntry.FSOURCEBILLENTRYID = blueEntry.FID").append("\r\n");
        selectBuilder.append(" INNER JOIN T_AP_PAYREQUESTBILLENTRY reqEntry ON blueEntry.FSOURCEBILLENTRYID = reqEntry.FID").append("\r\n");
        selectBuilder.append(" INNER JOIN T_AP_OTHERBILLENTRY apEntry ON reqEntry.FSOURCEBILLENTRYID = apEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE redEntry.FPAYMENTBILLID = ?").append("\r\n");
        String keySuffix = ".isContainsAp.selectSql";
        String recordKey = this.getClass() + keySuffix;
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        while (rowSet.next()) {
            notNeedLockIds.add(rowSet.getString("redEntryId"));
        }
        return notNeedLockIds;
    }

    private void writeBackBillPayAmt(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder srcIds = this.getWriteBackParam(ctx, bizAction, destBillInfo, paramList, WriteBackFieldEnum.PAY_AMT, null);
        if (0 == paramList.size()) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList, WriteBackFieldEnum.PAY_AMT);
        this.doWriteBackSumEntry(ctx, srcIds);
        this.autoClose(ctx, srcIds, bizAction);
        this.doCheck(ctx, srcIds, WriteBackFieldEnum.PAY_AMT);
    }

    protected void autoClose(Context ctx, StringBuilder srcIds, BizActionEnum bizAction) throws BOSException, EASBizException {
        String srcIdStr = srcIds.substring(0, srcIds.length() - 1);
        StringBuilder sql = new StringBuilder(300);
        sql.append(" SELECT FID FROM T_AP_PAYREQUESTBILLENTRY ENTRY");
        sql.append(" WHERE ENTRY.FID IN ( ").append(srcIdStr).append(")").append("\r\n");
        sql.append(" AND ENTRY.FIsManualClose = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                throw new PayRequestBillBizException(PayRequestBillBizException.PAY_HASCLOSE_UNCLOASE_FIRST);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        int entryStatus = BizActionEnum.PAY.equals((Object)bizAction) ? 3 : -2;
        sql.append(" UPDATE T_AP_PAYREQUESTBILLENTRY ENTRY SET FENTRYSTATUS = ").append(entryStatus).append("\r\n");
        sql.append(" WHERE ENTRY.FID IN ( ").append(srcIdStr).append(")").append("\r\n");
        sql.append(" AND  ENTRY.FTOTALPAYAMT ").append(BizActionEnum.PAY.equals((Object)bizAction) ? "<>" : "=").append(" ENTRY.FAUDITAMOUNT ").append("\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        PayRequestBillFactory.getLocalInstance(ctx).updateBillStatus(srcIdStr, !BizActionEnum.PAY.equals((Object)bizAction));
    }

    protected void doWriteBackSumEntry(Context ctx, StringBuilder srcIds) throws SQLException, BOSException, EASBizException {
        String srcIdStr = srcIds.substring(0, srcIds.length() - 1);
        StringBuilder sql = new StringBuilder(300);
        sql.append(" SELECT BILL.FID AS FID FROM T_AP_PAYREQUESTBILL BILL ").append("\r\n");
        sql.append(" INNER JOIN T_AP_PAYREQUESTBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID").append("\r\n");
        sql.append(" WHERE ENTRY.FID IN (").append(srcIdStr).append(")").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("FID"));
        }
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        if (idSet.size() > 0) {
            ArApBillReverseHelper.writeBackSumEntry(iPayRequestBill, iPayRequestSumEntry, idSet);
        }
    }

    private void writeBackBillLockAmt(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo, Set<String> notNeedLockIds) throws EASBizException, BOSException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder srcIds = this.getWriteBackParam(ctx, bizAction, destBillInfo, paramList, WriteBackFieldEnum.LOCK_AMT, notNeedLockIds);
        if (0 == paramList.size()) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList, WriteBackFieldEnum.LOCK_AMT);
        this.doCheck(ctx, srcIds, WriteBackFieldEnum.LOCK_AMT);
    }

    protected StringBuilder getWriteBackParam(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo, List<Object[]> paramList, WriteBackFieldEnum fieldEnum, Set<String> notNeedLockIds) throws BOSException, SQLException, EASBizException {
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT blueEntry.FSOURCEBILLENTRYID as SRCID").append("\r\n");
        selectBuilder.append(" \t,redEntry.FAMOUNT as AMOUNT").append("\r\n");
        selectBuilder.append(" \t,redEntry.FLOCALAMOUNT as AMOUNTLOC").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY redEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY blueEntry").append("\r\n");
        selectBuilder.append(" ON redEntry.FSOURCEBILLENTRYID = blueEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE redEntry.FPAYMENTBILLID = ?").append("\r\n");
        if (null != notNeedLockIds && notNeedLockIds.size() > 0) {
            String notNeedLockIdStr = ArApCommonUtil.transArr2SqlIdStr(notNeedLockIds);
            selectBuilder.append(" and redEntry.FID not in(").append(notNeedLockIdStr).append(")").append("\r\n");
        }
        String keySuffix = fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT) ? ".writeBackBillLockAmt.selectSql" : ".writeBackBillPayAmt.selectSql";
        String recordKey = this.getClass() + keySuffix;
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        BigDecimal thisAmt = BigDecimal.ZERO;
        String srcId = "";
        StringBuilder srcIds = new StringBuilder(200);
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT").negate();
            srcId = rowSet.getString("SRCID");
            paramList.add(new Object[]{thisAmt, thisAmt, srcId});
            srcIds.append("'").append(srcId).append("'").append(",");
            srcAmtMap.put(srcId, thisAmt);
        }
        if (fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT)) {
            paramList.clear();
            Map<String, BigDecimal> srcLocAmtMap = this.getLocalAmt(ctx, srcAmtMap, bizAction);
            String entryId = null;
            BigDecimal thisAmtLoc = BigDecimal.ZERO;
            for (Map.Entry entry : srcAmtMap.entrySet()) {
                entryId = (String)entry.getKey();
                thisAmt = (BigDecimal)entry.getValue();
                thisAmtLoc = srcLocAmtMap.get(entryId);
                if (null == thisAmtLoc) continue;
                paramList.add(new Object[]{thisAmt, thisAmtLoc, thisAmt, thisAmtLoc, entryId});
            }
        }
        return srcIds;
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList, WriteBackFieldEnum fieldEnum) throws BOSException {
        String payAmtSymbol = BizActionEnum.PAY.equals((Object)bizAction) ? "-" : "+";
        String unPayAmtSymbol = BizActionEnum.PAY.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append("UPDATE T_AP_PAYREQUESTBILLENTRY").append("\r\n");
        if (fieldEnum.equals((Object)WriteBackFieldEnum.PAY_AMT)) {
            updateBuilder.append(" SET FUNPAYAMOUNT = FUNPAYAMOUNT ").append(unPayAmtSymbol).append(" ?").append("\r\n");
            updateBuilder.append("\t,FTOTALPAYAMT = FTOTALPAYAMT ").append(payAmtSymbol).append(" ?").append("\r\n");
        } else if (fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT)) {
            updateBuilder.append(" SET FLOCKAMOUNT = FLOCKAMOUNT ").append(payAmtSymbol).append("? ,").append("\r\n");
            updateBuilder.append("     FLOCKAMOUNTLOC = FLOCKAMOUNTLOC ").append(payAmtSymbol).append("? ,").append("\r\n");
            updateBuilder.append("     FUNLOCKAMOUNT = FUNLOCKAMOUNT ").append(unPayAmtSymbol).append("? ,").append("\r\n");
            updateBuilder.append("     FUNLOCKAMOUNTLOC = FUNLOCKAMOUNTLOC ").append(unPayAmtSymbol).append("?").append("\r\n");
        }
        updateBuilder.append(" WHERE FID = ?").append("\r\n");
        String keySuffix = fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT) ? ".writeBackBillLockAmt.updateSql" : ".writeBackBillPayAmt.updateSql";
        String recordKey = this.getClass() + keySuffix;
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void doCheck(Context ctx, StringBuilder srcIds, WriteBackFieldEnum fieldEnum) throws BOSException, SQLException, ArApCommonException {
        String fieldName;
        String srcIdStr = srcIds.substring(0, srcIds.length() - 1);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_AP_PAYREQUESTBILL BILL").append("\r\n");
        checkBuilder.append(" INNER JOIN T_AP_PAYREQUESTBILLENTRY entry ON BILL.FID = ENTRY.FPARENTID").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN (").append(srcIdStr).append(")").append("\r\n");
        if (fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT)) {
            checkBuilder.append(" AND ENTRY.FLOCKAMOUNT * ENTRY.FUNLOCKAMOUNT < 0").append("\r\n");
        } else {
            checkBuilder.append(" AND ENTRY.FAUDITAMOUNT * ENTRY.FUNPAYAMOUNT < 0").append("\r\n");
        }
        String keySuffix = fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT) ? ".writeBackBillLockAmt.checkSql" : ".writeBackBillPayAmt.checkSql";
        String recordKey = this.getClass() + keySuffix;
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), srcIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        String billType = this.getResource("PAY_REQ_BILL");
        String string = fieldName = fieldEnum.equals((Object)WriteBackFieldEnum.LOCK_AMT) ? this.getResource("UN_LOCK_AMT") : this.getResource("UN_PAY_AMT");
        if (exceptionNum.length() > 0) {
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }

    protected Map<String, BigDecimal> getLocalAmt(Context ctx, Map<String, BigDecimal> srcAmtMap, BizActionEnum bizAction) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> locAmtMap = new HashMap<String, BigDecimal>();
        PayRequestBillEntryCollection srcEntryColl = this.getSrcEntryColl(ctx, srcAmtMap);
        if (null == srcEntryColl || srcEntryColl.size() == 0) {
            return locAmtMap;
        }
        Iterator payReqBillEntryCollIte = srcEntryColl.iterator();
        PayRequestBillEntryInfo payReqEntryInfo = null;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountLoc = BigDecimal.ZERO;
        String entryId = null;
        while (payReqBillEntryCollIte.hasNext()) {
            payReqEntryInfo = (PayRequestBillEntryInfo)payReqBillEntryCollIte.next();
            entryId = payReqEntryInfo.getId().toString();
            amount = srcAmtMap.get(entryId);
            if (null == amount) continue;
            amountLoc = this.calculateLocAmt(ctx, bizAction, payReqEntryInfo, amount);
            locAmtMap.put(entryId, amountLoc);
        }
        return locAmtMap;
    }

    protected BigDecimal calculateLocAmt(Context ctx, BizActionEnum bizAction, PayRequestBillEntryInfo payReqEntryInfo, BigDecimal amount) throws EASBizException, BOSException {
        boolean isDirectExchangeRate = true;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        int precision = 2;
        BigDecimal amountLoc = BigDecimal.ZERO;
        if (amount.compareTo(payReqEntryInfo.getAuditAmount()) == 0) {
            amountLoc = payReqEntryInfo.getAuditAmountLoc();
        } else if (bizAction.equals((Object)BizActionEnum.CANCEL_PAY) && amount.compareTo(payReqEntryInfo.getLockAmount()) == 0) {
            amountLoc = payReqEntryInfo.getLockAmountLoc();
        } else if (bizAction.equals((Object)BizActionEnum.PAY) && amount.compareTo(payReqEntryInfo.getUnLockAmount()) == 0) {
            amountLoc = payReqEntryInfo.getUnLockAmountLoc();
        } else {
            isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(BaseDataUtil.getExchangeRate(ctx, payReqEntryInfo.getParent().getCompany(), payReqEntryInfo.getParent().getCurrency(), payReqEntryInfo.getParent().getBizDate()));
            exchangeRate = payReqEntryInfo.getParent().getExchange_rate();
            precision = payReqEntryInfo.getParent().getCompany().getBaseCurrency().getPrecision();
            amountLoc = BaseDataUtil.caculateLocalAmount(amount, exchangeRate, isDirectExchangeRate, precision);
        }
        return amountLoc;
    }

    protected PayRequestBillEntryCollection getSrcEntryColl(Context ctx, Map<String, BigDecimal> srcAmtMap) throws BOSException {
        IPayRequestBillEntry iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.getSelector().add(new SelectorItemInfo("id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.exchange_rate"));
        entryView.getSelector().add(new SelectorItemInfo("parent.currency.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.company.id"));
        entryView.getSelector().add(new SelectorItemInfo("parent.company.baseCurrency.precision"));
        entryView.getSelector().add(new SelectorItemInfo("parent.bizDate"));
        entryView.getSelector().add(new SelectorItemInfo("lockAmount"));
        entryView.getSelector().add(new SelectorItemInfo("lockAmountLoc"));
        entryView.getSelector().add(new SelectorItemInfo("unLockAmount"));
        entryView.getSelector().add(new SelectorItemInfo("unLockAmountLoc"));
        entryView.getSelector().add(new SelectorItemInfo("auditAmount"));
        entryView.getSelector().add(new SelectorItemInfo("auditAmountLoc"));
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", srcAmtMap.keySet(), CompareType.INCLUDE));
        entryView.setFilter(entryFilter);
        PayRequestBillEntryCollection srcEntryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(entryView);
        return srcEntryColl;
    }
}

