/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Refund4PurOrderHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4PurOrderHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo) {
            return;
        }
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            this.writeBackEntryPrePayAmt(ctx, bizAction, destBillInfo);
            this.writeBackBillPrePayAmt(ctx, bizAction, destBillInfo);
        }
    }

    private void writeBackEntryPrePayAmt(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder srcIds = this.getWriteBackParam(ctx, bizAction, destBillInfo, paramList);
        if (0 == paramList.size()) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList);
        boolean allowed = this.getCheckParamValue(ctx, destBillInfo);
        if (!allowed) {
            this.doCheck(ctx, srcIds);
        }
    }

    private void writeBackBillPrePayAmt(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT distinct blueEntry.FCOREBILLID as SRCBILLID").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY redEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY blueEntry").append("\r\n");
        selectBuilder.append(" ON redEntry.FSOURCEBILLENTRYID = blueEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE redEntry.FPAYMENTBILLID = ?").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurOrderBillPrePayAmt.selectSql";
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String srcBillId = null;
        while (rowSet.next()) {
            srcBillId = rowSet.getString("SRCBILLID");
            if (StringUtils.isEmpty((String)srcBillId)) continue;
            paramList.add(new Object[]{srcBillId, srcBillId});
        }
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append(" update T_SM_PurOrder po set (FUnPrepaidAmount, fPrepaid)=").append("\r\n");
        updateBuilder.append(" (select t.FUnPrepaidAmount, t.fPrepaid ").append("\r\n");
        updateBuilder.append(" FROM (select poe.FParentID fid, sum(ISNULL(poe.FUnPrereceivedAm,0)) AS FUnPrepaidAmount,").append("\r\n");
        updateBuilder.append(" sum(ISNULL(poe.FPreReceived,0)) AS fPrepaid ").append("\r\n");
        updateBuilder.append(" from T_SM_PurOrderEntry poe").append("\r\n");
        updateBuilder.append(" where poe.FParentID= ? GROUP BY poe.FParentID) AS t").append("\r\n");
        updateBuilder.append(" where t.fid = po.fid ) ").append("\r\n");
        updateBuilder.append(" where po.fid = ? ");
        recordKey = this.getClass() + ".writeBackPurOrderEntryPrePayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected StringBuilder getWriteBackParam(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo, List<Object[]> paramList) throws BOSException, SQLException, EASBizException {
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT blueEntry.FCOREBILLENTRYID as SRCID").append("\r\n");
        selectBuilder.append(" \t,sum(redEntry.FAMOUNT) as AMOUNT").append("\r\n");
        selectBuilder.append(" \t,sum(redEntry.FLOCALAMOUNT) as AMOUNTLOC").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY redEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY blueEntry").append("\r\n");
        selectBuilder.append(" ON redEntry.FSOURCEBILLENTRYID = blueEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE redEntry.FPAYMENTBILLID = ?").append("\r\n");
        selectBuilder.append(" GROUP BY blueEntry.FCOREBILLENTRYID").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurOrderEntryPrePayAmt.selectSql";
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        BigDecimal thisAmt = BigDecimal.ZERO;
        String srcId = "";
        StringBuilder srcIds = new StringBuilder(200);
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT").negate();
            srcId = rowSet.getString("SRCID");
            paramList.add(new Object[]{thisAmt, thisAmt, srcId});
            srcIds.append("'").append(srcId).append("'").append(",");
            srcAmtMap.put(srcId, thisAmt);
        }
        return srcIds;
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList) throws BOSException {
        String payAmtSymbol = BizActionEnum.PAY.equals((Object)bizAction) ? "-" : "+";
        String unPayAmtSymbol = BizActionEnum.PAY.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append("UPDATE T_SM_PurOrderEntry").append("\r\n");
        updateBuilder.append(" SET FUnPrereceivedAm = FUnPrereceivedAm ").append(unPayAmtSymbol).append(" ?").append("\r\n");
        updateBuilder.append("\t,FPreReceived = FPreReceived ").append(payAmtSymbol).append(" ?").append("\r\n");
        updateBuilder.append(" WHERE FID = ?").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurOrderEntryPrePayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void doCheck(Context ctx, StringBuilder srcIds) throws BOSException, SQLException, ArApCommonException {
        String srcIdStr = srcIds.substring(0, srcIds.length() - 1);
        String checkField = "ENTRY.FUnPrereceivedAm";
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_SM_PURORDER BILL").append("\r\n");
        checkBuilder.append(" INNER JOIN T_SM_PURORDERENTRY entry ON BILL.FID = ENTRY.FPARENTID").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN (").append(srcIdStr).append(")").append("\r\n");
        checkBuilder.append(" AND ENTRY.FTAXAMOUNT * ").append(checkField).append(" < 0").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurOrderEntryPrePayAmt.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), srcIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        String billType = this.getResource("PUR_ORDER_BILL");
        String fieldName = this.getResource("UN_PRE_PAID_AMT");
        if (exceptionNum.length() > 0) {
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }
}

